-- Copyright 2015 Amazon.com, Inc. or its affiliates. All Rights Reserved.

local FocusForwarder = class(function(self)
	self._visitedNodeSet = {}
end)

function FocusForwarder:getTarget(currentNode)
	local nodeForFocusForwarding = self:_recursiveGetTarget(currentNode)
	self._visitedNodeSet = {}
	return nodeForFocusForwarding
end

function FocusForwarder:_recursiveGetTarget(currentNode)
	local nodeForFocusForwarding = nil

	local currentNodeId = currentNode:getId()
	self:_checkIfAlreadyVisited(currentNodeId)

	local focusedView = context:getNodesRegistry():getViewElement(currentNodeId)
	if focusedView then
		local focusForwardedNode = focusedView:getFocusForwardedNode()
		if focusForwardedNode then
			if focusForwardedNode:getFocusable() then
				nodeForFocusForwarding = focusForwardedNode
			else
				nodeForFocusForwarding =
						self:_recursiveGetTarget(focusForwardedNode)
			end
		else
			log.warn("A non-focusable item (id: " .. currentNode:getId() ..
					") of type '" .. (currentNode.typeName or "[unknown]") ..
					"' was focused with no node provided to handle focus " ..
					"forwarding")
		end
	end

	return nodeForFocusForwarding
end

function FocusForwarder:_checkIfAlreadyVisited(nodeId)
	if self._visitedNodeSet[nodeId]then
		error("Focus forwarding recursion loop detected at node with ID " ..
				nodeId ..	". Exiting before recursion limit is reached.")
	else
		self._visitedNodeSet[nodeId] = true
	end
end

return FocusForwarder
