/* Copyright 2013 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_DISPLAY_PLUGIN_DISPLAY_H_
#define PLUGIN_DISPLAY_PLUGIN_DISPLAY_H_

#include "IDisplay.h"
#include <Atomic.h>

namespace ignition
{
namespace deviceinfo
{
class IDeviceInfo;
}

namespace display
{
class PlatformContext;

class PluginDisplay : public IDisplay
{
public:

	PluginDisplay();
	virtual ~PluginDisplay();

	void satisfyDependencies(IPlugin::DependencyMap dependencies);
	void start();
	void tick();
	void stop();
	void enterBackground();
	void enterForeground();

	void release();
	void present();

	unsigned int getWidth() const;
	unsigned int getHeight() const;

	void* getFunctionAddress(const char*) const;
	void* getExtensionFunctionAddress(const char*) const;

	bool createContext();
	bool releaseContext();

protected:
	void _registerCommandLineOptions();
	void _setupDisplayDimensions();
	void _initialize();

	deviceinfo::IDeviceInfo* _deviceInfo;

	PlatformContext* _platformContext;
	core::atomic<bool> _inBackground;
	core::atomic<bool> _initialized;

	uint32_t _width;
	uint32_t _height;
};

} // namespace display
} // namespace ignition

#endif // PLUGIN_DISPLAY_PLUGIN_DISPLAY_H_
