/* Copyright 2013 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_DISPLAY_IDISPLAY_H_
#define PLUGIN_DISPLAY_IDISPLAY_H_

#include <plugin/IPlugin.h>

namespace ignition
{
namespace display
{

typedef unsigned int DisplayHandle;

class IDisplay : public core::plugin::IPlugin
{
	REGISTER_PLUGIN_NAME(com.amazon.ignition.framework.display);

public:

	IDisplay() {}
	virtual ~IDisplay() {}

	virtual void present() = 0;

	virtual unsigned int getWidth() const = 0;
	virtual unsigned int getHeight() const = 0;

	virtual void* getFunctionAddress(const char*) const = 0;
	virtual void* getExtensionFunctionAddress(const char*) const = 0;

	virtual bool createContext() = 0;
	virtual bool releaseContext() = 0;

};

} // namespace display
} // namespace ignition

#endif // PLUGIN_DISPLAY_IDISPLAY_H_
