/* Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_DEVICEINFO_DEVICEINFO_IDENTITY_I_SERIAL_NUMBER_PROVIDER_H_
#define PLUGIN_DEVICEINFO_DEVICEINFO_IDENTITY_I_SERIAL_NUMBER_PROVIDER_H_

#include <SmartPointers.h>
#include <string>

namespace ignition
{
namespace deviceinfo
{
namespace identity
{

class ISerialNumberProvider;
typedef core::memory::SharedPtr<ISerialNumberProvider> ISerialNumberProviderPtr;

class ISerialNumberProvider
{
public:
	virtual ~ISerialNumberProvider() {};
	virtual std::string getSerialNumber() = 0;
};

} // namespace identity
} // namespace deviceinfo
} // namespace ignition

#endif // PLUGIN_DEVICEINFO_DEVICEINFO_IDENTITY_I_SERIAL_NUMBER_PROVIDER_H_
