/* Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_DEVICEINFO_DEVICEINFO_IDENTITY_I_DEVICE_TYPE_PROVIDER_H_
#define PLUGIN_DEVICEINFO_DEVICEINFO_IDENTITY_I_DEVICE_TYPE_PROVIDER_H_

#include <SmartPointers.h>
#include <string>

namespace ignition
{
namespace deviceinfo
{
namespace identity
{

class IDeviceTypeProvider;
typedef core::memory::SharedPtr<IDeviceTypeProvider> IDeviceTypeProviderPtr;

class IDeviceTypeProvider
{
public:
	virtual ~IDeviceTypeProvider() {};
	virtual std::string getTypeId() = 0;
	virtual std::string getTypeName() = 0;

};

} // namespace identity
} // namespace deviceinfo
} // namespace ignition

#endif // PLUGIN_DEVICEINFO_DEVICEINFO_IDENTITY_I_DEVICE_TYPE_PROVIDER_H_
