/* Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_DEVICEINFO_DEVICEINFO_BINDINGS_LUA_FFI_DEVICE_IDENTITY_LUA_BINDING_H_
#define PLUGIN_DEVICEINFO_DEVICEINFO_BINDINGS_LUA_FFI_DEVICE_IDENTITY_LUA_BINDING_H_

#include <ffi/LuaFFIUserData.h>
#include <deviceinfo/identity/DeviceIdentity.h>
#include <deviceinfo/bindings/lua/ffi/NamespaceAliases.h>
#include <bindings/types/LuaReflectableValueBinding.h>

namespace ignition
{

CREATE_FFI_USER_DATA(DeviceIdentity, deviceinfo);

namespace deviceinfo
{

extern "C"
{

/* @begin_ffi_externs */

typedef struct DeviceIdentityUserData
	DeviceIdentityUserData;

typedef struct ReflectableValueUserData
	ReflectableValueUserData;

ReflectableValueUserData* deviceinfo_DeviceIdentity_getSerialNumber();
ReflectableValueUserData* deviceinfo_DeviceIdentity_getDeviceTypeId();
ReflectableValueUserData* deviceinfo_DeviceIdentity_getDeviceTypeName();
ReflectableValueUserData* deviceinfo_DeviceIdentity_getDeviceChipset();

/* @end_ffi_externs */

} // extern "C"
} // namespace deviceinfo
} // namespace ignition

#endif // PLUGIN_DEVICEINFO_DEVICEINFO_BINDINGS_LUA_FFI_DEVICE_IDENTITY_LUA_BINDING_H_
