/* Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_DEVICEINFO_BINDINGS_LUA_LUA_DEVICEINFO_BINDING_H_
#define PLUGIN_DEVICEINFO_BINDINGS_LUA_LUA_DEVICEINFO_BINDING_H_

#include <extensions/LuaExtension.h>
#include <ffi/LuaFFILibWrapper.h>
#include <utils/LuaRegistryRef.h>
#include <DataStructures.h>

namespace ignition
{

namespace lua
{
class IMetatabledClassInstance;
}

namespace deviceinfo
{
namespace bindings
{
namespace lua
{

class LuaDeviceInfoBinding : public ignition::lua::LuaExtension
{
	LUA_EXTENSION(LuaDeviceInfoBinding);

public:
	LuaDeviceInfoBinding(ignition::lua::LuaState* state);
	virtual ~LuaDeviceInfoBinding();

	ignition::lua::LuaState* getLuaState();
	ignition::lua::LuaFFILibWrapper* getLibWrapper();

private:
	void _addFfiBindings();
	void _removeFfiBindings();

	core::vector<std::string> _getFfiBindingNames();

	void _bindClass(const std::string& className);

	void _applyApiAugmentation();
	void _removeApiAugmentation();
	void _doExtensionScript(const std::string& script);

	ignition::lua::LuaFFILibWrapper _libWrapper;

	bool _isBound;
};

} // namespace lua
} // namespace deviceinfo
} // namespace network
} // namespace ignition

#endif // PLUGIN_DEVICEINFO_BINDINGS_LUA_LUA_DEVICEINFO_BINDING_H_
