/* Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_DEVICEINFO_EXTERNAL_DEVICEINFO_I_DEVICEINFO_H_
#define PLUGIN_DEVICEINFO_EXTERNAL_DEVICEINFO_I_DEVICEINFO_H_

#include <plugin/IPlugin.h>
#include "deviceinfo/properties/AbstractDeviceProperties.h"

namespace ignition
{
namespace deviceinfo
{

class IDeviceInfo : public core::plugin::IPlugin
{
	REGISTER_PLUGIN_NAME(com.amazon.ignition.framework.deviceinfo);

public:
	IDeviceInfo(){}
	virtual ~IDeviceInfo() {};

	virtual DevicePropertiesPtr getDeviceProperties() const = 0;
};

} // namespace deviceinfo
} // namespace ignition

#endif // PLUGIN_DEVICEINFO_EXTERNAL_DEVICEINFO_I_DEVICEINFO_H_
