-- Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved.

--[[
-- Applies Device Info Binding Extension Augmentations
--]]
return function ()
	local _ffi = require('ffi')
	
	-- Alias the DeviceIdentity metatable as a member of the global table
	-- for the convienience.
	_G.deviceinfo = getMetatable('DeviceIdentityUserData')
	
	-- Helper method to unwrap reflectable the reflectable values returned by 
	-- certain identity API calls. There is no need for the extra layer of 
	-- indirection here
	function unwrapValueOrThrow(ns, name)
		local fn = ns[name]
		ns[name] = function(...) 
			local value = fn(...);
			if value:isEmpty() then
				error("Empty ReflectableValue returned after calling " .. name)
			end
			return value:get()
		end
	end

	unwrapValueOrThrow(_G.deviceinfo, 'getSerialNumber')
	unwrapValueOrThrow(_G.deviceinfo, 'getDeviceTypeId')
	unwrapValueOrThrow(_G.deviceinfo, 'getDeviceTypeName')
	unwrapValueOrThrow(_G.deviceinfo, 'getDeviceChipset')
end
