/* Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_DEVICEINFO_DEVICEINFO_IDENTITY_DEVICE_IDENTITY_H_
#define PLUGIN_DEVICEINFO_DEVICEINFO_IDENTITY_DEVICE_IDENTITY_H_

#include "deviceinfo/identity/IDeviceTypeProvider.h"
#include "deviceinfo/identity/ISerialNumberProvider.h"
#include "deviceinfo/properties/AbstractDeviceProperties.h"

#include "SmartPointers.h"

namespace ignition
{
namespace deviceinfo
{
namespace identity
{

class DeviceIdentity;
typedef core::memory::SharedPtr<DeviceIdentity> DeviceIdentityPtr;

class DeviceIdentity
{
public:
	static DeviceIdentityPtr getInstance();
	static void setInstance(DeviceIdentityPtr instance);

	DeviceIdentity();
	~DeviceIdentity();

	void setDeviceTypeProvider(IDeviceTypeProviderPtr provider);
	void setDeviceSerialNumberProvider(ISerialNumberProviderPtr provider);
	void setDeviceProperties(const DevicePropertiesPtr& deviceProperties);

	IDeviceTypeProviderPtr getDeviceTypeProvider();
	ISerialNumberProviderPtr getSerialNumberProvider();
	DevicePropertiesPtr getDeviceProperties();

private:
	static DeviceIdentityPtr _createDefaultInstance();

	static DeviceIdentityPtr _instance;

	IDeviceTypeProviderPtr _deviceTypeProvider;
	ISerialNumberProviderPtr _serialNumberProvider;
	DevicePropertiesPtr _deviceProperties;
};

} // namespace identity
} // namespace deviceinfo
} // namespace ignition

#endif // PLUGIN_DEVICEINFO_DEVICEINFO_IDENTITY_DEVICE_IDENTITY_H_
