/* Copyright 2014-2016 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_DEVICEINFO_DEVICEINFO_BINDINGS_SM_DEVICE_INFO_EXTENSION_H_
#define PLUGIN_DEVICEINFO_DEVICEINFO_BINDINGS_SM_DEVICE_INFO_EXTENSION_H_

#include "PluginDeviceInfoBindingsIncludes.h"
#include "deviceinfo/properties/AbstractDeviceProperties.h"
#include "sm/Extension.h"

namespace ignition
{
namespace deviceinfo
{
namespace bindings
{
namespace sm
{

class DeviceInfoExtension : public javascript::sm::Extension
{
public:
	DeviceInfoExtension(
			javascript::sm::SpiderMonkeyEnvironment* env,
			const DevicePropertiesPtr& deviceProperties = DevicePropertiesPtr());

	std::string getSerialNumber();
	std::string getDeviceTypeId();
	std::string getDeviceTypeName();

	std::string getDeviceChipset();
	std::string getFirmwareVersion();
	std::string getModelName();
	DeviceMode getDeviceMode();
	std::string getManufacturer();
	std::string getPlatformPackageVersion();

	bool supportsUHD();
	bool supportsHDR();
	bool supportsDolbyVisionHDR();
	bool supportsHEVC();
	bool hasExternalOutput();
	bool hasPlatformVideoNode();

	int getPanelWidth();
	int getPanelHeight();
	int getDisplayWidth();
	int getDisplayHeight();

	std::string getDeviceLanguage();
	core::ReflectableValue getPlatformProperty(const std::string& key);
	core::vector<std::string> getPlatformPropertyKeys();

protected:
	DevicePropertiesPtr _deviceProperties;

};

} // namespace sm
} // namespace bindings
} // namespace deviceinfo
} // namespace ignition

#endif // PLUGIN_DEVICEINFO_DEVICEINFO_BINDINGS_SM_DEVICE_INFO_EXTENSION_H_
