/* Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_CRYPTO_INTERNAL_CRYPTO_SIGNING_VALIDATION_FACILITY_H_
#define PLUGIN_CRYPTO_INTERNAL_CRYPTO_SIGNING_VALIDATION_FACILITY_H_

#include <crypto/CryptoTypes.h>
#include <crypto/signing/SigningStatus.h>

namespace ignition
{
namespace crypto
{
namespace signing
{

class PLUGINCRYPTO_API ValidationFacility
{
public:
	enum SignatureLocation
	{
		FRONT_SIGNED_BINARY,
		END_SIGNED_BASE64
	};

	ValidationFacility(SignatureLocation signatureLocation,
			const AuthorityContext& authCtx = DEFAULT_AUTHORITY_CONTEXT);
	~ValidationFacility();

	SigningStatus validate(InStream& stream);

	void setCertificateProviderCallback(CertificateStringCallback);
	bool hasCertificateProviderCallback();

protected:
	CertificateStringCallback _certificateCallback;
	AuthorityContext _authorityContext;
	SignatureLocation _signatureLocation;
};

} // namespace signing
} // namespace crypto
} // namespace ignition

#endif // PLUGIN_CRYPTO_INTERNAL_CRYPTO_SIGNING_VALIDATION_FACILITY_H_
