/* Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_CRYPTO_EXTERNAL_CRYPTO_SIGNING_SIGNING_STATUS_H_
#define PLUGIN_CRYPTO_EXTERNAL_CRYPTO_SIGNING_SIGNING_STATUS_H_

#include <istream>

namespace ignition
{
namespace crypto
{
namespace signing
{

enum SigningStatus
{
	SIGNING_STATUS_UNKNOWN,
	SIGNING_STATUS_VALID,
	SIGNING_STATUS_INVALID,

	SIGNING_STATUS_BAD_PACKAGE_VERSION,
	SIGNING_STATUS_BAD_STREAM,
	SIGNING_STATUS_BAD_CERTIFICATE,
	SIGNING_STATUS_UNRESOLVED_AUTHORITY,
	SIGNING_STATUS_INTERNAL_FAILURE,

	SIGNING_STATUS_MAX
};

} // namespace signing
} // namespace crypto
} // namespace ignition

#endif // PLUGIN_CRYPTO_EXTERNAL_CRYPTO_SIGNING_SIGNING_STATUS_H_
