/* Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_CRYPTO_EXTERNAL_CRYPTO_SHA_HASHER_H_
#define PLUGIN_CRYPTO_EXTERNAL_CRYPTO_SHA_HASHER_H_

#include <crypto/CryptoTypes.h>
#include <CryptoConfig.h>

namespace ignition
{
namespace crypto
{
namespace hash
{

class PLUGINCRYPTO_API SHAHasherBase
{
public:
	virtual ~SHAHasherBase();

	bool update(const char* buffer, size_t size);
	bool update(Buffer& buffer, size_t size, size_t from = 0);
	bool update(InStream& stream);
	bool update(Buffer::iterator begin, Buffer::iterator end);

	size_t getDigestLength();

	bool finalise(Buffer& out);
	bool isReady();

	static const size_t READ_BUFFER_MAX;

	class ISHAHasherInternal;
protected:
	friend class SHAHasherImpl;
	ISHAHasherInternal* _hasher;
};

class SHA512Hasher : public SHAHasherBase
{
public:
	SHA512Hasher();
};

class SHA256Hasher : public SHAHasherBase
{
public:
	SHA256Hasher();
};

class SHA1Hasher : public SHAHasherBase
{
public:
	SHA1Hasher();
};

PLUGINCRYPTO_API bool SHA1HashStream(InStream& in, Buffer& out);
PLUGINCRYPTO_API bool SHA256HashStream(InStream& in, Buffer& out);
PLUGINCRYPTO_API bool SHA512HashStream(InStream& in, Buffer& out);

} // namespace hash
} // namespace crypto
} // namespace ignition

#endif // PLUGIN_CRYPTO_EXTERNAL_CRYPTO_SHA_HASHER_H_
