/* Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_CRYPTO_INTERNAL_CRYPTO_SIGNING_VALIDATION_FACILITY_FACTORY_H_
#define PLUGIN_CRYPTO_INTERNAL_CRYPTO_SIGNING_VALIDATION_FACILITY_FACTORY_H_

#include <crypto/CryptoTypes.h>
#include <crypto/signing/SigningStatus.h>
#include <crypto/signing/ValidationFacility.h>

namespace ignition
{
namespace crypto
{
namespace signing
{

class ValidationFacilityFactory
{
public:
	static ValidationFacilityFactory& get();

	virtual ValidationFacility create(
		ValidationFacility::SignatureLocation signatureLocation,
		const AuthorityContext& authContext = DEFAULT_AUTHORITY_CONTEXT);

	virtual ~ValidationFacilityFactory();

protected:
	ValidationFacilityFactory();
};

} // namespace signing
} // namespace crypto
} // namespace ignition

#endif // PLUGIN_CRYPTO_INTERNAL_CRYPTO_SIGNING_VALIDATION_FACILITY_FACTORY_H_
