/* Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_CRYPTO_EXTERNAL_CERIFICATE_CERTIFICATE_SERVICE_H_
#define PLUGIN_CRYPTO_EXTERNAL_CERIFICATE_CERTIFICATE_SERVICE_H_

#include <service/Service.h>
#include <DataStructures.h>
#include <core/thread/Mutex.h>
#include <crypto/CryptoTypes.h>
#include <CryptoConfig.h>

namespace ignition
{
namespace crypto
{
namespace certificate
{

class PLUGINCRYPTO_API CertificateService : public core::Service
{
public:
	struct Certificate
	{
		enum Type
		{
			TYPE_FILE,
			TYPE_STRING
		};

		Type type;
		std::string value;
	};

	typedef core::map<std::string, Certificate> CertificateMap;
	typedef core::map<AuthorityContext, CertificateMap> AuthorityContextMap;

	static const std::string SERVICE_NAME;

	static CertificateService& get();

	CertificateService(const std::string& name,
			core::ServiceManager* serviceManager = &core::ServiceManager::Get());
	virtual ~CertificateService();

	bool hasCertificate(
			const AuthorityContext& context,
			const std::string& name);

	const Certificate& getCertificate(
			const AuthorityContext& context,
			const std::string& name);

	void setCertificate(
			const AuthorityContext& context,
			const std::string& name,
			const Certificate& certificate);

	void unsetCertificate(
			const AuthorityContext& context,
			const std::string& name);

	void flushCertificates();

	CertificateStringCallback getCertificateStringCallback();

	bool start();
	bool stop();
	bool isRunning();

protected:
	bool _getCertificateString(
			const std::string& name,
			const AuthorityContext& context,
			std::string& out);

	bool _hasCertificate(
			const AuthorityContext& context,
			const std::string& name);

	const Certificate& _getCertificate(
			const AuthorityContext& context,
			const std::string& name);

	CertificateStringCallback _certificateStringCallback;
	core::thread::Mutex _mutex;
	AuthorityContextMap _authorityContextMap;
	bool _isRunning;
};

} // namespace certificate
} // namespace crypto
} // namespace ignition

#endif // PLUGIN_CRYPTO_EXTERNAL_CERIFICATE_CERTIFICATE_SERVICE_H_
