/* Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_CRYPTO_EXTERNAL_CRYPTO_CRYPTO_TYPES_H_
#define PLUGIN_CRYPTO_EXTERNAL_CRYPTO_CRYPTO_TYPES_H_

#include <vector>
#include <istream>

#include <Function.h>
#include <CryptoConfig.h>
#include <crypto/HashedString.h>

namespace ignition
{
namespace crypto
{

typedef std::istream InStream;
typedef std::ostream OutStream;

typedef std::streampos StreamPosition;
typedef std::streamoff StreamOffset;
typedef std::streamsize StreamSize;

typedef std::vector<InStream::char_type> Buffer;

typedef crypto::HashedString AuthorityContext;

typedef core::function<bool(
		const std::string&, const AuthorityContext&, std::string&)>
		CertificateStringCallback;

const AuthorityContext DEFAULT_AUTHORITY_CONTEXT = "DEFAULT_AUTHORITY_CONTEXT";

} // namespace crypto
} // namespace ignition

#endif // PLUGIN_CRYPTO_EXTERNAL_CRYPTO_CRYPTO_TYPES_H_
