/* Copyright 2015 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef IGNITION_ANIMATION_InterpolatorLUABINDING_H_
#define IGNITION_ANIMATION_InterpolatorLUABINDING_H_

#include "interpolation/IInterpolator.h"

#include "ffi/LuaFFIUserData.h"
#include "AnimationConfig.h"

namespace ignition
{

using namespace lua;

CREATE_FFI_USER_DATA(IInterpolator, animation);

namespace animation
{
extern "C"
{

/* @begin_ffi_externs */

typedef struct IInterpolatorUserData IInterpolatorUserData;

PLUGINANIMATION_API uint32_t animation_IInterpolator_getFunctionByName(
		IInterpolatorUserData*, const char*);

PLUGINANIMATION_API bool animation_IInterpolator_hasFunction(
		IInterpolatorUserData*, const char*);

PLUGINANIMATION_API bool animation_IInterpolator_loadFunction(
		IInterpolatorUserData*, const char*);

PLUGINANIMATION_API bool animation_IInterpolator_unloadFunction(
		IInterpolatorUserData*, const char*);

/* @end_ffi_externs */

} /* extern "C" */
} /* namespace core */
} /* namespace ignition */

#endif /* IGNITION_ANIMATION_IInterpolatorLUABINDING_H_ */
