/* Copyright 2013 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef IGNITION_ANIMATION_AnimationSequencerLUABINDING_H_
#define IGNITION_ANIMATION_AnimationSequencerLUABINDING_H_

#include "animators/AnimationSequencer.h"
#include <scene/nodes/SceneNodeLuaBinding.h>
#include <bindings/types/LuaReflectableValueBinding.h>
#include <bindings/types/LuaVec4Binding.h>

#include "ffi/LuaFFIUserData.h"
#include "AnimationConfig.h"

namespace ignition
{

using namespace scene;
using namespace core;
using namespace lua;

CREATE_FFI_USER_DATA(AnimationSequencer, animation);

namespace animation
{
extern "C"
{

/* @begin_ffi_externs */

typedef struct AnimationSequencerUserData AnimationSequencerUserData;
typedef struct ReflectableValueUserData ReflectableValueUserData;

PLUGINANIMATION_API uint32_t animation_AnimationSequencer_queueFixedDuration(
		AnimationSequencerUserData*,
		SceneNodeUserData*,
		const char*,
		ReflectableValueUserData* from,
		ReflectableValueUserData* to,
		uint32_t duration,
		LuaVec4 parameters,
		uint32_t interpolationType,
		uint32_t repetitions);

PLUGINANIMATION_API uint32_t animation_AnimationSequencer_queueContinuous(
		AnimationSequencerUserData*,
		SceneNodeUserData*,
		const char*,
		ReflectableValueUserData* initialSpeed,
		ReflectableValueUserData* maxSpeed,
		double accelerationDuration);

PLUGINANIMATION_API void animation_AnimationSequencer_stop(
		AnimationSequencerUserData*,
		SceneNodeUserData*,
		const char*,
		ReflectableValueUserData* target,
		bool stopImmediately);

PLUGINANIMATION_API void animation_AnimationSequencer_clear(
		AnimationSequencerUserData*,
		SceneNodeUserData*,
		const char*);

PLUGINANIMATION_API uint32_t animation_AnimationSequencer_length(
		AnimationSequencerUserData*,
		SceneNodeUserData*,
		const char*);

/* @end_ffi_externs */

} /* extern "C" */
} /* namespace core */
} /* namespace ignition */

#endif /* IGNITION_ANIMATION_AnimationSequencerLUABINDING_H_ */
