/**
 * Copyright 2016 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 */

(function ()
{
	log.info("Launching Blast");

	font.appendSearchPath(plugins.resolvePath("static://com.amazon.ignition.app.stark/assets/fonts"));

	global.appLoadMetrics = {};
	global.appLoadMetrics.requests = {};
	global.appLoadMetrics.includes = {};
	global.appLoadMetrics.appStartupTime = metrics.getNowTimestamp();

	function require(file)
	{
		var oldModule = global.module;
		var oldRequire = global.require;
		global.module = {exports: {}};
		global.require = require;
		include(file);
		var exports = global.module.exports;
		global.module = oldModule;
		global.require = oldRequire;
		return exports;
	}

	var commandLineArgs = global.commandLine && global.commandLine.args || {};
	global.deviceAffinity = (require("./deviceAffinity.js")).calculateDeviceAffinity(
			global.deviceinfo, global.plugins, commandLineArgs);

	var options = require('./config.js')();
	var createStateManager = require('./stateManager.js');

	var stateManager = createStateManager(options);
	stateManager.start();

}());
