/**
 * Copyright 2016 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 */

(function()
{
	function SplashScreenManager()
	{
		this.showDelay = 100;
		this.hideDelay = 300;
		this.showing = true;
		this.timer = null;
	}

	SplashScreenManager.prototype.show = function()
	{
		if (!this.showing)
		{
			if (this.timer)
			{
				clearTimeout(this.timer);
				this.timer = null;
			}
			renderer.showSplashScreen(this.showDelay);
			this.showing = true;
		}
	};

	SplashScreenManager.prototype.hide = function(fn)
	{
		if (this.showing)
		{
			renderer.dismissSplashScreen(this.hideDelay);
			if (fn)
			{
				this.timer = setTimeout(function()
				{
					fn();
				}.bind(this), this.hideDelay);
			}
			this.showing = false;
		}
	};

	module.exports = SplashScreenManager;
}());
