/**
 * Copyright 2016 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 */

(function ()
{
	var getCommandLineArgument = require('./utils.js').getCommandLineArgument;


	function stringifyQueryString(qs)
	{
		return Object.keys(qs).map(function (key)
		{
			var value = qs[key];
			return key + '=' + value;
		}).join('&');
	}


	function appendQueryStringArgs(url)
	{
		var deviceId = deviceinfo.getSerialNumber();
		var deviceTypeID = getCommandLineArgument("deviceTypeID") || deviceinfo.getDeviceTypeId();

		// Optional paramaters:
		var blastClient = getCommandLineArgument("blastClient");
		var blastURL = getCommandLineArgument("blastURL");
		var atvEndpoint = getCommandLineArgument("atvEndpoint");

		var blastArguments = {
			deviceId: deviceId,
			deviceTypeID: deviceTypeID,
			firmware: '0'
		};

		// If there is already an URL parameter then don't add it again.
		Object.keys(blastArguments).forEach(function(key)
		{
			if (url.indexOf(key) !== -1)
			{
				delete blastArguments[key];
			}
		});

		if (blastClient)
		{
			blastArguments.blastClient = blastClient;
			blastArguments.allowURLOverride = false;
		}

		if (blastURL)
		{
			blastArguments.blastURL = blastURL;
		}

		if (atvEndpoint)
		{
			blastArguments.atvEndpoint = atvEndpoint;
		}

		var blastArgumentsAsString = stringifyQueryString(blastArguments);

		if (url.indexOf('?') === -1)
		{
			return url + '?' + blastArgumentsAsString;
		}
		else
		{
			return url + '&' + blastArgumentsAsString;
		}
	}

	function getFilenameFromUrl(url)
	{
		var start = url.lastIndexOf('/');
		var end = url.lastIndexOf('?');
		var filepath = url.slice(start, end < 0 ? url.length : end);
		return '.' + filepath;
	}

	function ConnectivityStateError(message)
	{
		this.name = 'ConnectivityStateError';
		this.message = (message || '');
	}

	ConnectivityStateError.prototype = Object.create(Error.prototype);

	module.exports = {
		stringifyQueryString: stringifyQueryString,
		appendQueryStringArgs: appendQueryStringArgs,
		ConnectivityStateError: ConnectivityStateError,
		getFilenameFromUrl: getFilenameFromUrl
	};
}());
