/**
 * Copyright 2016 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 */

(function ()
{
	var requestModule = require('./fetchFile.js');
	var requestWithRetries = requestModule.requestWithRetries;

	var GLOBAL_DEVICE_PROXY_PROTOCOL = 'https://';
	var GLOBAL_DEVICE_PROXY_HOST = '.api.amazonvideo.com';

	function fetchIndexJsWithRetries(options, cb, firstFailCb)
	{
		var affinity = global.deviceAffinity;

		var globalDeviceProxy = GLOBAL_DEVICE_PROXY_PROTOCOL + affinity + GLOBAL_DEVICE_PROXY_HOST;
		// For example: https://A71I8788P1ZV8-v6d5d2p3-1d0d0dlinux-LinuxUndefinedFirmware-Linux.api.amazonvideo.com

		var url = globalDeviceProxy + '/blast-app-hosting/ignition';

		var baseUrl = options.baseUrl
		if (baseUrl)
		{
			url = baseUrl;
		}

		url += '/index.js';

		var req = requestWithRetries({
			url: url,
			firstFailCb: firstFailCb,
			maxRetries: 3
		}, cb);

		return req;
	}

	module.exports = {
		fetchIndexJsWithRetries: fetchIndexJsWithRetries
	};

}());
