/**
 * Copyright 2016 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 */

(function()
{
	module.exports.calculateDeviceAffinity = function(deviceinfo, plugins, overrides) {
		overrides = overrides || {};

		// Set affinity:
		// See https://w.amazon.com/index.php/ATV/Mobile/Android/Docs/Engineering/AffinityUrlStructure#Affinity_URL

		// Not allowed dots in versions, but we need to tell between 6.52 and 65.2 ...
		var versionDelimiters = /[\.-]/g

		var deviceTypeId = overrides["deviceTypeID"] || deviceinfo.getDeviceTypeId() || "";
		var ignitionVersion = (plugins.getPackageVersion() || "").replace(versionDelimiters,'d');
		var platformPackageVersion = (deviceinfo.getPlatformPackageVersion() || "").replace(versionDelimiters,'d');

		// Priority order for affinity:
		var affinityComponents = [
				"ign",
				deviceTypeId,
				ignitionVersion,
				platformPackageVersion
		];

		// Stip non-dns-label-friendly chars. Reserve '-' for delimiter.
		var nonAlphaNum = /[^a-zA-Z0-9]+/g;

		var affinity = affinityComponents
				.map(str => str.replace(nonAlphaNum, ''))
				.map(str => (str ? str : "unknown"))
				.join('-')
				.substr(0, 63)  // Limit to max length of DNS label
				.toLowerCase();  // Case insensitive anyway.

		// https://en.wikipedia.org/wiki/Domain_Name_System#Domain_name_syntax

		return affinity;
	};
}());
