/**
 * Copyright 2016 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 */

(function ()
{
	var getCommandLineArgument = require('./utils.js').getCommandLineArgument;

	function overrideBlastHost(options)
	{
		var host = getCommandLineArgument('blastHost');

		if (host)
		{
			options.baseUrl = host;
		}
		return options;
	}

	function overrideClearStorage(options)
	{
		var clear = getCommandLineArgument('clearStorage');

		if (typeof clear === 'boolean')
		{
			options.clearStorage = clear;
		}

		return options;
	}

	function _filterByLocale(locale, options)
	{
		if (!locale)
		{
			return options;
		}

		// Filter specific locale properties
		var candidateLocale = options.errorMessageImages.filter(function (errorMessageImage)
		{
			return errorMessageImage.locale === locale;
		});

		// Replace only if there have been results after filtering.
		if (candidateLocale.length > 0)
		{
			options.errorMessageImages = candidateLocale;
		}

		return options;
	}

	function overrideLocale(options)
	{
		var locale = getCommandLineArgument('overrideLocale');

		return _filterByLocale(locale, options);
	}

	function loadLocale()
	{
		// TODO Implement proper locale loading when
		// https://issues.amazon.com/issues/IGN-1657 is ready.
		return null;
	}

	function loadConfig()
	{
		var config = null;
		try
		{
			config = include('config.json');
		}
		catch (e)
		{
			log.errorEvent('config', 'ConfigException', 'Error loading "config.json": ' + e + '. Falling back to default.');
			config = {
				"errorMessageImages": [{
					"locale": "us",
					"path": "static://com.amazon.ignition.app.stark/images/clientError_us.jpg"
				}]
			};
		}

		return config;
	}

	function loadOptions(locale, config)
	{
		return _filterByLocale(locale, config);
	}

	function getOptions ()
	{
		var options;
		var config = loadConfig();
		var locale = loadLocale();

		options = loadOptions(locale, config);

		// Command Line Arguments override all configuration
		options = overrideLocale(options);
		options = overrideClearStorage(options);
		options = overrideBlastHost(options);

		return options;
	}

	module.exports = getOptions;
}());
