//
// Copyright (C) 2008-2009 Panasonic Corporation. All Rights Reserved.
//

//add_package_load_path( "twc_util", path + "weather/twc_util.js");
//add_stage_load_path( "twc", path + "weather/twc.js");

(function(){
var twc = new Icon();
twc.name = "weather";

// [private]
twc.panel_src = path + "weather/weather-panel.png";
twc.TEXT = {
  "en-US" : {
    "WEATHER" : "Weather",
    "TONIGHT" : "TONIGHT",
    "TOMORROW" : "TOMORROW",
    "CITY_STATE" : "City, State",
    "HIGH" : "H",
    "LOW" : "L",
  },
  "es-US" : {
    "WEATHER" : "Tiempo",
    "TONIGHT" : "ESTA NOCHE",
    "TOMORROW" : "MAÑANA",
    "CITY_STATE" : "Ciudad, Estado",
    "HIGH" : "H",
    "LOW" : "L",
  },
  "fr-CA" : {
    "WEATHER" : "Météo",
    "TONIGHT" : "CE SOIR",
    "TOMORROW" : "DEMAIN",
    "CITY_STATE" : "Ville, Province",
    "HIGH" : "H",
    "LOW" : "L",
  },
  "en-GB" : {
    "WEATHER" : "Weather",
    "TONIGHT" : "TONIGHT",
    "TOMORROW" : "TOMORROW",
    "CITY_STATE" : "City, State",
    "HIGH" : "H",
    "LOW" : "L",
  },
  "hu-HU" : {
    "WEATHER" : "Időjárás",
    "TONIGHT" : "MA ESTE",
    "TOMORROW" : "HOLNAP",
    "CITY_STATE" : "Város, Állam",
    "HIGH" : "H",
    "LOW" : "L",
  },
  "hr-HR" : {
    "WEATHER" : "Vrijeme",
    "TONIGHT" : "NOĆAS",
    "TOMORROW" : "SUTRA",
    "CITY_STATE" : "Grad, Država",
    "HIGH" : "G",
    "LOW" : "D",
  },
  "cs-CZ" : {
    "WEATHER" : "Počasí",
    "TONIGHT" : "DNES VEČER",
    "TOMORROW" : "ZÍTRA",
    "CITY_STATE" : "Město, Region",
    "HIGH" : "V",
    "LOW" : "N",
  },
  "ru-RU" : {
    "WEATHER" : "Погода",
    "TONIGHT" : "НОЧЬЮ",
    "TOMORROW" : "ЗАВТРА",
    "CITY_STATE" : "Город, Штат",
    "HIGH" : "H",
    "LOW" : "L",
  },
  "bg-BG" : {
    "WEATHER" : "Време",
    "TONIGHT" : "ТАЗИ ВЕЧЕР",
    "TOMORROW" : "УТРЕ",
    "CITY_STATE" : "Град, Държава",
    "HIGH" : "В",
    "LOW" : "Н",
  },
  "ro-RO" : {
    "WEATHER" : "Vreme",
    "TONIGHT" : "ÎN SEARA ASTA",
    "TOMORROW" : "MÂINE",
    "CITY_STATE" : "Oraş, Stat",
    "HIGH" : "Mx",
    "LOW" : "Mn",
  },
  "sk-SK" : {
    "WEATHER" : "Počasie",
    "TONIGHT" : "DNES",
    "TOMORROW" : "ZAJTRA",
    "CITY_STATE" : "Mesto, Štát",
    "HIGH" : "V",
    "LOW" : "N",
  },
  "sl-SI" : {
    "WEATHER" : "Vreme",
    "TONIGHT" : "DANES ZVEČER",
    "TOMORROW" : "JUTRI",
    "CITY_STATE" : "Mesto, Država",
    "HIGH" : "Vi",
    "LOW" : "Ni",
  },
  "pl-PL" : {
    "WEATHER" : "Pogoda",
    "TONIGHT" : "DZIŚ WIECZOREM",
    "TOMORROW" : "JUTRO",
    "CITY_STATE" : "Miasto, Region",
    "HIGH" : "W",
    "LOW" : "N",
  },
  "sr-YU" : {
    "WEATHER" : "Vreme",
    "TONIGHT" : "VEČERAS",
    "TOMORROW" : "SUTRA",
    "CITY_STATE" : "Grad, Država",
    "HIGH" : "V",
    "LOW" : "N",
  },
  "de-DE" : {
    "WEATHER" : "Wetter",
    "TONIGHT" : "HEUTE NACHT",
    "TOMORROW" : "MORGEN",
    "CITY_STATE" : "Stadt, Land",
    "HIGH" : "H ",
    "LOW" : "N",
  },
  "es-ES" : {
    "WEATHER" : "El tiempo",
    "TONIGHT" : "ESTA NOCHE",
    "TOMORROW" : "MAÑANA",
    "CITY_STATE" : "Ciudad, Región",
    "HIGH" : "H",
    "LOW" : "L",
  },
  "nl-NL" : {
    "WEATHER" : "Weer",
    "TONIGHT" : "VANAVOND",
    "TOMORROW" : "MORGEN",
    "CITY_STATE" : "Plaats, Land",
    "HIGH" : "H",
    "LOW" : "L",
  },
  "no-NO" : {
    "WEATHER" : "Vær",
    "TONIGHT" : "I KVELD",
    "TOMORROW" : "I MORGEN",
    "CITY_STATE" : "By, Fylke",
    "HIGH" : "H",
    "LOW" : "L",
  },
  "fi-FI" : {
    "WEATHER" : "Sää",
    "TONIGHT" : "TÄNÄ ILTANA",
    "TOMORROW" : "HUOMENNA",
    "CITY_STATE" : "Kaupunki, Lääni",
    "HIGH" : "S",
    "LOW" : "P",
  },
  "fr-FR" : {
    "WEATHER" : "Temps",
    "TONIGHT" : "CE SOIR",
    "TOMORROW" : "DEMAIN",
    "CITY_STATE" : "Ville, Etat",
    "HIGH" : "H",
    "LOW" : "B",
  },
  "da-DK" : {
    "WEATHER" : "Vejr",
    "TONIGHT" : "I AFTEN",
    "TOMORROW" : "I MORGEN",
    "CITY_STATE" : "By, Stat",
    "HIGH" : "H",
    "LOW" : "L",
  },
  "tr-TR" : {
    "WEATHER" : "HavaDurumu",
    "TONIGHT" : "BU GECE",
    "TOMORROW" : "YARIN",
    "CITY_STATE" : "İl, Eyalet",
    "HIGH" : "Y",
    "LOW" : "D",
  },
  "it-IT" : {
    "WEATHER" : "Tempo",
    "TONIGHT" : "STANOTTE",
    "TOMORROW" : "DOMANI",
    "CITY_STATE" : "Città, Stato",
    "HIGH" : "H",
    "LOW" : "L",
  },
  "sv-SE" : {
    "WEATHER" : "Väder",
    "TONIGHT" : "IKVÄLL",
    "TOMORROW" : "IMORGON",
    "CITY_STATE" : "Stad, Stat",
    "HIGH" : "H",
    "LOW" : "L",
  },
  "pt-PT" : {
    "WEATHER" : "Metereol.",
    "TONIGHT" : "ESTA NOITE",
    "TOMORROW" : "AMANHÃ",
    "CITY_STATE" : "Cidade, Estado",
    "HIGH" : "+",
    "LOW" : "-",
  },
  "el-GR" : {
    "WEATHER" : "Καιρός",
    "TONIGHT" : "ΑΠΟΨΕ",
    "TOMORROW" : "ΑΥΡΙΟ",
    "CITY_STATE" : "Πόλη, Νομός",
    "HIGH" : "Υ",
    "LOW" : "Χ",
  },
  "et-EE" : {
    "WEATHER" : "Ilm",
    "TONIGHT" : "TÄNA ÕHTUL",
    "TOMORROW" : "HOMME",
    "CITY_STATE" : "Linn, Riik",
    "HIGH" : "K",
    "LOW" : "M",
  },
  "lv-LV" : {
    "WEATHER" : "Laiks",
    "TONIGHT" : "Šovakar",
    "TOMORROW" : "Rītdien",
    "CITY_STATE" : "Pilsēta, Rajons",
    "HIGH" : "A",
    "LOW" : "Z",
  },
  "lt-LT" : {
    "WEATHER" : "Orai",
    "TONIGHT" : "ŠIĄNAKT",
    "TOMORROW" : "RYTOJ",
    "CITY_STATE" : "Miestas, Šalis",
    "HIGH" : "A",
    "LOW" : "Ž",
  },
  "pt-BR" : {
    "WEATHER" : "Meteorolo.",
    "TONIGHT" : "ESTA NOITE",
    "TOMORROW" : "AMANHÃ",
    "CITY_STATE" : "Cidade, Estado",
    "HIGH" : "H",
    "LOW" : "L",
  },
}
twc.TEXT[ "en-IE" ] = twc.TEXT[ "en-GB" ];
twc.TEXT[ "en-BR" ] = twc.TEXT[ "en-GB" ];
twc.TEXT[ "es-BR" ] = twc.TEXT[ "es-US" ];

twc.lang = ureg.read("language");
if( !twc.TEXT[ twc.lang ]){
  console.log("[TWC] cannot read \"language\" " + twc.lang + ". use default \"en-US\".");
  twc.lang = "en-US";
}


twc.market = ureg.read( "market" );

twc.getDefaultSettings = function () {

  var settings;
  // US
  if (!system.locale || system.locale.country.indexOf("US") == 0) {
    settings = {
      locations:[["10001","New York, NY",    ""],
		 ["90101","Los Angeles, CA", ""],
		 ["75201","Dallas, TX",      ""],
		 ["30303","Atlanta, GA",     ""],
		 ["60601","Chicago, IL",     ""]],
      fahrenheit:      true,
      miles:           true,
      twelveHourClock: true };
    return settings;
  }

  // UK
  if (system.locale.country == "UK") {
    settings = {
      locations:[["UKXX0085","London", "sat_ir_ltst_5eheu_enus_506x342.jpg"],
		 ["USNY0996","New York", ""],
		 ["GMXX0007","Berlin", "sat_ir_ltst_5eheu_enus_506x342.jpg"],
		 ["JAXX0085","Tokyo", "sat_ir_ltst_4asja_enus_506x342.jpg"],
		 ["ASXX0112","Sydney", "sat_ir_ltst_5shau_enus_506x342.jpg"]],
      fahrenheit:      false,
      miles:           false,
      twelveHourClock: true };
    return settings;
  }

  // OTHERS
  settings = {
    locations:[["UKXX0085","London", "sat_ir_ltst_5eheu_enus_506x342.jpg"],
	       ["USNY0996","New York", ""],
	       ["GMXX0007","Berlin", "sat_ir_ltst_5eheu_enus_506x342.jpg"],
	       ["JAXX0085","Tokyo", "sat_ir_ltst_4asja_enus_506x342.jpg"],
	       ["ASXX0112","Sydney", "sat_ir_ltst_5shau_enus_506x342.jpg"]],
    fahrenheit:      false,
    miles:           false,
    twelveHourClock: false };
  return settings;
};

/*twc.update_settings = function () {
  try {
    var settings = eval(nvram[1].read("twc_settings"));
    if (typeof settings == 'undefined'){
      throw("no location");
    }
    this.settings = { fahrenheit:      settings[0],
		      miles:           settings[1],
		      twelveHourClock: settings[2]};
  }catch(e){
    this.settings = this.getDefaultSettings();
  }
  };*/

/*twc.update_locations = function () {

  try {
    var locations = eval(flash_mem.read("twc_favorites"));
    if (typeof locations == 'undefined' || locations == null){
      throw("no location");
    }
    this.locations = locations;
  }catch(e){
    var locations = this.getDefaultSettings().locations;
    this.locations = locations;
  }
  };*/


//twc.http_req_id = -1;
/*twc.getFeed = function( url ) {
  var onload = function (status, header, body) {
     if (status == 200) {
       var feed = eval("("+body+")");
       twc.setFeed(feed, 0);
       twc.isLoaded = true;
     }
   };

  cancel_http_request( this.http_req_id );
  this.http_req_id = http_request ({url:url, onload:onload, sync:false});
  }*/

//twc.feedCnt = 0;
/*twc.loadFeed = function(){
  this.update_settings();
  this.update_locations();
  this.getFeed( MyHostName + "weather/info?area=" + this.locations[this.feedCnt][0]
		+ "&fahrenheit=" + this.settings.fahrenheit
		+ "&miles=" + this.settings.miles);
  
};*/

twc.ticker = {city:"", width:0, loop:0, wait:0};
/*twc.setFeed = function( feed, cnt ) {
  var p = this.mainPanel;
  var f = feed[cnt];
  var l = this.TEXT[this.lang];
  var HL = l.HIGH + "\n" + l.LOW;
  var miles = this.settings.miles ? "mph":"km/h";

  var get_tmp = function(text) {
    if (typeof text == 'undefined' || text == "N/A")
      return "- -";
    return text + "\u00b0";
  };

  // H/L, CITY, TEMPERATURE, WEATHER-ICON
  setf_text (p.label, l.HIGH + "\n" + l.LOW);
  setf_text (p.city,   f.cc.obst.split("(")[0]);
  setf_text (p.cc.tmp, get_tmp(f.cc.tmp));
  p.cc.icon.src = path + "weather/icon/" + ("00"+f.cc.icon).substr(-2) + ".png";

  // STORM
  if (f.cc.direction != "CALM"){
    setf_text (p.cc.storm, f.cc.direction + " " + f.cc.speed + "\n" + miles);
  }else{
    setf_text (p.cc.storm, "CALM");
  }

  // TONIGHT / TOMORROW
  if (f.dayf[0].hi != "N/A") {
    var d = [{date: l.TONIGHT,  tmp:f.dayf[0], icon: f.dayf[0].icon_n}];
  }else{
    var d = [{date: l.TOMORROW, tmp:f.dayf[1], icon: f.dayf[1].icon_d}];
  };
  setf_text (p.day0.date, d[0].date);
  setf_text (p.day0.tmp,  get_tmp(d[0].tmp.hi) + "\n" + get_tmp(d[0].tmp.low));
  p.day0.icon.src = path + "weather/icon/" + ("00"+d[0].icon).substr(-2) + ".png";

  // TICKER
  var city  = p.city.text + "        " + p.city.text + "        ";
  var width = get_text_width (p.city, p.city.text);
  if ( width > 340 ){
    this.ticker = {city:city, width:get_text_width (p.city, city), loop:0, wait:0};
  }else{
    this.ticker = {city:"", width:0, loop:0, wait:0};
  }
  }*/


twc.mainPanel = null;
twc.setPanel = function (){
  // mainPanel
  var p = new container ({});
  p.cc = {}; p.day0 = {};

  //////////////
  // tentative
  //////////////
  p.components = [
    p.back      = new gbox({ width:360, height:252, color:[0,0,0,255] }),
    p.panel     = new gimage({src: this.panel_src, onload: NULL_FUNCTION}),

    p.vCtl1  = new container
    ({components:[
	p.weather   = new gtext({translate:[96,118,0], width:128,
				 font_size:18, font_name:"F015T-bold",
				 color: [66,90,173,255], align:RIGHT}),
	p.city      = new gtext({translate: [0,92,0], width:320,
				 font_size:32, margin:[0,0,2,0], align:LEFT}),
	p.cc.storm  = new gtextbox({translate:[110,10,0], width:96, height:54,
				    font_name:"F015T-bold", font_size:22,
				    color: [128,128,128,255],	    
				    margin_leading: -6, align:CENTER}),
	p.cc.icon   = new gimage({translate: [0,16,0], onload:NULL_FUNCTION}),
	p.cc.tmp    = new gtext({translate: [-100+32,16,0], width:128,
				 font_size:54, font_name:"F015T-bold",
				 color: [239,134,16,255]}),
      ]}),
    
    p.vCtl2 = new container
    ({components:[
	p.day0.date = new gtext({translate: [-72,-54,0], width:160,
				 color: [140,203,255,255], font_size:20}),
	p.day0.icon = new gimage({translate: [0,-92,0], onload:NULL_FUNCTION}),
	p.day0.tmp  = new gtextbox({translate:[104,-92,0], width:96, height:96,
				    font_name:"F015T-bold", font_size:34,
				    margin_leading: -5, align:RIGHT}),
	p.label     = new gtextbox({translate:[90,-92,0],
				    width:64, height:72,
				    font_size:20, margin_leading: 12}),
      ]})
  ];

  var l = this.TEXT[this.lang];
  setf_text (p.label, l.HIGH + "\n" + l.LOW);
  setf_text (p.city,   l.CITY_STATE);
  setf_text (p.cc.tmp, "- -" + "\u00b0");
  p.cc.icon.src = path + "weather/icon/32.png";
  setf_text (p.cc.storm, "- - - - -");
  setf_text (p.day0.date, "- - - - - - - -");
  setf_text (p.day0.tmp,"- -" + "\u00b0" + "\n" + "- -" + "\u00b0");
  p.day0.icon.src = path + "weather/icon/34.png";
  this.components.push( p );
  this.mainPanel = p;
};


/*twc.do_ticker = function(){

  if (!this.isFocus || this.ticker.width==0 || this.ticker.loop >=2 )
    return false;
  
  this.ticker.wait++;
  if (this.ticker.wait <30)
    return false;

  this.mainPanel.city.margin[2] -= 10;
  if (this.mainPanel.city.margin[2] < -1 * Math.floor(this.ticker.width/2))
  {
    this.mainPanel.city.margin[2] = 2;
    this.ticker.loop++;
  }
  setf_text (this.mainPanel.city, this.ticker.city);
  return true;
}

twc.stop_ticker = function(){
  if(this.ticker.width==0)
    return;

  this.ticker.loop = 0;
  this.ticker.wait = 0;
  this.mainPanel.city.margin[2] = 2;
  setf_text (this.mainPanel.city, this.ticker.city);
}*/

//twc.isLoaded = false;

// [public]
//twc.counter = 0;
/*twc.animation = function (count){
  // ticker
  if (this.do_ticker()==true)
    return;
  if( count==60 )
  {
    this.counter = (this.counter+1) % 10;
    if (this.counter == 0) {
      this.feedCnt = (this.feedCnt+1) % this.locations.length;
      this.loadFeed();
    }
  }
  }*/

twc.enter_stage = function(){
  var p = this.mainPanel;
  p.vCtl2.visible_p = true;
  // Reset application data
  //discard_stage ("twc");
  /*if (!this.isLoaded)
    this.loadFeed();*/
}
twc.leave_stage = function(){
    //delete_timer( this );
  //cancel_http_request( this.http_req_id );
  //this.stop_ticker();
  //this.counter = 0;
  //this.feedCnt = 0;
  var p = this.mainPanel;
  p.vCtl2.visible_p = false;
}

twc.setAlpha = function(alpha){
  var v = (alpha==255);
  var p = this.mainPanel;
  p.back.color[3] = alpha;
  p.panel.color[3] = alpha;
  p.cc.icon.color[3] = alpha;
  p.day0.icon.color[3] = alpha;
  p.vCtl1.visible_p = v;
  p.vCtl2.visible_p = v;
}

twc.freeResource = function ()
{
  var p = this.mainPanel
  var t = [p.weather, p.city, p.cc.storm, p.cc.tmp,
	   p.day0.tmp, p.day0.date, p.label];
  var s = [p.panel, p.cc.icon, p.day0.icon];
  for (var i in t) setf_text(t[i],"");
  for (var j in s) s[j].src = "";
}

twc.resumeResource = function ()
{
    //this.isLoaded = false;
  var p = this.mainPanel
  var l = this.TEXT[this.lang];
  p.panel.src = this.panel_src;
  setf_text(p.weather, l.WEATHER);
  setf_text (p.label, l.HIGH + "\n" + l.LOW);
  setf_text (p.city,   l.CITY_STATE);
  setf_text (p.cc.tmp, "- -" + "\u00b0");
  p.cc.icon.src = path + "weather/icon/32.png";
  setf_text (p.cc.storm, "- - - - -");
  setf_text (p.day0.date, "- - - - - - - -");
  setf_text (p.day0.tmp,"- -" + "\u00b0" + "\n" + "- -" + "\u00b0");
  p.day0.icon.src = path + "weather/icon/34.png";
}

twc.getFrameColor = function (){
  return [30, 120, 165, 255];
}

//// END
//flash_mem = nvram[1];
twc.setPanel();
twc.resumeResource();
return twc;
 })();
