//
// Copyright (C) 2009 Panasonic Corporation. All Rights Reserved.
//

//var scroll_list_manager = new container({});
scroll_list_manager.create = function () {
  if (this.components.length > 0) return;

  this.TOP_TRANSLATE = 710;
  for (var i = 0; i < 9; i++) {
    this.components.push( new scroll_item(i, [1650,this.TOP_TRANSLATE-i*170,0] ));
    if (i < 2) this.components[i].visible_p = false;
    else this.components[i].visible_p = true;
  }
  this.index = 0;
  this.scroll = 0;
  this.cindex = 2;
  this.translate[1] = 0;
};
scroll_list_manager.init = function() {
  this.index = 0;
  this.scroll = 0;
  this.cindex = 2;
  this.translate[1] = 0;

  this.components.sort(function(a, b) {
    return (a.index > b.index) ? 1 : -1;
  });
  if (description_text.visible_p)
    this.TOP_TRANSLATE = 425;
  for (var i = 0; i < this.components.length; i++) {
    this.components[i].translate = [1650,this.TOP_TRANSLATE-i*170,0];
    this.components[i].expandp = false;
    this.components[i].bg.translate[1] = 0;
    this.components[i].bg.height = LIST_ITEM_BG_HEIGHT;

    if (i < 2) this.components[i].visible_p = false;
    else this.components[i].visible_p = true;
  }

  this.map = {
    contact_list : def_contact_list,
    settings_video : def_settings_video,
    settings_sound : def_settings_sound,
    settings_profile : def_settings_profile,
    settings_calls : def_settings_calls,
    settings_privacy : def_settings_privacy,
    settings_connection : def_settings_connection,
    settings_advanced : def_settings_advanced,
    status : def_status.slice(0,5),
    find_contact : def_find_contact_result_list,
    account : def_account_result_list,
    add_contact : def_add_contact_result_list,
    history_all : def_history_list,
    history_incoming : def_history_list,
    history_missed : def_history_list,
    history_outgoing : def_history_list,
    voicemail : def_voicemail_result_list,
    authorization : def_authorization_result_list,
  };

};
scroll_list_manager.get_current_id = function() {
  return this.components[this.cindex].id;
}
scroll_list_manager.update = function (type, hook_func) {
  this.disappear(function() { this.appear(type, hook_func); });
};
scroll_list_manager.show_detail = function(type, detail_index, hook_func, description) {
  var _this = this;
  this.disappear(function() {
    if(description)
      description_text.set_description(description);
    _this.detail_index = detail_index;
    _this.detail = type;
    _this.appear(type, hook_func);
  });
};
scroll_list_manager.set_data = function(type, index) {
  var def = this.get_data(type);
  this.type = type;
  this.feed = def;
  if(def.length > 1 && def[0].backto_text)
    if(this.index == 0) {
      this.index = 1;
      this.cindex = 3;
    }

  for (var i = 2, j = index; i < this.components.length; i++, j++) {
    if (j < def.length) {
      this.components[i].set_data(def[j]);
      this.components[i].visible_p = true;
    } else {
      this.components[i].visible_p = false;
    }
  }
};
scroll_list_manager.clear_data = function() {
  for (var i = 0; i < this.components.length; i++) {
    if (this.components.visible_p)
      this.components.clear_data();
  }
};
scroll_list_manager.get_type = function() {
  return this.type;
};
scroll_list_manager.get_label = function() {
  return this.label;
};
scroll_list_manager.get_data = function(type) {
  if (this.detail_index) {
    return this.map[type][this.detail_index].detail;
  } else {
    return this.map[type];
  }
};
scroll_list_manager.appear = function(type, hook_func) {
  enable_keyhook = false;
  switch(type) {
   case "contact_list":
    this.TOP_TRANSLATE = 710; break;
  default:
    this.TOP_TRANSLATE = 595; break;
  }
  for (var i = 0; i < this.components.length; i++) delete_timer(this.components[i]);
  this.init();

  this.set_data(type, 0);

  this.visible_p = true;
  top_mask.visible_p = !(type == "contact_list");
  var i = 0;
  var last = this.components.length-1;

  this.hook = function() {
    scrollbar.appear(scroll_list_manager.feed.length,
                     function () { if (hook_func) hook_func(); enable_keyhook = true; });
  };

  append_timer(this, 100, function(obj, count) {
    if (i < obj.components.length) {
      this.components[i].appear(
	(i == obj.components.length-1) ? obj.hook : null,
	(i%2 == 0) || (i == last));
      i++;
    } else {
      delete_timer(obj);
    }
  });
};
scroll_list_manager.disappear = function(hook_func) {
  enable_keyhook = false;
  scrollbar.disappear();
  var i = 0;
  var last = this.components.length-1;
  this.detail_index = null;
  this.detail = null;
  this.hook_func = hook_func;
  append_timer(this, 100, function(obj, count) {
    if (i < obj.components.length) {
      obj.components[i].disappear(
	(i == obj.components.length-1) ? obj.hook_func : null,
	(i%2 == 0) || (i == last));
      i++;
    } else {
      delete_timer(obj);
      obj.visible_p = false;
    }
  });
};
scroll_list_manager.enter_focus = function() {
  common_key.set_cursor(this, this.components[this.cindex]);
};
scroll_list_manager.leave_focus = function() {
  common_key.set_cursor(this, null);
};
scroll_list_manager.move = function(target_translate, hook_func) {
  this.hook_func = hook_func;

  this.dst_x = target_translate[0];
  this.dst_y = target_translate[1];
  this.dst_z = target_translate[2];

  this.COUNT = 12;

  append_timer(this, 50, this.effect);
};
scroll_list_manager.effect = function(obj, count) {
  if (count == this.COUNT) {
    delete_timer(obj);
    this.translate[0] = this.dst_x;
    this.translate[1] = this.dst_y;
    this.translate[2] = this.dst_z;
    force_redraw();
    if (this.hook_func)
      this.hook_func();
  } else {
    this.translate[0] += (this.dst_x - this.translate[0])/3;
    this.translate[1] += (this.dst_y - this.translate[1])/3;
    this.translate[2] += (this.dst_z - this.translate[2])/3;
    force_redraw();
  }
};
scroll_list_manager.expand = function() {
  var h = this.components[this.cindex].get_expand_height();
  if (this.cindex == 5 && h > 170) {
    for (var i = 0; i < this.cindex; i++) {
      this.components[i].move([this.components[i].translate[0],
			       -1*this.scroll*170+this.TOP_TRANSLATE-(i)*170 + 170,
			       this.components[i].translate[2]],
			      null, true);
    }
    this.components[this.cindex].expand([
      this.components[this.cindex].translate[0],
      this.components[this.cindex].translate[1] + 170,
      this.components[this.cindex].translate[2]
    ]);
    h -= 170;
  } else {
    this.components[this.cindex].expand(this.components[this.cindex].translate);
  }
  for (var i = this.cindex + 1; i < this.components.length; i++) {
    this.components[i].move([this.components[i].translate[0],
			     -1*this.scroll*170+this.TOP_TRANSLATE-(i)*170 - h,
			     this.components[i].translate[2]],
			    null, true);
  }
};
scroll_list_manager.shrink = function(index) {
  var h = this.components[this.cindex].get_expand_height();
  if (this.cindex == 5 && h > 170) {
    for (var i = 0; i < this.cindex; i++) {
      this.components[i].move([this.components[i].translate[0],
			       -1*this.scroll*170+this.TOP_TRANSLATE-(i)*170,
			       this.components[i].translate[2]],
			      null, true);
    }
    this.components[this.cindex].shrink([
      this.components[this.cindex].translate[0],
      this.components[this.cindex].translate[1] - 170,
      this.components[this.cindex].translate[2]
    ], LIST_ITEM_BG_HEIGHT);
  } else {
    this.components[this.cindex].shrink(this.components[this.cindex].translate, LIST_ITEM_BG_HEIGHT);
  }
  for (var i = this.cindex + 1; i < this.components.length; i++) {
    this.components[i].move([this.components[i].translate[0],
			     -1*this.scroll*170+this.TOP_TRANSLATE-i*170,
			     this.components[i].translate[2]
			    ], null, true);
  }
};
scroll_list_manager.free = function() {
  if(this.components.length == 0) return;
  this.visible_p = false;
  this.clear_data();
  this.detail = null;
  this.detail_index = null;
};
scroll_list_manager.key_hook = function(up_down, key) {
  if (this.cursor.key_hook(up_down,key))
    return true;

  switch(key) {
   case TXK_UP:
    if (this.index == 0)
      return true;
    if (this.components[this.cindex].expandp) {
      this.shrink(this.cindex);
    }
    if (this.scroll > 0 && this.cindex == 3) {
      this.scroll--;

      this.move([this.translate[0], this.scroll*170, this.translate[2]], function() {});
      this.tmp = this.components.pop();
      this.tmp.visible_p = false;
      delete_timer(this.tmp); // for expand and select up. stop and set translate
      this.tmp.translate[1] = this.TOP_TRANSLATE-this.scroll*170;

      if(this.index >= 4) {
        this.tmp.visible_p = true;
	this.tmp.set_data(this.feed[this.index-4]);
      }
      this.components.unshift(this.tmp);
    }
    if (0 < this.index)
      this.index--;
    if (3 < this.cindex || this.index == 0)
      this.cindex--;
    scrollbar.set_pos(this.index);
    common_key.set_cursor(this, this.components[this.cindex]);
    return true;

   case TXK_DOWN:
    if (this.index >= this.feed.length-1) return true;

    if (this.components[this.cindex].expandp) {
      this.shrink(this.cindex);
    }
    if (this.cindex == 5) {
      this.scroll++;
      this.move([this.translate[0], this.scroll*170, this.translate[2]], function() {});

      this.tmp = this.components.shift();
      this.tmp.visible_p = false;
      this.tmp.translate[1] = this.TOP_TRANSLATE-this.components.length*170-this.scroll*170;

      if (this.index+4 < this.feed.length) {
	this.tmp.visible_p = true;
	this.tmp.set_data(this.feed[this.index+4]);
      }
      this.components.push(this.tmp);
    }
    this.index++;
    if (this.cindex < 5) this.cindex++;
    scrollbar.set_pos(this.index);
    common_key.set_cursor(this, this.components[this.cindex]);
    return true;
   case TXK_ENTER:
    this.cursor.act.action();
    return true;
  case TXK_RIGHT:
    return true;
  }
  return false;

};

scrollbar.create = function() {
  if (this.components.length > 0) return;
  this.components = [
    this.bar = new gbox({ width:10, round_enable:true, round_width:4, round_height:4, visible_p:false }),
    this.pos = new gbox({ round_enable:true, visible_p:false })
  ];
  this.bartop_y = 395;
};
scrollbar.POS_SIZE = 32;
scrollbar.init = function() {
  var offset = 710 - scroll_list_manager.TOP_TRANSLATE;
  this.translate[1] = -1*offset/2;
  this.target_height = 935 - offset;

  this.bartop_y = this.target_height/2-this.POS_SIZE/2;

  this.scroll_count = 0;
  this.bar.translate = [0, this.bartop_y, 0];
  this.bar.height = 0;
  this.pos.translate = [0, this.bartop_y, 0];
  this.pos.width = 0;
  this.pos.height = 0;
  this.pos.round_width = 0;
  this.pos.round_height = 0;
};
scrollbar.set_pos = function(index) {
  if(this.scroll_count < 5) return;
  this.pos.translate[1] = this.bartop_y - Math.floor((this.target_height / (this.scroll_count - 1)) * index);
};
scrollbar.appear = function(data_length, hook_func) {
  this.init();
  this.scroll_count = data_length;
  this.set_pos(scroll_list_manager.index);
  if(this.scroll_count < 5) {
    if (hook_func) hook_func();
    return;
  }
  this.visible_p = true;
  this.bar.visible_p = true;
  this.move([0,-20,0], this.bar.width, this.target_height, this.bar.round_width, this.bar.round_height,
	    function(){
	      this.pos.visible_p = true;
	      this.move([0, this.pos.translate[1], 0],
                        this.POS_SIZE, this.POS_SIZE,
                        this.POS_SIZE/2, this.POS_SIZE/2,
                        hook_func, true, this.pos);
	    }, true, this.bar);
};
scrollbar.disappear = function(hook) {
  this.visible_p = false;
  if (hook && typeof hook == "function") hook();
};
scrollbar.move = function(target_translate, target_w, target_h, target_r_w, target_r_h, hook_func, drawp, obj) {
  this.drawp = drawp || false;
  this.hook_func = hook_func;

  this.dst_x = target_translate[0];
  this.dst_y = target_translate[1];
  this.dst_z = target_translate[2];

  this.dst_w = Math.ceil(target_w);
  this.dst_h = Math.ceil(target_h);

  this.dst_r_w = Math.ceil(target_r_w);
  this.dst_r_h = Math.ceil(target_r_h);

  obj.COUNT = 10;

  append_timer(obj, 50, this.effect);
};
scrollbar.effect = function(obj, count) {
  if (count == obj.COUNT) {
    delete_timer(obj);
    obj.translate[0] = scrollbar.dst_x;
    obj.translate[1] = scrollbar.dst_y;
    obj.translate[2] = scrollbar.dst_z;
    obj.width = scrollbar.dst_w;
    obj.height = scrollbar.dst_h;
    obj.round_width = scrollbar.dst_r_w;
    obj.round_height = scrollbar.dst_r_h;
    if (scrollbar.drawp)
      force_redraw();
    if (scrollbar.hook_func)
      scrollbar.hook_func();
  } else {
    obj.translate[0] += (scrollbar.dst_x - obj.translate[0])/3;
    obj.translate[1] += (scrollbar.dst_y - obj.translate[1])/3;
    obj.translate[2] += (scrollbar.dst_z - obj.translate[2])/3;
    obj.width += Math.floor((scrollbar.dst_w - obj.width)/3);
    obj.height += Math.floor((scrollbar.dst_h - obj.height)/3);
    obj.round_width += Math.floor((scrollbar.dst_r_w - obj.round_width)/3);
    obj.round_height += Math.floor((scrollbar.dst_r_h - obj.round_height)/3);
    if (scrollbar.drawp)
      force_redraw();
  }
};
scrollbar.free = function() {
  if(this.components.length == 0) return;
  this.visible_p = false;
};
