//
// Copyright (C) 2008-2009 Panasonic Corporation. All Rights Reserved.
//

add_stage_load_path( "skype_main", path+"skype/skype_main.js");
add_stage_load_path( "sk_setup", path+"skype/sk_setup.js");
add_stage_load_path( "skype_account_make", path+"skype/skype_account_make.js");

(function(){
var skype = new Icon({});

skype.name = "skype";

// [private]
skype.logo_src  = path + "skype/img/skype_logo.png";
skype.image_src = path + "skype/img/background_app.png";

skype.mainPanel = null;
skype.setPanel = function (){
  // mainPanel
  var p = new container ({});
  p.components = [
    p.back    = new gbox({ width:360, height:252, color:[0,174,239,255] }),
    p.image   = new gimage({translate: [0,-32,0],
			    width:360, height:188,
			    onload:NULL_FUNCTION, onerror: NULL_FUNCTION}),
    p.logo    = new gimage({translate: [0,66,0], src: this.logo_src,
			    width:142, height:63,
			    onload:NULL_FUNCTION, onerror:NULL_FUNCTION }),
  ];
  this.components.push( p );
  this.mainPanel = p;
};


// [public]

skype.enter_focus = function() {
  append_timer( this, 1000, function(obj){
    delete_timer( obj );
    prepare_stage( "skype_main" );
    //prepare_stage( "skype_account_make" );
  });
};

skype.leave_focus = function() {
  delete_timer( this );
  discard_stage( "skype_main" );
  discard_stage( "skype_account_make" );
  //discard_stage( "sk_setup" );
};
skype.action = function() {
  on_stage( "skype_main" );
  //on_stage( "skype_account_make" );
  //on_stage( "sk_setup" );
};

skype.setAlpha = function(alpha){
  var v = (alpha==255);
  var p = this.mainPanel;
  p.back.color[3]  = alpha;
  p.logo.color[3]  = alpha;
  p.image.visible_p = v;
};

skype.freeResource = function () {
  this.mainPanel.logo.src  = "";
  this.mainPanel.image.src = "";
};

skype.resumeResource = function () {
  this.mainPanel.logo.src  = this.logo_src;
  this.mainPanel.image.src = this.image_src;
};

skype.getFrameColor = function (){
  return [0,175,240,255];//[99,151,184,255];
};

//// END
skype.setPanel();
skype.resumeResource();
return skype;
})();
