//
// Copyright (C) 2008-2009 Panasonic Corporation. All Rights Reserved.
//


add_stage_load_path ("yt_mainmenu", path + "youtube/yt_mainmenu.js");
add_stage_load_path ("yt_videosearch", path + "youtube/yt_videosearch.js");
//add_stage_load_path ("yt_country", path + "youtube/yt_country.js");
//add_stage_load_path ("yt_copyright", path + "youtube/yt_copyright.js");

//add_package_load_path ("yt_vlist", path + "youtube/pkg_yt_vlist.js");
//add_package_load_path ("yt_popup", path + "youtube/pkg_yt_popup.js");
//add_package_load_path ("pkg_r_tab", path + "youtube/pkg_yt_right_tab.js");

(function(){
var yt = new Icon({});

yt.name = "youtube";

// [private]
yt.logo_src = path + "youtube/youtube-logo.png";

yt.TEXT = {
  "en-US":{
    ICON_TITLE: "Featured Videos",
    LOCKED: "Locked.",
  },
  "es-US":{
    ICON_TITLE:"Vídeos destacados",
    LOCKED: "Bloqueado",
  },
  "fr-CA":{
    ICON_TITLE: "La sélection",
    LOCKED: "Bloqué",
  },
  "en-GB":{
    ICON_TITLE: "Featured Videos",
    LOCKED: "Locked.",
  },
  "es-ES":{
    ICON_TITLE:"Vídeos destacados",
    LOCKED: "Bloqueado",
  },
  "fr-FR":{
    ICON_TITLE: "La sélection",
    LOCKED: "Bloqué",
  },
  "de-DE":{
    ICON_TITLE:"Angesagte Videos",
    LOCKED: "Gesperrt",
  },
  "it-IT":{
    ICON_TITLE: "Video in primo piano",
    LOCKED: "Bloccato",
  },
}
yt.TEXT["en-IE"] = yt.TEXT["en-GB"];
yt.TEXT["en-BR"] = yt.TEXT["en-GB"];
yt.TEXT["es-BR"] = yt.TEXT["es-US"];


yt.lang = ureg.read("language");
if( !yt.TEXT[ yt.lang ]){
  if (ureg.read("market") == "EU") {
    yt.lang = "en-IE";
  } else {
    yt.lang = "en-US";
  }
  console.log("[YT] cannot read \"language\" " + ureg.read("language") + ". use default \"" + yt.lang + "\".");
}
add_package_load_path ("lang_youtube", path + "youtube/pkg_lang_youtube_" + yt.lang + ".js");


/*yt.feed = {};
yt.feed.data = null;
yt.feed.http_req_id = -1;
yt.feed.country = "00";
yt.getFeed = function( data_url, data_obj ) {
  cancel_http_request( data_obj.http_req_id );
  data_obj.http_req_id = http_request ({
    "url": data_url,
    "method": "GET",
    "onload": function (status, header, body) {
      if (status == 200) {
	body = body.replace(/\u2028/g," ");
	body = body.replace(/\u000D/g," ");
	data_obj.data = eval("("+body+")");
	yt.mainPanel.thumb.initImage(data_obj.data[0].thumb0 );
	yt.anim_num ++;
	yt.ready = true;
      }
    },
    "sync": false,
  });
  }

yt.loadFeed = function(){
  this.ready = false;
  this.anim_ready = false;
  var new_country = null;
  try {
    new_country = nvram[0].read("yt_country");
  } catch (e) {
    new_country = null;
  }

  if( new_country == null ){
    new_country = "00"; // "00" is Global.
  }

  if (new_country != this.feed.country){
    this.feed.country = new_country;
    this.feed.data = null;
    this.anim_num = 0;
  }

  if (this.feed.data) {
    this.ready = true;
    return;
  }
  };*/


yt.mainPanel = null;
//yt.lockPanel = null;
yt.setPanel = function (){
  // mainPanel
  var p = new container ({});
  p.components = [
    p.back    = new gbox({ width:360, height:252, color:[0,0,0,255] }),
    p.logo    = new gimage({translate: [0,96,0], src: this.logo_src,
			    onload: NULL_FUNCTION}),
    p.thumb   = new WipeGimage ( {"translate":[0,-30,0]}, 360, 192 ),
    p.label   = new gbox ({ translate: [0,-109,0], width:360, height:34,
			    color:[0,0,0,153] }),
    p.caption = new gtext({ translate: [0,-105,0], width:340,
			    font_size: 26, omitter: "..."})
  ];
  p.thumb.checkImage(true);
  this.components.push( p );
  this.mainPanel = p;

  // lockPanel
  /*  var q = new container ({visible_p:false});
  q.components = [
    q.back    = new gbox({ width:360, height:252, color:[64,16,16,255] }),
    q.logo    = new gimage({src: this.logo_src, onload: NULL_FUNCTION}),
    q.caption = new gtext({ translate: [0,-80,0], width:340, align: CENTER,
			    font_name: "F015T-bold",
                            color: [150,150,150,255], font_size: 42})
  ];
  this.components.push( q );
  this.lockPanel = q;*/
};

/*
yt.setLock = function( b ){
  this.mainPanel.visible_p = !b;
  this.lockPanel.visible_p = b;
  }*/

/*
yt.isLock = function(){
  return this.lockPanel.visible_p;
  }*/

// [public]
/*
yt.lock = function(){
  this.setLock( true );
}
yt.unlock = function(){
  this.setLock( false );
  }*/

yt.anim_num = 0; // private
yt.anim_ready = false; // private
yt.animation = function( count ){
    /*  if( this.isLock() )
	return;*/
  
  if( (count==16) && (this.isReady()==true) ){
    this.anim_ready = true;
    this.anim_num ++;
    //var num = this.anim_num%6;
    this.mainPanel.thumb.setImage(path+"youtube/thumb.jpg");
  }
  if (this.anim_ready) {
    this.mainPanel.thumb.animation( count );
  }
}

//yt.ready = false; // private

yt.enter_focus = function(){
    //  if( this.isLock() == false ){
    append_timer( this, 1000, function(obj){
		    delete_timer( obj );
      prepare_package( "lang_youtube" );
		    //prepare_package( "pkg_common_feed" );
      prepare_stage( "yt_mainmenu" );
    });
    //}
}
yt.leave_focus = function(){
    /*if( this.isLock() )
      return;*/
  delete_timer( this );
  discard_stage( "yt_mainmenu" );
}

yt.enter_stage = function(){
    //this.loadFeed();
  this.mainPanel.thumb.visible_p = true;
  //if (this.isReady()){
    this.mainPanel.thumb.initImage(path+"youtube/thumb.jpg");
  //}
  discard_stage( "yt_videosearch" );
}
yt.leave_stage = function(){
  delete_timer( this );
  this.mainPanel.thumb.clearImage();
  this.mainPanel.thumb.visible_p = false;
}

yt.action = function(){
    /*if (this.isLock())
      return;*/
  on_stage( "yt_mainmenu" );
}

yt.setAlpha = function(alpha){
  var v = (alpha==255);

  var p = this.mainPanel;
  p.back.color[3] = alpha;
  p.logo.color[3] = alpha;
  p.thumb.visible_p   = v;
  p.label.visible_p   = v;
  p.caption.visible_p = v;
  /*
  var q = this.lockPanel;
  q.back.color[3] = alpha;
  q.logo.color[3] = alpha;
  q.caption.visible_p = v;*/
}

yt.freeResource = function ()
{
  this.mainPanel.logo.src = "";
  //this.lockPanel.logo.src = "";
  setf_text(this.mainPanel.caption, "");
  //setf_text(this.lockPanel.caption, "");
}

yt.resumeResource = function ()
{
  this.mainPanel.logo.src = this.logo_src;
  setf_text(this.mainPanel.caption, this.TEXT[this.lang].ICON_TITLE);
  //this.lockPanel.logo.src = this.logo_src;
  //setf_text(this.lockPanel.caption, this.TEXT[this.lang].LOCKED);
}

yt.getFrameColor = function (){
  return [206, 35, 35, 255];
}

//// END
yt.setPanel();
yt.resumeResource();
return yt;
 })();
