//
// Copyright (C) 2008-2009 Panasonic Corporation. All Rights Reserved.
//

var ts = new Icon ();

// icon language decision
ts.TEXT = {
  "en-GB":{
    LOCKED: "Locked",
    TITLE: "Die Tagesschau in 100 Sekunden",
  },
  "de-DE":{
    LOCKED: "Gesperrt",
    TITLE: "Die Tagesschau in 100 Sekunden",
  },
}

ts.lang = ureg.read("language");
if (!ts.TEXT[ts.lang]) {
  ts.lang = "en-GB";
  warn("[Tagesschau] cannot read \"language\" " + ureg.read("language") + ". use default \"" + ts.lang + "\".");
}

// icon properties
ts.name = "tagesschau";
ts.feed_ready = false;
ts.logo_src = path + "tagesschau/ts_icon.jpg";
ts.mainPanel = null;
ts.lockPanel = null;

// create ui functions
ts.setPanel = function() {
  // mainPanel
  var p = new container({});
  p.components = [
    p.back = new gbox({
      width: 360,
      height: 252,
      color: [0, 0, 0, 255]
    }),
    p.logo = new gimage({
      src: this.logo_src,
    }),
    p.caption = new gtextbox ({
      translate: [0, -20, 0],
      width: 360,
      height: 150,
      font_size: 26,
      valign: MIDDLE,
      margin: [10, 10, 10, 10]
    }),
  ];
  
  this.components.push(p);
  this.mainPanel = p;
  
  // lockPanel
  var q = new container({visible_p: false});
  q.components = [
    q.back = new gbox({
      width: 360,
      height: 252,
      color: [64, 16, 16, 255]
    }),
    q.logo = new gimage({
      src: this.logo_src,
      onload: function() {},
    onerror: function() {}
    }),
    q.caption = new gtext({
      translate: [0, -80, 0],
      width: 340,
      align: CENTER,
      font_name: "F015T-bold",
      color: [150, 150, 150, 255],
      font_size: 42,
    })
  ];
  
  this.components.push(q);
  this.lockPanel = q;
}

ts.getFrameColor = function() {
  return [0x91, 0xd7, 0xf9, 255];
}

// init, action and status functions
ts.init = function() {
  this.feed_ready = false;

  // init logo for mainPanel and lockPanel
  // init lockPanel text
  this.mainPanel.logo.src = this.logo_src;
  this.lockPanel.logo.src = this.logo_src;
  setf_text(this.lockPanel.caption, this.TEXT[this.lang].LOCKED);
  setf_text(this.mainPanel.caption, this.TEXT[this.lang].TITLE);

}

//ts.action = function() {}
 
ts.isReady = function() {
  return this.feed_ready;
}

// animation function
ts.animation = function(count) { }

// enter and leave functions
ts.enter_stage = function() { }

ts.leave_stage = function() { }

ts.enter_focus = function() { }

ts.leave_focus = function() { }

ts.setAlpha = function(alpha) {
  var v = (alpha == 255);

  var p = this.mainPanel;
  p.back.color[3] = alpha;
  p.logo.color[3] = alpha;
  p.caption.visible_p = v;
  
  var q = this.lockPanel;
  q.back.color[3] = alpha;
  q.logo.color[3] = alpha;
  q.caption.visible_p = v;
}

ts.freeResource = function() {
  this.mainPanel.logo.src = "";
  this.lockPanel.logo.src = "";
  setf_text(this.mainPanel.caption, "");
  setf_text(this.lockPanel.caption, "");
}

ts.resumeResource = function() {
  this.mainPanel.logo.src = this.logo_src;
  this.lockPanel.logo.src = this.logo_src;
  setf_text(this.lockPanel.caption, this.TEXT[this.lang].LOCKED);
  setf_text(this.mainPanel.caption, this.TEXT[this.lang].TITLE);
}

// locking functions
ts.isLock = function() {
  return this.lockPanel.visible_p;
}

ts.lock = function() {
  this.setLock(true);
}

ts.setLock = function(b) {
  this.mainPanel.visible_p = !b;
  this.lockPanel.visible_p = b;
}

ts.unlock = function() {
  this.setLock(false);
}

// change return value
// to activate child lock
ts.isLockable = function() {
  return false;
}

// END
ts.setPanel();
ts;
