//
// Copyright (C) 2009 Panasonic Corporation. All Rights Reserved.
//

var show_menu = function (selected, hook) {
  switch(selected) {
   case "settings":
    page_title.clear();
    if (scroll_list_manager.visible_p){
      settings_list.disappear(function() {
        scroll_list_manager.disappear(hook);
      });
    } else if (settings_list.visible_p) {
      settings_list.disappear(hook);
    }
    return;
   case "status":
    page_title.clear();
    scroll_list_manager.disappear(hook);
    return;
   case "add_contact":
    page_title.clear();
    if (scroll_list_manager.visible_p) {
      input_area.disappear(function() {
        scroll_list_manager.disappear(hook);
      });
    } else if (add_contact_list.visible_p) {
      add_contact_list.disappear(hook);
    } else {
      input_area.disappear();
      if (skype_keyboard.visible_p)
        skype_keyboard.disappear(hook);
      else if (skype_dial_pad.visible_p)
        skype_dial_pad.disappear(hook);
    }
    return;
   case "history":
    page_title.clear();
    if (scroll_list_manager.visible_p) {
      history_list.disappear(function() {
        scroll_list_manager.disappear(hook);
      });
    } else {
      history_list.disappear(hook);
    }
    return;
   case "call_phones":
    page_title.clear();
    if (scroll_list_manager.visible_p) {
      input_area.disappear(function() {
        scroll_list_manager.disappear(hook);
      });
    } else {
      input_area.disappear();
      skype_dial_pad.disappear(hook);
    }
    return;
   case "account":
    page_title.clear();
    account_list.disappear(hook);
    return;

  default:
    page_title.clear();
    if (scroll_list_manager.visible_p)
      scroll_list_manager.disappear(hook);
    else
      hook();
    return;
  }
};

var def_menu = [
  { icon:path+"skype/img/settings.png", label:"Settings",
    action:function() {
      if( DEMO_MODE ) return;
      var selected = sphere_list.selected;

      if (selected == "settings" && !scroll_list_manager.visible_p) return;

      pkg_mgr.require(settings_list, path+"skype/sk_settings.js", function() {
        var hook = function() {
          sphere_list.selected = "settings";
          page_title.set_title("Settings");
          settings_list.appear(def_settings);
        };
        console.log("settings hook");
        show_menu(selected, hook);
      });
    }, },
  { icon:path+"skype/img/online.png", label:"Online",
    action:function() {
      if( DEMO_MODE ) return;
      var selected = sphere_list.selected;

      if (selected == "status") return;

      var hook = function() {
        sphere_list.selected = "status";
        page_title.set_title("Status");
        scroll_list_manager.appear("status");
      };
      show_menu(selected, hook);
    }, },
  { icon:path+"skype/img/contacts.png", label:"Contacts",
    action:function() {
      var selected = sphere_list.selected;

      if (selected == "contact_list") return;

      var hook = function() {
        sphere_list.selected = "contact_list";
        if(scroll_list_manager.visible_p)
          scroll_list_manager.update("contact_list");
        else
          scroll_list_manager.appear("contact_list");
      };
      show_menu(selected, hook);
    }, },
  { icon:path+"skype/img/add_contact.png", label:"Add Contact",
    action:function() {
      if( DEMO_MODE ) return;
      var selected = sphere_list.selected;

      if (selected == "add_contact" && add_contact_list.visible_p) return;

      pkg_mgr.require(add_contact_list, path+"skype/sk_add_contact.js", function() {
        var hook = function() {
          sphere_list.selected = "add_contact";
          page_title.set_title("Add Contact");
          add_contact_list.appear(def_add_contact);
        };
        show_menu(selected, hook);
      });
    }, },
    { icon:path+"skype/img/history.png", label:"History",
    action:function() {
      if( DEMO_MODE ) return;
      var selected = sphere_list.selected;

      if (selected == "history" && !scroll_list_manager.visible_p) return;

      pkg_mgr.require(history_list, path+"skype/sk_history.js", function() {
        var hook = function() {
          sphere_list.selected = "history";
          page_title.set_title("History");
          history_list.appear(def_history);
        };
        show_menu(selected, hook);
      });
    }, },
  { icon:path+"skype/img/call_phone.png", label:"Call phones",
    action:function() {
      if( DEMO_MODE ) return;
      var selected = sphere_list.selected;

      if (selected == "call_phones") return;

      pkg_mgr.require(skype_dial_pad, path+"skype/sk_dial_pad.js", function() {
        var hook = function() {
          sphere_list.selected = "call_phones";
          input_area.create();
          input_area.set_upper_text("Enter Phone Number");
          country_sel_btn.create();
          country_sel_btn.appear();
          skype_dial_pad.create();

          page_title.set_title("Call phones");
          skype_dial_pad.appear();
	  input_area.appear([100,0,0]);
        };
        show_menu(selected, hook);
      });
    }, },
  { icon:path+"skype/img/account.png", label:"Account",
    action:function() {
      if( DEMO_MODE ) return;
      var selected = sphere_list.selected;

      if (selected == "account") return;

      pkg_mgr.require(account_list, path+"skype/sk_account.js", function() {
        var hook = function() {
          sphere_list.selected = "account";
          page_title.set_title("Account");
          account_list.appear(def_account);
        };
        show_menu(selected, hook);
      });
    }, },
  { icon:path+"skype/img/voicemail.png", label:"Voicemail",
    action:function() {
      if( DEMO_MODE ) return;
      var selected = sphere_list.selected;

      if (selected == "voicemail") return;

      var hook = function() {
        sphere_list.selected = "voicemail";
        page_title.set_title("Voicemail");
        scroll_list_manager.appear("voicemail");
      };
      show_menu(selected, hook);
    }, },
  { icon:path+"skype/img/add_contact.png", label:"Contact\nrequests",
    action:function() {
      if( DEMO_MODE ) return;
      var selected = sphere_list.selected;

      if (selected == "authorization") return;

      var hook = function() {
        sphere_list.selected = "authorization";
        page_title.set_title("Contact requests");
        scroll_list_manager.appear("authorization");
      };
      show_menu(selected, hook);
    }, },
];

///////////////////////////////////////////////////////////////////////
// sphere
///////////////////////////////////////////////////////////////////////
sphere.prototype = new container({});
sphere.prototype.toggle_setting = function() {
  if(this.icon.visible_p) {
    this.toggle_icon.visible_p = true;
    this.icon.visible_p = false;
    this.label1.visible_p = false;
    this.toggle_label.visible_p = true;
  } else {
    this.icon.visible_p = true;
    this.toggle_icon.visible_p = false;
    this.toggle_label.visible_p = false;
    this.label1.visible_p = true;
  }
  force_redraw();
};
sphere.prototype.set_data = function(param) {
  if (param.icon) this.icon.src = param.icon;
  if (param.label1) setf_text(this.label1, param.label1);
  if (param.label2) sk_setf_text(this.label2, param.label2, 100);
  if (param.action) this.act.action = param.action;
  if (param.toggle_src) this.toggle_icon.src = param.toggle_src;
  if (param.toggle_label) setf_text(this.toggle_label, param.toggle_label);

  if (param.size) {
    switch(param.size) {
     case 80: this.frame_size = 180; break;
     default: this.frame_size = 286;
    }
  }
  this.frame.src = path+"skype/img/skypeframe.png";

  if( DEMO_MODE ){
    switch( param.label1 ){
    case "Contacts":
    case "End Call":
      break;
    default:
      this.demo_disable();
    }
  }

};
sphere.prototype.enter_focus = function() {
  //this.sphere.color = [181,231,181,255];
  this.frame.visible_p = true;
  common_key.set_cursor(this, this.act);
};
sphere.prototype.leave_focus = function() {
  this.last_cursor = this.cursor;
  this.frame.visible_p = false;
  //this.sphere.color = [0,0,0,20];
  common_key.set_cursor(this, null);
};
sphere.prototype.move = function(target_translate, target_size, hook_func, drawp, effect_func) {
  effect_func = effect_func || this.effect;
  this.drawp = drawp || false;
  this.hook_func = hook_func;

  this.dst_x = target_translate[0];
  this.dst_y = target_translate[1];
  this.dst_z = target_translate[2];

  this.dst_w = Math.ceil(target_size);
  this.dst_h = Math.ceil(target_size);

  this.COUNT = 12;

  append_timer(this, 50, effect_func);
};
sphere.prototype.init = function(target_translate, target_size) {
  this.drawp = true;
  this.dst_x = target_translate[0];
  this.dst_y = target_translate[1];
  this.dst_z = target_translate[2];
  this.dst_w = target_size;
  this.dst_h = target_size;
  this.COUNT = 12;
  this.effect(this, this.COUNT + 1 );
};
sphere.prototype.effect = function(obj, count) {
  if (count >= this.COUNT) {
    delete_timer(obj);
    this.translate[0] = this.dst_x;
    this.translate[1] = this.dst_y;
    this.translate[2] = this.dst_z;
    this.icon.width = this.dst_w;
    this.icon.height = this.dst_h;
    this.sphere.width = Math.ceil(this.dst_w*1.7);
    this.sphere.height = Math.ceil(this.dst_h*1.7);
    this.sphere.round_width = Math.ceil(this.sphere.width/2);
    this.sphere.round_height = Math.ceil(this.sphere.height/2);
    if(this.toggle_icon.src) {
      this.toggle_icon.width = this.dst_w;
      this.toggle_icon.height = this.dst_h;
    }
    if(this.newly.visible_p) {
      this.newly.translate[0] = this.sphere.width/3;
      this.newly.translate[1] = this.sphere.height/3;
      this.newly.translate[2] = this.dst_z;
      this.newly_circle.width = Math.ceil(this.sphere.width/4);
      this.newly_circle.height = Math.ceil(this.sphere.height/4);
      this.newly_circle.round_width = Math.ceil(this.newly_circle.width/2);
      this.newly_circle.round_height = Math.ceil(this.newly_circle.height/2);
    }
    if (this.drawp)
      force_redraw();
    if( count == this.COUNT ){
      if (this.hook_func)
	this.hook_func();
    }
  } else {
    this.translate[0] += (this.dst_x - this.translate[0])/3;
    this.translate[1] += (this.dst_y - this.translate[1])/3;
    this.translate[2] += (this.dst_z - this.translate[2])/3;
    this.icon.width += Math.floor((this.dst_w - this.icon.width)/3);
    this.icon.height += Math.floor((this.dst_h - this.icon.height)/3);
    this.sphere.width += Math.ceil((this.dst_w*1.7 - this.sphere.width)/3);
    this.sphere.height += Math.ceil((this.dst_h*1.7 - this.sphere.height)/3);
    this.sphere.round_width = Math.ceil(this.sphere.width/2);
    this.sphere.round_height = Math.ceil(this.sphere.height/2);
    if(this.toggle_icon.src) {
      this.toggle_icon.width += Math.floor((this.dst_w - this.toggle_icon.width)/3);
      this.toggle_icon.height += Math.floor((this.dst_h - this.toggle_icon.height)/3);
    }
    if(this.newly.visible_p) {
      this.newly.translate[0] = this.sphere.width/3;
      this.newly.translate[1] = this.sphere.height/3;
      this.newly.translate[2] = (this.dst_z - this.translate[2])/3;
      this.newly_circle.width = Math.ceil(this.sphere.width/4);
      this.newly_circle.height = Math.ceil(this.sphere.height/4);
      this.newly_circle.round_width = Math.ceil(this.newly_circle.width/2);
      this.newly_circle.round_height = Math.ceil(this.newly_circle.height/2);
    }
    if (this.drawp)
      force_redraw();
  }
};
sphere.prototype.effect2 = function(obj, count) {
  this.COUNT = 12;
  if (count == this.COUNT) {
    delete_timer(obj);
    this.translate[0] = this.dst_x;
    this.translate[1] = this.dst_y;
    this.translate[2] = this.dst_z;
    this.icon.width = this.dst_w;
    this.icon.height = this.dst_h;
    this.toggle_icon.width = this.dst_w;
    this.toggle_icon.height = this.dst_h;
    this.sphere.width = Math.ceil(this.dst_w*1.7);
    this.sphere.height = Math.ceil(this.dst_h*1.7);
    this.sphere.round_width = Math.ceil(this.sphere.width/2);
    this.sphere.round_height = Math.ceil(this.sphere.height/2);
    if (this.drawp)
      force_redraw();
    if (this.hook_func)
      this.hook_func();
  } else if (count > Math.floor(this.COUNT*1/3)) {
    this.translate[0] += (this.dst_x - this.translate[0])/3;
    this.translate[1] += (this.dst_y - this.translate[1])/3;
    this.translate[2] += (this.dst_z - this.translate[2])/3;
    this.icon.width += Math.floor((this.dst_w - this.icon.width)/3);
    this.icon.height += Math.floor((this.dst_h - this.icon.height)/3);
    this.toggle_icon.width += Math.floor((this.dst_w - this.toggle_icon.width)/3);
    this.toggle_icon.height += Math.floor((this.dst_h - this.toggle_icon.height)/3);
    this.sphere.width += Math.ceil((this.dst_w*1.7 - this.sphere.width)/3);
    this.sphere.height += Math.ceil((this.dst_h*1.7 - this.sphere.height)/3);
    this.sphere.round_width = Math.ceil(this.sphere.width/2);
    this.sphere.round_height = Math.ceil(this.sphere.height/2);
  } else {
    this.translate[0] += (this.dst_x - this.translate[0])/5;
    this.translate[1] += (this.dst_y - this.translate[1])/5;
    this.translate[2] += (this.dst_z - this.translate[2])/5;
    this.icon.width += Math.floor((this.dst_w - this.icon.width)/3);
    this.icon.height += Math.floor((this.dst_h - this.icon.height)/3);
    this.toggle_icon.width += Math.floor((this.dst_w - this.toggle_icon.width)/3);
    this.toggle_icon.height += Math.floor((this.dst_h - this.toggle_icon.height)/3);
    this.sphere.width += Math.ceil((this.dst_w*1.7 - this.sphere.width)/3);
    this.sphere.height += Math.ceil((this.dst_h*1.7 - this.sphere.height)/3);
    this.sphere.round_width = Math.ceil(this.sphere.width/2);
    this.sphere.round_height = Math.ceil(this.sphere.height/2);
    if (this.drawp)
      force_redraw();
  }
};
sphere.prototype.effect_icon_enter = function(height) {
  if(this.label1.text.indexOf("\n") >= 0 ) {
    this.COUNT = 12;
    append_timer(this.icon, 50, function(obj, count) {
      if(count == this.COUNT) {
        delete_timer(obj);
        obj.translate[1] = height;
      } else {
        obj.translate[1] += Math.ceil((height-obj.translate[1])/3);
      }
    });
  }
};
sphere.prototype.effect_icon_leave = function() {
  if(this.label1.text.indexOf("\n") >= 0 ) {
    this.COUNT = 12;
    append_timer(this.icon, 50, function(obj, count) {
      if(count == this.COUNT) {
        delete_timer(obj);
        obj.translate[1] = 0;
      } else {
        obj.translate[1] -= Math.ceil((obj.translate[1])/3);
      }
    });
  }
};
sphere.prototype.free = function() {
  this.icon.src = "";
  setf_text(this.label1, "");
  sk_setf_text(this.label2, "", 0);
  this.toggle_icon.src = "";
  setf_text(this.toggle_label, "");
  this.frame.visible_p = false;
  this.frame.src = "";
};

if( DEMO_MODE ){
  sphere.prototype.demo_disable = function() {
    switch( this.label1.text ){
    case "Contacts":
    case "End Call":
    case "Return":
      return this.demo_enable();
    default:
    }

    this.icon.color[0] = 80;
    this.icon.color[1] = 80;
    this.icon.color[2] = 80;

    if( this.label1.color[0] != 40 ){
      this.label1.color = [40,40,40,255];
      setf_text(this.label1,this.label1.text);
    }
  };

  sphere.prototype.demo_enable = function() {
    this.icon.color[0] = 255;
    this.icon.color[1] = 255;
    this.icon.color[2] = 255;
    if( this.label1.color[0] == 40 ){
      this.label1.color = [255,255,255,255];
      setf_text(this.label1,this.label1.text);
    }
  };

}


///////////////////////////////////////////////////////////////////////
// sphere_list_back
///////////////////////////////////////////////////////////////////////

//var sphere_list_back = new gbox({ width:300, height:1080, color:[0,0,0,20], translate:[-1300,0,0], });
sphere_list_back.appear = function() {
  this.visible_p = true;
  this.translate = [-1300,0,0];
  sphere_list_back.move([-780,0.1,0]);
};
sphere_list_back.move = function(target_translate, hook_func) {
  this.hook_func = hook_func;

  this.dst_x = target_translate[0];
  this.dst_y = target_translate[1];
  this.dst_z = target_translate[2];

  this.COUNT = 12;

  append_timer(this, 50, this.effect);
};
sphere_list_back.effect = function(obj, count) {
  if (count == this.COUNT) {
    delete_timer(obj);
    this.translate[0] = this.dst_x;
    this.translate[1] = this.dst_y;
    this.translate[2] = this.dst_z;
    if (this.drawp)
      force_redraw();
    if (obj.hook_func)
      obj.hook_func();
  } else {
    this.translate[0] += (this.dst_x - this.translate[0])/3;
    this.translate[1] += (this.dst_y - this.translate[1])/3;
    this.translate[2] += (this.dst_z - this.translate[2])/3;
    if (this.drawp)
      force_redraw();
  }
};
sphere_list_back.free = function() {
  this.visible_p = false;
};

///////////////////////////////////////////////////////////////////////
// sphere_list
///////////////////////////////////////////////////////////////////////

//var sphere_list = new container({});
sphere_list.selected = "";
sphere_list.init = function() {
  this.pos_y = [470,250,0.1,-250,-470];
  this.level = 0;
  this.cindex = 2;
};
sphere_list.disable = function() {
  this.enablep = false;
  for (var i = 0; i < this.components.length; i++) {
    if( !DEMO_MODE ){
    this.components[i].sphere.color = [0,0,0,50];
    this.components[i].icon.color = [255,255,255,100];
    }else{
      this.components[i].sphere.color[3] = 50;
      this.components[i].icon.color[3] = 100;
      this.components[i].demo_disable();
    }
  }
};
sphere_list.enable = function() {
  this.enablep = true;
  for (var i = 0; i < this.components.length; i++) {
    if( !DEMO_MODE ){
    this.components[i].sphere.color = [0,0,0,20];
    this.components[i].icon.color = [255,255,255,255];
    }else{
      this.components[i].sphere.color[3] = 20;
      this.components[i].icon.color[3] = 255;
    }
  }
};
sphere_list.create = function() {
  if (this.components.length > 0) return;

  for (var i = 0; i < def_menu.length; i++) {
    this.components.push( new sphere({ translate:[-780,1000,0], size:1, }) );
    if (def_menu[i].label == "Contact\nrequests") {
      setf_text(this.components[i].newly_text,
                def_authorization_result_list.length.toString());
      this.components[i].newly.visible_p = true;
    }
  }
};
sphere_list.set_data = function(data) {
  for (var i = 0; i < this.components.length; i++) {
    this.components[i].set_data({ icon:data[i].icon, label1:data[i].label, action:data[i].action, });
  }
};
sphere_list.free = function() {
  this.visible_p = false;
  this.last_cursor = null;
  for (var i = 0; i < this.components.length; i++) {
    this.components[i].free();
  }
};
sphere_list.appear = function(hook_func) {
  if (!this.enablep) this.enable();
  for (var i = 0; i < this.components.length; i++) {
    this.components[i].translate = [-780,1000,0];
    this.components[i].visible_p = true;
  }
  this.init();
  this.set_data(def_menu);
  this.visible_p = true;
  this.hook_func = hook_func;

  sphere_list_back.appear();
  for (var i = 0; i < this.components.length; i++) {
    this.components[i].move([-780,this.pos_y[i] || (i < 3 ? 800 : -800),0],
			    (i == 2) ? 150 : 100,
			    (i == 2) ?
			    function() {
			      if (sphere_list.hook_func) {
				sphere_list.hook_func();
			      }
			    } : null,
			    (i == 2), this.components[i].effect2);
  }
};
sphere_list.pos_y = [470,250,0.1,-250,-470];
sphere_list.level = 0;
sphere_list.cindex = 2;
sphere_list.enter_focus = function() {
  if (this.last_cursor)
    common_key.set_cursor(this, this.last_cursor);
  else
    common_key.set_cursor(this, this.components[2]);
};
sphere_list.leave_focus = function() {
  this.last_cursor = this.cursor;
  common_key.set_cursor(this, null);
};
sphere_list.set_visible = function() {
  for (var i = 0; i < this.components.length; i++) {
    if(i >= this.cindex-3 && i <= this.cindex+3)
      this.components[i].visible_p = true;
    else
      this.components[i].visible_p = false;
  }
};
sphere_list.key_hook = function(up_down, key) {
  switch(key) {
   case TXK_UP:
    if (sphere_list.level > 1)
      return true;

    sphere_list.level++;
    common_key.set_cursor(this, this.components[2-this.level]);
    for (var i = 0; i < this.components.length; i++) {
      this.components[i].move([this.components[i].translate[0],
			       this.pos_y[i+this.level] || (i+this.level < 3 ? 800 : -800),
			       this.components[i].translate[2]
			      ], ((i+this.level == 2) ? 150: 100), null, (i == 0) );
      if (i+this.level == 2) {
        this.components[i].effect_icon_enter(25);
      } else if (i+this.level == 3) {
        this.components[i].effect_icon_leave();
      }
    }
    this.cindex--;
    this.set_visible();
    return true;
   case TXK_DOWN:
    if (sphere_list.level < -1*(this.components.length-4))
      return true;

    sphere_list.level--;
    common_key.set_cursor(this, this.components[2-this.level]);
    for (var i = 0; i < this.components.length; i++) {
      this.components[i].move([this.components[i].translate[0],
			       this.pos_y[i+this.level] || (i+this.level < 3 ? 800 : -800),
			       this.components[i].translate[2]
			      ], ((i+this.level == 2) ? 150: 100), null, (i == 0) );
      if (i+this.level == 2) {
        this.components[i].effect_icon_enter(25);
      } else if (i+this.level == 1) {
        this.components[i].effect_icon_leave();
      }
    }
    this.cindex++;
    this.set_visible();
    return true;
   case TXK_LEFT:
   case TXK_RETURN:
    on_stage("home_screen");
    return true;
   case TXK_RIGHT:
    if (call_cmd_list.visible_p) {
      call_cmd_list.components[0].move(call_cmd_list.components[0].translate, 100, null, true);
      common_key.set_cursor(sobj, call_cmd_list);
    } else if (scroll_list_manager.visible_p) {
      common_key.set_cursor(sobj, scroll_list_manager);
      return true;
    } else if (settings_list.visible_p) {
      common_key.set_cursor(sobj, settings_list);
      return true;
    } else if (add_contact_list.visible_p) {
      common_key.set_cursor(sobj, add_contact_list);
      return true;
    } else if (history_list.visible_p) {
      common_key.set_cursor(sobj, history_list);
      return true;
    } else if (account_list.visible_p) {
      common_key.set_cursor(sobj, account_list);
      return true;
    } else if (skype_dial_pad.visible_p) {
      skype_dial_pad.cindex = 0;
      common_key.set_cursor(sobj, skype_dial_pad);
    } else if (skype_keyboard.visible_p) {
      common_key.set_cursor(sobj, skype_keyboard);
    }
    return true;

   case TXK_ENTER:
    this.cursor.act.action(this.cursor);
    return true;
  }
  return false;
};

var def_call_cmd = [
  { icon:path+"skype/img/mute_on.png", label:"Mute", visible:true,
    toggle_icon: DEMO_MODE ? "" : path+"skype/img/mute_off.png", toggle_label:"Unmute",
    action:function() { if( DEMO_MODE ) return; call_cmd_list.components[call_cmd_list.index].toggle_setting();}
  },
  { icon:path+"skype/img/stop_video.png", label:"Stop Video", visible:true,
    toggle_icon:path+"skype/img/Video.png", toggle_label:"Start Video",
    action:function() { if( DEMO_MODE ) return; call_cmd_list.components[call_cmd_list.index].toggle_setting();}
  },
  { icon:path+"skype/img/call_end.png", label:"End Call", visible:true,
    action:function() {
      if (ENABLE_EBUS) ebus.skype.request(SKYPE_END_CALL);

      if (ENABLE_EBUS){
	call_end(function() {
          ebus.skype.request(SKYPE_GET_CONTACT_LIST);
	});
      }else{
        if(call_cmd_list.is_fullscreen) def_call_fullscreen_cmd[4].action(); // Return action
        call_end(function() {
          sphere_list.selected = "contact_list";
          scroll_list_manager.appear("contact_list", function() {
            common_key.set_cursor(sobj, scroll_list_manager);
          });
        });
      }
    }, },
  { icon:path+"skype/img/call_hold.png", label:"Hold", visible:true,
    toggle_icon: DEMO_MODE ? "" : path+"skype/img/call_resume.png", toggle_label:"Resume",
    action:function() { if( DEMO_MODE ) return; call_cmd_list.components[call_cmd_list.index].toggle_setting(); }
  },
  { icon:path+"skype/img/message.png", label:"IM", visible:true,
    action:function() { if( DEMO_MODE ) return; scroll_list_manager.start_chat(scroll_list_manager.get_current_id(), scroll_list_manager.call_type); }
  },
];

def_call_fullscreen_cmd = [
  def_call_cmd[0], // Mute
  def_call_cmd[1], // Stop Video
  def_call_cmd[2], // End Call
  def_call_cmd[3], // Hold
  { icon:path+"skype/img/hide.png", label:"Return", visible:true,
    toggle_icon:path+"skype/img/call_resume.png",
    action:function() {
      webcam.init();

      if (ENABLE_EBUS)
        myview.set_full_mode(false);
      else
        myview.visible_p = true;

      call_duration.translate = call_duration.DEFAULT_TRANSLATE;
      call_cmd_list.is_fullscreen = false;
      call_cmd_list.translate[0] = 0;
      call_cmd_list.set_data(def_call_cmd);
      call_cmd_list.index = 0;
      call_cmd_list_show_timer.stop();
      common_key.set_cursor(sobj, null);
      common_key.set_cursor(sobj, call_cmd_list);
    } },
];

//var call_cmd_list_show_timer = {};
call_cmd_list_show_timer.start = function() {
  delete_timer(this);
  append_timer(this, 5000, function(obj, count) {
    delete_timer(obj);
    call_cmd_list.visible_p = false;
  });
};
call_cmd_list_show_timer.stop = function() {
  delete_timer(this);
};

///////////////////////////////////////////////////////////////////////
// call_cmd_list
///////////////////////////////////////////////////////////////////////

//var call_cmd_list = new container({ visible_p:false, });
call_cmd_list.SLIDE_WIDTH = 400;
call_cmd_list.create = function() {
  if (this.components.length > 0) {
    for (var i = 0; i < this.components.length; i++) {
      this.components[i].translate = [1000*(i+2),-330,0];
    }
    this.visible_p = false;
    return;
  }

  for (var i = 0; i < def_call_cmd.length; i++) {
    this.components.push( new sphere({ translate:[1000*(i+2),-330,0],
				       icon:def_call_cmd[i].icon,
				       label1:def_call_cmd[i].label,
                                       label2:"",
				       size:80,
				       action:def_call_cmd[i].action,
				       toggle_src:def_call_cmd[i].toggle_icon || null ,
				       toggle_label:def_call_cmd[i].toggle_label || null,
                                     }));
    this.components[i].visible_p = def_call_cmd[i].visible;
  }
};
call_cmd_list.index = 0;
call_cmd_list.appear = function(hook_func) {
  this.set_data(def_call_cmd);
  this.visible_p = true;
  this.index = 0;
  for (var i = 0; i < this.components.length; i++) {
    this.components[i].translate = [-300+250*i,-550,0];
    this.components[i].move([-300+250*i,-390,0], 80,
			    (i == this.components.length-1) ? function() {
			      if (hook_func) hook_func();
			    } : null);

  }
};
call_cmd_list.disappear = function() {
  if (!this.visible_p) return;
  var _this = this;
  for (var i = 0; i < this.components.length; i++) {
    this.components[i].move([-300+250*i,-550,0], 100,
                            function() { _this.visible_p = false; },
                            (i == 0));
  }
};
call_cmd_list.move = function(target_translate, hook_func) {
  this.hook_func = hook_func;

  this.dst_x = target_translate[0];
  this.dst_y = target_translate[1];
  this.dst_z = target_translate[2];

  this.COUNT = 12;

  append_timer(this, 50, this.effect);
};
call_cmd_list.effect = function(obj, count) {
  if (count == this.COUNT) {
    delete_timer(obj);
    this.translate[0] = this.dst_x;
    this.translate[1] = this.dst_y;
    this.translate[2] = this.dst_z;
    force_redraw();
    if (this.hook_func)
      this.hook_func();
  } else {
    this.translate[0] += (this.dst_x - this.translate[0])/5;
    this.translate[1] += (this.dst_y - this.translate[1])/5;
    this.translate[2] += (this.dst_z - this.translate[2])/5;
    force_redraw();
  }
};
call_cmd_list.enter_focus = function() {
  this.components[this.index].move(this.components[this.index].translate, 100, null, true);
  common_key.set_cursor(this, this.components[this.index]);
};
call_cmd_list.leave_focus = function() {
  common_key.set_cursor(this, null);
};
call_cmd_list.set_data = function(def_menu) {
  var p = this.components;
  for (var i = 0; i < p.length || i < def_menu.length; i++) {
    if (!p[i]) p.push( new sphere({}) );
    if (def_menu[i]) {
      p[i].visible_p = def_menu[i].visible;
      p[i].set_data({ icon:def_menu[i].icon,
                      label1:def_menu[i].label,
                      label2:"",
                      size:1,
                      action:def_menu[i].action,
                    });
      p[i].init(p[i].translate, 80);
    } else {
      p[i].visible_p = false;
    }
  }
};
call_cmd_list.free = function() {
  if(this.components.length == 0) return;
  for (var i = 0; i < this.components.length; i++) {
    this.components[i].free();
  }
};
call_cmd_list.key_hook = function(up_down, key) {
  switch (key) {
   case TXK_D1:
    console.log("reset_video 1");
    if (ENABLE_EBUS && ces.flag) {
      ebus.skype.request(SKYPE_RESET_VIDEO);
      ces.wait();
    }
    return true;
  }

  if (this.is_fullscreen && !this.visible_p && key != TXK_D1) {
    this.visible_p = true;
    call_cmd_list_show_timer.start();
    return true;
  } else if (this.is_fullscreen) {
    call_cmd_list_show_timer.start();
  }

  switch(key) {
   case TXK_UP:
    if(this.is_fullscreen || scroll_list_manager.call_type != "video")
      return true;
    this.components[this.index].move(this.components[this.index].translate, 80);
    common_key.set_cursor(sobj, webcam);
    return true;
   case TXK_LEFT:
    if (this.components[this.index-1] && this.components[this.index-1].visible_p) {
      this.components[this.index].move(this.components[this.index].translate, 80);
      this.index--;
      this.components[this.index].move(this.components[this.index].translate, 100, null, true);
      common_key.set_cursor(this, this.components[this.index]);
    }
    return true;
    break;
   case TXK_RIGHT:
    if (this.components[this.index+1] && this.components[this.index+1].visible_p) {
      this.components[this.index].move(this.components[this.index].translate, 80);
      this.index++;
      this.components[this.index].move(this.components[this.index].translate, 100, null, true);
      common_key.set_cursor(this, this.components[this.index]);
    }
    return true;
    break;
   case TXK_ENTER:
    if (this.cursor.act && this.cursor.act.action)
      this.cursor.act.action();
    return true;
    break;
  case TXK_HOME:
  case TXK_DOWN:
    return true;
  }

  if( DEMO_MODE ){
    if( key==TXK_RETURN){
      if( this.is_fullscreen ){
	def_call_fullscreen_cmd[4].action();
      }
      return true;
    }
  }

  return false;
};

///////////////////////////////////////////////////////////////////////
// common_sphere_methods
///////////////////////////////////////////////////////////////////////

//var common_sphere_list = new container({});
//common_sphere_list.create = function() {
//};

var common_sphere_list_methods = {
  create : function(def, x, y) {
    this.feed = def;

    this.x = (def.length > 4) ? "-300+300*(i%4)": "(this.feed.length-1) * -150 + (i*300) + 150";
    this.y = (def.length > 4) ? "250-400*Math.floor(i/4)" : "0";

    if (this.components.length > 0) return;
    for (var i = 0; i < def.length; i++) {
      this.components.push( new sphere({ translate:[eval(this.x),eval(this.y),0],
				         icon:def[i].icon,
				         label1:def[i].label,
                                         label2:"",
				         size:1,
				         action:def[i].action,
                                       }) );
      this.components[i].label1.visible_p = false;
      this.components[i].label2.visible_p = false;
    }
  },
  init : function() {
    for (var i = 0; i < this.components.length; i++) {
      this.components[i].translate = [eval(this.x), eval(this.y), 0];
      this.components[i].label2.visible_p = false;
      this.components[i].visible_p = true;
    }
  },
  appear : function(def, hook_func) {
    enable_keyhook = false;
    this.create(def);
    this.init();
    top_mask.visible_p = false;
    this.hook_func = function() {
      if(hook_func) hook_func();
      enable_keyhook = true;
    };
    this.visible_p = true;
    var a = (this.components.length%2 == 0) ? 1 : 2;
    var i = 0;
    var j = Math.ceil(Math.random()*10)%this.components.length;
    var last = this.components.length-1;
    append_timer(this, 80, function(obj, count) {
      if (i < obj.components.length) {
	obj.components[j%this.components.length].order = i;
	obj.components[j%this.components.length].move(
	  obj.components[j%this.components.length].translate,
	  180,
	  function() { this.label1.visible_p = true;
		       this.move(this.translate, 120, (this.order==last) ? obj.hook_func : null,
                                 (this.order%3 == 0 || this.order == last) );},
          (i%3 == 0 || i == this.components.length-1) );
	j += this.components.length-a;
	i++;
      } else {
	delete_timer(obj);
      }
    });
  },
  disappear : function(hook_func) {
    if(!this.visible_p) {
      if(hook_func) hook_func();
      return;
    }
    enable_keyhook = false;
    if (description_text.free) description_text.free();
    var _this = this;
    this.hook_func = hook_func || null;
    var last = this.components.length-1;
    for (var i = 0; i < this.components.length; i++) {
      var p = this.components[i];
      p.label1.visible_p = false;
      p.label2.visible_p = false;
      p.move(this.components[i].translate, 1,
             (i == last) ? function() {
	       _this.visible_p = false;
	       if (_this.hook_func) _this.hook_func();
             } : null, (i%3 == 0|| i == last));
    }
  },
  enter_focus : function() {
    this.index = 0;
    this.components[this.index].move(this.components[this.index].translate, 150, null, true);
    common_key.set_cursor(this, this.components[this.index]);
  },
  leave_focus : function() {
    common_key.set_cursor(this, null);
  },
  clear_sphere : function() {
    this.visible_p = false;
    for (var i = 0; i < this.components.length; i++) {
      this.components[i].sphere.width = 2;
      this.components[i].sphere.height = 2;
      this.components[i].sphere.round_width = 1;
      this.components[i].sphere.round_height = 1;
      this.components[i].icon.width = 1;
      this.components[i].icon.height = 1;
      this.components[i].label1.visible_p = false;
      this.components[i].label2.visible_p = false;
    }
  },
  key_hook : function(up_down, key) {
    switch(key) {
     case TXK_UP:
      if (this.components[this.index-4]) {
	this.components[this.index].move(this.components[this.index].translate, 120);
	this.index -= 4;
	this.components[this.index].move(this.components[this.index].translate, 150, null, true);
	common_key.set_cursor(this, this.components[this.index]);
	return true;
      }
      break;
     case TXK_DOWN:
      if (this.components[this.index+4]) {
	this.components[this.index].move(this.components[this.index].translate, 120);
	this.index += 4;
	this.components[this.index].move(this.components[this.index].translate, 150, null, true);
	common_key.set_cursor(this, this.components[this.index]);
	return true;
      } else if(this.components.length > 4 && this.index < 4) {
	this.components[this.index].move(this.components[this.index].translate, 120);
	this.index = this.components.length-1;
	this.components[this.index].move(this.components[this.index].translate, 150, null, true);
	common_key.set_cursor(this, this.components[this.index]);
	return true;
      }
      break;
     case TXK_LEFT:
      if (this.components[this.index-1] && this.index != 4) {
	this.components[this.index].move(this.components[this.index].translate, 120);
	this.index--;
	this.components[this.index].move(this.components[this.index].translate, 150, null, true);
	common_key.set_cursor(this, this.components[this.index]);
      } else {
	this.components[this.index].move(this.components[this.index].translate, 120, null, true);
	common_key.set_cursor(sobj, sphere_list);
      }
      return true;
     case TXK_RIGHT:
      if (this.components[this.index+1] && this.index != 3) {
	this.components[this.index].move(this.components[this.index].translate, 120);
	this.index++;
	this.components[this.index].move(this.components[this.index].translate, 150, null, true);
	common_key.set_cursor(this, this.components[this.index]);
	return true;
      }
      break;
     case TXK_ENTER:
      this.cursor.act.action();
      return true;
    }
    return false;
  },
};

extend(settings_list, common_sphere_list_methods);
extend(add_contact_list, common_sphere_list_methods);
extend(history_list, common_sphere_list_methods);
extend(account_list, common_sphere_list_methods);

