//
// Copyright (C) 2008 Panasonic Corporation. All Rights Reserved.
//


var coming = new Icon({});

coming.name = "coming_soon_up";

coming.gray = [44,44,44,255];
coming.bg_col = [0,24,48,255];
coming.WIDTH = 480;
coming.HEIGHT = 137;

coming.TEXT = {
  "en-US" : {
    "TITLE" : "COMING SOON",
    "DISPLAY_NAME" : "COMING SOON",
  },
  "es-US" : {
    "TITLE" : "Próximamente",
    "DISPLAY_NAME" : "Próximamente",
  },
  "fr-CA" : {
    "TITLE" : "BIENTÔT DISPONIBLE",
    "DISPLAY_NAME" : "BIENTÔT DISPONIBLE",
  },
  "en-GB" : {
    "TITLE" : "COMING SOON",
    "DISPLAY_NAME" : "COMING SOON",
  },
  "hu-HU" : {
    "TITLE" : "HAMAROSAN JÖN",
    "DISPLAY_NAME" : "HAMAROSAN JÖN",
  },
  "hr-HR" : {
    "TITLE" : "USKORO",
    "DISPLAY_NAME" : "USKORO",
  },
  "cs-CZ" : {
    "TITLE" : "BRZY UVIDÍTE",
    "DISPLAY_NAME" : "BRZY UVIDÍTE",
  },
  "ru-RU" : {
    "TITLE" : "СКОРО",
    "DISPLAY_NAME" : "СКОРО",
  },
  "bg-BG" : {
    "TITLE" : "ПРЕДСТОЯЩО",
    "DISPLAY_NAME" : "ПРЕДСТОЯЩО",
  },
  "ro-RO" : {
    "TITLE" : "ÎN CURÂND",
    "DISPLAY_NAME" : "ÎN CURÂND",
  },
  "sk-SK" : {
    "TITLE" : "UŽ ČOSKORO",
    "DISPLAY_NAME" : "UŽ ČOSKORO",
  },
  "sl-SL" : {
    "TITLE" : "Kmalu tudi pri vas",
    "DISPLAY_NAME" : "Kmalu tudi pri vas",
  },
  "pl-PL" : {
    "TITLE" : "DOSTĘPNE WKRÓTCE",
    "DISPLAY_NAME" : "DOSTĘPNE WKRÓTCE",
  },
  "sr-YU" : {
    "TITLE" : "USKORO",
    "DISPLAY_NAME" : "USKORO",
  },
  "de-DE" : {
    "TITLE" : "BALD ERHÄLTLICH",
    "DISPLAY_NAME" : "BALD ERHÄLTLICH",
  },
  "es-ES" : {
    "TITLE" : "PRÓXIMAMENTE",
    "DISPLAY_NAME" : "PRÓXIMAMENTE",
  },
  "nl-NL" : {
    "TITLE" : "BINNENKORT",
    "DISPLAY_NAME" : "BINNENKORT",
  },
  "no-NO" : {
    "TITLE" : "KOMMER SNART",
    "DISPLAY_NAME" : "KOMMER SNART",
  },
  "fi-FI" : {
    "TITLE" : "TULOSSA PIAN",
    "DISPLAY_NAME" : "TULOSSA PIAN",
  },
  "fr-FR" : {
    "TITLE" : "PROCHAINE SORTIE ",
    "DISPLAY_NAME" : "PROCHAINE SORTIE ",
  },
  "da-DK" : {
    "TITLE" : "KOMMER SNART",
    "DISPLAY_NAME" : "KOMMER SNART",
  },
  "tr-TR" : {
    "TITLE" : "YAKINDA GELİYOR",
    "DISPLAY_NAME" : "YAKINDA GELİYOR",
  },
  "it-IT" : {
    "TITLE" : "PROSSIMAMENTE",
    "DISPLAY_NAME" : "PROSSIMAMENTE",
  },
  "sv-SE" : {
    "TITLE" : "KOMMER SNART",
    "DISPLAY_NAME" : "KOMMER SNART",
  },
  "pt-PT" : {
    "TITLE" : "EM BREVE",
    "DISPLAY_NAME" : "EM BREVE",
  },
  "el-GR" : {
    "TITLE" : "Προσεχώς",
    "DISPLAY_NAME" : "Προσεχώς",
  },
  "et-EE" : {
    "TITLE" : "TULEKUL",
    "DISPLAY_NAME" : "TULEKUL",
  },
  "lv-LV" : {
    "TITLE" : "Drīzumā",
    "DISPLAY_NAME" : "Drīzumā",
  },
  "lt-LT" : {
    "TITLE" : "JAU GREITAI",
    "DISPLAY_NAME" : "JAU GREITAI",
  },
}
coming.TEXT[ "en-GB" ] = coming.TEXT[ "en-US" ];
coming.TEXT[ "en-IE" ] = coming.TEXT[ "en-US" ];
coming.TEXT[ "es-ES" ] = coming.TEXT[ "es-US" ];
coming.TEXT[ "fr-FR" ] = coming.TEXT[ "fr-CA" ];

coming.lang = ureg.read("language");
if( !coming.TEXT[ coming.lang ]){
  console.log("[CS] cannot read \"language\" " + coming.lang + ". use default \"en-US\".");
  coming.lang = "en-US";
}

coming.display_name = coming.TEXT[ coming.lang ].DISPLAY_NAME;

coming.make = function(){
  this.components.push(
    new actor({
      "base_col": [ coming.gray, coming.gray ],
      "bg_image": [
	new gbox ({
	  "width": this.WIDTH,	"height": this.HEIGHT,
	  "color": this.gray,
	}),
	new gimage ({
	  "src":  path +this.name+ "/Coming-Logo-back.png",
	  "width": this.WIDTH,	"height": this.HEIGHT,
	  "draw_type":DIRECT,
	}),
	new gtextbox ({
	  "text":  this.TEXT[coming.lang].TITLE,
	  "color": [33,33,33,255],
	  "width": 340,	"height": 80,
	  "align": CENTER,
          "valign" : MIDDLE,
	  "font_name": "F015T-bold",
	  "font_size": 36,
	}),
      ],
    })
  );
};
coming.make();

//// END
coming;

