//
// Copyright (C) 2008 Panasonic Corporation. All Rights Reserved.
//


var set = new Icon();
set.name = "settings";
set.WIDTH = 480;
set.HEIGHT = 137;
set.TEXT = {
  "en-US" : {
    "SETTINGS" : "Settings",
    "SETTINGS_font_size" : 35,
  },
  "es-US" : {
    "SETTINGS" : "Configuración",
    "SETTINGS_font_size" : 35,
  },
  "fr-CA" : {
    "SETTINGS" : "Réglages",
    "SETTINGS_font_size" : 35,
  },
  "en-GB" : {
    "SETTINGS" : "Setup",
    "SETTINGS_font_size" : 35,
  },
  "hu-HU" : {
    "SETTINGS" : "Beállítások",
    "SETTINGS_font_size" : 35,
  },
  "hr-HR" : {
    "SETTINGS" : "Postavljanje",
    "SETTINGS_font_size" : 35,
  },
  "cs-CZ" : {
    "SETTINGS" : "Nastavení",
    "SETTINGS_font_size" : 35,
  },
  "ru-RU" : {
    "SETTINGS" : "Установки",
    "SETTINGS_font_size" : 35,
  },
  "bg-BG" : {
    "SETTINGS" : "Настройки",
    "SETTINGS_font_size" : 35,
  },
  "ro-RO" : {
    "SETTINGS" : "Setare",
    "SETTINGS_font_size" : 35,
  },
  "sk-SK" : {
    "SETTINGS" : "Ďalšie nastavenia",
    "SETTINGS_font_size" : 30,
  },
  "sl-SL" : {
    "SETTINGS" : "Nastavitev",
    "SETTINGS_font_size" : 35,
  },
  "pl-PL" : {
    "SETTINGS" : "Ustawianie",
    "SETTINGS_font_size" : 35,
  },
  "sr-YU" : {
    "SETTINGS" : "Postavka",
    "SETTINGS_font_size" : 35,
  },
  "de-DE" : {
    "SETTINGS" : "Setup",
    "SETTINGS_font_size" : 35,
  },
  "es-ES" : {
    "SETTINGS" : "Configuración",
    "SETTINGS_font_size" : 35,
  },
  "nl-NL" : {
    "SETTINGS" : "Instellingen",
    "SETTINGS_font_size" : 35,
  },
  "no-NO" : {
    "SETTINGS" : "Oppsett",
    "SETTINGS_font_size" : 35,
  },
  "fi-FI" : {
    "SETTINGS" : "Asetukset",
    "SETTINGS_font_size" : 35,
  },
  "fr-FR" : {
    "SETTINGS" : "Configuration",
    "SETTINGS_font_size" : 35,
  },
  "da-DK" : {
    "SETTINGS" : "Indstilling",
    "SETTINGS_font_size" : 35,
  },
  "tr-TR" : {
    "SETTINGS" : "Kurulum Ayarı",
    "SETTINGS_font_size" : 35,
  },
  "it-IT" : {
    "SETTINGS" : "Impostazione",
    "SETTINGS_font_size" : 35,
  },
  "sv-SE" : {
    "SETTINGS" : "Inställningar",
    "SETTINGS_font_size" : 35,
  },
  "pt-PT" : {
    "SETTINGS" : "Configuração",
    "SETTINGS_font_size" : 35,
  },
  "el-GR" : {
    "SETTINGS" : "Ρυθμίσεις",
    "SETTINGS_font_size" : 35,
  },
  "et-EE" : {
    "SETTINGS" : "Seadistus",
    "SETTINGS_font_size" : 35,
  },
  "lv-LV" : {
    "SETTINGS" : "Iestatīšana",
    "SETTINGS_font_size" : 35,
  },
  "lt-LT" : {
    "SETTINGS" : "Sąranka",
    "SETTINGS_font_size" : 35,
  },
}
set.TEXT[ "en-IE" ] = set.TEXT[ "en-GB" ];
set.lang = ureg.read("language");
if( !set.TEXT[ set.lang ]){
  if (ureg.read("market") == "EU") {
    set.lang = "en-IE";
  } else {
    set.lang = "en-US";
  }
  console.log("[ST] cannot read \"language\" " + ureg.read("language") + ". use default \"" + set.lang + "\".");
}

set.display_name = set.TEXT[ set.lang ].SETTINGS;

set.components.push(
  new actor ({
    "base_col": [[99, 151, 184, 255], [99, 151, 184, 255]],
    "bg_image": [
      new gbox ({
	"width" : set.WIDTH,
	"height": set.HEIGHT,
	"color" :[0,0,0,255]
      }),
    ]
  })
);



set.createColorBox = function(width, height, color){
  var c = new container({});
  var b = null;
  var num = color.length;
  for(var i = 0; i<num; i++){
    b = new gbox ({});
    b.width = width;
    b.height = height/num;
    b.color = color[i];
    b.translate[1] = -height/2+height/num/2+i*height/num; 
    c.components.push(b);
  }
  set.components.push( c );

}( set.WIDTH, set.HEIGHT,
   [ [8, 17, 24,255], [0, 36, 72, 255], [51, 80, 109, 255] ]);



set.createLogoText = function( logo, title, width, height, font_size){
  set.components.push(
    new gimage ({
      "src": logo,
      "translate": [-140, 0.0, 0.0],
    })
  );
  set.components.push(
    new gtext ({
      "translate": [80.0, 0.0, 0.0],
      "width" : 340,
      "text": title,
      "font_name": "F015T-bold",
      "align": CENTER,
      "font_size": font_size,
    })
  );

}( path + "settings/viera-cast.png",
   set.TEXT[set.lang].SETTINGS,
   set.WIDTH, set.HEIGHT, set.TEXT[set.lang].SETTINGS_font_size );



//END
set;