//
// Copyright (C) 2008 Panasonic Corporation. All Rights Reserved.
//


//console.log ("install animation package");

function move_to (obj, src, dst, interval, total, comp_hook)
{
  var delta =
    [
      (dst[0] - src[0]) / total,
      (dst[1] - src[1]) / total,
      (dst[2] - src[2]) / total,
    ];
  obj.translate = src;
  append_timer (obj, interval,
		function (obj, count) {
		  if (count >= total) {
		    obj.translate = dst;
		    delete_timer (obj);
		    if (comp_hook)
		      comp_hook (obj);
		  } else {
		    obj.translate[0] += delta[0];
		    obj.translate[1] += delta[1];
		    obj.translate[2] += delta[2];
		  }
		  force_redraw ();
		});
}

function move_to_no_redraw (obj, src, dst, interval, total, comp_hook)
{
  var delta =
    [
      (dst[0] - src[0]) / total,
      (dst[1] - src[1]) / total,
      (dst[2] - src[2]) / total,
    ];
  obj.translate = src;
  append_timer (obj, interval,
		function (obj, count) {
		  if (count >= total) {
		    obj.translate = dst;
		    delete_timer (obj);
		    force_redraw ();
		    if (comp_hook)
		      comp_hook (obj);
		  } else {
		    obj.translate[0] += delta[0];
		    obj.translate[1] += delta[1];
		    obj.translate[2] += delta[2];
		  }
		});
}

function move_to_with_bg (obj, src, dst, bg_src, bg_dst, interval, total, comp_hook)
{
  var delta =
    [
      (dst[0] - src[0]) / total,
      (dst[1] - src[1]) / total,
      (dst[2] - src[2]) / total,
    ];
  var bg_delta =
    [
      (bg_dst[0] - bg_src[0]) / total,
      (bg_dst[1] - bg_src[1]) / total,
      (bg_dst[2] - bg_src[2]) / total,
    ];
  obj.translate = src;
  obj.bg_translate = bg_src;
  append_timer (obj, interval,
		function (obj, count) {
		  if (count >= total) {
		    obj.translate = dst;
		    delete_timer (obj);
		    if (comp_hook)
		      comp_hook (obj);
		  } else {
		    obj.translate[0] += delta[0];
		    obj.translate[1] += delta[1];
		    obj.translate[2] += delta[2];
		    obj.bg_translate[0] += bg_delta[0];
		    obj.bg_translate[1] += bg_delta[1];
		    obj.bg_translate[2] += bg_delta[2];
		  }
		  force_redraw ();
		});
}

function move_from_home_to_ytmain (obj, src, dst, interval, total, comp_hook)
{
  var delta =
    [
      (dst[0] - src[0]) / total,
      (dst[1] - src[1]) / total,
      (dst[2] - src[2]) / total,
    ];
  obj.translate = src;
  append_timer (obj, interval,
		function (obj, count) {

		  //console.log("count = " + count);
		  if (count >= (total - 30)) {
		    obj.translate = dst;
		    //console.log("");
		    delete_timer (obj);
		    if (comp_hook)
		      comp_hook (obj);
		  }else if(count >= (total - 43)){
		    obj.translate[0] += (delta[0] + 35);
		    obj.translate[1] += delta[1];
		    obj.translate[2] += (delta[2] + 70);

		  } else {
		    obj.translate[0] += (delta[0] + 20);
		    obj.translate[1] += delta[1];
		    obj.translate[2] += (delta[2] + 40);
		  }
		  force_redraw ();
		});
}


//function move_to_home_out_ytmain (obj, src, dst, interval, total, comp_hook)
function move_from_ytmain_to_home (obj, src, dst, interval, total, comp_hook)
{
  var delta =
    [
      (dst[0] - src[0]) / total,
      (dst[1] - src[1]) / total,
      (dst[2] - src[2]) / total,
    ];
  obj.translate = src;
  append_timer (obj, interval,
		function (obj, count) {
		  if (count >= (total - 40)) {
		    obj.translate = dst;
		    delete_timer (obj);
		    if (comp_hook)
		      comp_hook (obj);
//		  }else if(count >= (total - 25)){
//		    obj.translate[0] += delta[0];
//		    obj.translate[1] += delta[1];
//		    obj.translate[2] += delta[2];

		  } else {
		    obj.translate[0] += (delta[0] - 30);
		    obj.translate[1] += delta[1];
		    obj.translate[2] += (delta[2] - 110);

		  }
//		  force_redraw ();
		});
}

//function move_to_video_out_ytmain (obj, src, dst, interval, total, comp_hook)
function move_from_menu (obj, src, dst, interval, total, comp_hook)
{
  var delta =
    [
      (dst[0] - src[0]) / total,
      (dst[1] - src[1]) / total,
      (dst[2] - src[2]) / total,
    ];

  var position = total * 0.9;

  obj.translate = src;
  append_timer (obj, interval,
		function (obj, count) {
		  if (count >= total) {
		    obj.translate = dst;
		    delete_timer (obj);
		    if (comp_hook)
		      comp_hook (obj);
//		  }else if(count >= (total - 45)){
		  }else if(count >= (total - position)){
		    obj.translate[0] += (delta[0] - 150);
		    obj.translate[1] += delta[1];
		    obj.translate[2] += delta[2];
		  }

//		  force_redraw ();
		});
}

function move_to_menu (obj, src, dst, interval, total, comp_hook)
{
  var delta =
    [
      (dst[0] - src[0]) / total,
      (dst[1] - src[1]) / total,
      (dst[2] - src[2]) / total,
    ];
  obj.translate = src;
  append_timer (obj, interval,
		function (obj, count) {
		  if (count >= (total - 27)) {
		    obj.translate = dst;
		    delete_timer (obj);
		    if (comp_hook)
		      comp_hook (obj);
		  }else {
		    obj.translate[0] += (delta[0] + 35);
		    obj.translate[1] += delta[1];
		    obj.translate[2] += delta[2];
		  }
//		  force_redraw ();
		});
}

provide ("common_animation");
