//
// Copyright (C) 2008 Panasonic Corporation. All Rights Reserved.
//

var ES_DEMO = true;

add_stage_load_path ("es_main", 
		     path + "eurosport/es_main.js");

var es = new Icon({});

es.name = "eurosport";
es.display_name = "Eurosport";

// language and translations
es.TEXT = {
  "en-GB":{
    LOCKED: "Locked",
  },
  "en-IE":{
    LOCKED: "Locked",
  },
  "es-ES":{
    LOCKED: "Bloqueado",
  },
  "fr-FR":{
    LOCKED: "Bloqué",
  },
  "de-DE":{
    LOCKED: "Gesperrt",
  },
  "it-IT":{
    LOCKED: "Bloccato",
  },
};

es.lang = ureg.read("language");
if (!es.TEXT[ es.lang ]) {
  es.lang = "en-GB";
  console.log("[ES] cannot read \"language\" " + ureg.read("language") + 
	      ". use default \"" + es.lang + "\".");
}

add_package_load_path ("lang_eurosport", 
		       path + "eurosport/lang/pkg_lang_eurosport_" + 
		       es.lang + ".js");

// start GUI parts ///////////
es.isLeft = true; // modified by setTranslate, used for key handler ...
es.base_col = [99,  151, 184, 255];
es.HEIGHT_ROTATEGIMAGE = 142;

//[make lines GUI]
es.GUI = function() { 
  var tmp = null;
  tmp = new gbox ({
    "width": 64,  
    "height": 3, 
    "color": es.base_col,
    "translate": [-100,0,0]
  });
  es.components.push( tmp );
  tmp = new gbox ({
    "width": 3,  
    "height": 120, 
    "color": es.base_col,
    "translate": [-174,0,0]
  });
  es.components.push( tmp );
}();

//[make main GUI]
es.GUI = function(Logo) {
  es.main = new actor ({
    "translate": [ 78, 0, 0 ],
    "base_col": [es.base_col, es.base_col],
    "bg_image": [
      new gbox ({
	"width": 286, 
	"height": 286, 
	"color":[0, 24, 48, 255] 
      }),
      new gimage ({ 
	"src": Logo, 
	"translate":[0.0, 107.0, 0.0],
	"width": 286
      }),
      new gbox ({ 
	"width": 280, 
	"height": es.HEIGHT_ROTATEGIMAGE,
	"color": [0,0,0,255],  
	"translate": [0,-4,0]
      }),
      es.thumb = new RotateGimage (
	{"translate":[0,-4,0]}, 280, 
	es.HEIGHT_ROTATEGIMAGE, CIRCUMSCRIBED 
      ),
      es.title =  new gtextbox ({
	"translate": [0, -108, 0],
	"width": 280,
	"height": 64,
	"font_size": 26,
	"text": "",
	"align": LEFT,
	"margin": [0, 0, 8, 8],
	"margin_leading": -1,
      }),
    ]
  });  
  es.components.push( es.main);
}(path + "eurosport/286x74_esp_logo.png");

// [make minis GUI]
es.icon=[];
es.GUI = function(){
  for(var i=0; i<3; i++) {
    es.icon[i] = new actor ({
      "translate":[-174, 103*(1-i), 0],
      "base_col": [es.base_col, es.base_col],
      "bg_image": [
	new gbox ({
	  "width": 80,
	  "height": 80,
	  "color": [0, 0, 0, 255]
	}),
	new gimage ({
	  "src":   path + "common/not_found.png",
	  "width": 76,
	  "height": 76,
	  "draw_type": CIRCUMSCRIBED,
	})
      ]
    });
    es.components.push( es.icon[i] );
  }
}();

// end GUI parts ///////////

// [public]
es.setDimension = function( w, h, d ){
  // @TODO : w & h
  if( (d==null) || (d>=es.HEIGHT_ROTATEGIMAGE*2) ){
    this.thumb.visible_p = true;
  }else if( d < es.HEIGHT_ROTATEGIMAGE * 2 ){
    this.thumb.visible_p = false;
  }
}

// [public]
es.setTranslate = function(x,y,z) {
  if (typeof x == "number") {
    if(((x<0)&&(this.isLeft==false)) ||
       ((x>=0)&&(this.isLeft==true))){ // side switch
      for( var i=0 ; i<this.components.length ; i++ ){
	this.components[i].translate[0] *= -1;
      }
    }
    if( x < 0 ){
      this.isLeft = true;
    }else{
      this.isLeft = false;
    }
    this.translate[0] = x;
  }
  if (typeof y == "number") {
    this.translate[1] = y;
  }
  if (typeof z == "number") {
    this.translate[2] = z;
  }
}

// [private]
es.anim_num = -1;
if (ES_DEMO) {
  //es.IMAGE_PATH = "file:///nv/demo/";
  es.IMAGE_PATH = path;
} else {
  es.IMAGE_PATH = "http://i.eurosport.com";
}

// [private]
es.do_animation = function(anim_num){
  var num_big = anim_num % this.feed.data.length;
  var num = [
    (num_big + 1) % this.feed.data.length, 
    (num_big + 2) % this.feed.data.length, 
    (num_big + 3) % this.feed.data.length];
  
  if (this.feed.data[num_big].thumb_1) {
    this.thumb.setImage(this.IMAGE_PATH + this.feed.data[num_big].thumb_1);
  } else {
    this.thumb.setImage("");
  }
  setf_text(this.title, this.feed.data[num_big].title);
  for(var i=0; i<3; i++) {
    if (this.feed.data[num[i]].thumb_0) {
      this.icon[i].bg_image[1].src = this.IMAGE_PATH + this.feed.data[num[i]].thumb_0;
    } else {
      this.icon[i].bg_image[1].src = path + "common/not_found.png";
    }
  }
}

// [public]
es.animation = function( count ){
  if (!ES_DEMO) {
    if( (count==1) && (this.isReady()==true) ){
      this.anim_num++;
      this.do_animation (this.anim_num);
    }
    this.thumb.animation(count);
  }
}

// [private]
es.ready = false;

// [public]
es.isReady = function() {
  return this.ready;
}

// [private]
es.feed = new Object();
es.feed.data = null;
es.feed.http_req_id = -1;
es.feed.country = null;

// [private]
es.getFeed = function(data_url, data_obj) {

  // START DEMO MODE
  if (ES_DEMO) {
    data_obj.data = [
      {"id": 0,
       "thumb_1": "eurosport/demo/HS_D.png",
       "title": "IRC Madeira - Portugal -Vol.3-"},
      {"id": 0,
       "thumb_0": "eurosport/demo/HS_A.png"},
      {"id": 0,
       "thumb_0": "eurosport/demo/HS_B.png"},
      {"id": 0,
       "thumb_0": "eurosport/demo/HS_C.png"}
    ];  
    es.ready = true;
    this.anim_num = 0;
    es.do_animation (0);
    return;
  }
  // END DEMO MODE

  cancel_http_request( data_obj.http_req_id );
  data_obj.http_req_id = http_request ({
    "url": data_url,
    "method": "GET",
    "onload": function (status, header, body) {
      if (status == 200) {
	data_obj.data = eval("("+body.replace(/\u2028/g," ")+")");
	es.ready = true;
	es.anim_num = -1;
	es.animation (1);
      }
    },
    "sync": false,
  });
}

// [public]
es.init = function() {
  this.ready = false;

  var country_id;
  try {
    var country_flash = nvram[2].read ("es_country");
    var countrymap = {"UK": 0, "FR": 3, "DE": 1, "IT": 4, "ES": 6, "RU": 15};
    country_id = countrymap[country_flash];
    //console.log ("[ES] read country_id: " + country_id + " " + country_flash);
    if (country_flash == null || country_id == undefined ) {
      console.log ("[ES] set country_id 0 UK");
      country_id = 0; // UK
    }
  } catch (e) {
    console.log ("[ES] set country_id 0 UK");
    country_id = 0; // UK
  }
  
  if (country_id != this.feed.country) {
    this.feed.country = country_id;
    this.feed.data = null;
  }

  if (this.feed.data) {
    this.ready = true;
    return;
  } else {
    this.ready = false;
  }

  this.getFeed(
    MyHostName + "eurosport/videoshort.js," + this.feed.country + ",-1,-1,-1,-1,40",
    this.feed );

  this.thumb.setImage("");
}

// [public]
es.enter_stage = function() {
  this.init();
  this.thumb.visible_p = true;
  this.thumb.animation( 0 );
}

// [public]
es.leave_stage = function() {
  this.thumb.visible_p = false;
}

// [public]
es.enter_focus = function() {
  append_timer (es, 1000, function (obj, count) {
    delete_timer (obj);
    prepare_stage("es_main");
  });

  this.cursor = this.main;
  this.cursor.in_cursor = true;
}

// [public]
es.leave_focus = function() {
  delete_timer (es);
  discard_stage ("es_main");

  this.cursor.in_cursor = false;
  this.cursor = this.main;
}

// [public]
es.key_hook = function(up_down, key) {
  if (up_down != KEY_PRESS)
    return true;

  switch( key ){
  case TXK_UP:
    switch( this.cursor ){
    case this.main:
    case this.icon[0]:
      return false;
      
    case this.icon[1]:
      this.changeCursor( this.icon[0] );
      return true;
      
    case this.icon[2]:
      this.changeCursor( this.icon[1] );
      return true;
    }
    console.log("[ES] @@@ ERROR @@@ : illegal this.cursor");
    return false;

  case TXK_DOWN:
    switch( this.cursor ){
    case this.main:
    case this.icon[2]:
      return false;
    case this.icon[0]:
      this.changeCursor( this.icon[1] );
      return true;
    case this.icon[1]:
      this.changeCursor( this.icon[2] );
      return true;
    }
    console.log("[ES] @@@ ERROR @@@ : illegal this.cursor");
    return false;

  case TXK_LEFT:
    if( this.isLeft ){
      switch( this.cursor ){
      case this.main:
	this.changeCursor( this.icon[1] );
	return true;
      case this.icon[0]:
      case this.icon[1]:
      case this.icon[2]:
	return false;
      }
    }else{
      switch( this.cursor ){
      case this.main:
	return false;
      case this.icon[0]:
      case this.icon[1]:
      case this.icon[2]:
	this.changeCursor( this.main );
	return true;
      }
    }
    console.log("[ES] @@@ ERROR @@@ : illegal this.cursor");
    return false;

  case TXK_RIGHT:
    this.isLeft = !this.isLeft;
    var ret = this.key_hook( up_down, TXK_LEFT );
    this.isLeft = !this.isLeft;
    return ret;

  case TXK_ENTER:
    switch( this.cursor ){
    case this.main:
      this.start(0);
      break;
    case this.icon[0]:
      this.start(1);
      break;
    case this.icon[1]:
      this.start(2);
      break;
    case this.icon[2]:
      this.start(3);
      break;
    default:
      // Illegal
      return false;
    }
    return true;
  default:
    return false;
  }
  return false;
}

// [private]
es.changeCursor = function(to) {
  this.cursor.in_cursor = false;
  this.cursor = to;
  this.cursor.in_cursor = true;
}

// [private]
es.start = function(offset) {
  delete_timer (es);
  var id = 0;
  try {
    var offset = (this.anim_num+offset) % this.feed.data.length;
    var id = this.feed.data[offset].id;
  } catch (e) {
    console.log("[ES] get video id for offset " + offset + " failed: " + e);
  }   
  try {
    var ret = ureg.read("eurosport_video_id");
    if (typeof ret == "undefined"){
      ureg.RegisterApp("eurosport_video_id");
    }
    ureg.write( "eurosport_video_id", id.toString() );
    on_stage( "es_main" );
  } catch (e) {
    console.log("[ES] launch failed: " + e);
  }
}

//// END
es;

