//
// Copyright (C) 2008 Panasonic Corporation. All Rights Reserved.
//


var coming = new Icon({});

coming.name = "coming_soon_bottom";
coming.isLeft = true;

coming.gray = [44,44,44,255];
coming.bg_col = [0,24,48,255];
coming.base_col = coming.gray;
coming.TEXT = {
  "en-US" : {
    "TITLE" : "COMING SOON",
    "DISPLAY_NAME" : "COMING SOON",
  },
  "es-US" : {
    "TITLE" : "Próximamente",
    "DISPLAY_NAME" : "Próximamente",
  },
  "fr-CA" : {
    "TITLE" : "BIENTÔT DISPONIBLE",
    "DISPLAY_NAME" : "BIENTÔT DISPONIBLE",
  },
  "en-GB" : {
    "TITLE" : "COMING SOON",
    "DISPLAY_NAME" : "COMING SOON",
  },
  "hu-HU" : {
    "TITLE" : "HAMAROSAN JÖN",
    "DISPLAY_NAME" : "HAMAROSAN JÖN",
  },
  "hr-HR" : {
    "TITLE" : "USKORO",
    "DISPLAY_NAME" : "USKORO",
  },
  "cs-CZ" : {
    "TITLE" : "BRZY UVIDÍTE",
    "DISPLAY_NAME" : "BRZY UVIDÍTE",
  },
  "ru-RU" : {
    "TITLE" : "СКОРО",
    "DISPLAY_NAME" : "СКОРО",
  },
  "bg-BG" : {
    "TITLE" : "ПРЕДСТОЯЩО",
    "DISPLAY_NAME" : "ПРЕДСТОЯЩО",
  },
  "ro-RO" : {
    "TITLE" : "ÎN CURÂND",
    "DISPLAY_NAME" : "ÎN CURÂND",
  },
  "sk-SK" : {
    "TITLE" : "UŽ ČOSKORO",
    "DISPLAY_NAME" : "UŽ ČOSKORO",
  },
  "sl-SL" : {
    "TITLE" : "Kmalu tudi pri vas",
    "DISPLAY_NAME" : "Kmalu tudi pri vas",
  },
  "pl-PL" : {
    "TITLE" : "DOSTĘPNE WKRÓTCE",
    "DISPLAY_NAME" : "DOSTĘPNE WKRÓTCE",
  },
  "sr-YU" : {
    "TITLE" : "USKORO",
    "DISPLAY_NAME" : "USKORO",
  },
  "de-DE" : {
    "TITLE" : "BALD ERHÄLTLICH",
    "DISPLAY_NAME" : "BALD ERHÄLTLICH",
  },
  "es-ES" : {
    "TITLE" : "PRÓXIMAMENTE",
    "DISPLAY_NAME" : "PRÓXIMAMENTE",
  },
  "nl-NL" : {
    "TITLE" : "BINNENKORT",
    "DISPLAY_NAME" : "BINNENKORT",
  },
  "no-NO" : {
    "TITLE" : "KOMMER SNART",
    "DISPLAY_NAME" : "KOMMER SNART",
  },
  "fi-FI" : {
    "TITLE" : "TULOSSA PIAN",
    "DISPLAY_NAME" : "TULOSSA PIAN",
  },
  "fr-FR" : {
    "TITLE" : "PROCHAINE SORTIE ",
    "DISPLAY_NAME" : "PROCHAINE SORTIE ",
  },
  "da-DK" : {
    "TITLE" : "KOMMER SNART",
    "DISPLAY_NAME" : "KOMMER SNART",
  },
  "tr-TR" : {
    "TITLE" : "YAKINDA GELİYOR",
    "DISPLAY_NAME" : "YAKINDA GELİYOR",
  },
  "it-IT" : {
    "TITLE" : "PROSSIMAMENTE",
    "DISPLAY_NAME" : "PROSSIMAMENTE",
  },
  "sv-SE" : {
    "TITLE" : "KOMMER SNART",
    "DISPLAY_NAME" : "KOMMER SNART",
  },
  "pt-PT" : {
    "TITLE" : "EM BREVE",
    "DISPLAY_NAME" : "EM BREVE",
  },
  "el-GR" : {
    "TITLE" : "Προσεχώς",
    "DISPLAY_NAME" : "Προσεχώς",
  },
  "et-EE" : {
    "TITLE" : "TULEKUL",
    "DISPLAY_NAME" : "TULEKUL",
  },
  "lv-LV" : {
    "TITLE" : "Drīzumā",
    "DISPLAY_NAME" : "Drīzumā",
  },
  "lt-LT" : {
    "TITLE" : "JAU GREITAI",
    "DISPLAY_NAME" : "JAU GREITAI",
  },
}
coming.TEXT[ "en-GB" ] = coming.TEXT[ "en-US" ];
coming.TEXT[ "en-IE" ] = coming.TEXT[ "en-US" ];
coming.TEXT[ "es-ES" ] = coming.TEXT[ "es-US" ];
coming.TEXT[ "fr-FR" ] = coming.TEXT[ "fr-CA" ];

coming.lang = ureg.read("language");
if( !coming.TEXT[ coming.lang ]){
  console.log("[CS] cannot read \"language\" " + coming.lang + " . use default \"en-US\".");
  coming.lang = "en-US";
}

coming.display_name = coming.TEXT[ coming.lang ].DISPLAY_NAME;

// start GUI parts ///////////
coming.GUI = function(){ // [lines]
  var tmp = null;

  tmp = new gbox ({
    "width": 64,  "height": 3, "color": coming.base_col,
    "translate": [-100,0,0]});
  coming.components.push( tmp );

  tmp = new gbox ({
    "width": 3,  "height": 120, "color": coming.base_col,
    "translate": [-174,0,0]});
  coming.components.push( tmp );

}();


coming.GUI = function( Logo, text ){// [main]
  coming.main = new actor ({
    "base_col": [ coming.base_col, coming.base_col ],
    "translate":[78,0,0],
    "bg_image": [
      new gbox ({
	"width": 286,	"height": 286,
	"color": coming.bg_col,
      }),
      new gimage ({
	"src": Logo,	"translate": [0.0, 107.0, 0.0],
	"width": 286,
      }),
      new gbox ({
	"width": 280,	"height": 142,
	"color": [28, 47, 67, 255],
	"translate": [0.0, -4.0, 0.0],
      }),
      new gtextbox ({
	"translate": [0.0, 107.0, 0.0],
	"text": text,
	"color": [33,33,33,255],
	"width": 220,	"height": 140,
	"font_size": 27,
	"align": CENTER,
        "valign" : MIDDLE,
	"font_name": "F015T-bold",
      }),
    ],
  });
  coming.components.push( coming.main );

}( path + coming.name + "/Coming-Logo-back.png",
   coming.TEXT[coming.lang].TITLE );





coming.icon=[];
coming.GUI = function(){// [minis]
  for( var i=0 ; i<3 ; i++ ){
    coming.icon[i] =new actor ({
      "translate": [ -174, 103*(1-i), 0 ],
      "base_col": [ coming.gray, coming.gray ],
      "bg_image": [
	new gbox ({ "width": 80, "height":80, "color":[ 0, 24, 48, 255] }),
	new gbox ({ "width": 76, "height":76, "color":[44, 44, 44, 255] }),
	new gbox ({ "width":  8, "height":35, "color":[71, 71, 71, 255] }),
	new gbox ({ "width": 35, "height": 8, "color":[71, 71, 71, 255] }),
      ],
    });

    coming.components.push( coming.icon[i] );
  }
}();

// end GUI parts ///////////



coming.setTranslate = function(x,y,z){
  if( typeof x == "number" ){
    if( ((x<0)&&(this.isLeft==false)) ||
	((x>=0)&&(this.isLeft==true)) ){ // side switch
      for( var i=0 ; i<this.components.length ; i++ ){
	this.components[i].translate[0] *= -1;
      }
    }
    if( x < 0 ){
      this.isLeft = true;
    }else{
      this.isLeft = false;
    }
    this.translate[0] = x;
  }
  if( typeof y == "number" ){
    this.translate[1] = y;
  }
  if( typeof z == "number" ){
    this.translate[2] = z;
  }
}


coming.enter_focus = function(){
  this.cursor = this.main;
  this.cursor.in_cursor = true;
}
coming.leave_focus = function(){
  this.cursor.in_cursor = false;
  this.cursor = this.main;
}


coming.key_hook = function( up_down, key ){
  if (up_down != KEY_PRESS)
    return true;

  switch( key ){
  case TXK_UP:
    switch( this.cursor ){
    case this.main:
    case this.icon[0]:
      return false;
      
    case this.icon[1]:
      this.changeCursor( this.icon[0] );
      return true;
      
    case this.icon[2]:
      this.changeCursor( this.icon[1] );
      return true;
    }
    console.log("@@@ ERROR @@@ : illegal this.cursor");
    return false;

  case TXK_DOWN:
    switch( this.cursor ){
    case this.main:
    case this.icon[2]:
      return false;
    case this.icon[0]:
      this.changeCursor( this.icon[1] );
      return true;
    case this.icon[1]:
      this.changeCursor( this.icon[2] );
      return true;
    }
    console.log("@@@ ERROR @@@ : illegal this.cursor");
    return false;

  case TXK_LEFT:
    if( this.isLeft ){
      switch( this.cursor ){
      case this.main:
	//this.changeCursor( this.icon[1] );
	return true;
      case this.icon[0]:
      case this.icon[1]:
      case this.icon[2]:
	return false;
      }
    }else{
      switch( this.cursor ){
      case this.main:
	return false;
      case this.icon[0]:
      case this.icon[1]:
      case this.icon[2]:
	this.changeCursor( this.main );
	return true;
      }
    }
    console.log("@@@ ERROR @@@ : illegal this.cursor");
    return false;

  case TXK_RIGHT:
    this.isLeft = !this.isLeft;
    var ret = this.key_hook( up_down, TXK_LEFT );
    this.isLeft = !this.isLeft;
    return ret;

  default:
    return false;
  }
  return false;
}


// [private]
coming.changeCursor = function( to ){
  this.cursor.in_cursor = false;
  this.cursor = to;
  this.cursor.in_cursor = true;
}


//// END
coming;

