(load "/usr/local/slisp/station.lsp")(defvar svl-key nil)(defvar tsl-key nil)(defvar dig-owner nil)(defvar initial t)(defvar market nil)(defvar with-freesat nil)(defvar with-dvb-s-cont nil)(defvar with-hk-tuner nil)(defvar with-satip nil)(defvar delay-time 10000)(defvar dish-param-1 nil)(defvar dish-param-2 nil)(defvar dish-param-3 nil)(defvar dish-param-4 nil)(defvar dish-band-control-param nil)(defvar with-dvb-ci nil)(defvar use-new-tsport nil)(defvar bootup t)(defvar single-tuner-mode nil)(defvar tuner-sleep-time 1000)(defvar sub-avail nil)(defvar end-tune-around nil)(defvar systime-available nil)(register-device 'tvp
"tvp"
(get-default-prio)
#'(lambda (sig)))(register-device 'tvp-atnr0
"atnr0"
(get-default-prio)
#'(lambda (sig)(case sig
(AVAILABLE
(set-timer #'(lambda (arg)(write-bytes msg-fd 3))
'atnr0-delay-timer
nil
1
delay-time))(LOST
(write-bytes msg-fd 2)(cancel-timer 'atnr0-delay-timer)))))(register-device 'tvp-atnr1
"atnr1"
(get-default-prio)
#'(lambda (sig)(case sig
(AVAILABLE
(set-timer #'(lambda (arg)(write-bytes msg-fd 5))
'atnr1-delay-timer
nil
1
delay-time))(LOST
(write-bytes msg-fd 4)(cancel-timer 'atnr1-delay-timer)))))(register-device 'tvp-ds-main
"display"
(get-default-prio)
#'(lambda (sig)(case sig
(AVAILABLE
(set-timer #'(lambda (arg)(display-mute 'tvp-ds-main))
'ds-delay-timer
nil
1
delay-time))(LOST
(cancel-timer 'ds-delay-timer)))))(register-device 'tvp-sp
"speaker"
(get-default-prio)
#'(lambda (sig)(case sig
(AVAILABLE
(set-timer #'(lambda (arg)(soundout-mute 'tvp-sp))
'sp-delay-timer
nil
1
delay-time))(LOST
(cancel-timer 'sp-delay-timer)))))(register-device 'tvp-hp
"headphone0"
(get-default-prio)
#'(lambda (sig)(case sig
(AVAILABLE
(set-timer #'(lambda (arg)(soundout-mute 'tvp-hp))
'hp-delay-timer
nil
1
delay-time))(LOST
(cancel-timer 'hp-delay-timer)))))(register-device 'tvp-monout
"monitorout"
(get-default-prio)
#'(lambda (sig)(case sig
(AVAILABLE
(set-timer #'(lambda (arg)(monitorout-mute 'tvp-monout))
'monout-delay-timer
nil
1
delay-time))(LOST
(cancel-timer 'monout-delay-timer)))))(register-device 'tvp-scart0
"scart0"
(get-default-prio)
#'(lambda (sig)(case sig
(AVAILABLE
(set-timer #'(lambda (arg)(monitorout-mute 'tvp-scart0))
'scart0-delay-timer
nil
1
delay-time))(LOST
(cancel-timer 'scart0-delay-timer)))))(register-device 'tvp-scart1
"scart1"
(get-default-prio)
#'(lambda (sig)(case sig
(AVAILABLE
(set-timer #'(lambda (arg)(monitorout-mute 'tvp-scart1))
'scart1-delay-timer
nil
1
delay-time))(LOST
(cancel-timer 'scart1-delay-timer)))))(register-device 'tvp-scart2
"scart2"
(get-default-prio)
#'(lambda (sig)(case sig
(AVAILABLE
(set-timer #'(lambda (arg)(monitorout-mute 'tvp-scart2))
'scart2-delay-timer
nil
1
delay-time))(LOST
(cancel-timer 'scart2-delay-timer)))))(register-device 'tvp-optout
"optical-output"
(get-default-prio)
#'(lambda (sig)(case sig
(AVAILABLE
(set-timer #'(lambda (arg)(optical-output-mute 'tvp-optout))
'optout-delay-timer
nil
1
delay-time))(LOST
(cancel-timer 'optout-delay-timer)))))(register-device 'tsport
"tsport"
(get-default-prio)
#'(lambda (sig)(case sig
(LOST
(set-owner 'tsport nil))(AVAILABLE
(set-owner 'tsport t)(make-event 'tsport-available))(SOURCE_CHANGE
(when (device-source-p 'tsport 'tuner)(set-tuning-tsl-key (tuner-tsl-key 'tuner)))(tsl-query (get-tuning-tsl-key) 'onid 'tsid 'ntype 'ya_nid 'physical_ch)(make-event 'tuner-req)(make-event 'tsport-change)))))(register-node 'tuner-message
#'(lambda ()
t)
#'(lambda ()(let ((param))(setf param (if (eq (tsl-get-data (get-tuning-tsl-key) 'ntype) 1)(tsl-get-data (get-tuning-tsl-key) 'onid 'tsid 'ya_nid 'ntype)(tsl-get-data (get-tuning-tsl-key) 'onid 'tsid 'physical_ch 'ntype)))(when (and (nth 0 param) (nth 1 param) (nth 2 param) (nth 3 param))(write-bytes msg-fd 6 param))))
#'(lambda ()(write-bytes msg-fd 7 )))(defvar tuning-tuner 'tuner)(defun set-tuning-tuner (dev)(setf tuning-tuner dev))(defun get-tuning-tuner ()
tuning-tuner)(register-node 'my-tuner-freq-valid
#'(lambda ()(tsl-equal (get-tuning-tsl-key) (get-tuner-tsl-key (get-tuning-tuner))))
#'(lambda ()(set-tuning-tuner 'tuner)(set-tuner-tsl-key (get-tuning-tuner) (get-tuning-tsl-key))(eval-events (list 'tuner-req 'tuner-change)))
#'(lambda ()
nil))(register-node 'my-tuner-connect
#'(lambda ()(tuner-status (get-tuning-tuner)))
#'(lambda ()(cancel-timer 'tuner-sleep-timer)(if (or (and (not initial))(and single-tuner-mode
(not initial)(owner-p 'tuner)(not sub-avail)(eq (tsl-get-data (get-tuning-tsl-key) 'ntype) n-type-dvb-s)))(progn
(set-tuner-tsl-key (get-tuning-tuner) (tuner-tsl-key (get-tuning-tuner)))(tsl-query (get-tuning-tsl-key) 'onid 'tsid 'ntype 'ya_nid 'physical_ch))(unless (tuner-connect (get-tuning-tuner)
:tsl (get-tuner-tsl-key (get-tuning-tuner)))(set-tuner-tsl-key (get-tuning-tuner) (tuner-tsl-key (get-tuning-tuner)))(tsl-query (get-tuning-tsl-key) 'onid 'tsid 'ntype 'ya_nid 'physical_ch)))(eval-events (list (list 'tuner-lock (get-tuning-tuner))(list 'tuner-unlock (get-tuning-tuner))(list 'tuner-disconnect (get-tuning-tuner)))))
#'(lambda ()(tuner-disconnect (get-tuning-tuner))))(register-node 'my-tsport-connect
#'(lambda ()(device-source-p 'tsport (get-tuning-tuner)))
#'(lambda ()(tsport-connect 'tsport (get-tuning-tuner))(eval-events (list 'tsport-available 'tsport-change)))
#'(lambda ()
nil))(register-node 'initial-tune
#'(lambda ()
initial)
#'(lambda ()(eval-events (list 'initial-done)))
#'(lambda ()
nil))(defun set-market (m)(setf market m)(if (eq market 'EUROPE_ASIA)(progn
(let (tdev)(setf tdev (list "ttuner"))(when (or with-freesat with-dvb-s-cont)(setf-cdr (last tdev) (cons "stuner" nil)))(when with-satip
(setf-cdr (last tdev) (cons "siptuner" nil)))(tuner-config 'tuner tdev)))(if (eq market 'US)(tuner-config 'tuner "ibtuner")))(my-device-open 'psi 0)(if use-new-tsport
(tsport-config 'tsport "FE_IN1")(if (or with-freesat with-dvb-s-cont)(tsport-config 'tsport (list "FE_IN1" "FE_IN2"))(if with-hk-tuner
(tsport-config 'tsport "FE_IN2")(tsport-config 'tsport "FE_IN1"))))(my-device-open 'tsport "tsi0")(if use-new-tsport
(my-device-open 'tuner 0)(my-device-open 'tuner (if with-hk-tuner 1 0)))(init-tuner-object 'tuner)(set-tuner-hook 'tuner #'(lambda (sig)(case sig
((AVAILABLE)(set-owner 'tuner t)(when (or end-tune-around systime-available)(tuner-sleep-mode-on)))((LOST)(set-owner 'tuner nil)(cancel-timer 'tuner-sleep-timer))(TUNER_LOCK
(make-event (list 'tuner-lock 'tuner)))(TUNER_UNLOCK
(make-event (list 'tuner-unlock 'tuner)))(TUNER_DISCONNECT
(make-event (list 'tuner-disconnect 'tuner)))(TUNER_LNB_SHORT
(make-event (list 'tuner-short-lnb 'tuner)))(PROPERTY_CHANGE
(when (eq (get-tuning-tuner) 'tuner)(set-tuning-tsl-key (tuner-tsl-key 'tuner))(tsl-query (get-tuning-tsl-key) 'onid 'tsid 'ntype 'ya_nid 'physical_ch)(make-event 'tuner-req))))))(init-section-object 'pat)(init-section-object 'pmt)(when with-hk-tuner
(set-section-filter 'pat (list #xFF #x80 #xFF #xFF #xFF #x01))(set-section-mask 'pat (list #xFF #x7F #xFF #xFF #xFF #xFE))(set-section-filter 'pmt (list #xFF #x80 #xFF #xFF #xFF #x01))(set-section-mask 'pmt (list #xFF #x7F #xFF #xFF #xFF #xFE)))(init-psi-object 'psi #'(lambda (pmt)))(when (eq market 'EUROPE_ASIA)(device-open 'cp nil)(cp-host 'cp)(device-open 'tvp nil))(append-t
'my-tuner-freq-valid
'my-tuner-connect
'my-tsport-connect
'initial-tune
'pat-request
'pmt-pid-valid
'pmt-request)(append-t
'my-tsport-connect
'tuner-message)(when (or with-freesat with-dvb-s-cont)(when with-freesat
(sat-init 1))(when with-dvb-s-cont
(sat-init 0)))(resource-node 'mini_sh-resource (list 'tuner 'tsport))(append-t
'mini_sh-resource
'resource-action)(register-node 'resource-action
#'(lambda ()
t)
#'(lambda ()(setf dig-owner t)(start-delay-event-digital))
#'(lambda ()(setf dig-owner nil)(when initial
(setf initial nil)(make-event 'initial-done))(set-tuning-tsl-key (get-tuner-tsl-key 'tuner))(set-tuning-tsid (tsl-get-data (get-tuning-tsl-key) 'tsid))(eval-node 'my-tuner-freq-valid)(write-bytes msg-fd 0)))(eval-node 'mini_sh-resource))(defun pal-digital-tune (sym onid tsid svcid)(when dig-owner
(setf svl-key (svl-create-key sym
:onid onid
:tsid tsid
:svcid svcid))(setf tsl-key (svl-create-key "TSL"
:physical_ch (svl-get-data svl-key 'physical_ch)
:onid onid
:tsid tsid))(set-tuning-tsl-key tsl-key)(set-tuning-tsid tsid)(set-tuning-svcid svcid)(eval-node 'my-tuner-freq-valid)))(defun pal-sat-tune (sym onid tsid svcid ch)(when dig-owner
(setf svl-key (svl-create-key sym
:onid onid
:tsid tsid
:svcid svcid
:physical_ch ch))(setf tsl-key (svl-create-key "TSL"
:physical_ch ch
:onid onid
:tsid tsid))(set-tuning-tsl-key tsl-key)(set-tuning-tsid tsid)(set-tuning-svcid svcid)(eval-node 'my-tuner-freq-valid)))(defun pal-analog-tune (sym pos)(setf svl-key (svl-create-key sym
:major_channel pos))(setf tsl-key (svl-create-key "TSL"
:physical_ch (svl-get-data svl-key 'physical_ch)
:offset (svl-get-data svl-key 'offset))))(defun us-initial-tune (sym ch svcid)(when dig-owner
(setf svl-key (svl-create-key sym
:physical_ch ch
:svcid svcid))(setf tsl-key (svl-create-key "TSL"
:ntype nil
:physical_ch ch))(when (find (svl-get-data svl-key 'ntype) (list 10 11 12))(set-tuning-tsl-key tsl-key)(set-tuning-svcid svcid)(eval-node 'my-tuner-freq-valid))))(defun initial-tune (sym arg)(when initial
(if (eq market 'EUROPE_ASIA)(if (eq (length arg) 3)(pal-digital-tune sym (first arg) (second arg) (third arg))(if (eq (length arg) 4)(pal-sat-tune sym (first arg) (second arg) (third arg) (fourth arg))(pal-analog-tune sym (first arg))))(if (and (eq market 'US) (eq (length arg) 2))(us-initial-tune sym (first arg) (second arg))))))(defun pal-ts-tune (onid tsid ch)(when dig-owner
(setf tsl-key (svl-create-key "TSL"
:physical_ch ch
:onid onid
:tsid tsid))(set-tuning-tsl-key tsl-key)(set-tuning-tsid tsid)(set-tuning-svcid nil)(eval-node 'my-tuner-freq-valid)))(defun pal-freq-tune (freq band-width)(when dig-owner
(cancel-timer 'tuner-sleep-timer)(tuner-connect 'tuner
:freq freq
:band-width band-width)))(defun pal-analog-freq-tune (freq)(let ((prop))(setf prop (atnr-property atnr-prop))(setf (atnr-prop-tune-type prop) "normal")(setf (atnr-prop-tune-param0-vfreq prop) freq)(setf (atnr-prop-tune-param0-offset prop) 0)(setf (atnr-prop-wnd-srch-mode prop) 0)(setf (atnr-prop-scan-mode prop) 0)(tvp-load 'tvp)(atnr-set 'tvp-atnr0 prop)(tvp-sync 'tvp)))(defun pal-analog-freq-tune2 (freq)(let ((prop))(setf prop (atnr-property atnr-prop))(setf (atnr-prop-tune-type prop) "normal")(setf (atnr-prop-tune-param0-vfreq prop) freq)(setf (atnr-prop-tune-param0-offset prop) 0)(setf (atnr-prop-wnd-srch-mode prop) 0)(setf (atnr-prop-scan-mode prop) 0)(tvp-load 'tvp)(atnr-set 'tvp-atnr1 prop)(tvp-sync 'tvp)))(defun start-delay-event-digital ()(cancel-timer 'delay-event-digital-available)(set-timer #'(lambda (arg)(when dig-owner
(write-bytes msg-fd 1)))
'delay-event-digital-available
nil
1
delay-time))(defun start-delay-event-analog1 (dev)(cancel-timer 'delay-event-analog1-available)(set-timer #'(lambda (arg)(when (owner-p arg)(write-bytes msg-fd 3)))
'delay-event-analog1-available
dev
1
delay-time))(defun start-delay-event-analog2 (dev)(cancel-timer 'delay-event-analog2-available)(set-timer #'(lambda (arg)(when (owner-p arg)(write-bytes msg-fd 5)))
'delay-event-analog2-available
dev
1
delay-time))(defun tuner-sleep-mode-on ()(cancel-timer 'tuner-sleep-timer)(set-timer #'(lambda (arg)(when (owner-p 'tuner)(tuner-sleep-tuner 'tuner)))
'tuner-sleep-timer
nil
1
tuner-sleep-time))(defun change-my-prio (prio)(my-device-priority 'tuner prio)(my-device-priority 'psi prio)(my-device-priority 'tsport prio))(defvar dish-param nil)(defun dish-band-control-manual ()(setf dish-band-control-param t)(tuner-setup 'tuner
:dish-band-control dish-band-control-param))(defun dish-setup (low high tone-en)(unless (and (eq low (nth 0 dish-param))(eq high (nth 1 dish-param))(eq tone-en (nth 2 dish-param)))(setf dish-param (list low high tone-en))(tuner-setup 'tuner
:dish-low low
:dish-high high
:dish-tone-en tone-en)(make-event (list 'tuner-unlock 'tuner))))(defun dish-setup-c (sat low high tone-en)(when (eq sat 0)(unless (and (eq low (nth 0 dish-param-1))(eq high (nth 1 dish-param-1))(eq tone-en (nth 2 dish-param-1)))(setf dish-param-1 (list low high tone-en))))(when (eq sat 1)(unless (and (eq low (nth 0 dish-param-2))(eq high (nth 1 dish-param-2))(eq tone-en (nth 2 dish-param-2)))(setf dish-param-2 (list low high tone-en))))(when (eq sat 2)(unless (and (eq low (nth 0 dish-param-3))(eq high (nth 1 dish-param-3))(eq tone-en (nth 2 dish-param-3)))(setf dish-param-3 (list low high tone-en))))(when (eq sat 3)(unless (and (eq low (nth 0 dish-param-4))(eq high (nth 1 dish-param-4))(eq tone-en (nth 2 dish-param-4)))(setf dish-param-4 (list low high tone-en))))(tuner-setup 'tuner
:satellite sat
:dish-low low
:dish-high high
:dish-tone-en tone-en)(make-event (list 'tuner-unlock 'tuner)))(defvar f-pmt-list nil)(defvar f-pmt-svcid nil)(defvar f-pmt-pid nil)(defvar tot-pid nil)(defun sat-init (freesat)(if (= freesat 1)(progn
(when dish-param
(tuner-setup 'tuner
:dish-low (nth 0 dish-param)
:dish-high (nth 1 dish-param)
:dish-tone-en (nth 2 dish-param))))(progn
(when dish-band-control-param
(tuner-setup 'tuner
:dish-band-control dish-band-control-param))(when dish-param-1
(tuner-setup 'tuner
:satellite 0
:dish-low (nth 0 dish-param-1)
:dish-high (nth 1 dish-param-1)
:dish-tone-en (nth 2 dish-param-1)))(when dish-param-2
(tuner-setup 'tuner
:satellite 1
:dish-low (nth 0 dish-param-2)
:dish-high (nth 1 dish-param-2)
:dish-tone-en (nth 2 dish-param-2)))(when dish-param-3
(tuner-setup 'tuner
:satellite 2
:dish-low (nth 0 dish-param-3)
:dish-high (nth 1 dish-param-3)
:dish-tone-en (nth 2 dish-param-3)))(when dish-param-4
(tuner-setup 'tuner
:satellite 3
:dish-low (nth 0 dish-param-4)
:dish-high (nth 1 dish-param-4)
:dish-tone-en (nth 2 dish-param-4)))))(register-section 'f-pat
#'(lambda (data)(let ((ptr) (svcid nil) (pid nil))(setf f-pmt-list nil)(mapcar #'(lambda (sec)(setf ptr (nthcdr 8 sec))(do ((x 8 (+ x 4)))((> x (length sec)))(setf svcid (+ (* (first ptr) #x100) (second ptr)))(unless (eq svcid 0)(setf pid (+ (* (logand (third ptr) #x1F) #x100) (fourth ptr)))(if f-pmt-list
(unless (assoc svcid f-pmt-list)(setf-cdr (last f-pmt-list) (cons (list svcid pid) nil)))(setf f-pmt-list (cons (list svcid pid) nil))))(setf ptr (nthcdr 4 ptr))))
data)(setf f-pmt-svcid (first (nth 0 f-pmt-list)))(setf f-pmt-pid (second (nth 0 f-pmt-list)))(set-section-valid 'f-pat t)(make-event 'f-pat-valid)(make-event 'f-pmt-req))))(register-section 'f-pmt
#'(lambda (data)(let ((ptr) (len) (stype) (espid) (tag nil) (pid nil) (private))(mapcar #'(lambda (sec)(setf ptr (nthcdr 12 sec))(setf len (+ (* (logand (nth 10 sec) #xF) #x100) (nth 11 sec)))(setf private nil)(do ((x 0))((>= x len))(case (car ptr)(#x5F
(when (and (eq (nth 1 ptr) 4)(eq (nth 2 ptr) #x46)(eq (nth 3 ptr) #x53)(eq (nth 4 ptr) #x41)(eq (nth 5 ptr) #x54))(setf private t)))(#xD0
(do ((y 0))((or (>= y (nth 1 ptr)) tag))(when (or (eq (nth (+ 2 y) ptr) 5)(eq (nth (+ 2 y) ptr) 6))(setf tag (nth (+ 3 y) ptr)))(setf y (+ y 2))))(otherwise
))(setf x (+ x 2 (nth 1 ptr)))(setf ptr (nthcdr (+ 2 (nth 1 ptr)) ptr)))(unless private
(setf tag nil))(do ((z 0))((or (>= 4 (length ptr)) pid))(setf stype (nth 0 ptr))(setf espid (+ (* (logand (nth 1 ptr) #x1F) #x100) (nth 2 ptr)))(setf len (+ (* (logand (nth 3 ptr) #xF) #x100) (nth 4 ptr)))(setf ptr (nthcdr 5 ptr))(if (not (eq stype 5))(setf ptr (nthcdr len ptr))(setf private nil)(do ((x 0))((or (>= x len) (and private pid)))(case (car ptr)(#x5F
(when (and (eq (nth 1 ptr) 4)(eq (nth 2 ptr) #x46)(eq (nth 3 ptr) #x53)(eq (nth 4 ptr) #x41)(eq (nth 5 ptr) #x54))(setf private t)))(#xD1
(unless tag
(do ((y 0))((or (>= y (nth 1 ptr)) pid))(when (or (eq (nth (+ 2 y) ptr) 5)(eq (nth (+ 2 y) ptr) 6))(setf pid espid))(setf y (+ y 1)))))(#x52
(when (and tag (eq tag (nth 2 ptr)))(setf pid espid)(setf private t)))(otherwise))(setf x (+ x 2 (nth 1 ptr)))(setf ptr (nthcdr (+ 2 (nth 1 ptr)) ptr)))(unless private
(setf pid nil)))))
data)(when (and pid (not (eq pid tot-pid)))(setf tot-pid pid)(write-bytes msg-fd 8 tot-pid)))(set-section-valid 'f-pmt t)))(init-section-object 'f-pat)(set-section-pid 'f-pat 0)(setf (nth 0 (get-section-filter 'f-pat)) 0)(setf (nth 0 (get-section-mask 'f-pat)) 0)(init-section-object 'f-pmt)(setf (nth 0 (get-section-filter 'f-pmt)) 2)(setf (nth 0 (get-section-mask 'f-pmt)) 2)(register-node 'is-freesat
#'(lambda ()(and (eq (tsl-get-data (get-tuning-tsl-key) 'ntype) 1)(eq (tsl-get-data (get-tuning-tsl-key) 'ya_nid) #x3b)))
#'(lambda ())
#'(lambda ()))(register-node 'f-pat-request
#'(lambda ()(get-section-valid 'f-pat))
#'(lambda ()(unless (get-section-valid 'f-pat)(section-open 'f-pat)(section-disable 'f-pat)(section-filter 'f-pat
:type "version"
:source 'tsport
:pid (get-section-pid 'f-pat)
:length (get-section-length 'f-pat)
:filter (get-section-filter 'f-pat)
:mask (get-section-mask 'f-pat)
:elength (get-section-elength 'f-pat)
:efilter (get-section-efilter 'f-pat)
:emask (get-section-emask 'f-pat))(section-enable 'f-pat))(eval-events (list 'f-pat-valid)))
#'(lambda ()(section-close 'f-pat)(set-section-valid 'f-pat nil)))(register-node 'f-pmt-pid-valid
#'(lambda ()(and f-pmt-pid f-pmt-svcid
(eq f-pmt-pid (get-section-pid 'f-pmt))(eq (/ f-pmt-svcid #x100) (nth 3 (get-section-filter 'f-pmt)))(eq (logand f-pmt-svcid #xFF) (nth 4 (get-section-filter 'f-pmt)))))
#'(lambda ()(when f-pmt-pid
(set-section-pid 'f-pmt f-pmt-pid))(when f-pmt-svcid
(setf (nth 3 (get-section-filter 'f-pmt)) (/ f-pmt-svcid #x100))(setf (nth 3 (get-section-mask 'f-pmt)) 0)(setf (nth 4 (get-section-filter 'f-pmt)) (logand f-pmt-svcid #xFF))(setf (nth 4 (get-section-mask 'f-pmt)) 0))(eval-events (list 'f-pmt-req)))
#'(lambda ()(setf f-pmt-pid nil)(setf f-pmt-svcid nil)))(register-node 'f-pmt-request
#'(lambda ()(get-section-valid 'f-pmt))
#'(lambda ()(unless (get-section-valid 'f-pmt)(section-open 'f-pmt)(section-disable 'f-pmt)(section-filter 'f-pmt
:type "version"
:source 'tsport
:pid (get-section-pid 'f-pmt)
:length (get-section-length 'f-pmt)
:filter (get-section-filter 'f-pmt)
:mask (get-section-mask 'f-pmt)
:elength (get-section-elength 'f-pmt)
:efilter (get-section-efilter 'f-pmt)
:emask (get-section-emask 'f-pmt))(section-enable 'f-pmt)(set-timer #'(lambda (arg)(if (get-section-valid 'f-pmt)(progn
(set-section-valid 'f-pmt nil)(make-event 'f-pmt-valid))(let ((pair))(setf pair (cadr (member-if #'(lambda (x)(and (eq (first x) f-pmt-svcid)(eq (second x) f-pmt-pid)))
f-pmt-list)))(unless pair
(setf pair (nth 0 f-pmt-list)))(setf f-pmt-svcid (first pair))(setf f-pmt-pid (second pair))(make-event 'f-pmt-req))))
'f-pmt-monitor
nil
1
5000))(eval-events (list 'f-pmt-valid)))
#'(lambda ()(setf tot-pid nil)(cancel-timer 'f-pmt-monitor)(section-close 'f-pmt)(set-section-valid 'f-pmt nil)))(append-t
'my-tsport-connect
'is-freesat
'f-pat-request
'f-pmt-pid-valid
'f-pmt-request))
