'use strict';
var FDP={};
FDP.UI={};
var keyRequest=false;
FDP.getLanguage=function(){
try{
if(FDP_LANG)
return FDP_LANG;
else
return (navigator.browserLanguage||navigator.language||navigator.userLanguage).substr(0,5);}
catch(e){
return undefined;}
};
FDP.getDirection=function(){
switch(FDP.getLanguage()){
case 'ar':
case 'fa':
case 'he-IL':
return 'rtl';
default:
return 'ltr';}
};
FDP.isLtr=function(){
if(FDP.getDirection()==='ltr'){
return true;}else {
return false;}
};
FDP.getGblValue=function(idx){
try{
return window.parent.MDM.getGblValue(idx);}
catch(e){
return undefined;}
};
(function(){
'use strict';
var keyDef=null;
var isLtr=FDP.isLtr;
var getDirection=FDP.getDirection;
var _document;
var sysFocus;
try{
keyDef={
DOWN:system.event.DOM_VK_DOWN,
UP:system.event.DOM_VK_UP,
LEFT:system.event.DOM_VK_LEFT,
RIGHT:system.event.DOM_VK_RIGHT,
ENTER:system.event.DOM_VK_RETURN,
RETURN:system.event.DOM_VK_BACK_SPACE,MENU:system.event.DOM_VK_MENU,
VK_0:system.event.DOM_VK_0,
VK_1:system.event.DOM_VK_1,
VK_2:system.event.DOM_VK_2,
VK_3:system.event.DOM_VK_3,
VK_4:system.event.DOM_VK_4,
VK_5:system.event.DOM_VK_5,
VK_6:system.event.DOM_VK_6,
VK_7:system.event.DOM_VK_7,
VK_8:system.event.DOM_VK_8,
VK_9:system.event.DOM_VK_9,
VK_D0:system.event.DOM_VK_D0,
VK_D1:system.event.DOM_VK_D1,
VK_D2:system.event.DOM_VK_D2,
VK_D3:system.event.DOM_VK_D3,
VK_D4:system.event.DOM_VK_D4,
VK_D5:system.event.DOM_VK_D5,
VK_D6:system.event.DOM_VK_D6,
VK_D7:system.event.DOM_VK_D7,
VK_D8:system.event.DOM_VK_D8,
VK_D9:system.event.DOM_VK_D9,
VK_D10:system.event.DOM_VK_D0,
VK_D11:system.event.DOM_VK_11,
VK_D12:system.event.DOM_VK_12,
RED:system.event.DOM_VK_RED,
GREEN:system.event.DOM_VK_GREEN,
YELLOW:system.event.DOM_VK_YELLOW,
BLUE:system.event.DOM_VK_BLUE,
CH_UP:system.event.DOM_VK_CH_UP,
CH_DOWN:system.event.DOM_VK_CH_DOWN,
F_CH_UP:system.event.DOM_VK_F_CH_UP,
F_CH_DOWN:system.event.DOM_VK_F_CH_DOWN,
F_VOLUP:system.event.DOM_VK_F_VOLUP,
F_VOLDOWN:system.event.DOM_VK_F_VOLDOWN,
F_CHG_INPUT:system.event.DOM_VK_F_CHG_INPUT,
HELP:system.event.DOM_VK_HELP,
mindom:true
};}catch(e){
keyDef={
UP:38,
DOWN:40,
LEFT:37,
RIGHT:39,
ENTER:13,
RETURN:8,
MENU:114,
VK_0:48,
VK_1:49,
VK_2:50,
VK_3:51,
VK_4:52,
VK_5:53,
VK_6:54,
VK_7:55,
VK_8:56,
VK_9:57
};}
FDP.keyDef=keyDef;
keyDef.isAccess=function(keyCode){
if(keyCode===this.ENTER)
return true;
if(isLtr()){
if(keyCode===this.RIGHT)
return true;}else {
if(keyCode===this.LEFT)
return true;}
return false;};
keyDef.getEnterKey=function(){
return isLtr()?keyDef.RIGHT:keyDef.LEFT;};
keyDef.isBack=function(keyCode){
if(keyCode===this.RETURN)
return true;
if(isLtr()){
if(keyCode===this.LEFT)
return true;}else {
if(keyCode===this.RIGHT)
return true;}
return false;};
keyDef.convNumberKey=function(keyCode){
var val;
switch(keyCode){
case this.VK_0:
case this.VK_D0:
val=0;
break;
case this.VK_1:
case this.VK_D1:
val=1;
break;
case this.VK_2:
case this.VK_D2:
val=2;
break;
case this.VK_3:
case this.VK_D3:
val=3;
break;
case this.VK_4:
case this.VK_D4:
val=4;
break;
case this.VK_5:
case this.VK_D5:
val=5;
break;
case this.VK_6:
case this.VK_D6:
val=6;
break;
case this.VK_7:
case this.VK_D7:
val=7;
break;
case this.VK_8:
case this.VK_D8:
val=8;
break;
case this.VK_9:
case this.VK_D9:
val=9;
break;}
if(FDP.getGblValue('area')==='jp'){
if(keyCode===this.YELLOW)
val=-1;}
return val;};
var getReqKeyByFrameType=function(type,addKeyList){
if(type==='errpnl')
{
var keyList=new Array(keyDef.DOWN,keyDef.UP,keyDef.LEFT,keyDef.RIGHT,keyDef.ENTER,keyDef.RETURN);
return keyList.concat(addKeyList);}
else if(type==='menu')
{
var keyList=new Array(keyDef.DOWN,keyDef.UP,keyDef.LEFT,keyDef.RIGHT,keyDef.ENTER,keyDef.RETURN,
keyDef.RED,keyDef.GREEN,keyDef.YELLOW,keyDef.BLUE,
keyDef.F_CH_UP,keyDef.F_CH_DOWN,keyDef.F_VOLUP,keyDef.F_VOLDOWN,keyDef.F_CHG_INPUT);
return keyList.concat(addKeyList);}
return addKeyList;};
var getReqKeyByFrameTypeForKeyboard=function(addKeyList){
var keyList=new Array(keyDef.DOWN,keyDef.UP,keyDef.LEFT,keyDef.RIGHT,keyDef.ENTER,keyDef.RETURN,
keyDef.VK_0,keyDef.VK_1,keyDef.VK_2,keyDef.VK_3,keyDef.VK_4,keyDef.VK_5,keyDef.VK_6,keyDef.VK_7,keyDef.VK_8,keyDef.VK_9,
keyDef.VK_D0,keyDef.VK_D1,keyDef.VK_D2,keyDef.VK_D3,keyDef.VK_D4,keyDef.VK_D5,keyDef.VK_D6,keyDef.VK_D7,keyDef.VK_D8,keyDef.VK_D9,keyDef.VK_D11,keyDef.VK_D12,
keyDef.RED,keyDef.GREEN,keyDef.YELLOW,keyDef.BLUE,
keyDef.F_CH_UP,keyDef.F_CH_DOWN,keyDef.F_VOLUP,keyDef.F_VOLDOWN,keyDef.F_CHG_INPUT,
system.event.DOM_VK_COLON,system.event.DOM_VK_SEMICOLON,system.event.DOM_VK_LESS_THAN,system.event.DOM_VK_EQUALS,system.event.DOM_VK_GREATER_THAN,system.event.DOM_VK_QUESTION_MARK,system.event.DOM_VK_AT,system.event.DOM_VK_A,system.event.DOM_VK_B,system.event.DOM_VK_C,system.event.DOM_VK_D,system.event.DOM_VK_E,system.event.DOM_VK_F,system.event.DOM_VK_G,system.event.DOM_VK_H,system.event.DOM_VK_I,system.event.DOM_VK_J,system.event.DOM_VK_K,system.event.DOM_VK_L,system.event.DOM_VK_M,system.event.DOM_VK_N,system.event.DOM_VK_O,system.event.DOM_VK_P,system.event.DOM_VK_Q,system.event.DOM_VK_R,system.event.DOM_VK_S,system.event.DOM_VK_T,system.event.DOM_VK_U,system.event.DOM_VK_V,system.event.DOM_VK_W,system.event.DOM_VK_X,system.event.DOM_VK_Y,system.event.DOM_VK_Z,system.event.DOM_VK_NUMPAD0,system.event.DOM_VK_NUMPAD1,system.event.DOM_VK_NUMPAD2,system.event.DOM_VK_NUMPAD3,system.event.DOM_VK_NUMPAD4,system.event.DOM_VK_NUMPAD5,system.event.DOM_VK_NUMPAD6,system.event.DOM_VK_NUMPAD7,system.event.DOM_VK_NUMPAD8,system.event.DOM_VK_NUMPAD9,system.event.DOM_VK_ADD,system.event.DOM_VK_SEPARATOR,system.event.DOM_VK_SUBTRACT,system.event.DOM_VK_DECIMAL,system.event.DOM_VK_DIVIDE,system.event.DOM_VK_CIRCUMFLEX,system.event.DOM_VK_EXCLAMATION,system.event.DOM_VK_DOUBLE_QUOTE,system.event.DOM_VK_HASH,system.event.DOM_VK_DOLLAR,system.event.DOM_VK_PERCENT,system.event.DOM_VK_AMPERSAND,system.event.DOM_VK_UNDERSCORE,system.event.DOM_VK_OPEN_PAREN,system.event.DOM_VK_CLOSE_PAREN,system.event.DOM_VK_ASTERISK,system.event.DOM_VK_PLUS,system.event.DOM_VK_PIPE,system.event.DOM_VK_HYPHEN_MINUS,system.event.DOM_VK_OPEN_CURLY_BRACKET,system.event.DOM_VK_CLOSE_CURLY_BRACKET,system.event.DOM_VK_TILDE,system.event.DOM_VK_COMMA,system.event.DOM_VK_PERIOD,system.event.DOM_VK_SLASH,system.event.DOM_VK_BACK_QUOTE,system.event.DOM_VK_OPEN_BRACKET,system.event.DOM_VK_BACK_SLASH,system.event.DOM_VK_CLOSE_BRACKET,system.event.DOM_VK_QUOTE);
return keyList.concat(addKeyList);};
var printProp=function(obj){
for(var i in obj){
console.log(obj[i]);}
};
var debugPrint=function(){
var printStr='[Log]';
for(var i=0;i<arguments.length;i++){
printStr+=arguments[i]+' :';}
console.log(printStr);};
var copyArray=function(from,to){
to=to||[];
for(var i=0,len=from.length;i<len;i++){
to[i]=from[i];}
return to;};
var copyProp=function(from,to,props){
var i;
to=to||{};
if(props){
for(i=0;i<props.length;i++){
var prop=props[i];
if(from.hasOwnProperty(prop)){
to[prop]=from[prop];}
}
}else {
for(i in from){
if(from.hasOwnProperty(i)){
to[i]=from[i];}
}
}
return to;};
var getArrayObj=function(array,func){
var obj;
for(var i in array){
obj=array[i];
if(func(obj)){
return obj;}
}
return null;};
var removeAllChild=function(ele){
while(ele.firstChild){
ele.removeChild(ele.firstChild);}
};
var arrayLast=function(obj){
return obj[obj.length-1];};
var classAdd=function(ele,className){
var classList=ele.classList;
classList.add(className);
return ele;};
var classRemove=function(ele,className){
var classList=ele.classList;
classList.remove(className);
return ele;};
function calcFDPParam(){
var sizeDiv=_document.createElement('div');
sizeDiv.style.position='absolute';
sizeDiv.style.visibility='hidden';
sizeDiv.style.display='block';
sizeDiv.style.width='.4rem';
sizeDiv.style.height='7rem';
sizeDiv.style.borderStyle='solid';
sizeDiv.style.borderWidth='0 0 .1rem 0';
_document.body.appendChild(sizeDiv);
FDP.params={
listBtnTotalH:sizeDiv.offsetHeight
};
if(FDP.params.listBtnTotalH===0){
FDP.params.listBtnTotalH=71;}
FDP.params.checkWidth=sizeDiv.offsetWidth;
_document.body.removeChild(sizeDiv);};
FDP.getParam=function(){
if(!FDP.params||!FDP.params.listBtnTotalH){
calcFDPParam();}
return FDP.params;};
FDP.init=function(arg){
if(window.fdpInitialized){
return;}
arg=arg||{};
window.fdpInitialized=true;
_document=arg.document||document;
var bodyWidth=document.body.offsetWidth;
var htmlWidth=window.innerWidth;
if(htmlWidth===0){
if(bodyWidth===0){
htmlWidth=window.parent.window.innerWidth;}else {
htmlWidth=bodyWidth;}
}
var bodyHeight=document.body.offsetHeight;
var htmlHeight=window.innerHeight;
if(htmlHeight===0){
if(bodyHeight===0){
htmlHeight=window.parent.window.innerHeight;}else {
htmlHeight=bodyHeight;}
}
var htmlheightPar=htmlHeight/1080;
var htmlFontSizeNum=62.5*htmlheightPar;
var htmlFontSize='font-size: '+htmlFontSizeNum+'%';
var htmlEle=document.getElementsByTagName('html')[0];
htmlEle.style.fontSize=htmlFontSizeNum+'%';
htmlEle.style.direction=getDirection();
calcFDPParam();
setFontSizeCss(document);
if(sysFocus){
if(arg.initFocus){
sysFocus.type='shadow';
sysFocus.color=0xffc239;
sysFocus.outset=8*htmlheightPar;}
}

FDP.anim=true;
if(window.parent.MDM)
FDP.changeColorSet(window.parent.MDM.getColorSetNo());
else
setColorDefCss(document);
window.addEventListener('keydown',function(ev){
FDP.FRAMES.sendKey(ev);});
window.addEventListener('keypress',function(ev){
FDP.FRAMES.sendKey(ev);});
window.addEventListener('keyup',function(ev){
FDP.FRAMES.sendKey(ev);});
window.addEventListener('resize',function(ev){
var htmlheightPar=window.innerHeight/1080;
document.getElementsByTagName('html')[0].style.fontSize=(htmlheightPar*62.5)+'%';
if(sysFocus){
sysFocus.outset=8*htmlheightPar;}
calcFDPParam();});};
var lastHeight=0;
FDP.resize=function(arg){

};
var curColorIdx=0;
var colorSet=[{
base:'rgb(0,0,0)',
base_a:'rgba(0,0,0,0.95)',
base_sub:'rgb(49,49,49)',
base_sub_a:'rgba(49,49,49,0.95)',
text_onbase:'rgb(238,238,238)',
text_onbase_a:'rgb(95,95,95)',
text_sub_onbase:'rgb(204,204,204)',
text_sub_onbase_a:'rgb(111,111,111)',
icon_onbase:'rgb(204,204,204)',
icon_onbase_a:'rgb(81,81,81)',
border_onbase:'rgb(89,89,89)',
border_onbase_a:'rgba(89,89,89,0.95)',
btn:'rgb(34,34,34)',
btn_border:'rgb(136,136,136)',
widget_sub:'rgb(89,89,89)',
pop:'rgb(0,0,0)',
pop_a:'rgba(0,0,0,0.95)',
pop_border:'rgb(170,170,170)',
point:'rgb(64,163,255)',
text_onpoint:'rgb(255,255,255)',
text_sub_onpoint:'rgb(201,229,255)',
icon_onpoint:'rgb(201,229,255)',
border_onpoint:'rgb(201,229,255)',
point_onbase:'rgb(84,173,255)',
point_onbase_a:'rgb(33,69,102)'
},{
base:'rgb(245,245,245)',
base_a:'rgba(245,245,245,0.95)',
base_sub:'rgb(220,220,220)',
base_sub_a:'rgba(220,220,220,0.95)',
text_onbase:'rgb(48,48,48)',
text_onbase_a:'rgb(166,166,166)',
text_sub_onbase:'rgb(102,102,102)',
text_sub_onbase_a:'rgb(172,172,172)',
icon_onbase:'rgb(128,128,128)',
icon_onbase_a:'rgb(198,198,198)',
border_onbase:'rgb(186,186,186)',
border_onbase_a:'rgba(186,186,186,0.95)',
btn:'rgb(210,210,210)',
btn_border:'rgb(156,156,156)',
widget_sub:'rgb(171,171,171)',
pop:'rgb(245,245,245)',
pop_a:'rgba(245,245,245,0.95)',
pop_border:'rgb(170,170,170)',
point:'rgb(64,163,255)',
text_onpoint:'rgb(255,255,255)',
text_sub_onpoint:'rgb(201,229,255)',
icon_onpoint:'rgb(201,229,255)',
border_onpoint:'rgb(201,229,255)',
point_onbase:'rgb(15,140,255)',
point_onbase_a:'rgb(153,203,249)'
},{
base:'rgb(72,59,46)',
base_a:'rgba(72,59,46,0.95)',
base_sub:'rgb(97,79,62)',
base_sub_a:'rgba(97,79,62,0.95)',
text_onbase:'rgb(238,238,238)',
text_onbase_a:'rgb(138,130,122)',
text_sub_onbase:'rgb(204,204,204)',
text_sub_onbase_a:'rgb(139,129,118)',
icon_onbase:'rgb(204,204,204)',
icon_onbase_a:'rgb(124,117,109)',
border_onbase:'rgb(125,102,80)',
border_onbase_a:'rgba(125,102,80,0.95)',
btn:'rgb(84,69,53)',
btn_border:'rgb(153,126,98)',
widget_sub:'rgb(31,31,31)',
pop:'rgb(38,32,25)',
pop_a:'rgba(38,32,25,0.95)',
pop_border:'rgb(179,157,136)',
point:'rgb(209,114,24)',
text_onpoint:'rgb(255,255,255)',
text_sub_onpoint:'rgb(242,221,198)',
icon_onpoint:'rgb(242,221,198)',
border_onpoint:'rgb(242,221,198)',
point_onbase:'rgb(237,136,40)',
point_onbase_a:'rgb(138,89,43)'
},{
base:'rgb(219,205,180)',
base_a:'rgba(219,205,180,0.95)',
base_sub:'rgb(202,184,153)',
base_sub_a:'rgba(202,184,153,0.95)',
text_onbase:'rgb(31,31,31)',
text_onbase_a:'rgb(143,135,120)',
text_sub_onbase:'rgb(77,72,65)',
text_sub_onbase_a:'rgb(152,139,117)',
icon_onbase:'rgb(105,99,89)',
icon_onbase_a:'rgb(173,162,143)',
border_onbase:'rgb(171,157,137)',
border_onbase_a:'rgba(171,157,137,0.95)',
btn:'rgb(186,169,140)',
btn_border:'rgb(140,120,97)',
widget_sub:'rgb(153,142,123)',
pop:'rgb(219,205,180)',
pop_a:'rgba(219,205,180,0.95)',
pop_border:'rgb(168,148,120)',
point:'rgb(209,114,24)',
text_onpoint:'rgb(255,255,255)',
text_sub_onpoint:'rgb(242,221,198)',
icon_onpoint:'rgb(242,221,198)',
border_onpoint:'rgb(242,221,198)',
point_onbase:'rgb(209,114,24)',
point_onbase_a:'rgb(215,168,117)'
}];
var colorSetGrad=[
'(top,'+
'#000 0%,'+
'#141414 30%,'+
'#3c3c3c 75%,'+
'#757575 100%)',
'(top,'+
'#f5f5f5 0%,'+
'#f3f3f3 30%,'+
'#dddddd 75%,'+
'#cacaca 100%)',
'(top,'+
'#483b2e 0%,'+
'#4a3d30 30%,'+
'#5c5145 75%,'+
'#6c6258 100%)',
'(top,'+
'#dbcdb4 0%,'+
'#d9cbb2 30%,'+
'#c4b8a2 75%,'+
'#b2a793 100%)'
];
FDP.changeColorSet=function(id){
curColorIdx=id;
var frames=document.getElementsByTagName('frame');
var doc;
setColorDefCss(document);
for(var i=0;i<frames.length;i++){
doc=frames[i].contentWindow.document;
if(doc){
setColorDefCss(doc);}
}
};
function setAlphaValue(colorSet){
if(FDP.getGblValue('colorDepth')===16){
var pattern=/(rgba\((\s*\d+\s*,){3,3})(\s*0\.\d+\s*)\)/;
var value,matchRet;
var newSet={};
for(var name in colorSet){
value=colorSet[name];
matchRet=value.match(pattern);
if(matchRet){
value=matchRet[1]+'0.7)';}
newSet[name]=value;}
return newSet;}else {
return colorSet;}
}
function setColorDefCss(doc){
var old=doc.getElementById('colorDef_css');
if(old)doc.head.removeChild(old);
var css=document.createElement('style');
css.id='colorDef_css';
var curSet=setAlphaValue(colorSet[curColorIdx]);
var curSetGrad=colorSetGrad[curColorIdx];
css.innerHTML=
'.fdp-color-base{background-color:'+curSet.base+';}\n'+
'.fdp-color-base-full{background:-webkit-linear-gradient'+curSetGrad+';}\n'+
'.fdp-color-base-a{background-color:'+curSet.base_a+';}\n'+
'.fdp-color-base-border-a{border-color:'+curSet.base_a+';}\n'+
'.fdp-color-base-sub{background-color:'+curSet.base_sub+';}\n'+
'.fdp-color-base-sub-a{background-color:'+curSet.base_sub_a+';}\n'+
'.fdp-color-btn{background-color:'+curSet.btn+';}\n'+
'.fdp-color-btn-border{border-color:'+curSet.btn_border+';}\n'+
'.fdp-color-text-onbase{color:'+curSet.text_onbase+';}\n'+
'.fdp-color-text-onbase-a-border-bottom{border-bottom-color:'+curSet.text_onbase_a+';}\n'+
'.fdp-color-text-sub-onbase{color:'+curSet.text_sub_onbase+';}\n'+
'.fdp-color-icon-onbase{color:'+curSet.icon_onbase+';}\n'+
'.fdp-color-icon-onbase-border{border-color:'+curSet.icon_onbase+';}\n'+
'.fdp-color-icon-onbase-back{background-color:'+curSet.icon_onbase+';}\n'+
'.fdp-color-icon-onbase-a{color:'+curSet.icon_onbase_a+';}\n'+
'.fdp-color-icon-onbase-a-border{border-color:'+curSet.icon_onbase_a+';}\n'+
'.fdp-color-icon-onbase-a-back{background-color:'+curSet.icon_onbase_a+';}\n'+
'.fdp-color-top-icon{background-color:'+curSet.text_onbase_a+';color:'+curSet.text_onbase+';}\n'+
'.fdp-color-border-onbase{border-color:'+curSet.border_onbase+';}\n'+
'.fdp-color-pop{background-color:'+curSet.pop+';}\n'+
'.fdp-color-pop-a{background-color:'+curSet.pop_a+';}\n'+
'.fdp-color-pop-border{border-color:'+curSet.pop_border+';}\n'+
'.fdp-color-text-onbase-border{border-color:'+curSet.text_onbase+';}\n'+
'.fdp-color-point{background-color:'+curSet.point+';}\n'+
'.fdp-color-text-point{color:'+curSet.point+';}\n'+
'.fdp-color-point-onbase{background-color:'+curSet.point_onbase+';}\n'+
'.fdp-color-text-point-onbase{color:'+curSet.point_onbase+';fill:'+curSet.point_onbase+';}\n'+
'.fdp-color-point-border{border-color:'+curSet.point+';}\n'+
'.fdp-color-widget-sub{background-color:'+curSet.widget_sub+';}\n'+
'.fdp-color-widget-sub-border{border-color:'+curSet.widget_sub+';}\n'+
'.fdp-color-text-onpoint{color:'+curSet.text_onpoint+';}\n'+
'.fdp-color-text-sub-onpoint{color:'+curSet.text_sub_onpoint+';}\n'+
'.fdp-color-gray{background-color:rgb(102,102,102);}\n'+
'.fdp-color-signal-green{background-color:rgb(45,238,145);}\n'+
'.fdp-color-signal-yellow{background-color:rgb(246,226,64);}\n'+
'.fdp-color-signal-red{background-color:rgb(249,20,68);}\n'+
'.fdp-color-signal-blue{background-color:rgb(43,192,255);}\n'+
'.fdp-color-signal-aqua{background-color:rgb(0,255,255);}\n'+
'.fdp-color-signal-orange{background-color:rgb(255,128,74);}\n'+
'.fdp-color-signal-white{background-color:rgb(221,221,221);}\n'+
'.fdp-color-scrollbar::-webkit-scrollbar{width:1.2rem;}\n'+
'.fdp-color-scrollbar::-webkit-scrollbar-thumb{background:'+curSet.icon_onbase+';}\n'+
'.fdp-color-scrollbar::-webkit-scrollbar-track-piece{background:'+curSet.icon_onbase_a+';}\n'+
'.fdp-frame.full .fdp-color-base-sub-a {background-color:'+curSet.base_sub+';}\n'+
'.fdp-frame.full .fdp-btn-wrap {background-color:transparent;}\n'+
'.fdp-pop-border  {border: solid 0.2rem '+curSet.pop_border+';}\n'+
'.fdp-list.choice-list .fdp-color-base-sub-a{background-color:'+curSet.base+';}\n'+
'.fdp-disable.fdp-color-point-onbase {background-color:'+curSet.point_onbase_a+';}\n'+
'.fdp-disable.fdp-list-btn .fdp-color-point-onbase {background-color:'+curSet.point_onbase_a+';}\n'+
'.fdp-disable .fdp-color-point-onbase {background-color:'+curSet.point_onbase_a+';}\n'+
'.fdp-color-category-line {background-color:'+curSet.text_onbase+';}\n'+
'.fdp-color-transparent {background-color:transparent;border-color:transparent}\n'+
'.fdp-color-btn-transparent-back {background-color:'+curSet.pop_a+';}\n'+
'.fdp-color-btn-transparent {background-color:'+curSet.pop_a+';border-color:'+curSet.pop_a+';background-clip:padding-box;}\n'+
'.fdp-color-svg-stroke {stroke:'+curSet.text_onpoint+';}\n'+
'.fdp-frame.full .fdp-color-btn-transparent-back {background-color:transparent;}\n'+
'.fdp-frame.full .fdp-color-btn-transparent {background-color:transparent;border-color:transparent}\n'+
'.fdp-frame.full .fdp-color-base-sub-a.fdp-color-point-onbase {background-color:'+curSet.point_onbase+';}\n'+
'.fdp-disable.fdp-color-text-onbase-border {border-color:'+curSet.text_onbase_a+';}\n'+
'.fdp-disable.fdp-color-text-onbase {color:'+curSet.text_onbase_a+';}\n'+
'.fdp-disable .fdp-color-text-onbase {color:'+curSet.text_onbase_a+';}';
doc.head.appendChild(css);}
function setFontSizeCss(doc){
var headEle,fdpCss;
for(var i=0;i<doc.head.children.length;i++){
headEle=doc.head.children[i];
if(headEle.tagName==='LINK'&&
(headEle.href.indexOf('shared/style/fdp.css')!==-1)){
fdpCss=headEle;
break;}
}
var old=doc.getElementById('fontSizeDef_css');
if(old)doc.head.removeChild(old);
var css=document.createElement('style');
css.id='fontSizeDef_css';
switch(FDP.getLanguage()){
case 'ja-JP':
case 'my':
FDP.fontSmall=true;
break;}
if(FDP.fontSmall){
if(FDP.getLanguage()==='my'){
css.innerHTML=
'.fdp-font-normal {font-size:2.6rem;}\n'+
'.fdp-list-btn {padding:0 3rem 0rem 3rem;}\n';}else {
css.innerHTML=
'.fdp-font-normal {font-size:2.8rem;}\n'+
'.fdp-list-btn {padding:0 3rem 0 3rem;}\n';}
}else {
css.innerHTML=
'.fdp-font-normal {font-size:3.2rem;}\n'+
'.fdp-list-btn {padding:0 4rem 0 4rem;}\n';}
if(fdpCss)
doc.head.insertBefore(css,fdpCss);
else
doc.head.insertBefore(css,doc.head.firstChild);}
function setAnimParamCss(doc){

var css=document.createElement('link');
css.id='fdpAnimParam_css';
css.rel='stylesheet';
css.href='/usr/local/minidom/shared/style/fdp_anim_4k.css';
doc.head.appendChild(css);}

(function(FDP){
var UI=FDP.UI;
var tmplDiv=document.createElement('div');
var tmplImg=document.createElement('img');
var tmplArrow=tmplDiv.cloneNode(false);
tmplArrow.className='fdp-arrow fdp-color-text-onbase-border';
var tmplArrowL=tmplArrow.cloneNode(true);
tmplArrowL.classList.add('left');
var tmplArrowR=tmplArrow.cloneNode(true);
tmplArrowR.classList.add('right');
var makeTemplate=function(arg){
var tmpl,ele,eleFunc;
switch(arg.type){
case 'row':
eleFunc=rowElement;
ele=eleFunc.make(arg);
eleFunc.initForm(ele,arg.form);
break;
case 'access6':
eleFunc=access6Element;
ele=eleFunc.make(arg);
eleFunc.initBtn(ele,arg);
break;}
return {ele:ele,arg:arg,template:true};};
var BaseObj=UTIL.Class.create(
Object,{
type:'base',
__construct:function(){
this.isFocus=false;},
__onFocus:function(){
this.isFocus=true;},
__onBlure:function(){
this.isFocus=false;},
makeElement:function(arg){
return this.eleFunc.make(arg);},
keyHook:function(ev){
return false;}
});
UTIL.include(UTIL.Event,BaseObj);

var BaseListBtnObj=UTIL.Class.create(
BaseObj,{
type:'baselistbtn',
__init:function(arg,parentObj){
this.isFocus=false;
this.ele=this.makeElement(arg);
this.id=arg.id;
this.setTitle(arg.title);
this.setTitleColor(arg.titleColor);
this.setTitleFontSize(arg.titleFontSize);
if(arg.centerRatio)
this.setCenterRatio(arg.centerRatio);
this.parentObj=parentObj;
this.setDisable(arg.disable);
this.help=arg.help;
this.focusHook=arg.focusHook;
this.unfocusHook=arg.unfocusHook;},
setTitle:function(title){
if(title!==undefined){
this.title=title;
this.eleFunc.setTitle(this.ele,title);}
return this;},
setTitleColor:function(colorClass){
if(colorClass!==undefined){
this.titleColor=colorClass;
this.eleFunc.setTitleColor(this.ele,colorClass);}
return this;},
setTitleFontSize:function(size){
if(size!==undefined){
this.eleFunc.setTitleFontSize(this.ele,size);}
return this;},
focus:function(){
this.__onFocus();
if(this.parentObj)
this.parentObj.dispatchEvent('focus',this);
if(this.focusHook)
this.focusHook({type:'focus',obj:this});},
unfocus:function(){
this.__onBlure();
if(this.parentObj)
this.parentObj.dispatchEvent('unfocus',this);
if(this.unfocusHook)
this.unfocusHook({type:'unfocus',obj:this});},
destroy:function(){
},
getTitle:function(){
return this.title;},
getValue:function(){
return this.value;},
setDisable:function(disable){
if(disable)
this.disable=true;
else
this.disable=false;
if(this.eleFunc.setDisable){
if(this.hideSelector&&this.isSelectMode&&disable){
this.hideSelector();}
this.eleFunc.setDisable(this.ele,disable);}
},
setCenterRatio:function(ratio){
this.ratio=ratio;
if(this.eleFunc.setCenterRatio)
this.eleFunc.setCenterRatio(this.ele,ratio);},
dispatchAccess:function(){
if(this.parentObj)
this.parentObj.dispatchEvent('buttonaccess',this);
if(this.accessHook)
this.accessHook({
type:'access',
obj:this
});},
dispatchValueChange:function(){
if(this.parentObj)
this.parentObj.dispatchEvent('valuechange',this);
if(this.valueChangeHook){
this.valueChangeHook({
type:'valuechange',
obj:this,
value:this.getValue()
});}
}
});
var makeListButtonBaseElement=(function(){
var tmpl=null;
return function(){
if(tmpl===null){
tmpl=tmplDiv.cloneNode(false);
tmpl.className=
'fdp-list-btn fdp-list-btn-border fdp-color-border-onbase fdp-color-text-onbase fdp-color-base-sub-a';}
return tmpl.cloneNode(true);};}());
var makeListButtonElement=(function(){
var tmpl=null;
return function(arg){
if(tmpl===null){
var title=tmplDiv.cloneNode(false);
var value=tmplDiv.cloneNode(false);
title.className='title';
value.className='valueWrap';
tmpl=makeListButtonBaseElement();
tmpl.appendChild(title);
tmpl.appendChild(value);}
return tmpl.cloneNode(true);};}());
function setListBtnEleContent(ele,content,html){
if(html)
ele.innerHTML=content;
else
ele.textContent=content;
return ele;}
function getListBtnEleContent(ele){
return ele.textContent;}
var listButton={
setTitle:function(ele,title){
setListBtnEleContent(ele.getElementsByClassName('title')[0],title);
return ele;},
getTitle:function(ele){
return getListBtnEleContent(ele.getElementsByClassName('title')[0]);},
setTitleColor:function(ele,colorClass){
ele.getElementsByClassName('title')[0].classList.add(colorClass);
return ele;},
setTitleFontSize:function(ele,size){
ele.getElementsByClassName('title')[0].style.fontSize=size;
return ele;},
getTitleEle:function(ele){
return ele.getElementsByClassName('title')[0];},
setValue:function(ele,value){
setListBtnEleContent(ele.getElementsByClassName('valueWrap')[0],value);
return ele;},
getValue:function(ele){
return getListBtnEleContent(ele.getElementsByClassName('valueWrap')[0]);},
getValueEle:function(ele){
return ele.getElementsByClassName('valueWrap')[0];},
setDisable:function(ele,disable){
if(disable)
ele.classList.add('fdp-disable');
else
ele.classList.remove('fdp-disable');},
setCenterRatio:function(ele,ratio){
var titleEle,valueWrapEle;
titleEle=ele.getElementsByClassName('title')[0];
if(titleEle)
titleEle.style.width=ratio;
valueWrapEle=ele.getElementsByClassName('valueWrap')[0];
if(valueWrapEle)
valueWrapEle.style.width=100-Number(ratio.replace('%',''))+'%';}
};

var sysmenuTitleElement={
make:(function(){
var tmpl=null;
var func=function(prop){
if(tmpl===null){
var title=tmplDiv.cloneNode(false);
title.className='title fdp-color-text-sub-onbase';
tmpl=tmplDiv.cloneNode(false);
tmpl.className='fdp-sysmenu-title fdp-color-border-onbase';
if(FDP.getLanguage()==='my'){
tmpl.style.paddingBottom='1.5rem';}
tmpl.appendChild(title);}
var ele=tmpl.cloneNode(true);
return ele;};
return func;}()),
setTitle:listButton.setTitle,
getTitle:listButton.getTtiel,
getTitleEle:listButton.getTitleEle
};
var SysmenuTitleObj=UTIL.Class.create(
BaseListBtnObj,{
type:'sysmenuTitle',
eleFunc:sysmenuTitleElement,
enableFocus:false,
__construct:function(arg,parentObj){
this.ele=this.makeElement(arg);
this.parentObj=parentObj;
this.setTitle(arg.title);},
destroy:function(){
}
}
);

var categoryTitleElement={
make:(function(){
var tmpl=null;
var func=function(prop){
if(tmpl===null){
var title=tmplDiv.cloneNode(false);
var line=tmplDiv.cloneNode(false);
var subTitle=tmplDiv.cloneNode(false);
title.className='title fdp-color-text-onbase';
switch(FDP.getLanguage()){
case 'th':
title.style.paddingBottom='2rem';
break;
case 'my':
title.style.fontSize='4.4rem';
title.style.paddingBottom='3.5rem';
title.style.paddingRight='.1rem';
break;}
line.className='line';
subTitle.className='sub-title fdp-color-text-onbase';
tmpl=tmplDiv.cloneNode(false);
tmpl.className='categoryTitle fdp-color-base fdp-color-border-onbase';
tmpl.appendChild(line);
tmpl.appendChild(title);
tmpl.appendChild(subTitle);}
var ele=tmpl.cloneNode(true);
return ele;};
return func;}()),
setTitle:listButton.setTitle,
getTitle:listButton.getTitle,
getTitleEle:listButton.getTitleEle,
setSubTitle:function(ele,title){
var subTitleEle=ele.getElementsByClassName('sub-title')[0];
if(FDP.getLanguage()==='my'){
subTitleEle.style.paddingBottom='2rem';}
setListBtnEleContent(subTitleEle,title);},
setLine:function(ele,num){
var lineDiv=ele.getElementsByClassName('line')[0];
var i,line;
var lineWidth=((32-(4*(num-1)))/ num) /10;
for(i=0;i<num;i++){
line=tmplDiv.cloneNode(false);
line.className='fdp-color-category-line';
line.style.width=lineWidth+'rem';
line.style.height='100%';
lineDiv.appendChild(line);}
}
};
var CategoryTitleObj=UTIL.Class.create(
BaseListBtnObj,{
type:'categoryTitle',
eleFunc:categoryTitleElement,
enableFocus:false,
__construct:function(arg,parentObj){
this.ele=this.makeElement(arg);
this.parentObj=parentObj;
this.setTitle(arg.title);
this.setSubTitle(arg.subTitle);
this.eleFunc.setLine(this.ele,arg.level+1);},
setSubTitle:function(subTitle){
if(subTitle)
this.eleFunc.setSubTitle(this.ele,subTitle);
return this;},
destroy:function(){
}
}
);

var accessElement={
make:(function(){
var tmpl=null;
var func=function(prop){
if(tmpl===null){
tmpl=makeListButtonElement();}
var ele=tmpl.cloneNode(true);
return ele;};
return func;}())
};
UTIL.extend(listButton,accessElement);
var access2Element={
make:(function(){
var tmpl=null;
var func=function(prop){
if(tmpl===null){
tmpl=makeListButtonElement();
tmpl.removeChild(tmpl.lastChild);
tmpl.firstChild.style.width='100%';}
var ele=tmpl.cloneNode(true);
return ele;};
return func;}()),
setValue:function(){
},
getValue:function(){
return null;}
};
UTIL.extend2(listButton,access2Element);
var access7Element={
make:(function(){
var tmpl=null;
var func=function(prop){
if(tmpl===null){
var title=tmplDiv.cloneNode(false);
var icon=tmplDiv.cloneNode(false);
tmpl=tmplDiv.cloneNode(false);
tmpl.className='fdp-list-btn fdp-color-text-onbase fdp-access7';
title.className='title';
title.style.width='100%';
icon.className='fdp-access7-icon fdp-color-top-icon';
tmpl.appendChild(icon);
tmpl.appendChild(title);}
var ele=tmpl.cloneNode(true);
return ele;};
return func;}()),
setIcon:function(ele,icon){
var iconDiv=ele.getElementsByClassName('fdp-access7-icon')[0];
iconDiv.classList.add('fdp-fonticon-'+icon);},
getIcon:function(ele){
return ele.getElementsByClassName('fdp-access7-icon')[0];},
setValue:function(){
},
getValue:function(){
return null;},
focus:function(ele){
classAdd(ele,'access7-focus');},
unfocus:function(ele){
classRemove(ele,'access7-focus');},
setSelectedColor:function(ele){
classAdd(ele,'access7-selected');},
unsetSelectedColor:function(ele){
classRemove(ele,'access7-selected');}
};
UTIL.extend2(listButton,access7Element);
var btnElement={
make:(function(){
var tmpl=null,btn;
var func=function(prop){
if(tmpl===null){
tmpl=tmplDiv.cloneNode(false);
tmpl.className='fdp-btn-wrap fdp-color-base-a';
btn=makeListButtonElement();
btn.removeChild(btn.lastChild);
btn.firstChild.style.width='100%';
btn.className='fdp-btn fdp-margin-center fdp-color-btn fdp-color-text-onbase fdp-color-btn-border';
tmpl.appendChild(btn);}
var ele=tmpl.cloneNode(true);
return ele;};
return func;}()),
setTitle:function(ele,title){
var btn=ele.firstChild;
listButton.setTitle(btn,title);
return ele;},
getTitle:function(ele){
var btn=ele.firstChild;
return listButton.getTitle(btn);},
setValue:function(){
},
getValue:function(){
return null;}
};
UTIL.extend2(listButton,btnElement);
var AccessObj=UTIL.Class.create(
BaseListBtnObj,{
type:'access',
eleFunc:null,
enableFocus:true,
__construct:function(arg,parentObj){
switch(arg.subType){
case 'access2':
this.eleFunc=access2Element;
break;
case 'access7':
this.eleFunc=access7Element;
break;
case 'button':
this.eleFunc=btnElement;
break;
default:
this.eleFunc=accessElement;
break;}
this.__init(arg,parentObj);
this.setValue(arg.value);
this.enableFocus=arg.enableFocus===false?false:true;
this.accessHook=arg.accessHook;
this.subType=arg.subType;
if(arg.enterTxt){
this.enterTxt=arg.enterTxt;}
if(arg.icon){
this.eleFunc.setIcon(this.ele,arg.icon);}
if(this.subType==='button'){
if(arg.allHeight){
this.ele.style.height=arg.allHeight;}
}
this.lastKey={key:null,count:0};},
setValue:function(value){
if(value!==undefined){
this.value=value;
this.eleFunc.setValue(this.ele,value);}
return this.ele;},
getFocusEle:function(){
if(this.subType==='button')
return this.ele.firstChild;
else
return this.ele;},
setSelectedColor:function(){

if(this.eleFunc.setSelectedColor){
this.eleFunc.setSelectedColor(this.ele);}
},
unsetSelectedColor:function(){

if(this.eleFunc.unsetSelectedColor){
this.eleFunc.unsetSelectedColor(this.ele);}
},
setSelectedBgColor:function(){
this.ele.classList.add('fdp-color-point-onbase');},
unsetSelectedBgColor:function(){
this.ele.classList.remove('fdp-color-point-onbase');},
focus:function(){
if(this.eleFunc.focus){
this.eleFunc.focus(this.ele);}
BaseListBtnObj.prototype.focus.call(this);},
unfocus:function(){
this.lastKey.key=null;
this.lastKey.count=0;
if(this.eleFunc.unfocus){
this.eleFunc.unfocus(this.ele);}
BaseListBtnObj.prototype.unfocus.call(this);},
keyHook:function(ev){
var ret=false;
if(this.disable)
return ret;
if(ev.type==='keydown'){
this.lastKey.key=ev.keyCode;
this.lastKey.count++;}else {
this.lastKey.key=null;
this.lastKey.count=0;}
if(ev.type==='keydown'){
var enterKey=keyDef.getEnterKey();
switch(ev.keyCode){
case enterKey:
case keyDef.ENTER:
if(this.lastKey.count===1){
this.dispatchAccess();
ret=true;}
break;}
}
return ret;}
}
);
var access6Element={
make:(function(){
var tmpl=null;
var func=function(prop){
var ele,sname,icon2;
if(tmpl===null){
tmpl=makeListButtonBaseElement();
tmpl.classList.add('fdp-access6-btn');
sname=tmplDiv.cloneNode(false);
sname.className='access6-sname fdp-text-ellipsis';
tmpl.appendChild(sname);
icon2=tmplImg.cloneNode(false);
icon2.className='access6-icon2';
tmpl.appendChild(icon2);}
ele=tmpl.cloneNode(true);
return ele;};
return func;}()),
makeCheckSvg:(function(){
var tmpl=null;
var func=function(){
var path,ns,length;
if(tmpl===null){
ns='http://www.w3.org/2000/svg';
tmpl=document.createElementNS(ns,'svg');
tmpl.setAttributeNS(null,'viewBox','0 0 36 36');
tmpl.setAttribute('xmlns',ns);
tmpl.classList.add('fdp-check-wrap');
tmpl.classList.add('fdp-color-point');
path=document.createElementNS(ns,'path');
path.classList.add('fdp-color-svg-stroke');
path.classList.add('fdp-check-svg');
path.setAttributeNS(null,'d','M 5.500500000000001,19.323 15.250499999999999,26.447499999999998 30.125,8.0725');
tmpl.appendChild(path);
length=path.getTotalLength();
path.style.strokeDasharray=length+' '+length;
path.dataset.len=length;}
return tmpl.cloneNode(true);};
return func;}()),
initBtn:function(ele,prop){
var type,checkbox,check,index,sname;
sname=ele.firstChild;
if(prop.checkBox){
checkbox=tmplDiv.cloneNode(false);
checkbox.className='fdp-checkbox fdp-color-widget-sub fdp-color-text-onpoint fdp-color-border-onpoint';
check=this.makeCheckSvg();
if(FDP.getParam())
check.firstChild.style.strokeWidth=FDP.getParam().checkWidth+'px';
checkbox.appendChild(check);
ele.insertBefore(checkbox,ele.firstChild);}
if(prop.indexType==='png'){
index=tmplImg.cloneNode(false);
index.className='access6-index';}else {
index=tmplDiv.cloneNode(false);
index.className='access6-index';}
ele.insertBefore(index,sname);
if(prop.showType){
type=tmplDiv.cloneNode(false);
type.className='access6-type fdp-color-widget-sub-border';
ele.insertBefore(type,ele.lastChild);}
},
changeCheckBoxState:function(ele,state,anim){
var checkbox=ele.getElementsByClassName('fdp-checkbox')[0];
var classList=checkbox.classList;
var eles=[checkbox.firstChild,checkbox.firstChild.firstChild];
if(anim){
classAdd(checkbox,'anim');}else {
classRemove(checkbox,'anim');}
if(state){
eles.forEach(function(ele){
classAdd(classRemove(ele,'unchecked'),'checked');});}else {
eles.forEach(function(ele){
classAdd(classRemove(ele,'checked'),'unchecked');});}
},
changeCheckBoxDisplay:function(ele,display){
var checkbox=ele.getElementsByClassName('fdp-checkbox')[0];
if(display){
checkbox.style.visibility='';}else {
checkbox.style.visibility='hidden';}
},
setIndex:function(ele,index){
var indexEle=ele.getElementsByClassName('access6-index')[0];
setListBtnEleContent(indexEle,index);},
setSname:function(ele,sname){
var snameEle=ele.getElementsByClassName('access6-sname')[0];
setListBtnEleContent(snameEle,sname);},
setType:function(ele,type){
var typeEle=ele.getElementsByClassName('access6-type')[0];
setListBtnEleContent(typeEle,type);},
setIcon:function(ele,icon,iconType){
var iconEle=ele.getElementsByClassName('access6-index')[0];
if(iconType==='png'){
iconEle.src=icon;}else {
if(iconEle.classList[1])
iconEle.classList.remove(iconEle.classList[1]);
iconEle.classList.add(icon);}
},
setIcon2:function(ele,icon2){
var icon2Ele=ele.getElementsByClassName('access6-icon2')[0];
if(icon2==''){
icon2Ele.style.visibility='hidden';}else {
icon2Ele.style.visibility='visible';
icon2Ele.src=icon2;}
}
};
var Access6Obj=UTIL.Class.create(
BaseListBtnObj,{
type:'access6',
eleFunc:access6Element,
enableFocus:true,
__construct:function(arg,parentObj){
this.isFocus=false;
if(arg.template){
this.ele=arg.template.ele.cloneNode(arg);
arg.indexType=arg.template.arg.indexType;
arg.checkBox=arg.template.arg.checkBox;
arg.showType=arg.template.arg.showType;}else {
this.ele=this.makeElement(arg);}
this.id=arg.id;
this.parentObj=parentObj;
this.setDisable(arg.disable);
this.help=arg.help;
this.enableFocus=arg.enableFocus===false?false:true;
this.accessHook=arg.accessHook;
this.focusHook=arg.focusHook;
this.unfocusHook=arg.unfocusHook;
this.indexType=arg.indexType||'text';
if(arg.enterTxt){
this.enterTxt=arg.enterTxt;}
if(arg.template){
}else {
this.eleFunc.initBtn(this.ele,arg);}
this.checkBox=arg.checkBox||false;
this.changeCheckBoxState(arg.checkBoxState,false);
this.changeCheckBoxDisplay(arg.checkBoxDisplay);
if((this.indexType==='png')||(this.indexType==='icon')){
this.setIcon(arg.index);}else {
this.setIndex(arg.index);}
this.setSname(arg.sname);
if(arg.showType)
this.setType(arg.typeText);
this.setIcon2(arg.icon2);},
clearDisp:function(){
this.changeCheckBoxDisplay(false);},
changeCheckBoxState:function(state,anim){
if(!this.checkBox)
return this;
if(state===undefined)
return this;
this.checkBoxState=state;
anim=(anim===undefined)?true:anim;
this.eleFunc.changeCheckBoxState(this.ele,state,anim);
return this;},
changeCheckBoxDisplay:function(display){
if(!this.checkBox)
return this;
if(display===undefined)
display=true;
this.checkBoxDisplay=display;
this.eleFunc.changeCheckBoxDisplay(this.ele,display);
return this;},
setIndex:function(index){
if(index){
this.index=index;
this.eleFunc.setIndex(this.ele,index);}
return this;},
setSname:function(sname){
if(sname||sname==''){
this.sname=sname;
this.eleFunc.setSname(this.ele,sname);}
return this;},
setType:function(type){
if(type){
this.type=type;
this.eleFunc.setType(this.ele,type);}
return this;},
setIcon:function(icon){
if(icon){
this.icon=icon;
this.eleFunc.setIcon(this.ele,icon,this.indexType);}
return this;},
setIcon2:function(icon2){
if(icon2||icon2==''){
this.icon2=icon2;
this.eleFunc.setIcon2(this.ele,icon2);}
return this;},
updateData:function(prop){
this.changeCheckBoxState(prop.checkBoxState);
this.changeCheckBoxDisplay(prop.checkBoxDisplay);
this.setIndex(prop.index);
this.setSname(prop.sname);
this.setType(prop.typeText);
if((this.indexType==='png')||(this.indexType==='icon')){
this.setIcon(prop.index);}else {
this.setIndex(prop.index);}
this.accessHook=prop.accessHook;
this.focusHook=prop.focusHook;
this.unfocusHook=prop.unfocusHook;
return this;},
setSelectedColor:function(){
this.ele.classList.add('fdp-color-text-point');
if(this.eleFunc.getIcon)
this.eleFunc.getIcon(this.ele).classList.add('fdp-color-text-point');},
unsetSelectedColor:function(){
this.ele.classList.remove('fdp-color-text-point');
if(this.eleFunc.getIcon)
this.eleFunc.getIcon(this.ele).classList.remove('fdp-color-text-point');},
setSelectedBgColor:function(){
this.ele.classList.add('fdp-color-point-onbase');},
unsetSelectedBgColor:function(){
this.ele.classList.remove('fdp-color-point-onbase');},
keyHook:function(ev){
var ret=false;
if(this.disable)
return ret;
if(ev.type==='keydown'){
var enterKey=keyDef.getEnterKey();
switch(ev.keyCode){
case enterKey:
case keyDef.ENTER:
this.dispatchAccess();
ret=true;
break;}
}
return ret;}
}
);

var informationElement={
make:(function(){
var tmpl=null;
var func=function(prop){
var borderEle;
if(tmpl===null){
tmpl=makeListButtonElement();
tmpl.getElementsByClassName('title')[0].classList.add('fdp-no-wrap');
borderEle=tmplDiv.cloneNode(true);
borderEle.textContent=':';
borderEle.className='fdp-information-border';
tmpl.insertBefore(borderEle,this.getValueEle(tmpl));}
var ele=tmpl.cloneNode(true);
return ele;};
return func;}()),
dispBorder:function(ele,disp){
var border=ele.getElementsByClassName('fdp-information-border')[0];
if(disp)
border.style.visibility='';
else
border.style.visibility='hidden';}
};
UTIL.extend(listButton,informationElement);
var InformationObj=UTIL.Class.create(
BaseListBtnObj,{
type:'access',
eleFunc:informationElement,
enableFocus:false,
__construct:function(arg,parentObj){
this.__init(arg,parentObj);
this.setValue(arg.value);
this.enableFocus=arg.enableFocus||false;
this.accessHook=arg.accessHook;
this.withBorder=(arg.withBorder===false)?false:true;
if(arg.enterTxt){
this.enterTxt=arg.enterTxt;}
if(!this.enableFocus){
if(arg.withUnderline)
this.ele.classList.add('fdp-color-btn-transparent-back');
else
this.ele.classList.add('fdp-color-btn-transparent');}
if(!this.withBorder)
this.eleFunc.dispBorder(this.ele,false);},
setValue:function(value){
if(value!==undefined){
this.value=value;
this.eleFunc.setValue(this.ele,value);}
return this.ele;},
keyHook:function(ev){
var ret=false;
if(this.disable)
return ret;
if(ev.type==='keydown'){
var enterKey=keyDef.getEnterKey();
switch(ev.keyCode){
case enterKey:
case keyDef.ENTER:
this.dispatchAccess();
ret=true;
break;}
}
return ret;}
});

var keyboardElement={
make:(function(){
var tmpl=null;
var func=function(prop){
if(tmpl===null){
tmpl=makeListButtonElement();}
var ele=tmpl.cloneNode(true);
return ele;};
return func;}())
};
UTIL.extend(listButton,keyboardElement);
var KeyboardObj=UTIL.Class.create(
BaseListBtnObj,{
type:'keyboard',
eleFunc:keyboardElement,
enableFocus:true,
__construct:function(arg,parentObj){
var frag;
this.ele=tmplDiv.cloneNode(false);
this.ele.className='fdp-list';
this.ele.id='keyboards-wrapper';
var objs=tmplDiv.cloneNode(false);
var keys=FDP.KBD.keys.make(FDP.KBD.mngLayouts.getLayout(arg.language));
keys.id='keyboard';
var obj=this.makeElement(arg);
objs.appendChild(obj);
objs.appendChild(keys);
this.ele.appendChild(objs);
this.setTitle(arg.title);
if(arg.value!==undefined)
this.setValue(arg.value);
this.value=arg.value;
this.mngMoveTable=new FDP.KBD.MngMoveTable(keys,'keyboard-row','keyboard-key');
this.setFocusElement(arg.focusEleId);
this.id=arg.id;
this.eventHook=arg.eventHook;
FDP.KBD.mngEdited.init(this.getValue.bind(this),this.setValue.bind(this),
arg.maxLength,FDP.KBD.mngLayouts.getUpperCase(arg.language));
this.numKeytimerId=null;},
destroy:function(){
},
setValue:function(value){
this.value=value;
this.eleFunc.setValue(this.ele,value);
return this.ele;},
getValue:function(){
return this.value;},
dispatchValueChange:function(){
if(this.eventHook){
this.eventHook({type:'valuechange',
obj:this,
value:this.getValue()
});}
},
setFocusElement:function(id){
if(id){
this.myFocus=false;
this.focusEle=document.getElementById(id);}else {
this.myFocus=true;
this.focusEle=tmplDiv.cloneNode(false);
this.focusEle.className='fdp-focus fdp-color-focus hide';
this.ele.appendChild(this.focusEle);}
this.focusEle.dataset.movetoedge='no';},
focus:function(){
var self=this;
var callback=function(ev,callback){
transitionCallback.remove(ev.target,callback);
self.showFocus(false);
self.__onFocus();
};
this.moveFocus(this.mngMoveTable.getCurrentObj(),callback,false);},
unfocus:function(){
hideFocus(this.focusEle);
this.__onBlure();},
showFocus:function(){
var obj=FDP.KBD.keys.stripButton(this.mngMoveTable.getCurrentObj());
showFocus(obj,null,this.focusEle,null,true);},
moveFocus:function(ele,callback,anim){
if(anim===undefined)
anim=true;
moveFocus(FDP.KBD.keys.stripButton(ele),null,callback,this.focusEle,null,anim);},
mvFocusFunc:function(dst){
if(dst.obj){
this.moveFocus(dst.obj,function(ev,callback){
transitionCallback.remove(ev.target,callback)},!dst.over);}
},
keyHook:function(ev){
var ret=false;
var path=null;
var file=null;
var self=this;
var getObjByInc=this.mngMoveTable.getObjByIncrement.bind(this.mngMoveTable);
var tempNumKeyTimer=null;
if(this.disable)
return ret;
if(ev.type==='keydown'){
tempNumKeyTimer=this.numKeytimerId;
clearTimeout(this.numKeytimerId);
this.numKeytimerId=null;
switch(ev.keyCode){
case keyDef.UP:
this.mvFocusFunc(getObjByInc(-1,0));
FDP.KBD.mngEdited.resetNumKeyRepeat();
ret=true;
break;
case keyDef.DOWN:
this.mvFocusFunc(getObjByInc(1,0));
FDP.KBD.mngEdited.resetNumKeyRepeat();
ret=true;
break;
case keyDef.LEFT:
this.mvFocusFunc(getObjByInc(0,-1));
FDP.KBD.mngEdited.resetNumKeyRepeat();
ret=true;
break;
case keyDef.RIGHT:
this.mvFocusFunc(getObjByInc(0,1));
FDP.KBD.mngEdited.resetNumKeyRepeat();
ret=true;
break;
case keyDef.RED:
if(FDP.getGblValue('area')!='jp'){
FDP.KBD.mngEdited.keyDelete();
this.dispatchValueChange();}
FDP.KBD.mngEdited.resetNumKeyRepeat();
ret=true;
break;
case keyDef.YELLOW:
if(FDP.getGblValue('area')==='jp'){
FDP.KBD.mngEdited.keyDelete();
this.dispatchValueChange();}
FDP.KBD.mngEdited.resetNumKeyRepeat();
ret=true;
break;
case keyDef.BLUE:
if(FDP.getGblValue('area')!='jp'){
FDP.KBD.mngEdited.keyAllDelete();
this.dispatchValueChange();}
FDP.KBD.mngEdited.resetNumKeyRepeat();
ret=true;
break;
case keyDef.ENTER:
FDP.KBD.mngEdited.sendKeycode(this.mngMoveTable.getCurrentObj().dataset.keycode);
this.dispatchValueChange();
FDP.KBD.mngEdited.resetNumKeyRepeat();
ret=true;
break;
case keyDef.VK_0:
case keyDef.VK_1:
case keyDef.VK_2:
case keyDef.VK_3:
case keyDef.VK_4:
case keyDef.VK_5:
case keyDef.VK_6:
case keyDef.VK_7:
case keyDef.VK_8:
case keyDef.VK_9:
case keyDef.VK_D0:
case keyDef.VK_D1:
case keyDef.VK_D2:
case keyDef.VK_D3:
case keyDef.VK_D4:
case keyDef.VK_D5:
case keyDef.VK_D6:
case keyDef.VK_D7:
case keyDef.VK_D8:
case keyDef.VK_D9:
var upperCase;
if(tempNumKeyTimer){
if(FDP.KBD.mngEdited.checkNumKeyChanged(keyDef.convNumberKey(ev.keyCode))){
FDP.KBD.mngEdited.sendKeycode(self.mngMoveTable.getCurrentObj().dataset.keycode);
self.dispatchValueChange();}
}
upperCase=FDP.KBD.mngEdited.getKeyCodeByNumKey(keyDef.convNumberKey(ev.keyCode));
this.mvFocusFunc({
obj:this.mngMoveTable.serchObj(upperCase.keycode.charCodeAt(0))});
if(upperCase.length==1){
FDP.KBD.mngEdited.sendKeycode(self.mngMoveTable.getCurrentObj().dataset.keycode);
self.dispatchValueChange();}else if(upperCase.length>1){
this.numKeytimerId=setTimeout(function(){
FDP.KBD.mngEdited.sendKeycode(self.mngMoveTable.getCurrentObj().dataset.keycode);
self.dispatchValueChange();
FDP.KBD.mngEdited.resetNumKeyRepeat();
self.numKeytimerId=null;},1*1000);}
ret=true;
break;
default:
break;}
}else if(ev.type==='keypress'){
if(ev.charCode)
{
var obj=this.mngMoveTable.serchObj(ev.charCode);
if(obj){
this.mvFocusFunc({obj:obj});
FDP.KBD.mngEdited.sendKeycode(self.mngMoveTable.getCurrentObj().dataset.keycode);
self.dispatchValueChange();
FDP.KBD.mngEdited.resetNumKeyRepeat();}
}
ret=true;}
return ret;}
}
);

var inputElement={
makeInputEle:(function(){
var tmpl=null;
var calcMinW=function(){
var minW,sizeDiv;
sizeDiv=tmplDiv.cloneNode(false);
sizeDiv.style.position='absolute';
sizeDiv.style.visibility='hidden';
sizeDiv.style.display='block';
sizeDiv.textContent='8';
sizeDiv.classList.add('fdp-font-normal');
document.body.appendChild(sizeDiv);
minW=sizeDiv.offsetWidth;
document.body.removeChild(sizeDiv);
return minW;};
var func=function(prop){
if(tmpl===null){
tmpl=tmplDiv.cloneNode(false);
tmpl.className='fdp-input-wrap';
if(getDirection()==='rtl'){
tmpl.style.direction='ltr';
tmpl.style.webkitJustifyContent='flex-end';}
tmpl.dataset.minW=calcMinW();}
return tmpl.cloneNode(true);};
return func;}()),
make:(function(){
var tmpl=null;
var func=function(prop){
if(tmpl===null){
var valueDiv,inputWrap;
tmpl=makeListButtonElement();
valueDiv=listButton.getValueEle(tmpl);
inputWrap=this.makeInputEle();
valueDiv.appendChild(inputWrap);
tmpl.dataset.minW=inputWrap.dataset.minW;}
var ele=tmpl.cloneNode(true);
return ele;};
return func;}()),
initValue:function(ele,value,length,password,unit){
var i,inputWrap,inputVal,unitDiv,numTotal=0;
inputWrap=ele.getElementsByClassName('fdp-input-wrap')[0];
for(i=0;i<length;i++){
inputVal=tmplDiv.cloneNode(false);
if(password){
inputVal.textContent='*';
inputVal.classList.add('focus-ele');
numTotal++;}else {
if(value.charAt(i)){
inputVal.textContent=value.charAt(i);
if(isNaN(value.charAt(i))){
}else {
inputVal.classList.add('focus-ele');
numTotal++;}
}
else {
inputVal.textContent=' ';
inputVal.classList.add('focus-ele');
numTotal++;}
}
inputVal.style.minWidth=inputWrap.dataset.minW+'px';
inputWrap.appendChild(inputVal);}
if(unit){
unitDiv=tmplDiv.cloneNode(false);
unitDiv.classList.add('fdp-input-unit');
setListBtnEleContent(unitDiv,unit);
inputWrap.appendChild(unitDiv);}
return numTotal;},
setUnit:function(ele,unit){
var unitDiv=ele.getElementsByClassName('fdp-input-unit')[0];
setListBtnEleContent(unitDiv,unit);},
setValueOne:function(ele,value,focusPos,password){
var inputWrap,target;
inputWrap=ele.getElementsByClassName('fdp-input-wrap')[0];
target=inputWrap.getElementsByClassName('focus-ele')[focusPos];
if(password)
target.textContent='*';
else
target.textContent=value;},
setValue:function(ele,value,password){
var i,inputWrap,targets,newValue='',chara;
inputWrap=ele.getElementsByClassName('fdp-input-wrap')[0];
targets=inputWrap.getElementsByClassName('focus-ele');
for(i=0;i<value.length;i++){
chara=value.charAt(i);
if(isNaN(chara)){
}else {
newValue+=chara;}
}
for(i=0;i<targets.length;i++){
if(password){
targets[i].textContent='*';}else {
targets[i].textContent=(newValue.charAt(i)||' ');}
}
},
getValue:function(ele){
},
setFocus:function(ele,pos){
var i,inputWrap;
inputWrap=ele.getElementsByClassName('fdp-input-wrap')[0];
inputWrap.getElementsByClassName('focus-ele')[pos].classList.add('fdp-color-point');},
unSetFocus:function(ele){
var i,inputWrap,target;
inputWrap=ele.getElementsByClassName('fdp-input-wrap')[0];
target=inputWrap.getElementsByClassName('fdp-color-point')[0];
if(target)
target.classList.remove('fdp-color-point');}
};
UTIL.extend2(listButton,inputElement);
var InputObj=UTIL.Class.create(
BaseListBtnObj,{
type:'input',
eleFunc:inputElement,
enableFocus:true,
__construct:function(arg,parentObj){
this.__init(arg,parentObj);
this.enableFocus=arg.enableFocus===false?false:true;
this.password=arg.password;
this.strings=arg.strings;
this.unit=arg.unit;
this.cursorPos=arg.cursorPos||0;
if(arg.stringsLength===undefined){
this.stringsLength=this.strings.length;}else {
this.stringsLength=arg.stringsLength;}
this.numTotal=this.eleFunc.initValue(this.ele,arg.strings,this.stringsLength,this.password,this.unit);
this.valueChangeHook=arg.valueChangeHook;
if(arg.helpMessage){
this.numTxt=arg.helpMessage;}
},
getValue:function(){
return this.strings;},
setUnit:function(unit){
this.unit=unit;
this.eleFunc.setUnit(this.ele,unit);
return this;},
getUnit:function(){
return this.unit;},
setValue:function(strings){
this.strings=strings;
this.eleFunc.setValue(this.ele,this.strings,this.password);
return this;},
setValueOne:function(value,cursorPos){
var newStrings='';
var i,chara,focusNum=0;
if(cursorPos===undefined)
cursorPos=this.cursorPos;
if(value===-1||value==='NaN'){
value=' ';}
for(i=0;i<this.stringsLength;i++){
chara=this.strings.charAt(i);
if(isNaN(chara)&&chara!=='i'){
newStrings+=chara;}else {
if(focusNum===cursorPos){
newStrings+=value;}else {
if(chara)
newStrings+=chara;
else
newStrings+=' ';}
focusNum++;}
}
this.strings=newStrings;
this.eleFunc.setValueOne(this.ele,value,cursorPos,this.password);
return this;},
focus:function(){
BaseListBtnObj.prototype.focus.call(this);
if(this.disable==false){
this.eleFunc.setFocus(this.ele,this.cursorPos);}
return this;},
unfocus:function(){
BaseListBtnObj.prototype.unfocus.call(this);
this.eleFunc.unSetFocus(this.ele);
return this;},
moveCursor:function(inc){
if(inc===-1){
if(this.cursorPos>0){
this.setCursorPos(this.cursorPos-1);}
}else {
if(this.cursorPos<this.numTotal-1){
this.setCursorPos(this.cursorPos+1);}
}
return this;},
setCursorPos:function(pos){
if(this.cursorPos!==pos){
this.cursorPos=pos;
this.eleFunc.unSetFocus(this.ele);
this.eleFunc.setFocus(this.ele,this.cursorPos);}
return this;},
keyHook:function(ev){
var ret=false;
var val,oldStrings;
if(this.disable)
return ret;
if(ev.type==='keydown'){
switch(ev.keyCode){
case keyDef.LEFT:
this.moveCursor(-1);
ret=true;
break;
case keyDef.RIGHT:
this.moveCursor(1);
ret=true;
break;
case keyDef.VK_0:
case keyDef.VK_1:
case keyDef.VK_2:
case keyDef.VK_3:
case keyDef.VK_4:
case keyDef.VK_5:
case keyDef.VK_6:
case keyDef.VK_7:
case keyDef.VK_8:
case keyDef.VK_9:
case keyDef.VK_D0:
case keyDef.VK_D1:
case keyDef.VK_D2:
case keyDef.VK_D3:
case keyDef.VK_D4:
case keyDef.VK_D5:
case keyDef.VK_D6:
case keyDef.VK_D7:
case keyDef.VK_D8:
case keyDef.VK_D9:
oldStrings=this.strings;
this.setValueOne(keyDef.convNumberKey(ev.keyCode),this.cursorPos);
this.moveCursor(1);
if(oldStrings!==this.strings)
this.dispatchValueChange();
ret=true;
break;
case keyDef.YELLOW:
if(FDP.getGblValue('area')==='jp'){
oldStrings=this.strings;
this.setValueOne(keyDef.convNumberKey(ev.keyCode),this.cursorPos);
var chara=0;
var Last=0;for(var i=this.cursorPos+1;i<this.stringsLength;i++){
chara=parseInt(this.strings.charAt(i));
if(chara>=0&&chara<=9){
Last=1;
break;}
}
if(Last===0){
this.moveCursor(-1);}else {
var tmpStr=this.strings.replace(/\D/g,'');
for(var j=this.cursorPos;j<this.stringsLength;j++){
if(j<tmpStr.length)
chara=parseInt(tmpStr.charAt(j));
else
chara=' ';
if(chara>=0&&chara<=9){
this.setValueOne(chara,j);}else {
this.setValueOne(-1,j);}
}
}
if(oldStrings!==this.strings)
this.dispatchValueChange();
ret=true;
break;}else {
ret=false;
break;}
case system.event.DOM_VK_INFO:
oldStrings=this.strings;
this.setValueOne('i',this.cursorPos);
this.moveCursor(1);
if(oldStrings!==this.strings)
this.dispatchValueChange();
ret=true;
break;}
}
return ret;}
}
);

var rowElement={
make:(function(){
var tmpl=null;
var func=function(prop){
var ele;
if(tmpl===null){
tmpl=makeListButtonBaseElement();
tmpl.appendChild(tmplDiv.cloneNode(false));
tmpl.classList.add('fdp-row-btn');}
ele=tmpl.cloneNode(true);
return ele;};
return func;}()),
makeTextForm:(function(){
var tmpl=null;
var func=function(prop){
var ele;
if(tmpl===null){
tmpl=tmplDiv.cloneNode(false);
tmpl.className='fdp-row-form fdp-row-text';
tmpl.dataset.type='text';}
ele=tmpl.cloneNode(true);
return ele;};
return func;}()),
makePngForm:(function(){
var tmpl=null;
var func=function(prop){
var ele,pngDiv;
if(tmpl===null){
tmpl=tmplDiv.cloneNode(false);
pngDiv=document.createElement('img');
tmpl.appendChild(pngDiv);
tmpl.className='fdp-row-form fdp-row-png';
tmpl.dataset.type='png';}
ele=tmpl.cloneNode(true);
return ele;};
return func;}()),
initForm:function(ele,forms){
var i,formEle,form,eleStyle;
for(i=0;i<forms.length;i++){
form=forms[i];
switch(form.type){
case 'text':
formEle=this.makeTextForm();
break;
case 'png':
formEle=this.makePngForm();
break;}
if(formEle){
eleStyle=formEle.style;
if(form.width===undefined){
eleStyle.width=100/forms.length+'%';}else {
eleStyle.width=form.width;}
if(form.textAlign!==undefined)
eleStyle['text-align']=form.textAlign;
if(form.pngWidth!==undefined)
formEle.firstChild.style.width=form.pngWidth;
if(form.pngHeight!==undefined)
formEle.firstChild.style.height=form.pngHeight;
ele.appendChild(formEle);}
}
},
setData:function(ele,data,pos){
var i,formEle;
var forms=ele.getElementsByClassName('fdp-row-form');
var setData=function(formEle,data){
switch(formEle.dataset.type){
case 'text':
setListBtnEleContent(formEle,data);
break;
case 'png':
formEle.firstChild.src=data;
if(data&&(typeof data==='string')){
formEle.firstChild.className='show';}else {
formEle.firstChild.className='hide';}
break;}
};
for(i=0;i<forms.length;i++){
formEle=forms[i];
setData(formEle,data[i]);}
},
setDisable:function(disable){
}
};
var RowObj=UTIL.Class.create(
BaseListBtnObj,{
type:'row',
eleFunc:rowElement,
enableFocus:true,
__construct:function(arg,parentObj){
if(arg.template){
this.ele=arg.template.ele.cloneNode(true);}else {
this.ele=this.makeElement(arg);
this.form=arg.form;
this.eleFunc.initForm(this.ele,this.form);}
this.data=arg.data;
if(this.data)
this.eleFunc.setData(this.ele,this.data);
this.parentObj=parentObj;
this.setDisable(arg.disable);
this.enableFocus=arg.enableFocus===false?false:true;
this.accessHook=arg.accessHook;
this.focusHook=arg.focusHook;
this.unfocusHook=arg.unfocusHook;},
setData:function(data,pos){
if(pos===undefined){
this.data=data;}else {
this.data[pos]=data;}
this.eleFunc.setData(this.ele,this.data,pos);},
getData:function(){
return this.data;},
updateData:function(prop){
this.setData(prop.data);
this.accessHook=prop.accessHook;
this.focusHook=prop.focusHook;
this.unfocusHook=prop.unfocusHook;
return this;},
setSelectedBgColor:function(){
this.ele.classList.add('fdp-color-point-onbase');},
unsetSelectedBgColor:function(){
this.ele.classList.remove('fdp-color-point-onbase');},
keyHook:function(ev){
var ret=false;
if(this.disable)
return ret;
if(ev.type==='keydown'){
var enterKey=keyDef.getEnterKey();
switch(ev.keyCode){
case enterKey:
case keyDef.ENTER:
this.dispatchAccess();
ret=true;
break;}
}
return ret;}
}
);

var getSelectorTmpl=(function(){
var tmpl=null;
var func=function(className){
var ele;
if(tmpl===null){
var title,wrap,dummy;
tmpl=tmplDiv.cloneNode(false);
title=makeListButtonElement();
title.classList.remove('fdp-color-base-sub');
title.classList.remove('fdp-color-base-sub-a');
title.classList.add('fdp-color-point');
tmpl.appendChild(title);
wrap=tmplDiv.cloneNode(false);
wrap.classList.add('selector-wrap');
dummy=tmplDiv.cloneNode(false);
dummy.classList.add('selector-dummy');
wrap.appendChild(dummy);
tmpl.appendChild(title);
tmpl.appendChild(wrap);}
ele=tmpl.cloneNode(true);
ele.className=className;
return ele;};
return func;}());

var choiceCommonFuncs={
__choiceInit:function(arg,parentObj){
BaseListBtnObj.prototype.__init.call(this,arg,parentObj);
this.reverse=arg.reverse||false;
this.setList(arg.list,arg.value);
this.onePopup=arg.onePopup||false;
this.enableFocus=(arg.enableFocus===false)?false:true;
this.loop=(arg.loop===undefined)?true:arg.loop;
this.valueChangeHook=arg.valueChangeHook;
this.help=arg.help;},
setList:function(list,value){
this.list=copyArray(list);
if(value===undefined)
value=this.value;
this.setValue(value,true);
return this;},
getList:function(){
return this.list;},
setValue:function(value,reverse){
if((value<0)||(value>=this.list.length))
return null;
if(reverse&&this.reverse)
this.value=(this.list.length-value-1);
else
this.value=value;
this.eleFunc.setValue(this.ele,this.list[this.value]);
return this;},
setFixString:function(string){
this.eleFunc.setValue(this.ele,string);},
unSetFixString:function(){
this.eleFunc.setValue(this.ele,this.list[this.value]);},
getValue:function(){
if(this.reverse)
return (this.list.length-this.value-1);
else
return this.value;}
};
var choiceElement={
make:(function(){
var tmpl=null;
var func=function(prop){
if(tmpl===null){
tmpl=makeListButtonElement();}
var ele=tmpl.cloneNode(true);
return ele;};
return func;}()),
makeSelector:(function(){
var tmpl=null;
var func=function(prop){
if(tmpl===null){
var title,list,dummy;
tmpl=getSelectorTmpl('choice-selector');}
var ele=tmpl.cloneNode(true);
return ele;};
return func;}()),
setInputEle:function(ele,inputEle){
this.valueWrap=this.getValueEle(ele);
this.valueWrap.textContent='';
this.valueWrap.appendChild(inputEle);
return ele;},
setSelectorParam:function(selector,baseEle){
var width=baseEle.offsetWidth;
selector.getElementsByClassName('fdp-list-btn')[0].style.width='-webkit-calc('+width+'px - 10rem)';
width=listButton.getTitleEle(baseEle).offsetWidth;
selector.getElementsByClassName('selector-dummy')[0].style.width='-webkit-calc('+width+'px - .2rem)';
width=listButton.getValueEle(baseEle).offsetWidth;
if(FDP.fontSmall){
selector.getElementsByClassName('choice-list')[0].style.width='-webkit-calc('+width+'px + 8rem)';}else {
selector.getElementsByClassName('choice-list')[0].style.width='-webkit-calc('+width+'px + 10rem)';}
return selector;},
setSelectorTitle:function(selector,title){
listButton.setTitle(selector.firstChild,title);
return selector;},
addChoiceList:function(selector,list){
list.classList.add('choice-list');
list.classList.add('fdp-pop-border');
selector.getElementsByClassName('selector-wrap')[0].appendChild(list);
return selector;}
};
UTIL.extend(listButton,choiceElement);
var ChoiceObj=UTIL.Class.create(
BaseListBtnObj,{
type:'choice',
enableFocus:true,
eleFunc:choiceElement,
__construct:function(arg,parentObj){
var inputProp;
this.__choiceInit(arg,parentObj);
this.showSelectorHook=arg.showSelectorHook;
this.hideSelectorHook=arg.hideSelectorHook;
this.accessHook=arg.accessHook;
this.inputMode=false;
if(arg.withInputMode){
inputProp=copyProp(arg);
inputProp.centerRatio='0%';
inputProp.title='';
inputProp.focusHook=undefined;
inputProp.unfocusHook=undefined;
inputProp.valueChangeHook=this.__inputValueChangeHook.bind(this);
this.inputObj=new InputObj(inputProp,this);
this.inputObj.ele.style.padding='0';
this.inputObj.ele.classList.add('fdp-color-transparent');
}
},
focus:function(){
if(this.inputObj)
this.inputObj.focus();
BaseListBtnObj.prototype.focus.call(this);
return this.ele;},
unfocus:function(){
if(this.inputObj)
this.inputObj.unfocus();
BaseListBtnObj.prototype.unfocus.call(this);
return this.ele;},
__inputValueChangeHook:function(ev){
this.strings=this.inputObj.getValue();
if(this.parentObj)
this.parentObj.dispatchEvent('valuechange',this);
if(this.valueChangeHook){
this.valueChangeHook({
type:'valuechange',
obj:this,
value:this.inputObj.getValue()
});}
},
getInputValue:function(){
return this.inputObj.getValue();},
setInputValue:function(strings){
this.inputObj.setValue(strings);
this.strings=this.inputObj.getValue();
return this;},
setValueOne:function(value,cursorPos){
this.inputObj.setValue(value,cursorPos);
return this;},
getUnit:function(){
return this.inputObj.getUnit();},
setUnit:function(unit){
this.inputObj.setUnit(unit);
return this;},
moveCursor:function(inc){
this.inputObj.moveCursor(inc);
return this;},
setCursorPos:function(pos){
this.inputObj.setCursorPos(pos);
return this;},
isInputMode:function(){
return this.inputMode;},
activateInput:function(){
if(this.inputObj){
this.eleFunc.setInputEle(this.ele,this.inputObj.ele);
this.inputObj.focus();
this.inputMode=true;}
return this;},
deActivateInput:function(){
if(this.inputObj){
this.inputObj.unfocus();
this.setValue(this.value);
this.inputMode=false;}
return this;},
selectorKeyHook:function(ev){
var ret=false;
if(!this.valueList)
return true;
if(!this.valueList.isFocus)
return true;
var blockKey=isLtr()?keyDef.RIGHT:keyDef.LEFT;
if(!(ev.keyCode===blockKey)){
ret=this.valueList.keyHook(ev);}
if(ev.type==='keydown'){
if((ev.keyCode===keyDef.DOWN)||(ev.keyCode===keyDef.UP))
ret=true;}
if(ret)
return true;
if(ev.type==='keydown'){
var backKey=isLtr()?keyDef.LEFT:keyDef.RIGHT;
switch(ev.keyCode){
case keyDef.RETURN:
case keyDef.ENTER:
case backKey:
this.hideSelector();
ret=true;
break;
case blockKey:
ret=true;
break;}
}
return ret;},
keyHook:function(ev){
var ret=false;
if(this.disable)
return ret;
if(this.isSelectMode){
ret=this.selectorKeyHook(ev);}
if(ret)
return true;
if(this.inputObj&&this.inputObj.isFocus){
ret=this.inputObj.keyHook(ev);
if(ret)
return true;}
if(ev.type==='keydown'){
var enterKey=keyDef.getEnterKey();
switch(ev.keyCode){
case enterKey:
case keyDef.ENTER:
this.showSelector(this.parentObj.getValueSelectorEle());
ret=true;
break;}
}
return ret;},
makeChoiceList:function(){
var list=null;
var item_list=[];
for(var i=0,len=this.list.length;i<len;i++){
item_list.push({
type:'access',
subType:'access2',
title:this.list[i]
});}
list=new FDP.UI.List({
focusIdx:this.value,
list:item_list,
loop:this.loop,
eventHook:this.eventHook.bind(this)
});
return list;},
eventHook:function(ev){
if(ev.type==='access'){
this.dispatchAccess();
this.hideSelector();}
},
showChoiceList:function(){
var self=this;
var ele=this.valueList.ele;
this.valueList.moveFocus('next',null,false,false);
ele.classList.remove('invisible');
if(FDP.anim){
ele.classList.add('move');}
ele.style.webkitTransform='translateX(0px)';
var animCallback=function(ev,callback){
if(FDP.anim){
ele.classList.remove('move');
transitionCallback.remove(ev.target,callback);}
ele.style.webkitTransform='';
self.valueList.focus({syncDraw:true});};
if(FDP.anim)
transitionCallback.add(ele,animCallback);
else
animCallback();},
showSelector:function(parent){
var style,rect,ele,list;
var self=this;
if(this.isSelectMode)
return;
this.deActivateInput();
this.isSelectMode=true;
if(this.parentObj)
this.parentObj.dispatchEvent('showselector',this,this.onePopup);
this.valueList=list=this.makeChoiceList();
style=parent.style;
rect=this.ele.getBoundingClientRect();
style.top=rect.top+'px';
style.left=rect.left+'px';
parent.dataset.otop=rect.top;
ele=this.eleFunc.makeSelector();
this.eleFunc.setSelectorTitle(ele,this.title);
this.eleFunc.addChoiceList(ele,list.ele);
this.eleFunc.setSelectorParam(ele,this.ele);
parent.classList.add('show');
parent.appendChild(ele);

if(FDP.isLtr())
list.ele.style.webkitTransform='translateX(2rem)';
else
list.ele.style.webkitTransform='translateX(-2rem)';

(function(){
var btnH=list.getBtnElement(0).offsetHeight;
var btnNum=Math.floor((window.innerHeight-btnH)/btnH);
var listH,listOffset,topOffset,bottomOffset;
list.ele.style.maxHeight=btnH*btnNum+'px';listH=list.ele.offsetHeight;
if(self.onePopup){
if(list.objlist.length==1){
listOffset=-btnH;}else {
listOffset=-listH+btnH+btnH/2-btnH;}
}else {
listOffset=-(listH-rect.height)/2-btnH;
topOffset=(btnH/2-(listOffset+rect.top+rect.height));
bottomOffset=((listOffset+rect.top+rect.height+listH)-(window.innerHeight-btnH/2));
if(topOffset>0){listOffset+=topOffset;}else if(bottomOffset>0){
listOffset-=bottomOffset;}
}
list.ele.style.top=listOffset+'px';
list.ele.classList.add('invisible');}());
this.selector={
list:list,
ele:ele
};
list.addEventListener('changefocus',function(ev){
if(ev.force)
return;
this.setValue(ev.idx,false);
this.dispatchValueChange();}.bind(this));
if(this.onePopup){
var targetTop=window.innerHeight-rect.height*2;
if(parent.clientTop===targetTop){
self.showChoiceList();}else {
parent.style.webkitTransform='translateY('+(targetTop-rect.top)+'px)';
parent.dataset.transY=targetTop-rect.top;
var popupCallback=function(ev,callback){
if(FDP.anim){
if(ev.propertyName!=='-webkit-transform'){
return;}
ev.target.classList.remove('move');
transitionCallback.remove(ev.target,callback);}
parent.style.webkitTransform='';
parent.style.top=targetTop+'px';
self.showChoiceList();};
if(FDP.anim){
transitionCallback.add(parent,popupCallback);
parent.classList.add('move');}else {
popupCallback();}
}
}else {
this.showChoiceList();}
if(self.showSelectorHook){
self.showSelectorHook({type:'showselector',
obj:self});}
},
hideSelector:function(){
var self=this;
if(!this.isSelectMode)
return;
var parent=this.selector.ele.parentNode;
this.selector.list.removeEventListener('changefocus');
var destroy=function(){
removeAllChild(parent);
self.selector=null;
self.valueList.unfocus();
self.valueList.destroy();
self.valueList=null;
self.isSelectMode=false;
if(self.parentObj)
self.parentObj.dispatchEvent('hideselector',self,self.onePopup);
if(self.hideSelectorHook){
self.hideSelectorHook({type:'hideselector',
obj:self});}
};
if(this.onePopup){
if(this.parentObj)
this.parentObj.dispatchEvent('prehideselector',this,this.onePopup);
this.valueList.unfocus();
this.valueList.ele.classList.add('hide');
var animCallback=function(ev,callback){
if(FDP.anim){
transitionCallback.remove(ev.target,callback);
parent.classList.remove('move');
}
parent.style.webkitTransform='';
destroy();};
if(FDP.anim){
parent.classList.add('move');
}
parent.style.webkitTransform='translateY('+(-parent.dataset.transY)+'px)';
if(FDP.anim)
transitionCallback.add(parent,animCallback);
else
animCallback();}else {
destroy();}
this.removeEventListener('changefocus');}
}
);
UTIL.include2(choiceCommonFuncs,ChoiceObj);
var twoChoiceElement={
make:(function(){
var tmpl=null;
var func=function(prop){
var valueWrap,value1,value2,values,arrowL,arrowR;
if(tmpl===null){
tmpl=makeListButtonElement();
tmpl.getElementsByClassName('title')[0].classList.add('fdp-no-wrap');
valueWrap=this.getValueEle(tmpl);
valueWrap.classList.add('fdp-flex');
valueWrap.style.visibility='hidden';
if(getDirection()==='rtl')
valueWrap.classList.add('fdp-row-reverse');
values=tmplDiv.cloneNode(false);
values.classList.add('fdp-flex');
values.classList.add('fdp-two-choice-wrap');
if(getDirection()==='rtl')
values.classList.add('fdp-row-reverse');
value1=tmplDiv.cloneNode(false);
value1.className='value';
value2=tmplDiv.cloneNode(false);
value2.className='value';
arrowL=tmplArrowL.cloneNode(true);
arrowR=tmplArrowR.cloneNode(true);
arrowL.style.visibility='hidden';
arrowR.style.visibility='hidden';
valueWrap.appendChild(arrowL);
values.appendChild(value1);
values.appendChild(value2);
valueWrap.appendChild(values);
valueWrap.appendChild(arrowR);}
var ele=tmpl.cloneNode(true);
return ele;};
return func;}()),
dispValue:function(ele,disp){
var valueWrap=this.getValueEle(ele);
if(disp){
valueWrap.style.visibility='';}else {
valueWrap.style.visibility='hidden';}
},
setArrowState:function(ele,left,right){
var arrows=ele.getElementsByClassName('fdp-arrow');
var setState=function(ele,state){
if(state)
ele.classList.remove('fdp-disable');
else
ele.classList.add('fdp-disable');};
setState(arrows[0],left);
setState(arrows[1],right);
return ele;},
dispArrow:function(ele,disp){
var i;
var arrows=ele.getElementsByClassName('fdp-arrow');
for(i=0;i<arrows.length;i++){
if(disp)
arrows[i].style.visibility='';
else
arrows[i].style.visibility='hidden';}
},
setList:function(ele,list){
var values=this.getValueEle(ele).getElementsByClassName('value');
setListBtnEleContent(values[0],list[0]);
setListBtnEleContent(values[1],list[1]);},
setValue:function(ele,value){
var values=this.getValueEle(ele).getElementsByClassName('value');
values[value].classList.add('fdp-color-point');
values[(value===0)?1:0].classList.remove('fdp-color-point');}
};
UTIL.extend2(listButton,twoChoiceElement);
var TwoChoiceObj=UTIL.Class.create(
BaseListBtnObj,{
type:'2choice',
enableFocus:true,
eleFunc:twoChoiceElement,
__construct:function(arg,parentObj){
this.__init(arg,parentObj);
this.setList(arg.list,arg.value);
this.focusTitle=arg.focusTitle;
this.enableFocus=arg.enableFocus===false?false:true;
this.accessHook=arg.accessHook;
this.valueChangeHook=arg.valueChangeHook;
this.loop=arg.loop||false;
this.valueDisp=arg.valueDisp||'onFocus';
if(this.valueDisp==='always'){
this.eleFunc.dispValue(this.ele,true);}
},
focus:function(){
this.__onFocus();
if(this.focusTitle)
this.eleFunc.setTitle(this.ele,this.focusTitle);
this.eleFunc.dispArrow(this.ele,true);
if(this.valueDisp==='onFocus'){
this.eleFunc.dispValue(this.ele,true);}
return this;},
unfocus:function(){
this.__onBlure();
if(this.focusTitle)
this.eleFunc.setTitle(this.ele,this.title);
this.eleFunc.dispArrow(this.ele,false);
if(this.valueDisp==='onFocus'){
this.eleFunc.dispValue(this.ele,false);}
return this;},
setList:function(list,value){
this.list=copyArray(list);
if(value===undefined)
value=this.value;
this.eleFunc.setList(this.ele,list);
this.setValue(value);},
getList:function(list){
return this.list;},
setArrowState:function(){
if(!this.loop){
if(this.value===0)
this.eleFunc.setArrowState(this.ele,false,true);
else if(this.value+1===this.list.length)
this.eleFunc.setArrowState(this.ele,true,false);
else
this.eleFunc.setArrowState(this.ele,true,true);}
return this;},
setValue:function(value){
this.value=value;
this.eleFunc.setValue(this.ele,value);
this.setArrowState();
return this;},
changeValue:function(dir){
var ret=false;
if(this.loop){
this.setValue((this.value===0)?1:0);
ret=true;}else {
if(dir==='next'){
if(this.value===0){
this.setValue(1);
ret=true;}
}else {
if(this.value===1){
this.setValue(0);
ret=true;}
}
}
return ret;},
keyHook:function(ev){
var ret=false;
var dir;
if(this.disable)
return ret;
if(ret)
return true;
if(ev.type==='keydown'){
var enterKey=keyDef.getEnterKey();
switch(ev.keyCode){
case keyDef.LEFT:
dir='prev';
case keyDef.RIGHT:
dir=dir||'next';
ret=this.changeValue(dir);
if(ret)
this.dispatchValueChange();
break;
case enterKey:
case keyDef.ENTER:
this.dispatchAccess();
ret=true;
break;}
}
return ret;}
});
var twoButtonChoiceElement={
make:(function(){
var tmpl=null;
var func=function(prop){
var ele,btn1,btn2;
if(tmpl===null){
tmpl=makeListButtonBaseElement();
tmpl.classList.add('fdp-two-button-choice');
tmpl.classList.add('fdp-color-btn-transparent');
if(getDirection()==='rtl')
tmpl.classList.add('fdp-row-reverse');
btn1=tmplDiv.cloneNode(false);
btn2=tmplDiv.cloneNode(false);
btn1.className='fdp-btn fdp-color-btn fdp-color-text-onbase fdp-color-btn-border';
btn1.style.width='48%';
btn2.className='fdp-btn fdp-color-btn fdp-color-text-onbase fdp-color-btn-border';
btn2.style.width='48%';
tmpl.appendChild(btn1);
tmpl.appendChild(btn2);}
ele=tmpl.cloneNode(true);
return ele;};
return func;}()),
setTitle:function(){
},
setButtonState:function(ele,btnNo,state){
var btn;
if(btnNo===0)
btn=ele.firstChild;
else
btn=ele.lastChild;
if(state)
btn.classList.remove('fdp-disable');
else
btn.classList.add('fdp-disable');},
setList:function(ele,list){
setListBtnEleContent(ele.firstChild,list[0]);
setListBtnEleContent(ele.lastChild,list[1]);},
getFocusEle:function(ele,value){
var btn;
if(value===0)
btn=ele.firstChild;
else
btn=ele.lastChild;
return btn;}
};
UTIL.extend2(listButton,twoButtonChoiceElement);
var TwoButtonChoiceObj=UTIL.Class.create(
BaseListBtnObj,{
type:'2buttonChoice',
enableFocus:true,
eleFunc:twoButtonChoiceElement,
__construct:function(arg,parentObj){
this.__init(arg,parentObj);
this.setList(arg.list,arg.value);
this.focusTitle=arg.focusTitle;
this.enableFocus=arg.enableFocus===false?false:true;
this.accessHook=arg.accessHook;
this.valueChangeHook=arg.valueChangeHook;
this.loop=arg.loop||false;
this.state=arg.state||[true,true];
this.setButtonsState(this.state);},
getFocusEle:function(){
return this.eleFunc.getFocusEle(this.ele,this.value);},
setList:function(list,value){
this.list=copyArray(list);
if(value===undefined)
value=this.value;
this.eleFunc.setList(this.ele,list);
this.setValue(value);},
getList:function(list){
return this.list;},
setButtonsState:function(state){
this.setButtonState(0,state[0]);
this.setButtonState(1,state[1]);
return this;},
setButtonState:function(btnNo,state){
this.state[btnNo]=state;
this.eleFunc.setButtonState(this.ele,btnNo,state);
return this;},
setValue:function(value){
this.value=value;
if(this.parentObj&&this.isFocus){
this.parentObj.dispatchEvent('changefocusele',this);}
return this;},
changeValue:function(dir){
var ret=false;
if(this.loop){
this.setValue((this.value===0)?1:0);
ret=true;}else {
if(dir==='next'){
if(this.value===0){
this.setValue(1);
ret=true;}
}else {
if(this.value===1){
this.setValue(0);
ret=true;}
}
}
return ret;},
keyHook:function(ev){
var ret=false;
var dir;
if(this.disable)
return ret;
if(ret)
return true;
if(ev.type==='keydown'){
var enterKey=keyDef.getEnterKey();
switch(ev.keyCode){
case keyDef.LEFT:
dir='prev';
case keyDef.RIGHT:
dir=dir||'next';
ret=this.changeValue(dir);
if(ret)
this.dispatchValueChange();
break;
case enterKey:
case keyDef.ENTER:
if(this.state[this.value])
this.dispatchAccess();
ret=true;
break;}
}
return ret;}
});
var choice4Element={
make:(function(){
var tmpl=null;
var func=function(prop){
var valueWrap,value,arrowL,arrowR;
if(tmpl===null){
tmpl=makeListButtonElement();
valueWrap=this.getValueEle(tmpl);
valueWrap.classList.add('fdp-flex');
valueWrap.classList.add('fdp-two-choice-wrap');
if(getDirection()==='rtl')
valueWrap.classList.add('fdp-row-reverse');
value=tmplDiv.cloneNode(false);
value.className='value';
arrowL=tmplArrowL.cloneNode(true);
arrowR=tmplArrowR.cloneNode(true);
arrowL.style.visibility='hidden';
arrowR.style.visibility='hidden';
valueWrap.appendChild(arrowL);
valueWrap.appendChild(value);
valueWrap.appendChild(arrowR);}
var ele=tmpl.cloneNode(true);
return ele;};
return func;}()),
setArrowState:function(){
twoChoiceElement.setArrowState.apply(this,arguments);},
dispArrow:function(){
twoChoiceElement.dispArrow.apply(this,arguments);},
setValue:function(ele,value){
var valueEle=ele.getElementsByClassName('value')[0];
setListBtnEleContent(valueEle,value);}
};
UTIL.extend2(listButton,choice4Element);
var Choice4Obj=UTIL.Class.create(
BaseListBtnObj,{
type:'choice4',
enableFocus:true,
eleFunc:choice4Element,
__construct:function(arg,parentObj){
this.__choiceInit(arg,parentObj);
this.accessHook=arg.accessHook;
this.loop=arg.loop||false;},
focus:function(){
this.__onFocus();
this.eleFunc.dispArrow(this.ele,true);
return this;},
unfocus:function(){
this.__onBlure();
this.eleFunc.dispArrow(this.ele,false);
return this;},
setValue:function(value){
choiceCommonFuncs.setValue.call(this,value);
TwoChoiceObj.prototype.setArrowState.call(this);
return this;},
changeValue:function(dir){
var ret=false;
if(dir==='next'){
if(this.value+1<this.list.length){
this.setValue(this.value+1);
ret=true;}else if(this.loop){
this.setValue(0);
ret=true;}
}else {
if(this.value>0){
this.setValue(this.value-1);
ret=true;}else if(this.loop){
this.setValue(this.list.length-1);
ret=true;}
}
return ret;},
keyHook:function(ev){
var ret=false;
var dir;
if(this.disable)
return ret;
if(ev.type==='keydown'){
var enterKey=keyDef.getEnterKey();
switch(ev.keyCode){
case keyDef.LEFT:
dir='prev';
case keyDef.RIGHT:
dir=dir||'next';
ret=this.changeValue(dir);
if(ret)
this.dispatchValueChange();
break;
case enterKey:
case keyDef.ENTER:
this.dispatchAccess();
ret=true;
break;}
}
return ret;}
});
UTIL.include2(choiceCommonFuncs,Choice4Obj);
var barBaseElement={
makeBarTmpl:(function(){
var tmpl=null;
var func=function(prop){
var ele;
if(tmpl===null){
var dacbase=tmplDiv.cloneNode(false);
var left=tmplDiv.cloneNode(false);
var line=tmplDiv.cloneNode(false);
var right=tmplDiv.cloneNode(false);
var bar=tmplDiv.cloneNode(false);
var value=tmplDiv.cloneNode(false);
dacbase.className='fdp-barbase fdp-flex';
left.className='bar-left fdp-color-widget-sub';
right.className='bar-right fdp-color-widget-sub';
line.className='bar-line fdp-color-widget-sub';
bar.className='bar fdp-color-point-onbase';
dacbase.appendChild(left);
dacbase.appendChild(line);
dacbase.appendChild(right);
dacbase.appendChild(bar);
tmpl=makeListButtonElement();
var valueWrap=listButton.getValueEle(tmpl);
valueWrap.classList.add('fdp-flex');
valueWrap.appendChild(dacbase);
valueWrap.appendChild(value);}
ele=tmpl.cloneNode(true);
return ele;};
return func;}()),
make:(function(){
var tmpl=null;
var func=function(prop){
var ele;
if(tmpl===null){
tmpl=this.makeBarTmpl();}
ele=tmpl.cloneNode(true);
return ele;};
return func;}()),
getValue:function(ele){
var valueWrap=this.getValueEle(ele);
return getListBtnEleContent(valueWrap.lastChild);},
setValue:function(ele,value){
var valueWrap=this.getValueEle(ele);
if((typeof value==='string')&&(value.indexOf('<span')!==-1))
setListBtnEleContent(valueWrap.lastChild,value,true);
else
setListBtnEleContent(valueWrap.lastChild,value);
return ele;},
makeSelector:(function(){
var tmpl=null;
var func=function(prop){
var ele;
if(tmpl===null){
var dacWrap,wrap,left,right,baseDac,focus;
var triClass;
tmpl=getSelectorTmpl('dacbar-selector');
dacWrap=tmplDiv.cloneNode(false);
dacWrap.className='fdp-color-base selector-bar-wrap fdp-pop-border';
if(getDirection()==='rtl')
dacWrap.classList.add('fdp-row-reverse');
focus=tmplDiv.cloneNode(false);
focus.className='fdp-focus hide';
triClass='dac-triangle-box fdp-color-icon-onbase fdp-color-widget-sub';
left=tmplDiv.cloneNode(false);
left.className=triClass;
left.appendChild(tmplDiv.cloneNode(false));
left.firstChild.className='fdp-color-icon-onbase-border fdp-triangle left';
right=tmplDiv.cloneNode(false);
right.className=triClass;
right.appendChild(tmplDiv.cloneNode(false));
right.firstChild.className='fdp-color-icon-onbase-border fdp-triangle right';
dacWrap.appendChild(left);
dacWrap.appendChild(right);
wrap=tmpl.getElementsByClassName('selector-wrap')[0];
wrap.appendChild(dacWrap);
wrap.appendChild(focus);}
ele=tmpl.cloneNode(true);
return ele;};
return func;}()),
setSelectorValue:function(selector,value){
this.setValue(this.getSelectorBar(selector),value);
return selector;},
setSelectorParam:function(selector,baseEle){
var width=baseEle.offsetWidth;
var dacWrap;
selector.getElementsByClassName('fdp-list-btn')[0].style.width='-webkit-calc('+width+'px - 12rem)';
width=listButton.getTitleEle(baseEle).offsetWidth;
if(FDP.fontSmall){
selector.getElementsByClassName('selector-dummy')[0].style.width='-webkit-calc('+width+'px - 3rem - 0.2rem)';}else {
selector.getElementsByClassName('selector-dummy')[0].style.width='-webkit-calc('+width+'px - 2rem - 0.2rem)';}
width=listButton.getValueEle(baseEle).offsetWidth;
selector.getElementsByClassName('selector-bar-wrap')[0].style.width='-webkit-calc('+width+'px + 12rem)';
return selector;},
setSelectorTitle:function(selector,title){
this.setTitle(selector.firstChild,title);
return selector;},
addBar:function(selector,dacbar){
var dacWrap=selector.getElementsByClassName('selector-bar-wrap')[0];
dacbar.classList.add('selector-dac-in');
dacbar.classList.add('font-font-normal');
dacbar.classList.add('fdp-color-text-onbase');
var right=dacWrap.lastChild;
dacWrap.appendChild(dacbar);
dacWrap.appendChild(right);
return selector;},
getSelectorBar:function(selector){
return selector.getElementsByClassName('selector-bar-wrap')[0];},
getSlectorDummy:function(selector){
return selector.getElementsByClassName('selector-dummy')[0];}
};
UTIL.extend2(listButton,barBaseElement);
var dacbarElement={
make:(function(){
var tmpl=null;
var fun=function(prop){
var ele;
if(tmpl===null){
tmpl=this.makeBarTmpl();
tmpl.getElementsByClassName('fdp-barbase')[0].classList.add('fdp-dacbar');}
ele=tmpl.cloneNode(true);
return ele;};
return fun;}()),
setDacWidth:function(ele,width){
this.getValueEle(ele).getElementsByClassName('bar')[0].style.width=width;
return ele;},
setSelectorBarWidth:function(selector,value){
this.setDacWidth(this.getSelectorBar(selector),value);
return selector;}
};
UTIL.extend2(barBaseElement,dacbarElement);
var wSideFuncs={
setMaxWidth:function(ele,width){
var valueWrap=this.getValueEle(ele);
var maxEle=valueWrap.getElementsByClassName('max')[0];
maxEle.style.width=width;},
setMinWidth:function(ele,width){
var valueWrap=this.getValueEle(ele);
valueWrap.firstChild.style.width=width;},
setMaxText:function(ele,text){
var valueWrap=this.getValueEle(ele);
var maxEle=valueWrap.getElementsByClassName('max')[0];
setListBtnEleContent(maxEle,text);
return ele;},
setMinText:function(ele,text){
var valueWrap=this.getValueEle(ele);
setListBtnEleContent(valueWrap.firstChild,text);
return ele;}
};
var dacbar4Element={
makeBar:(function(){
var tmpl=null;
var fun=function(pro){
var ele,dacbase,bar,barWrap,valueWrap,valueMin,valueMax,maxLine;
if(tmpl===null){
tmpl=dacbase=tmplDiv.cloneNode(false);
barWrap=tmplDiv.cloneNode(false);
bar=tmplDiv.cloneNode(false);
dacbase.className='fdp-barbase fdp-flex fdp-dacbar';
barWrap.className='bar-wrap fdp-color-widget-sub';
bar.className='bar fdp-color-point-onbase';
dacbase.appendChild(barWrap);
barWrap.appendChild(bar);}
ele=tmpl.cloneNode(true);
return ele;};
return fun;}()),
make:(function(){
var tmpl=null;
var fun=function(prop){
var ele,dacbase,valueWrap,valueMin,valueMax,maxLine;
if(tmpl===null){
dacbase=this.makeBar(prop);
dacbase.classList.add('fdp-dacbar4');
maxLine=tmplDiv.cloneNode(false);
maxLine.className='max-line fdp-color-signal-aqua';
dacbase.appendChild(maxLine);
valueMin=tmplDiv.cloneNode(false);
valueMax=tmplDiv.cloneNode(false);
valueMin.className='fdp-barside-value min';
valueMax.className='fdp-barside-value max';
tmpl=makeListButtonElement();
valueWrap=listButton.getValueEle(tmpl);
valueWrap.classList.add('fdp-flex');
valueWrap.appendChild(valueMin);
valueWrap.appendChild(dacbase);
valueWrap.appendChild(valueMax);
if(getDirection()==='rtl'){
valueWrap.style.direction='ltr';
valueWrap.style.webkitJustifyContent='flex-end';}
}
ele=tmpl.cloneNode(true);
return ele;};
return fun;}()),
dispValue:function(ele){
var valueWrap=this.getValueEle(ele);
var maxEle=valueWrap.getElementsByClassName('max')[0];
maxEle.className='dacbar4-value';},
setValue:function(ele,value){
var valueWrap=this.getValueEle(ele);
var valueEle=valueWrap.getElementsByClassName('dacbar4-value')[0];
setListBtnEleContent(valueEle,value);},
setMaxLinePos:function(ele,width){
var bar=ele.getElementsByClassName('bar')[0];
var maxLine=ele.getElementsByClassName('max-line')[0];
maxLine.style.display='block';
maxLine.style.left=width;},
setBarWrapColor:function(ele,className){
var barWrap=ele.getElementsByClassName('bar-wrap')[0];
barWrap.classList.remove(barWrap.classList[1]);
barWrap.classList.add(className);},
setBarColor:function(ele,color,className){
var bar=ele.getElementsByClassName('bar')[0];
if(color){
bar.style.backgroundColor=color;}else {
bar.classList.remove(bar.classList[1]);
bar.classList.add(className);}
},
addPercent:function(ele){
var barWrap=this.getValueEle(ele);
var percent=barWrap.getElementsByClassName('dac4-percent')[0];
if(!percent){
percent=tmplDiv.cloneNode(false);
percent.textContent='%';
percent.className='dac4-percent';
barWrap.appendChild(percent);}
},
removePercent:function(ele){
var barWrap=this.getValueEle(ele);
var percent=barWrap.getElementsByClassName('dac4-percent')[0];
if(percent){
barWrap.removeChild(percent);}
}
};
UTIL.extend2(dacbarElement,dacbar4Element);
UTIL.extend(wSideFuncs,dacbar4Element);
var sliderbarElement={
make:(function(){
var tmpl=null;
var fun=function(prop){
var ele,base,center;
if(tmpl===null){
tmpl=this.makeBarTmpl();
base=tmpl.getElementsByClassName('fdp-barbase')[0];
base.classList.add('fdp-sliderbar');
center=tmplDiv.cloneNode(false);
center.className='bar-center fdp-color-widget-sub';
base.insertBefore(center,base.getElementsByClassName('bar-right')[0]);}
ele=tmpl.cloneNode(true);
return ele;};
return fun;}()),
setBarPos:function(ele,pos){
var bar=this.getValueEle(ele).getElementsByClassName('bar')[0];
bar.style.left='-webkit-calc('+pos+' - .8rem)';return ele;},
setSelectorBarPos:function(selector,pos){
this.setBarPos(this.getSelectorBar(selector),pos);
return selector;}
};
UTIL.extend2(barBaseElement,sliderbarElement);
var barBaseFuncs={
setValue:function(value){
if((value<this.min)||(value>this.max))
return null;
this.value=value;
this.eleFunc.setValue(this.ele,this.makeValueText(value));
this.updateBar();
return this;},
makeValueText:function(value){
return value;},
updateSelectorValue:function(value){
if(this.selector){
this.eleFunc.setSelectorValue(this.selector.ele,this.makeValueText(value));
this.updateSelectorBar();}
return this;},
upValue:function(){
if(this.value<this.max){
this.value++;
this.setValue(this.value);
this.updateSelectorValue(this.value);
this.dispatchValueChange();}
},
downValue:function(){
if(this.value>this.min){
this.value--;
this.setValue(this.value);
this.updateSelectorValue(this.value);
this.dispatchValueChange();}
},
selectorKeyHook:function(ev){
var ret=false;
if(ev.type==='keydown'){
if(!this.selector.isFocus)
return true;
switch(ev.keyCode){
case keyDef.RETURN:
case keyDef.ENTER:
case keyDef.DOWN:
case keyDef.UP:
case keyDef.CH_UP:
case keyDef.CH_DOWN:
this.hideSelector();
ret=true;
break;
case keyDef.RIGHT:
this.upValue();
ret=true;
break;
case keyDef.LEFT:
this.downValue();
ret=true;
break;}
}
return ret;},
keyHook:function(ev){
var ret=false;
if(this.disable)
return ret;
if(this.isSelectMode){
ret=this.selectorKeyHook(ev);}
if(ret)
return true;
if(ev.type==='keydown'){
if(keyDef.isAccess(ev.keyCode)){
if(ev.keyCode===keyDef.LEFT){
this.downValue();}else if(ev.keyCode===keyDef.RIGHT){
this.upValue();}
this.showSelector(this.parentObj.getValueSelectorEle());
ret=true;}
}
return ret;},
showSelectorBar:function(){
var barEle=this.selector.bar;
var selector=this.selector;
barEle.classList.remove('invisible');
if(FDP.anim)
barEle.classList.add('move');
barEle.style.left=0;
var animCallback=function(ev,callback){
if(FDP.anim){
ev.target.classList.remove('move');
transitionCallback.remove(ev.target,callback);}
showFocus(barEle,null,selector.ele.getElementsByClassName('fdp-focus')[0],null,false);
selector.isFocus=true;};
if(FDP.anim)
transitionCallback.add(barEle,animCallback);
else
animCallback();},
showSelector:function(parent){
var ele,style,rect,dacbar,orgBar,barEle,cloneBar,dummy;
var self=this;
this.isSelectMode=true;
style=parent.style;
rect=this.ele.getBoundingClientRect();
style.top=rect.top+'px';
style.left=rect.left+'px';
ele=this.eleFunc.makeSelector();
this.eleFunc.setSelectorTitle(ele,this.title);
this.eleFunc.setSelectorParam(ele,this.ele);
orgBar=this.eleFunc.getValueEle(this.ele);
cloneBar=orgBar.cloneNode(true);
cloneBar.style.width=orgBar.offsetWidth+'px';
this.eleFunc.addBar(ele,cloneBar);
parent.classList.add('show');
parent.appendChild(ele);
barEle=this.eleFunc.getSelectorBar(ele);
if(FDP.isLtr())
barEle.style.left='2rem';else
barEle.style.left='-2rem';
this.selector={};
this.selector.ele=ele;
this.selector.bar=barEle;
barEle.classList.add('invisible');
this.parentObj.dispatchEvent('showselector',this,this.onePopup);
(function(){
var barH=barEle.offsetHeight;
var targetTop;
barEle.style.top=Math.floor(-rect.height-((barH-rect.height)/2))+'px';
if(self.onePopup){
targetTop=window.innerHeight-rect.height*2;
if(parent.clientTop===targetTop){
self.showChoiceList();}else {
var animCallback=function(ev,callback){
if(FDP.anim){
if(ev.propertyName!=='-webkit-transform'){
return;}
ev.target.classList.remove('move');
transitionCallback.remove(ev.target,callback);}
parent.style.webkitTransform='';
parent.style.top=targetTop+'px';
self.showSelectorBar();};
parent.dataset.otop=rect.top;
parent.style.webkitTransform='translateY('+(targetTop-rect.top)+'px)';
parent.dataset.transY=targetTop-rect.top;
if(FDP.anim){
transitionCallback.add(parent,animCallback);
parent.classList.add('move');}else {
animCallback();}
}
}else {
self.showSelectorBar();}
}());},
hideSelector:function(){
var self=this;
var parent=this.selector.ele.parentNode;
var destroy=function(){
self.isSelectMode=false;
self.selector=null;
self.parentObj.dispatchEvent('hideselector',self,self.onePopup);
if(self.hideSelectorHook){
self.hideSelectorHook({type:'hideselector',
obj:self});}
};
if(this.onePopup){
this.parentObj.dispatchEvent('prehideselector',this,this.onePopup);
hideFocus(this.selector.ele.getElementsByClassName('fdp-focus')[0]);
this.selector.bar.classList.add('hide');
if(FDP.anim){
parent.classList.add('move');
}
parent.style.webkitTransform='translateY('+(-parent.dataset.transY)+'px)';
var animCallback=function(ev,callback){
if(FDP.anim){
transitionCallback.remove(ev.target,callback);
parent.classList.remove('move');
}
parent.style.webkitTransform='';
destroy();};
if(FDP.anim){
transitionCallback.add(parent,animCallback);}else {
animCallback();}
}else {
hideFocus(this.selector.ele.getElementsByClassName('fdp-focus')[0]);
destroy();}
}
};
var dacBarCommonFuncs={
init:function(arg,parentObj){
this.__init(arg,parentObj);
this.max=arg.max||100;
this.min=arg.min||0;
this.valueChangeHook=arg.valueChangeHook;},
getDacWidth:function(){
return (this.value-this.min)/(this.max-this.min)*100+'%';},
updateBar:function(){
this.eleFunc.setDacWidth(this.ele,this.getDacWidth());}
};
var barWSideCommonFuncs={
initWSide:function(arg){
this.maxDisp=(arg.maxDisp===undefined)?true:arg.maxDisp;
this.minDisp=(arg.minDisp===undefined)?true:arg.minDisp;
this.maxText=arg.maxText||this.max;
this.minText=arg.minText||this.min;
this.withPercent=arg.withPercent;
if(this.maxDisp){
if(arg.maxWidth!==undefined)
this.eleFunc.setMaxWidth(this.ele,arg.maxWidth);
this.setMaxText(this.maxText);}
if(this.minDisp){
if(arg.minWidth!==undefined)
this.eleFunc.setMinWidth(this.ele,arg.minWidth);
this.setMinText(this.minText);}
if(this.withPercent){
this.eleFunc.addPercent(this.ele);}
},
setMaxText:function(text){
this.maxText=text;
this.eleFunc.setMaxText(this.ele,this.maxText);},
setMinText:function(text){
this.minText=text;
this.eleFunc.setMinText(this.ele,this.minText);}
};
var DacbarObj=UTIL.Class.create(
BaseListBtnObj,{
type:'dacbar',
enableFocus:true,
eleFunc:dacbarElement,
__construct:function(arg,parentObj){
this.init(arg,parentObj);
this.setValue(arg.value);
this.onePopup=arg.onePopup||false;
this.enableFocus=arg.enableFocus===false?false:true;
this.hideSelectorHook=arg.hideSelectorHook;},
updateSelectorBar:function(){
this.eleFunc.setSelectorBarWidth(this.selector.ele,this.getDacWidth());}
}
);
UTIL.include(barBaseFuncs,DacbarObj);
UTIL.include(dacBarCommonFuncs,DacbarObj);
var Dacbar4Obj=UTIL.Class.create(
BaseListBtnObj,{
type:'dacbar4',
enableFocus:true,
eleFunc:dacbar4Element,
__construct:function(arg,parentObj){
this.init(arg,parentObj);
this.initWSide(arg);
if(!this.maxDisp&&!this.minDisp){
this.eleFunc.dispValue(this.ele);
this.dispValue=true;}
if(arg.barColor)
this.setBarColor(arg.barColor);
if(arg.maxLine){
this.maxLine=arg.maxLine;}
this.maxValue=this.min;
this.setValue(arg.value);
this.enableFocus=(arg.enableFocus===true)?true:false;
if(arg.withUnderline)
this.ele.classList.add('fdp-color-btn-transparent-back');
else
this.ele.classList.add('fdp-color-btn-transparent');
this.eleFunc.setBarWrapColor(this.ele,'fdp-color-gray');},
setBarColor:function(color){
this.barColor=color;
if(color.indexOf('fdp-color')===0)
this.eleFunc.setBarColor(this.ele,undefined,color);
else
this.eleFunc.setBarColor(this.ele,color);},
resetMaxValue:function(){
if(this.maxLine){
this.maxValue=this.min;
this.eleFunc.setMaxLinePos(this.ele,0);}
},
updateBar:function(value){
var width=this.getDacWidth();
this.eleFunc.setDacWidth(this.ele,width);
if(this.maxLine){
if(this.maxValue<value){
this.eleFunc.setMaxLinePos(this.ele,width);
this.maxValue=value;}
}
},
setValue:function(value){
if((value<this.min)||(value>this.max))
return null;
this.value=value;
if(this.dispValue){
this.eleFunc.setValue(this.ele,value);}
this.updateBar(this.value);
return this;}
}
);
UTIL.include2(dacBarCommonFuncs,Dacbar4Obj);
UTIL.include2(barWSideCommonFuncs,Dacbar4Obj);
var SliderbarObj=UTIL.Class.create(
BaseListBtnObj,{
type:'sliderbar',
enableFocus:true,
eleFunc:sliderbarElement,
__construct:function(arg,parentObj){
this.__init(arg,parentObj);
this.onePopup=arg.onePopup||false;
this.max=arg.max||100;
this.min=arg.min||0;
this.withLR=arg.withLR;
this.setValue(arg.value);
this.enableFocus=arg.enableFocus===false?false:true;
this.valueChangeHook=arg.valueChangeHook;
this.hideSelectorHook=arg.hideSelectorHook;},
makeValueText:function(value){
var text;
if(value>0){
if(this.withLR){
text=LANG('LT_R');
if(text==='右')
return '<span style=\'font-size:90%;\'>'+text+'</span>'+value;
else
return text+value;}else {
return '+'+value;}
}else if(value<0){
if(this.withLR){
text=LANG('LT_L');
if(text==='左')
return '<span style=\'font-size:90%;\'>'+text+'</span>'+Math.abs(value);
else
return text+Math.abs(value);}else {
return value;}
}
return value;},
getBarPos:function(){
return (this.value-this.min)/(this.max-this.min)*100+'%';},
updateBar:function(){
this.eleFunc.setBarPos(this.ele,this.getBarPos());},
updateSelectorBar:function(){
this.eleFunc.setSelectorBarPos(this.selector.ele,this.getBarPos());}
}
);
UTIL.include2(barBaseFuncs,SliderbarObj);
var progressbarElement={
makeBar:(function(){
var tmpl=null;
var func=function(prop){
var ele,i,bar;
var barEles={
line:null,
left:null,
lineDummy:null,
right:null,
barWrap:null
};
if(tmpl===null){
tmpl=makeListButtonElement();
tmpl.className='fdp-progress-barbase';
for(i in barEles){
barEles[i]=tmplDiv.cloneNode(false);
tmpl.appendChild(barEles[i]);}
barEles.left.className='bar-left fdp-color-widget-sub';
barEles.lineDummy.className='bar-line-dummy';
barEles.right.className='bar-right fdp-color-widget-sub';
barEles.line.className='bar-line fdp-color-widget-sub';
barEles.barWrap.className='bar-wrap';
var bar=tmplDiv.cloneNode(false);
bar.className='bar fdp-color-point-onbase';
barEles.barWrap.appendChild(bar);}
ele=tmpl.cloneNode(true);
return ele;};
return func;}()),
make:(function(){
var tmpl=null;
var func=function(prop){
var ele,bar,valueMin,valueMax,valueWrap;
if(tmpl===null){
tmpl=makeListButtonElement();
bar=this.makeBar();
valueMin=tmplDiv.cloneNode(false);
valueMax=tmplDiv.cloneNode(false);
valueMin.className='fdp-barside-value min';
valueMax.className='fdp-barside-value max';
valueWrap=listButton.getValueEle(tmpl);
valueWrap.classList.add('fdp-flex');
if(getDirection()==='rtl')
valueWrap.style.direction='ltr';
valueWrap.appendChild(valueMin);
valueWrap.appendChild(bar);
valueWrap.appendChild(valueMax);}
ele=tmpl.cloneNode(true);
return ele;};
return func;}()),
getValue:function(ele){
},
setValue:function(ele,value){
return ele;},
setPoint:function(pointEle,isSet){
var addClass,removeClass;
var oColor='fdp-color-widget-sub';
var pColor='fdp-color-point-onbase';
if(!isSet){
removeClass=pColor;
addClass=oColor;}else {
removeClass=oColor;
addClass=pColor;}
pointEle.classList.remove(removeClass);
pointEle.classList.add(addClass);
return pointEle;},
setEnd:function(ele,isSet){
var right=this.getValueEle(ele).getElementsByClassName('bar-right')[0];
this.setPoint(right,isSet);
return ele;},
setStart:function(ele,isSet){
var left=this.getValueEle(ele).getElementsByClassName('bar-left')[0];
this.setPoint(left,isSet);
return ele;},
getDacEle:function(ele){
return this.getValueEle(ele).getElementsByClassName('bar')[0];},
setDacWidth:function(ele,width){
this.getValueEle(ele).getElementsByClassName('bar')[0].style.width=width;
return ele;},
setBarColor:function(ele,color,className){
var bar=this.getValueEle(ele).getElementsByClassName('bar')[0];
if(color){
bar.style.backgroundColor=color;}else {
bar.classList.add(className);}
},
setLeftColor:function(ele,color,className){
var left=this.getValueEle(ele).getElementsByClassName('bar-left')[0];
if(color){
left.style.backgroundColor=color;}else {
left.classList.add(className);}
},
setRightColor:function(ele,color,className){
var right=this.getValueEle(ele).getElementsByClassName('bar-right')[0];
if(color){
right.style.backgroundColor=color;}else {
right.classList.add(className);}
}
};
UTIL.extend2(listButton,progressbarElement);
UTIL.extend(wSideFuncs,progressbarElement);
var ProgressbarObj=UTIL.Class.create(
BaseListBtnObj,{
type:'progressbar',
enableFocus:false,
eleFunc:progressbarElement,
__construct:function(arg,parentObj){
this.init(arg,parentObj);
this.initWSide(arg);
this.onePopup=false;
this.isStart=false;
this.isEnd=false;
this.setValue(arg.value||0,false);
this.enableFocus=(arg.enableFocus===false)?false:(arg.enableFocus||false);
if(arg.withUnderline)
this.ele.classList.add('fdp-color-btn-transparent-back');
else
this.ele.classList.add('fdp-color-btn-transparent');},
unSetStart:function(){
this.isStart=false;
this.eleFunc.setStart(this.ele,false);},
setStart:function(){
this.isStart=true;
this.eleFunc.setStart(this.ele,true);},
unSetEnd:function(){
this.isEnd=false;
this.eleFunc.setEnd(this.ele,false);},
setEnd:function(){
this.isEnd=true;
this.eleFunc.setEnd(this.ele,true);},
setValue:function(value,anim){
var self=this;
if((value<this.min)||(value>this.max))
return null;
this.value=value;
if((this.isStart===false)&&(value>this.min)){
this.setStart();}
if((this.isEnd===false)&&(value===this.max)){
if(anim===false){
self.setEnd();}else {
transitionCallback.add(this.eleFunc.getDacEle(this.ele),function(ev,callback){
transitionCallback.remove(ev.target,callback);
if(self.value===self.max)
self.setEnd();});}
}else if(this.isEnd&&(value!==this.max)){
this.unSetEnd();}
this.updateBar();
return this;},
setBarColor:function(color){
if(this.getDacWidth()>'0%'){
if(color.indexOf('fdp-color')===0){
this.eleFunc.setLeftColor(this.ele,undefined,color);
this.eleFunc.setBarColor(this.ele,undefined,color);}else {
this.eleFunc.setLeftColor(this.ele,color);
this.eleFunc.setBarColor(this.ele,color);}
}
if(this.getDacWidth()=='100%'){
if(color.indexOf('fdp-color')===0){
this.eleFunc.setRightColor(this.ele,undefined,color);}else {
this.eleFunc.setRightColor(this.ele,color);}
}
}
}
);
UTIL.include(dacBarCommonFuncs,ProgressbarObj);
UTIL.include(barWSideCommonFuncs,ProgressbarObj);
var hyperbarElement={
barEle:dacbar4Element,
makeTmpl:function(prop){
var tmpl;
var bar1,bar2;
var margin;
var valueWrap,value1,value2;
var arrowL,arrowR;
tmpl=makeListButtonElement();
bar1=this.barEle.makeBar(prop);
bar2=this.barEle.makeBar(prop);
if(prop.addClass){
bar1.classList.add('fdp-hyper-bar');
bar2.classList.add('fdp-hyper-bar');}
var makeValue=function(){
return (function(){
var min,max;
min=tmplDiv.cloneNode(false);
max=tmplDiv.cloneNode(false);
min.className='fdp-barside-value min';
max.className='fdp-barside-value max';
return {max:max,min:min};}());};
value1=makeValue();
value2=makeValue();
margin=tmplDiv.cloneNode(false);
margin.className='fdp-hyper-bar-margin fdp-color-widget-sub';
if(prop.withArrow){
arrowL=tmplArrowL.cloneNode(true);
arrowR=tmplArrowR.cloneNode(true);
arrowL.style.visibility='hidden';
arrowR.style.visibility='hidden';}
valueWrap=listButton.getValueEle(tmpl);
valueWrap.classList.add('fdp-flex');
if(prop.withArrow)
valueWrap.appendChild(arrowL);
valueWrap.appendChild(value1.min);
valueWrap.appendChild(bar1);
valueWrap.appendChild(value1.max);
valueWrap.appendChild(margin);
valueWrap.appendChild(value2.min);
valueWrap.appendChild(bar2);
valueWrap.appendChild(value2.max);
if(prop.withArrow)
valueWrap.appendChild(arrowR);
if(getDirection()==='rtl')
valueWrap.style.direction='ltr';
return tmpl;},
make:(function(){
var tmpl=null;
var func=function(prop){
var ele;
if(tmpl===null){
tmpl=this.makeTmpl({withArrow:true,addClass:true});}
ele=tmpl.cloneNode(true);
return ele;};
return func;}()),
dispArrow:function(ele,disp){
var i;
var arrows=ele.getElementsByClassName('fdp-arrow');
for(i=0;i<arrows.length;i++){
if(disp)
arrows[i].style.visibility='';
else
arrows[i].style.visibility='hidden';}
},
getValueTextEle:function(ele,barNo,max){
var pos;
var valueWrap=this.getValueEle(ele);
if(max)
pos=1;
else
pos=0;
return valueWrap.getElementsByClassName('fdp-barside-value')[barNo*2+pos];},
setMaxWidth:function(ele,width,barNo){
var valueEle=this.getValueTextEle(ele,barNo,1);
valueEle.style.width=width;},
setMinWidth:function(ele,width,barNo){
var valueEle=this.getValueTextEle(ele,barNo,0);
valueEle.style.width=width;},
setMaxText:function(ele,text,barNo){
var valueEle=this.getValueTextEle(ele,barNo,1);
setListBtnEleContent(valueEle,text);
return ele;},
setMinText:function(ele,text,barNo){
var valueEle=this.getValueTextEle(ele,barNo,0);
setListBtnEleContent(valueEle,text);
return ele;},
getDacEle:function(ele,barNo){
return this.getValueEle(ele).getElementsByClassName('bar')[barNo];},
setDacWidth:function(ele,width,barNo){
this.getValueEle(ele).getElementsByClassName('bar')[barNo].style.width=width;
return ele;}
};
UTIL.extend2(listButton,hyperbarElement);
var hyperbarElementProgress={
barEle:progressbarElement,
make:(function(){
var tmpl=null;
var func=function(prop){
var ele;
if(tmpl===null){
tmpl=this.makeTmpl({withArrow:false});}
ele=tmpl.cloneNode(true);
return ele;};
return func;}()),
setPoint:function(pointEle,isSet){
var addClass,removeClass;
var oColor='fdp-color-widget-sub';
var pColor='fdp-color-point-onbase';
if(!isSet){
removeClass=pColor;
addClass=oColor;}else {
removeClass=oColor;
addClass=pColor;}
pointEle.classList.remove(removeClass);
pointEle.classList.add(addClass);
return pointEle;},
setEnd:function(ele,isSet,barNo){
var right=this.getValueEle(ele).getElementsByClassName('bar-right')[barNo];
this.setPoint(right,isSet);
return ele;},
setStart:function(ele,isSet,barNo){
var right=this.getValueEle(ele).getElementsByClassName('bar-left')[barNo];
this.setPoint(right,isSet);
return ele;}
};
UTIL.extend2(hyperbarElement,hyperbarElementProgress);
var HyperbarObj=UTIL.Class.create(
BaseListBtnObj,{
type:'hyperbar',
enableFocus:false,
eleFunc:hyperbarElement,
__construct:function(arg,parentObj){
var self=this;
this.isProgress=(arg.isProgress===undefined)?false:arg.isProgress;
if(this.isProgress){
this.eleFunc=hyperbarElementProgress;}
this.__init(arg,parentObj);
this.valueChangeHook=arg.valueChangeHook;
(function(){
var setBarProp=function(arg){
var prop={
min:arg.min||0,
max:arg.max||100,
value:arg.value||0,
minDisp:(arg.minDisp===undefined)?true:arg.minDisp,
maxDisp:(arg.maxDisp===undefined)?true:arg.maxDisp,
minWidth:arg.minWidth,
maxWidth:arg.maxWidth,
isStart:false,
isEnd:false
};
prop.minText=arg.minText||prop.min;
prop.maxText=arg.maxText||prop.max;
return prop;};
var setBarInit=function(bar,barNo){
if(bar.maxDisp){
if(bar.maxWidth!==undefined)
self.eleFunc.setMaxWidth(self.ele,bar.maxWidth,barNo);
self.setMaxText(bar.maxText,barNo);}
if(bar.minDisp){
if(bar.minWidth!==undefined)
self.eleFunc.setMinWidth(self.ele,bar.minWidth,barNo);
self.setMinText(bar.minText,barNo);}
};
self.bar1=setBarProp({min:arg.min,max:arg.max,value:arg.value,
minDisp:arg.minDisp,maxDisp:arg.maxDisp,
minText:arg.minText,maxText:arg.maxText,
minWidth:arg.minWidth,maxWidth:arg.maxWidth
});
self.bar2=setBarProp({min:arg.min2,max:arg.max2,value:arg.value2,
minDisp:arg.minDisp2,maxDisp:arg.maxDisp2,
minText:arg.minText2,maxText:arg.maxText2,
minWidth:arg.minWidth2,maxWidth:arg.maxWidth2
});
setBarInit(self.bar1,0);
setBarInit(self.bar2,1);}());
this.setValue(this.bar1.value,0,false);
this.setValue(this.bar2.value,1,false);
this.enableFocus=(arg.enableFocus===undefined)?true:arg.enableFocus;
if(this.isProgress){
this.enableFocus=false;
if(arg.withUnderline)
this.ele.classList.add('fdp-color-btn-transparent-back');
else
this.ele.classList.add('fdp-color-btn-transparent');}
},
focus:function(){
this.__onFocus();
this.eleFunc.dispArrow(this.ele,true);
return this.ele;},
unfocus:function(){
this.__onBlure();
this.eleFunc.dispArrow(this.ele,false);
return this.ele;},
getBarProp:function(barNo){
if(barNo===0){
return this.bar1;}else {
return this.bar2;}
},
unSetStart:function(barNo){
var bar=this.getBarProp(barNo);
bar.isStart=false;
this.eleFunc.setStart(this.ele,false,barNo);},
setStart:function(barNo){
var bar=this.getBarProp(barNo);
bar.isStart=true;
this.eleFunc.setStart(this.ele,true,barNo);},
unSetEnd:function(barNo){
var bar=this.getBarProp(barNo);
bar.isEnd=false;
this.eleFunc.setEnd(this.ele,false,barNo);},
setEnd:function(barNo){
var bar=this.getBarProp(barNo);
bar.isEnd=true;
this.eleFunc.setEnd(this.ele,true,barNo);},
setMaxText:function(text,barNo){
this.maxText=text;
this.eleFunc.setMaxText(this.ele,this.maxText,barNo);},
setMinText:function(text,barNo){
this.minText=text;
this.eleFunc.setMinText(this.ele,this.minText,barNo);},
getDacWidth:function(bar){
return (bar.value-bar.min)/(bar.max-bar.min)*100+'%';},
updateBar:function(barNo){
var bar=this.getBarProp(barNo);
this.eleFunc.setDacWidth(this.ele,this.getDacWidth(bar),barNo);},
setValue:function(value,barNo,anim){
var self=this;
var bar=this.getBarProp(barNo);
if((value<bar.min)||(value>bar.max))
return null;
bar.value=value;
if(this.isProgress){
if((bar.isStart===false)&&(value>bar.min)){
this.setStart(barNo);}
if((bar.isEnd===false)&&(value===bar.max)){
if(anim===false){
this.setEnd(barNo);}else {
transitionCallback.add(this.eleFunc.getDacEle(this.ele,barNo),function(ev,callback){
transitionCallback.remove(ev.target,callback);
if(bar.value===bar.max)
self.setEnd(barNo);});}
}else if(bar.isEnd&&(value!==bar.max)){
this.unSetEnd(barNo);}
}
this.updateBar(barNo);
return this;}
});

var spaceElement={
make:(function(){
var tmpl=null;
var func=function(prop){
if(tmpl===null){
tmpl=tmplDiv.cloneNode(false);
tmpl.className='fdp-list-btn fdp-list-btn-border';}
var ele=tmpl.cloneNode(true);
return ele;};
return func;}())
};
var SpaceObj=UTIL.Class.create(
BaseListBtnObj,{
type:'space',
eleFunc:spaceElement,
enableFocus:false,
__construct:function(arg,parentObj){
this.ele=this.makeElement(arg);
this.parentObj=parentObj;
if(arg.withUnderline){
this.ele.classList.add('fdp-color-btn-transparent-back');
this.ele.classList.add('fdp-color-border-onbase');}else {
this.ele.classList.add('fdp-color-btn-transparent');}
if(arg.height){
this.ele.style.height=arg.height;}
}
}
);

var scrollBarElement={
make:(function(){
var tmpl=null;
var func=function(prop){
var up,down,bar,thumb;
if(tmpl===null){
tmpl=tmplDiv.cloneNode(false);
tmpl.className='fdp-scroll-bar';
up=tmplDiv.cloneNode(false);
down=tmplDiv.cloneNode(false);
up.className='fdp-triangle up fdp-color-icon-onbase-border';
down.className='fdp-triangle down fdp-color-icon-onbase-border';
bar=tmplDiv.cloneNode(false);
bar.className='bar fdp-color-icon-onbase-a-back';
thumb=tmplDiv.cloneNode(false);
thumb.className='thumb fdp-color-icon-onbase-back';
bar.appendChild(thumb);
tmpl.appendChild(up);
tmpl.appendChild(bar);
tmpl.appendChild(down);}
return tmpl.cloneNode(true);};
return func;}()),
getThumbEle:function(ele){
return ele.getElementsByClassName('thumb')[0];},
setThumbHeight:function(ele,height){
var thumb=ele.getElementsByClassName('thumb')[0];
thumb.style.height=height;},
setThumbTop:function(ele,top){
var thumb=ele.getElementsByClassName('thumb')[0];
thumb.style.top=top;},
setArrowState:function(ele,up,down){
var arrows=ele.getElementsByClassName('fdp-triangle');
var enaClass='fdp-color-icon-onbase-border';
var disClass='fdp-color-icon-onbase-a-border';
var swapClass=function(ele,from,to){
return classAdd(classRemove(ele,from),to);};
if(up)
swapClass(arrows[0],disClass,enaClass);
else
swapClass(arrows[0],enaClass,disClass);
if(down)
swapClass(arrows[1],disClass,enaClass);
else
swapClass(arrows[1],enaClass,disClass);}
};
var ScrollBarObj=UTIL.Class.create(
BaseObj,{
eleFunc:scrollBarElement,
__construct:function(arg){
this.ele=this.makeElement(arg);
this.areaHeight=arg.areaHeight;
this.pageHeight=arg.pageHeight;
this.pageTop=arg.pageTop;
this.loop=(arg.loop===undefined)?false:arg.loop;
this.changeThumbHeight();
this.changeTop(arg.pageTop);},
changeThumbHeight:function(){
var height=(this.pageHeight/this.areaHeight)*100;
if(height<1){
height=1;}
this.eleFunc.setThumbHeight(this.ele,(height+'%'));},
changeAreaHeight:function(height){
this.areaHeight=height;
this.changeThumbHeight();
this.changeTop(this.pageTop);},
__updateArrowState:function(){
var up=true,down=true;
if(!this.loop){
if(this.pageTop===0){
up=false;}else if(this.areaHeight<=this.pageHeight-this.pageTop){
down=false;}
this.eleFunc.setArrowState(this.ele,up,down);}
return this;},
changeTop:function(top,anim){
var thumb=this.eleFunc.getThumbEle(this.ele);
if(top>0)
top=0;
this.pageTop=top;
if(this.areaHeight<this.pageHeight-this.pageTop){
top=this.pageHeight-this.areaHeight;}
if(anim){
classAdd(thumb,'anim');}else {
classRemove(thumb,'anim');}
this.eleFunc.setThumbTop(this.ele,(((-1*top)/this.areaHeight)*100+'%'));
this.__updateArrowState();}
});
var makeListObj=function(item,parentObj){
var retObj=null;
switch(item.type){
case 'choice':
retObj=new ChoiceObj(item,parentObj);
break;
case '2choice':
retObj=new TwoChoiceObj(item,parentObj);
break;
case 'choice4':
retObj=new Choice4Obj(item,parentObj);
break;
case '2buttonChoice':
retObj=new TwoButtonChoiceObj(item,parentObj);
break;
case 'access':
retObj=new AccessObj(item,parentObj);
break;
case 'access2':
item.subType='access2';
retObj=new AccessObj(item,parentObj);
break;
case 'access7':
item.subType='access7';
retObj=new AccessObj(item,parentObj);
break;
case 'access6':
retObj=new Access6Obj(item,parentObj);
break;
case 'information':
retObj=new InformationObj(item,parentObj);
break;
case 'sysmenuTitle':
retObj=new SysmenuTitleObj(item,parentObj);
break;
case 'categoryTitle':
retObj=new CategoryTitleObj(item,parentObj);
break;
case 'dacbar':
retObj=new DacbarObj(item,parentObj);
break;
case 'dacbar4':
retObj=new Dacbar4Obj(item,parentObj);
break;
case 'sliderbar':
retObj=new SliderbarObj(item,parentObj);
break;
case 'progressbar':
retObj=new ProgressbarObj(item,parentObj);
break;
case 'hyperbar':
retObj=new HyperbarObj(item,parentObj);
break;
case 'input':
retObj=new InputObj(item,parentObj);
break;
case 'row':
retObj=new RowObj(item,parentObj);
break;
case 'button':
item.subType='button';
retObj=new AccessObj(item,parentObj);
break;
case 'space':
retObj=new SpaceObj(item,parentObj);
break;
default:
retObj=new AccessObj(item,parentObj);
break;}
return retObj;};
var List=UTIL.Class.create(
BaseObj,{
__construct:function(arg){
var frag;
this.focusIdx=arg.focusIdx===false?false:arg.focusIdx||0;
this.loop=(arg.loop===undefined)?true:arg.loop;
this.ele=tmplDiv.cloneNode(false);
this.ele.className='fdp-list';
this.doc=arg.document;
this.win=arg.window;
this.frameLeft=arg.frameLeft;
this.back=tmplDiv.cloneNode(false);
this.back.className='list-back';
this.listContent=tmplDiv.cloneNode(false);
this.listContent.className='list-content list-scroll move';
this.listContent.style.webkitTransform='';
this.objlist=[];
this.objlistAll=[];
this.linkList=[];
this.scrollType=arg.scrollType||'normal';
this.parentCursorHelpObj=arg.cursorHelpObj;
this.parentNumHelpObj=arg.numHelpObj;
this.parentColorHelpObj=arg.colorHelpObj;
this.lastKey={key:null,count:0};
frag=this.__makeListFragment(arg);
if(arg.firstLine&&this.objlistAll[0].enableFocus){
this.ele.classList.add('fdp-list-border-top');
this.ele.classList.add('fdp-color-border-onbase');}
this.listContent.appendChild(frag);
if(arg.listParam){
this.itemLength=arg.listParam.itemLength;}
this.itemLength=(this.itemLength===undefined)?this.objlist.length:this.itemLength;
this.back.appendChild(this.listContent);
if(this.scrollType==='over'||
this.scrollType==='over-scroll'){
var dummy=tmplDiv.cloneNode(false);
dummy.classList.add('fdp-color-base-sub-a');
dummy.style.width='100%';
dummy.style.height='108rem';
this.listContent.appendChild(dummy);}
if(this.scrollType==='over-scroll'){
this.ele.style.overflow='visible';
this.ele.style.height=arg.height;
}
this.ele.appendChild(this.back);


this.setFocusElement(arg.focusEleId);
this.valueSelector=tmplDiv.cloneNode(false);
this.valueSelector.className='value-selector hide';
this.ele.appendChild(this.valueSelector);
this.setEventHook(arg.eventHook);
this.setKeyHook(arg.keyHook);
this.addEventListener('hideselector',this.hideSelector.bind(this));
this.addEventListener('prehideselector',this.preHideSelector.bind(this));
this.addEventListener('showselector',this.showSelector.bind(this));
this.addEventListener('valuechange',this.valueChange.bind(this));
this.addEventListener('buttonaccess',this.buttonAcess.bind(this));
this.addEventListener('changefocusele',this.changeFocusEle.bind(this));},
destroy:function(){
this.objlistAll.map(function(obj){
if(obj.destroy)
obj.destroy();});
this.removeEventListener('hideselector');
this.removeEventListener('prehideselector');
this.removeEventListener('showselector');
this.removeEventListener('valuechange');
this.removeEventListener('buttonaccess');
this.removeEventListener('changeFocusEle');
scrollAnim.stop();},
__makeListFragment:function(arg){
var frag=document.createDocumentFragment();
arg.list.map(function(item){
var obj=makeListObj(item,this);
frag.appendChild(obj.ele);
if(obj.enableFocus){
obj.idx=this.objlist.length;
this.objlist.push(obj);}else {
if(item.type==='categoryTitle'){
this.linkList.push(obj);
obj.nextId=this.objlist.length;
obj.ele.id=item.id;}
}
if(item.id){
obj.id=item.id;}
this.objlistAll.push(obj);},this);
return frag;},
getBtnElement:function(idx,all){
if(all)
return this.objlistAll[idx].ele;
else
return this.objlist[idx].ele;},
isMoving:function(type){
if(transitionCallback.isMoving(this.focusEle)){
return true;}
if(transitionCallback.isMoving(this.listContent)){
return true;}
if(scrollAnim.isMoving()){
return true;}
if(isSystemFocusMoving(this.focusEle)){
return true;}
return false;},
getFocusObj:function(){
return this.objlist[this.focusIdx];},
getBtnObjById:function(id){
for(var i=0,len=this.objlistAll.length;i<len;i++){
if(this.objlistAll[i].id===id){
return this.objlistAll[i];}
}
return null;},
getBtnObjByFocusIdx:function(idx){
return this.objlist[idx];},
setFocusElement:function(id){
if(id){
this.myFocus=false;
this.focusEle=document.getElementById(id);}else {
this.myFocus=true;
this.focusEle=tmplDiv.cloneNode(false);
this.focusEle.className='fdp-focus fdp-color-focus hide';
this.ele.appendChild(this.focusEle);}
},
showSelector:function(obj,onePopup){
this.selectorMode=true;
hideFocus(this.focusEle);
if(onePopup){
this.back.style.visibility='hidden';}else {
this.listContent.classList.add('fdp-disable');
if(this.parentCursorHelpObj){
this.parentCursorHelpObj.updateCursorHelp(obj);}
}
},
preHideSelector:function(obj,onePopup){
},
hideSelector:function(obj,onePopup){
this.selectorMode=false;
if(onePopup){
this.back.style.visibility='';}
if(onePopup){}else {
this.listContent.classList.remove('fdp-disable');
if(this.parentCursorHelpObj){
this.parentCursorHelpObj.updateCursorHelp(obj);}
}
this.valueSelector.classList.remove('show');
this.valueSelector.classList.add('hide');
removeAllChild(this.valueSelector);
this.showFocus(true);},
valueChange:function(obj){
if(this.eventHook){
this.eventHook({
type:'valuechange',
idx:obj.idx,
id:obj.id,
value:obj.getValue(),
obj:obj
});}
},
buttonAcess:function(obj){
if(this.eventHook){
this.eventHook({
type:'access',
idx:obj.idx,
id:obj.id,
obj:obj
});}
},
changeFocusEle:function(obj){
if(obj===this.getFocusObj()){
this.moveFocus();}
},
getCategoryId:function(idx){
if(this.linkList.length===0){
return null;}
for(var i=0,len=this.linkList.length;i<len-1;i++){
if((this.linkList[i].nextId<=idx)&&(this.linkList[i+1].nextId>idx)){
return this.linkList[i].id;}
}
if(this.linkList[len-1].nextId<=idx){
return this.linkList[len-1].id;}
return null;},
hideSelected:function(){
var obj=this.objlist[this.focusIdx];
obj.unsetSelectedColor();},
showSelected:function(){
var obj=this.objlist[this.focusIdx];
obj.setSelectedColor();},
dispatchFocusEnd:function(){
var obj=this.objlist[this.focusIdx];
this.dispatchEvent('changefocusend',{idx:this.focusIdx,
obj:obj});
if(obj.focus){
obj.focus();}
if(this.parentCursorHelpObj){
this.parentCursorHelpObj.updateCursorHelp(obj);}
if(this.parentNumHelpObj){
this.parentNumHelpObj.updateNumHelp(obj);}
if(this.parentColorHelpObj){
this.parentColorHelpObj.updateColorHelp(obj);}
},
enableFocus:function(){
if((this.focusIdx===false)||this.objlist.length===0||this.itemLength===0)
return false;
else
return true;},
getFocusIdx:function(){
return this.focusIdx;},
setFocusIdx:function(idx,forceEvent,dispatchCategoryEve){
var curIdx=this.focusIdx;
var ev,lastObj;
if((curIdx!==idx)||forceEvent){
ev={
idx:idx,
obj:this.objlist[idx],
force:forceEvent
};
lastObj=this.objlist[this.focusIdx];
if(lastObj.unfocus){
lastObj.unfocus();}
this.focusIdx=idx;
this.dispatchEvent('changefocus',ev);
if(dispatchCategoryEve!==false){
if(this.getCategoryId(curIdx)!==this.getCategoryId(idx)){
this.dispatchEvent('changecategory',this.getCategoryId(idx));}
}
if(this.parentCursorHelpObj){
var obj=this.objlist[idx];
this.parentCursorHelpObj.updateCursorHelp(obj);}
if(this.parentNumHelpObj){
var obj=this.objlist[idx];
this.parentNumHelpObj.updateNumHelp(obj);}
if(this.parentColorHelpObj){
var obj=this.objlist[idx];
this.parentColorHelpObj.updateColorHelp(obj);}
}
return this;},
unfocus:function(){
if(!this.enableFocus())
return false;
hideFocus(this.focusEle);
var obj=this.objlist[this.focusIdx];
obj.unfocus();
this.__onBlure();
return this;},
focus:function(ev){
var syncDraw=false;
if(ev)
syncDraw=ev.syncDraw;
if(!this.enableFocus())
return false;
if(!isNaN(this.frameLeft)){
setSystemFocusOffset(this.frameLeft);}
var self=this;
var callback=function(ev,callback){
transitionCallback.remove(ev.target,callback);
self.showFocus(syncDraw);
self.__onFocus();
self.dispatchFocusEnd();};
this.__makeScrollBar();
this.setFocusIdx(this.focusIdx,true);
this.moveFocus(null,callback,false,false);
return this;},
show:function(){
this.setFocusIdx(this.focusIdx,true);
this.moveFocus(null,null,false,false);},
__getAreaHeight:function(){
var lastObjEle;
if(this.itemLength===undefined){
lastObjEle=arrayLast(this.objlist).ele;
return lastObjEle.offsetTop+lastObjEle.offsetHeight;}else {
lastObjEle=this.objlist[this.itemLength-1].ele;
return lastObjEle.offsetTop+lastObjEle.offsetHeight;}
},
__makeScrollBar:function(){
var areaHeight,pageHeight;
if(!this.scrollLimit){
this.setScrollParam();}
if(this.scrollLimit.needScroll&&!this.scrollBar&&(this.scrollType==='normal')){
areaHeight=this.__getAreaHeight();
pageHeight=this.listContent.offsetHeight;
if(areaHeight>pageHeight){
this.scrollBar=new ScrollBarObj(
{areaHeight:areaHeight,
pageHeight:pageHeight,
pageTop:(this.listContent.getBoundingClientRect().top-this.ele.getBoundingClientRect().top),
loop:this.loop
});
this.back.appendChild(this.scrollBar.ele);}
}
},
__updateScrollBar:function(top,changeHeight,anim){
if(this.scrollBar){
if(changeHeight){
if(!this.scrollLimit.needScroll){
this.hideScrollBar();
return this;}
this.showScrollBar();
this.scrollBar.changeAreaHeight(this.__getAreaHeight());}
this.scrollBar.changeTop(top,(anim===false)?false:true);}
return this;},
showScrollBar:function(){
if(this.scrollBar){
this.scrollBar.ele.style.display='';}
return this;},
hideScrollBar:function(){
if(this.scrollBar){
this.scrollBar.ele.style.display='none';}
return this;},
showFocus:function(drawSync){
if(!this.scrollLimit){
this.setScrollParam();}
showFocus(this.getFocusEle(),null,this.focusEle,null,drawSync);},
setItemLength:function(length){
var lastLength=this.itemLength;
var lastNeedScroll;
this.itemLength=length;
this.__updateScrollParam();
this.__makeScrollBar();
this.__updateScrollBar(this.listContent.dataset.ttop||0,true);
if(lastLength===0&&this.itemLength!==0){
this.focusEle.classList.remove('move');
this.showFocus();}else if(this.itemLength===0){
this.setFocusIdx(0);
hideFocus(this.focusEle);
this.scrollToTop(false);}
if(this.itemLength<=this.focusIdx){
var callback=function(ev,callback){
};
this.setFocusIdx(0);
lastNeedScroll=this.scrollLimit.needScroll;
this.scrollLimit.needScroll=true;
this.moveFocus(null,callback,false);
this.scrollLimit.needScroll=lastNeedScroll;}
},
__updateScrollParam:function(){
var lastEle;
if(this.itemLength===undefined)
return;
if(!this.scrollLimit){
this.setScrollParam();}
if(this.itemLength===0){
this.scrollLimit.needScroll=false;
return;}
lastEle=this.objlist[this.itemLength-1].ele;
if(this.listContent.offsetHeight>=lastEle.offsetTop+lastEle.offsetHeight){
this.scrollLimit.needScroll=false;
return;}
this.scrollLimit.needScroll=true;
},
setScrollParam:function(param){
var lastEle=this.objlist[this.objlist.length-1].ele;
var rect=this.listContent.getBoundingClientRect();var eleRect=this.ele.getBoundingClientRect();
var bottom;
if(this.listContent.offsetHeight>=lastEle.offsetTop+lastEle.offsetHeight){
this.scrollLimit={
needScroll:false,
contTop:rect.top
};
return;}
if(param){
}else {
if(this.scrollType==='over-scroll'){
bottom=rect.top+rect.height-FDP.getParam().listBtnTotalH;}else {
if(rect.top+rect.height>eleRect.height-FDP.getParam().listBtnTotalH){bottom=eleRect.top+this.ele.offsetHeight-FDP.getParam().listBtnTotalH;}else {
bottom=rect.top+rect.height;}
}
this.scrollLimit={
needScroll:true,
top:this.objlist[0].ele.offsetTop+rect.top,
bottom:bottom,
contTop:rect.top
};
this.focusEle.dataset.targettop=this.objlist[0].ele.offsetTop+rect.top;
}
},
scrollToTop_scroll:function(anim){
scrollAnim.start(this.win,{time:400,x:0,y:0,onComplete:function(){}});
this.listContent.dataset.ttop=0;
return this;},
scrollToTop_normal:function(anim){
if(!anim){
this.listContent.classList.remove('move');
this.listContent.classList.remove('fast');}
this.__updateScrollBar(0);
this.listContent.style.webkitTransform='translateY(0px)';
this.listContent.dataset.ttop=0;
return this;},
scrollToTop:function(anim){
if(this.scrollType==='over-scroll')
return this.scrollTop_scroll(anim);
else
return this.scrollTop_normal(anim);},
scrollToCategory:function(id,dispatchEvent){
var target;
if(this.doc){
target=this.doc.getElementById(id);}else {
target=document.getElementById(id);}
var i,len;
var transValue;
var anim=FDP.anim;
if(!this.scrollLimit){
this.setScrollParam();}
if(this.scrollType==='over-scroll'){
if(anim){
scrollAnim.start(this.win,{time:400,x:0,y:target.offsetTop,onComplete:function(){}});}else {
this.win.scroll(0,target.offsetTop);}
this.listContent.dataset.ttop=-target.offsetTop;}else {
var callback=function(ev,callback){
transitionCallback.remove(ev.target,callback);};
transValue=getTransValue(this.listContent.style.webkitTransform);
if(transValue!==(target.offsetTop*-1)+'px')
{
if(anim){
this.listContent.classList.add('move');
this.listContent.classList.remove('fast');
transitionCallback.add(this.listContent,callback);}else {
this.listContent.classList.remove('move');
this.listContent.classList.remove('fast');}
this.listContent.style.webkitTransform='translateY('+ -target.offsetTop+'px)';
this.listContent.dataset.ttop=-target.offsetTop;}
}
for(i=0,len=this.linkList.length;i<len;i++){
if(this.linkList[i].ele===target){
this.setFocusIdx(this.linkList[i].nextId,false,dispatchEvent);
break;}
}
return this;},
getFocusEle:function(){
var target;
var focusObj=this.getFocusObj();
if(focusObj.getFocusEle)
target=focusObj.getFocusEle();
else
target=focusObj.ele;
return target;},
__setListPos_scroll:function(pos,callback,anim){
var self=this;
if(FDP.anim===false)
anim=false;
this.listContent.dataset.ttop=pos;
var time=400;
if(anim){
if((this.lastKey.key===keyDef.DOWN)&&
(this.lastKey.count>3)&&
(this.focusEle.dataset.movetoedge!=='yes')){
time=200;}
scrollAnim.start(this.win,{time:time,x:0,y:-1*pos,onComplete:function(){
if(callback){
callback({target:self.listContent},callback);}
}});}else {
this.win.scroll(0,-1*pos);
if(callback){
callback({target:self.listContent},callback);}
}
},
__setListPos_normal:function(pos,callback,anim){
if(FDP.anim===false)
anim=false;
var transValue=getTransValue(this.listContent.style.webkitTransform);
if(transValue!==(pos+'px')){
if(anim){
this.listContent.classList.add('move');
if((this.lastKey.key===keyDef.DOWN)&&(this.lastKey.count>3)&&(this.focusEle.dataset.movetoedge!=='yes')){
this.listContent.classList.add('fast');}else {
this.listContent.classList.remove('fast');}
}else {
this.listContent.classList.remove('move');
this.listContent.classList.remove('fast');}
this.__updateScrollBar(pos,false,anim);
this.listContent.style.webkitTransform='translateY('+pos+'px)';
this.listContent.dataset.ttop=pos;
if(anim){
transitionCallback.add(this.listContent,function(ev,__callback){
transitionCallback.remove(ev.target,__callback);
if(callback)
callback(ev,callback);});}else {
if(callback)
callback({target:this.listContent},callback);}
}else {
if(callback)
callback({target:this.listContent},callback);}
return this;},
__setListPos:function(pos,callback,anim){
if(this.scrollType==='over-scroll'){
return this.__setListPos_scroll(pos,callback,anim);}else {
return this.__setListPos_normal(pos,callback,anim);}
},
__moveFocusEle:function(target,callback,anim){
var trect=target.getBoundingClientRect();
var ttop;
if(this.listContent.dataset.ttop){
ttop=target.offsetTop+Number(this.listContent.dataset.ttop)+this.scrollLimit.contTop;}else {
ttop=target.offsetTop+this.scrollLimit.contTop;}
moveFocus(target,{
top:ttop,
left:trect.left,
width:trect.width,
height:trect.height
},callback,this.focusEle,null,anim);},
moveFocus:function(dir,callback,anim,scrollAnim){
if(!this.enableFocus())
return false;
var target,focusObj,targetRect;
var contentListRect,offset;
var top,bottom;
var targetPos;
var listTop;
var trect,ttop;
var self=this;
if(anim===undefined)
anim=true;
if(scrollAnim===undefined)
scrollAnim=true;
target=this.getFocusEle();
if(!this.scrollLimit){
this.setScrollParam();}
if(this.scrollLimit.needScroll){
if(this.listContent.dataset.ttop)
listTop=Number(this.listContent.dataset.ttop)+this.scrollLimit.contTop;
else
listTop=this.scrollLimit.contTop;
top=listTop+target.offsetTop;
bottom=top+target.offsetHeight;
if(bottom>this.scrollLimit.bottom){
offset=top-(Number(this.focusEle.dataset.targettop||this.scrollLimit.contTop)-this.scrollLimit.contTop);
targetPos=listTop-offset;
if((this.scrollType==='normal')&&((targetPos+this.__getAreaHeight()+
(this.listContent.scrollHeight-this.listContent.scrollHeight)-
target.offsetHeight-this.listContent.offsetHeight)<0)){
targetPos=-(this.__getAreaHeight()-this.listContent.offsetHeight);
this.__setListPos(targetPos,function(ev){
var target=self.getFocusEle();
self.__moveFocusEle(target,callback,anim);},scrollAnim);
return this;}else {
this.__setListPos(targetPos,callback,scrollAnim);
return this;}
}else if(top<this.scrollLimit.top){
offset=((Number(this.focusEle.dataset.targettop)||this.scrollLimit.contTop)-this.scrollLimit.contTop)-top;
targetPos=listTop+offset;
if(targetPos<=0){
this.__setListPos(targetPos,callback,scrollAnim);
return this;}else {
this.__setListPos(0,function(ev){
var target=self.getFocusEle();
self.__moveFocusEle(target,callback,anim);},scrollAnim);
return this;}
}
}
this.__moveFocusEle(target,callback,anim);
return this;},
canMoveFocus:function(){
return true;

},
moveNextFocus:function(){
var ret=false;
var self=this;
if(!this.enableFocus())
return false;
if(!this.canMoveFocus())
return true;
if((this.focusIdx+1<this.objlist.length)&&(this.focusIdx+1<this.itemLength)){
this.setFocusIdx(this.focusIdx+1);
this.moveFocus('next',function(ev,callback){
transitionCallback.remove(ev.target,callback);
self.dispatchFocusEnd();});
return true;}
if(this.loop){
ret=this.__moveToTop(false);}
return ret;},
movePrevFocus:function(){
var ret=false;
var self=this;
if(!this.enableFocus())
return false;
if(!this.canMoveFocus())
return true;
if(this.focusIdx>0){
this.setFocusIdx(this.focusIdx-1);
this.moveFocus('prev',function(ev,callback){
transitionCallback.remove(ev.target,callback);
self.dispatchFocusEnd();});
return true;}
if(this.loop)
ret=this.__moveToBottom(false);
return ret;},
moveFocusWrap:function(dir,anim){
if(!anim)
hideFocus(this.focusEle);
this.moveFocus(dir,function(ev,callback){
transitionCallback.remove(ev.target,callback);
if(this.focusEle.dataset.movetoedge==='yes'){
var fele=this.focusEle;
setTimeout(function(){
fele.dataset.movetoedge='no';},400);}
if(!anim){
this.showFocus(false);}
this.dispatchFocusEnd();}.bind(this),anim);},
__getObjByTop:function(top){
var i,obj,lastBottom=0;
if(top<=0){
return this.objlist[0];}
for(i=0;i<this.objlist.length;i++){
obj=this.objlist[i];
if(lastBottom<=top&&(obj.ele.offsetTop+obj.ele.offsetHeight)>=top){
return obj;}
lastBottom=obj.ele.offsetTop+obj.ele.offsetHeight;}
return obj;},
scrollPageUp:function(){
var ret=false;
var curIdx=this.getFocusIdx();
var curObj,nextObj;
if(this.isMoving()){
return false;}
if(curIdx===0){
if(this.loop)
ret=this.__moveToBottom(false);
return ret;}
if(this.scrollLimit.needScroll===false){
ret=this.__moveToTop(true);
return ret;}
curObj=this.getFocusObj();
nextObj=this.__getObjByTop(curObj.ele.offsetTop-this.listContent.offsetHeight);
this.setFocusIdx(nextObj.idx);
this.moveFocusWrap('prev',true);
return true;},
scrollPageDown:function(){
var ret=false;
var curIdx=this.getFocusIdx();
var curObj,nextObj;
if(this.isMoving()){
return false;}
if(curIdx===this.itemLength-1){
if(this.loop)
ret=this.__moveToTop(false);
return ret;}
if(this.scrollLimit.needScroll===false){
ret=this.__moveToBottom(true);
return ret;}
curObj=this.getFocusObj();
nextObj=this.__getObjByTop(curObj.ele.offsetTop+this.listContent.offsetHeight);
this.setFocusIdx(nextObj.idx);
this.moveFocusWrap('next',true);
return true;},
__moveToBottom:function(anim){
var self=this;
anim=anim||false;
if(this.isMoving()){
return false;}
this.focusEle.dataset.movetoedge='yes';
this.setFocusIdx(this.itemLength-1);
this.moveFocusWrap('next',anim);
return true;},
__moveToTop:function(anim){
var self=this;
anim=anim||false;
if(this.isMoving()){
return false;}
this.focusEle.dataset.movetoedge='yes';
this.setFocusIdx(0);
this.moveFocusWrap('prev',anim);
return true;},
selectButton:function(){
return true;},
getValueSelectorEle:function(){
return this.valueSelector;},
defaultKeyHook:function(ev){
var ret=false;
var obj;
if(!this.enableFocus())
return false;
obj=this.objlist[this.focusIdx];
if(ev.type==='keydown'){
this.lastKey.key=ev.keyCode;
this.lastKey.count++;}else {
this.lastKey.key=null;
this.lastKey.count=0;}
if(this.isMoving()&&!this.selectorMode){
ret=false;}else {
ret=obj.keyHook(ev);}
if(ret)
return true;
if(ev.type==='keydown'){
if([keyDef.DOWN,keyDef.UP,keyDef.CH_UP,keyDef.CH_DOWN].indexOf(ev.keyCode)!==-1){
if(this.focusEle.dataset.movetoedge==='yes'){
return true;}
}
switch(ev.keyCode){
case keyDef.DOWN:
ret=this.moveNextFocus();
if(ev.preventDefault)
ev.preventDefault();
break;
case keyDef.UP:
ret=this.movePrevFocus();
if(ev.preventDefault)
ev.preventDefault();
break;
case keyDef.CH_UP:
ret=this.scrollPageUp();
ret=true;
break;
case keyDef.CH_DOWN:
ret=this.scrollPageDown();
ret=true;
break;
case keyDef.ENTER:
break;}
}else {
}
return ret;},
setKeyHook:function(hook){
if(hook)
this.keyHook=hook;
else
this.keyHook=this.defaultKeyHook.bind(this);},
setEventHook:function(hook){
if(hook){
this.eventHook=hook;}
}
}
);

var makeColsBtnObj=function(item,parentObj){
item.subType='access2';
return new AccessObj(item,parentObj);};
var makeMultiColsCol=function(colData){
var colEle=tmplDiv.cloneNode(false);
var self=this;
var objs=[];
colEle.className='fdp-multi-cols-col';
colData.map(function(item){
var btn=makeColsBtnObj(item,self);
btn.ele.className='fdp-multi-cols-btn fdp-color-btn fdp-color-text-onbase fdp-color-btn-border';
colEle.appendChild(btn.ele);
objs.push(btn);});
return {
ele:colEle,
objs:objs
};};
var MultiColsObj=UTIL.Class.create(
BaseObj,{
__construct:function(arg){
var self=this;
this.focusIdx=arg.focusIdx===false?false:arg.focusIdx||0;
this.loop=arg.loop||false;
this.ele=tmplDiv.cloneNode(false);
this.ele.classList.add('fdp-multi-cols-wrap');
this.cols=tmplDiv.cloneNode(false);
this.cols.className='fdp-multi-cols';
if(getDirection()==='rtl')
this.cols.classList.add('fdp-row-reverse');
this.objlist=[];
arg.list.map(function(colData){
var col=makeMultiColsCol.call(self,colData);
self.objlist.push(col.objs);
self.cols.appendChild(col.ele);});
this.objNum=this.getObjNum();
this.setFocusElement(arg.focusEleId);
this.ele.appendChild(this.cols);
this.setEventHook(arg.eventHook);
this.setKeyHook(arg.keyHook);
this.addEventListener('buttonaccess',this.buttonAcess.bind(this));
return this.ele;},
destroy:function(){
this.removeEventListener('buttonaccess');},
setFocusElement:function(id){
if(id){
this.myFocus=false;
this.focusEle=document.getElementById(id);}else {
this.myFocus=true;
this.focusEle=tmplDiv.cloneNode(false);
this.focusEle.className='fdp-focus fdp-color-focus hide';
this.ele.appendChild(this.focusEle);}
},
focus:function(){
var self=this;
var callback=function(ev,callback){
transitionCallback.remove(ev.target,callback);
self.showFocus(false);
self.__onFocus();
};
this.setFocusIdx(this.focusIdx,true);
this.moveFocus(null,callback,false);},
unfocus:function(){
hideFocus(this.focusEle);
this.__onBlure();},
showFocus:function(){
showFocus(this.getFocusObj().ele,null,this.focusEle,null,true);},
moveFocus:function(dir,callback,anim){
if(anim===undefined)
anim=true;
moveFocus(this.getFocusObj().ele,null,callback,this.focusEle,null,anim);},
getFocusRowInfo:function(){
var i,len,col,total=0;
len=this.objlist.length;
for(i=0;i<len;i++){
col=this.objlist[i];
total+=col.length;
if(total>this.focusIdx){
return {id:i,preTotal:(total-col.length)};}
}
return null;},
getFocusObj:function(){
var colInfo=this.getFocusRowInfo();
return this.objlist[colInfo.id][this.focusIdx-colInfo.preTotal];},
getBtnObjById:function(id){
for(var i=0,len=this.objlist.length;i<len;i++){
if(this.objlist[i].id===id){
return this.objlist[i];}
}
return null;},
getBtnObjByFocusIdx:function(idx){
return this.objlist[idx];},
getFocusIdx:function(){
return this.focusIdx;},
setFocusIdx:function(idx,forceEvent){
var curIdx=this.focusIdx;
var ev;
if((curIdx!==idx)||forceEvent){
this.focusIdx=idx;
ev={
idx:idx,
obj:this.getFocusObj(),
force:forceEvent
};
this.dispatchEvent('changefocus',ev);
if(this.parentCursorHelpObj){
var obj=this.objlist[idx];
this.parentCursorHelpObj.updateCursorHelp(obj);}
}
},
getObjNum:function(){
var i,total=0;
for(i=0;i<this.objlist.length;i++){
total+=this.objlist[i].length;}
return total;},
moveNextFocus:function(){
var self=this;
var ret=false;
var colInfo=this.getFocusRowInfo();
var objPos=this.focusIdx-colInfo.preTotal;
if(this.focusIdx+1<this.getObjNum()){
if((objPos+1>=this.objlist[colInfo.id].length)&&!this.loop){
}else {
this.setFocusIdx(this.focusIdx+1);
this.moveFocus('next',function(ev,callback){
transitionCallback.remove(ev.target,callback);
});
ret=true;}
}else {
if(this.loop){
if(!this.isMoving()){
this.setFocusIdx(0);
this.moveFocus('next');
ret=true;}
}
}
return ret;},
movePrevFocus:function(){
var self=this;
var ret=false;
var colInfo=this.getFocusRowInfo();
var objPos=this.focusIdx-colInfo.preTotal;
if(this.focusIdx>0){
if((objPos===0)&&!this.loop){
}else {
this.setFocusIdx(this.focusIdx-1);
this.moveFocus('prev',function(ev,callback){
transitionCallback.remove(ev.target,callback);
});
ret=true;}
}else {
if(this.loop){
if(!this.isMoving()){
this.setFocusIdx(this.getObjNum()-1);
this.moveFocus('next');
ret=true;}
}
}
return ret;},
moveRow:function(dir){
var colInfo=this.getFocusRowInfo();
var objPos=this.focusIdx-colInfo.preTotal;
var nextCol;
var ret=false;
if(dir==='prev'){
if(colInfo.id>0){
nextCol=this.objlist[colInfo.id-1];
if(nextCol.length>objPos){
this.setFocusIdx(colInfo.preTotal-nextCol.length+objPos);}else {
this.setFocusIdx(colInfo.preTotal-nextCol.length);}
ret=true;}else {
if(this.loop){
if(!this.isMoving()){
dir='next';
nextCol=this.objlist[this.objlist.length-1];
if(nextCol.length>objPos){
this.setFocusIdx(this.objNum-nextCol.length+objPos);}else {
this.setFocusIdx(this.objNum-nextCol.length);}
ret=true;}
}
}
}else {
if(colInfo.id<this.objlist.length-1){
nextCol=this.objlist[colInfo.id+1];
if(nextCol.length>objPos){
this.setFocusIdx(colInfo.preTotal+this.objlist[colInfo.id].length+objPos);}else {
this.setFocusIdx(colInfo.preTotal+this.objlist[colInfo.id].length);}
ret=true;}else {
if(this.loop){
if(!this.isMoving()){
dir='prev';
nextCol=this.objlist[0];
if(nextCol.length>objPos){
this.setFocusIdx(objPos);}else {
this.setFocusIdx(0);}
ret=true;}
}
}
}
if(ret)
this.moveFocus(dir);
return ret;},
isMoving:function(type){
if(transitionCallback.isMoving(this.focusEle)){
return true;}
return false;},
defaultKeyHook:function(ev){
var ret=false;
var obj=this.getFocusObj();
if(this.isMoving()){
ret=false;}
else {
if(ev.keyCode===keyDef.ENTER){
ret=obj.keyHook(ev);}
}
if(ret)
return true;
if(ev.type==='keydown'){
switch(ev.keyCode){
case keyDef.DOWN:
ret=this.moveNextFocus();
break;
case keyDef.UP:
ret=this.movePrevFocus();
break;
case keyDef.LEFT:
ret=this.moveRow('prev');
break;
case keyDef.RIGHT:
ret=this.moveRow('next');
break;}
}
return ret;},
setKeyHook:function(hook){
if(hook)
this.keyHook=hook;
else
this.keyHook=this.defaultKeyHook.bind(this);},
setEventHook:function(hook){
if(hook){
this.eventHook=hook;}
},
buttonAcess:function(obj){
if(this.eventHook){
this.eventHook({
type:'access',
idx:obj.idx,
id:obj.id,
obj:obj
});}
},
getWidth:function(){
var width;
var lastRowObj=this.objlist[this.objlist.length-1][0];
width=-this.objlist[0][0].ele.offsetLeft+lastRowObj.ele.offsetLeft+lastRowObj.ele.offsetWidth;
this.ele.style.width=width+'px';
return this.ele.offsetWidth;}
});
var readTextFile=function(path){
var obj=false;
var lineMax=13;
var lineNum;
obj=new XMLHttpRequest();
if(obj){
obj.open('get',path,false);
obj.setRequestHeader('Connection','close');
obj.send('');
if(obj.readyState==4&&obj.status==0){
var text=obj.responseText;
if(!text){
text='';}
lineNum=text.match(/\n/g);
text=text.replace(/"/g,'\"');
text=text.replace(/</g,'&lt;');
text=text.replace(/>/g,'&gt;');
text=text.replace(/\n/g,'<br>');
text=text.replace(/\t/g,' ');}
}
return text;};

var TextAreaElement={
make:(function(){
var tmpl=null;
var textArea=null;
var textAreaBg=null;
var up,down;
var func=function(arg){
if(textArea===null){
up=tmplDiv.cloneNode(false);
down=tmplDiv.cloneNode(false);
textArea=tmplDiv.cloneNode(false);
textAreaBg=tmplDiv.cloneNode(false);
textArea.className='textarea fdp-color-border-onbase fdp-color-text-onbase fdp-color-scrollbar';textAreaBg.className='fdp-color-text-onbase fdp-color-pop-a';up.className='fdp-triangle up fdp-color-icon-onbase-border';
down.className='fdp-triangle down fdp-color-icon-onbase-border';
up.style.position='relative';
down.style.position='relative';
up.style.bottom='1rem';
down.style.top='1rem';
if(FDP.isLtr()){
up.style.left='-webkit-calc(100% - 2.2rem)';
down.style.left='-webkit-calc(100% - 2.2rem)';}else {
up.style.left='1rem';
down.style.left='1rem';}
textArea.style.paddingLeft='2rem';
textArea.style.paddingRight='2rem';
textAreaBg.style.padding='2rem';
textAreaBg.appendChild(up);
textAreaBg.appendChild(textArea);
textAreaBg.appendChild(down);}
var ele=textAreaBg.cloneNode(true);
return ele;};
return func;}())
};
var TextAreaObj=UTIL.Class.create(
BaseObj,{
eleFunc:TextAreaElement,
__construct:function(arg){
this.ele=this.makeElement(arg);
var childs=this.ele.childNodes;
this.up=childs[0];
this.child=childs[1];
this.down=childs[2];
if(FDP.getLanguage()=='th'&&arg.useThaiFont==true){
this.child.style.lineHeight='2.0';}else {
this.child.style.lineHeight='1.4';}
if(arg.textDirection===false){
this.up.style.direction='ltr';
this.child.style.direction='ltr';
this.down.style.direction='ltr';}
this.child.style.height=0;
if(arg.fullscreen){
this.child.style.marginLeft=arg.x;
this.child.style.marginTop=arg.y;
this.child.style.width=arg.width;}
if(arg.scrollbar==true){
this.child.style.overflowY='scroll';}else {
this.child.style.overflowY='hidden';}
this.child.innerHTML=readTextFile(arg.textfile);}
}
);

var getCursorRemGuideImgName=function(lineEna,buttomEna,cursorEna){
var base_path='/usr/local/png/m_widget3/';var imgName=base_path+'EU_RemGuide_000000_0000_11.png';
if(!lineEna||!buttomEna||!cursorEna)
return imgName;
var up_line=lineEna['up'];
var down_line=lineEna['down'];
var right_line=lineEna['right'];
var left_line=lineEna['left'];
var enter_line=lineEna['enter'];
var enter3_line=0;var enter2_line='';
var up_ena=cursorEna['up'];
var down_ena=cursorEna['down'];
var left_ena=cursorEna['left'];
var right_ena=cursorEna['right'];
var exit_btn=buttomEna['exit'];
var return_btn=buttomEna['return'];
imgName=base_path+'EU_RemGuide_'+
up_line+down_line+left_line+right_line+
enter_line+enter3_line+enter2_line+'_'+
up_ena+down_ena+left_ena+right_ena+'_'+
exit_btn+return_btn+'.png';
return imgName;};
var CursorHelpElement={
make:(function(){
var tmpl=null;
var func=function(arg){
if(tmpl===null){

var upTxt=tmplDiv.cloneNode(false);
upTxt.className='upTxt';
upTxt.style.lineHeight='1.3';
upTxt.style.whiteSpace='nowrap';
var enterTxt=tmplDiv.cloneNode(false);
enterTxt.className='enterTxt';
enterTxt.style.verticalAlign='top';
enterTxt.style.textAlign='right';
enterTxt.style.marginTop='0.4rem';
enterTxt.style.display='inline-block';
enterTxt.style.whiteSpace='nowrap';

var img=document.createElement('img');
img.className='cursorImg';
img.src=getCursorRemGuideImgName();
img.style.width='10rem';
var rightTxtArea=tmplDiv.cloneNode(false);
rightTxtArea.className='rightTxtArea';
rightTxtArea.style.display='inline-block';
rightTxtArea.style.position='relative';
rightTxtArea.style.verticalAlign='top';
var exitTxt=tmplDiv.cloneNode(false);
exitTxt.className='exitTxt';
exitTxt.style.whiteSpace='nowrap';
var rightTxt=tmplDiv.cloneNode(false);
rightTxt.className='rightTxt';
rightTxt.style.position='absolute';
rightTxt.style.top='3.2rem';
rightTxt.style.whiteSpace='nowrap';
var returnTxt=tmplDiv.cloneNode(false);
returnTxt.className='returnTxt';
returnTxt.style.position='absolute';
returnTxt.style.top='6.8rem';
returnTxt.style.whiteSpace='nowrap';
if(FDP.getLanguage()==='my'){
upTxt.style.paddingBottom='0.8rem';
enterTxt.style.marginTop='0rem';
rightTxt.style.top='1.6rem';
returnTxt.style.top='5.5rem';}
rightTxtArea.appendChild(exitTxt);
rightTxtArea.appendChild(rightTxt);
var vSizeBox=tmplDiv.cloneNode(false);
vSizeBox.className='vSizeBox fdp-color-point fdp-color-text-onbase';
vSizeBox.style.display='inline-block';
vSizeBox.style.position='absolute';
vSizeBox.style.top='3.2rem';
rightTxtArea.appendChild(vSizeBox);
rightTxtArea.appendChild(returnTxt);

tmpl=tmplDiv.cloneNode(false);
tmpl.className='fdp-cursor-help fdp-color-text-onbase';
tmpl.appendChild(upTxt);
tmpl.appendChild(enterTxt);
tmpl.appendChild(img);
tmpl.appendChild(rightTxtArea);}
var ele=tmpl.cloneNode(true);
return ele;};
return func;}())
};
var CursorHelpObj=UTIL.Class.create(
BaseObj,{
eleFunc:CursorHelpElement,
__construct:function(arg){
this.ele=this.makeElement(arg);
if(arg.txtListAll){this.txtListAll=arg.txtListAll;}else {
this.txtListAllInit(arg);}
if(arg.cursorHelpArgs&&arg.cursorHelpArgs.vSizeBox){
this.vSizeBox=true;}
this.txtListInit(this.txtListAll);
this.cursorEna={'up':0,'down':0,'left':0,'right':0};
this.setCursorHelp(this.txtList);},
setCursorHelp:function(txtList,cursorEna){
var lineEna={
'up':0,'down':0,'right':0,'left':0,'enter':0
};
var buttomEna={
'return':0,'exit':0
};
var cursorEle;
if(txtList){
if(txtList.up!=null)
this.txtList.up=txtList.up;
if(txtList.down!=null)
this.txtList.down=txtList.down;
if(txtList.right!=null)
this.txtList.right=txtList.right;
if(txtList.left!=null)
this.txtList.left=txtList.left;
if(txtList.exit!=null)
this.txtList.exit=txtList.exit;
if(txtList.enter!=null)
this.txtList.enter=txtList.enter;
if(txtList.return !=null)
this.txtList.return =txtList.return;}
this.ele.getElementsByClassName('upTxt')[0].innerHTML=this.txtList.up;
this.ele.getElementsByClassName('enterTxt')[0].innerHTML=this.txtList.enter;
this.ele.getElementsByClassName('exitTxt')[0].innerHTML=this.txtList.exit;
this.ele.getElementsByClassName('rightTxt')[0].innerHTML=this.txtList.right;
this.ele.getElementsByClassName('returnTxt')[0].innerHTML=this.txtList.return;
if(cursorEna){
if(cursorEna.up!=null)
this.cursorEna.up=cursorEna.up;
if(cursorEna.down!=null)
this.cursorEna.down=cursorEna.down;
if(cursorEna.right!=null)
this.cursorEna.right=cursorEna.right;
if(cursorEna.left!=null)
this.cursorEna.left=cursorEna.left;}else {
if(this.txtList.up&&(this.txtList.up!='')){
this.cursorEna.up=1;
this.cursorEna.down=1;}else {
this.cursorEna.up=0;
this.cursorEna.down=0;}
if(this.txtList.right&&(this.txtList.right!='')){
this.cursorEna.right=1;
this.cursorEna.left=1;}else {
this.cursorEna.right=0;
this.cursorEna.left=0;}
}
if(this.txtList.up!='')
lineEna.up=1;
if(this.txtList.down!='')
lineEna.down=0;
if(this.txtList.right!='')
lineEna.right=1;
if(this.txtList.left!='')
lineEna.left=0;
if(this.txtList.enter!='')
lineEna.enter=1;
if(this.txtList.return !='')
buttomEna.return =1;
if(this.txtList.exit!='')
buttomEna.exit=1;
cursorEle=this.ele.getElementsByClassName('cursorImg')[0];
cursorEle.src=getCursorRemGuideImgName(lineEna,buttomEna,this.cursorEna);
cursorEle.onerror=function(){
cursorEle.src='/usr/local/png/m_widget3/EU_RemGuide_100010_1111_01.png';};},
updateCursorHelp:function(obj,sysMenu,updown,updownText){
var txtList={};
var cursorEna={};
var setUpdown=false;
if(this.helpCtrlEnable===false)
return;
if(sysMenu&&(sysMenu=='navi')){
txtList.enter=LANG('LT_ACCESS');
txtList.right='';
if(FDP.isLtr()){
cursorEna.left=0;
cursorEna.right=1;}else {
cursorEna.left=1;
cursorEna.right=0;}
this.setCursorHelp(txtList,cursorEna);
return;}
if(sysMenu&&(sysMenu=='menu')){
cursorEna.left=1;
cursorEna.right=1;}
switch(obj.type){
case 'choice':
if(obj.isSelectMode){
txtList.enter=LANG('LT_OK');
this.defUpTxt=this.txtList.up;
txtList.up=LANG('LT_SELECT');
if(FDP.isLtr()){
cursorEna.left=1;
cursorEna.right=0;}else {
cursorEna.left=0;
cursorEna.right=1;}
}else {
txtList.enter=LANG('LT_CHANGE');
txtList.up=this.defUpTxt;}
break;
case '2buttonChoice':
txtList.enter=LANG('LT_OK');
txtList.right=LANG('LT_CHANGE');
break;
case '2choice':
txtList.enter=LANG('LT_ACCESS');
txtList.right=LANG('LT_CHANGE');
break;
case 'choice4':
txtList.enter='';
txtList.right=LANG('LT_CHANGE');
break;
case 'dacbar':
case 'sliderbar':
if(obj.isSelectMode){
txtList.enter=LANG('LT_OK');
txtList.right=LANG('LT_ADJUST');
this.defUpTxt=this.txtList.up;
txtList.up='';
cursorEna.up=0;
cursorEna.down=0;
setUpdown=true;}else {
txtList.enter=LANG('LT_ADJUST');
txtList.right='';
txtList.up=this.defUpTxt;
cursorEna.up=1;
cursorEna.down=1;}
break;
case 'hyperbar':
txtList.right=LANG('LT_ADJUST');
break;
case 'input':
txtList.enter='';
break;
case 'access':
if(obj.enterTxt)
txtList.enter=obj.enterTxt;
else
txtList.enter=LANG('LT_ACCESS');
break;
case 'row':
default:
txtList.enter=LANG('LT_OK');
break;}
if(obj.disable){
txtList.enter='';
if(sysMenu&&(sysMenu=='menu')){
if(FDP.isLtr()){
cursorEna.left=1;
cursorEna.right=0;}else {
cursorEna.left=0;
cursorEna.right=1;}
}
}
if(setUpdown===false){
if(updown===false){
this.defUpTxt=this.txtList.up;
txtList.up='';
cursorEna.up=0;
cursorEna.down=0;}else {
if(updownText)
txtList.up=updownText;
else
txtList.up=this.defUpTxt;
cursorEna.up=1;
cursorEna.down=1;}
}
if(sysMenu&&(sysMenu=='menu')){
this.setCursorHelp(txtList,cursorEna);}else {
this.setCursorHelp(txtList);}
},
setCursorHelpLayout:function(maxWidth){
var objUpTxt=this.ele.getElementsByClassName('upTxt')[0];
var objEnterTxt=this.ele.getElementsByClassName('enterTxt')[0];
var objExitTxt=this.ele.getElementsByClassName('exitTxt')[0];
var objRightTxt=this.ele.getElementsByClassName('rightTxt')[0];
var objReturnTxt=this.ele.getElementsByClassName('returnTxt')[0];
var objCursorImg=this.ele.getElementsByClassName('cursorImg')[0];
var objRightTxtArea=this.ele.getElementsByClassName('rightTxtArea')[0];
if(this.vSizeBox){
var objVSizeBox=this.ele.getElementsByClassName('vSizeBox')[0];}
var enterTxt=objEnterTxt.innerHTML;
var enterTxtMaxWidth=0;
for(var i=0;i<this.txtListAll['enter'].length;i++){
objEnterTxt.innerHTML=this.txtListAll['enter'][i];
if(objEnterTxt.offsetWidth>enterTxtMaxWidth){
enterTxtMaxWidth=objEnterTxt.offsetWidth;}
}
var returnTxt=objReturnTxt.innerHTML;
var returnTxtMaxWidth=0;
for(var i=0;i<this.txtListAll['return'].length;i++){
objReturnTxt.innerHTML=this.txtListAll['return'][i];
if(objReturnTxt.offsetWidth>returnTxtMaxWidth){
returnTxtMaxWidth=objReturnTxt.offsetWidth;}
}
objReturnTxt.innerHTML=returnTxt;
objRightTxtArea.style.width=returnTxtMaxWidth+'px';
var rightTxt=objRightTxt.innerHTML;
var rightTxtMaxWidth=0;
for(var i=0;i<this.txtListAll['right'].length;i++){
objRightTxt.innerHTML=this.txtListAll['right'][i];
if(objRightTxt.offsetWidth>rightTxtMaxWidth){
rightTxtMaxWidth=objRightTxt.offsetWidth;}
}
objRightTxt.innerHTML=rightTxt;
if(rightTxtMaxWidth>returnTxtMaxWidth){
objRightTxtArea.style.width=rightTxtMaxWidth+'px';}
if(this.vSizeBox){
objVSizeBox.style.marginLeft=rightTxtMaxWidth+'px';}
if(maxWidth){
var allOffsetWidth=objCursorImg.offsetWidth+enterTxtMaxWidth+returnTxtMaxWidth+(24*window.innerWidth/1920);
if(maxWidth<allOffsetWidth){
enterTxtMaxWidth=enterTxtMaxWidth-((allOffsetWidth-maxWidth)+(60*window.innerWidth/1920));
objEnterTxt.style.whiteSpace='normal';}
}
objUpTxt.style.marginLeft=enterTxtMaxWidth+(20*window.innerWidth/1920)+'px';
objEnterTxt.innerHTML=enterTxt;
objEnterTxt.style.width=enterTxtMaxWidth+'px';
var upTxt=objUpTxt.innerHTML;
var upTxtMaxHeight=0;
for(var i=0;i<this.txtListAll['up'].length;i++){
objUpTxt.innerHTML=this.txtListAll['up'][i];
if(objUpTxt.offsetHeight>upTxtMaxHeight){
upTxtMaxHeight=objUpTxt.offsetHeight;}
}
objUpTxt.innerHTML=upTxt;
objUpTxt.style.height=upTxtMaxHeight+'px';},
txtListAllInit:function(arg){
this.txtListAll={'up':[''],'down':[''],'right':[''],'left':[''],'enter':[''],'exit':[''],'return':['']};
if(arg.cursorHelpArgs){
this.helpCtrlEnable=false;
if(arg.cursorHelpArgs.curUpTextLst)
this.txtListAll.up=arg.cursorHelpArgs.curUpTextLst;
if(arg.cursorHelpArgs.enterTextLst)
this.txtListAll.enter=arg.cursorHelpArgs.enterTextLst;
if(arg.cursorHelpArgs.curRightTextLst)
this.txtListAll.right=arg.cursorHelpArgs.curRightTextLst;
if(arg.cursorHelpArgs.returnTextLst)
this.txtListAll.return =arg.cursorHelpArgs.returnTextLst;
if(arg.cursorHelpArgs.exitTextLst)
this.txtListAll.exit=arg.cursorHelpArgs.exitTextLst;}else {
this.helpCtrlEnable=true;
this.txtListAll={
'up':['',LANG('LT_SELECT'),LANG('LT_CHANGE'),LANG('LT_SCROLL_PAGE')],
'right':['',LANG('LT_SELECT'),LANG('LT_ADJUST')],
'enter':['',LANG('LT_ACCESS'),LANG('LT_OK'),LANG('LT_ADJUST'),LANG('LT_CHANGE'),LANG('LT_RESET')],
'return':[LANG('LT_RETURN')]
};
if(arg.textArea){this.defUpTxt=LANG('LT_SCROLL_PAGE');}else if(arg.button&&arg.button.length>1){this.defUpTxt=LANG('LT_SELECT');}
}
},
txtListInit:function(txtListAll){
this.txtList={
'up':'','down':'','right':'','left':'','enter':'','exit':'','return':''
};
if(this.defUpTxt){
this.txtList.up=this.defUpTxt;}else if(txtListAll.up){
this.txtList.up=txtListAll.up[0];}
if(txtListAll.down)
this.txtList.down=txtListAll.down[0];
if(txtListAll.right)
this.txtList.right=txtListAll.right[0];
if(txtListAll.left)
this.txtList.left=txtListAll.left[0];
if(txtListAll.enter)
this.txtList.enter=txtListAll.enter[0];
if(txtListAll.exit)
this.txtList.exit=txtListAll.exit[0];
if(txtListAll.return)
this.txtList.return =txtListAll.return[0];},
setVsizeTxt:function(txt){
this.ele.getElementsByClassName('vSizeBox')[0].innerHTML=txt;}
}
);

var NumHelpElement={
make:(function(){
var tmpl=null;
var func=function(arg){
if(tmpl===null){
var base_path='/usr/local/png/m_widget3/';var img1='rem_10key_0.png';
var img2='rem_10key_9.png';
if(FDP.getGblValue('area')==='jp'){
base_path='/usr/local/png/';
img1='okonomi_10key_1.png';
img2='okonomi_10key_0.png';}
var img1Name=base_path+img1;
var img2Name=base_path+img2;
var numTxt=tmplDiv.cloneNode(false);
numTxt.className='numTxt';
numTxt.style.display='inline-block';
numTxt.style.verticalAlign='top';
numTxt.style.marginTop='0rem';numTxt.style.marginLeft='0.4rem';
var hyphen=tmplDiv.cloneNode(false);
hyphen.className='hyphen';
hyphen.style.backgroundColor=colorSet[curColorIdx].text_onbase;
var img1=document.createElement('img');
img1.src=img1Name;
img1.style.width='3.6rem';
var img2=img1.cloneNode(false);
img2.src=img2Name;
tmpl=tmplDiv.cloneNode(false);
tmpl.className='fdp-num-help fdp-color-text-onbase';
tmpl.appendChild(img1);
tmpl.appendChild(hyphen);
tmpl.appendChild(img2);
tmpl.appendChild(numTxt);}
var ele=tmpl.cloneNode(true);
return ele;};
return func;}())
};
var NumHelpObj=UTIL.Class.create(
BaseObj,{
eleFunc:NumHelpElement,
__construct:function(arg){
if(arg.helpCtrlEnable==false){
this.helpCtrlEnable=false;}else {
this.helpCtrlEnable=true;}
this.ele=this.makeElement(arg);},
setTxt:function(txt){
this.ele.getElementsByClassName('numTxt')[0].innerHTML=txt;},
show:function(){
this.ele.classList.remove('hide');
this.ele.classList.add('show');},
hide:function(){
this.ele.classList.remove('show');
this.ele.classList.add('hide');},
updateNumHelp:function(obj){
if(this.helpCtrlEnable==false)
return;
switch(obj.type){
case 'input':
if(obj.disable==true){
this.hide();}else {
if(obj.numTxt!=null){
this.setTxt(obj.numTxt);}
this.show();}
break;
case 'access':
default:
this.hide();
break;}
}
}
);

var NumHelpKeyElement={
make:(function(){
var tmpl=null;
var func=function(arg){
if(tmpl===null){
var base_path='/usr/local/png/';var file='rem_multi_tap_digits.png';
if(arg.language){
file=FDP.KBD.mngLayouts.getLayout(arg.language).remGuide||file;}
var imgName=base_path+file;
var img=document.createElement('img');
img.src=imgName;
img.style.width='16rem';
tmpl=tmplDiv.cloneNode(false);
tmpl.className='fdp-numkey-help fdp-color-text-onbase';
tmpl.appendChild(img);}
var ele=tmpl.cloneNode(true);
return ele;};
return func;}())
};
var NumKeyHelpObj=UTIL.Class.create(
BaseObj,{
eleFunc:NumHelpKeyElement,
__construct:function(arg){
this.ele=this.makeElement(arg);},
show:function(){
this.ele.classList.remove('hide');
this.ele.classList.add('show');},
hide:function(){
this.ele.classList.remove('show');
this.ele.classList.add('hide');}
}
);

var InfoHelpElement={
make:(function(){
var tmpl=null;
var func=function(arg){
if(tmpl===null){
var base_path='/usr/local/png/';var img1='banner_icon_infoBtn.png';
var img1Name=base_path+img1;
var txt=tmplDiv.cloneNode(false);
txt.className='infoTxt';
var img1=document.createElement('img');
img1.src=img1Name;
img1.style.width='4rem';
tmpl=tmplDiv.cloneNode(false);
tmpl.className='fdp-info-help fdp-color-text-onbase';
tmpl.appendChild(img1);
tmpl.appendChild(txt);}
var ele=tmpl.cloneNode(true);
return ele;};
return func;}())
};
var InfoHelpObj=UTIL.Class.create(
BaseObj,{
eleFunc:InfoHelpElement,
__construct:function(arg){
this.ele=this.makeElement(arg);
if(arg.infoHelpArgs){
this.setTxt(arg.infoHelpArgs);}
},
setTxt:function(txt){
this.ele.getElementsByClassName('infoTxt')[0].innerHTML=txt;},
show:function(){
this.ele.classList.remove('hide');
this.ele.classList.add('show');},
hide:function(){
this.ele.classList.remove('show');
this.ele.classList.add('hide');},
updateInfoHelp:function(obj){
if(this.helpCtrlEnable==false)
return;
switch(obj.type){
case 'input':
if(obj.numTxt!=null){
this.setTxt(obj.numTxt);}
this.show();
break;
case 'access':
default:
this.hide();
break;}
}
}
);

var ChHelpElement={
make:(function(){
var tmpl=null;
var func=function(arg){
if(tmpl===null){
var base_path='/usr/local/png/m_widget3/';var img='rem_ch_up_dwn.png';
var imgName=base_path+img;
var chUpTxt=tmplDiv.cloneNode(false);
chUpTxt.className='chUpTxt';
chUpTxt.style.lineHeight='1.1';
chUpTxt.style.display='inline-block';
chUpTxt.style.textAlign='right';
var chDownTxt=tmplDiv.cloneNode(false);
chDownTxt.className='chDownTxt';
chDownTxt.style.lineHeight='1.1';
chDownTxt.style.textAlign='right';
var imgDom=document.createElement('img');
imgDom.src=imgName;
imgDom.style.width='2.2rem';

tmpl=tmplDiv.cloneNode(false);
tmpl.className='fdp-ch-help fdp-color-text-onbase';
var wrap=tmplDiv.cloneNode(false);
wrap.style.display='inline-block';
wrap.style.verticalAlign='top';wrap.appendChild(chUpTxt);
wrap.appendChild(chDownTxt);
tmpl.appendChild(wrap);
tmpl.appendChild(imgDom);}
var ele=tmpl.cloneNode(true);
return ele;};
return func;}())
};
var ChHelpObj=UTIL.Class.create(
BaseObj,{
eleFunc:ChHelpElement,
__construct:function(arg){
this.ele=this.makeElement(arg);
if(arg.upDownHelpArgs){
if(arg.upDownHelpArgs.chUpTextLst&&arg.upDownHelpArgs.chUpTextLst[0]){
this.setUpTxt(arg.upDownHelpArgs.chUpTextLst[0]);}
if(arg.upDownHelpArgs.chDownTextLst&&arg.upDownHelpArgs.chDownTextLst[0]){
this.setDownTxt(arg.upDownHelpArgs.chDownTextLst[0]);}
}
},
setUpTxt:function(txt){
this.ele.getElementsByClassName('chUpTxt')[0].innerHTML=txt;},
setDownTxt:function(txt){
this.ele.getElementsByClassName('chDownTxt')[0].innerHTML=txt;},
show:function(){
this.ele.classList.remove('hide');
this.ele.classList.add('show');},
hide:function(){
this.ele.classList.remove('show');
this.ele.classList.add('hide');}
}
);

var ColorHelpElement={
make:(function(){
var tmpl=null;
var func=function(arg){
if(tmpl===null){
var base_path='/usr/local/png/m_widget3/';var img1='rem_guide_red.png';
var img2='rem_guide_green.png';
var img3='rem_guide_yellow.png';
var img4='rem_guide_blue.png';
if(FDP.getGblValue('area')==='jp'){
img1='color_guide_blue_jp.png';
img2='color_guide_red_jp.png';
img3='color_guide_green_jp.png';
img4='color_guide_yellow_jp.png';}
var img1Name=base_path+img1;
var img2Name=base_path+img2;
var img3Name=base_path+img3;
var img4Name=base_path+img4;
var area1=tmplDiv.cloneNode(false);
area1.style.width='25%';
area1.style.display='inline-block';
area1.style.margin='0.4rem 0';
var txt1=tmplDiv.cloneNode(false);
txt1.className='cTxt1';
txt1.style.lineHeight='1.2';
txt1.style.verticalAlign='top';
txt1.style.display='inline-block';
txt1.innerHTML='TEXT1';
var area2=area1.cloneNode(false);
area2.style.width='25%';
area2.style.display='inline-block';
var txt2=txt1.cloneNode(false);
txt2.className='cTxt2';
txt2.innerHTML='TEXT2';
var area3=area1.cloneNode(false);
area3.style.width='25%';
area3.style.display='inline-block';
var txt3=txt1.cloneNode(false);
txt3.className='cTxt3';
txt3.innerHTML='TEXT3';
var area4=area1.cloneNode(false);
area4.style.width='25%';
area4.style.display='inline-block';
var txt4=txt1.cloneNode(false);
txt4.className='cTxt4';
txt4.innerHTML='TEXT4';
var imgDom=document.createElement('img');
imgDom.style.width='5rem';
imgDom.style.display='inline-block';
var imgDom1=imgDom.cloneNode(false);
imgDom1.src=img1Name;
var imgDom2=imgDom.cloneNode(false);
imgDom2.src=img2Name;
var imgDom3=imgDom.cloneNode(false);
imgDom3.src=img3Name;
var imgDom4=imgDom.cloneNode(false);
imgDom4.src=img4Name;
tmpl=tmplDiv.cloneNode(false);
tmpl.className='fdp-color-help fdp-color-text-onbase fdp-color-btn-border';
area1.appendChild(imgDom1);
area1.appendChild(txt1);
area2.appendChild(imgDom2);
area2.appendChild(txt2);
area3.appendChild(imgDom3);
area3.appendChild(txt3);
area4.appendChild(imgDom4);
area4.appendChild(txt4);
tmpl.appendChild(area1);
tmpl.appendChild(area2);
tmpl.appendChild(area3);
tmpl.appendChild(area4);}
var ele=tmpl.cloneNode(true);
return ele;};
return func;}())
};
var ColorHelpObj=UTIL.Class.create(
BaseObj,{
eleFunc:ColorHelpElement,
__construct:function(arg){
this.ele=this.makeElement(arg);
this.helpCtrlEnable=arg.helpCtrlEnable;
this.txt1='';
this.txt2='';
this.txt3='';
this.txt4='';
if(arg.colorHelpArgs){
if(arg.colorHelpArgs.rText)
this.txt1=arg.colorHelpArgs.rText;
if(arg.colorHelpArgs.gText)
this.txt2=arg.colorHelpArgs.gText;
if(arg.colorHelpArgs.yText)
this.txt3=arg.colorHelpArgs.yText;
if(arg.colorHelpArgs.bText)
this.txt4=arg.colorHelpArgs.bText;}
this.setTxt(this.txt1,this.txt2,this.txt3,this.txt4);},
setTxt:function(txt1,txt2,txt3,txt4){
if(txt1!=null){
this.txt1=txt1;
this.ele.getElementsByClassName('cTxt1')[0].innerHTML=txt1;}
if(txt2!=null){
this.txt2=txt2;
this.ele.getElementsByClassName('cTxt2')[0].innerHTML=txt2;}
if(txt3!=null){
this.txt3=txt3;
this.ele.getElementsByClassName('cTxt3')[0].innerHTML=txt3;}
if(txt4!=null){
this.txt4=txt4;
this.ele.getElementsByClassName('cTxt4')[0].innerHTML=txt4;}
},
helpColorOn:function(){
this.ele.getElementsByClassName('cTxt1')[0].innerHTML=this.txt1;
this.ele.getElementsByClassName('cTxt2')[0].innerHTML=this.txt2;
this.ele.getElementsByClassName('cTxt3')[0].innerHTML=this.txt3;
this.ele.getElementsByClassName('cTxt4')[0].innerHTML=this.txt4;},
helpColorOff:function(){
this.ele.getElementsByClassName('cTxt1')[0].innerHTML='';
this.ele.getElementsByClassName('cTxt2')[0].innerHTML='';
this.ele.getElementsByClassName('cTxt3')[0].innerHTML='';
this.ele.getElementsByClassName('cTxt4')[0].innerHTML='';},
updateColorHelp:function(obj){
if(this.helpCtrlEnable===false)
return;
switch(obj.type){
case 'input':
if(FDP.getGblValue('area')==='jp'){
this.setTxt('','','',LANG('LT_DEL_ONE_CHAR'));}else {
if(obj.disable==true){
this.helpColorOff();}else {
if(obj.id=='ClockSettingsTime'){
this.setTxt(LANG('LT_DELETE'),'AM/PM','',LANG('LT_DEL_ALL'));}else {
this.setTxt(LANG('LT_DELETE'),'','',LANG('LT_DEL_ALL'));}
}
}
break;
default:
this.helpColorOff();
break;}
}
}
);
var frameElement={
make:function(arg){
if(arg.fullscreen){
return this.makeFull();}else {
return this.makePop();}
},
makePop:(function(){
var tmpl=null;
var func=function(arg){
var ele,header,help,content;
if(tmpl===null){
tmpl=tmplDiv.cloneNode(false);
tmpl.className='fdp-frame fdp-font-normal popup fdp-pop-border fdp-pop-shadow';
header=tmplDiv.cloneNode(false);
header.className='header fdp-color-text-onbase fdp-color-pop-a fdp-color-border-onbase fdp-title-underline';
content=tmplDiv.cloneNode(false);
content.className='content';
help=tmplDiv.cloneNode(false);
help.className='help fdp-color-text-onbase fdp-color-pop-a fdp-color-border-onbase';
tmpl.appendChild(header);
tmpl.appendChild(content);
tmpl.appendChild(help);}
ele=tmpl.cloneNode(true);
return ele;};
return func;}()),
makeFull:(function(){
var tmpl=null;
var func=function(arg){
var ele,header,help,content;
if(tmpl===null){
tmpl=tmplDiv.cloneNode(false);
tmpl.className='fdp-frame fdp-font-normal full fdp-color-base-full';
header=tmplDiv.cloneNode(false);
header.className='header fdp-color-text-onbase fdp-color-border-onbase fdp-title-underline';
content=tmplDiv.cloneNode(false);
content.className='content';
help=tmplDiv.cloneNode(false);
help.className='help fdp-color-text-onbase fdp-color-pop-border fdp-help-upperline';
help.style.position='absolute';
help.style.bottom='0';
help.style.width='100%';
tmpl.appendChild(header);
tmpl.appendChild(content);
tmpl.appendChild(help);}
ele=tmpl.cloneNode(true);
return ele;};
return func;}()),
setTitle:function(ele,title){
ele.getElementsByClassName('header')[0].innerHTML=title;
return ele;},
getTitle:function(ele){
return ele.getElementsByClassName('header')[0].innerHTML;},
hideTitle:function(ele){
ele.getElementsByClassName('header')[0].style.display='none';},
setText:function(ele,path){
var obj=false;
var lineMax=13;
var lineNum;
obj=new XMLHttpRequest();
if(obj){
obj.open('get',path,false);
obj.setRequestHeader('Connection','close');
obj.send('');
if(obj.readyState==4&&obj.status==0){
var text=obj.responseText;
if(!text){
text=path+' : File load error';}
lineNum=text.match(/\n/g);
text=text.replace(/"/g,'\"');
text=text.replace(/</g,'&lt;');
text=text.replace(/>/g,'&gt;');
text=text.replace(/\n/g,'<br>');
text=text.replace(/\t/g,' ');}
}
return text;},
getContentEle:function(ele){
return ele.getElementsByClassName('content')[0];},
getHelpEle:function(ele){
return ele.getElementsByClassName('help')[0];}
};
var frameCommon={
__construct:function(arg){
this.id=arg.id;
this.myMap=arg.mapHook;
this.myUnmap=arg.unmapHook;
this.myFocus=arg.focusHook;
this.myUnfocus=arg.unfocusHook;
this.myKeyHook=arg.keyHook;
this.myMouseWheelHook=arg.mouseWheelHook;
this.myExclusive=arg.exclusiveHook;
this.myUseKey=arg.myUseKey||[];
if(arg.keyboard){
this.useKey=getReqKeyByFrameTypeForKeyboard(this.myUseKey);}else {
this.useKey=getReqKeyByFrameType(this.frametype,this.myUseKey);}
},
map:function(ev){
if(this.myMap)
return this.myMap(ev);
else
return false;},
unmap:function(ev){
if(this.myUnmap)
return this.myUnmap(ev);
else
return false;},
exclusive:function(ev){
if(this.myExclusive)
return this.myExclusive(ev);
else
return false;},
focus:function(ev){
if(this.myFocus)
return this.myFocus(ev);
else
return false;},
unfocus:function(ev){
if(this.myUnfocus)
return this.myUnfocus(ev);
else
return false;},
keyHook:function(ev){
if(this.myKeyHook)
return this.myKeyHook(ev);
else
return false;},
mouseWheel:function(ev){
if(this.myMouseWheelHook)
return this.myMouseWheelHook(ev);
else
return false;}
};
var BaseFrameObj=UTIL.Class.create(
BaseObj,{
__construct:function(arg){
this.ele=arg.ele;
this.frametype=arg.frametype||'no_type';
frameCommon.__construct.call(this,arg);}
});
UTIL.include2(frameCommon,BaseFrameObj);
var FrameObj=UTIL.Class.create(
BaseObj,{
eleFunc:frameElement,
__construct:function(arg){
this.__isShow=false;
this.firstShow=true;
this.destroyWithUnmap=(arg.destroyWithUnmap===undefined)?true:arg.destroyWithUnmap;
this.__onBlure();
this.ele=this.eleFunc.make(arg);
if(arg.withTitle===false)
this.eleFunc.hideTitle(this.ele);
this.frametype=arg.frametype||'menu';
if(arg.keyboard){if(FDP.KBD===undefined){
var keyboardPath='/usr/local/minidom/shared/js/keyboard/';
loadJS((keyboardPath+'keys.min.js'),true,null);
loadJS((keyboardPath+'layouts.min.js'),true,null);
}
arg.keyboard.eventHook=arg.eventHook;
arg.keyboard.language=arg.keyboard.language||'english';
arg.width=arg.width||'60%',
arg.height=arg.height||'70%',
arg.framePos=arg.framePos||'center';}
this.framePos=arg.framePos;
frameCommon.__construct.call(this,arg);
if(arg.width&&!arg.fullscreen){
this.ele.style.width=arg.width;
this.width=arg.width;}
this.fullscreen=arg.fullscreen;
this.showAnim=true;
this.setTitle(arg.title);
this.setKeyHook(arg.keyHook);
this.setMouseWheelHook(arg.mouseWheelHook);
this.__makeInfo2({info2:arg.info2,
fullscreen:arg.fullscreen});
this.__makeTextArea({textfile:arg.textfile,
x:arg.x,
y:arg.y,
width:arg.width,
height:arg.height,
useThaiFont:arg.useThaiFont,
textDirection:arg.textDirection,
scrollbar:arg.scrollbar,
fullscreen:arg.fullscreen});
this.__makeHelp({withCursorHelp:arg.withCursorHelp,
cursorHelpArgs:arg.cursorHelpArgs,
button:arg.button,
textfile:arg.textfile,
keyboard:arg.keyboard,
withNumericInputHelp:arg.withNumericInputHelp,
numHelpCtrlEnable:arg.numHelpCtrlEnable,
withNumericKeyHelp:arg.withNumericKeyHelp,
withInfoHelp:arg.withInfoHelp,
infoHelpArgs:arg.infoHelpArgs,
withUpDownHelp:arg.withUpDownHelp,
upDownHelpArgs:arg.upDownHelpArgs,
withColorHelp:arg.withColorHelp,
colorHelpArgs:arg.colorHelpArgs,
withLine:arg.withHelpLine});
this.__makeRowHead(arg.rowHead);
this.__makeKeyboard(arg.keyboard);
this.__makeButtonList({button:arg.button,
buttonAlign:arg.buttonAlign,
multiCols:arg.multiCols,
lastPos:arg.lastPos,
fullscreen:arg.fullscreen,
listScrollType:arg.listScrollType,
listParam:arg.listParam,
rowHead:arg.rowHead,
width:arg.width,
info2:arg.info2,
buttonWidth:arg.buttonWidth,
buttonStyle:arg.buttonStyle,
firstLine:arg.listFirstLine,
loop:arg.loop
});
this.__makeInfo({info:arg.info,
fullscreen:arg.fullscreen});
this.id=arg.id;
this.argEventHook=arg.eventHook;
if(arg.showAnim!=null){
this.showAnim=arg.showAnim;}
this.ele.style.opacity='0';},
__makeInfo:function(arg){
if(arg.info){
this.info=arg.info;
this.eleFunc.getContentEle(this.ele).appendChild(arg.info);
this.info.classList.add('fdp-info');
if(!arg.fullscreen){
this.info.classList.add('fdp-color-pop-a');}
}
},
__makeInfo2:function(arg){
if(arg.info2){
this.info2=arg.info2;
this.eleFunc.getContentEle(this.ele).appendChild(arg.info2);
this.info2.classList.add('fdp-info2');
if(!arg.fullscreen){
this.info2.classList.add('fdp-color-pop-a');}
}
},
__makeTextArea:function(arg){
if(arg.textfile){
this.withTextArea=true;
this.useThaiFont=arg.useThaiFont;
if(this.withTextArea){
this.textArea=new FDP.UI.TextAreaObj({
x:arg.x,
y:arg.y,
width:arg.width,
height:arg.height,
useThaiFont:arg.useThaiFont,
scrollbar:arg.scrollbar,
textDirection:arg.textDirection,
textfile:arg.textfile,
fullscreen:arg.fullscreen
});
this.eleFunc.getContentEle(this.ele).appendChild(this.textArea.ele);}
}
},
__makeHelp:function(arg){
if(arg.keyboard){arg.cursorHelpArgs=arg.cursorHelpArgs||{
curUpTextLst:[LANG('LT_SELECT')],
enterTextLst:[LANG('LT_SET_CHARACTER')],
curRightTextLst:[LANG('LT_SELECT')],
returnTextLst:[LANG('LT_OK')]
};
if(FDP.getGblValue('area')!='jp'){arg.withNumericKeyHelp=arg.withNumericKeyHelp===undefined?
{lang:arg.keyboard.language}:arg.withNumericKeyHelp;}
arg.withColorHelp=arg.withColorHelp===undefined?true:arg.withColorHelp;
arg.colorHelpArgs=arg.colorHelpArgs||
((FDP.getGblValue('area')==='jp')?
{bText:LANG('LT_DEL_ONE_CHAR')}:
{rText:LANG('LT_DELETE'),bText:LANG('LT_DEL_ALL')});
}
if(arg.withCursorHelp!=false&&(arg.withCursorHelp||arg.cursorHelpArgs||arg.button||arg.textfile))
this.withCursorHelp=true;
if(this.withCursorHelp){
this.cursorHelp=new FDP.UI.CursorHelpObj({
cursorHelpArgs:arg.cursorHelpArgs,
button:arg.button,textArea:arg.textfile});
this.eleFunc.getHelpEle(this.ele).appendChild(this.cursorHelp.ele);}
if(arg.withNumericInputHelp){
this.numHelp=new FDP.UI.NumHelpObj({
helpCtrlEnable:arg.numHelpCtrlEnable
});
this.eleFunc.getHelpEle(this.ele).appendChild(this.numHelp.ele);}
if(arg.withNumericKeyHelp){
this.numKeyHelp=new FDP.UI.NumKeyHelpObj({
language:arg.withNumericKeyHelp.language
});
this.eleFunc.getHelpEle(this.ele).appendChild(this.numKeyHelp.ele);}
if(arg.withInfoHelp||arg.infoHelpArgs){
this.infoHelp=new FDP.UI.InfoHelpObj({
infoHelpArgs:arg.infoHelpArgs
});
this.eleFunc.getHelpEle(this.ele).appendChild(this.infoHelp.ele);}
if(arg.withUpDownHelp){
this.chHelp=new FDP.UI.ChHelpObj({
upDownHelpArgs:arg.upDownHelpArgs
});
this.eleFunc.getHelpEle(this.ele).appendChild(this.chHelp.ele);}
if(arg.withLine!==false){
if(this.withCursorHelp||arg.withNumericInputHelp||arg.withUpDownHelp){
if(!arg.button&&!arg.textfile&&!arg.keyboard){
this.eleFunc.getHelpEle(this.ele).classList.add('fdp-help-upperline');}
}
}
if(arg.withColorHelp){
if(arg.colorHelpArgs){
this.colorHelpCtrlEnable=false;}else {
this.colorHelpCtrlEnable=true;}
this.colorHelp=new FDP.UI.ColorHelpObj({
colorHelpArgs:arg.colorHelpArgs,
helpCtrlEnable:this.colorHelpCtrlEnable
});
this.eleFunc.getHelpEle(this.ele).appendChild(this.colorHelp.ele);}
},
__makeRowHead:function(rowHead){
if(rowHead){
var rowHeadWrap=tmplDiv.cloneNode(false);
this.rowHead=new RowObj(rowHead);
this.rowHead.ele.classList.add('fdp-color-widget-sub');
rowHeadWrap.style.paddingTop='2rem';
rowHeadWrap.classList.add('fdp-color-pop-a');
rowHeadWrap.appendChild(this.rowHead.ele);
this.eleFunc.getContentEle(this.ele).appendChild(rowHeadWrap);}
},
__makeKeyboard:function(keyboard){
if(keyboard){
var frag;
var keyboardWrap=tmplDiv.cloneNode(false);
keyboard.title=keyboard.title||LANG('LT_CH_NAME');
this.keyboard=new KeyboardObj(keyboard);
keyboardWrap.classList.add('fdp-color-pop-a');
keyboardWrap.appendChild(this.keyboard.ele);
this.eleFunc.getContentEle(this.ele).appendChild(keyboardWrap);}
},
__makeButtonList:function(arg){
var makeParam;
if(arg.button){
if(arg.multiCols){
this.multiCols=arg.multiCols;
this.buttonList=new FDP.UI.MultiColsObj({
focusIdx:arg.lastPos===false?false:arg.lastPos||0,
list:arg.button,
loop:arg.loop,
cursorHelpObj:this.cursorHelp,
numHelpObj:this.numHelp,
colorHelpObj:this.colorHelp,
eventHook:this.eventHook.bind(this)
});
if(!arg.fullscreen&&!arg.info2)
this.buttonList.ele.style.paddingTop='4rem';
if(!arg.fullscreen){
this.buttonList.ele.classList.add('fdp-color-pop-a');}
}else {
makeParam={
focusIdx:arg.lastPos===false?false:arg.lastPos||0,
list:arg.button,
loop:arg.loop,
cursorHelpObj:this.cursorHelp,
numHelpObj:this.numHelp,
colorHelpObj:this.colorHelp,
eventHook:this.eventHook.bind(this),
firstLine:(arg.firstLine===false)?false:((arg.info2||arg.fullscreen)?true:false),
scrollType:arg.listScrollType,
listParam:arg.listParam
};
if(arg.listScrollType==='eco'){
}else {
this.buttonList=new FDP.UI.List(makeParam);}
var maxBtnNum=10;
if(arg.rowHead){
maxBtnNum--;}
if(arg.listParam&&arg.listParam.maxBtnNum)
maxBtnNum=arg.listParam.maxBtnNum;
this.buttonList.ele.style.maxHeight=7.1*maxBtnNum+'rem';}
if(arg.fullscreen){
this.buttonList.ele.classList.add('fdp-full-list');
switch(arg.buttonAlign){
case 'left':
case 'right':
case 'center':
case 'start':
case 'end':
this.buttonList.ele.classList.add(arg.buttonAlign);
break;
default:
this.buttonList.ele.classList.add('center');
break;}
}
if(arg.buttonWidth){
this.buttonList.ele.style.width=arg.buttonWidth;
this.buttonWidth=arg.buttonWidth;}else {
if(arg.fullscreen){
}
else {
if(arg.width){
if(arg.multiCols)
this.buttonList.ele.style.width='-webkit-calc('+arg.width+' - 8rem)';
else
this.buttonList.ele.style.width=arg.width;}else {
this.buttonList.ele.style.width='96rem';}
}
}
if(arg.buttonStyle){
copyProp(arg.buttonStyle,this.buttonList.ele.style);}
this.eleFunc.getContentEle(this.ele).appendChild(this.buttonList.ele);
if(arg.width)this.ele.width=arg.width;}
},
getContentEle:function(){
return this.eleFunc.getContentEle(this.ele);},
draw:function(){
var maxWidth=0;
if(this.cursorHelp){
this.cursorHelp.setCursorHelpLayout();}
if(this.fullscreen)
return this;
if(this.buttonList){
if(!this.width){
if(this.multiCols){
if(this.buttonWidth){
maxWidth=this.buttonList.ele.offsetWidth;}else {
maxWidth=this.buttonList.getWidth();}
}else {
maxWidth=this.buttonList.ele.offsetWidth;}
if(this.withTextArea){
maxWidth=Math.max(this.textArea.ele.offsetWidth,maxWidth);
if(this.multiCols){
this.buttonList.ele.style.width='-webkit-calc('+maxWidth+'px - 8rem)';}else {
this.buttonList.ele.style.width=maxWidth+'px';}
}
this.ele.style.width=maxWidth+'px';}
}else {
try{
if(!this.fullscreen&&!this.ele.style.width)
this.ele.style.width='96rem';}catch(e){
this.ele.style.width='96rem';}
}
if(this.info2){
this.info2.style.maxWidth=this.ele.offsetWidth+'px';}
if(this.keyboard){
FDP.KBD.keys.setKeysWidth(this.keyboard.ele,this.ele.offsetWidth);}
return this;},
map:function(ev){
frameCommon.map.call(this,ev);
this.draw();
this.show();},
unmap:function(ev){
var self=this;
this.__isShow=false;
if(this.keyboard){
ev=ev||{};
ev.obj=this.keyboard;
ev.value=this.keyboard.getValue();}
this.unfocus({},false);
frameCommon.unmap.call(this,ev);
this.animFadeOut(function(){
self.ele.parentNode.removeChild(self.ele);
self.destroy();});},
getTitle:function(){
return this.title;},
setTitle:function(title){
if(title){
this.title=title;
this.eleFunc.setTitle(this.ele,title);}
},
setListItemLength:function(length){
if(this.buttonList.setItemLength)
this.buttonList.setItemLength(length);},
setListItems:function(items,redraw){
if(this.buttonList.setItems)
this.buttonList.setItems(items,redraw);},
destroy:function(){
if(this.destroyWithUnmap){
if(this.buttonList)
this.buttonList.destroy();}
},
doFocusAnim:function(type){
if(type==='fadein'){
this.fadein();}else if(type==='slidein'){
this.animSlide();}else {
this.fadein();}
},
doUnfocusAnim:function(type){
if(type==='fadeout'){
this.fadeout();}else {
this.fadeout();}
},
fadein:function(){
if(!this.__firstAnim)
return;
this.animFadeIn();},
fadeout:function(){
this.animFadeOut();},
focusContent:function(ev){
if(!this.__isShow)
return;
if(this.buttonList){
this.buttonList.focus(ev);}else if(this.keyboard){
this.keyboard.focus();}
},
focus:function(ev){
this.__onFocus();
frameCommon.focus.call(this,ev);
this.focusContent(ev);},
unfocusContent:function(ev){
if(this.buttonList){
this.buttonList.unfocus();}
if(this.keyboard){
this.keyboard.unfocus();}
},
unfocus:function(ev,callHook){
this.__onBlure();
this.unfocusContent();
if(callHook!==false)
frameCommon.unfocus.call(this,ev);},
animFadeOut:function(callback){
var self=this;
this.__isShow=false;
this.ele.classList.remove('fade-in');
this.ele.classList.add('fade-out');
transitionCallback.add(this.ele,function(ev,__callback){
transitionCallback.remove(ev.target,__callback);
if(callback)
callback();});},
animFadeIn:function(callback){
var self=this;
this.ele.classList.remove('fade-out');
this.ele.classList.add('fade-in');
transitionCallback.add(this.ele,function(ev,__callback){
ev.target.classList.remove('fade-in');
transitionCallback.remove(ev.target,__callback);
self.__isShow=true;
self.focusContent();
if(callback)
callback();});},
__setFramePos:function(){
var setCenter=function(ele){
ele.style.left=Math.floor(window.outerWidth/ 2 - ele.offsetWidth /2)+'px';
ele.style.top=Math.floor(window.outerHeight/ 2 - ele.offsetHeight /2)+'px';};
var setLeft=function(ele){
ele.classList.add('normal-margin');
ele.style.left='0';};
var setRight=function(ele){
ele.classList.add('normal-margin');
ele.style.right='0';
};
var setStart=function(ele){
ele.classList.add('normal-margin');};
var setEnd=function(ele){
ele.classList.add('normal-margin');
if(isLtr()){
ele.style.right='0';}else {
ele.style.left='0';}
};
var setTop=function(ele){
ele.style.top='5rem';};
var setBottom=function(ele){
ele.style.bottom='7.1rem';};
if(this.fullscreen)
return this;
if(this.framePos){
switch(this.framePos){
case 'myself':
break;
case 'center':
setCenter(this.ele);
break;
case 'left-top':
setLeft(this.ele);
setTop(this.ele);
break;
case 'left-bottom':
setLeft(this.ele);
setBottom(this.ele);
break;
case 'start-top':
setStart(this.ele);
setTop(this.ele);
break;
case 'start-bottom':
setStart(this.ele);
setBottom(this.ele);
break;
case 'right-top':
setRight(this.ele);
setTop(this.ele);
break;
case 'right-bottom':
setRight(this.ele);
setBottom(this.ele);
break;
case 'end-top':
setEnd(this.ele);
setTop(this.ele);
break;
case 'end-bottom':
setEnd(this.ele);
setBottom(this.ele);
break;}
}else {
if(this.frametype==='menu'){
setStart(this.ele);
setBottom(this.ele);}else if(this.frametype==='errpnl'){
setCenter(this.ele);}
}
return this;},
animSlide:function(){
var offset;
var transform;
this.ele.classList.remove('fade-in');
this.ele.classList.remove('fade-out');
this.ele.dataset.oleft=this.ele.offsetLeft;
if(this.fullscreen){
if(getDirection()=='ltr')
offset=(window.innerWidth-this.ele.offsetLeft)+'px';
else
offset=-this.ele.offsetLeft+'px';
transform='translateX('+offset+')';}else {
this.ele.classList.add('fast');
if(this.framePos==='center'||this.frametype==='errpnl'){
transform='translateY(30rem)';}else {
if(getDirection()=='ltr')
offset=10+'rem';
else
offset=-10+'rem';
transform='translateX('+offset+')';}
}
this.ele.style.webkitTransform=transform;
setTimeout(this.animSlideStart.bind(this),0);},
animSlideStart:function(){
var self=this;
this.ele.classList.add('move');
transitionCallback.add(this.ele,function(ev,callback){
self.ele.classList.remove('move');
self.ele.classList.remove('fast');
transitionCallback.remove(ev.target,callback);
self.ele.style.webkitTransform='';
self.ele.style.opacity='1';
self.__isShow=true;
self.__firstAnim=true;
self.focusContent();});
if(!hasClass(self.ele,'fast'))
self.ele.style.opacity='1';
self.ele.style.webkitTransform='translateX(0px)';},
show:function(){
if(this.firstShow){
this.__setFramePos();
this.animSlide();
this.firstShow=false;}else {
this.animFadeIn();}
},
setMouseWheelHook:function(hook){
this.mouseWheel=hook||this.defaultMouseWheelHook;},
setKeyHook:function(hook){
if(this.withTextArea){
this.keyHook=hook||this.scrollKeyHook;}else {
this.keyHook=hook||this.defaultKeyHook;}
},
scrollKeyHook:function(ev){
var fSize;
var lHeight;
if(FDP.getLanguage()=='th'&&this.useThaiFont==true){
lHeight=2.0;}else {
lHeight=1.4;}
fSize=Math.floor(parseInt(String(getComputedStyle(this.textArea.ele,'').fontSize))*lHeight);
if(ev.type==='keydown'){
switch(ev.keyCode){
case keyDef.UP:
this.textArea.child.scrollTop=this.textArea.child.scrollTop-fSize;
break;
case keyDef.DOWN:
this.textArea.child.scrollTop=this.textArea.child.scrollTop+fSize;
break;
case keyDef.CH_UP:
this.textArea.child.scrollTop=this.textArea.child.scrollTop-(fSize*10);
break;
case keyDef.CH_DOWN:
this.textArea.child.scrollTop=this.textArea.child.scrollTop+(fSize*10);
break;
case keyDef.RETURN:
FRAMES.unmap(this);
break;}
}
return true;},
keyHook:null,
defaultMouseWheelHook:function(ev){
return false;},
defaultKeyHook:function(ev){
var ret=false;
if(!this.isFocus)
return false;
if(this.buttonList){
ret=this.buttonList.keyHook(ev);}
if(this.keyboard){
ret=this.keyboard.keyHook(ev);}
if(!ret){
if((ev.type==='keydown')&&(ev.keyCode===keyDef.RETURN)){
FRAMES.unmap(this);
return true;}
}
if(!ret&&(ev.type==='keydown')){
if(this.useKey.indexOf(ev.keyCode)>=0){
ret=true;}
}
return ret;
},
eventHook:function(ev){
if(this.argEventHook)
this.argEventHook(ev);},
getFocusBtnObj:function(){
if(this.buttonList){
return this.buttonList.getFocusObj();}else {
return null;}
},
getBtnObjByFocusIdx:function(idx){
if(this.buttonList){
return this.buttonList.getBtnObjByFocusIdx(idx);}else {
return null;}
},
getBtnObjById:function(id){
if(this.buttonList){
return this.buttonList.getBtnObjById(id);}else {
return null;}
},
setTextAreaLines:function(lines){
if(this.withTextArea){
var fSize;
var lHeight;
if(FDP.getLanguage()=='th'&&this.useThaiFont==true){
lHeight=2.0;
lines=lines/2;}else {
lHeight=1.4;}
fSize=Math.floor(parseInt(String(getComputedStyle(this.textArea.ele,'').fontSize))*lHeight);
this.textArea.child.style.height=lines*fSize+'px';}
}
});
UTIL.include2(frameCommon,FrameObj);
var transitionCallback={
list:[],
isMoving:function(ele){
var evObj=getArrayObj(this.list,
function(obj){
return obj.ele==ele?true:false;});
if(evObj)
return evObj.isMoving;
else
return false;},
onstart:function(ev){
var evObj=getArrayObj(this.list,
function(obj){
return obj.ele==ev.target?true:false;});
if(evObj){
evObj.isMoving=true;}
},
onend:function(ev){
var i;
var evObj=getArrayObj(this.list,
function(obj){
return obj.ele==ev.target?true:false;});
if(evObj){
evObj.isMoving=false;
var calls=[];
for(i in evObj.hooks){
calls.push(evObj.hooks[i]);}
for(i in calls){
calls[i].call(ev.target,ev,calls[i]);}
}
},
add:function(ele,callback){
var evObj=getArrayObj(this.list,
function(obj){
return obj.ele===ele?true:false;});
if(evObj===null){
if(!this.startHook)
this.startHook=this.onstart.bind(this);
if(!this.endHook)
this.endHook=this.onend.bind(this);
ele.addEventListener('animationstart',this.startHook);
ele.addEventListener('animationend',this.endHook);
ele.addEventListener('webkitAnimationStart',this.startHook);
ele.addEventListener('webkitAnimationEnd',this.endHook);
ele.addEventListener('transitionstart',this.startHook);
ele.addEventListener('transitionend',this.endHook);
ele.addEventListener('webkitTransitionStart',this.startHook);
ele.addEventListener('webkitTransitionEnd',this.endHook);
this.list.push({
ele:ele,
hooks:[callback],
isMoving:true
});}else {
evObj.isMoving=true;
if(evObj.hooks.indexOf(callback)===-1){
evObj.hooks.push(callback);}
}
return ele;},
remove:function(ele,callback){
var pos;
var evObj=getArrayObj(this.list,
function(obj){
return obj.ele===ele?true:false;});
if(evObj){
pos=evObj.hooks.indexOf(callback);
if(pos>-1){
evObj.hooks.splice(pos,1);}
if(evObj.hooks.length===0){
ele.removeEventListener('animationstart',this.startHook);
ele.removeEventListener('animationend',this.endHook);
ele.removeEventListener('webkitAnimationStart',this.startHook);
ele.removeEventListener('webkitAnimationEnd',this.endHook);
ele.removeEventListener('transitionstart',this.startHook);
ele.removeEventListener('transitionend',this.endHook);
ele.removeEventListener('webkitTransitionStart',this.startHook);
ele.removeEventListener('webkitTransitionEnd',this.endHook);
pos=this.list.indexOf(evObj);
this.list.splice(pos,1);}
}
return ele;}
};
function getTransformValue(transform){
return transform.match(/\-?[0-9]*px/gi);};
var getTransValue=function(styleText){
var value;
value=getTransformValue(styleText);
if(value){
return value[0];}else {
return '0px';}
};
function setElementRect(obj,rect){
if(obj.style.top===rect.top+'px'&&
obj.style.left===rect.left+'px'&&
obj.style.width===rect.width+'px'&&
obj.style.height===rect.height+'px'){
return false;}
copyProp({
top:rect.top+'px',
left:rect.left+'px',
width:rect.width+'px',
height:rect.height+'px'
},obj.style);
return obj;}
function setElementRectTransform(obj,rect){
var style=obj.style;
var transform=obj.style.webkitTransform;
var prop;
var left='',top='';
if(transform){
prop=transform.match(/[0-9]*px/gi);
left=prop[0];
top=prop[1];
}
if(top===rect.top+'px'&&
left===rect.left+'px'&&
style.width===rect.width+'px'&&
style.height===rect.height+'px'){
return false;}
style.webkitTransform='translate('+rect.left+'px,'+rect.top+'px)';
if(style.width!==rect.width+'px')
style.width=rect.width+'px';
if(style.height!==rect.height+'px')
style.height=rect.height+'px';
return obj;}
function getElementRect(obj){
var r=obj.getBoundingClientRect();
var x=r.left+'px';
var y=r.top+'px';
var w=r.width+'px';
var h=r.height+'px';
return {
'top':y,
'left':x,
'width':w,
'height':h
};}
function getFocusEle(focusEle,id){
if(!focusEle){
id=id||'#FocusBar';
focusEle=document.getElementById(id);}
return focusEle;}
function testCall2(ev){
console.log('testcall2');
transitionCallback.remove(ev.target,testCall2);}
function testCall(ev){
console.log('testcall');}
function hasClass(el,c){
return el.classList.contains(c);}
function _hideFocus(focusEle,id){
focusEle=getFocusEle(focusEle,id);
focusEle.classList.remove('show');
focusEle.classList.remove('show-noanim');
focusEle.classList.add('hide');}
function _isFocusHide(focusEle){
return hasClass(focusEle,'hide');}
function _showFocus(target,callback,focusEle,id){
focusEle=getFocusEle(focusEle,id);
var rect=target.getBoundingClientRect();
focusEle.classList.remove('hide');
if(FDP.anim)
focusEle.classList.add('show');
else
focusEle.classList.add('show-noanim');
setElementRectTransform(focusEle,rect);
focusEle.dataset.targettop=rect.top;}
function _moveFocus(target,rect,callback,focusEle,id,anim){
var frect,isSet;
if(FDP.anim===false)
anim=false;
focusEle=getFocusEle(focusEle,id);
frect=focusEle.getBoundingClientRect();
rect=rect||target.getBoundingClientRect();

if(anim){
focusEle.classList.add('move');}else {
focusEle.classList.remove('move');}
focusEle.dataset.targettop=rect.top;
isSet=setElementRectTransform(focusEle,rect);
if(isSet&&!isFocusHide(focusEle)&&anim){
if(callback){
transitionCallback.add(focusEle,callback);}else {
transitionCallback.add(focusEle,function(ev,callback){
transitionCallback.remove(ev.target,callback);});}
}else {
if(callback){
callback({
target:focusEle
},callback);}
}
}
if(system.effect){
sysFocus=system.effect.focus_ring;}
var system_focus_param={rect:{top:0,left:0,width:0,height:0},
offsetLeft:0,
isShow:false,
isMove:false,
focusEle:undefined};
function isSystemFocusMoving(focusEle){
if(focusEle){
if(system_focus_param.focusEle){
if(focusEle===system_focus_param.focusEle)
return true;
else
return false;}
}else {
return system_focus_param.isMove;}
return false;}
function setSystemFocusOffset(left){
system_focus_param.offsetLeft=left;}
function setSystemFocusRect(rect){
if(!rect)
return;
var sysrect=system_focus_param.rect;
sysrect.top=rect.top;
sysrect.left=rect.left;
sysrect.width=rect.width;
sysrect.height=rect.height;}
function hideSystemFocus(focusEle,callback,id){
system_focus_param.isShow=false;
sysFocus.hide(0);}
function hideSystemFocusForce(focusEle,callback,id){
system_focus_param.isMove=false;
system_focus_param.focusEle=undefined;
hideSystemFocus(focusEle,callback,id);}
function isSystemFocusHide(focusEle){
return !system_focus_param.isShow;}
function showSystemFocus(target,callback,focusEle,id,drawSync){
var trect,rect={};
if(target){
trect=target.getBoundingClientRect();
copyProp(trect,rect);
rect.left+=system_focus_param.offsetLeft;}else {
rect=system_focus_param.rect;}
system_focus_param.isShow=true;
if(drawSync){
sysFocus.show(rect.left,Math.floor(rect.top),rect.width,rect.height,300,true);}else {
sysFocus.show(rect.left,Math.floor(rect.top),rect.width,rect.height,300);}
setSystemFocusRect(rect);
focusEle.dataset.targettop=rect.top;}
function moveSystemFocus(target,arect,callback,focusEle,id,anim){
var frect,isSet,trect,rect={};
if(FDP.anim===false)
anim=false;
trect=arect||target.getBoundingClientRect();
copyProp(trect,rect);
rect.left+=system_focus_param.offsetLeft;
focusEle.dataset.targettop=rect.top;
if(anim){
sysFocus.move(rect.left,Math.floor(rect.top),rect.width,rect.height,300);}else {
sysFocus.move(rect.left,Math.floor(rect.top),rect.width,rect.height,0);}
setSystemFocusRect(rect);
if(anim){
system_focus_param.isMove=true;
system_focus_param.focusEle=focusEle;
system_focus_param.callback=function(){
if(callback)
callback(focusEle,callback);};}else {
system_focus_param.isMove=false;
system_focus_param.focusEle=undefined;
if(callback)
callback(focusEle,callback);}
}
var hideFocus;
var isFocusHide;
var showFocus;
var moveFocus;
if(sysFocus){
hideFocus=hideSystemFocus;
isFocusHide=isSystemFocusHide;
showFocus=showSystemFocus;
moveFocus=moveSystemFocus;
sysFocus.onended=function(){
system_focus_param.isMove=false;
system_focus_param.focusEle=undefined;
var callback=system_focus_param.callback;
if(callback){
callback();
system_focus_param.callback=undefined;}
};}else {
hideFocus=_hideFocus;
isFocusHide=_isFocusHide;
showFocus=_showFocus;
moveFocus=_moveFocus;}
var FRAMES={
list:[],
delList:[],
delList2:[],
tmpList:[],
lastFocusObj:null,
keyLoop:false,
getFrameObjById:function(id){
var i;
for(i=0;i<this.list.length;i++){
if(this.list[i]&&this.list[i].id===id)
return this.list[i];}
for(i=0;i<this.tmpList.length;i++){
if(this.tmpList[i].id===id)
return this.tmpList[i];}
return null;},
updateKeyRequest:function(){
var i,j;
var mergeList=[];
if(window.keyRequest===undefined)
window.keyRequest=false;
if(this.keyStatus===undefined)
this.keyStatus=true;
for(i=0;i<this.list.length;i++){
if(this.list[i]===null)
continue;
if(mergeList.length){
var tmpUseKey=this.list[i].useKey;
for(j=0;j<tmpUseKey.length;j++){
if(mergeList.indexOf(tmpUseKey[j])===-1)
mergeList.push(tmpUseKey[j]);}
}else {
var tmpUseKey=this.list[i].useKey;
for(j=0;j<tmpUseKey.length;j++){
mergeList.push(tmpUseKey[j]);}
}
}
try{
if(mergeList.length&&this.keyStatus){
system.event.requestKeyEvents.apply(null,mergeList);
if(window.keyRequest===false){
window.keyRequest=true;
if(window.parent.document.body.id=='local2'){
window.parent.MDM.updateFramesWin2(window.frameElement.parentNode.id);}else {
window.parent.MDM.updateFrames();}
}
}else {
system.event.requestKeyEvents();
if(window.keyRequest===true){
window.keyRequest=false;
if(window.parent.document.body.id=='local2'){
window.parent.MDM.updateFramesWin2(window.frameElement.parentNode.id);}else {
window.parent.MDM.updateFrames();}
}
}
}catch(e){
}
},
updateWheelRequest:function(){
var i;
var wheelReq=false;
if(window.wheelRequest===undefined)
window.wheelRequest=false;
for(i=0;i<this.list.length;i++){
if(this.list[i]&&this.list[i].wheelRequest){
wheelReq=true;
break;}
}
if(wheelReq){
if(!window.wheelRequest){
window.wheelRequest=true;
window.parent.MDM.updateWheelRequest();}
}else {
if(window.wheelRequest){
window.wheelRequest=false;
window.parent.MDM.updateWheelRequest();}
}
},
requestWheelEvent:function(frameObj,val){
frameObj.wheelRequest=val;
this.updateWheelRequest();},
listPush:function(obj){
this.list.push(obj);
this.updateKeyRequest();
this.updateWheelRequest();},
listPop:function(obj){
this.list.pop(obj);
this.updateKeyRequest();
this.updateWheelRequest();},
listShift:function(obj){
this.list.shift(obj);
this.updateKeyRequest();
this.updateWheelRequest();},
listUnshift:function(obj){
this.list.unshift(obj);
this.updateKeyRequest();
this.updateWheelRequest();},
listSplice:function(pos,n){
this.list.splice(pos,n);
this.updateKeyRequest();
this.updateWheelRequest();},
isMapped:function(frameObj){
if(this.list.indexOf(frameObj)!==-1)
return true;
if(this.tmpList.indexOf(frameObj)!==-1)
return true;
return false;},
map:function(frameObj,parent,append){
if(this.keyLoop){
this.tmpList.push(frameObj);}else {
this.listUnshift(frameObj);}
if(append===undefined)
append=true;
if(parent&&append&&frameObj.ele){
if(typeof(parent)==='string'){
frameObj.parent_name=parent;
document.getElementById(parent).appendChild(frameObj.ele);}else {
parent.appendChild(frameObj.ele);}
}
if(this.lastFocusObj)
this.lastFocusObj.unfocus();
frameObj.map();
frameObj.focus();
this.lastFocusObj=frameObj;},
unmap:function(frameObj,remove){
var pos;
if(remove===undefined)
remove=true;
pos=this.list.indexOf(frameObj);
if(this.keyLoop){
if(pos!==-1){
this.list[pos]=null;}
this.removeObj(frameObj,remove);}else {
if(pos!==-1){
this.listSplice(pos,1);}
this.removeObj(frameObj,remove);
if(this.list.length&&this.list[0]){
this.list[0].focus();
this.lastFocusObj=this.list[0];}else {
this.lastFocusObj=null;}
}
},
setKeyStatus:function(keyStatus){this.keyStatus=keyStatus;
this.updateKeyRequest();},
addUseKey:function(frameObj,keyCode){
if(frameObj.useKey.indexOf(keyCode)===-1){
frameObj.useKey.push(keyCode);}
this.updateKeyRequest();},
delUseKey:function(frameObj,keyCode){
if(frameObj.useKey.indexOf(keyCode)!==-1){
var tmpUseKey=[];
var numUseKey=frameObj.useKey.length;
for(var i=0;i<numUseKey;i++){
if(frameObj.useKey[i]!==keyCode){
tmpUseKey.push(frameObj.useKey[i]);}
}
for(var i=0;i<numUseKey;i++){
frameObj.useKey.shift();}
for(var i=0;i<tmpUseKey.length;i++){
frameObj.useKey.push(tmpUseKey[i]);}
this.updateKeyRequest();}
},
exclusive:function(ev){
var i;
for(i=0;i<this.list.length;i++){
if(this.list[i])
this.tmpList.push(this.list[i]);}
for(i=0;i<this.tmpList.length;i++){
if(!this.tmpList[i].exclusive(ev)&&((this.tmpList[i].frametype==='menu')||(this.tmpList[i].frametype==='errpnl')))
FRAMES.unmap(this.tmpList[i]);}
this.tmpList.length=0;},
removeObj:function(frameObj,remove){if(frameObj&&frameObj!==undefined)
frameObj.unmap();
},
sendKey:function(ev){
var ret=false;
var pos;
var top=false;
var skipPrevent=false;
this.keyLoop=true;
var convert_conpane_ev=function(frameObj,ev){
if(frameObj.frametype==='menu'){
switch(ev.keyCode){
case keyDef.F_CH_UP:
if(frameObj.myUseKey.indexOf(keyDef.F_CH_UP)===-1)
return window.parent.MDM.createKey(ev.type,keyDef.UP);
break;
case keyDef.F_CH_DOWN:
if(frameObj.myUseKey.indexOf(keyDef.F_CH_DOWN)===-1)
return window.parent.MDM.createKey(ev.type,keyDef.DOWN);
break;
case keyDef.F_VOLUP:
if(frameObj.myUseKey.indexOf(keyDef.F_VOLUP)===-1)
return window.parent.MDM.createKey(ev.type,keyDef.RIGHT);
break;
case keyDef.F_VOLDOWN:
if(frameObj.myUseKey.indexOf(keyDef.F_VOLDOWN)===-1)
return window.parent.MDM.createKey(ev.type,keyDef.LEFT);
break;
case keyDef.F_CHG_INPUT:
if(frameObj.myUseKey.indexOf(keyDef.F_CHG_INPUT)===-1)
return window.parent.MDM.createKey(ev.type,keyDef.ENTER);
break;
default:break;}
}
return ev;};
for(var i=0;i<this.list.length;i++){
if(this.list[i]===null)
continue;
if(this.list[i].keyboard){
if(ev.type==='keydown')
skipPrevent=true;
ret=this.list[i].keyHook(convert_conpane_ev(this.list[i],ev));}else {
if(ev.type!=='keypress')
ret=this.list[i].keyHook(convert_conpane_ev(this.list[i],ev));}
if(ret)
break;}
this.keyLoop=false;
for(i=0;i<this.tmpList.length;i++){
this.listUnshift(this.tmpList[i]);}
this.tmpList.length=0;
for(i=(this.list.length-1);i>=0;i--){
if(this.list[i]===null)
this.listSplice(i,1);}
if(this.list.length){
top=this.list[0];
if(this.lastFocusObj!==top){
this.lastFocusObj=top;
this.lastFocusObj.focus();}
}else {
this.lastFocusObj=null;}
if(ev.stopPropagation)
ev.stopPropagation();
if(!skipPrevent){
if(ev.preventDefault)
ev.preventDefault();}
return ret;},
mouseWheel:function(ev){
var ret=false;
for(var i=0;i<this.list.length;i++){
if(this.list[i]&&this.list[i].mouseWheel)
ret=this.list[i].mouseWheel(ev);
if(ret)
break;}
return ret;}
};

UI.ChoiceObj=ChoiceObj;
UI.TwoChoiceObj=TwoChoiceObj;
UI.Choice4Obj=Choice4Obj;
UI.AccessObj=AccessObj;
UI.Access6Obj=Access6Obj;
UI.DacbarObj=DacbarObj;
UI.Dacbar4Obj=Dacbar4Obj;
UI.SliderbarObj=SliderbarObj;
UI.ProgressbarObj=ProgressbarObj;
UI.HyperbarObj=HyperbarObj;
UI.InputObj=InputObj;
UI.RowObj=RowObj;
UI.CategoryTitleObj=CategoryTitleObj;
UI.SpaceObj=SpaceObj;
UI.makeListObj=makeListObj;
UI.List=List;
UI.MultiColsObj=MultiColsObj;
UI.frameCommon=frameCommon;
UI.FrameObj=FrameObj;
UI.BaseFrameObj=BaseFrameObj;
UI.TextAreaObj=TextAreaObj;
UI.CursorHelpObj=CursorHelpObj;
UI.NumHelpObj=NumHelpObj;
UI.NumKeyHelpObj=NumKeyHelpObj;
UI.InfoHelpObj=InfoHelpObj;
UI.ChHelpObj=ChHelpObj;
UI.ColorHelpObj=ColorHelpObj;
UI.makeTemplate=makeTemplate;
UI.access6Element=access6Element;
FDP.FRAMES=FRAMES;
FDP.hideSystemFocus=function(){
hideSystemFocusForce();};
UI.test=function(){
var obj=new ChoiceObj({
title:'aaa',
list:['on','off'],
value:0
});
var obj2=new ChoiceObj({
title:'aaa',
list:['on','off'],
value:1
});
makeListButtonElement();
makeListButtonElement();};}(FDP));
(function(){
var MAKEPANEL={};
var frameCommon=FDP.UI.frameCommon;
MAKEPANEL.getText=function(){
return getMesObj(this.ele).innerHTML;};
MAKEPANEL.getX=function(){
if(document.defaultView.getComputedStyle(getTableCellObj(this.ele),'').getPropertyValue('text-align')==='center'){
return 'center';}else {
return document.defaultView.getComputedStyle(getFrameObj(this.ele),'').getPropertyValue('margin-left');}
};
MAKEPANEL.getY=function(){
if(document.defaultView.getComputedStyle(getTableCellObj(this.ele),'').getPropertyValue('vertical-align')==='middle'){
return 'middle';}else {
return document.defaultView.getComputedStyle(getFrameObj(this.ele),'').getPropertyValue('margin-top');}
};
MAKEPANEL.getW=function(){
return document.defaultView.getComputedStyle(getFrameObj(this.ele),'').getPropertyValue('width');};
MAKEPANEL.getH=function(){
return document.defaultView.getComputedStyle(getFrameObj(this.ele),'').getPropertyValue('height');};
MAKEPANEL.getBannerOffset=function(){
return document.defaultView.getComputedStyle(this.ele,'').getPropertyValue('top');};
MAKEPANEL.getTopMargin=function(){
return document.defaultView.getComputedStyle(getFrameObj(this.ele),'').getPropertyValue('padding-top');};
MAKEPANEL.getLeftMargin=function(){
return document.defaultView.getComputedStyle(getFrameObj(this.ele),'').getPropertyValue('padding-left');};
MAKEPANEL.getLineMargin=function(){
return document.defaultView.getComputedStyle(getFrameObj(this.ele),'').getPropertyValue('line-height');};
MAKEPANEL.getBackCol=function(){
return document.defaultView.getComputedStyle(getFrameObj(this.ele),'').getPropertyValue('background-color');};
MAKEPANEL.getBorderCol=function(){
return document.defaultView.getComputedStyle(getFrameObj(this.ele),'').getPropertyValue('border-top-color');};
MAKEPANEL.getTextCol=function(){
return document.defaultView.getComputedStyle(getFrameObj(this.ele),'').getPropertyValue('color');};
MAKEPANEL.getMesTextAlign=function(){
return document.defaultView.getComputedStyle(getMesObj(this.ele),'').getPropertyValue('text-align');};
MAKEPANEL.setText=function(mes){
_setText(mes,getMesObj(this.ele));};
MAKEPANEL.setX=function(x){
_setX(x,getTableCellObj(this.ele),getFrameObj(this.ele));};
MAKEPANEL.setY=function(y){
_setY(y,getTableCellObj(this.ele),getFrameObj(this.ele));};
MAKEPANEL.setW=function(w){
_setW(w,getFrameObj(this.ele));};
MAKEPANEL.setH=function(h){
_setH(h,getFrameObj(this.ele));};
MAKEPANEL.setBannerOffset=function(bannerOffset){
_setBannerOffset(bannerOffset,this.ele);};
MAKEPANEL.setTopMargin=function(topMargin){
_setTopMargin(topMargin,getFrameObj(this.ele));};
MAKEPANEL.setLeftMargin=function(leftMargin){
_setLeftMargin(leftMargin,getFrameObj(this.ele));};
MAKEPANEL.setLineMargin=function(lineMargin){
_setLineMargin(lineMargin,getFrameObj(this.ele));};
MAKEPANEL.setColorByClassName=function(arg){
_setColorByClassName(arg,getFrameObj(this.ele));};
MAKEPANEL.setBackCol=function(backCol){
_setBackCol(backCol,getFrameObj(this.ele));};
MAKEPANEL.setBorderCol=function(borderCol){
_setBorderCol(borderCol,getFrameObj(this.ele));};
MAKEPANEL.setTextCol=function(textCol){
_setTextCol(textCol,getFrameObj(this.ele));};
MAKEPANEL.setMesTextAlign=function(mesTextAlign){
_setMesTextAlign(mesTextAlign,getMesObj(this.ele));};
MAKEPANEL.frameObj=function(){
return getFrameObj(this.ele);};
MAKEPANEL.mesObj=function(){
return getMesObj(this.ele);};
MAKEPANEL.makePanel=function(obj){
return (function(_this){
var tableObj;
var tableCellObj;
var frameObj;
var mesObj;
var helpAreaObj;
var helpIconObj;
var helpObj;
if(typeof copyMakePanel=='undefined'){
tableObj=document.createElement('div');
tableCellObj=document.createElement('div');
tableObj.appendChild(tableCellObj);
frameObj=document.createElement('div');
tableCellObj.appendChild(frameObj);
mesObj=document.createElement('div');
frameObj.appendChild(mesObj);
frameObj.classList.add('fdp-color-pop');
frameObj.classList.add('fdp-color-text-onbase');
frameObj.classList.add('fdp-color-pop-border');
tableObj.classList.add('fdp-panel-obj');
tableCellObj.classList.add('fdp-panel-obj-table-cell');
frameObj.classList.add('fdp-panel-obj-frame');
mesObj.classList.add('fdp-panel-obj-mes');
copyMakePanel=tableObj.cloneNode(true);
helpAreaParts=document.createElement('div');
helpAreaParts.classList.add('fdp-panel-obj-help-area');
helpCursorParts=document.createElement('div');
helpCursorParts.classList.add('fdp-panel-obj-help');
helpIconTextParts=document.createElement('div');
helpIconTextParts.classList.add('fdp-panel-obj-help-icon');
helpIconTextParts.innerHTML='<img src="/usr/local/png/rem_guide_hatena.png">詳しく表示';}else {
tableObj=copyMakePanel.cloneNode(true);
tableCellObj=tableObj.getElementsByClassName('fdp-panel-obj-table-cell')[0];
frameObj=tableCellObj.getElementsByClassName('fdp-panel-obj-frame')[0];
mesObj=frameObj.getElementsByClassName('fdp-panel-obj-mes')[0];}
if(obj.helpIcon===true||obj.withCursorHelp||obj.cursorHelpArgs){
helpAreaObj=helpAreaParts.cloneNode(true);
frameObj.appendChild(helpAreaObj);}
if(obj.withCursorHelp||obj.cursorHelpArgs){
helpObj=helpCursorParts.cloneNode(true);
helpAreaObj.appendChild(helpObj);}
if(obj.helpIcon===true){
helpIconObj=helpIconTextParts.cloneNode(true);
helpAreaObj.insertBefore(helpIconObj,helpObj);}
if(typeof obj.fontSize==='undefined'||obj.fontSize==='normal'){
tableObj.classList.add('fdp-font-normal');}
_setText(obj.message,mesObj);
_setX(obj.x,tableCellObj,frameObj);
_setY(obj.y,tableCellObj,frameObj);
_setW(obj.w,frameObj);
_setH(obj.h,frameObj);
_setBannerOffset(obj.bannerOffset,tableObj);
_setTopMargin(obj.topMargin,frameObj);
_setLeftMargin(obj.leftMargin,frameObj);
_setLineMargin(obj.lineMargin,frameObj);
_setBackCol(obj.backCol,frameObj);
_setBorderCol(obj.borderCol,frameObj);
_setTextCol(obj.textCol,frameObj);
_setMesTextAlign(obj.mesTextAlign,mesObj);
if(helpObj){
__makeHelp(helpObj,obj,_this);}
_setColorByClassName(obj.colorByClassName,frameObj);
return tableObj;}(this));};
function _setText(mes,mesObj){
if(typeof mes==='undefined'||mes===false)
mesObj.innerHTML='';
else
mesObj.innerHTML=mes.replace('\n','<br>');}
function _setX(x,tableCellObj,frameObj){
if(typeof x==='undefined'||x===false){
frameObj.style.marginLeft='0px';
frameObj.style.marginRight='0px';
tableCellObj.style.textAlign='center';}else if(typeof x.x!=='undefined'&&typeof x.horizontal!=='undefined'){
frameObj.style.marginLeft=x.x;
frameObj.style.marginRight=x.x;
tableCellObj.style.textAlign=x.horizontal;}else if(x==='left'||x==='center'||x==='right'||x==='start'||x==='end'){
frameObj.style.marginLeft='0px';
frameObj.style.marginRight='0px';
tableCellObj.style.textAlign=x;}else {
frameObj.style.marginLeft=x;
frameObj.style.marginRight=x;
tableCellObj.style.textAlign='start';}
}
function _setY(y,tableCellObj,frameObj){
if(typeof y==='undefined'||y===false){
frameObj.style.marginTop='0px';
frameObj.style.marginBottom='0px';
tableCellObj.style.verticalAlign='middle';}else if(typeof y.y!=='undefined'&&typeof y.vertical!=='undefined'){
if(y.vertical==='bottom'){
frameObj.style.marginTop='0px';
frameObj.style.marginBottom=y.y;}else {
frameObj.style.marginTop=y.y;
frameObj.style.marginBottom='0px';}
tableCellObj.style.verticalAlign=y.vertical;}else if(y==='top'||y==='middle'||y==='bottom'){
frameObj.style.marginTop='0px';
frameObj.style.marginBottom='0px';
tableCellObj.style.verticalAlign=y;}else {
frameObj.style.marginTop=y;
frameObj.style.marginBottom='0px';
tableCellObj.style.verticalAlign='top';}
}
function _setW(w,frameObj){
if(typeof w==='undefined'||w===false)
frameObj.style.width='41.6%';
else
frameObj.style.width=w;}
function _setH(h,frameObj){
if(typeof h==='undefined'||h===false)
frameObj.style.height='';
else
frameObj.style.height=h;}
function _setBannerOffset(bannerOffset,panelObj){
if(typeof bannerOffset==='undefined'||bannerOffset===false)
panelObj.style.top='0px';
else
panelObj.style.top='-'+bannerOffset;}
function _setTopMargin(topMargin,frameObj){
if(typeof topMargin==='undefined'||topMargin===false){
frameObj.style.paddingTop='0.7em';
frameObj.style.paddingBottom='0.7em';}else {
frameObj.style.paddingTop=topMargin;
frameObj.style.paddingBottom=topMargin;}
}
function _setLeftMargin(leftMargin,frameObj){
if(typeof leftMargin==='undefined'||leftMargin===false){
frameObj.style.paddingLeft='1.1em';
frameObj.style.paddingRight='1.1em';}else {
frameObj.style.paddingLeft=leftMargin;
frameObj.style.paddingRight=leftMargin;}
}
function _setLineMargin(lineMargin,frameObj){
if(typeof lineMargin==='undefined'||lineMargin===false)
frameObj.style.lineHeight='1.3em';
else
frameObj.style.lineHeight=lineMargin;}
function _setColorByClassName(arg,frameObj){
if(typeof arg==='undefined'){
return;}
if(typeof arg.backCol!=='undefined'){
frameObj.classList.remove('fdp-color-pop');
frameObj.classList.add(arg.backCol);}
if(typeof arg.borderCol!=='undefined'){
frameObj.classList.remove('fdp-color-pop-border');
frameObj.classList.add(arg.borderCol);}
if(typeof arg.textCol!=='undefined'){
frameObj.classList.remove('fdp-color-text-onbase');
frameObj.classList.add(arg.textCol);}
}
function _setBackCol(backCol,frameObj){
if(typeof backCol==='undefined'||backCol===false){
frameObj.style.backgroundColor='';}else {
frameObj.style.backgroundColor=backCol;}
}
function _setBorderCol(borderCol,frameObj){
if(typeof borderCol==='undefined'||borderCol===false){
frameObj.style.borderColor='';}else {
frameObj.style.borderColor=borderCol;}
}
function _setTextCol(textCol,frameObj){
if(typeof textCol==='undefined'||textCol===false){
frameObj.style.color='';}else {
frameObj.style.color=textCol;}
}
function _setMesTextAlign(mesTextAlign,mesObj){
if(typeof mesTextAlign==='undefined'||mesTextAlign===false)
mesObj.style.textAlign='start';
else
mesObj.style.textAlign=mesTextAlign;}
function getFrameObj(panelObj){
return panelObj.getElementsByClassName('fdp-panel-obj-frame')[0];}
function getMesObj(panelObj){
return panelObj.getElementsByClassName('fdp-panel-obj-mes')[0];}
function getTableCellObj(panelObj){
return panelObj.getElementsByClassName('fdp-panel-obj-table-cell')[0];}
function getHelpIconObj(panelObj){
return panelObj.getElementsByClassName('fdp-panel-obj-help-icon')[0];}
function __makeHelp(helpObj,arg,_this){
if(arg.withCursorHelp||arg.cursorHelpArgs){
_this.cursorHelp=new FDP.UI.CursorHelpObj({
cursorHelpArgs:arg.cursorHelpArgs?arg.cursorHelpArgs:
{returnTextLst:[LANG('LT_RETURN')]}
});
helpObj.appendChild(_this.cursorHelp.ele);}
}
var copyMakePanel;
var helpAreaParts;
var helpIconTextParts;
var helpCursorParts;
MAKEPANEL.map=function(ev){
frameCommon.map.call(this,ev);
if(this.cursorHelp){
this.cursorHelp.setCursorHelpLayout();}
};
MAKEPANEL.unmap=function(ev){
this.ele.parentNode.removeChild(this.ele);
frameCommon.unmap.call(this,ev);};
MAKEPANEL.keyHook=function(ev){
return false;};
var PanelObj=UTIL.Class.create(
Object,{
__construct:function(arg){
this.frametype=arg.frametype||'errpnl';
frameCommon.__construct.call(this,arg);
this.ele=this.makePanel(arg);
if(arg.keyHook)
this.keyHook=arg.keyHook;},
getText:MAKEPANEL.getText,
getX:MAKEPANEL.getX,
getY:MAKEPANEL.getY,
getW:MAKEPANEL.getW,
getH:MAKEPANEL.getH,
getBannerOffset:MAKEPANEL.getBannerOffset,
getTopMargin:MAKEPANEL.getTopMargin,
getLeftMargin:MAKEPANEL.getLeftMargin,
getLineMargin:MAKEPANEL.getLineMargin,
getBackCol:MAKEPANEL.getBackCol,
getBorderCol:MAKEPANEL.getBorderCol,
getTextCol:MAKEPANEL.getTextCol,
getMesTextAlign:MAKEPANEL.getMesTextAlign,
getFrameObj:MAKEPANEL.frameObj,
getMesObj:MAKEPANEL.mesObj,
setText:MAKEPANEL.setText,
setX:MAKEPANEL.setX,
setY:MAKEPANEL.setY,
setW:MAKEPANEL.setW,
setH:MAKEPANEL.setH,
setBannerOffset:MAKEPANEL.setBannerOffset,
setTopMargin:MAKEPANEL.setTopMargin,
setLeftMargin:MAKEPANEL.setLeftMargin,
setLineMargin:MAKEPANEL.setLineMargin,
setBackCol:MAKEPANEL.setBackCol,
setBorderCol:MAKEPANEL.setBorderCol,
setTextCol:MAKEPANEL.setTextCol,
setMesTextAlign:MAKEPANEL.setMesTextAlign,
setColorByClassName:MAKEPANEL.setColorByClassName,
makePanel:MAKEPANEL.makePanel,
map:MAKEPANEL.map,
unmap:MAKEPANEL.unmap,
keyHook:MAKEPANEL.keyHook
});
UTIL.include2(frameCommon,PanelObj);
FDP.UI.PanelObj=PanelObj;}());}());
(function(exports){
var Anim=exports.scrollAnim={};
var animWin;
var animParam;
var tid=undefined;
var useAnimationFrame=false;
function evalTimer(){
var x,y;
if(system.effect.now()>=animParam.stopTime){
var callback=animParam.onComplete;
animWin.scroll(animParam.endPos.x,animParam.endPos.y);
animWin=undefined;
animParam=undefined;
if(!useAnimationFrame){
clearInterval(tid);}
tid=undefined;
callback();}else {
var now=system.effect.now();
var st=Math.floor(now-animParam.startTime);

x=animParam.transition(st,
animParam.startPos.x,
animParam.endPos.x-animParam.startPos.x,
animParam.time);
y=animParam.transition(st,
animParam.startPos.y,
animParam.endPos.y-animParam.startPos.y,
animParam.time);
animWin.scroll(x,y);
if(useAnimationFrame){
tid=webkitRequestAnimationFrame(evalTimer);}
}
}
Anim.start=function(win,param){
animParam={};
animWin=win;
animParam.time=param.time;
animParam.startPos=
{
x:win.document.body.scrollLeft,
y:win.document.body.scrollTop
};
animParam.endPos=
{
x:param.x,
y:param.y
};
animParam.startTime=system.effect.now();
animParam.time=param.time;
animParam.stopTime=animParam.startTime+param.time;
animParam.transition=easingFunctions[param.transition]||easingFunctions['easeOutQuad'];
animParam.onComplete=function(){
if(param.onComplete){
param.onComplete();}
};
if(useAnimationFrame){
if(tid){
webkitCancelAnimationFrame(tid);}
tid=webkitRequestAnimationFrame(evalTimer);}else {
if(tid){
clearInterval(tid);}
tid=setInterval(evalTimer,50);}
};
Anim.stop=function(){
if(useAnimationFrame){
if(tid)
webkitCancelAnimationFrame(tid);}else {
if(tid)
clearInterval(tid);}
tid=undefined;
animWin=undefined;
animParam=undefined;};
Anim.isMoving=function(){
return tid===undefined?false:true;};

var easingFunctions={
easeNone:function(t,b,c,d){
return c*t/d+b;},
easeInQuad:function(t,b,c,d){
return c*(t/=d)*t+b;},
easeOutQuad:function(t,b,c,d){
return -c*(t/=d)*(t-2)+b;},
easeInOutQuad:function(t,b,c,d){
if((t/= d /2)<1)return c/2*t*t+b;
return -c/2*((--t)*(t-2)-1)+b;}
};})(window);
