var black_frame_pics =
[
   "file:///usr/local/png/wall_frame_LL.png",
   "file:///usr/local/png/wall_frame_LH.png",
   "file:///usr/local/png/wall_frame_LV.png",
   "file:///usr/local/png/wall_frame_MH.png",
   "file:///usr/local/png/wall_frame_MV.png",
   "file:///usr/local/png/wall_frame_S.png",
   "file:///usr/local/png/wall_frame_S.png",//dummy
];

var white_frame_pics =
[
   "file:///usr/local/png/wall_frame_ll_white.png",
   "file:///usr/local/png/wall_frame_ll_white.png",
   "file:///usr/local/png/wall_frame_l_white.png",
   "file:///usr/local/png/wall_frame_l_white.png",
   "file:///usr/local/png/wall_frame_m_white.png",
   "file:///usr/local/png/wall_frame_s_white.png",
   "file:///usr/local/png/wall_frame_s_white.png",//dummy
];

MAX_PICTURES = 7;     //max black frame 
MAX_PICTURES_W = 11;  //max frame
MAX_PICTURES_WP = 20; //max photo
//ANIM_SPEED = 8;
ANIM_SPEED = 64;
WAIT_TO_NEXT_PAGE = 10000;
//WAIT_TO_NEXT_PAGE = 1000;

var wall_draw_mode = 0;
WALL_DRAW_WHITE = 0;
WALL_DRAW_BLACK = 1;

var wall_number = 0;

var anim_frame = 0;
var anim_picture = 0;
var dsp_wall_frame = 0;
var photo_number = 0;
var black_frame_obj = new Array ();
var black_frame_picture_obj = new Array ();
var white_frame_obj = new Array ();
var white_frame_picture_obj = new Array ();
var ptr_buf = new Array ();
var ptr_buf_size = new Array ();
var ptr_buf_black = new Array ();
var ptr_buf_black_size = new Array ();
var ptr_ready = new Array ();
var ptr_ready_black = new Array ();
var photo_buf = new Array ();
var photo_buf_black = new Array ();
var photo_buf2 = new Array ();
var photo_buf_black2 = new Array ();
var wall_mode = 0; // 0:black 1:white
var debug_mode = false;
var wall_finish = false;

black_frame_position_1 = [
    [42, -173, 1], // x, y, type
    [274, -544, 1],
    [834, -284, 3],
    [533, -284, 3],
    [766, -544, 4],
    [533, -92, 5],
    [85, -544, 5],
];
black_frame_position_2 = [
    [80, -246, 0],
    [345, -54, 5],
    [235, -764, 5],
    [726, -438, 2],
    [536, -54, 5],
    [425, -764, 3],
    [726, -178, 3],
];
black_frame_position_3 = [
    [83, -109, 1],
    [477, -480, 0],
    [573, -220, 3],
    [176, -480, 3],
    [-10000, -10000, 6],
    [-10000, -10000, 6],
    [-10000, -10000, 6],
];
black_frame_position_4 = [
    [24, -358, 1],
    [514, -285, 0],
    [-10000, -10000, 6],
    [-10000, -10000, 6],
    [-10000, -10000, 6],
    [-10000, -10000, 6],
    [-10000, -10000, 6],
];

black_frame_position = [
    black_frame_position_1,
    black_frame_position_2,
    black_frame_position_3,
    black_frame_position_4,
];

black_frame_size_width = new Array (640, 484, 363, 295, 252, 184, 0);
black_frame_size_height = new Array (510, 364, 484, 252, 295, 184, 0);
black_frame_inner_size_width = new Array (520, 344, 258, 192, 144, 96, 0);
black_frame_inner_size_height = new Array (390, 258, 344, 144, 192, 96, 0);
black_frame_inner_pos_x = new Array (61, 71, 53, 52, 55, 45, 0);
black_frame_inner_pos_y = new Array (61, 53, 71, 55, 52, 45, 0 );

white_frame_position_1 = [
    [88, -51, 5],
    [817, -51, 1],
    [88, -472, 3],
    [471, -51, 5],
    [-10000, -10000, 6],
    [-10000, -10000, 6],
    [-10000, -10000, 6],
    [-10000, -10000, 6],
    [-10000, -10000, 6],
    [-10000, -10000, 6],
    [-10000, -10000, 6],
];
white_frame_position_2 = [
    [81, -683, 5],
    [447, -51, 0],
    [1522, -115, 5],
    [1522, -399, 5],
    [81, -115, 5],
    [1522, -683, 5],
    [81, -399, 5],
    [-10000, -10000, 6],
    [-10000, -10000, 6],
    [-10000, -10000, 6],
    [-10000, -10000, 6],
];
white_frame_position_3 = [
    [1522, -683, 5],
    [433, -115, 2],
    [1522, -115, 5],
    [81, -399, 5],
    [81, -115, 5],
    [1168, -399, 5],
    [1522, -399, 5],
    [433, -683, 4],
    [81, -683, 5],
    [1168, -115, 5],
    [1168, -683, 5],
];
white_frame_position_4 = [
    [81, -115, 5],
    [1154, -399, 2],
    [433, -683, 4],
    [81, -399, 4],
    [433, -115, 4],
    [1154, -115, 4],
    [81, -683, 5],
    [816, -399, 5],
    [-10000, -10000, 6],
    [-10000, -10000, 6],
    [-10000, -10000, 6],
];
white_frame_position = [
    white_frame_position_1,
    white_frame_position_2,
    white_frame_position_3,
    white_frame_position_4,
];

white_frame_size_width = new Array (1030, 1030, 707, 707, 707, 324, 0);
white_frame_size_height = new Array (980, 980, 561, 561, 277, 277, 0);
white_frame_inner_size_width = new Array (520, 192, 520, 520, 96, 192, 0);
white_frame_inner_size_height = new Array (390, 144, 390, 390, 96, 144, 0);
white_frame_inner_pos_x = new Array (51, 76, 90, 90, 304, 63, 0);
white_frame_inner_pos_y = new Array (81 ,81, 72, 72, 86, 63, 0);

for (var j=0; j<MAX_PICTURES; j++)
{
    var f_type = black_frame_position[0][j][2];
    black_frame_obj[j] = new gimage ({
	"color": [255,255,255,255],
	"translate": [black_frame_position[0][j][0],black_frame_position[0][j][1],0],
	"rotation": [0,0,0,0],
	"src": black_frame_pics[f_type],
	"width": black_frame_size_width[f_type],
	"height": black_frame_size_height[f_type],
	"visible_p": true,
	"draw_type": CIRCUMSCRIBED,
    });
    black_frame_picture_obj[j] = new gimage ({
	"color": [255, 255, 255, 255],
	"translate": [black_frame_position[0][j][0] + black_frame_inner_pos_x[f_type],
		      black_frame_position[0][j][1] + black_frame_inner_pos_y[f_type],
		      0],
	"rotation": [0,0,0,0],
	"width": black_frame_inner_size_width[f_type],
	"height": black_frame_inner_size_height[f_type],
	"enable_dither": true,
	"visible_p": true,
	"enable_expmem": true,
	//"draw_type": INSCRIBED,
	"draw_type": FULL,
    });
    ptr_buf_black[j] = 0;
    ptr_buf_black_size[j] = 0;
    ptr_ready_black[j] = 0;
    photo_buf_black[j] = -1; 
}

for (var j=0; j<MAX_PICTURES_W; j++)
{
    var f_type = white_frame_position[0][j][2];
    white_frame_obj[j] = new gimage ({
	"color": [255,255,255,255],
	"translate": [0,0,0],
	"rotation": [0,0,0,0],
	"src": white_frame_pics[f_type],
	"width": white_frame_size_width[f_type],
	"height": white_frame_size_height[f_type],
	"enable_dither": true,
	"visible_p": true,
	"draw_type": CIRCUMSCRIBED,
    });
}

for (var j=0; j<MAX_PICTURES_WP; j++)
{
    white_frame_picture_obj[j] = new gimage ({
	"color": [255, 255, 255, 0],
	"translate": [0, 0, 0],
	"rotation": [0,0,0,0],
	"width": white_frame_inner_size_width[f_type],
	"height": white_frame_inner_size_height[f_type],
	"enable_dither": true,
	"visible_p": true,
	"enable_expmem": true,
	//"draw_type": INSCRIBED,
	"draw_type": FULL,
    });
    ptr_buf[j] = 0;
    ptr_buf_size[j] = 0;
    ptr_ready[j] = 0;
    photo_buf[j] = -1; 
}

var dsp_wallframe = 0;

var clear_wall_frame = function () {
    dsp_wallframe = 0;
    for (var j=0; j<MAX_PICTURES; j++)
    {
	if (ptr_buf_black[j] != 0)
	{
	    black_frame_picture_obj[j].free_expmem (ptr_buf_black[j]);
	    ptr_buf_black[j] = 0;
	    ptr_buf_black_size[j] = 0;
	}
	black_frame_obj[j].src = "";
	black_frame_obj[j] = 0;
	black_frame_picture_obj[j] = 0;
	ptr_buf_black[j] = 0;
	ptr_buf_black_size[j] = 0;
	ptr_ready_black[j] = 0;
    }
    for (var j=0; j<MAX_PICTURES_W; j++)
    {
	white_frame_obj[j].src = "";
	white_frame_obj[j] = 0;
    }
    for (var j=0; j<MAX_PICTURES_WP; j++)
    {
	if (ptr_buf[j] != 0)
	{
	    white_frame_picture_obj[j].free_expmem (ptr_buf[j]);
	    ptr_buf[j] = 0;
	    ptr_buf_size[j] = 0;
	}
	white_frame_picture_obj[j] = 0;
	ptr_buf[j] = 0;
	ptr_buf_size[j] = 0;
	ptr_ready[j] = 0;
    }
}

var stop_reading = function () {
    for (var j=0; j<MAX_PICTURES; j++)
    {
	photo_buf_black[j] = -1;
    }
    for (var j=0; j<MAX_PICTURES_WP; j++)
    {
	photo_buf[j] = -1;
    }
}

var wallframe_load_image = function (num) {
    if(num != -1)
    {
	if(wall_mode == 0)
	{
	    if (ptr_buf_black[num] != 0 && ptr_ready_black[num] == 0)
	    {
		ptr_ready_black[num] = 1;
		black_frame_picture_obj[num].ready_expmem (ptr_buf_black[num]);
	    }
	}
	else
	{
	    if (ptr_buf[num] != 0 && ptr_ready[num] == 0)
	    {
		ptr_ready[num] = 1;
		white_frame_picture_obj[num].ready_expmem (ptr_buf[num]);
	    }
	}
    }
    
    if(dsp_wallframe == 0)
    {
	return;
    }
    
    for (var j=0; j<MAX_PICTURES; j++)
    {
	if(photo_buf_black[j] >= 0)
	{
	    ptr = black_frame_picture_obj[j].alloc_expmem (black_frame_picture_obj[j].width, 
							   black_frame_picture_obj[j].height,
							   RGBA8888_BLOCK);
	    write_back_bytes2 (10, [ptr[0],
				    black_frame_picture_obj[j].width,
				    black_frame_picture_obj[j].height,
				    photo_buf_black[j],j, ptr[1] * ptr[2] * 4]);
	    ptr_buf_black[j] = ptr[0];
	    ptr_buf_black_size[j] = ptr[1] * ptr[2] * 4;
	    ptr_ready_black[j] = 0;
	    photo_buf_black[j] = -1;
	    return;
	}
    }
    for (var j=0; j<MAX_PICTURES_WP; j++)
    {
	if(photo_buf[j] >= 0)
	{
	    ptr = white_frame_picture_obj[j].alloc_expmem (white_frame_picture_obj[j].width,
							   white_frame_picture_obj[j].height,
							   RGBA8888_BLOCK);
	    write_back_bytes2 (10, [ptr[0],
				    white_frame_picture_obj[j].width,
				    white_frame_picture_obj[j].height,
				    photo_buf[j], j, ptr[1] * ptr[2] * 4]);
	    ptr_buf[j] = ptr[0];
	    ptr_buf_size[j] = ptr[1] * ptr[2] * 4;
	    ptr_ready[j] = 0;
	    photo_buf[j] = -1;
	    return;
	}
    }
    wall_finish = true;
    write_back_bytes2 (33,[0]);
}

var load_picture_black = function (obj, num) {
    if(ptr_buf_black[num] != 0)
    {
	obj.free_expmem(ptr_buf_black[num]);
	ptr_buf_black[num] = 0;
	ptr_buf_black_size[num] = 0;
	ptr_ready_black[num] = 0;
    }
    photo_buf_black[num] = photo_number;
    photo_buf_black2[num] = photo_number;
    photo_number++; 
    if(photo_number >= items)
    {
	photo_number = 0;
    }
}

var load_picture = function (obj, num) {
    if(ptr_buf[num] != 0)
    {
	obj.free_expmem(ptr_buf[num]);
	ptr_buf[num] = 0;
	ptr_buf_size[num] = 0;
	ptr_ready[num] = 0;
    }
    photo_buf[num] = photo_number;
    photo_buf2[num] = photo_number;
    photo_number++; 
    if(photo_number >= items)
    {
	photo_number = 0;
    }
}

var create_black_frame = function (num) {
    wall_finish = false;
    write_back_bytes2 (35,[0]);
    wall_draw_mode = WALL_DRAW_BLACK;
    top_picture_number = photo_number;

    wall_mode = 0;

    set_calendar_size (100);
    set_calendar_color (128);

    for (var j=0; j<MAX_PICTURES_WP; j++)
    {
	photo_buf[j] = -1; 	
    }
    for (var j=0; j<MAX_PICTURES; j++)
    {
	photo_buf_black[j] = -1; 
    }

    move_calendar();

    if(calendar_mode == true)
    {
	wall_base_obj.translate[0] = -960 + (photo_number % 10);
	wall_base_obj.translate[1] = 540 + (photo_number % 7);
	calendar_base_obj.translate[0] = 340;
	calendar_base_obj.translate[1] = calendar_y_pos;
	calendar_base_obj.translate[2] = 0;
	calendar_base_obj.visible_p = true;
    }
    else
    {
	wall_base_obj.translate[0] = -600 + (photo_number % 10);
	wall_base_obj.translate[1] = 540 + (photo_number % 7);
    }
    for (var j=0; j<MAX_PICTURES; j++)
    {
	var f_type = black_frame_position[num][j][2];

	black_frame_obj[j].color = [255,255,255,0];
	black_frame_picture_obj[j].color = [255,255,255,0];
	
	black_frame_obj[j].translate = [black_frame_position[num][j][0] + black_frame_size_width[f_type] / 2,
					black_frame_position[num][j][1] - black_frame_size_height[f_type] / 2,
					0];
	black_frame_obj[j].src = black_frame_pics[f_type];
	black_frame_obj[j].width = black_frame_size_width[f_type];
	black_frame_obj[j].height = black_frame_size_height[f_type];
	
	black_frame_picture_obj[j].translate = [black_frame_obj[j].translate[0], black_frame_obj[j].translate[1], 0];
	black_frame_picture_obj[j].width = black_frame_inner_size_width[f_type];
	black_frame_picture_obj[j].height = black_frame_inner_size_height[f_type];
	if(f_type != 6)
	{
	    load_picture_black(black_frame_picture_obj[j],j);
	}
    }
    wall_base_obj.components = [ 
	black_frame_obj[6],
	black_frame_obj[5],
	black_frame_obj[4],
	black_frame_obj[3],
	black_frame_obj[2],
	black_frame_obj[1],
	black_frame_obj[0],
	black_frame_picture_obj[6],
	black_frame_picture_obj[5],
	black_frame_picture_obj[4],
	black_frame_picture_obj[3],
	black_frame_picture_obj[2],
	black_frame_picture_obj[1],
	black_frame_picture_obj[0],];
    write_back_bytes2 (30,[0]);
    wallframe_load_image(-1);
}

var create_white_frame = function (num) {
    wall_finish = false;
    write_back_bytes2 (35,[0]);
    wall_draw_mode = WALL_DRAW_WHITE;
    top_picture_number = photo_number;

    wall_mode = 1;

    set_calendar_size (80);
    set_calendar_color (100);

    for (var j=0; j<MAX_PICTURES; j++)
    {
	photo_buf_black[j] = -1; 
    }

    wall_base_obj.translate[0] = -960 + (photo_number % 10);
    wall_base_obj.translate[1] = 540 + (photo_number % 7);

    if(calendar_mode == true)
    {
	calendar_base_obj.translate[0] = 3500;
	calendar_base_obj.translate[1] = -100;
	calendar_base_obj.translate[2] = 0;
    }
    var i = 0; //picture
    for (var j=0; j<MAX_PICTURES_WP; j++)
    {
	white_frame_picture_obj[j].color = [255,255,255,0];
    }

    for (var j=0; j<MAX_PICTURES_W; j++)
    {
	var f_type = white_frame_position[num][j][2];

	white_frame_obj[j].color = [255,255,255,0];

	white_frame_obj[j].translate = [white_frame_position[num][j][0] + white_frame_size_width[f_type] / 2,
					white_frame_position[num][j][1] - white_frame_size_height[f_type] / 2,
					0];
	white_frame_obj[j].src = white_frame_pics[f_type];
	white_frame_obj[j].width = white_frame_size_width[f_type];
	white_frame_obj[j].height = white_frame_size_height[f_type];

	switch (f_type)
	{
	case 0:
	    white_frame_picture_obj[i].translate = [white_frame_obj[j].translate[0] - 439 + 96,
						    white_frame_obj[j].translate[1] + 432 - 72, 0];
	    white_frame_picture_obj[i].width = white_frame_inner_size_width[5];
	    white_frame_picture_obj[i].height = white_frame_inner_size_height[5];
	    load_picture(white_frame_picture_obj[i],i++);
	    white_frame_picture_obj[i].translate = [white_frame_obj[j].translate[0] - 439 + 96,
						    white_frame_obj[j].translate[1] + 187 - 72, 0];
	    white_frame_picture_obj[i].width = white_frame_inner_size_width[5];
	    white_frame_picture_obj[i].height = white_frame_inner_size_height[5];
	    load_picture(white_frame_picture_obj[i],i++);
	    white_frame_picture_obj[i].translate = [white_frame_obj[j].translate[0] - 108 + 260,
						    white_frame_obj[j].translate[1] + 432 - 195, 0];
	    white_frame_picture_obj[i].width = white_frame_inner_size_width[2];
	    white_frame_picture_obj[i].height = white_frame_inner_size_height[2];
	    load_picture(white_frame_picture_obj[i],i++);
	    white_frame_picture_obj[i].translate = [white_frame_obj[j].translate[0] + 220 + 96 ,
						    white_frame_obj[j].translate[1] - 179 - 72, 0];
	    white_frame_picture_obj[i].width = white_frame_inner_size_width[5];
	    white_frame_picture_obj[i].height = white_frame_inner_size_height[5];
	    load_picture(white_frame_picture_obj[i],i++);
	    //calendar
	    if(calendar_mode == true)
		{
		    calendar_base_obj.translate[0] = white_frame_obj[j].translate[0] - 1300 + (photo_number % 10);
		    calendar_base_obj.translate[1] = white_frame_obj[j].translate[1] + 350;
		}
	    else
		{
		    white_frame_picture_obj[i].translate = [white_frame_obj[j].translate[0] - 439 + 260,
							    white_frame_obj[j].translate[1] -37 - 195, 0];
		    white_frame_picture_obj[i].width = white_frame_inner_size_width[2];
		    white_frame_picture_obj[i].height = white_frame_inner_size_height[2];
		    load_picture(white_frame_picture_obj[i],i++);
		}
	    break;
	case 1:
	    white_frame_picture_obj[i].translate = [white_frame_obj[j].translate[0] - 439 + 96,
						    white_frame_obj[j].translate[1] + 432 - 72, 0];
	    white_frame_picture_obj[i].width = white_frame_inner_size_width[5];
	    white_frame_picture_obj[i].height = white_frame_inner_size_height[5];
	    load_picture(white_frame_picture_obj[i],i++);
	    white_frame_picture_obj[i].translate = [white_frame_obj[j].translate[0] - 439 + 96,
						    white_frame_obj[j].translate[1] + 187 - 72, 0];
	    white_frame_picture_obj[i].width = white_frame_inner_size_width[5];
	    white_frame_picture_obj[i].height = white_frame_inner_size_height[5];
	    load_picture(white_frame_picture_obj[i],i++);
	    white_frame_picture_obj[i].translate = [white_frame_obj[j].translate[0] - 108 + 260,
						    white_frame_obj[j].translate[1] + 432 - 195, 0];
	    white_frame_picture_obj[i].width = white_frame_inner_size_width[2];
	    white_frame_picture_obj[i].height = white_frame_inner_size_height[2];
	    load_picture(white_frame_picture_obj[i],i++);
	    white_frame_picture_obj[i].translate = [white_frame_obj[j].translate[0] + 220 + 96 ,
						    white_frame_obj[j].translate[1] - 179 - 72, 0];
	    white_frame_picture_obj[i].width = white_frame_inner_size_width[5];
	    white_frame_picture_obj[i].height = white_frame_inner_size_height[5];
	    load_picture(white_frame_picture_obj[i],i++);
	    //calendar
	    if(calendar_mode == true)
		{
		    calendar_base_obj.translate[0] = white_frame_obj[j].translate[0] - 1300 + (photo_number % 10);
		    calendar_base_obj.translate[1] = white_frame_obj[j].translate[1] + 350;
		}
	    else
		{
		    white_frame_picture_obj[i].translate = [white_frame_obj[j].translate[0] - 439 + 260,
							    white_frame_obj[j].translate[1] -37 - 195, 0];
		    white_frame_picture_obj[i].width = white_frame_inner_size_width[2];
		    white_frame_picture_obj[i].height = white_frame_inner_size_height[2];
		    load_picture(white_frame_picture_obj[i],i++);
		}
	    break;
	case 2:
	    if(calendar_mode == true)
		{
		    //calendar
		    calendar_base_obj.translate[0] = white_frame_obj[j].translate[0] - 1160 + (photo_number % 10);
		    calendar_base_obj.translate[1] = white_frame_obj[j].translate[1] + 580;
		}
	    else
		{
		    white_frame_picture_obj[i].translate = [white_frame_obj[j].translate[0], white_frame_obj[j].translate[1], 0];
		    white_frame_picture_obj[i].width = white_frame_inner_size_width[f_type];
		    white_frame_picture_obj[i].height = white_frame_inner_size_height[f_type];
		    load_picture(white_frame_picture_obj[i],i++);
		}
	    break;
	case 3:
	    white_frame_picture_obj[i].translate = [white_frame_obj[j].translate[0], white_frame_obj[j].translate[1], 0];
	    white_frame_picture_obj[i].width = white_frame_inner_size_width[f_type];
	    white_frame_picture_obj[i].height = white_frame_inner_size_height[f_type];
	    load_picture(white_frame_picture_obj[i],i++);
	    break;
	case 4:
	    white_frame_picture_obj[i].translate = [white_frame_obj[j].translate[0], white_frame_obj[j].translate[1], 0];
	    white_frame_picture_obj[i].width = white_frame_inner_size_width[f_type];
	    white_frame_picture_obj[i].height = white_frame_inner_size_height[f_type];
	    load_picture(white_frame_picture_obj[i],i++);
	    white_frame_picture_obj[i].translate = [white_frame_obj[j].translate[0] + 177, white_frame_obj[j].translate[1], 0];
	    white_frame_picture_obj[i].width = white_frame_inner_size_width[5];
	    white_frame_picture_obj[i].height = white_frame_inner_size_height[5];
	    load_picture(white_frame_picture_obj[i],i++);
	    white_frame_picture_obj[i].translate = [white_frame_obj[j].translate[0] - 177, white_frame_obj[j].translate[1], 0];
	    white_frame_picture_obj[i].width = white_frame_inner_size_width[5];
	    white_frame_picture_obj[i].height = white_frame_inner_size_height[5];
	    load_picture(white_frame_picture_obj[i],i++);
	    break;
	case 5:
	    white_frame_picture_obj[i].translate = [white_frame_obj[j].translate[0], white_frame_obj[j].translate[1], 0];
	    white_frame_picture_obj[i].width = white_frame_inner_size_width[f_type];
	    white_frame_picture_obj[i].height = white_frame_inner_size_height[f_type];
	    load_picture(white_frame_picture_obj[i],i++);
	    break;
	default:
	    white_frame_picture_obj[i].translate = [white_frame_obj[j].translate[0], white_frame_obj[j].translate[1], 0];
	    break;
	}
    };
    wall_base_obj.components = [ 
	white_frame_obj[11],
	white_frame_obj[10],
	white_frame_obj[9],
	white_frame_obj[8],
	white_frame_obj[7],
	white_frame_obj[6],
	white_frame_obj[5],
	white_frame_obj[4],
	white_frame_obj[3],
	white_frame_obj[2],
	white_frame_obj[1],
	white_frame_obj[0],
	white_frame_picture_obj[15],
	white_frame_picture_obj[14],
	white_frame_picture_obj[13],
	white_frame_picture_obj[12],
	white_frame_picture_obj[11],
	white_frame_picture_obj[10],
	white_frame_picture_obj[9],
	white_frame_picture_obj[8],
	white_frame_picture_obj[7],
	white_frame_picture_obj[6],
	white_frame_picture_obj[5],
	white_frame_picture_obj[4],
	white_frame_picture_obj[3],
	white_frame_picture_obj[2],
	white_frame_picture_obj[1],
	white_frame_picture_obj[0],];
    write_back_bytes2 (30,[0]);
    wallframe_load_image(-1);
}

wall_base_obj = 
    new container ({
	"translate": [-960, 540, 0],
	"rotation": [0, 0, 0, 0],
	"components":[ 
	    black_frame_obj[6],
	    black_frame_obj[5],
	    black_frame_obj[4],
	    black_frame_obj[3],
	    black_frame_obj[2],
	    black_frame_obj[1],
	    black_frame_obj[0],
	    black_frame_picture_obj[6],
	    black_frame_picture_obj[5],
	    black_frame_picture_obj[4],
	    black_frame_picture_obj[3],
	    black_frame_picture_obj[2],
	    black_frame_picture_obj[1],
	    black_frame_picture_obj[0],
	],
	"visible_p": true,
    });

wall = new gbox ({
    "translate":[0, 0, 10],
    "rotation": [0, 0, 0, 0],
    "width": 1920,
    "height": 1080,
    "color_enable": true,
    "color": [0, 0, 0, 255],
});

var timer_hook_black = 
    function (obj, count){
	delete_timer (obj);
	if(black_frame_picture_obj[anim_frame].color[3] < 256)
	{
	    black_frame_obj[anim_frame].color[3] += ANIM_SPEED;
	    black_frame_picture_obj[anim_frame].color[3] += parseInt(ANIM_SPEED/2);
	    append_timer (this, 50, timer_hook_black);
	}
	else
	{
	    write_back_bytes2 (35,[0]);
	    if(!slideshow_repeat && items == photo_buf_black2[anim_frame] + 1)
		{
		    loop_over = true;
		}
	    black_frame_obj[anim_frame].color[3] = 255;
	    black_frame_picture_obj[anim_frame].color[3] = 255;
	    anim_frame++;
	    append_timer (this, ANIM_SPEED * 50, timer_hook_black);
	    if(black_frame_picture_obj[anim_frame-1].translate[0] != -10000)
	    {
		wall_set_last_focus ();
		write_back_bytes2 (32,[focus]);    
	    }
	}
	
	force_redraw ();
	
	if(anim_frame >= MAX_PICTURES)
	{
	    delete_timer (obj);
	    append_timer (this, WAIT_TO_NEXT_PAGE, timer_hook_black2);
	}
    }

var timer_hook_black2 = 
    function (obj, count){
	if(!wall_finish)
	{
	    return;
	}
	for (var j=0; j<MAX_PICTURES; j++)
	{
	    if(black_frame_obj[j].color[3] > 0)
	    {
		black_frame_obj[j].color[3] -= ANIM_SPEED;
		black_frame_picture_obj[j].color[3] -= ANIM_SPEED;
	    }
	    else
	    {
		black_frame_obj[j].color[3] = 0;
		black_frame_picture_obj[j].color[3] = 0;
		anim_frame++;
	    }
	}
	force_redraw ();
	if(black_frame_obj[0].color[3] == 0)
	{
	    delete_timer (obj);      
	    append_timer (this, 1000, timer_hook_black3);
	}
	else
	{
	    delete_timer (obj);      
	    append_timer (this, 50, timer_hook_black2);
	}
    }

var timer_hook_black3 = 
  function (obj, count){
      delete_timer (obj);      
      anim_frame = 0;
      anim_picture = 0;
      wall_number++;
      if(wall_number > 3)
      {
	  wall_number = 0;
	  create_white_frame(wall_number);
	  append_timer (this, ANIM_SPEED * 50, timer_hook_white);
	  wall.color = [192, 192, 192, 255];
	  calendar_base_obj.visible_p = false;
      }
      else
      {
	  create_black_frame(wall_number);
	  append_timer (this, ANIM_SPEED * 50, timer_hook_black);
      }
      force_redraw ();
      if(loop_over)
      {
	  wall_quit_func ();
      }
  }

finish_count = 0;

var timer_hook_white = 
    function (obj, count){
	var f_type = white_frame_position[wall_number][anim_frame][2];
	delete_timer (obj);
	if(finish_count < 256)
	{
	    white_frame_obj[anim_frame].color[3] += ANIM_SPEED;
	    switch (f_type)
	    {
	    case 0:
	    case 1:
		white_frame_picture_obj[anim_picture].color[3] += parseInt(ANIM_SPEED/2);
		white_frame_picture_obj[anim_picture+1].color[3] += parseInt(ANIM_SPEED/2 + 10);
		white_frame_picture_obj[anim_picture+2].color[3] += parseInt(ANIM_SPEED/2 + 7);
		white_frame_picture_obj[anim_picture+3].color[3] += parseInt(ANIM_SPEED/2 + 3) ;
		if(calendar_mode != true)
		{
		    white_frame_picture_obj[anim_picture+4].color[3] += parseInt(ANIM_SPEED/2);
		}
		finish_count = white_frame_picture_obj[anim_picture].color[3];
		break;
	    case 2:
		if(calendar_mode != true)
		{
		    white_frame_picture_obj[anim_picture].color[3] += parseInt(ANIM_SPEED/2);
		    finish_count = white_frame_picture_obj[anim_picture].color[3];
		}
		else
		{
		    finish_count = white_frame_obj[anim_frame].color[3];
		}
		break;
	    case 3:
		white_frame_picture_obj[anim_picture].color[3] += parseInt(ANIM_SPEED/2);
		finish_count = white_frame_picture_obj[anim_picture].color[3];
		break;
	    case 4:
		white_frame_picture_obj[anim_picture].color[3] += parseInt(ANIM_SPEED/2);
		white_frame_picture_obj[anim_picture+1].color[3] += parseInt(ANIM_SPEED/2 + 20);
		white_frame_picture_obj[anim_picture+2].color[3] += parseInt(ANIM_SPEED/2 + 10);
		finish_count = white_frame_picture_obj[anim_picture].color[3];
		break;
	    case 5:
		white_frame_picture_obj[anim_picture].color[3] += parseInt(ANIM_SPEED/2);
		finish_count = white_frame_picture_obj[anim_picture].color[3];
		break;
	    case 6:
		finish_count = 256;
		break;
	    default:
		break;
	    }
	    append_timer (this, 50, timer_hook_white);
	}
	else
	{
	    write_back_bytes2 (35,[0]);
	    if(!slideshow_repeat && items == photo_buf2[anim_frame] + 1)
		{
		    loop_over = true;
		}
	    finish_count = 0;
	    white_frame_obj[anim_frame].color[3] = 255;
	    switch (f_type)
	    {
	    case 0:
	    case 1:
		white_frame_picture_obj[anim_picture++].color[3] = 255;
		white_frame_picture_obj[anim_picture++].color[3] = 255;
		white_frame_picture_obj[anim_picture++].color[3] = 255;
		white_frame_picture_obj[anim_picture++].color[3] = 255;
		if(calendar_mode == true)
		{
		    calendar_base_obj.visible_p = true;
		}
		else
		{
		    white_frame_picture_obj[anim_picture++].color[3] = 255;
		}
		break;
	    case 2:
		if(calendar_mode == true)
		{
		    calendar_base_obj.visible_p = true;
		}
		else
		{
		    white_frame_picture_obj[anim_picture++].color[3] = 255;
		}
		break;
	    case 3:
		white_frame_picture_obj[anim_picture++].color[3] = 255;
		break;
	    case 4:
		white_frame_picture_obj[anim_picture++].color[3] = 255;
		white_frame_picture_obj[anim_picture++].color[3] = 255;
		white_frame_picture_obj[anim_picture++].color[3] = 255;
		break;
	    case 5:
		white_frame_picture_obj[anim_picture++].color[3] = 255;
		break;
	    case 6:
		break;
	    default:
		break;
	    }
	    anim_frame++;
	    wall_set_last_focus ();
	    write_back_bytes2 (32,[focus]);    
	    append_timer (this, ANIM_SPEED * 50, timer_hook_white);
	}

	force_redraw ();
	
	if(anim_frame >= MAX_PICTURES_W)
	{
	    calendar_base_obj.visible_p = true;
	    force_redraw ();
	    delete_timer (obj);
	    append_timer (this, WAIT_TO_NEXT_PAGE, timer_hook_white2);
	}
    }

var timer_hook_white2 = 
    function (obj, count){
	if(!wall_finish)
	{
	    return;
	}
	calendar_base_obj.visible_p = false;

	for (var j=0; j<MAX_PICTURES_W; j++)
	{
	    if(white_frame_obj[j].color[3] > 0)
	    {
		white_frame_obj[j].color[3] -= ANIM_SPEED;
	    }
	    else
	    {
		white_frame_obj[j].color[3] = 0;
	    }
	}
	for (var j=0; j<MAX_PICTURES_WP; j++)
	{
	    if(white_frame_picture_obj[j].color[3] > 0)
	    {
		white_frame_picture_obj[j].color[3] -= ANIM_SPEED;
	    }
	    else
	    {
		white_frame_picture_obj[j].color[3] = 0;
	    }
	}
	force_redraw ();
	if(white_frame_obj[0].color[3] == 0)
	{
	    delete_timer (obj);      
	    append_timer (this, 1000, timer_hook_white3);
	}
	else
	{
	    delete_timer (obj);      
	    append_timer (this, 50, timer_hook_white2);
	}
    }

var timer_hook_white3 = 
  function (obj, count){
      delete_timer (obj);      
      anim_frame = 0;
      anim_picture = 0;
      wall_number++;
      if(wall_number > 3)
      {
	  wall_number = 0;
	  create_black_frame(wall_number);
	  append_timer (this, ANIM_SPEED * 50, timer_hook_black);
	  wall.color = [0, 0, 0, 255];
	  calendar_base_obj.visible_p = true;
      }
      else
      {
	  create_white_frame(wall_number);
	  append_timer (this, ANIM_SPEED * 50, timer_hook_white);
      }
      force_redraw ();
      if(loop_over)
      {
	  wall_quit_func ();
      }
  }

function wallframe_appear_obj () {
    dsp_wallframe = 1;

    for(var i = 0; i < MAX_PICTURES; i++)
    {
	ptr_buf_black[i] = 0;
	ptr_buf_black_size[i] = 0;
	ptr_ready_black[i] = 0;
    }
    for(var i = 0; i < MAX_PICTURES_WP; i++)
    {
	ptr_buf[i] = 0;
	ptr_buf_size[i] = 0;
	ptr_ready[i] = 0;
    }

    viv_mode = MODE_WALLFRAME;

    photo_number = focus;
    start_pos = focus;
    loop_over = false;

    s.components[0] = wall;
    s.components[1] = wall_base_obj;
    s.components[2] = calendar_base_obj;

    write_back_bytes2 (22,[MODE_WALLFRAME]);
    
    dsp_wall_frame = 1;
    create_black_frame(0);
    anim_frame = 0;
    anim_picture = 0;

    append_timer (this, ANIM_SPEED * 50, timer_hook_black);
    //append_timer (this, 50, timer_hook_black);
}

var wallframe_key = function (up_down, key) {
    if (up_down != KEY_PRESS)
	return true;
    if (frame_mode == false)
    {
	return true;
    }
    if (key_invalid_flg)
    {
	return true;
    }

    switch (key)
    {
    case TXK_STOP:
	key = TXK_DOWN;
	break;
    case TXK_FF:
    case TXK_SKIP_NEXT:
	key = TXK_RIGHT;
	break;
    case TXK_REW:
    case TXK_SKIP_PREV:
	key = TXK_LEFT;
	break;
    case TXK_PAUSE:
	key = TXK_ENTER;
	break;
    default:
	break;
    }

    switch (key)
    {
    case TXK_RIGHT:
	if(calendar_year != 0xff)
	{
	    calendar_month++;
	    if(calendar_month == 13)
	    {
		calendar_month = 1;
		calendar_year++;
		if(calendar_year == 2100)
		{
		    calendar_year--;
		    calendar_month = 12;
		}
            }
	    set_calendar(calendar_year,calendar_month);
	    force_redraw ();
	}
	break;
    case TXK_LEFT:
	if(calendar_year != 0xff)
	{
	    calendar_month--;
	    if(calendar_month == 0)
	    {
		calendar_month = 12;
		calendar_year--;
		if(calendar_year == 1899)
		{
		    calendar_year++;
		    calendar_month = 1;
		}
	    }
	    set_calendar(calendar_year,calendar_month);
	    force_redraw ();
	}
	break;
    case TXK_DOWN:
	wall_quit_func ();
	break;
    case TXK_UP:
	break;
    case TXK_ENTER:
	wall_move_single();
	break;
    case TXK_RETURN:
	wall_quit_func ();
        break;
    default:
	break;
    }
};

var wall_set_last_focus = function (){
    if(wall_draw_mode == WALL_DRAW_BLACK)
    {
	if(anim_frame == 0)
	{
	    focus = top_picture_number + anim_frame;
	}
	else
	{
	    focus = top_picture_number + anim_frame - 1;
	}
	focus %= items;
    }
    else
    {
	if(anim_picture == 0)
	{
	    focus = top_picture_number + anim_picture;
	}
	else
	{
	    focus = top_picture_number + anim_picture - 1;
	}
	focus %= items;
    }
    if(focus < 0 || focus >= items || loop_over)
    {
	focus = items - 1;
    }
}

var wall_quit_func = function (){
    stop_reading ();
    frame_mode = false;
    single_mode = false;
    clear_wall_frame();
    clear_stage();
    delete_timer (this);
    write_back_bytes2 (28,[0]);
}

var wall_change_func = function (){
    stop_reading ();
    frame_mode = false;
    single_mode = false;
    clear_wall_frame();
    clear_stage();
    delete_timer (this);
}

var wall_move_single = function () {
    hide_flag = true;
    delete_timer (this);
    write_back_bytes2 (27,[focus]);
    clear_wall_frame();
    clear_stage();
}
