VIV_AREA_EU = 0;
VIV_AREA_PAL = 1;
VIV_AREA_US = 2;
VIV_AREA_JP = 3;

var font_name = ["F015T-bold","F015T-bold","F015T-bold","PUDGoDp-regular"];
var info_font_name = ["F015T-bold","F015T-bold","F015T-bold","PUDGoDp-regular"];
var viv_area = VIV_AREA_EU;
var low_load_animation = false;

MODE_LIST = 0;
MODE_FLOWFRAME = 1;
MODE_WALLFRAME = 2;
MODE_CINEMAFRAME = 3;
MODE_NONE = 4;

ZOOM_SPEED = 20;
ZOOM_DELAY = 5;

//INFO_WIDTH = 352; //for JS info panel
//INFO_HEIGHT = 284;

INFO_WIDTH = 600;//484; //for LISP info panel
INFO_HEIGHT = 472;

var viv_mode = MODE_NONE;
var single_mode = false;
var frame_mode = false;
var viv_loaded = false;

var disp_column = 0;
var disp_row = 0;
var items = 0;
var disphead = 0;
var old_disphead = 0;
var focus = 0;
var old_focus = 0;
var multi_shot_sel_cnt = 0;

var zoom_anim_flag = false;
var zoom_mode = 1; // 7 x 4
var old_zoom_mode = 1;

var slideshow_repeat = false;
var start_pos = 0;
var loop_over = false;
var multi_shot_enable = false;
var scroll_anim_flag = false;
var insert_anim_flag = false;
var disp_info_flag = false;
var hide_flag = true;
var check_mark_num = 0;
var chk_key_disable_flag = false;

var dsp_viv_list = 0; 
var s = new stage ({});
var small_photo_obj = new Array ();

var base_height = 845;
var base_y_pos = 60;

var reading_pos = -1;

var key_invalid_flg = 0;

ANIM_FINISH = 10000;

disp_info = [
    //[4, 3, 360, 270, 204, 82, 24, 18], // column,row,width,height,x,y,margin_x,margin_y
    //[6, 4, 264, 198, 118, 82, 20, 18], // 0      1   2     3      4 5 6        7
    //[7, 4, 240, 180,  40, 82, 20, 18], // 0      1   2     3      4 5 6        7
    //[9, 6, 168, 126, 140, 82, 16, 18],
    [5, 3, 340, 255, 58, 78, 16, 20],
    [7, 4, 248, 186, 19, 78, 17, 20],
    [10, 6, 156, 117, 88, 78, 16, 20],
];

MAX_PHOTO_OBJ = 100;

mid_t = new Array ();
mid_ti = new Array ();

for(var i = 0; i < MAX_PHOTO_OBJ; i++)
{
    mid_t[i] = 0;
    mid_ti[i] = -1;
}

var viv_list_reload = function () {
    viv_list_clear ();
    mid_table_shift ();
}

var viv_list_clear = function () {
    disphead = 0;
    focus = 0;
    for(var i = 0; i < MAX_PHOTO_OBJ; i++)
    {
	mid_t[i] = i;
	mid_ti[i] = i;
	if(small_photo_obj[i].ptr != 0)
	{
	    small_photo_obj[i].img_id = -1; 
	    small_photo_obj[i].images[1].free_expmem(small_photo_obj[i].ptr);
	    small_photo_obj[i].ptr = 0;
	    small_photo_obj[i].mem_size = 0;
	}
	small_photo_obj[i].clearImage();
    }
    init_position();
}

var change_items = function (new_items){
    items = new_items;
    if (viv_mode == MODE_LIST)
    {
        change_scrollbar ();
        mid_table_shift ();
    }
}

// thumbnail image item
READYIMAGE = 0;
PREPAREIMAGE = 1;
NOIMAGE = 2;
CLEARIMAGE = 3;
NOIMAGE_R = 4;
STAR_PNG = "file:///usr/local/mystream/img/star.png";
var ThumbItem = function( init ,width ,height ){
    this.base = container; // inherit
    init.components = [ ];
    this.base( init );

    this.img_id = -2;
    this.img_width = 160; // actual image size
    this.img_height = 120;

    this.status = NOIMAGE;
    this.ptr = 0;
    this.mem_size = 0;

    this.start = 0; //for animation 
    this.duration = 0;
    this.ms_sel = false;
    this.icon_3d = false;
    this.check = false;
    this.favorite = false;
    this.s_translate = [0, 0, 0];
    this.e_translate = [0, 0, 0];
    this.s_color = [255, 255, 255, 255];
    this.e_color = [255, 255, 255, 255];

    this.images = [
	new gbox ({
	    "translate": [0, 0, 0],
	    "rotate": [0, 0, 0, 0],
	    //"color": [65, 83, 112, 255],//reading
	    "color": [102,99,102, 255],//reading
	    "width": width,
	    "height": height,
	    "visible_p": true,
	}),
	new gimage ({
	    "color": [255,255,255,255],
	    "translate": [0, 0, 0],
	    "rotate": [0, 0, 0, 0],
	    "width": width,
	    "height": height,
	    "src": null,
	    "visible_p": true,
	    "enable_dither": true,
	    //"draw_type": INSCRIBED,
	    "draw_type": FULL,
	}),
	new gimage ({
	    "color": [255,255,255,255],
	    "translate": [80-15, -60+6, 0],
	    "rotate": [0, 0, 0, 0],
	    "width": 60,
	    "height": 58,
	    "src":"file:///usr/local/png/ed_logo_info_L.png",
	    "visible_p": false,
	    "enable_dither": false,
	    "draw_type": INSCRIBED,
	}),
	new gimage ({
	    "color": [255,255,255,255],
	    "translate": [80-15, -60+6, 0],
	    "rotate": [0, 0, 0, 0],
	    "width": 40,
	    "height": 38,
	    "src":null,
	    "visible_p": false,
	    "enable_dither": false,
	    "draw_type": INSCRIBED,
	}),
	new gimage ({
	    "color": [255,255,255,255],
	    "translate": [80-15, -60+6, 0],
	    "rotate": [0, 0, 0, 0],
	    "width": 40,
	    "height": 38,
	    "src":null,
	    "visible_p": false,
	    "enable_dither": false,
	    "draw_type": INSCRIBED,
	}),
	new gimage ({
	    "color": [255,255,255,255],
	    "translate": [80-15, -60+6, 0],
	    "rotate": [0, 0, 0, 0],
	    "width": 35,
	    "height": 35,
	    "src":STAR_PNG,
	    "visible_p": false,
	    "enable_dither": false,
	    "draw_type": INSCRIBED,
	})];

    this.components = this.images;
}

ThumbItem.prototype.clearImage = function(){
    this.images[1].visible_p = false;
    this.images[0].visible_p = true; //bg
    this.images[0].color[0] = 17;
    this.images[0].color[1] = 22;
    this.images[0].color[2] = 31;
    this.status = CLEARIMAGE;
    this.images[2].visible_p = false;
    this.ms_sel = false;
    this.images[3].visible_p = false;
    this.icon_3d = false;
    this.images[4].visible_p = false;
    this.check = false;
    this.images[5].visible_p = false;
    this.favorite = false;
}

ThumbItem.prototype.readyImage = function(){
    this.images[1].visible_p = true;
    this.images[0].visible_p = false;
    this.status = READYIMAGE;
    //this.images[3].visible_p = false;
    //this.icon_3d = false;
}

ThumbItem.prototype.prepareImage = function(){
    this.images[1].visible_p = true;//false;
    this.images[0].visible_p = true;
    this.images[0].color[0] = 102;
    this.images[0].color[1] = 99;
    this.images[0].color[2] = 102;
    this.status = PREPAREIMAGE;
    this.images[2].visible_p = false;
    this.ms_sel = false;
    this.images[3].visible_p = false;
    this.icon_3d = false;
    this.images[4].visible_p = false;
    this.check = false;
    this.images[5].visible_p = false;
    this.favorite = false;
}

ThumbItem.prototype.noImage = function(){
    this.images[1].visible_p = false;
    this.images[0].visible_p = true;
    this.images[0].color[0] = 0;
    this.images[0].color[1] = 0;
    this.images[0].color[2] = 0;
    if(this.status == READYIMAGE || this.status == NOIMAGE_R)
    {
	this.status = NOIMAGE_R;
	this.images[2].visible_p = false;
	this.images[3].visible_p = false;
	this.images[4].visible_p = false;
	this.images[5].visible_p = false;
    }
    else
    {
	this.status = NOIMAGE;
	this.images[2].visible_p = false;
	this.ms_sel = false;
	this.images[3].visible_p = false;
	this.icon_3d = false;
	this.images[4].visible_p = false;
	this.check = false;
	this.images[5].visible_p = false;
	this.favorite = false;
    }
}

ThumbItem.prototype.delPng = function (){
    if(this.status != CLEARIMAGE && this.status != NOIMAGE && this.staus != NOIMAGE_R)
    {
      this.images[2].src = "";
    }
}

ThumbItem.prototype.changePng = function(ms_sel){
    if(this.status != CLEARIMAGE && this.status != NOIMAGE && this.staus != NOIMAGE_R)
    {
        if(ms_sel>=1)
        {
	    if (ms_sel==1)
	    {
	      this.images[2].src = "file:///usr/local/png/ed_logo_info_L.png";
	    }
	    else
	    {
	      this.images[2].src = "file:///usr/local/png/ed_logo_info_R.png";
	    }
        }
        else
        {

	    this.images[2].src = "";
        }
    }
}

ThumbItem.prototype.ms_selMark = function(ms_sel){
    if(this.status != CLEARIMAGE && this.status != NOIMAGE && this.staus != NOIMAGE_R)
    {
	this.images[2].visible_p = multi_shot_enable;
	if (ms_sel >= 1)
	{
	this.ms_sel = true;
	}
	else
	{
	this.ms_sel = false;
	}
    }
}

ThumbItem.prototype.ms_selVisible = function(){
    if(this.status == READYIMAGE)
    {
	if( this.icon_3d == true )
        {
	    this.images[2].visible_p = false;
	}
        else
	{
	    this.images[2].visible_p = true;
	}

    }
    else
    {
	this.images[2].visible_p = false;
    }
}

//////////////////////////////////////////////////////////////////////////////////////
//  check mark
///////////////////////////////////////////////////////////////////////////////////////
ThumbItem.prototype.chk_delPng = function (){
    if(this.status != CLEARIMAGE && this.status != NOIMAGE && this.staus != NOIMAGE_R)
    {
      this.images[4].src = "";
    }
}

ThumbItem.prototype.chk_changePng = function(check){
    if(this.status != CLEARIMAGE && this.status != NOIMAGE && this.staus != NOIMAGE_R)
    {
      if (check)
      {
        this.images[4].src = "file:///usr/local/png/check_on.png";
      }
      else
      {
        this.images[4].src = "file:///usr/local/png/check_off.png";
       }
    }
    else
      {
        this.images[4].src = "";
       }
}

ThumbItem.prototype.chk_selMark = function(check){
    if(this.status != CLEARIMAGE && this.status != NOIMAGE && this.staus != NOIMAGE_R)
    {
	this.images[4].visible_p = false;
	if (check)
	{
	  this.check = true;
	}
	else
	{
	  this.check = false;
	}
    }
}

ThumbItem.prototype.chk_selVisible = function(){
    if(this.status == READYIMAGE)
    {
	this.images[4].visible_p = false;

    }
    else
    {
	this.images[4].visible_p = false;
    }
}
/////////////////////////////////////////////////////////////////////////////////////



ThumbItem.prototype.setSize = function(width, height){
    this.images[0].width = width;
    this.images[0].height = height;
    this.images[1].width = width;
    this.images[1].height = height;
    this.images[2].translate[0] = parseInt(-width / 2 + this.images[2].width / 2);
    this.images[2].translate[1] = parseInt(height / 2 - this.images[2].height / 2);
    this.images[3].translate[0] = parseInt(-width / 2 + this.images[3].width * 2 / 3);
    this.images[3].translate[1] = parseInt(-height / 2 + this.images[3].height * 2 / 3);
    this.images[4].translate[0] = parseInt(-width / 2 + this.images[4].width / 2);
    this.images[4].translate[1] = parseInt(height / 2 - this.images[4].height / 2);
    this.images[5].translate[0] = parseInt(width / 2 - this.images[5].width / 2 - 5);
    this.images[5].translate[1] = parseInt(-height / 2 + this.images[5].height / 2 + 5);
}

ThumbItem.prototype.setAnim = function(start, duration, s_translate, e_translate, s_color, e_color){
    this.start = start;
    this.duration = duration;
    this.s_translate[0] = s_translate[0];
    this.s_translate[1] = s_translate[1];
    this.s_translate[2] = s_translate[2];
    //    this.s_translate = s_translate;
    this.e_translate[0] = e_translate[0];
    this.e_translate[1] = e_translate[1];
    this.e_translate[2] = e_translate[2];
    //    this.e_translate = e_translate;
    this.s_color[0] = s_color[0];
    this.s_color[1] = s_color[1];
    this.s_color[2] = s_color[2];
    this.s_color[3] = s_color[3];
    //    this.s_color = s_color;
    this.e_color[0] = e_color[0];
    this.e_color[1] = e_color[1];
    this.e_color[2] = e_color[2];
    this.e_color[3] = e_color[3];
    //    this.e_color = e_color;
}

ThumbItem.prototype.anim = function(count){
    if(this.duration == 0)
    {
	return true; // do nothing finish animation
    }
    if(count == 0)
    {
	//this.translate = this.s_translate;
	this.translate[0] = this.s_translate[0];
	this.translate[1] = this.s_translate[1];
	this.translate[2] = this.s_translate[2];
	this.images[0].color[3] = this.s_color[3];
	this.images[1].color[3] = this.s_color[3];
	this.images[2].color[3] = this.s_color[3];
	this.images[3].color[3] = this.s_color[3];
	this.images[4].color[3] = this.s_color[3];
	this.images[5].color[3] = this.s_color[3];
	return false;
    }
    if(this.start + this.duration <= count)// || count == ANIM_FINISH)
    {
	//this.translate = this.e_translate;
	this.translate[0] = this.e_translate[0];
	this.translate[1] = this.e_translate[1];
	this.translate[2] = this.e_translate[2];
	this.images[0].color[3] = this.e_color[3];
	this.images[1].color[3] = this.e_color[3];
	this.images[2].color[3] = this.e_color[3];
	this.images[3].color[3] = this.e_color[3];
	this.images[4].color[3] = this.e_color[3];
	this.images[5].color[3] = this.e_color[3];
	return true; // finish animation
    }

    var progress = (count - this.start) / this.duration;

    this.images[0].color[3] = this.s_color[3] + parseInt((this.e_color[3] - this.s_color[3]) * progress);
    this.images[1].color[3] = this.s_color[3] + parseInt((this.e_color[3] - this.s_color[3]) * progress);
    this.images[2].color[3] = this.s_color[3] + parseInt((this.e_color[3] - this.s_color[3]) * progress);
    this.images[3].color[3] = this.s_color[3] + parseInt((this.e_color[3] - this.s_color[3]) * progress);
    this.images[4].color[3] = this.s_color[3] + parseInt((this.e_color[3] - this.s_color[3]) * progress);
    this.images[5].color[3] = this.s_color[3] + parseInt((this.e_color[3] - this.s_color[3]) * progress);

    this.translate[0] = this.s_translate[0] + parseInt((this.e_translate[0] - this.s_translate[0]) * progress);
    this.translate[1] = this.s_translate[1] + parseInt((this.e_translate[1] - this.s_translate[1]) * progress);
    this.translate[2] = this.s_translate[2] + parseInt((this.e_translate[2] - this.s_translate[2]) * progress);

    return false;
}

var object_set = function (){
    base_obj = 
	new container ({
	    "translate": [-960, 540, 0],
	    "rotation": [0, 0, 0, 0],
	    "components":[ 
		new gbox({
		    "translate":[960, -540 + base_y_pos, 0],
		    "rotation": [0, 0, 0, 0],
		    "width": 1920,
		    "height": base_height,
		    "color_enable": true,
		    "color": [50, 50, 50, 255],
		}),
/*
		new gimage({
		    "translate": [1887, -(91 + 7), 0],
		    "rotation": [0, 0, 0, 0],
		    "width": 26,
		    "height": 16,
		    "src":"file:///usr/local/png/viv_scroll_arrow.png",
		    "visible_p": true,
		    "draw_type": DIRECT,
		}),
		new gimage({
		    "translate": [1887, -(870 + 7), 0],
		    "rotation": [180, 0, 0, 1],
		    "width": 26,
		    "height": 16,
		    "src":"file:///usr/local/png/viv_scroll_arrow.png",
		    "visible_p": true,
		    "draw_type": DIRECT,
		}),
*/
	    ],
	    "visible_p": true,
	});

    black_base_obj = 
	new container ({
	    "translate": [-960, 540, 100],
	    "rotation": [0, 0, 0, 0],
	    "components":[ 
		new gbox({
		    "translate":[960, -540, 0],
		    "rotation": [0, 0, 0, 0],
		    "width": 1920,
		    "height": 1080,
		    "color_enable": true,
		    "color": [0, 0, 0, 255],
		}),
	    ],
	    "visible_p": true,
	});

    scroll_cover_obj = 
	new container ({
	    "translate": [-960, 540, 0],
	    "rotation": [0, 0, 0, 0],
	    "components":[ 
		new gbox({
		    "translate":[960, -540 + 540 - 28, 0],
		    "rotation": [0, 0, 0, 0],
		    "width": 1920,
		    "height": 59,
		    "color_enable": true,
		    "color": [0, 0, 0, 180],
		}),
		new gbox({
		    "translate":[960, -540 - 540 + 88, 0],
		    "rotation": [0, 0, 0, 0],
		    "width": 1920,
		    "height": 180,//1080-60-845,//1080,
		    "color_enable": true,
		    "color": [0, 0, 0, 180],
		}),
	    ],
	    "visible_p": true,
	});

    focus_obj = 
	new ThumbItem(
	    {"translate":[0, 0, 0],},
	    disp_info[zoom_mode][2],
	    disp_info[zoom_mode][3]
	);

    focus_obj.images[1].src = "file:///usr/local/png/photo_list_focus.png";
    focus_obj.images[1].draw_type = DIRECT;
    focus_obj.readyImage();

    scroll_bar_obj =
	new gbox({
	    "translate":[-960 + 1887, 540 - 200, 0], // y:tmp
	    "rotation": [0, 0, 0, 0],
	    "width": 10,
	    "height": 100, // tmp
	    "color_enable": true,
	    "color": [192, 192, 192, 255],
	});

    for(var i  = 0; i < MAX_PHOTO_OBJ ; i++)
    {
	small_photo_obj[i] = new ThumbItem(
	    {"translate":[0, 0, 0],},
	    disp_info[zoom_mode][2],
	    disp_info[zoom_mode][3]
	);
	small_photo_obj[i].prepareImage();
	small_photo_obj[i].images[1].enable_expmem = true;
	small_photo_obj[i].id = i;
	mid_t[i] = i;
    }

    thumb_base_obj = 
	new container ({
	    "translate": [-960, 540, 0],
	    "rotation": [0, 0, 0, 0],
	    "components":[ 
		small_photo_obj[0],
		small_photo_obj[1],
		small_photo_obj[2],
		small_photo_obj[3],
		small_photo_obj[4],
		small_photo_obj[5],
		small_photo_obj[6],
		small_photo_obj[7],
		small_photo_obj[8],
		small_photo_obj[9],
		small_photo_obj[10],
		small_photo_obj[11],
		small_photo_obj[12],
		small_photo_obj[13],
		small_photo_obj[14],
		small_photo_obj[15],
		small_photo_obj[16],
		small_photo_obj[17],
		small_photo_obj[18],
		small_photo_obj[19],
		small_photo_obj[20],
		small_photo_obj[21],
		small_photo_obj[22],
		small_photo_obj[23],
		small_photo_obj[24],
		small_photo_obj[25],
		small_photo_obj[26],
		small_photo_obj[27],
		small_photo_obj[28],
		small_photo_obj[29],
		small_photo_obj[30],
		small_photo_obj[31],
		small_photo_obj[32],
		small_photo_obj[33],
		small_photo_obj[34],
		small_photo_obj[35],
		small_photo_obj[36],
		small_photo_obj[37],
		small_photo_obj[38],
		small_photo_obj[39],
		small_photo_obj[40],
		small_photo_obj[41],
		small_photo_obj[42],
		small_photo_obj[43],
		small_photo_obj[44],
		small_photo_obj[45],
		small_photo_obj[46],
		small_photo_obj[47],
		small_photo_obj[48],
		small_photo_obj[49],
		small_photo_obj[50],
		small_photo_obj[51],
		small_photo_obj[52],
		small_photo_obj[53],
		small_photo_obj[54],
		small_photo_obj[55],
		small_photo_obj[56],
		small_photo_obj[57],
		small_photo_obj[58],
		small_photo_obj[59],
		small_photo_obj[60],
		small_photo_obj[61],
		small_photo_obj[62],
		small_photo_obj[63],
		small_photo_obj[64],
		small_photo_obj[65],
		small_photo_obj[66],
		small_photo_obj[67],
		small_photo_obj[68],
		small_photo_obj[69],
		small_photo_obj[70],
		small_photo_obj[71],
		small_photo_obj[72],
		small_photo_obj[73],
		small_photo_obj[74],
		small_photo_obj[75],
		small_photo_obj[76],
		small_photo_obj[77],
		small_photo_obj[78],
		small_photo_obj[79],
		small_photo_obj[80],
		small_photo_obj[81],
		small_photo_obj[82],
		small_photo_obj[83],
		small_photo_obj[84],
		small_photo_obj[85],
		small_photo_obj[86],
		small_photo_obj[87],
		small_photo_obj[88],
		small_photo_obj[89],
		small_photo_obj[90],
		small_photo_obj[91],
		small_photo_obj[92],
		small_photo_obj[93],
		small_photo_obj[94],
		small_photo_obj[95],
		small_photo_obj[96],
		small_photo_obj[97],
		small_photo_obj[98],
		small_photo_obj[99],
	    ],
	    "visible_p": true,
	});

    INFO_FONT = 35;
    info_obj = 
	new container ({
	    "translate": [-960, 540, 0],
	    "rotation": [0, 0, 0, 0],
	    "components":[ 
		new gimage({
		    "translate": [0, 0, 0],
		    "rotation": [0, 0, 0, 0],
		    "src":"file:///usr/local/png/mp_info_lda2_pop.png",
		    "width": INFO_WIDTH,
		    "height": INFO_HEIGHT,
		    "visible_p": true,
		    "draw_type": DIRECT,
		}),
		new gtext ({
		    "translate": [0, INFO_HEIGHT/2 - INFO_FONT * 1, 0],
		    "rotation": [0, 0, 0, 0],
		    "color": [255, 255, 255, 255],
		    "width": INFO_WIDTH - 30,
		    "text": "",
		    "align": RIGHT,
		    "font_size": INFO_FONT,
		    "font_name": info_font_name[viv_area],
		    "visible_p": true,
		    "margin": [0,0,10,0],
		}),
		new gtext ({
		    "translate": [0, INFO_HEIGHT/2 - INFO_FONT * 2, 0],
		    "rotation": [0, 0, 0, 0],
		    "color": [200, 200, 200, 255],
		    "width": INFO_WIDTH - 30,
		    "text": "File name",
		    "align": LEFT,
		    "font_size": INFO_FONT - 5,
		    "font_name": info_font_name[viv_area],
		    "visible_p": true,
		    "margin": [0,0,10,0],
		}),
		new gtext ({
		    "translate": [0, INFO_HEIGHT/2 - INFO_FONT * 3, 0],
		    "rotation": [0, 0, 0, 0],
		    "color": [255, 255, 255, 255],
		    "width": INFO_WIDTH - 30,
		    "text": "",
		    "align": RIGHT,
		    "font_size": INFO_FONT,
		    "font_name": info_font_name[viv_area],
		    "visible_p": true,
		    "margin": [0,0,10,0],
		}),
		new gtext ({
		    "translate": [0, INFO_HEIGHT/2 - INFO_FONT * 4, 0],
		    "rotation": [0, 0, 0, 0],
		    "color": [200, 200, 200, 255],
		    "width": INFO_WIDTH - 30,
		    "text": "Date",
		    "align": LEFT,
		    "font_size": INFO_FONT - 5,
		    "font_name": info_font_name[viv_area],
		    "visible_p": true,
		    "margin": [0,0,10,0],
		}),
		new gtext ({
		    "translate": [0, INFO_HEIGHT/2 - INFO_FONT * 5, 0],
		    "rotation": [0, 0, 0, 0],
		    "color": [255, 255, 255, 255],
		    "width": INFO_WIDTH - 30,
		    "text": "",
		    "align": RIGHT,
		    "font_size": INFO_FONT,
		    "font_name": info_font_name[viv_area],
		    "visible_p": true,
		    "margin": [0,0,10,0],
		}),
		new gtext ({
		    "translate": [0, INFO_HEIGHT/2 - INFO_FONT * 6, 0],
		    "rotation": [0, 0, 0, 0],
		    "color": [200, 200, 200, 255],
		    "width": INFO_WIDTH - 30,
		    "text": "Pixel",
		    "align": LEFT,
		    "font_size": INFO_FONT - 5,
		    "font_name": info_font_name[viv_area],
		    "visible_p": true,
		    "margin": [0,0,10,0],
		}),
		new gtext ({
		    "translate": [0, INFO_HEIGHT/2 - INFO_FONT * 7, 0],
		    "rotation": [0, 0, 0, 0],
		    "color": [255, 255, 255, 255],
		    "width": INFO_WIDTH - 30,
		    "text": "",
		    "align": RIGHT,
		    "font_size": INFO_FONT,
		    "font_name": info_font_name[viv_area],
		    "visible_p": true,
		    "margin": [0,0,10,0],
		}),
	    ],
	    "visible_p": true,
	});
}

var base_obj_reset = function ()
{
    s.components[4] = 0;
    base_obj.components[0].height = base_height;
}

function disp_infomation ()
{
    disp_info_flag = true;
    if(focus_obj.translate[0] > 0)
    {
	info_obj.translate[0] = focus_obj.translate[0] - (disp_info[zoom_mode][2] + INFO_WIDTH) / 2 - 10;
    }
    else
    {
	info_obj.translate[0] = focus_obj.translate[0] + (disp_info[zoom_mode][2] + INFO_WIDTH) / 2 + 10;
    }
    if(focus_obj.translate[1] > 0)
    {
	info_obj.translate[1] = focus_obj.translate[1] - (-disp_info[zoom_mode][3] + INFO_HEIGHT) / 2;
    }
    else
    {
	info_obj.translate[1] = focus_obj.translate[1] + (-disp_info[zoom_mode][3] + INFO_HEIGHT) / 2;
    }
    setf_text(info_obj.components[1], String(focus+1)+"/"+String(items));

    s.components[4] = info_obj;
    force_redraw();
}

var reading = false;
function read_image()
{
    reading = true;
    if(small_photo_obj[mid_t[focus - disphead]].status == PREPAREIMAGE)
    {
	ptr = small_photo_obj[mid_t[focus - disphead]].images[1].alloc_expmem (small_photo_obj[mid_t[focus - disphead]].img_width,
								small_photo_obj[mid_t[focus - disphead]].img_height,
								RGBA8888_BLOCK);
	write_back_bytes2 (10, [ptr[0],
				small_photo_obj[mid_t[focus - disphead]].img_width,
				small_photo_obj[mid_t[focus - disphead]].img_height,
				mid_ti[focus - disphead], mid_t[focus - disphead],
				ptr[1] * ptr[2] * 4]);
	reading_pos = mid_ti[focus - disphead];
	small_photo_obj[mid_t[focus - disphead]].img_id = mid_ti[focus - disphead];
	small_photo_obj[mid_t[focus - disphead]].ptr = ptr[0]; 
	small_photo_obj[mid_t[focus - disphead]].mem_size = ptr[1] * ptr[2] * 4; 
	return;
    }
    for (var i = 0 ; i < MAX_PHOTO_OBJ; i++)
    {
	if(small_photo_obj[mid_t[i]].status == PREPAREIMAGE)
	{
	    ptr = small_photo_obj[mid_t[i]].images[1].alloc_expmem (small_photo_obj[mid_t[i]].img_width,
								    small_photo_obj[mid_t[i]].img_height,
								    RGBA8888_BLOCK);
	    write_back_bytes2 (10, [ptr[0],
				    small_photo_obj[mid_t[i]].img_width,
				    small_photo_obj[mid_t[i]].img_height,
				    mid_ti[i], mid_t[i], ptr[1] * ptr[2] * 4]);
	    reading_pos = mid_ti[i];
	    small_photo_obj[mid_t[i]].img_id = mid_ti[i];
	    small_photo_obj[mid_t[i]].ptr = ptr[0]; 
	    small_photo_obj[mid_t[i]].mem_size = ptr[1] * ptr[2] * 4; 
	    return;
	}
    }
    reading = false;
    write_back_bytes2 (31, [0]);
}

function ready_image (num,mode,pos,ms_sel,mode_3d,check,favorite)
{
    if(hide_flag)
    {
	return;
    }
    if(viv_mode != mode)
    {
	return;
    }
    switch(mode)
    {
    case MODE_LIST:
	if(pos >= disphead && pos < disphead + MAX_PHOTO_OBJ)
	    {
		if(small_photo_obj[num].ptr != 0)
		{
		    small_photo_obj[num].images[1].ready_expmem (small_photo_obj[num].ptr);
		    small_photo_obj[num].readyImage();
		    if (mode_3d)
			{
			    small_photo_obj[num].images[3].src = "file:///usr/local/png/ed_logo_info_a.png";
			    small_photo_obj[num].images[3].visible_p = true;
			    small_photo_obj[num].icon_3d = true;
			}
		    else
			{
			    small_photo_obj[num].images[3].visible_p = false;
			    small_photo_obj[num].icon_3d = false;
			}
		    if(multi_shot_enable)
                    {
	                small_photo_obj[num].changePng(ms_sel);
	                small_photo_obj[num].ms_selMark(ms_sel);
	                small_photo_obj[num].ms_selVisible();
                    }
		    if(favorite)
		      {
			  small_photo_obj[num].images[5].src = STAR_PNG;
			  small_photo_obj[num].images[5].visible_p = true;
			  small_photo_obj[num].favorite = true;
		      }
		    else
		      {
			  small_photo_obj[num].images[5].visible_p = false;
			  small_photo_obj[num].favorite = false;
		      }
		    read_image();
		}
	    }
	break;
    case MODE_FLOWFRAME:
	if (frame_mode == true)
	{
	    flowframe_load_image(0, 0, num);
	}
	break;
    case MODE_WALLFRAME:
	if (frame_mode == true)
	{
	    wallframe_load_image(num);
	}
	break;
    case MODE_CINEMAFRAME:
	if (frame_mode == true)
	{
	    read_cinema_picture(num);
	}
	break;
    default:
	break;
    }
}

function mid_table_shift ()
{
    var count;
    
    count = disphead % MAX_PHOTO_OBJ; 
    if(reading_pos < disphead || reading_pos >= disphead + MAX_PHOTO_OBJ)
    {
	write_back_bytes2 (11, [0]);
	reading = false;
    }
	
    for (var i = 0 ; i < MAX_PHOTO_OBJ; i++)
    {
	mid_t[i] = count;
	mid_ti[i] = disphead + i;
	if(mid_ti[i] >= items)
	{
	    small_photo_obj[mid_t[i]].noImage();
	}
	else
	{
	    if(mid_ti[i] != small_photo_obj[mid_t[i]].img_id)
	    {
		if(small_photo_obj[mid_t[i]].ptr != 0)
		{
		    small_photo_obj[mid_t[i]].images[1].free_expmem(small_photo_obj[mid_t[i]].ptr);
		    small_photo_obj[mid_t[i]].ptr = 0;
		    small_photo_obj[mid_t[i]].mem_size = 0;
		}
		small_photo_obj[mid_t[i]].prepareImage();
	    }
	    else
	    {
		if(small_photo_obj[mid_t[i]].status == NOIMAGE || small_photo_obj[mid_t[i]].status == CLEARIMAGE)
		{
		    if(small_photo_obj[mid_t[i]].ptr != 0)
		    {
			small_photo_obj[mid_t[i]].images[1].free_expmem(small_photo_obj[mid_t[i]].ptr);
			small_photo_obj[mid_t[i]].ptr = 0;
			small_photo_obj[mid_t[i]].mem_size = 0;
		    }
		    small_photo_obj[mid_t[i]].prepareImage();
		}
		else if(small_photo_obj[mid_t[i]].status == NOIMAGE_R)
		{
		    if (small_photo_obj[mid_t[i]].icon_3d == true)
			{
			    small_photo_obj[mid_t[i]].images[3].visible_p = true;
			    small_photo_obj[mid_t[i]].images[2].visible_p = false;
			}
		    else
			{
			    small_photo_obj[mid_t[i]].images[3].visible_p = false;
 			    if(multi_shot_enable)
                             {
 		                small_photo_obj[mid_t[i]].images[2].visible_p = true;
                             }
			}

		    small_photo_obj[mid_t[i]].images[4].visible_p = false;
		    if (small_photo_obj[mid_t[i]].favorite == true)
		    {
			small_photo_obj[mid_t[i]].images[5].visible_p = true;
		    }
		    else
		    {
			small_photo_obj[mid_t[i]].images[5].visible_p = false;
		    }
		    small_photo_obj[mid_t[i]].readyImage();
		}
	    }
	}
	count++;
	if(count >= MAX_PHOTO_OBJ)
	{
	    count = 0;
	}
    }
    if(reading == false)
	read_image();
}

function init_position () {
    var focus_column1 = (focus - disphead) % disp_column;
    var focus_row1 = parseInt((focus - disphead) / disp_column);
    var x1 = -960 +disp_info[zoom_mode][4] + (disp_info[zoom_mode][2]+disp_info[zoom_mode][6]) * focus_column1 + disp_info[zoom_mode][2]/2;
    var y1 = 540 -(disp_info[zoom_mode][5] + (disp_info[zoom_mode][3]+disp_info[zoom_mode][7]) * focus_row1 + disp_info[zoom_mode][3]/2);
    focus_obj.translate[0] = x1; 
    focus_obj.translate[1] = y1; 
    focus_obj.setSize(parseInt(disp_info[zoom_mode][2] * 1.1),parseInt(disp_info[zoom_mode][3] * 1.1));

    for(var i = 0; i <  disp_row ; i++)
    {
	for(var j = 0; j < disp_column; j++)
	{
	    var x = disp_info[zoom_mode][4]
		+ (disp_info[zoom_mode][2]+disp_info[zoom_mode][6]) * j + disp_info[zoom_mode][2]/2;
	    var y = -(disp_info[zoom_mode][5]
		      + (disp_info[zoom_mode][3]+disp_info[zoom_mode][7]) * i + disp_info[zoom_mode][3]/2);

	    small_photo_obj[mid_t[i*disp_column + j]].translate = [x,y,0];
	    small_photo_obj[mid_t[i*disp_column + j]].setSize(disp_info[zoom_mode][2],disp_info[zoom_mode][3]);
	}
    }
    out_position ();
    change_scrollbar ();
    force_redraw ();
}

function out_position () {
    for(var k = disp_column*disp_row; k <  MAX_PHOTO_OBJ; k++)
    {
	small_photo_obj[mid_t[k]].translate = [-1000,0,0];
	small_photo_obj[mid_t[k]].setSize(disp_info[zoom_mode][2],disp_info[zoom_mode][3]);
	small_photo_obj[mid_t[k]].setAnim(0, 0, [-1000,0,0], [-1000,0,0],
					  [255,255,255,255], [255,255,255,255]);
    }
}

function out_position2 () { // extra lines for scroll : disp_row + 1
    for(var k = disp_column*(disp_row + 1); k <  MAX_PHOTO_OBJ; k++)
    {
	small_photo_obj[mid_t[k]].translate = [-1000,0,0];
	small_photo_obj[mid_t[k]].setSize(disp_info[zoom_mode][2],disp_info[zoom_mode][3]);
	small_photo_obj[mid_t[k]].setAnim(0, 0, [-1000,0,0], [-1000,0,0],
					  [255,255,255,255], [255,255,255,255]);
    }
}

function focus_anim () {
    var focus_column1 = (old_focus - disphead) % disp_column;
    var focus_row1 = parseInt((old_focus - disphead) / disp_column);
    var focus_column2 = (focus - disphead) % disp_column;
    var focus_row2 = parseInt((focus - disphead) / disp_column);
    
    var x1 = -960 +disp_info[zoom_mode][4] + (disp_info[zoom_mode][2]+disp_info[zoom_mode][6]) * focus_column1 + disp_info[zoom_mode][2]/2;
    var y1 = 540 -(disp_info[zoom_mode][5] + (disp_info[zoom_mode][3]+disp_info[zoom_mode][7]) * focus_row1 + disp_info[zoom_mode][3]/2);
    var x2 = -960 + disp_info[zoom_mode][4] + (disp_info[zoom_mode][2]+disp_info[zoom_mode][6]) * focus_column2 + disp_info[zoom_mode][2]/2;
    var y2 = 540 -(disp_info[zoom_mode][5] + (disp_info[zoom_mode][3]+disp_info[zoom_mode][7]) * focus_row2 + disp_info[zoom_mode][3]/2);
    
    focus_obj.setAnim(0, 3, [x1,y1,0], [x2,y2,0],
		      [255,255,255,255], [255,255,255,255]);
    
    append_timer (this, 50, focus_anim_timer_hook);
}

var focus_anim_timer_hook = function (obj, count){
    
    var finish_flag = focus_obj.anim(count);
    
    force_redraw ();
    
    if(finish_flag == true)
    {
	base_obj_reset ();
	delete_timer (obj);      
    }
}

var focus_anim_finish = function (){
    base_obj_reset ();
    focus_obj.anim(ANIM_FINISH);
    force_redraw ();
}

function zoom_anim_f1 () {
    for(var i = 0; i <  disp_row; i++)
    {
	for(var j = 0; j < disp_column; j++)
	{
	    var x = disp_info[old_zoom_mode][4]
		+ (disp_info[old_zoom_mode][2]+disp_info[old_zoom_mode][6]) * j + disp_info[old_zoom_mode][2]/2;
	    var y = -(disp_info[old_zoom_mode][5]
		      + (disp_info[old_zoom_mode][3]+disp_info[old_zoom_mode][7]) * i + disp_info[old_zoom_mode][3]/2);

	    small_photo_obj[mid_t[i*disp_column + j]].translate[0] = x;
	    small_photo_obj[mid_t[i*disp_column + j]].translate[1] = y;

	    if(focus - old_disphead != i*disp_column + j)
	    {
		small_photo_obj[mid_t[i*disp_column + j]].setAnim(1, 7, [x,y,0], [x,y,0], [255,255,255,255], [255,255,255,0]);
	    }
	}
    }

    var focus_column1 = (focus - old_disphead) % disp_info[old_zoom_mode][0];
    var focus_row1 = parseInt((focus - old_disphead) / disp_info[old_zoom_mode][0]);
    var focus_column2 = (focus - disphead) % disp_info[zoom_mode][0];
    var focus_row2 = parseInt((focus - disphead) / disp_info[zoom_mode][0]);
    var x1 = -960 +disp_info[old_zoom_mode][4] + (disp_info[old_zoom_mode][2]+disp_info[old_zoom_mode][6]) * focus_column1 + disp_info[old_zoom_mode][2]/2;
    var y1 = 540 -(disp_info[old_zoom_mode][5] + (disp_info[old_zoom_mode][3]+disp_info[old_zoom_mode][7]) * focus_row1 + disp_info[old_zoom_mode][3]/2);
    var x2 = -960 + disp_info[zoom_mode][4] + (disp_info[zoom_mode][2]+disp_info[zoom_mode][6]) * focus_column2 + disp_info[zoom_mode][2]/2;
    var y2 = 540 -(disp_info[zoom_mode][5] + (disp_info[zoom_mode][3]+disp_info[zoom_mode][7]) * focus_row2 + disp_info[zoom_mode][3]/2);
    focus_obj.setAnim(1, 4, [x1,y1,0], [x2,y2,0],
		      [255,255,255,255], [255,255,255,255]);
    small_photo_obj[mid_t[focus-old_disphead]].setAnim(1, 4, [x1+960,y1-540,0], [x2+960,y2-540,0], [255,255,255,255], [255,255,255,255]);

    append_timer (this, 50, zoom_anim_f1_timer_hook);
}

var zoom_anim_f1_timer_hook = function (obj, count){
    var finish_flag = true;
    var flag = false;
    for(var i = 0; i <  disp_row; i++)
    {
	for(var j = 0; j < disp_column; j++)
	{
	    flag = small_photo_obj[mid_t[i*disp_column + j]].anim(count);
	    if(flag == false)
	    {
		finish_flag = false;
	    }
	}
    }

    focus_obj.anim(count);

    force_redraw ();
    
    if(finish_flag == true)
    {
	delete_timer (obj);      
	zoom_anim_f2 ();
    }
}

function zoom_anim_f2 () {
    disp_column = disp_info[zoom_mode][0];
    disp_row = disp_info[zoom_mode][1];
    change_scrollbar ();
    mid_table_shift ();
    out_position ();

    var x1;
    var y1;
    var x2;
    var y2;
    var f1;
    var delay;
    var base_line;

    for(var i = 0; i <  disp_row; i++)
    {
	for(var j = 0; j < disp_column; j++)
	{
	    small_photo_obj[mid_t[i*disp_column + j]].setSize(disp_info[zoom_mode][2],disp_info[zoom_mode][3]);

	    base_line = parseInt((focus - disphead) / disp_column);

	    if(base_line < i)
	    {
		delay = (i - base_line) * 4;
		x1 = disp_info[zoom_mode][4] + disp_info[zoom_mode][2]/2;
	    }
	    else if(base_line > i)
	    {
		delay = (base_line - i) * 4;
		x1 = disp_info[zoom_mode][4] + (disp_info[zoom_mode][2]+disp_info[zoom_mode][6]) * (disp_column - 1) + disp_info[zoom_mode][2]/2;
	    }
	    else
	    {
		delay = 0; 
		f1 = (focus - disphead) % disp_column;
		x1 = disp_info[zoom_mode][4] + (disp_info[zoom_mode][2]+disp_info[zoom_mode][6]) * f1 + disp_info[zoom_mode][2]/2;
	    }

	    y1 = -(disp_info[zoom_mode][5] + (disp_info[zoom_mode][3]+disp_info[zoom_mode][7]) * i + disp_info[zoom_mode][3]/2);
	    x2 = disp_info[zoom_mode][4] + (disp_info[zoom_mode][2]+disp_info[zoom_mode][6]) * j + disp_info[zoom_mode][2]/2;
	    y2 = y1;

	    if(focus - disphead != i*disp_column + j)
	    {
		small_photo_obj[mid_t[i*disp_column + j]].setAnim(delay + 1 + (i*disp_column + j) / ZOOM_SPEED, delay + ZOOM_DELAY + (i*disp_column + j) / ZOOM_SPEED,
								  [x1,y1,0], [x2,y2,0], [255,255,255,0], [255,255,255,255]);
	    }
	    else
	    {
		small_photo_obj[mid_t[i*disp_column + j]].setAnim(delay + 1 + (i*disp_column + j) / ZOOM_SPEED, delay + ZOOM_DELAY + (i*disp_column + j) / ZOOM_SPEED,
								  [x1,y1,0], [x2,y2,0], [255,255,255,255], [255,255,255,255]);
	    }
	}
    }

    focus_obj.setSize(parseInt(disp_info[zoom_mode][2] * 1.1),parseInt(disp_info[zoom_mode][3] * 1.1));

    append_timer (this, 50, zoom_anim_f2_timer_hook);
}

var zoom_anim_f2_timer_hook = function (obj, count){
    var finish_flag = true;
    var flag;
    for(var i = 0; i <  disp_row; i++)
    {
	for(var j = 0; j < disp_column; j++)
	{
	    flag = small_photo_obj[mid_t[i*disp_column + j]].anim(count);
	    if(flag == false)
	    {
		finish_flag = false;
	    }
	}
    }
    
    force_redraw ();
    
    if(finish_flag == true)
    {
	for(var k = 0; k < MAX_PHOTO_OBJ; k++)
	{
	    small_photo_obj[k].images[0].color[3] = 255;
            small_photo_obj[k].images[1].color[3] = 255;
            small_photo_obj[k].images[2].color[3] = 255;
            small_photo_obj[k].images[3].color[3] = 255;
            small_photo_obj[k].images[4].color[3] = 255;
            small_photo_obj[k].images[5].color[3] = 255;
	}

	base_obj_reset ();
	zoom_anim_flag = false;
	delete_timer (obj);      
    }
}

var anim_finish = function (){
    for(var i = 0; i <  disp_row + 1; i++)
    {
	for(var j = 0; j < disp_column; j++)
	{
	    small_photo_obj[mid_t[i*disp_column + j]].anim(ANIM_FINISH);
	}
    }
    
    base_obj_reset ();
    mid_table_shift();
    out_position ();
    force_redraw ();
    
    focus_anim_finish ();

    for(var i = 0; i <  MAX_PHOTO_OBJ; i++)
    {
	small_photo_obj[i].duration = 0;
    }

    zoom_anim_flag = false;
    scroll_anim_flag = false;
}

SCROLL_LINE_UP = 0;
SCROLL_LINE_UP2 = 5;
SCROLL_LINE_DOWN = 1;
SCROLL_FULL_UP = 2;
SCROLL_FULL_DOWN = 3;
SCROLL_STAY = 4;

function scroll_anim () {
    var x1;
    var y1;
    var y2;
    var mode;

    s.components[4] = scroll_cover_obj;
    //base_obj.components[0].height = 3000;

    if(old_disphead + disp_column == disphead)
    {
	mode = SCROLL_LINE_UP;
    }
    else if(old_disphead - disp_column == disphead )
    {
	mode = SCROLL_LINE_DOWN;
    }
    else if(old_disphead > disphead )
    {
	mode = SCROLL_FULL_DOWN;
    }
    else if(old_disphead < disphead )
    {
	mode = SCROLL_FULL_UP;
    }
    else
    {
	mode = SCROLL_STAY;
    }
    
    for(var i = 0; i <	disp_row + 1; i++)
    {
	for(var j = 0; j < disp_column; j++)
	{
	    x1 = disp_info[zoom_mode][4] + (disp_info[zoom_mode][2]+disp_info[zoom_mode][6]) * j + disp_info[zoom_mode][2]/2;
	    y2 = -(disp_info[zoom_mode][5] + (disp_info[zoom_mode][3]+disp_info[zoom_mode][7]) * i + disp_info[zoom_mode][3]/2);

	    switch(mode)
	    {
	    case SCROLL_LINE_UP:
		y1 = -(disp_info[zoom_mode][5] + (disp_info[zoom_mode][3]+disp_info[zoom_mode][7]) * i + disp_info[zoom_mode][3]/2);
		y2 = -(disp_info[zoom_mode][5] + (disp_info[zoom_mode][3]+disp_info[zoom_mode][7]) * (i - 1) + disp_info[zoom_mode][3]/2);
		break;
	    case SCROLL_LINE_DOWN:
		y1 = -(disp_info[zoom_mode][5] + (disp_info[zoom_mode][3]+disp_info[zoom_mode][7]) * (i - 1) + disp_info[zoom_mode][3]/2);
		break;
	    case SCROLL_FULL_UP:
		y1 = 1080 + y2;
		break;
	    case SCROLL_FULL_DOWN:
		y1 = -1080 + y2;
		break;
	    case SCROLL_STAY:
		y1 = y2;
		break;
	    default:
		y1 = 0;
	    }
	    
	    small_photo_obj[mid_t[i*disp_column + j]].setAnim(1,5, [x1,y1,0], [x1,y2,0], [255,255,255,255], [255,255,255,255]);
	}
    }
    
    append_timer (this, 50, scroll_anim_timer_hook);
}

var scroll_anim_timer_hook = function (obj, count){
    var finish_flag = true;
    var flag;
    for(var i = 0; i <	disp_row + 1; i++)
    {
	for(var j = 0; j < disp_column; j++)
	{
	    flag = small_photo_obj[mid_t[i*disp_column + j]].anim(count);
	    if(flag == false)
	    {
		finish_flag = false;
	    }
	}
    }

    force_redraw ();
    
    if(finish_flag == true)
    {
	scroll_anim_flag = false;
	delete_timer (obj);	 
	mid_table_shift();
	out_position ();
	base_obj_reset ();
	force_redraw ();
    }
}

TOP_OF_BAR = 80;;
MAX_BAR_LENGTH = 802;

function change_scrollbar () {
    var total_lines;

    total_lines = parseInt(items / disp_column);
    if(items % disp_column > 0)
	{
	    total_lines++;
	}

    if(disp_column * disp_row >= items)
    {
	scroll_bar_obj.height = MAX_BAR_LENGTH;
    }
    else
    {
//	scroll_bar_obj.height = parseInt((disp_column * disp_row) * MAX_BAR_LENGTH / items );
//	scroll_bar_obj.height = parseInt(disp_row / parseInt((items + disp_column - 1) / disp_column) * MAX_BAR_LENGTH);
	scroll_bar_obj.height = parseInt(disp_row * MAX_BAR_LENGTH / total_lines);
	if(scroll_bar_obj.height < 5)
	    {
		scroll_bar_obj.height = 4;
	    }
    }
    scroll_bar_obj.translate[1] = 540 - parseInt( TOP_OF_BAR
						  + (disphead / disp_column / total_lines) * MAX_BAR_LENGTH
						  + scroll_bar_obj.height / 2);
}

function multishoot_3d_key_func (focus) {
    if(small_photo_obj[mid_t[focus - disphead]].status == READYIMAGE)
    {
 	if(small_photo_obj[mid_t[focus - disphead]].ms_sel == false)
 	{
 	    if (multi_shot_sel_cnt >= 2)
	    {
		write_back_bytes2 (52, [27,0,0,focus,0,multi_shot_sel_cnt]);
 		return;
	    }
	    if (small_photo_obj[mid_t[focus - disphead]].icon_3d == true)
	    {
		write_back_bytes2 (52, [28,0,0,focus,0,multi_shot_sel_cnt]);
 		return;
	    }
 	    multi_shot_sel_cnt++;
 	    write_back_bytes2 (52, [25,0,1,focus,disphead,multi_shot_sel_cnt]);  // ms_sel on
 	}
 	else
 	{
 	    if (multi_shot_sel_cnt <= 0)
 		return;
 	    multi_shot_sel_cnt--;
 	    write_back_bytes2 (52, [26,0,0,focus,disphead,multi_shot_sel_cnt]);  // ms_sel off
 	}
    }
}

function cursor_move (key) {
    if(items == 0)
    {
	return;
    }
    old_focus = focus;
    old_disphead = disphead;
    switch (key)
    {
    case TXK_RIGHT:
    case TXK_PAGE_RIGHT:
	focus++;
	if(focus >= items)
	{
	    focus = 0;
	    disphead = 0;
	    mid_table_shift();
	    out_position ();
	}
	else if(focus >= disphead + disp_column * disp_row)
	{
	    //scroll_up
	    disphead += disp_column;
	    out_position2 ();
	}
	else
	{
	    focus_anim (); 
	    return;
	}
	break;
    case TXK_LEFT:
    case TXK_PAGE_LEFT:
	focus--;
	if(focus < 0)
	{
	    focus = items - 1;
	    disphead = items - (items % disp_column) - (disp_row - 1) * disp_column;
	    if(disphead == 0 && old_disphead == 0)
	    {
		disphead = 0;
		focus_anim (); 
		return;
	    }
	    if(disphead < 0)
	    {
		disphead = 0;
		focus_anim (); 
		return;
	    }
	    while ( items - disphead <= disp_info[zoom_mode][0] * (disp_info[zoom_mode][1] - 1)
		    && disphead + disp_info[zoom_mode][0] * disp_info[zoom_mode][1] >= focus)
		{
		    disphead -= disp_info[zoom_mode][0];
		}
	    if(old_disphead + disp_column != disphead)
	    {
		mid_table_shift();
	    }
	    out_position ();
	}
	else if(focus < disphead)
	{
	    //scroll_down
	    disphead -= disp_column;
	    mid_table_shift();
	    out_position2 ();
	}
	else
	{
	    focus_anim (); 
	    return;
	}
	break;
    case TXK_DOWN:
	//console.log('[TXK_DOWN]');
	focus += disp_column;
	if(focus >= items)
	{
	    if(parseInt(focus / disp_column) == parseInt((items - 1) / disp_column))
	    {
		if(disphead + disp_column * disp_row < items)
		{
		    focus = items - 1;
		    disphead += disp_column;
		    out_position2 ();
		}
		else
		{
		    focus = items - 1;
		    focus_anim ();
		}
	    }
	    else
	    {
		focus = 0;
		disphead = 0;
		mid_table_shift();
		out_position ();
	    }
	}
	else if(focus >= disphead + disp_column * disp_row)
	{
	    //scroll_up
	    disphead += disp_column;
	    out_position2 ();
	}
	else
	{
	    focus_anim (); 
	    return;
	}
	break;
    case TXK_PAGE_DN:
	//console.log('[TXK_PAGE_DN]');
	if (disphead + (disp_column * disp_row) >= items)
	{
	  focus = focus % disp_column;
	  disphead = 0;
	  mid_table_shift();
	  out_position ();
	}
	else
	{
          disphead += disp_column;
	  focus += disp_column;
          out_position2 ();
	}
	break;
    case TXK_UP:
	//console.log('[TXK_UP]');
	focus -= disp_column;
	if(focus < 0)
	{
	    focus = items - 1;
	    disphead = items - (items % disp_column) - (disp_row - 1) * disp_column;
	    if(disphead == 0 && old_disphead == 0)
	    {
		disphead = 0;
		focus_anim (); 
		return;
	    }
	    if(disphead < 0)
	    {
		disphead = 0;
		focus_anim (); 
		return;
	    }
	    while ( items - disphead <= disp_info[zoom_mode][0] * (disp_info[zoom_mode][1] - 1)
		    && disphead + disp_info[zoom_mode][0] * disp_info[zoom_mode][1] >= focus)
		{
		    disphead -= disp_info[zoom_mode][0];
		}
	    if(old_disphead + disp_column != disphead)
	    {
		mid_table_shift();
	    }
	    out_position ();
	}
	else if(focus < disphead)
	{
	    //scroll_down
	    disphead -= disp_column;
	    mid_table_shift();
	    out_position2 ();
	}
	else
	{
	    focus_anim (); 
	    return;
	}
	break;
    case TXK_PAGE_UP:
	//console.log('[TXK_PAGE_UP]');
	if (disphead - disp_column < 0)
	{
	  disphead = items - (items % disp_column) - (disp_row - 1) * disp_column;
          focus = (focus % disp_column) + disphead + (disp_column * disp_row);
          if (focus >= items - 1 )
	  {
	    focus = items - 1;
	  }
	  mid_table_shift();
	  out_position ();
	}
	else
	{
          disphead -= disp_column;
          focus -= disp_column;
          mid_table_shift();
          out_position2 ();
	}
	break;
    default:
	return;
    }
    change_scrollbar ();
    focus_anim ();
    if(disphead != old_disphead)
    {
	focus_anim_finish ();
	scroll_anim_flag = true;
	scroll_anim();
    }
}

function change_zoom () {
    base_obj_reset ();
    
    old_zoom_mode = zoom_mode;
    zoom_mode++;
    old_disphead = disphead;
    if(zoom_mode > 2)
    {
	zoom_mode = 1;
	disphead = 0;
	while ( focus - disphead >= disp_info[zoom_mode][0] * disp_info[zoom_mode][1] )
	{
	    disphead += disp_info[zoom_mode][0];
	}
    }
    else
    {
	disphead = parseInt(disphead / disp_info[zoom_mode][0]) * disp_info[zoom_mode][0];
    }
    while ( items - disphead <= disp_info[zoom_mode][0] * (disp_info[zoom_mode][1] - 1)
	    && disphead + disp_info[zoom_mode][0] * disp_info[zoom_mode][1] >= focus)
	{
	    disphead -= disp_info[zoom_mode][0];
	}
    if(disp_info[zoom_mode][0] * disp_info[zoom_mode][1] >= items)
    {
	disphead = 0;
    }
    zoom_anim_flag = true;
    zoom_anim_f1();
}

function viv_obj_load () {
    if(!viv_loaded)
    {
	if(viv_area == VIV_AREA_JP)
	    {
		//base_height = 867;
		//base_y_pos = 53;
		base_height = 845;
		base_y_pos = 60;
	    }

	viv_loaded = true;
	eval_js_file ("file:///usr/local/javascript/wing/mplayer/calendar.js"); 
	object_set ();
    }
    disp_column = disp_info[zoom_mode][0];
    disp_row = disp_info[zoom_mode][1];
}

function appear_obj () {
    hide_flag = false;
    single_mode = false;
    frame_mode = false;
    viv_mode = MODE_LIST;

    viv_obj_load ();

    s.components[0] = base_obj;
    s.components[1] = scroll_bar_obj;
    s.components[2] = thumb_base_obj;
    s.components[3] = focus_obj;

    dsp_viv_list = 1;

    if(disphead > focus || disphead + disp_column * disp_row <= focus)
    {
	disphead = 0;
	old_disphead = 0;
	while(disphead + disp_column * disp_row <= focus)
	{
	    disphead += disp_column;
	}
    }

    write_back_bytes2 (20,[zoom_mode]);
    write_back_bytes2 (22,[MODE_LIST]);
    write_back_bytes2 (100, [focus]);
    reading = false;
    mid_table_shift ();
    init_position ();
}

function appear_obj2 () {
    hide_flag = false;
    single_mode = false;
    frame_mode = false;
    viv_mode = MODE_LIST;

    s.components[0] = base_obj;
    s.components[1] = scroll_bar_obj;
    s.components[2] = thumb_base_obj;
    s.components[3] = focus_obj;

    dsp_viv_list = 1;
    disphead = 0;
    focus = 0;

    force_redraw ();

    write_back_bytes2 (22,[MODE_LIST]);
    write_back_bytes2 (31, [0]);
}

var restore_stage = function () {
    s.components[0] = base_obj;
    s.components[1] = scroll_bar_obj;
    s.components[2] = thumb_base_obj;
    s.components[3] = focus_obj;
}

s.symbol = "home-screen";

var clear_stage = function () {
    var num = s.components.length;
    for (var i = 0; i < num; i++)
    {
	s.components[i] = 0;
    }
    force_redraw();
}

var clear_stage_black = function () {
    var num = s.components.length;
    for (var i = 0; i < num; i++)
    {
	s.components[i] = 0;
    }
    s.components[0] = black_base_obj;
    force_redraw();
}

var list_key = function (up_down, key) {
    var info_break = 0;

    if (key_invalid_flg)
    {
	return true;
    }

    if (up_down != KEY_PRESS)
	return true;
    if (zoom_anim_flag)
    {
	zoom_anim_f2 ();
	anim_finish ();
    }
    
    if (scroll_anim_flag)
    {
	anim_finish ();
    }
    
    if(insert_anim_flag)
    {
	insert_anim_flag = false;
	delete_timer (this);	 
	s.components[4] = 0;
	//appear_obj ();
	return; 
    }

    if(disp_info_flag)
    {
	s.components[4] = 0;
	disp_info_flag = false;
	force_redraw();
	info_break = 1;
    }

    if(single_mode || frame_mode)
    {
	switch (key)
	{
	case TXK_RETURN:
	    single_mode = false;
	    frame_mode = false;
	    restore_stage();
	    mid_table_shift ();
	    write_back_bytes2 (24,[0]);
	}
	return;
    }

    switch (key)
    {
    case TXK_RIGHT:
    case TXK_LEFT:
    case TXK_DOWN:
    case TXK_UP:
    case TXK_PAGE_DN:
    case TXK_PAGE_UP:
    case TXK_PAGE_RIGHT:
    case TXK_PAGE_LEFT:
	cursor_move(key);
    switch(viv_area)
	{
        case VIV_AREA_EU:
        case VIV_AREA_PAL:
        case VIV_AREA_US:
	    break;
        case VIV_AREA_JP:
	    write_back_bytes2 (100, [focus]);
	    break;
	}
        break;
    case TXK_PLAY:
	if(multi_shot_enable)
	{
	    return;
	}
	if (items == 0)
	{
	    return;
	}
	clear_stage();
	hide_flag = true;
	frame_mode = true;
	write_back_bytes2 (23,[focus, disphead]);
	break;
    case TXK_ENTER:
	if(items == 0)
	{
	    return;
	}
    //if(multi_shot_enable)
    //	{
    //	    write_back_bytes2 (25,[30,0,focus,disphead]);
    //	}
	if(multi_shot_enable)
        {
	    if(multi_shot_sel_cnt >= 2)
	    {
	    clear_stage();
	    single_mode = true;
	    hide_flag = true;
	    write_back_bytes2 (25,[focus, disphead]);
	    }
	}
	else
	{
	    clear_stage();
	    single_mode = true;
	    hide_flag = true;
	    write_back_bytes2 (25,[focus, disphead]);
	}
	break;
    case TXK_RED:
	if(items == 0)
	{
	    return;
	}
	switch(viv_area)
	{
	case VIV_AREA_EU:
	case VIV_AREA_PAL:
	case VIV_AREA_US:
	    if (multi_shot_enable)
	    {
		multishoot_3d_key_func (focus);
	    }
	    break;
	case VIV_AREA_JP:
	    if (!multi_shot_enable && items)
	    {
		write_back_bytes2 (40,[focus, disphead]);
	    }
	break;
	}
    break;
    case TXK_GREEN:
    switch(viv_area)
	{
	case VIV_AREA_EU:
	case VIV_AREA_PAL:
	case VIV_AREA_US:
	    if (!multi_shot_enable && items)
	    {
		write_back_bytes2 (40,[focus, disphead]);
	    }
	    break;
	case VIV_AREA_JP:
	    break;
	}
    break;
    case TXK_BLUE:
    switch(viv_area)
	{
	case VIV_AREA_EU:
	case VIV_AREA_PAL:
	case VIV_AREA_US:
	    break;
	case VIV_AREA_JP:
	    if (multi_shot_enable)
	    {
	      multishoot_3d_key_func (focus);
	    }
	    break;
	}
	break;
    case TXK_YELLOW:
    switch(viv_area)
	{
	case VIV_AREA_EU:
	case VIV_AREA_PAL:
	    break;
	case VIV_AREA_US:
	    break;
	case VIV_AREA_JP:
	    write_back_bytes2 (36,[focus]);
	    break;
	}
	break;
    case TXK_RETURN:
	if(single_mode || frame_mode)
	{
	    single_mode = false;
	    frame_mode = false;
	    restore_stage();
	    mid_table_shift ();
	    write_back_bytes2 (24,[0]);
	}
	else if (multi_shot_enable == true)
	{
	    change_multishoot_mode (0);
	    ms_sel_del ();
	    write_back_bytes2 (53,[0]);
	}
	else
	{
	    write_back_bytes2 (50,[1]);//terminate
	}
        break;
    case TXK_INFO:
	switch(viv_area)
	{
	case VIV_AREA_JP:
	    return;
	}	
    case TXK_DMODE:
	if(items == 0)
	{
	    return;
	}
	if(!info_break)
	{
	    if(focus_obj.translate[0] > 0)
	    {
		x = parseInt(960 + focus_obj.translate[0] - disp_info[zoom_mode][2] / 2 - INFO_WIDTH) - 10;
	    }
	    else
	    {
		x = parseInt(960 + focus_obj.translate[0] + disp_info[zoom_mode][2] / 2) + 10;
	    }
	    if(focus_obj.translate[1] > 0)
	    {
		y = parseInt(560 - (focus_obj.translate[1] + disp_info[zoom_mode][3] / 2)) - 20;
	    }
	    else
	    {
		y = parseInt(560 - (focus_obj.translate[1] - disp_info[zoom_mode][3] / 2)) - INFO_HEIGHT - 10;
	    }
	    write_back_bytes2 (26,[focus, x, y, items]);
	}
	break;
    case TXK_MYBUTTON:
	if(items == 0)
	{
	    return;
	}
	write_back_bytes2 (60,[focus, disphead]);
	break;
    default:
	break;
    }
}

var change_focus = function (new_focus)
{
    focus = new_focus; 
    if(disphead > focus || disphead + disp_column * disp_row <= focus)
    {
	disphead = 0;
	old_disphead = 0;
	while(disphead + disp_column * disp_row <= focus)
	{
	    disphead += disp_column;
	}
    }
    mid_table_shift ();
    init_position ();
}

var set_focus = function (new_focus)
{
    focus = new_focus; 
}

var set_focus_fav_update = function (new_focus,onoff)
{
    if(new_focus >= mid_ti[0] && new_focus < mid_ti[MAX_PHOTO_OBJ-1])
    {
	focus = new_focus;
	update_favorite_icon(onoff);
    }
}

var ms_sel_del = function ()
{
    for (var i = 0; i < MAX_PHOTO_OBJ; i++)
    {
	small_photo_obj[i].delPng();
	small_photo_obj[i].ms_selMark(0);
	small_photo_obj[i].ms_selVisible();
    }
    force_redraw ();
}

var ms_sel_all_photo = function (ms_sel)
{
    for(var i = 0; i < MAX_PHOTO_OBJ; i++)
	{
	    small_photo_obj[i].changePng(ms_sel);
	    small_photo_obj[i].ms_selMark(ms_sel);
	    small_photo_obj[i].ms_selVisible();
	}
    force_redraw ();
}

var ms_sel_photo = function (num,ms_sel)
{
    for(var i = 0; i < MAX_PHOTO_OBJ; i++)
    {
	if(small_photo_obj[i].img_id == num)
	{
	    small_photo_obj[i].changePng(ms_sel);
	    small_photo_obj[i].ms_selMark(ms_sel);
	}
    }
   force_redraw ();
}

var dec_multi_shot_sel_cnt = function ()
{
    if (multi_shot_sel_cnt == 2)
	multi_shot_sel_cnt = 1;
}

var change_multishoot_mode = function (multishoot)
{
    for(var i = 0; i < MAX_PHOTO_OBJ; i++)
    {
	if (multishoot)
	{
	  small_photo_obj[i].changePng(0);
	  small_photo_obj[i].ms_selMark(0);
          small_photo_obj[i].ms_selVisible();
	  multi_shot_sel_cnt = 0;
	}
	else
	{
	  small_photo_obj[i].delPng();
	  small_photo_obj[i].ms_selMark(0);
	  small_photo_obj[i].ms_selVisible();
	  multi_shot_sel_cnt = 0;
	}
    }
   force_redraw ();
}

var update_favorite_icon = function (onoff)
{
    if(onoff)
    {
	small_photo_obj[mid_t[focus - disphead]].images[5].src = STAR_PNG;
	small_photo_obj[mid_t[focus - disphead]].images[5].visible_p = true;
	small_photo_obj[mid_t[focus - disphead]].favorite = true;
    }
    else
    {
	small_photo_obj[mid_t[focus - disphead]].images[5].visible_p = false;
	small_photo_obj[mid_t[focus - disphead]].favorite = false;
    }
   force_redraw ();
}


var chk_sel_del = function ()
{
    for (var i = 0; i < MAX_PHOTO_OBJ; i++)
    {
	small_photo_obj[i].chk_delPng();
	small_photo_obj[i].chk_selMark(0);
	small_photo_obj[i].chk_selVisible();
    }
    force_redraw ();
}

var all_sel_chk_photo = function (onoff)
{
    for(var i = 0; i < MAX_PHOTO_OBJ; i++)
    {
	if (small_photo_obj[i].img_id >= 0
	    && (small_photo_obj[i].status != NOIMAGE)
	    && (small_photo_obj[i].status != CLEARIMAGE))
	{
	    small_photo_obj[i].chk_changePng(onoff);
	    small_photo_obj[i].chk_selMark(onoff);
            small_photo_obj[i].chk_selVisible();
	}
    }
    force_redraw ();
}
var chk_key_flag_timer_hook = function (obj, count){
    if (chk_key_disable_flag == true)
    {
	chk_key_disable_flag = false;
    }
    delete_timer (obj);
}


var chk_mark_func = function (num)
{
    if (chk_key_disable_flag == false)
    {
	append_timer (base_obj, 100, chk_key_flag_timer_hook);
	chk_key_disable_flag = true;
	for(var i = 0; i < MAX_PHOTO_OBJ; i++)
	{
	    if(small_photo_obj[i].img_id == num)
	    {
		var chk = 0;
		if (small_photo_obj[i].check == true)
		{
		    chk = 0;
		}
		else
		{
		    chk = 1;
		}
	    }
	}
	write_back_bytes2 (51, [chk, num, 1]);
    }
}

var chk_sel_photo = function (num)
{
    for(var i = 0; i < MAX_PHOTO_OBJ; i++)
    {
	if(small_photo_obj[i].img_id == num)
	{
	    var chk = 0;
	    if (small_photo_obj[i].check == true)
	    {
		chk = 0;
		check_mark_num--;
	    }
	    else
	    {
		chk = 1;
		check_mark_num++;
	    }
	    small_photo_obj[i].chk_changePng(chk);
	    small_photo_obj[i].chk_selMark(chk);
	}
    }
    chk_key_disable_flag = false;
}

var appear_frame = function (mode)
{
    viv_mode = mode;
    hide_flag = false;

    switch(mode)
    {
    case MODE_FLOWFRAME:
	clear_stage();
	eval_js_file ("file:///usr/local/javascript/wing/mplayer/flowframe.js"); 
	flowframe_appear_obj ();
	break;
    case MODE_WALLFRAME:
	clear_stage();
	eval_js_file ("file:///usr/local/javascript/wing/mplayer/wallframe.js"); 
	wallframe_appear_obj ();
	break;
    case MODE_CINEMAFRAME:
	clear_stage();
	eval_js_file ("file:///usr/local/javascript/wing/mplayer/cinema.js"); 
	cinemaframe_appear_obj ();
	break;
    default:
	break;
    }
}

var stop_frame = function ()
{
    frame_mode = false;
    single_mode = false;
    delete_timer (this);

    switch(viv_mode)
    {
    case MODE_LIST:
	if (zoom_anim_flag)
	{
	    zoom_anim_f2 ();
	    anim_finish ();
	}
	if (scroll_anim_flag)
	{
	    anim_finish ();
	}
	if(insert_anim_flag)
	{
	    insert_anim_flag = false;
	    s.components[4] = 0;
	}
	break;
    case MODE_FLOWFRAME:
	clear_flow_frame();
	clear_stage();
	break;
    case MODE_WALLFRAME:
	clear_wall_frame();
	clear_stage();
	break;
    case MODE_CINEMAFRAME:
	clear_cinema_frame();
	clear_stage();
	break;
    default:
	break;
    }
    viv_mode = MODE_NONE;
}

s.key_hook = function (up_down, key) {
    if(hide_flag)
    {
	return;
    }

    switch(viv_mode)
    {
    case MODE_LIST:
	list_key(up_down, key);
	break;
    case MODE_FLOWFRAME:
	flowframe_key(up_down, key);
	break;
    case MODE_WALLFRAME:
	wallframe_key(up_down, key);
	break;
    case MODE_CINEMAFRAME:
	cinema_key(up_down, key);
	break;
    default:
	break;
    }
}

s.in = [
    {
	"from": ["default"],
    }
];

var home_screen = stage
({
    "key_hook" : key_hook,
    "symbol": "home_screen",
});
