var day_obj_text = new Array ();
var day_obj = new Array ();
var week_obj = new Array ();

MONTH_FONT_SIZE = 80;
MONTH_US_FONT_SIZE = 60;

//firstday:the week of the first day of the month
//firstday:0->sunday 1->monday 2->tuesday ...
//monthday:the number of days of the month

var mon = 
    [0,31,60,91,121,152,182,213,244,274,305,335,366,
     0,31,59,90,120,151,181,212,243,273,304,334,365];
var mon_name = 
    ["", "VIV_Jan", "VIV_Feb", "VIV_Mar", "VIV_Apr", "VIV_May", "VIV_Jun", "VIV_Jul",
     "VIV_Aug", "VIV_Sep", "VIV_Oct", "VIV_Nov", "VIV_Dec"];
    //    ["", "January", "February", "March", "April", "May", "June", "July",
    //     "August", "September", "October", "November", "December"];
var week_name = 
    ["", "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"];

var firstday;
var monthday;

var calendar_y_pos = 300;
var calendar_mode = true;

var calendar_year = 2009;
var calendar_month = 10;

var cal_month = function (year, month){
    //number of days before first day of every month in this year
    //the first row is leap yesr,the second row is normal year
    //sum is the number of days before first day of this month in this year
    
    var t = year - 1;
    var sum;
    
    /*leap year judgement,monthday calculate*/
    if((year%400 == 0) || ((year%4 == 0)&&(year%100 != 0)))
    {
	sum = mon[month-1];
	monthday = mon[month] - mon[month - 1];
    }
    else
    {
	sum = mon[month+12];
	monthday = mon[month+13] - mon[month+12];
    }

    //firstday calculate
    //AD 0 year JANURRY 1ST weekday is sunday
    //364%7 = 0; (1+t) is number of normal years
    //(t/4 - t/100 + t/400) is number of leap years
    firstday = (1 + t + parseInt(t/4) - parseInt(t/100) + parseInt(t/400) + sum) % 7;
}

cal_month(calendar_year, calendar_month);

var month_name_obj =
    new gtext ({
	"translate": [-50, 60, 0],
	"rotation": [0, 0, 0, 0],
	"color": [0, 0, 0, 255],
	"width": 200,
	//	"text": calendar_year + " " + mon_name[calendar_month],
	"text": String(calendar_month),
	"align": CENTER,
	"font_size": MONTH_FONT_SIZE,
	"font_name": font_name[viv_area],
	"visible_p": true,
	"margin": [0,0,10,0],
    });

var year_name_obj =
    new gtext ({
	"translate": [-50, 0, 0],
	"rotation": [0, 0, 0, 0],
	"color": [0, 0, 0, 255],
	"width": 110,
	"text": String(calendar_year),
	"align": CENTER,
	"font_size": 32,
	"font_name": font_name[viv_area],
	"visible_p": true,
	"margin": [0,0,10,0],
    });

var day_count = -firstday - 1;

for (var i=0; i<6; i++)
{
    for (var j=0; j<7; j++)
    {
      day_obj[i*7 + j] = new container ({"components" : []});
    }
}


day_obj_text[0] = new gtextbox ({
  "translate": [0, 0, 0],
  "rotation": [0, 0, 0, 0],
  "color": [0, 0, 0, 255],
  "width": 80,
  "height": 50,
  "text": " ",
  "align": RIGHT,
  "font_size": 48,
  "font_name": font_name[viv_area],
  "visible_p": true,
});

for (var i = 1; i <= 31; i++)
{
  day_obj_text[i] = new gtextbox ({
    "translate": [0, 0, 0],
    "rotation": [0, 0, 0, 0],
    "color": [0, 0, 0, 255],
    "width": 80,
    "height": 50,
    "text": String(i),
    "align": RIGHT,
    "font_size": 48,
    "font_name": font_name[viv_area],
    "visible_p": true,
  });
}

for (var i=0; i<7; i++)
{
    week_obj[i] = new gtextbox ({
	"translate": [0, 0, 0],
	"rotation": [0, 0, 0, 0],
	"color": [0, 0, 0, 255],
	"width": 80,
	"height": 30,
	"text": (viv_area == VIV_AREA_US) ? gettext(week_name[i+1]) : week_name[i+1],
	"align": CENTER,
	"font_size": 24,
	"font_name": font_name[viv_area],
	"visible_p": true,
    });
}

calendar_base_obj = 
    new container ({
	"translate": [300, 300, 0],
	"rotation": [0, 0, 0, 0],
	"components":[ 
	    year_name_obj,
	    month_name_obj,
	    week_obj[0],		      
	    week_obj[1],		      
	    week_obj[2],		      
	    week_obj[3],		      
	    week_obj[4],		      
	    week_obj[5],		      
	    week_obj[6],		      

	    day_obj[0],		      
	    day_obj[1],		      
	    day_obj[2],		      
	    day_obj[3],		      
	    day_obj[4],		      
	    day_obj[5],		      
	    day_obj[6],		      
	    day_obj[7],		      
	    day_obj[8],		      
	    day_obj[9],		      
	    day_obj[10],		      
	    day_obj[11],		      
	    day_obj[12],		      
	    day_obj[13],		      
	    day_obj[14],		      
	    day_obj[15],		      
	    day_obj[16],		      
	    day_obj[17],		      
	    day_obj[18],		      
	    day_obj[19],		      
	    day_obj[20],		      
	    day_obj[21],		      
	    day_obj[22],		      
	    day_obj[23],		      
	    day_obj[24],		      
	    day_obj[25],		      
	    day_obj[26],		      
	    day_obj[27],		      
	    day_obj[28],		      
	    day_obj[29],		      
	    day_obj[30],		      
	    day_obj[31],		      
	    day_obj[32],		      
	    day_obj[33],		      
	    day_obj[34],		      
	    day_obj[35],		      
	    day_obj[36],		      
	    day_obj[37],		      
	    day_obj[38],		      
	    day_obj[39],		      
	    day_obj[40],		      
	    day_obj[41],		      
	],
	"visible_p": true,
    });

var set_calendar = 
    function (year, month){
	calendar_year = year;
	calendar_month = month;

	calendar_mode = true;
	if(year == 0xff)
	{
	    calendar_mode = false;
	    calendar_base_obj.translate[0] = -10000;
	    calendar_base_obj.translate[1] = -10000;
	    return;
	}
	calendar_base_obj.visible_p = true;

	setf_text(year_name_obj, String(year));
	if(viv_area == VIV_AREA_US)
	{
	    setf_text(month_name_obj, gettext(mon_name[month]));
	}
	else
	{
	    setf_text(month_name_obj, String(month)); 
	}
	
	cal_month(year, month);
	day_count = -firstday;
	
	if(day_count == -7)
	{
	    day_count = 0;
	}

	for (var i=0; i<42; i++)
	{
	    day_count++; 
	    if((day_count > 0) && (day_count <= monthday))
	    {
	      day_obj[i].components[0] = day_obj_text[day_count];
	    }
	    else
	    {
	      day_obj[i].components[0] = day_obj_text[0];
	    }
	}
	write_back_bytes2 (21, [calendar_year,calendar_month,firstday]);
    }

var set_calendar_color = 
    function (color){
	year_name_obj.color = [color, color, color, 255];
	month_name_obj.color = [color, color, color, 255];

	for (var i=0; i<=31; i++)
	{
	    day_obj_text[i].color = [color, color, color, 255];
	}
	for (var i=0; i<7; i++)
	{
	    week_obj[i].color = [color, color, color, 255];
	}
    }


var set_calendar_size = 
    function (size){
	year_name_obj.font_size = 32 * size / 100;
	year_name_obj.width = 110 * size / 100;
	year_name_obj.translate[0] = -50 * size / 100;
	setf_text (year_name_obj, year_name_obj.text);//redraw buf
	if(viv_area == VIV_AREA_US)
	{
	    month_name_obj.font_size = MONTH_US_FONT_SIZE * size / 100;
	}
	else
	{
	    month_name_obj.font_size = MONTH_FONT_SIZE * size / 100;
	}
	month_name_obj.width = 200 * size / 100;
	month_name_obj.translate[0] = -50 * size / 100;
	month_name_obj.translate[1] = 60 * size / 100;
	setf_text (month_name_obj, month_name_obj.text);
	
	for (var i=0; i<6; i++)
	{
	    for (var j=0; j<7; j++)
	    {
		day_obj[i*7+j].translate[0] = j*(80 * size / 100) + (50 * size / 100);
		day_obj[i*7+j].translate[1] = -i*(60 * size / 100) + (50 * size / 100);
		if(i*7+j <= 31)
		    {
			day_obj_text[i*7+j].width = 80 * size / 100;
			day_obj_text[i*7+j].font_size = 48 * size / 100;
			setf_text (day_obj_text[i*7+j], day_obj_text[i*7+j].text);
		    }
	    }
	}
	
	for (var i=0; i<7; i++)
	{
	    week_obj[i].translate[0] = i*(80 * size / 100) + (70 * size / 100);
	    week_obj[i].translate[1] = (60 * size / 100) + (30 * size / 100);
	    week_obj[i].font_size = 24 * size / 100;
	    week_obj[i].width = 80 * size / 100;
	    setf_text (week_obj[i], week_obj[i].text);
	}
    }

var move_calendar = 
    function (){
	calendar_y_pos -= 1;
	if(calendar_y_pos <= -200)
	{
	    calendar_y_pos = 300;
	}
	calendar_base_obj.translate[1] = calendar_y_pos;
    }


