/**
 * Created with JetBrains WebStorm.
 * User: Dean Clancy
 * Date: 26/11/13
 * Time: 23:04
 * To change this template use File | Settings | File Templates.
 */
var olgOnly = function(){

    var ACTION_CLOSE = 'Close menu',
        ACTION_RECORD = 'Record',
        ACTION_CANCEL_RECORD = 'Cancel record',
        ACTION_SET_REMINDER = 'Set reminder',
        ACTION_CANCEL_REMINDER = 'Cancel reminder',
        ACTION_WATCH = 'Watch now',
        MOCK_RECORDINGS = false,
        MOCK_REMINDERS = false;
        MOCK_REMINDER_DIALOGUE = false,
        LOCAL_STORAGE_OPT_IN = 'marketingOptIn',
        MAX_RECORDINGS = 15;

    var vbo = null,
        configObj = null,
        manager = null,
        searchManager = null,
        am = null,
        search_stack = [],
        linesToRender = 0,
        ui = null,
        metaIcons = null,
        channelChanger = null,
        config,
        reminderShowing = false,
        messageShowing = false,
        state_olg = true,
        action_menu = false,
        action_menu_items = [],
        searching = false,
        focusRow = 0,
        pageRows = 0,
        topRow = 0,
        notHidden = true,
        tlgPageAM = 0,
        deferredChannelChangeAMEvent = false;

    config = {
        channelIDs: [],
        channelImages: [],
        LOCAL_VARS: {
            ui_banner_timeout: 5,
            NO_DATA: 'No data available',
            regions: []
        },
        LOCAL_CONFIG_FILE: "file:///transient/freetime/freetimed/ram/freetimeconf.xml",

        getQueryString: function() {
            var query = window.location.search,
                options,
                option,
                len,
                i;
            if (query) {
                query = query.replace('?', '');
                options = query.split('&');
                len = options.length;

                for (i = 0; i < len; i++) {
                    option = options[i].split('=');
                    config.LOCAL_VARS[option[0]] = option[1];
                }
            }
        },

        parseJSONImages: function(json) {
            if(json){
                var data = JSON.parse(json),
                    images = data.imageMappings.img,
                    len = images.length,
                    fsatid,
                    img_index,
                    i;

                for (i = 0; i < len; i++) {
                    fsatid = images[i].id.replace('fs-img://fsatid/', '').replace('-hi', '');

                    if (config.channelIDs.indexOf(fsatid) === -1) {
                        config.channelIDs.push(fsatid);
                        config.channelImages.push({
                            fsatid: fsatid,
                            img: config.LOCAL_VARS.recdata_loc + images[i].stb
                        });
                    } else {
                        img_index = config.channelIDs.indexOf(fsatid);

                        if (images[i].id === ('fs-img://fsatid/' + fsatid + '-hi')) {
                            config.channelImages[img_index].img_hi = config.LOCAL_VARS.recdata_loc + images[i].stb;
                        }
                        if (images[i].id === ('fs-img://fsatid/' + fsatid)) {
                            config.channelImages[img_index].img = config.LOCAL_VARS.recdata_loc + images[i].stb;
                        }
                    }
                }
            }
        },

        parseXMLConfig: function(xml) {
            var mode,
                data,
                recdata_loc,
                ui_banner_timeout,
                file_url = '/img/imgmap.json';

            mode = (config.LOCAL_VARS.mode) ? config.LOCAL_VARS.mode : 'dtt';

            try {

                data = xml.getElementsByTagName(mode)[0];
                recdata_loc = data.getElementsByTagName('recdata_loc')[0].childNodes[0].nodeValue;
                auth_loc = data.getElementsByTagName('auth_file_loc')[0].childNodes[0].nodeValue;

                var i;
                config.LOCAL_VARS.regions = [];
                var regions = data.getElementsByTagName('regions')[0];
                for(i=0; i< regions.childNodes.length; i++){
                    var obj = {};
                    try{
                        obj.id = regions.childNodes[i].getAttribute('id');
                        obj.pr_id = regions.childNodes[i].getAttribute('pr_id');
                        obj.sr_id = regions.childNodes[i].getAttribute('sr_id');
                        obj.pr_name = regions.childNodes[i].getAttribute('pr_name');
                        obj.sr_name = regions.childNodes[i].getAttribute('sr_name');
                        config.LOCAL_VARS.regions.push(obj);
                    }catch(e){
                        // ignore
                    }
                }

                if (recdata_loc) {
                    file_url = recdata_loc + file_url;
                    config.LOCAL_VARS.recdata_loc = recdata_loc;
                    config.getFile(file_url, 'json', config.parseJSONImages);
                }

                if (auth_loc) {
                    console.log('Parsing auth file from: ' + auth_loc);
                    config.getFile(auth_loc, 'xml', config.parseAuth);
                }
                ui_banner_timeout = xml.getElementsByTagName('ui_banner_timeout')[0].childNodes[0].nodeValue;

                if (ui_banner_timeout) {
                    config.LOCAL_VARS.ui_banner_timeout = ui_banner_timeout;
                }

            } catch (e) {
                ui_banner_timeout = 5;
            }
        },

        parseAuth: function(xml) {
            try {
                config.LOCAL_VARS.appMonitor = xml.getElementsByTagName('appmonitor')[0].childNodes[0].nodeValue;
                config.LOCAL_VARS.appMonitorCustomData = xml.getElementsByTagName('appmonitor')[0].getAttribute('customdata');
                config.LOCAL_VARS.appMonitorSessionTimeoutSecs = xml.getElementsByTagName('appmonitor')[0].getAttribute('sessionTimeoutSecs');
                config.LOCAL_VARS.appMonitorSessionRefreshSecs = xml.getElementsByTagName('appmonitor')[0].getAttribute('sessionRefreshSecs');
            } catch (e) {
                console.log('ERROR: could not parse auth file: ' + e);
            }
        },

        getFile: function(file, type, callback) {
            var client, response;
            try{
                if (window.XMLHttpRequest) {
                    client = new XMLHttpRequest();
                }
                client.open("GET", file, false);
                client.onreadystatechange = function() {
                    if (type === 'xml') {
                        response = client.responseXML;
                    } else {
                        if(client.responseText){
                            response = client.responseText;
                        }
                    }

                    if(client.readyState === 4){
                        callback(response);
                    }
                };
                client.send();
            }catch(e){
            }
        }
    };

    metaIcons = {
        meta: [
            { property: false, func: 'getHasTSTVfromProgramme', css: 'ondemand' },
            { property: false, func: 'getShowcase', css: 'showcase' },
            { property: true, func: MOCK_RECORDINGS ? 'hasRecordingDummy' : 'hasRecording', css: 'recording' },
            { property: true, func: MOCK_REMINDERS ? 'hasReminderDummy' : 'hasReminder', css: 'reminder' },
            { property: true, func: 'isHD', css: 'hd' },
            { property: true, func: 'hasHDSimulcast', css: 'simulcast' },
            { property: true, func: 'is3D', css: '3d' },
            { property: false, func: 'getIsSeries', css: 'series' },
            { property: true, func: 'hasGuidance', css: 'guidance' },
            { property: true, func: 'subtitles', css: 'sub' },
            { property: true, func: 'hasSignLanguage', css: 'sl' },
            { property: true, func: 'hasAudioDescription', css: 'ad' },
            { property: false, func: 'gethasDolby', css: 'dolby' },
            { property: false, func: 'gethasSurroundSound', css: 'surround'},
            { property: false, func: 'getPlayFromStart', css: 'restart' }
        ],

        currentMetaIcons: [],

        set: function(prog) {
            var i, classname, add_class,
                len = metaIcons.meta.length,
                banner = document.getElementById('tlg-info-banner');

            metaIcons.unset();

            for (i = 0; i < len; i++) {
                add_class = false;

                if (metaIcons.meta[i].property) {
                    add_class = (prog[metaIcons.meta[i].func]);
                } else {
                    add_class = (metaIcons[this.meta[i].func](prog));
                }

                if (add_class) {
                    classname = 'show-' + metaIcons.meta[i].css;
                    metaIcons.currentMetaIcons.push(classname);
                }
            }

            if (metaIcons.currentMetaIcons.length > 0) {
                banner.className = metaIcons.currentMetaIcons.join(" ");
            }
        },

        unset: function() {
            var len = this.currentMetaIcons.length,
                banner = document.getElementById('tlg-info-banner');

            if (len > 0) {
                banner.className = "";
            }
            this.currentMetaIcons = [];
        },

        getHasTSTVfromProgramme: function(programme) {
            return false;
        },

        getShowcase: function(programme) {
            return false;
        },

        getIsSeries: function(programme) {
            try{
                var crids = programme.CRIDS,
                    len = crids.length,
                    i;

                for (i = 0; i < len; i++) {
                    return (crids[i].indexOf('0x32')>-1);
                }
            }catch(e){
                console.log('ChannelData no CRIDs');
            }
            return false;
        },

        gethasDolby: function(programme) {
            return (config.LOCAL_VARS.mode === 'dsat' && programme && programme.audioType === 4); // Compare audioType is 4 and return boolean
        },

        gethasSurroundSound: function(programme) {
            return (config.LOCAL_VARS.mode === 'dtt' && programme && programme.audioType === 4);
        },

        getPlayFromStart: function(programme) {
            return metaIcons.getHasTSTVfromProgramme(programme);
        }
    };

    reminderPopup = {
        show: function(programme) {
            reminderPopup.programme = programme;

            reminderPopup.container = document.getElementById('reminderBackground');
            reminderPopup.btnWatch = document.getElementById('reminder-btn-watch');
            reminderPopup.btnClose = document.getElementById('reminder-btn-close');

            reminderPopup.ccid = reminderPopup.programme.channelID;
            reminderPopup.channel = oipfChannelList.getItem(oipfChannelList.findListPosByCCID(reminderPopup.ccid));

            document.getElementById('reminder-programme-name').innerHTML = reminderPopup.programme.name;
            document.getElementById('reminder-when-where').innerHTML = 'is about to start on ' + reminderPopup.channel.name;

            reminderPopup.setFocussedButton(reminderPopup.btnWatch);

            ui.hideAll();
            setKeysetShow();

            reminderPopup.container.classList.remove('hidden'); // make visible
            reminderShowing = true;
        },
        hide: function() {
            reminderPopup.container.classList.add('hidden');
            reminderShowing = false;
        },
        onKey: function(evt) {
            switch (evt.keyCode){
                case 13: //KEY_OK
                    if (reminderPopup.getFocussedButton() === reminderPopup.btnWatch) {
                        console.log('WATCH ' + reminderPopup.ccid);
                        vbo.setChannel(reminderPopup.channel, false);
                        vbo.bindToCurrentChannel();
                        channelChanger.updateAndShowBanner();
                        
                    } else {
                        console.log('CLOSE');
                    }
                    reminderPopup.hide();
                    break;
                case 38: //KEY_UP
                case 40: //KEY_DOWN
                    if (reminderPopup.getFocussedButton() === reminderPopup.btnWatch) {
                        reminderPopup.setFocussedButton(reminderPopup.btnClose);
                    } else {
                        reminderPopup.setFocussedButton(reminderPopup.btnWatch);
                    }
                    break;
                case 461: // Back button
                    console.log('BACK');
                    reminderPopup.hide();
                    break;
            }
        },
        getFocussedButton: function() {
            if (reminderPopup.btnWatch.classList.contains('focused')) {
                return reminderPopup.btnWatch;
            } else if (reminderPopup.btnClose.classList.contains('focused')) {
                return reminderPopup.btnClose;
            }
            return null;
        },
        setFocussedButton: function(button) {
            reminderPopup.btnWatch.classList.remove('focused');
            reminderPopup.btnClose.classList.remove('focused');
            button.classList.add('focused');
        }
    };

    messagePopup = {
        show: function(title, desc, callToAction, iconType) {
            messagePopup.container = document.getElementById('messagePopupBackground');
            messagePopup.btnOk = document.getElementById('msg-popup-btn-ok');
            messagePopup.iconRecording = document.getElementById('msg-popup-logo-recording');
            messagePopup.iconReminder = document.getElementById('msg-popup-logo-reminder');
            messagePopup.labelTitle = document.getElementById('msg-popup-title');
            messagePopup.labelDesc = document.getElementById('msg-popup-desc');
            messagePopup.labelCallToAction = document.getElementById('msg-popup-call-to-action');

            messagePopup.labelTitle.innerHTML = title;
            messagePopup.labelDesc.innerHTML = desc;
            messagePopup.labelCallToAction.innerHTML = callToAction;


            messagePopup.iconReminder.className = 'hidden';
            messagePopup.iconRecording.className = 'hidden';
            switch (iconType) {
                case 'reminder':
                    messagePopup.iconReminder.className = 'msg-popup-logo';
                    break;
                case 'recording':
                    messagePopup.iconRecording.className = 'msg-popup-logo';
                    break;
            }

            ui.hideAll();
            setKeysetShow();

            messagePopup.container.classList.remove('hidden'); // make visible
            messageShowing = true;
        },
        hide: function() {
            messagePopup.container.classList.add('hidden');
            messageShowing = false;
        },
        onKey: function(evt) {
            switch (evt.keyCode){
                case 13: //KEY_OK
                    messagePopup.hide();
                    break;
                case 461: // Back button
                    messagePopup.hide();
                    break;
            }
        }
    };

    ui = {
        clockInterval: null,
        timeout: null,
        no_data_timeout: null,
        visible: false,
        infoVisible: false,
        column: 'now',
        blank_cell: {
            name: '',
            startTime: '',
            duration: 0
        },
        empty_programme: {
            name: config.LOCAL_VARS.NO_DATA,
            startTime: '',
            duration: 0
        },

        no_data_avail_display : false,

        setNoDataDispTimer: function() {
            ui.clearNoDataDispTimer();
            ui.no_data_timeout = setTimeout(ui.dispNoDataAvail, 2000);
        },
        clearNoDataDispTimer: function() {
            if (ui.no_data_timeout) {
                clearTimeout(ui.no_data_timeout);
            }
            ui.no_data_avail_display = false;
        },
        dispNoDataAvail: function () {
            ui.no_data_avail_display = true;
            channelChanger.updateProgrammes();
        },

        hideAll: function() {
            ui.visible = true;
            ui.toggle();
            clearAllTimeouts();
        },

        toggle: function() {
            var cssClass = "";

            if (ui.visible) {
                cssClass = "hidden";
                linesToRender = 0;
                ui.visible = false;
                setKeysetHide();
                hide3LG();
                if (ui.infoVisible) {
                    ui.toggleInfo();
                }
            } else {
                ui.setupClockUpdate();
                ui.updateClock();
                ui.visible = true;
                setKeysetShow();
            }
            document.getElementById('zappertlg-inst').className = cssClass;
        },
        toggleInfo: function() {
            var cssClass = "";
            clearTimeout(ui.timeout);

            if (ui.infoVisible) {
//                clearTimeout(ui.timeout);
                cssClass = "hidden";
                ui.infoVisible = false;
                ui.timeout = setTimeout(ui.toggle, (config.LOCAL_VARS.ui_banner_timeout * 1000));
            } else {
                if (!ui.visible) {
                    setKeysetShow();
                    channelChanger.updateProgrammes();
                }
                ui.infoVisible = true;
                ui.timeout = setTimeout(ui.hideAll, (5 * 60 * 1000));
                ui.setNoDataDispTimer();
            }
            if(!state_olg) cssClass += ' show-tlg';
            document.getElementById('tlg-info-banner-mask').className = cssClass;
        },
        updateClock: function() {
            var clock = document.getElementById('zapper-clock'),
                now = new Date(),
                hour = ui.addLeadingZero(now.getHours()),
                minutes = ui.addLeadingZero(now.getMinutes()),
                time;
            if(!state_olg){
                if(now % 300000 < 60000){
                    linesToRender = 3;
                     guideCreateLine(currentPage[0],1);
                    if(currentPage[1]>-1){
                        guideCreateLine(currentPage[1],2);
                    }else{
                        --linesToRender;
                    }
                    if(currentPage[2]>-1){
                        guideCreateLine(currentPage[2],3);
                    }else{
                        --linesToRender;
                    }
                }
            }
            time = hour + ':' + minutes;
            clock.innerHTML = time;
        },
        setupClockUpdate: function(){
            if(ui.clockInterval === null){
                ui.clockInterval = setInterval(ui.updateClock, 30000);
            }
        },
        clearClockUpdate: function(){
            if(ui.clockInterval){
                clearInterval(ui.clockInterval);
                ui.clockInterval = null;
            }
        },
        addLeadingZero: function(value) {
            if (value < 10) {
                value = '0' + value;
            }
            return value;
        }
    };

    channelChanger = {
        truncate: function(str){
            if (str.length > 9) {
                return str.substring(0, 7) + "...";
            } else {
                return str;
            }
        },
        setChannelLogo: function(channel, labelElement, logoElement, hi, highlight){
            var freesatServiceID = String(channel.freesatServiceID),
                channelImageIndex = config.channelIDs.indexOf(freesatServiceID), img_url,
                labelClass = labelElement.className;

            if (channelImageIndex !== -1) { // Check if channel logo is available and set
//                img_url = config.channelImages[channelImageIndex].img_hi;
                img_url = (hi)? config.channelImages[channelImageIndex].img_hi : config.channelImages[channelImageIndex].img;
                channelChanger.highlightEle(hi,highlight);
                if (labelClass.indexOf('hidden') === -1) {
                    labelClass = labelClass + ' hidden';
                }
                logoElement.setAttribute('src', img_url);

            } else { // Add invalid url to hide previous image // Clear logo and show label
                logoElement.setAttribute('src', 'noimage');
                if (labelClass.indexOf('hidden') !== -1) labelClass = labelClass.replace(' hidden', '');
                labelClass = channelChanger.highlightText(hi, labelClass);
                channelChanger.highlightEle(hi,highlight);
            }
            labelElement.className = labelClass;
        },
        highlightText: function(hi, labelClass){
            if(labelClass){
                if(hi){
                    if(labelClass.indexOf('highlight')===-1) labelClass += (' highlight')
                }else{
                    labelClass = labelClass.replace(' highlight', '');
                }
            }
            return labelClass;
        },
        highlightEle: function(hi, highlight){
            if(highlight){
                if(hi){
                    if(highlight.className.indexOf('highlight')===-1) highlight.className += (' highlight');
                }else{
                    highlight.className = highlight.className.replace(' highlight', '');
                }
            }
        },

        updateProgrammes: function() {
            var nowElement = document.getElementById('zapping-banner-now'),
                nextElement = document.getElementById('zapping-banner-next'),
                channel = vbo.currentChannel,
                channelName = channel.name || '',
//                icons = document.getElementById('tlg-banner-icons'),
                shortChannelName = channelChanger.truncate(channelName),
                selected, programmeName, description, episode, programmes, now, next, empty,
                nowTime, prog;

            notHidden = !channel.hidden;
            channelChanger.setChannelLogo(channel, document.getElementById('zapping-banner-ch-icon-label'), document.getElementById('olg-channel-logo'), true);
            nowElement.className = nowElement.className.replace(' focused', '');
            nextElement.className = nextElement.className.replace(' focused', '');

            programmes = vbo.programmes;
console.log('# programmes: ' + programmes.length);
            if (ui.no_data_avail_display) {
                empty = ui.empty_programme;
            } else {
                empty = ui.blank_cell;
            }
            if (programmes.length === 2) {
                ui.clearNoDataDispTimer();
            }
            if (programmes.length === 0) {
                now = empty;
                next = empty;
            } else if (programmes.length === 1) {
                nowTime = Math.round(new Date().getTime() / 1000);
                prog = vbo.programmes[0];

                if (prog.startTime > nowTime) {
                    now = empty;
                    next = prog;
                } else {
                    now = prog;
                    next = empty;
                }
            } else {
                now = vbo.programmes[0];
                next = vbo.programmes[1];
            }
            if (ui.column === 'now') {
                selected = now;
                nowElement.className += ' focused';
            } else {
                selected = next;
                nextElement.className += ' focused';
            }
            programmeName = selected.name || '';
            description = selected.description || 'No description available';
            episode = selected.episode;

            document.getElementById('zapping-banner-ch-no').innerHTML = channel.ccid.split(':')[1];
            document.getElementById('zapping-banner-ch-icon-label').innerHTML = shortChannelName;

            document.getElementById('programmeNameLabel-olg-now').innerHTML = now.name;
            document.getElementById('timeLabel-now').innerHTML = formatGuideTime(now.startTime);
            document.getElementById('programmeNameLabel-olg-next').innerHTML = next.name;
            document.getElementById('timeLabel-next').innerHTML = formatGuideTime(next.startTime);

            document.getElementById('record-icon-now').className = 'hidden';
            document.getElementById('reminder-icon-now').className = 'hidden';
            document.getElementById('programmeNameLabel-olg-now').classList.remove('hasIcon');
            document.getElementById('record-icon-next').className = 'hidden';
            document.getElementById('reminder-icon-next').className = 'hidden';
            document.getElementById('programmeNameLabel-olg-next').classList.remove('hasIcon');

            if (pvrEnabled()) {
                if (hasRecording(now)) {
                    document.getElementById('record-icon-now').className = 'grid-icon';
                    document.getElementById('programmeNameLabel-olg-now').classList.add('hasIcon');
                }

                if (hasRecording(next)) {
                    document.getElementById('record-icon-next').className = 'grid-icon';
                    document.getElementById('programmeNameLabel-olg-next').classList.add('hasIcon');
                }
            } else if (remindersEnabled()) {
                if (hasReminder(now)) {
                    document.getElementById('reminder-icon-now').className = 'grid-icon';
                    document.getElementById('programmeNameLabel-olg-now').classList.add('hasIcon');
                }

                if (hasReminder(next)) {
                    document.getElementById('reminder-icon-next').className = 'grid-icon';
                    document.getElementById('programmeNameLabel-olg-next').classList.add('hasIcon');
                } 
            }

            if (state_olg) {
                channelChanger.updateInfoPanel(selected, episode, channelName, programmeName, description);
                metaIcons.set(selected);
            }
//            if (!ui.visible) {
//                ui.toggle();
//            }
//
//            if (!ui.infoVisible && !ui.no_data_avail_display) {
//
//                if (ui.timeout) {
//                    clearTimeout(ui.timeout);
//                }
//                timeoutDuration = (config.LOCAL_VARS.ui_banner_timeout * 1000);
//                ui.timeout = setTimeout(ui.toggle, timeoutDuration);
//            }
        },
        updateInfoPanel: function(selected, episode, channelName, programmeName, description){
            var season = 'Season 0 Episode {e}', remaining;

                if (episode) {
                season = season.replace('{e}', episode);
            } else {
                season = '';
            }

            if (ui.column === 'now') {
                remaining = formatTimeRemaining(selected.startTime, selected.duration);
            } else {
                var startDate = new Date(selected.startTime*1000);
                var endDate = new Date((selected.startTime*1000)+(selected.duration*1000));
                var stMin = String(startDate.getMinutes());
                while(stMin.length<2){
                    stMin = '0'+stMin;
                }
                var endMin = String(endDate.getMinutes());
                while(endMin.length<2){
                    endMin = '0'+endMin;
                }
                remaining = startDate.getHours()+':'+stMin+ ' - '+ endDate.getHours()+':'+endMin;
            }
            document.getElementById('tlg-banner-ch-name').innerHTML = channelName;
            document.getElementById('tlg-banner-prog-name').innerHTML = programmeName;
            document.getElementById('tlg-banner-synopsis').innerHTML = description;
            document.getElementById('tlg-banner-season').innerHTML = season;
            document.getElementById('tlg-banner-time-remaining').innerHTML = remaining;
        },
        channelUp: function() {
            if (ui.visible) {
                ui.toggle();
            }
            vbo.nextChannel();
            vbo.bindToCurrentChannel();
            ui.setNoDataDispTimer();
        },

        channelDown: function() {

            if (ui.visible) {
                ui.toggle();
            }
            vbo.prevChannel();
            vbo.bindToCurrentChannel();
            getConfig();
            ui.setNoDataDispTimer();
        },
        changeToChannel: function(ccid){
            var channel = oipfChannelList.getItem(oipfChannelList.findListPosByCCID(ccid));
            vbo.setChannel(channel, false);
            vbo.bindToCurrentChannel();
        },
        onChannelChange: function() {
            if(!state_olg)clearGuide();
            ui.column = 'now';

            document.getElementById('programmeNameLabel-olg-now').innerHTML = '';
            document.getElementById('timeLabel-now').innerHTML = '';
            document.getElementById('programmeNameLabel-olg-next').innerHTML = '';
            document.getElementById('timeLabel-next').innerHTML = '';
            document.getElementById('record-icon-now').className = 'hidden';
            document.getElementById('record-icon-next').className = 'hidden';
            document.getElementById('reminder-icon-now').className = 'hidden';
            document.getElementById('reminder-icon-next').className = 'hidden';

            channelChanger.updateAndShowBanner();

            deferredChannelChangeAMEvent = true;
            channelChanger.checkDeferredAM();
        },

        checkDeferredAM: function() {
            if (!deferredChannelChangeAMEvent) {
                return;
            }

            var programmes = vbo.programmes;
            if (programmes.length === 0) {
                return;
            }

            var programme = programmes[0];
            var nowTime = new Date().getTime() / 1000;
            var endTime = programme.startTime + programme.duration;
            if ((programme.startTime > nowTime) || (nowTime > endTime)) {
                return;
            }

            // only send DVB event ID without dvb:// triplet for channel
            var eventID = programme.programmeID;
            if (eventID.indexOf(';') !== -1) {
                eventID = eventID.split(';')[1];
            }

            am.amEvent('/liveTv', {
                channel: {
                    sID : vbo.currentChannel.sid,
                    name: vbo.currentChannel.name
                },
                content: {
                    eventID: eventID,
                    name: programme.name,
                    startTime: programme.startTime,
                    duration: programme.duration
                },
                playback: {
                    delay: 0,
                    playSpeed: 1
                }
            });

            deferredChannelChangeAMEvent = false;
        },

        onChannelError: function(channel, error) {
            channelChanger.updateAndShowBanner();
        },

        onProgrammesChanged: function() {
            channelChanger.updateProgrammes();
            channelChanger.checkDeferredAM();
        },

        refreshBanner: function() {
            if (!ui.visible) {
                ui.column = 'now';
            }
            channelChanger.updateProgrammes();
            channelChanger.showBanner();
        },

        updateAndShowBanner: function() {
            ui.column = 'now';
            channelChanger.updateProgrammes();
            channelChanger.showBanner();
        },
        
        showBanner: function() {
            var timeoutDuration, seconds;

            if (!ui.visible) {
                am.screenView('/olg');
                ui.toggle();
            }

            if (!ui.infoVisible && !ui.no_data_avail_display) {

                if (ui.timeout) {
                    clearTimeout(ui.timeout);
                }

                // OLG : Banner timeout variable
                // 3LG : 5 mins
                seconds = (state_olg) ? config.LOCAL_VARS.ui_banner_timeout : (config.LOCAL_VARS.ui_banner_timeout * 3);
                timeoutDuration = (seconds * 1000);
                ui.timeout = setTimeout(ui.toggle, timeoutDuration);
            }
        }
    };


    function getConfig() {
        config.getQueryString();
        config.getFile(config.LOCAL_CONFIG_FILE, 'xml', config.parseXMLConfig);
    }

    function moveChannel(line_no){
        var fsname     = document.getElementById('chlogo'+(focusRow+1)+'-label');
        var flogo     = document.getElementById('chlogo'+(focusRow+1)+'img');
        var fhighlight= document.getElementById('chlogo'+(focusRow+1)+'bg');
        var sname     = document.getElementById('chlogo'+(line_no+1)+'-label');
        var logo     = document.getElementById('chlogo'+(line_no+1)+'img');
        var highlight= document.getElementById('chlogo'+(line_no+1)+'bg');
        channelChanger.setChannelLogo(oipfChannelList.getItem(topRow + focusRow), fsname, flogo, false, fhighlight);
        channelChanger.setChannelLogo(oipfChannelList.getItem(topRow+ line_no), sname, logo, true, highlight);
    }

    function formatGuideTime(seconds){
        var d = new Date(seconds * 1000),
            local_offset = d.getTimezoneOffset(),
            _date;

        if (typeof seconds !== "number") {
            return '';
        }

        try {
            _date = new Date((seconds  - (local_offset * 60)) * 1000);

            var dateStr = _date.toISOString().substr(0, _date.toISOString().length-5);
            var tArr = dateStr.split('T');
            return tArr[1].substr(0,5);
        } catch (Error) {
            _date = new Date(seconds);
            if(_date && seconds) {
                var retString  = '<h1>:<m1>';
                var tArr1 = seconds.split('T')[1].split(':');
                return retString.replace('<h1>',tArr1[0]).replace('<m1>',tArr1[1]);
            }
        }
    }

    var oipfFindPrograms = function(pos,line_no) {
        if (searching === false) {
            searching = true;
            this.mSearch = searchManager.createSearch( 1 );
            var ch = oipfChannelList.getItem(pos);
            this.mSearch.findProgrammesFromStream(ch, null);
            searchManager.onMetadataSearch = oipfOnMetadataFindProgs(this,line_no);
            this.mSearch.result.getResults(0, 2);
        }else{
            // push the search onto the stack
            search_stack.push(pos);
        }
    };
    var oipfOnMetadataFindProgs = function(scope,line_no) {
        return function(search, state) {
            if (state===0) {
                search.onMetadataSearch = null;
                guideUpdateNowNext(search.result, line_no);
                searching = false;
                if (search_stack.length) {
                    // shift first one off the stack
                    var pos = search_stack.shift();
                    oipfFindPrograms(pos,line_no+1);
                }
            }
            else {

            }
        };
    };

    var guideUpdateNowNextIcons = function(progs, line_no) {
        var now             = document.getElementById('programmeNameLabel_now'+line_no),
            now_icon_rec    = document.getElementById('programmeRecordIcon_now'+line_no),
            now_icon_rem    = document.getElementById('programmeReminderIcon_now'+line_no),
            next            = document.getElementById('programmeNameLabel_next'+line_no),
            next_time       = document.getElementById('programmeTimeHourLabel_next'+line_no),
            next_icon_rec   = document.getElementById('programmeRecordIcon_next'+line_no),
            next_icon_rem   = document.getElementById('programmeReminderIcon_next'+line_no);

        now.classList.remove('hasIcon');
        now_icon_rec.className = 'hidden';
        now_icon_rem.className = 'hidden';
        next.classList.remove('hasIcon');
        next_icon_rec.className = 'hidden';
        next_icon_rem.className = 'hidden';
    
        if (progs.length > 0) {
            if (hasRecording(progs[0].progObj)) {
                now.classList.add('hasIcon');
                now_icon_rec.className = 'grid-icon';
            } else if (hasReminder(progs[0].progObj)) {
                now.classList.add('hasIcon');
                now_icon_rem.className = 'grid-icon';
            }
        }
        if (progs.length > 1) {
            if (hasRecording(progs[1].progObj)) {
                next.classList.add('hasIcon');
                next_icon_rec.className = 'grid-icon';
            } else if (hasReminder(progs[1].progObj)) {
                next.classList.add('hasIcon');
                next_icon_rem.className = 'grid-icon';
            }
        }
    };

    var filterNowNext = function(nowNextArray) {
        if (nowNextArray.length == 0) {
            return [];
        }

        var firstProg = nowNextArray[0];
        var secondProg = nowNextArray.length == 1 ? null : nowNextArray[1];
        var timeNow = (new Date().getTime()) / 1000;
        var arr = [];

        try {
            if ((firstProg.startTime <= timeNow) && ((firstProg.startTime + firstProg.duration) > timeNow)) {
                // first prog valid for now
                arr.push(firstProg);

                if (nowNextArray.length >= 2 && (secondProg.startTime === (firstProg.startTime + firstProg.duration))) {
                    arr.push(secondProg);
                }
            } else {
                // first prog not showing now - check second
                if (nowNextArray.length >= 2 && (secondProg.startTime <= timeNow) && ((secondProg.startTime + secondProg.duration) > timeNow)) {
                    // second prog is showing now - add it as the now item but don't provide a next item
                    arr.push(secondProg);
                }
            }
            return arr;
        } catch (e) {
            freesat.console.log('ERROR filterNowNext: ' + e);
            return [];
        }
    };

    var guideUpdateNowNext = function(result, line_no) {
        var progs = filterNowNext(oipfChannelList.setProgrammes(result));
        var len = progs.length;
        // find grid line
        var now             = document.getElementById('programmeNameLabel_now'+line_no);
        var now_time        = document.getElementById('programmeTimeHourLabel_now'+line_no);
        var next            = document.getElementById('programmeNameLabel_next'+line_no);
        var next_time       = document.getElementById('programmeTimeHourLabel_next'+line_no);

        if (len > 0) {
            try{
                now.innerHTML      = progs[0].name;
                now_time.innerHTML = progs[0].startTimeString;
                if (len > 1) {
                    next.innerHTML      = progs[1].name;
                    next_time.innerHTML = progs[1].startTimeString;
                }
            }catch(e){}
        }else{
            now.innerHTML = ' No Data';
            next.innerHTML = ' No Data';
        }
        --linesToRender;
        if(linesToRender<1)updateInfoPanel();
        guideUpdateNowNextIcons(progs, line_no);
    };

    var guideCreateLine = function(pos, line_no) {
        currentPage[line_no-1] = pos;
        var lcn           = document.getElementById('ch'+line_no);
        var sname         = document.getElementById('chlogo'+line_no+'-label');
        var logo          = document.getElementById('chlogo'+line_no+'img');
        var highlight     = document.getElementById('chlogo'+line_no+'bg');
        var now           = document.getElementById('programmeNameLabel_now'+line_no);
        var now_time      = document.getElementById('programmeTimeHourLabel_now'+line_no);
        var next          = document.getElementById('programmeNameLabel_next'+line_no);
        var next_time     = document.getElementById('programmeTimeHourLabel_next'+line_no);

        var ccid  = oipfChannelList.getLcn(pos);
        var hidden = oipfChannelList.getHidden(pos);
        if (hidden === true) {
            lcn.innerHTML = "***";
        }
        else {
            lcn.innerHTML = ccid;
        }
        sname.innerHTML = oipfChannelList.getName(pos);
        channelChanger.setChannelLogo(oipfChannelList.getItem(pos), sname, logo, ((focusRow+1)===line_no), highlight);
        now.innerHTML = '';
        now_time.innerHTML = ' - -:- -';
        next.innerHTML = '';
        next_time.innerHTML = ' - -:- -';

        var progs = oipfChannelList.getProgrammes(pos);
        if (progs.length > 0) {
            // test cache is up to date. If not perform new search
            var timeNow = new Date();
            //var progEnd = (progs[0].startTime + progs[0].duration) * 1000;
            if ( progs[0].progEnd < timeNow) {
                // perform oipf search
                oipfFindPrograms(pos, line_no);
            }else {
                now.innerHTML      = progs[0].name;
                now_time.innerHTML = progs[0].startTimeString;
                if (progs.length > 1) {
                    next.innerHTML      = progs[1].name;
                    next_time.innerHTML = progs[1].startTimeString;
                }
                --linesToRender;
                guideUpdateNowNextIcons(progs, line_no);
            }
        }else {
            oipfFindPrograms(pos, line_no);
        }
    };

    var clearTLG = function(){
        for(var i=1; i<4; i++){
            document.getElementById('ch'+i).innerHTML = '';
            document.getElementById('chlogo'+i+'-label').innerHTML = '';
            document.getElementById('programmeNameLabel_now'+i).innerHTML = '';
            document.getElementById('programmeTimeHourLabel_now'+i).innerHTML = '';
            document.getElementById('programmeNameLabel_next'+i).innerHTML = '';
            document.getElementById('programmeTimeHourLabel_next'+i).innerHTML = '';
            document.getElementById('programmeRecordIcon_now'+i).className = 'hidden';
            document.getElementById('programmeRecordIcon_next'+i).className = 'hidden';
            document.getElementById('programmeReminderIcon_now'+i).className = 'hidden';
            document.getElementById('programmeReminderIcon_next'+i).className = 'hidden';
        }
    };

    function formatDuration(time) {
        var hours,
            minutes,
            duration = '';

        if (typeof time !== "number" || time === 0) {
            return '';
        }

        minutes = Math.floor(time / 60);

        if (minutes > 60) {
            hours = Math.floor(minutes / 60);
            minutes -= (hours * 60);
            duration += hours + ' hr ';
        }
        duration += minutes + ' mins';
        return duration;
    }

    function formatTimeRemaining(startTime, duration) {
        var d = new Date(),
            currentTime = d.getTime() / 1000,
            hours,
            minutes,
            remainingTimeInSeconds,
            remaining = '';

        if (typeof startTime !== "number") {
            return '';
        }
        remainingTimeInSeconds =  (startTime + duration) - currentTime;
        minutes = Math.ceil(remainingTimeInSeconds / 60);

        if (minutes > 60) {
            hours = Math.floor(minutes / 60);
            minutes -= (hours * 60);
            remaining += hours + ' hr ';
        }
        remaining += minutes + ' mins left';
        return remaining;
    }

    function setKeysetShow() {
        var red = 0x1; //red
        var green = 0x2; //green
        var yellow = 0x4; //yellow
        var blue = 0x8; //blue
        var nav = 0x10;
        var vcr = 0x20; // don't capture this (for one-touch STOP) - middleware will handle PDC-362
        var pgUpDown = 0x40;
        var info = 0x80;
        var other = 0x400; // don't capture this (for one-touch RECORD) - middleware will handle PDC-385
        var mask = nav+pgUpDown+info+green+yellow+blue+red;
        try {
            var app = document.getElementById('appmgr').getOwnerApplication(document);
            console.log('setting (show) mask: ' + mask);
            app.privateData.keyset.setValue(mask);
            console.log('value is now: ' + app.privateData.keyset.value);
            app.show();
        } catch (e) {
            // ignore
        }
        document.getElementById('olg-strapline').className = '';
    }
    function setKeysetHide() {
        var red = 0x1; //red
        var green = 0x2; //green
        var yellow = 0x4; //yellow
        var blue = 0x8; //blue
        var nav = 0x10;
        var vcr = 0x20;
        var pgUpDown = 0x40;
        var info = 0x80;
        var other = 0x400; // don't capture this (for OTR/STOP) - middleware will handle PDC-385
        var mask = nav+pgUpDown+info+green+yellow+blue;
        try {
            var app = document.getElementById('appmgr').getOwnerApplication(document);
            console.log('setting (hide) mask: ' + mask);
            app.privateData.keyset.setValue(mask);
            console.log('value is now: ' + app.privateData.keyset.value);
            app.hide();
        } catch (e) {
            // ignore
        }
        document.getElementById('olg-strapline').className = 'hidden';
    }

    var launch3LG = function() {
        if(notHidden && oipfChannelList.getLength()>0){
            clearTLG();
            clearEmptyRows(0);
            state_olg = false;
            if(ui.infoVisible) {
                var bannerMsk = document.getElementById('tlg-info-banner-mask');
                var cssClass = bannerMsk.className;
                cssClass += ' show-tlg';
                bannerMsk.className = cssClass;
            }
            resetTimer();
            document.getElementById('olg-strapline').className = 'hidden';
            document.getElementById('zapping-banner').className = 'hidden';
            document.getElementById('tlg-strapline').className = '';
            document.getElementById('tlgGuideMask').className = 'tlgGuideMask';
            document.getElementById('tlg-bg').classList.remove('hidden');
            oipfChannelList.setCurrentPos();
            var curIndex = oipfChannelList.findListPosByCCID(oipfChannelList._currentCCID);
            focusRow = curIndex % 3;
            topRow = Math.floor(curIndex/3)*3;
            tlgPageAM = 0;
            try{
                document.getElementById(ui.column + (focusRow+1)).className += ' focused';
            }catch(e){
                //ignore
            }
            getPage();
        }
    };
//    resetTimer();

    function clearEmptyRows(rows) {
        var empty_rows = 3 - rows,
            i, highlight,
            index = rows + 1;

        for (i = 0; i < empty_rows; i++) {
            document.getElementById('chlogo' + index + '-label').innerHTML = '';
            document.getElementById('chlogo'+ index + 'img').setAttribute('src', 'noimage');
            highlight= document.getElementById('chlogo'+ index + 'bg');

            if (highlight.className.indexOf('highlight') !== -1) {
                highlight.className = highlight.className.replace(' highlight', '');
            }
            index += 1;
        }
    }

    var currentPage = [-1,-1,-1];
    var getPage = function(dir) {
        try{
            var oipfChannelListLength = oipfChannelList.getLength(),
                rows = 1;

            if (topRow+1 < oipfChannelListLength) {
                rows += 1;

                if (topRow+2 < oipfChannelListLength) {
                    rows += 1;
                }
            }
            pageRows = rows;

            if (dir === 'up') {
                focusRow = rows - 1;
            }
            ++linesToRender;
            guideCreateLine(topRow,1);
            if (topRow+1 < oipfChannelListLength) {
                ++linesToRender;
                guideCreateLine(topRow+1,2);
                if (topRow+2 < oipfChannelListLength) {
                    ++linesToRender;
                    guideCreateLine(topRow+2,3);
                }else{
                    currentPage[2] = -1;
                }
            }else{
                currentPage[1] = -1;
            }
            if (rows < 3) { // Clear empty channel logostime
                clearEmptyRows(rows);
            }

            am.screenView('/tlg/nowNext/page' + tlgPageAM);
        }catch(e){
            clearGuide();
        }
    };
    
    function clearAllTimeouts() {
        clearTimeout(ui.timeout);
        clearTimeout(ui.no_data_timeout);
    }

    function hide3LG() {
        ui.clearClockUpdate();
        state_olg = true;
        try{
            var ele = document.getElementById(ui.column + (focusRow+1));
            ele.className = ele.className.split(' ')[0];
            document.getElementById('olg-strapline').className = '';
            document.getElementById('zapping-banner').className = '';
            document.getElementById('tlg-strapline').className = 'hidden';
            document.getElementById('tlgGuideMask').className = 'tlgGuideMask hidden';
            document.getElementById('tlg-bg').classList.add('hidden');
            linesToRender = 0;
        }catch(e){
            clearGuide();
        }
    }
    function resetTimer(){
        var timeoutDuration, seconds;

        if (ui.timeout) {
            clearTimeout(ui.timeout);
        }

        if (!ui.infoVisible) {
            seconds = (state_olg) ? config.LOCAL_VARS.ui_banner_timeout : (config.LOCAL_VARS.ui_banner_timeout * 3);
            timeoutDuration = Math.round(seconds * 1000);
            ui.timeout = setTimeout(ui.toggle, timeoutDuration);
        } else {
            ui.timeout = setTimeout(ui.hideAll, (5 * 60 * 1000));
        }
    }
    function onKey(evt){
        if (reminderShowing) {
            reminderPopup.onKey(evt);
        } else if (messageShowing) {
            messagePopup.onKey(evt);
        } else if (state_olg){
            olgKey(evt);
        }else{
            tlgKey(evt);
        }
    }
    function updateInfoPanel(){
        try{
            var ccid = 'ccid:'+document.getElementById('ch'+String(focusRow+1)).innerHTML;
            var channel = oipfChannelList.getItem(oipfChannelList.findListPosByCCID(ccid)),
                channelName = channel.name || '',
                progs = oipfChannelList.getProgrammes(topRow + focusRow),
                ind = (ui.column==='now')?0: 1,
                selected = progs[ind],
                programmeName = (selected && selected.name) || '',
                description = (selected && selected.description) || 'No description available',
                episode = (selected && selected.episode) || null;
            if (selected) {
                channelChanger.updateInfoPanel(selected, episode, channelName, programmeName, description);
                metaIcons.set(selected.progObj);
            }
        }catch(e){
            //data not ready yet
            console.log("INFO ERROR: " + e);
            this.upInterval = setInterval(retryUpdateInfo, 100);
        }
    }
    function retryUpdateInfo(){
        clearInterval(this.upInterval);
        updateInfoPanel();
    }
    function getSelectedOIPFProgramme() {
        var ccid = 'ccid:' + document.getElementById('ch' + String(focusRow + 1)).innerHTML;
            channel = oipfChannelList.getItem(oipfChannelList.findListPosByCCID(ccid)),
            progs = oipfChannelList.getProgrammes(topRow + focusRow),
            ind = (ui.column==='now') ? 0 : 1
        return progs[ind].progObj;
    }
    function updateIconsForSelectedProgramme() {
        var ccid = 'ccid:' + document.getElementById('ch' + String(focusRow + 1)).innerHTML;
            channel = oipfChannelList.getItem(oipfChannelList.findListPosByCCID(ccid)),
            progs = oipfChannelList.getProgrammes(topRow + focusRow);
        guideUpdateNowNextIcons(progs, (focusRow + 1));
    }
    function getSelectionMenuItems() {
        var items = [];
        items.push(ACTION_CLOSE);

        includeRecordReminderMenuItems(items);

        if (ui.column === 'now') {
            items.push(ACTION_WATCH);
        }
        return items;
    }
    function includeRecordReminderMenuItems(items) {
        var programme = getSelectedOIPFProgramme(),
            programmeIsOnNow = isProgrammeOnNow(programme),
            programmeIsFinished = isProgrammeIsFinished(programme);

        if (programmeIsFinished) {
            return;
        }

        if (pvrEnabled()) {
            items.push(hasRecording(programme) ? ACTION_CANCEL_RECORD : ACTION_RECORD);
        } else if (remindersEnabled()) {
            if (!programmeIsOnNow) {
                items.push(hasReminder(programme) ? ACTION_CANCEL_REMINDER : ACTION_SET_REMINDER);
            }
        }
    }
    function pvrEnabled() {
        return (document.getElementById('oipfcfg').localSystem.pvrEnabled === true);
    }
    function remindersEnabled() {
        return (document.getElementById('oipfcfg').localSystem.pvrEnabled === false);
    }
    function hasRecording(programObject) {
        if (!pvrEnabled()) {
            return false; // no usb hdd - recordings disabled
        }
        return MOCK_RECORDINGS ? programObject.hasRecordingDummy : programObject.hasRecording;
    }
    function hasReminder(programObject) {
        if (!remindersEnabled()) {
            return false; // reminders disabled
        }

        return MOCK_REMINDERS ? programObject.hasReminderDummy : programObject.hasReminder;
    }

    function findRecordingForProgramme(programme, optionalCcid) {
        var recordings = document.getElementById('oipfrecorder').getScheduledRecordings();
        var result = null;

        // ccid not available on next programme of vbo object, for some reason
        var ccid = optionalCcid ? optionalCcid : programme.channelID;

        for (var i = 0; i < recordings.length; i++) {
            var recording = recordings[i];
            if (!recording.channel) {
                // can happen on switch between DSAT and DTT on Pro4
                continue;
            }
            if ((recording.channel.ccid == ccid) && (recording.startTime == programme.startTime)) {
                result = recording;
                break;
            }
        }
        return result;
    }

    function dumpScheduledRecordings() {
        console.log('SCHEDULED RECORDINGS LIST:');

        var recordings = document.getElementById('oipfrecorder').getScheduledRecordings();
        for (var i = 0; i < recordings.length; i++) {
            var index = recordings[i].channel.ccid + ' @ ' + new Date(recordings[i].startTime * 1000);
            console.log('    ' + index);
        }

        if (recordings.length == 0) {
            console.log('    (no items)');
        }
    }

    function isRecordingClash(startTime, duration) {
        var startTime1 = startTime;
        var endTime1 = startTime1 + duration;

        var recordings = document.getElementById('oipfrecorder').getScheduledRecordings();
        for (var i = 0; i < recordings.length; i++) {
            var recording = recordings[i];
            var startTime2 = recording.startTime;
            var endTime2 = startTime2 + recording.duration;

            if ((endTime1 <= startTime2) || (endTime2 <= startTime1)) {
                continue; // 1 finishes before 2, or 2 finishes before 1
            }
            return true;
        }

        return false;
    }

    function isProgrammeOnNow(programObject) {
        var now = Math.round(new Date().getTime() / 1000);
        var startTime = programObject.startTime;
        var duration = programObject.duration;
        var endTime = startTime + duration;
        return (startTime <= now && now < endTime);
    }
    function isProgrammeIsFinished(programObject) {
        var now = Math.round(new Date().getTime() / 1000);
        var startTime = programObject.startTime;
        var duration = programObject.duration;
        var endTime = startTime + duration;
        return (now > endTime);
    }
    function populateSelectionMenu(items) {
        var menu = document.getElementById('tlg-SelectionMenu');
        while (menu.firstChild) {
            menu.removeChild(menu.firstChild);
        }

        for (var i = 0; i < items.length; i++) {
            var menuItemDiv = document.createElement('div');
            if ((i + 1) < items.length) {
                menuItemDiv.className = 'tlg-Lowlight';
            } else {
                menuItemDiv.id = 'tlg-Highlight';
            }
            menuItemDiv.textContent = items[i];
            menu.appendChild(menuItemDiv);

            var sepDiv = document.createElement('div');
            sepDiv.className = 'tlg-action-line';
            menu.appendChild(sepDiv);
        }

        menu.style.top = String(4 + (focusRow * 50) - ((items.length - 1) * 50)) + 'px';
    }
    function tlgRecord(programme) {
        if (!pvrEnabled()) {
            messagePopup.show(
                'set recording',
                'Connect a USB disk drive to start recording your fave shows.',
                'The first time, press \'Menu\' button then choose \'Setup/USB Device Setup\'.',
                'recording');
            return;
        }

        try {
            var recordingsManager = document.getElementById('oipfrecorder');
            console.log('recording programmeID=' + programme.programmeID + ' name="' + programme.name + '"');
            if (MOCK_RECORDINGS) {
                console.log('    WARNING - using mocked recordings')
                programme.hasRecordingDummy = true;
            } else {
                if (document.getElementById('oipfrecorder').getScheduledRecordings().length >= MAX_RECORDINGS) {
                    setTimeout(function() {
                        messagePopup.show(
                            'set recording',
                            'It has not been possible to set this recording',
                            'A maximum of ' + MAX_RECORDINGS + ' reminders and recordings may be scheduled.<br/>Press the \'Menu\' button then choose Timer/Timer Programming to manage your reminders and recordings.',
                            'recording');
                    }, 1000);
                } else {
                    var showClashWarning = isRecordingClash(programme.startTime, programme.duration);
                    recordingsManager.record(programme);

                    if (showClashWarning) {
                        setTimeout(function() {
                            messagePopup.show('recording clash', 'This programme overlaps with another recording', 'Press \'Menu\' button then choose Timer/Timer Programming for more information.', 'recording');
                        }, 1000);
                    }
                }
            }
            clearActionMenu();
            updateIconsForSelectedProgramme();
            updateInfoPanel();

            dumpScheduledRecordings();
        } catch(e){
            //data not ready yet
            console.log("REC ERROR: " + e);
        }
    }
    function tlgCancelRecord(programme) {
        if (!pvrEnabled()) {
            console.log('ERROR: not PVR enabled, ignoring one-touch STOP keypress.');
            return; // no usb hdd - recordings disabled
        }

        try {
            var recordingsManager = document.getElementById('oipfrecorder');
            console.log('cancelling recording programmeID=' + programme.programmeID + ' name="' + programme.name + '"');
            if (MOCK_RECORDINGS) {
                console.log('    WARNING - using mocked recordings')
                programme.hasRecordingDummy = false;
            } else {
                var recordingToRemove = findRecordingForProgramme(programme);
                if (recordingToRemove) {
                    recordingsManager.remove(recordingToRemove);
                    console.log('    ...done');
                } else {
                    console.log('    WARNING - failed to find recording');
                }
            }
            console.log('recording cancelled');
            clearActionMenu();
            updateIconsForSelectedProgramme();
            updateInfoPanel();

            dumpScheduledRecordings();
        } catch(e){
            //data not ready yet
            console.log("CANCEL REC ERROR: " + e);
        }
    }
    function tlgKey(evt){
        var ele;

        switch (evt.keyCode){
            case 416: // RECORD
                var programme = getSelectedOIPFProgramme();
                if (null != findRecordingForProgramme(programme)) {
                    tlgCancelRecord(programme);
                } else {
                    tlgRecord(programme);
                }
                break;
            case 413: // STOP
                tlgCancelRecord(getSelectedOIPFProgramme());
                break;
            case 13: //KEY_OK
                var ccid = 'ccid:' + document.getElementById('ch' + String(focusRow + 1)).innerHTML,
                    recordingsManager = document.getElementById('oipfrecorder'),
                    reminderManager = document.getElementById('oipfreminder'),
                    programme = getSelectedOIPFProgramme(),
                    programmeName = (programme && programme.name) || '',
                    channel = oipfChannelList.getItem(oipfChannelList.findListPosByCCID(ccid));

                if(action_menu){
                    var action = document.getElementById('tlg-Highlight').innerHTML;

                    if (channel && programme) {
                        // only send DVB event ID without dvb:// triplet for channel
                        var eventID = programme.programmeID;
                        if (eventID.indexOf(';') !== -1) {
                            eventID = eventID.split(';')[1];
                        }

                        am.screenEvent('/tlg/nowNext/page' + tlgPageAM, {
                            channel: {
                                sID : channel.sid,
                                name: channel.name
                            },
                            content: {
                                eventID: eventID,
                                name: programme.name,
                                startTime: programme.startTime,
                                duration: programme.duration
                            },
                            category: 'actionMenu',
                            action: action.toAMStandardised()
                        });
                    }

                    switch (action) {
                    case ACTION_CLOSE:
                        clearActionMenu();
                        break;
                    case ACTION_WATCH:
                        clearGuide();
                        channelChanger.changeToChannel(ccid);
                        break;
                    case ACTION_RECORD:
                        tlgRecord(programme);
                        break;
                    case ACTION_CANCEL_RECORD:
                        tlgCancelRecord(programme);
                        break;
                    case ACTION_SET_REMINDER:
                        try {
                            console.log('setting reminder for programmeID=' + programme.programmeID + ' name="' + programmeName + '"');
                            if (MOCK_REMINDERS) {
                                console.log('    WARNING - using mocked reminders')
                                programme.hasReminderDummy = true;
                                if (MOCK_REMINDER_DIALOGUE) {
                                    setTimeout(function() {
                                        reminderPopup.show(programme);
                                    }, 5000);
                                }
                            } else if (document.getElementById('oipfrecorder').getScheduledRecordings().length >= MAX_RECORDINGS) {
                                setTimeout(function() {
                                    messagePopup.show(
                                        'set reminder',
                                        'It has not been possible to set this reminder',
                                        'A maximum of ' + MAX_RECORDINGS + ' reminders and recordings may be scheduled.<br/>Press the \'Menu\' button then choose Timer/Timer Programming to manage your reminders and recordings.',
                                        'reminder');
                                }, 1000);
                            } else {
                                var showClashWarning = isRecordingClash(programme.startTime, programme.duration);
                                recordingsManager.record(programme);
                
                                if (showClashWarning) {
                                    setTimeout(function() {
                                        messagePopup.show('reminder clash', 'This programme overlaps with another reminder', 'Press \'Menu\' button then choose Timer/Timer Programming for more information.', 'reminder');
                                    }, 1000);
                                }
                            }
                            clearActionMenu();
                            updateIconsForSelectedProgramme();
                            updateInfoPanel();
                        } catch(e){
                            //data not ready yet
                            console.log("SET REMINDER ERROR: " + e);
                        }
                        break;
                    case ACTION_CANCEL_REMINDER:
                        try {
                            console.log('cancelling reminder for programmeID=' + programme.programmeID + ' name="' + programmeName + '"');
                            if (MOCK_REMINDERS) {
                                console.log('    WARNING - using mocked reminders')
                                programme.hasReminderDummy = false;
                            } else {
                                var reminderToRemove = findRecordingForProgramme(programme);
                                if (reminderToRemove) {
                                    recordingsManager.remove(reminderToRemove);
                                    console.log('    ...done');
                                } else {
                                    console.log('    WARNING - failed to find reminder');
                                }
                            }
                            console.log('reminder cancelled');
                            clearActionMenu();
                            updateIconsForSelectedProgramme();
                            updateInfoPanel();
                        } catch(e){
                            //data not ready yet
                            console.log("SET REMINDER ERROR: " + e);
                        }
                        break;
                    }
                }else{
                    try{
                        if (ui.infoVisible) {
                            ui.toggleInfo();
                        }
                        action_menu_items = getSelectionMenuItems();

                        if (action_menu_items.length == 1) {
                            // no point in showing a menu with only 'close' in it
                            resetTimer();
                        } else {
                            clearTimeout(ui.timeout);
                            action_menu = true;
                            var aItem = document.getElementById(ui.column + (focusRow+1));
                            aItem.className = aItem.className.replace(' focused', '');
                            document.getElementById(ui.column + (focusRow+1)).className += ' disable';

                            populateSelectionMenu(action_menu_items);
                            var menu = document.getElementById('tlg-SelectionMenu');
                            menu.className = '';
                            menu.style.left = (ui.column === 'now') ? '712px' : '432px';
                            console.log('setting left to: ' + menu.style.left);

                            document.getElementById('tlg-fade').classList.remove('hidden');
                        }
                    }catch(e){
                        clearGuide();
                    }
                }
                break;
            case 38: //KEY_UP;
                if(action_menu){
                    action_menu_items.unshift(action_menu_items.pop());
                    populateSelectionMenu(action_menu_items);
                }else{
                    try{
                        resetTimer();
                        if(focusRow>0){
                            ele = document.getElementById(ui.column + (focusRow+1));
                            ele.className = ele.className.split(' ')[0];
                            moveChannel(focusRow-1);
                            --focusRow;
                            document.getElementById(ui.column + (focusRow+1)).className += ' focused';
                        }else{
                            if(!pagingBusy()){
//                                linesToRender=3;
                                clearTLG();
                                ele = document.getElementById(ui.column + (focusRow+1));
                                ele.className = ele.className.split(' ')[0];
                                if(topRow>2){
                                    topRow -= 3;
                                }else{
                                    var len = oipfChannelList.getLength();
                                    topRow = Math.floor(len/3)*3;
                                    if(topRow === len){
                                        topRow-=3;
                                    }
//                                    if(topRow - len < 3)linesToRender = topRow - len;
                                }
                                tlgPageAM--;

                                getPage('up');
                                document.getElementById(ui.column + (focusRow+1)).className += ' focused';
                            }
                        }
                        updateInfoPanel();
                    }catch(e){
                        clearGuide();
                    }
                }
                break;
            case 40: //KEY_DOWN;
                if(action_menu){
                    action_menu_items.push(action_menu_items.shift());
                    populateSelectionMenu(action_menu_items);
                }else{
                    try{
                        resetTimer();
                        if (focusRow < (pageRows - 1)) {
                            ele = document.getElementById(ui.column + (focusRow+1));
                            ele.className = ele.className.split(' ')[0];
                            moveChannel(focusRow+1);
                            ++focusRow;
                            document.getElementById(ui.column + (focusRow+1)).className += ' focused';
                        } else {
                            if(!pagingBusy()){
//                                linesToRender=3;
                                clearTLG();
                                ele = document.getElementById(ui.column + (focusRow+1));
                                ele.className = ele.className.split(' ')[0];
                                if(topRow+3<oipfChannelList.getLength()){
                                    topRow += 3;
                                }else{
                                    topRow = 0;
                                }
                                focusRow = 0;
                                tlgPageAM++;

                                getPage('down');
                                document.getElementById(ui.column + (focusRow+1)).className += ' focused';
                            }
                        }
                        updateInfoPanel();
                    }catch(e){
                        clearGuide();
                    }
                }
                break;
            case 37: //KEY_LEFT;
                if(!action_menu){
                    resetTimer();
                    if(ui.column === 'next'){
                        ele = document.getElementById(ui.column + (focusRow+1));
                        ele.className = ele.className.split(' ')[0];
                        ui.column = 'now';
                        document.getElementById(ui.column + (focusRow+1)).className += ' focused';
                        updateInfoPanel();
                    }
                }
                break;

            case 39: //KEY_RIGHT;
                if(!action_menu){
                    resetTimer();
                    if(ui.column === 'now'){
                        ele = document.getElementById(ui.column + (focusRow+1));
                        ele.className = ele.className.split(' ')[0];
                        ui.column = 'next';
                        document.getElementById(ui.column + (focusRow+1)).className += ' focused';
                        updateInfoPanel();
                    }
                }
                break;
            case 33: //KEY_KEYBOARD_PAGE_UP;
                clearGuide();
                channelChanger.channelUp();
                break;
            case 34: //KEY_KEYBOARD_PAGE_DOWN;
                clearGuide();
                channelChanger.channelDown();
                break;
            case 461: // Back button
                if(action_menu){
                    clearActionMenu();
                }else{
                    clearGuide();
                }
                break;
            case 457: // Info button
                if(!action_menu){
                    if (!ui.visible) {
                        console.log('show info');
                        updateInfoPanel();
                        channelChanger.showBanner();
//                        channelChanger.updateAndShowBanner();
                    } else{
                        ui.toggleInfo();
                    }

                }
                break;
        }
    }
    function clearGuide(){
        if (ui.infoVisible) {
            ui.toggleInfo();
        }
        clearActionMenu();
        if (ui.visible) {
            ui.toggle();
            clearAllTimeouts();
        }
        hide3LG();
        linesToRender = 0;
    }
    function clearActionMenu(){
        try{
            var aItem = document.getElementById(ui.column + (focusRow+1));
            aItem.className = aItem.className.replace(' disable', '');
            document.getElementById(ui.column + (focusRow+1)).className += ' focused';
            action_menu = false;
            document.getElementById('tlg-SelectionMenu').className = 'hidden';
            document.getElementById('tlg-fade').classList.add('hidden');
            resetTimer();
        }catch(e){
            clearGuide();
        }
    }
    function actionSwap(){
        /*
        var low = document.getElementById('tlg-Lowlight');
        var high = document.getElementById('tlg-Highlight');
        var lowTxt = low.innerHTML;
        var highTxt = high.innerHTML;
        low.innerHTML = highTxt;
        high.innerHTML = lowTxt;
        */
    }
    function olgSelectedProgramme() {
        var programmes = filterNowNext(vbo.programmes);
        var now = null;
        var next = null;
        if (programmes.length === 1) {
            now = programmes[0];
            next = null;
        } else if (programmes.length >= 2) {
            now = programmes[0];
            next = programmes[1];
        }
        console.log('len: ' + programmes.length);

        console.log('now: ' + now.name);
        console.log('next: ' + next.name);
        console.log('ui.visible: ' + ui.visible);
        console.log('ui.column: ' + ui.column);

        var result = ((!ui.visible) | (ui.column === 'now')) ? now : next;
        console.log('result: ' + result.name);
        return result;
    }

    function olgRecord(programme) {
        console.log('recording programmeID=' + programme.programmeID + ' name="' + programme.name + '"');
        
        try {
            var recordingsManager = document.getElementById('oipfrecorder');

            if (!pvrEnabled()) {
                messagePopup.show(
                    'set recording',
                    'Connect a USB disk drive to start recording your fave shows.',
                    'The first time, press \'Menu\' button then choose \'Setup/USB Device Setup\'.',
                    'recording');
                return;
            }

            if (MOCK_RECORDINGS) {
                console.log('    WARNING - using mocked recordings')
                programme.hasRecordingDummy = true;
            } else {
                var showClashWarning = isRecordingClash(programme.startTime, programme.duration);
                recordingsManager.record(programme);
                
                if (showClashWarning) {
                    setTimeout(function() {
                        messagePopup.show('recording clash', 'This programme overlaps with another recording', 'Press \'Menu\' button then choose Timer/Timer Programming for more information.', 'recording');
                    }, 1000);
                }
            }
            console.log('recording scheduled');
        } catch(e){
            //data not ready yet
            console.log("REC ERROR: " + e);
        }

        channelChanger.refreshBanner();

        dumpScheduledRecordings();
    }

    function olgCancelRecord(programme) {
        console.log('cancelling recording of programmeID=' + programme.programmeID + ' channelID=' + programme.channelID + ' name="' + programme.name + '"');
        console.log(' ccid=' + vbo.currentChannel.ccid);
        
        try {
            var recordingsManager = document.getElementById('oipfrecorder');
            if (MOCK_RECORDINGS) {
                console.log('    WARNING - using mocked recordings')
                programme.hasRecordingDummy = false;
            } else {
                var recordingToRemove = findRecordingForProgramme(programme, vbo.currentChannel.ccid);
                if (recordingToRemove) {
                    recordingsManager.remove(recordingToRemove);
                    console.log('    ...done');
                } else {
                    console.log('    WARNING - failed to find recording');
                }
            }
            console.log('recording cancelled');
        } catch(e){
            //data not ready yet
            console.log("CANCEL REC ERROR: " + e);
        }

        channelChanger.refreshBanner();
        
        dumpScheduledRecordings();
    }

    function olgKey(evt){
        switch (evt.keyCode){
            case 416: // RECORD
                var programme = olgSelectedProgramme();
                if (!pvrEnabled()) {
                    console.log('ERROR: not PVR enabled, ignoring one-touch REC keypress.');
                    messagePopup.show(
                        'set recording',
                        'Connect a USB disk drive to start recording your fave shows.',
                        'The first time, press \'Menu\' button then choose \'Setup/USB Device Setup\'.',
                        'recording');
                    break;
                } else if (!programme) {
                    console.log('WARNING - couldn\'t find highlighted programme to record - ignoring');
                    break;
                }

                if (null != findRecordingForProgramme(programme, vbo.currentChannel.ccid)) {
                    olgCancelRecord(programme);
                } else {
                    olgRecord(programme);
                }
                break;
            case 413: // STOP
                var programme = olgSelectedProgramme();
                if (!pvrEnabled()) {
                    console.log('ERROR: not PVR enabled, ignoring one-touch STOP keypress.');
                    break; // no usb hdd - recordings disabled
                } else if (!programme) {
                    console.log('WARNING - couldn\'t find highlighted programme to cancel recording - ignoring');
                    break;
                }
                olgCancelRecord(programme);
                break;
            case 13: //KEY_OK
                if(channelChanger && channelChanger.hideTimeout){
                    channelChanger.hideChanger();
                }else{
                    if (ui.visible) {
                        launch3LG();
                    } else {
//                    if (!ui.visible) {
                        channelChanger.updateAndShowBanner();
                    }
                }
                break;
            case 38: //KEY_UP;
            case 40: //KEY_DOWN;
                if (ui.visible) {
                    launch3LG();
                    tlgKey(evt);
                } else {
//                if (!ui.visible) {
                    channelChanger.updateAndShowBanner();
                }
                break;
            case 37: //KEY_LEFT;
                if (ui.visible) {
                    if (ui.column === 'next') {
                        channelChanger.updateAndShowBanner();
                    } else {
                        launch3LG();
                    }
                } else {
                    channelChanger.updateAndShowBanner();
                }
                break;

            case 39: //KEY_RIGHT;
                if (ui.visible) {

                    if (ui.column === 'now') {
                        ui.column = 'next';
                        channelChanger.updateProgrammes();
                        channelChanger.showBanner();
                    } else {
                        launch3LG();
                    }
                } else {
                    channelChanger.updateAndShowBanner();
                }
                break;
            case 33: //KEY_KEYBOARD_PAGE_UP;
                channelChanger.channelUp();
                break;
            case 34: //KEY_KEYBOARD_PAGE_DOWN;
                channelChanger.channelDown();
                break;

            case 461: // Back button

                if (ui.visible) {
                    ui.toggle();
                    clearAllTimeouts();
                }
                break;

            case 457: // Info button

                if (!ui.visible) {
                    channelChanger.updateAndShowBanner();
                } else {
                    ui.toggleInfo();
                 }
                break;
        }
    }

    var pagingBusy = function(){
        return (linesToRender > 0);
    };

    var initAM = function(cb) {
        var recdataAMImplURL = config.LOCAL_VARS.recdata_loc + config.LOCAL_VARS.appMonitor;

        console.log('[olgOnly] Attempting to configure AM from ' + recdataAMImplURL);

        var primaryRegion = null;
        var secondaryRegion = null;
        try {
            var regArr = config.LOCAL_VARS.regions;
            var i, len = regArr.length,
                prId, sr_name;
            for(i=0; i<len; i++){
                prId = regArr[i].pr_id;
                if (prId) {
                    primaryRegion = prId || 'null';
                    secondaryRegion = regArr[i].sr_id  || 'null';
                } else {
                    primaryRegion = regArr[i].pr_name || 'null';
                    secondaryRegion = regArr[i].sr_name || 'null';
                }
            }
        }
        catch (e) {
            console.log('ERROR: failed to get region: ' + e);
        }


        var factory = new freesat_am.factory(
            config.LOCAL_VARS.appMonitor,
            config.LOCAL_VARS.appMonitorFailureUrl,
            config.LOCAL_VARS.appMonitorCustomData,
            config.LOCAL_VARS.appMonitorSessionTimeoutSecs,
            config.LOCAL_VARS.appMonitorSessionRefreshSecs,
            config.LOCAL_VARS.mode,
            config.LOCAL_VARS.recdata_loc, 
            primaryRegion,
            secondaryRegion);
        am = factory.build(cb);
    };

    return{

        init: function(){
            document.onkeydown = onKey;
            setKeysetHide();
            getConfig();

            setInterval(getConfig, (30 * 60 * 1000));

            initAM(function() {
                try {
                    vbo = window.oipfObjectFactory.createVideoBroadcastObject();
                    vbo.setAttribute('id', 'video');
                    vbo.onProgrammesChanged = channelChanger.onProgrammesChanged; //onProgrammesChanged;
                    vbo.onChannelChangeSucceeded = channelChanger.onChannelChange;
                    vbo.onChannelChangeError = channelChanger.onChannelError;
                    document.body.appendChild(vbo);
                    vbo.bindToCurrentChannel();
                } catch(e) {
                }
                channelChanger.updateAndShowBanner();
                document.getElementById('video').style.cssText = "width: 1280px; height: 720px;";

                try{
                    manager = window.oipfObjectFactory.createApplicationManagerObject();
                    document.body.appendChild(manager);

                    configObj = window.oipfObjectFactory.createConfigurationObject();
                    document.body.appendChild(configObj);
                }catch(e){
                }
                try {
                    searchManager = window.oipfObjectFactory.createSearchManagerObject();
    //                searchManager.onMetadataUpdate = this.onMetadataUpdate(this);
                    document.body.appendChild(searchManager);
                }
                catch (e) {
                }
                oipfChannelList.init(vbo);

                setTimeout(function() {
                    deferredChannelChangeAMEvent = true;
                    channelChanger.checkDeferredAM();
                }, 1000);
            });
        }
    };
}();