/**
 * @name ShowcaseAbout
 * @namespace
 * @memberOf freesat.controllers
 * @class
 */
accedo.Class.create('freesat.controllers.Showcaseabout', 'accedo.ui.Controller', ['freesat.view.Showcaseabout', 'freesat.language.AboutMenuEn', 'freesat.language.CommonEn'], {}, {
    //,'freesat.controllers.about.Showing','freesat.view.about.Episodes','freesat.view.about.About','freesat.controllers.about.Cast','freesat.controllers.about.More','freesat.controllers.about.Recommendations','freesat.controllers.about.Rich','freesat.controllers.about.Programme'
    //TODO: Refactor this controller with about controller
    currentFocus: 0,
    focusPosition: 0,
    elementContainer: null,
    buttons: [],
    ypositions: [],
    common: null,
    submenu: false,
    controllerLoadedInterval: null,

    /**
     * @memberOf freesat.controllers.Showcaseabout
     */
    initialize: function($super) {
        $super();
        freesat.console.log('[About Controller] initialize');
        this.common = new freesat.controllers.subabout.Common();
        this.common.setupData(this);
        this.setView(freesat.view.Showcaseabout);
    },

    /**
     * reset
     * @memberOf freesat.controllers.Showcaseabout
     */
    reset: function() {
        //XDK[warn]
        freesat.isAnimating = true;
        freesat.masterController.childContainer.getChildren()[1].smallPigVideoSize();
    },

    /**
     * setup
     * @memberOf freesat.controllers.Showcaseabout
     */
    setup: function() {
        freesat.front = this;
        freesat.isAnimating = true;
        freesat.masterController.childContainer.getChildren()[1].pigVideoSize();
        freesat.header = null;
        freesat.front.createView();
        freesat.front.setHeader();
    },

    /**
     * createView
     * @memberOf freesat.controllers.Showcaseabout
     */
    createView: function() {
        this.common.scope = this;
        this.common.setHasMenuData(this, 4);
        this.slowInterval = setInterval(this.menuCreation(this),2000);
    },

    menuCreation: function(scope){
        return function(){
            clearInterval(scope.slowInterval);
            if(!freesat.front.common.makingMenu){
                freesat.front.common.createFirstMenu(scope);
            }
        };
    },

    setHeader: function() {

        if (freesat.header) {
            if (freesat.actionData.programObject.sc_title) {
                freesat.header.setShowcaseEpisode(freesat.actionData.programObject);
            } else {
                freesat.header.setNow(freesat.actionData.programObject);
            }
            freesat.header.setProgrammeDescription('');
            if (freesat.front.controllerLoadedInterval !== null) {
                clearInterval(freesat.front.controllerLoadedInterval);
            }
        } else {

            if (freesat.front.controllerLoadedInterval === null) {
                freesat.front.controllerLoadedInterval = setInterval(freesat.front.setHeader, 25);
            }
        }
    },

    /**
     * onKey
     * @memberOf freesat.controllers.Showcaseabout
     */
    onKey: function(vKey) {
        freesat.console.log('[aboutController] onKey ' + vKey);
        var keyHandling = new freesat.controllers.subabout.KeyHandling();
        keyHandling.setScope(freesat.front);
        return keyHandling.onKey(vKey);
    }
});

accedo.ui.View.create('freesat.view.Showcaseabout', {
    type: accedo.ui.layout.Normal,
    defaultFocus: '',
    id: '#about',
    css: 'showcaseabout',
    children: [
        {
            type: accedo.ui.widget.Image,
            id: '#about-background',
            src: 'images/1280x720/background/back_showcase_about.png'
        },
        {
            id: '#header-controller',
            controller: 'freesat.controllers.subcontrollers.Header'
        },
        {
            type: accedo.ui.Container,
            id: '#container',
            css: 'container',
            children: [
                {
                    type: accedo.ui.Container,
                    id: '#leftcontainer',
                    css: 'leftcontainer'
                },
                {
                    type: accedo.ui.Container,
                    id: '#rightcontainer',
                    css: 'rightcontainer',
                    children: [
                        {
                            controller: 'freesat.controllers.subabout.About'
                        }
                    ]
                }
            ]
        }
    ]
});
accedo.ui.View.create('freesat.view.showcase.Zoom', {
    type: accedo.ui.layout.Normal,
    defaultFocus: 'zoomrightArrow',
    id: '#zoom',
    css:'zoom',
    enterAsClick: false,
    children: [

        {
            type: accedo.ui.Container,
            id:'#zoomBackGround',
            css:'zoomBackGround'
        },
        {
            type: accedo.ui.Container,
            id:'#zoommenu',
            css:'zoomMenu',
            enterAsClick: false,
            children:
            [
                {
                    type : accedo.ui.Container,
                    id : '#menuItemsContainer',
                    css : 'menuItemsContainer',
                    enterAsClick: false
                }
            ]
        },
        {
            type: accedo.ui.Container,
            id:'#zoomContainer',
            css:'zoomContainer',
            children:
            [
                {
                    type : accedo.ui.widget.Label,
                    id : '#zoomContainerTitleLabel',
                    css : 'zoomContainerTitleLabel',
                    text :''
                },
                {
                    type : accedo.ui.Container,
                    id: '#zoomProgrammeContainer',
                    css : 'zoomProgrammeContainer',
                    children :
                    [

                        {
                            type : accedo.ui.Container,
                            id:'#zoomProgrammeInformationContainer',
                            css:'zoomProgrammeInformationContainer',
                            children :
                            [
                                {
                                    type : accedo.ui.widget.Image,
                                    id : '#zoomProgrammeImage',
                                    css : 'zoomProgrammeImage-connected',
                                    src:''
                                },
                                {
                                    type: accedo.ui.Container,
                                    id:'#zoomimagegradient',
                                    css:'zoomimagegradient'
                                },
                                {
                                   type : accedo.ui.widget.Image,
                                   id : '#imageBackgroundGradient',
                                   css :'imageBackgroundGradient'
                                },
                                {
                                    type : accedo.ui.Container,
                                    id:'#programmeDetailContainer',
                                    css:'programmeDetailContainer',
                                    children : [
                                        {
                                            type : accedo.ui.widget.Image,
                                            src: '',
                                            id : '#zoomChannelLogo'
                                        },
                                        {
                                            type : accedo.ui.widget.Label,
                                            id : '#zoomProgrammeName',
                                            css : 'zoomProgrammeName zoomLabel',
                                            text : ''
                                        },
                                        {
                                            type : accedo.ui.Container,
                                            id  : '#zoomLayoutBlock',
                                            css : 'zoomLayoutBlock',
                                            children : [
                                               {
                                                    type :accedo.ui.widget.Label,
                                                    id : '#zoomProgrammeLength',
                                                    css : 'zoomProgrammeLength zoomLabel',
                                                    text : ''
                                                },
                                                {
                                                    type : accedo.ui.widget.Label,
                                                    id : '#zoomProgrammeAvailability',
                                                    css : 'zoomProgrammeAvailability zoomLabel',
                                                    text : ''
                                                }
                                            ]
                                        },
                                        {
                                            type: accedo.ui.Container,
                                            css: 'zoomLayoutBlockEpisodeAndIcons',
                                            children: [
                                                {
                                                    type : accedo.ui.widget.Label,
                                                    id : '#zoomProgrammeSeasonAndEpisode',
                                                    css : 'zoomProgrammeSeasonAndEpisode zoomLabel',
                                                    text : ''
                                                },
                                                {
                                                    type: accedo.ui.widget.Image,
                                                    id: 'ondemand',
                                                    css: 'zoomicon',
                                                    src: 'images/1280x720/icon/icon_ondemand.png'
                                                },
                                                {
                                                    type: accedo.ui.widget.Image,
                                                    id: 'pay',
                                                    css: 'zoomicon',
                                                    src: 'images/1280x720/icon/icon_paid_content.png'
                                                },
                                                {
                                                    type: accedo.ui.widget.Image,
                                                    id: 'guidance',
                                                    css: 'zoomicon',
                                                    src: 'images/1280x720/icon/icon_guidance.png'
                                                },
                                                {
                                                    type: accedo.ui.widget.Image,
                                                    id: 'threed',
                                                    css: 'zoomicon',
                                                    src: 'images/1280x720/icon/icon_3d.png'
                                                },
                                                {
                                                    type: accedo.ui.widget.Image,
                                                    id: 'hd',
                                                    css: 'zoomicon',
                                                    src: 'images/1280x720/icon/icon_HD.png'
                                                },
                                                {
                                                    type: accedo.ui.widget.Image,
                                                    id: 'subtitle',
                                                    css: 'zoomicon',
                                                    src: 'images/1280x720/icon/icon_sub.png'
                                                },
                                                {
                                                    type: accedo.ui.widget.Image,
                                                    id: 'signed',
                                                    css: 'zoomicon',
                                                    src: 'images/1280x720/icon/icon_sl.png'
                                                },
                                                {
                                                    type: accedo.ui.widget.Image,
                                                    id: 'ad',
                                                    css: 'zoomicon',
                                                    src: 'images/1280x720/icon/icon_AD.png'
                                                },
                                                {
                                                    type: accedo.ui.widget.Image,
                                                    id: 'series',
                                                    css: 'zoomicon',
                                                    src: 'images/1280x720/icon/icon_series.png'
                                                },
                                                {
                                                    type: accedo.ui.widget.Image,
                                                    id: 'dolby',
                                                    css: 'zoomicon',
                                                    src: 'images/1280x720/icon/icon_5.1audio.png'
                                                },
                                                {
                                                    type: accedo.ui.widget.Image,
                                                    id: 'ssound',
                                                    css: 'zoomicon',
                                                    src: 'images/1280x720/icon/icon_surround.png'
                                                },
                                                {
                                                    type: accedo.ui.widget.Image,
                                                    id: 'sc',
                                                    css: 'zoomicon',
                                                    src: 'images/1280x720/icon/icon_showcase.png'
                                                },
                                                {
                                                    type: accedo.ui.widget.Image,
                                                    id: 'recording',
                                                    css: 'zoomicon',
                                                    src: 'images/1280x720/icon/icon_rec.png'
                                                },
                                                {
                                                    type: accedo.ui.widget.Image,
                                                    id: 'reminder',
                                                    css: 'zoomicon',
                                                    src: 'images/1280x720/icon/icon_reminder.png'
                                                },
                                                {
                                                    type: accedo.ui.widget.Image,
                                                    id: 'filmIcon',
                                                    css: 'zoomicon',
                                                    src: 'images/1280x720/icon/icon_film.png'
                                                },
                                            ]
                                        }
                                    ]
                                },
                                {
                                    type : accedo.ui.widget.Label,
                                    id : '#zoomProgrammeLongdescription',
                                    css : 'zoomProgrammeLongdescription zoomLabel',
                                    text : ''
                                },
                                {
                                    type : accedo.ui.widget.Label,
                                    id : '#zoomProgrammesNofNN',
                                    css : 'zoomProgrammesNofNN zoomLabel',
                                    text : ''
                                }
                            ]
                        }
                    ]
                }
            ]
        },
        {
            type: accedo.ui.Container,
            id:'#zoomleft',
            css:'zoomleft zoom-arrow',
            children:
                [
                    {
                        type: freesat.widget.VTextImageButton,
                        id: '#zoomleftArrow',
                        src: 'images/1280x720/arrow/arrow_left_zoom.png',
                        text: 'previous',
                        align: 'left'
                    }
                ]
        },
        {
            type: accedo.ui.Container,
            id:'#zoomright',
            css:'zoomright zoom-arrow',
            nextLeft:'zoomleft',
            children:
            [
                {
                    type: freesat.widget.VTextImageButton,
                    id: '#zoomrightArrow',
                    src: 'images/1280x720/arrow/arrow_right_zoom.png',
                    text: 'next',
                    align: 'right'
                }
            ]
        }
    ]
});
accedo.ui.View.create("freesat.view.ShowCase", {
    type : accedo.ui.layout.Normal,
    defaultFocus: '',
    id: "#showCase",
    children : [
        {
            type: accedo.ui.widget.Image,
            id: '#backgrounnd',
//            src: 'images/demo/demo-showcase.png'
            src: 'images/1280x720/background/back_showcase.png'
        },
        {
            type: accedo.ui.Container,
            id: '#container',
            css:'container split',
            children:
                [
                    {
                        type:accedo.ui.Container,
                        id:'#header-container',
                        children:
                            [
                                {
                                    type: accedo.ui.widget.Label,
                                    id: '#pageClock',
                                    css: 'showcase-time'
                                },
                                {
                                    type: accedo.ui.Container,
                                    css: 'logoContainer',
                                    children:[
                                    {
                                        type: accedo.ui.widget.Image,
                                        id: 'freesatLogo',
                                        css: 'freesatLogo',
                                        src: 'images/1280x720/logo/freetime-125x24.png'
                                    }]
                                },
                                {
                                    type: accedo.ui.widget.Label,
                                    id: '#showcase-title'
                                },
                                {
                                    type: accedo.ui.widget.Label,
                                    id: '#showcase-strap'
                                }
                            ]
                    },
                    {
                        type:accedo.ui.Container,
                        id:'#on-demand-container',
                        css: 'hidden',
                        children:
                            [
                                {
                                    type: accedo.ui.Container,
                                    id: '#on-demand-title-container',
                                    children:
                                        [
                                            {
                                                type: accedo.ui.widget.Label,
                                                id: '#on-demand-title-label'
                                            }
                                        ]
                                },
                                {
                                    type: accedo.ui.Container,
                                    id: '#on-demand-item-container-mask',
                                    children:[
                                        {
                                            type: accedo.ui.Container,
                                            id: '#on-demand-item-container',
                                            children:[
                                            ]
                                        },
                                        {
                                            type : accedo.ui.Container,
                                            id: '#showcase-connection-on-demand-blank',
                                            css : 'showcase-connection-on-demand-blank',
                                            children:[

                                                {
                                                    type : accedo.ui.widget.Image,
                                                    id : '#showcase-disconnected-image',
                                                    css : 'showcase-disconnected-image',
                                                    src: 'images/1280x720/not_connected/showcase.png'
                                                }

                                            ]
                                        }
                                    ]
                                }
                            ]
                    },
                    {
                        type:accedo.ui.Container,
                        id:'#on-tv-container',
                        css: 'hidden',
                        children:
                            [
                                {
                                    type: accedo.ui.Container,
                                    id: '#on-tv-title-container',
                                    children:
                                        [
                                            {
                                                type: accedo.ui.widget.Label,
                                                id: '#on-tv-title-label'
                                            }
                                        ]
                                },
                                {
                                    type: accedo.ui.Container,
                                    id: '#on-tv-item-container-mask',
                                    children:[
                                    {
                                        type: accedo.ui.Container,
                                        id: '#on-tv-item-container',
                                        children:[
                                        ]
                                    },
                                    {
                                        type : accedo.ui.Container,
                                        id: '#showcase-connection-message',
                                        css : 'showcase-connection-message',
                                        children :
                                            [
                                                {
                                                    type : accedo.ui.widget.Label,
                                                    id: '#showcase-connectionLabel',
                                                    css:'showcase-connectionLabel',
                                                    text : 'get connected'
                                                },
                                                {
                                                    type : accedo.ui.widget.Label,
                                                    id: '#showcase-connectionmessageLabel',
                                                    css:'showcase-connectionmessageLabel',
                                                    text : 'To use this section, please make sure your TV is connected to the internet'
                                                },
                                                {
                                                    type : accedo.ui.widget.Button,
                                                    id: '#showcase-connectionBackButton',
                                                    css:'showcase-connectionBackButton',
                                                    text : 'Back',
                                                    nextUp:''
                                                }
                                            ]
                                    }

                                    ]
                                }
                            ]
                    },
                    {
                        type: accedo.ui.Container,
                        id: '#item-grey-out-container',
                        children:[
                            {
                                type: accedo.ui.Container,
                                id: '#left-grey',
                                css: 'hidden'
                            },
                            {
                                type: accedo.ui.Container,
                                id: '#right-grey',
                                css: 'hidden'
                            },
                            {
                                type: accedo.ui.Container,
                                id: '#bottom-grey'
                            }
                        ]
                    },
                    {
                        type: accedo.ui.Container,
                        id: "#showcase_bg_gradient"
                    },
                    {
                        type: accedo.ui.Container,
                        id: "#showcase_footer_gradient"
                    },
                    {
                        type: accedo.ui.Container,
                        id: '#arrowContainer',
                        children:[
                            {
                                type: freesat.widget.VTextImageButton,
                                id: '#leftArrow',
                                src: 'images/1280x720/arrow/arrow_left_dark_L.png',
                                text: 'more',
                                textcss: 'showcase',
                                css: 'showcase hidden',
                                align: 'left'
                            },
                            {
                                type: freesat.widget.VTextImageButton,
                                id: '#rightArrow',
                                src: 'images/1280x720/arrow/arrow_right_dark_L.png',
                                text: 'more',
                                textcss: 'showcase',
                                css: 'showcase hidden',
                                align: 'right'
                            }
                        ]
                    },
                    {
                        type:accedo.ui.Container,
                        id:'#filter-container',
                        css: 'hidden',
                        children:
                            [
                                {
                                    type:accedo.ui.Container,
                                    id:'#filter-bg'
                                },{
                                    type:accedo.ui.Container,
                                    id:'#filter-buttons'
                                }
                            ]
                    },
                    {
                        type:accedo.ui.Container,
                        id:'#scroll-bar-container',
                        css: 'showcase-scrollbar',
                        children:
                            [
                                {
                                    type: accedo.ui.Container,
                                    id: '#scroll-bar-handle',
                                    css: 'showcase-scrollbar-handle'
                                }
                            ]
                    }
//                    ,
//                    {
//                        controller : 'freesat.controllers.showcase.Zoom',
//                        id : '#zoomview'
//                    }
                ]
        }
    ]
});
accedo.ui.View.create("freesat.view.ShowCasePlaceholder", {
    type : accedo.ui.layout.Normal,
    defaultFocus: '',
    id: "#showCase",
    css: 'placeholder',
    children : [
        {
            type: accedo.ui.widget.Image,
            id: '#backgrounnd',
//            src: 'images/demo/demo-showcase.png'
            src: 'images/1280x720/background/back_showcaseplaceholder.png'
        },
        {
            type: accedo.ui.Container,
            id: '#container',
            css:'container',
            children:
                [
                    {
                        type:accedo.ui.Container,
                        id:'#header-container',
                        children:
                            [
                                {
                                    type: accedo.ui.widget.Label,
                                    id: '#pageClock',
                                    css: 'showcase-time'
                                },
                                {
                                    type: accedo.ui.Container,
                                    css: 'logoContainer',
                                    children:[
                                    {
                                        type: accedo.ui.widget.Image,
                                        id: 'freesatLogo',
                                        css: 'freesatLogo',
                                        src: 'images/1280x720/logo/freetime-125x24.png'
                                    }]
                                },
                                {
                                    type: accedo.ui.widget.Label,
                                    id: '#showcase-title'
                                },
                                {
                                    type: accedo.ui.widget.Label,
                                    id: '#showcase-strap'
                                }
                            ]
                    },
                    {
                        type : accedo.ui.widget.Image,
                        id : '#showcase-disconnected-image',
                        css : 'showcase-disconnected-image',
                        src: 'images/1280x720/not_connected/showcase.png'
                    },
                    {
                        type : accedo.ui.Container,
                        id: '#showcase-connection-message',
                        css : 'showcase-connection-message',
                        children :
                            [
                                {
                                    type : accedo.ui.widget.Label,
                                    id: '#showcase-connectionLabel',
                                    css:'showcase-connectionLabel',
                                    text : 'coming soon'
                                },
                                {
                                    type : accedo.ui.widget.Label,
                                    id: '#showcase-connectionmessageLabel',
                                    css:'showcase-connectionmessageLabel',
                                    text : "To get Showcase as soon as it's available, please make sure your TV is connected to the internet"
                                },
                                {
                                    type : accedo.ui.widget.Button,
                                    id: '#showcase-connectionBackButton',
                                    css:'showcase-connectionBackButton',
                                    text : 'Back',
                                    nextUp:''
                                }
                            ]
                    }
                ]
        }
    ]
});
/**
 * @namespace freesat.controllers.showcase
 * @memberOf freesat.controllers
 */

/**
 * Creates a new Animations instance.
 * @name Animations
 * @namespace
 * @memberof freesat.controllers.showcase
 * @class A Animations class, bla functionality.
 * @author <a href="mailto:dean.clancy@accedo.tv">Dean Clancy</a>
 */
accedo.Class.create('freesat.controllers.showcase.Animations', [], {},
    {
        tvcurrent: 'hidden',
        odcurrent: 'hidden',
        aniUp: function(area, areaTop, paging){
            if(freesat.behind.row < freesat.behind.topRow){

                if (paging) {
                    freesat.behind.topRow -= paging;
                } else {
                    --freesat.behind.topRow;
                }

                if (freesat.behind.topRow < 0) {
                    freesat.behind.topRow = 0;
                }

                accedo.Env.blockKeys();
                freesat.isAnimating = true;
                this.moveUpDown(areaTop, area + '-item-container');
                freesat.behind.updateScrollbar('up');
                freesat.behind.AM_ScreenView();
            }else{
                return true;
            }
        },
        aniDown: function(area, areaTop, paging){
            var row;

            if(freesat.behind.row > freesat.behind.topRow+2){

                if (paging) {
                    freesat.behind.topRow += paging;
                } else {
                    ++freesat.behind.topRow;
                }
                accedo.Env.blockKeys();
                freesat.isAnimating = true;

                if (area === "on-tv" ) {

                    if (freesat.behind.lastRenderedTvRow < freesat.behind.tvTotalRows) {
                        row = freesat.behind.lastRenderedTvRow + 1;
                    } else {
                        row = freesat.behind.lastRenderedTvRow;
                    }
                    freesat.behind.create.populateTVGrid(freesat.behind.rightProgrammes, false, row);
                } else {

                    if (freesat.behind.lastRenderedOdRow < freesat.behind.odTotalRows) {
                        row = freesat.behind.lastRenderedOdRow + 1;
                    } else {
                        row = freesat.behind.lastRenderedOdRow;
                    }
                    freesat.behind.create.populateODGrid(freesat.behind.leftProgrammes, false, row);
                }
                this.moveUpDown(areaTop, area + '-item-container');
                freesat.behind.updateScrollbar('down');
                freesat.behind.AM_ScreenView();

            }else{
                return true;
            }
        },
        moveUpDown : function(top, container){
            freesat.behind.get(container).root.setStyle({
                'top': String(top) + 'px'
            });
            document.getElementById(container).addEventListener('webkitTransitionEnd', this.onTransitionEnd(this, container));
        },
        onTransitionEnd : function(scope, container){
            return function(){
                document.getElementById(container).removeEventListener('webkitTransitionEnd', scope.onTransitionEnd(scope, container));
                freesat.isAnimating = false;
                accedo.Env.unblockKeys();
                freesat.behind.checkTVtop();
            };
        },

        setTVanimation: function(newAni){
            freesat.behind.get('on-tv-container').removeClass(this.tvcurrent);
            freesat.behind.get('on-tv-container').addClass(newAni);
            this.tvcurrent = newAni;
        },
        setODanimation: function(newAni){
            freesat.behind.get('on-demand-container').removeClass(this.odcurrent);
            freesat.behind.get('on-demand-container').addClass(newAni);
            this.odcurrent = newAni;
        },
        /**
         * startupAni
         * animate from instanciation outside view to split positions
         * @memberOf freesat.controllers.showcase.Animations
         */
        startupAni: function(){
            freesat.isAnimating = true;
            accedo.Env.blockKeys();
            this.setODanimation('od-on-from-left');
            this.setTVanimation('tv-on-from-right');
            document.getElementById('on-tv-container').addEventListener('webkitAnimationEnd', freesat.behind.animationClass.startupArrows);
        },
        startupArrows: function(){
            document.getElementById('on-tv-container').removeEventListener('webkitAnimationEnd', freesat.behind.animationClass.startupArrows);
            freesat.behind.animationClass.arrowInAni();
            document.getElementById('rightArrow').addEventListener('webkitAnimationEnd', freesat.behind.animationClass.startupClearup);
        },
        startupClearup: function(){
            document.getElementById('rightArrow').removeEventListener('webkitAnimationEnd', freesat.behind.animationClass.startupClearup);
            freesat.behind.animationClass.clearUpArrowInAni();
            freesat.isAnimating = false;
            accedo.Env.unblockKeys();
            if (freesat.backJourney) {
                freesat.behind.handleBackJourney();
            }
        },

        /**
         * dialogInAni
         * animate dialog into split view
         * @memberOf freesat.controllers.showcase.Animations
         */
        dialogInAni: function() {
            freesat.isAnimating = true;
            accedo.Env.blockKeys();
            this.setODanimation('od-on-from-left');
            this.setTVanimation('tv-on-from-right');
            document.getElementById('on-tv-container').addEventListener('webkitAnimationEnd', freesat.behind.animationClass.dialogInAniCleanup);
        },
        dialogInAniCleanup: function(){
            freesat.isAnimating = false;
            accedo.Env.unblockKeys();
            document.getElementById('on-tv-container').removeEventListener('webkitAnimationEnd', freesat.behind.animationClass.dialogInAniCleanup);
        },

        /**
         * dialogInAni
         * animate dialog back offscreen
         * @memberOf freesat.controllers.showcase.Animations
         */
        dialogOutAni: function(cb) {
            freesat.isAnimating = true;
            accedo.Env.blockKeys();
            this.setODanimation('od-off-to-left');
            this.setTVanimation('tv-off-to-right');
            this.dialogOutAniCallback = cb;
            document.getElementById('on-tv-container').addEventListener('webkitAnimationEnd', freesat.behind.animationClass.dialogOutAniCleanup);
        },
        dialogOutAniCleanup: function(){
            freesat.isAnimating = false;
            accedo.Env.unblockKeys();
            document.getElementById('on-tv-container').removeEventListener('webkitAnimationEnd', freesat.behind.animationClass.dialogOutAniCleanup);
            freesat.behind.animationClass.dialogOutAniCallback();
            freesat.behind.animationClass.dialogOutAniCallback = null;
        },
        
        /**
         * arrowInAni
         * fades in arrow(s) and greyouts
         * @param side <optional> left or right default both
         * @memberOf freesat.controllers.showcase.Animations
         */
        arrowInAni : function(side){
            if(side !== 'right'){
                freesat.behind.get('left-grey').removeClass('hidden');
                freesat.behind.get('left-grey').addClass('fade-in-fast-seven');
                freesat.behind.get('leftArrow').removeClass('hidden');
                freesat.behind.get('leftArrow').addClass('fade-in-fast');
            }
            if(side !== 'left'){
                freesat.behind.get('right-grey').removeClass('hidden');
                freesat.behind.get('right-grey').addClass('fade-in-fast-seven');
                freesat.behind.get('rightArrow').removeClass('hidden');
                freesat.behind.get('rightArrow').addClass('fade-in-fast');
            }
        },
        /**
         * clearUpArrowInAni
         * clears up after arrowInAni
         * @param side <optional> left or right default both
         * @memberOf freesat.controllers.showcase.Animations
         */
        clearUpArrowInAni : function(side){
            if(side !== 'right'){
                freesat.behind.get('left-grey').remove('fade-in-fast-seven');
                freesat.behind.get('leftArrow').remove('fade-in-fast');
            }
            if(side !== 'left'){
                freesat.behind.get('right-grey').remove('fade-in-fast-seven');
                freesat.behind.get('rightArrow').remove('fade-in-fast');
            }
        },
        /**
         * arrowOutAni
         * fades out arrow(s) and greyouts
         * @param side <optional> left or right default both
         * @memberOf freesat.controllers.showcase.Animations
         */
        arrowOutAni : function(side){
            if(side !== 'right'){
                freesat.behind.get('left-grey').addClass('fade-out-fast');
                freesat.behind.get('leftArrow').addClass('fade-out-fast');
            }
            if(side !== 'left'){
                freesat.behind.get('right-grey').addClass('fade-out-fast');
                freesat.behind.get('rightArrow').addClass('fade-out-fast');
            }
        },
        /**
         * clearUpArrowAni
         * clears up after arrowOutAni
         * @param side <optional> left or right default both
         * @memberOf freesat.controllers.showcase.Animations
         */
        clearUpArrowAni : function(side){
            if(side !== 'right'){
                freesat.behind.get('left-grey').removeClass('fade-out-fast');
                freesat.behind.get('left-grey').addClass('hidden');
                freesat.behind.get('leftArrow').removeClass('fade-out-fast');
                freesat.behind.get('leftArrow').addClass('hidden');
            }
            if(side !== 'left'){
                freesat.behind.get('right-grey').removeClass('fade-out-fast');
                freesat.behind.get('right-grey').addClass('hidden');
                freesat.behind.get('rightArrow').removeClass('fade-out-fast');
                freesat.behind.get('rightArrow').addClass('hidden');
            }
        },
        /**
         * menuOutAni
         * fades out menu
         * @memberOf freesat.controllers.showcase.Animations
         */
        menuOutAni : function(){
            freesat.behind.get('filter-container').addClass('fade-out-fast');
        },
        /**
         * clearUpMenuOutAni
         * clears up after menuOutAni
         * @memberOf freesat.controllers.showcase.Animations
         */
        clearUpMenuOutAni : function(){
            freesat.behind.get('filter-container').addClass('hidden');
            freesat.behind.get('filter-container').removeClass('fade-out-fast');
        },
        /**
         * menuInAni
         * fades In menu
         * @memberOf freesat.controllers.showcase.Animations
         */
        menuInAni : function(){
            freesat.behind.get('filter-container').removeClass('hidden');
            freesat.behind.get('filter-container').addClass('fade-in-fast');
        },
        /**
         * clearUpMenuInAni
         * clears up after menuInAni
         * @memberOf freesat.controllers.showcase.Animations
         */
        clearUpMenuInAni : function(){
            freesat.behind.get('filter-container').removeClass('fade-in-fast');
        },

        /**
         * aniTVtoCenterFromStart
         * animate TV to the center from split
         * @memberOf freesat.controllers.showcase.Animations
         */
        aniTVtoCenterFromStart: function(){
            freesat.behind.animationClass.arrowOutAni();
            freesat.behind.get('container').removeClass('split');
            document.getElementById('rightArrow').addEventListener('webkitAnimationEnd', freesat.behind.animationClass.aniTVtoCenterFromStartPart2);
        },
        aniTVtoCenterFromStartPart2: function(){
            freesat.behind.get('on-demand-item-container').addClass('hide-metadata');
            document.getElementById('rightArrow').removeEventListener('webkitAnimationEnd', freesat.behind.animationClass.aniTVtoCenterFromStartPart2);
            freesat.behind.animationClass.clearUpArrowAni();
            freesat.behind.animationClass.setODanimation('od-off-from-start');
            freesat.behind.animationClass.setTVanimation('tv-center-pos-from-start');
            document.getElementById('on-tv-container').addEventListener('webkitAnimationEnd', freesat.behind.animationClass.aniTVtoCenterFromStartPart3);
        },
        aniTVtoCenterFromStartPart3: function(){
            document.getElementById('on-tv-container').removeEventListener('webkitAnimationEnd', freesat.behind.animationClass.aniTVtoCenterFromStartPart3);
            var lang = new freesat.language.ShowCaseEn();
            freesat.behind.get('left-grey').addClass('tvon');
            freesat.behind.get('leftArrow').setText("");
            freesat.behind.get('rightArrow').setText("");
            freesat.behind.animationClass.arrowInAni('left');
            freesat.behind.get('filter-container').addClass('ontv-left');
            freesat.behind.get('showcase_bg_gradient').show();
            freesat.behind.animationClass.menuInAni();
            document.getElementById('leftArrow').addEventListener('webkitAnimationEnd', freesat.behind.animationClass.tvCenterClearup);
        },
        tvCenterClearup: function(){
            document.getElementById('leftArrow').removeEventListener('webkitAnimationEnd', freesat.behind.animationClass.tvCenterClearup);
            freesat.behind.animationClass.clearUpArrowInAni('left');
            freesat.behind.animationClass.clearUpMenuInAni();
            freesat.behind.state = 'ontv';
            freesat.behind.area = 'ontv';
            freesat.isAnimating = false;
            accedo.Env.unblockKeys();
            freesat.behind.checkTVtop();
            freesat.behind.showScrollbar();

            freesat.behind.AM_ScreenView();
        },

        /**
         * aniOnDemandtoCenterFromStart
         * animates on demand to the Center from the split position
         * @memberOf freesat.controllers.showcase.Animations
         */
        aniOnDemandtoCenterFromStart: function(){
            document.getElementById('rightArrow').removeEventListener('webkitAnimationEnd', freesat.behind.animationClass.aniOnDemandtoCenterFromStartPart2);
            freesat.behind.animationClass.clearUpArrowAni();
            freesat.behind.get('container').removeClass('split');
            freesat.behind.animationClass.setODanimation('od-center-pos-from-start');
            freesat.behind.animationClass.setTVanimation('tv-off-from-start');
            document.getElementById('on-tv-container').addEventListener('webkitAnimationEnd', freesat.behind.animationClass.aniOnDemandtoCenterFromStartPart3);
            freesat.behind.get("on-demand-title-label").addClass("active");
        },
        aniOnDemandtoCenterFromStartPart3: function(){
            freesat.behind.get('on-tv-item-container').addClass('hide-metadata');

            document.getElementById('on-tv-container').removeEventListener('webkitAnimationEnd', freesat.behind.animationClass.aniOnDemandtoCenterFromStartPart3);
            var lang = new freesat.language.ShowCaseEn();
            freesat.behind.get('right-grey').addClass('odon');
            freesat.behind.get('leftArrow').setText("");
            freesat.behind.get('rightArrow').setText("");
            freesat.behind.animationClass.arrowInAni('right');
            freesat.behind.animationClass.menuInAni();
            document.getElementById('rightArrow').addEventListener('webkitAnimationEnd', freesat.behind.animationClass.onDemandCenterClearup);
        },
        onDemandCenterClearup: function(){
            document.getElementById('rightArrow').removeEventListener('webkitAnimationEnd', freesat.behind.animationClass.onDemandCenterClearup);
            freesat.behind.animationClass.clearUpArrowInAni('right');
            freesat.behind.animationClass.clearUpMenuInAni();
            freesat.behind.state = 'ondemand';
            freesat.behind.area = 'ondemand';
            freesat.isAnimating = false;
            accedo.Env.unblockKeys();
            freesat.behind.showScrollbar();

            freesat.behind.AM_ScreenView();
        },


        /**
         * aniODtoCenterFromTV
         * animate od to the center from tv
         * @memberOf freesat.controllers.showcase.Animations
         */
        aniODtoCenterFromTV : function(){
            freesat.behind.animationClass.arrowOutAni('left');
            freesat.behind.animationClass.menuOutAni();
            freesat.behind.get('showcase_bg_gradient').hide();
            freesat.behind.hideScrollbar();
            document.getElementById('leftArrow').addEventListener('webkitAnimationEnd', freesat.behind.animationClass.aniODtoCenterFromTVPart2);
        },
        aniODtoCenterFromTVPart2: function(){
            freesat.behind.get('on-tv-item-container').addClass('hide-metadata');
            freesat.behind.get('on-demand-item-container').removeClass('hide-metadata');
            document.getElementById('leftArrow').removeEventListener('webkitAnimationEnd', freesat.behind.animationClass.aniODtoCenterFromTVPart2);
            freesat.behind.animationClass.clearUpArrowAni('left');

            // Make new menu
            freesat.behind.makeFilterMenu('left');
            freesat.behind.animationClass.clearUpMenuOutAni();

            freesat.behind.get('filter-container').removeClass('ontv-left');
            freesat.behind.animationClass.setODanimation('od-left-pos-to-center');
            freesat.behind.animationClass.setTVanimation('tv-center-pos-to-right');
            document.getElementById('on-tv-container').addEventListener('webkitAnimationEnd', freesat.behind.animationClass.aniODtoCenterFromTVPart3);
            freesat.behind.get("on-demand-title-label").addClass("active");
        },
        aniODtoCenterFromTVPart3: function(){
            document.getElementById('on-tv-container').removeEventListener('webkitAnimationEnd', freesat.behind.animationClass.aniODtoCenterFromTVPart3);
            var lang = new freesat.language.ShowCaseEn();
            freesat.behind.get('right-grey').addClass('odon');
            freesat.behind.animationClass.arrowInAni('right');
            document.getElementById('rightArrow').addEventListener('webkitAnimationEnd', freesat.behind.animationClass.onDemandCenterClearup);
            // step backwards until we find an item to give focus
            while (!freesat.behind.get('sc-od-' + String(freesat.behind.prevrow)+ '-' + freesat.behind.column)) {
                if (freesat.behind.column > 0) {
                    --freesat.behind.column;
                } else if (freesat.behind.prevrow > 0) {
                    --freesat.behind.prevrow;
                } else {
                    break;
                }
            }
            freesat.behind.get('sc-od-' + String(freesat.behind.prevrow)+ '-' + freesat.behind.column).setFocus();
            var row = freesat.behind.row;
            freesat.behind.row = freesat.behind.prevrow;
            freesat.behind.prevrow = row;
            freesat.behind.topRow = (freesat.behind.odTop*-1)/175;
            freesat.behind.animationClass.menuInAni();
            freesat.behind.showScrollbar();
        },


        /**
         * aniTVtoCenterFromOD
         * animate tv to the center from od
         * @memberOf freesat.controllers.showcase.Animations
         */
        aniTVtoCenterFromOD : function(){
            freesat.behind.animationClass.arrowOutAni('right');
            freesat.behind.animationClass.menuOutAni();
            freesat.behind.hideScrollbar();
            document.getElementById('rightArrow').addEventListener('webkitAnimationEnd', freesat.behind.animationClass.aniTVtoCenterFromODPart2);
        },
        aniTVtoCenterFromODPart2: function(){
            freesat.behind.get('on-tv-item-container').removeClass('hide-metadata');
            freesat.behind.get('on-demand-item-container').addClass('hide-metadata');
            document.getElementById('rightArrow').removeEventListener('webkitAnimationEnd', freesat.behind.animationClass.aniTVtoCenterFromODPart2);
            freesat.behind.animationClass.clearUpArrowAni('right');

            // Make new menu
            freesat.behind.makeFilterMenu('right');
            freesat.behind.animationClass.clearUpMenuOutAni();

            freesat.behind.get('filter-container').addClass('ontv-left');
            freesat.behind.animationClass.setODanimation('od-center-pos-to-left');
            freesat.behind.animationClass.setTVanimation('tv-right-pos-to-center');
            document.getElementById('on-tv-container').addEventListener('webkitAnimationEnd', freesat.behind.animationClass.aniTVtoCenterFromODPart3);
            freesat.behind.get("on-demand-title-label").removeClass("active");
        },
        aniTVtoCenterFromODPart3: function(){
            document.getElementById('on-tv-container').removeEventListener('webkitAnimationEnd', freesat.behind.animationClass.aniTVtoCenterFromODPart3);
            var lang = new freesat.language.ShowCaseEn();
            freesat.behind.get('left-grey').addClass('tvon');
            freesat.behind.animationClass.arrowInAni('left');
            document.getElementById('leftArrow').addEventListener('webkitAnimationEnd', freesat.behind.animationClass.tvCenterClearup);
//            freesat.behind.get('sc-tv-' + String(freesat.behind.prevrow+1)+ '-' + freesat.behind.column).setFocus();
            var row = freesat.behind.row;
            freesat.behind.row = freesat.behind.prevrow;
            freesat.behind.prevrow = row;
            freesat.behind.setTVFocus((freesat.behind.row), freesat.behind.column, true);
            freesat.behind.topRow = (freesat.behind.tvTop*-1)/175;
            freesat.behind.get('showcase_bg_gradient').show();
            freesat.behind.animationClass.menuInAni();
            freesat.behind.showScrollbar();

        }
    }
);
/**
 * Created with JetBrains WebStorm.
 * User: Dean Clancy
 * Date: 24/09/13
 * Time: 16:11
 * To change this template use File | Settings | File Templates.
 */
/*global accedo: false */
/**
 * Creates a new itemSelection instance.
 * @name ItemSelection
 * @memberof freesat.controllers.showcase
 * @class A itemSelection class, .
 * @author <a href='mailto:dean.clancy@accedo.tv'>Dean Clancy</a>
 */
accedo.Class.create('freesat.controllers.showcase.ItemSelection', [], {}, {
    handle: function(vKey) {
        var lookupOipfProgram = function(scProgram, cb) {
            if (scProgram.oipfProgram) {
                cb(scProgram.oipfProgram);
                return;
            }

            freesat.masterController.showLoading();
            freesat.dataStore.getInterface().searchProgrammes(
                scProgram.svc_id,
                scProgram.startTime,
                null,
                1,
                function(results) {
                    freesat.masterController.hideLoading();
                    var result = null;
                    if (!results || results.length === 0) {
                        cb(null);
                    } else {
                        scProgram.oipfProgram = results[0];
                        cb(scProgram.oipfProgram);
                    }
                });
        };

        switch (vKey) {
        case accedo.VKey.KEY_OK:
            var timeZoneVar = freesat.getZone();

            freesat.actionData = new freesat.models.vo.MenuObject();
            freesat.actionData.timeZone = timeZoneVar;
            freesat.behind.backItem = this;
            freesat.actionData.backFocus = this;
            freesat.actionData.programObject = this._data;
            freesat.actionData.hasMask = true;
            freesat.masterController.instanciateShowCaseZoom();
            freesat.behind.zoom_enabled = true;
            break;

        case accedo.VKey.KEY_INFO:
            freesat.actionData = new freesat.models.vo.MenuObject();
            freesat.actionData.programObject = this._data;
            freesat.actionData.backFocus = this;
            freesat.actionData.hasMask = true;
            freesat.masterController.instanciateShowcaseAbout();
            break;
            
        case accedo.VKey.KEY_REC:
            if (freesat.behind.area != 'ontv') {
                return;
            }

            if (!freesat.masterController.recordingsHandler.hasPVR()) {
                freesat.masterController.recordingsHandler.showNoHddWarning();
                return;
            }

            var scope = this;
            lookupOipfProgram(this._data, function(oipfProgram) {
                if (!oipfProgram) {
                    // TODO: error notification
                    console.log('RECORDING ERROR - couldn\'t find event in EPG to be recorded/cancelled');
                    return;
                }

                var recHandler = freesat.masterController.recordingsHandler;
                if (oipfProgram.hasRecording) {
                    if (recHandler.removeRecording(oipfProgram) === recHandler.RECORDING_CHANGE_OK) {
                        if (scope._iconvalue & 8) {
                            scope.setIconValue(scope._iconvalue ^ 8);
                        }
                        console.log('recording cancelled');
                    } else {
                        console.log('FAILED TO CANCEL RECORDING')
                    }
                } else {
                    switch (recHandler.setRecording(oipfProgram)) {
                    case recHandler.RECORDING_CLASH:
                        // ignore as recording will have been set correctly and warning dialog will be shown: fall through
                    case recHandler.RECORDING_CHANGE_OK:
                        console.log("set recording ok");
                        scope.setIconValue(this._iconvalue | 8);
                        break;
                    default:
                        console.log("RECORDING FAILURE!!!!");
                        // TODO: pop-up
                        break;
                    }
                }
            });
            break;

        case accedo.VKey.KEY_STOP:
            if ((freesat.behind.area != 'ontv') || !freesat.masterController.recordingsHandler.hasPVR()) {
                return;
            }

            var scope = this;
            lookupOipfProgram(this._data, function(oipfProgram) {
                if (!oipfProgram) {
                    // TODO: error notification
                    console.log('RECORDING ERROR - couldn\'t find event in EPG to be cancelled');
                    return;
                }

                var recHandler = freesat.masterController.recordingsHandler;
                if (recHandler.removeRecording(oipfProgram) === recHandler.RECORDING_CHANGE_OK) {
                    if (scope._iconvalue & 8) {
                        scope.setIconValue(scope._iconvalue ^ 8);
                    }
                    console.log('recording cancelled');
                } else {
                    console.log('FAILED TO CANCEL RECORDING')
                }
            });
            break;
        }
    }
});

/**
 * Creates a new ItemCreation instance.
 * @name ItemCreation
 * @namespace
 * @memberof freesat.controllers.showcase
 * @class A ItemCreation class, bla functionality.
 * @author <a href="mailto:dean.clancy@accedo.tv">Dean Clancy</a>
 */
accedo.Class.create('freesat.controllers.showcase.ItemCreation', [], {},
    {
        /**
         * populateTVGrid
         * populate on tv with contence of arr
         * @param arr
         * @memberOf freesat.controllers.showcase.ItemCreation
         */
        populateTVGrid : function (arr, startFilter, row) {
            freesat.behind.rightProgrammes = arr;

            // if we don't have enough items to fulfil special ordering requirements then add any old how...
            freesat.behind.reorderTV = (arr.length >= 9);
            if (freesat.behind.reorderTV) {
                freesat.behind.uiPlacementMap.ontv = freesat.behind.uiPlacementMapPreferred.ontv;
            } else {
                freesat.behind.uiPlacementMap.ontv = freesat.behind.uiPlacementMapFallback.ontv;
            }

            freesat.console.log('controller showcase itemCreation : populateTVGrid row=' + row + ' of ' + arr.length + ' items');
            var i, rows, len,
                parent = freesat.behind.get('on-tv-item-container');

            freesat.behind.tvTotalRows = Math.floor((freesat.behind.dataLayer.usingDsmcc ? (arr.length - 1) : (arr.length + 2)) / 3);
            var numItemsInFirstFourRows = (freesat.behind.dataLayer.usingDsmcc ? 12 : 9);
            if (!row) {
                if (arr.length > numItemsInFirstFourRows) {
                    arr = arr.slice(0, numItemsInFirstFourRows);
                }
                freesat.behind.lastRenderedTvRow = 3;
            } else if (row && freesat.behind.lastRenderedTvRow) {

                if (row > freesat.behind.lastRenderedTvRow) {
                    rows = ((freesat.behind.topRow + 2) - freesat.behind.lastRenderedTvRow) - 1;

                    if (rows >= 0) {
                        freesat.behind.lastRenderedTvRow = row + rows;
                    } else {
                        freesat.behind.lastRenderedTvRow = row;
                    }

                    len = Math.min((freesat.behind.lastRenderedTvRow * 3) + 3, arr.length + (freesat.behind.dataLayer.usingDsmcc ? 0 : 3));

                    for (i = row * 3; i < len; i++) {

                        this.generateItem(parent, i, arr[i - (freesat.behind.dataLayer.usingDsmcc ? 0 : 3)], true);
                    }
                }
                return;

            } else {
                return;
            }

            for(i = 0; i < (freesat.behind.dataLayer.usingDsmcc ? arr.length : (arr.length + 3)); i++){
                if (freesat.behind.dataLayer.usingDsmcc) {
                    this.generateItem(parent, i, arr[i], true, false);
                } else {
                    if (startFilter && freesat.behind.reorderTV) {
                        switch (i){
                            case 0:
                                this.generateItem(parent, i, arr[0], true, true);
                                break;
                            case 1: break;
                            case 2:
                                this.generateItem(parent, i, arr[3], true, false);
                                break;
                            case 3:
                            case 4:
                                break;
                            case 5:
                                this.generateItem(parent, i, arr[4], true, false);
                                break;
                            case 6:
                                this.generateItem(parent, i, arr[1], true, false);
                                break;
                            case 7:
                                this.generateItem(parent, i, arr[2], true, false);
                                break;
                            case 8:
                                this.generateItem(parent, i, arr[5], true, false);
                                break;
                            default :
                                this.generateItem(parent, i, arr[i-3], true, false);
                                break;
                        }
                    } else {
                        switch (i){
                            case 0:
                                this.generateItem(parent, i, arr[0], true, true);
                                break;
                            case 1: break;
                            case 2:
                                this.generateItem(parent, i, arr[1], true, false);
                                break;
                            case 3:
                            case 4:
                                break;
                            default :
                                this.generateItem(parent, i, arr[i-3], true, false);
                                break;
                        }
                    }
                }
            }
        },
        repopulateTVGrid: function(scope, reset, startFilter) {
            return function(arr){
                freesat.console.log('repopulateTVGrid');
                freesat.behind.get('on-tv-item-container').removeAll();
                if (reset) {
                    freesat.behind.tvTop = 0;
                    freesat.behind.topRow = 0;
                    freesat.behind.row = 0;
                    freesat.behind.animationClass.moveUpDown(0, 'on-tv-item-container');
                }
                scope.populateTVGrid(arr, startFilter);
                freesat.behind.AM_ScreenView();
            };
        },
        repopulateODGrid: function(scope, reset, startFilter) {
            return function(arr){
                freesat.console.log('repopulateODGrid');
                freesat.behind.get('on-demand-item-container').removeAll();
                if (reset) {
                    freesat.behind.odTop = 0;
                    freesat.behind.topRow = 0;
                    freesat.behind.row = 0;
                    freesat.behind.animationClass.moveUpDown(0, 'on-demand-item-container');
                }
                scope.populateODGrid(arr, startFilter);
                freesat.behind.AM_ScreenView();
            };
        },

        // reverse lookup function for back journey focus
        getODGridPositionFromIndex: function (index) {
            if (!freesat.behind.reorderOD) {
                return index;
            }
            return index <= 8 ? [2, 5, 8, 0, 1, 3, 4, 6, 7][index] : index;
        },
        
        /**
         * populateODGrid
         * populate on demand with contence of arr
         * @param arr
         * @memberOf freesat.controllers.showcase.ItemCreation
         */
        populateODGrid : function(arr, startFilter, row){
            freesat.behind.leftProgrammes = arr;

            // if we don't have enough items to fulfil special ordering requirements then add any old how...
            freesat.behind.reorderOD = (arr.length >= 9);
            if (freesat.behind.reorderOD) {
                freesat.behind.uiPlacementMap.ondemand = freesat.behind.uiPlacementMapPreferred.ondemand;
            } else {
                freesat.behind.uiPlacementMap.ondemand = freesat.behind.uiPlacementMapFallback.ondemand;
            }

            freesat.console.log('controller showcase itemCreation : populateODGrid');
            var i, rows, len, parent = freesat.behind.get('on-demand-item-container'),
                items;
            freesat.behind.odTotalRows = Math.floor((arr.length - 1) / 3);

            if (freesat.backJourney && freesat.behind.cookieTopRow > 0) {
                items = (freesat.behind.cookieTopRow * 3) + (3 * 3);

                if (items < arr.length) {
                    arr = arr.slice(0, items);
                }
                freesat.behind.lastRenderedOdRow = Math.floor(arr.length / 3) - 1;

            } else if (!row) {
                if (arr.length > 15) {
                    arr = arr.slice(0, 15);
                }
                freesat.behind.lastRenderedOdRow = 4;
            } else if (row && freesat.behind.lastRenderedOdRow) {

                if (row > freesat.behind.lastRenderedOdRow) {
                    rows = ((freesat.behind.topRow + 2) - freesat.behind.lastRenderedOdRow) - 1;

                    if (rows >= 0) {
                        freesat.behind.lastRenderedOdRow = row + rows;
                    } else {
                        freesat.behind.lastRenderedOdRow = row;
                    }
                    len = Math.min((freesat.behind.lastRenderedOdRow * 3) + 3, arr.length);

                    for (i = row * 3; i < len; i++) {
                        this.generateItem(parent, i, arr[i]);
                    }
                }
                return;
            } else {
                return;
            }
            for(i=0; i<arr.length; i++){
                if (startFilter && freesat.behind.reorderOD) {
                    switch (i){
                        case 0:
                            this.generateItem(parent, i, arr[3]);
                            break;
                        case 1:
                            this.generateItem(parent, i, arr[4]);
                            break;
                        case 2:
                            this.generateItem(parent, i, arr[0]);
                            break;
                        case 3:
                            this.generateItem(parent, i, arr[5]);
                            break;
                        case 4:
                            this.generateItem(parent, i, arr[6]);
                            break;
                        case 5:
                            this.generateItem(parent, i, arr[1]);
                            break;
                        case 6:
                            this.generateItem(parent, i, arr[7]);
                            break;
                        case 7:
                            this.generateItem(parent, i, arr[8]);
                            break;
                        case 8:
                            this.generateItem(parent, i, arr[2]);
                            break;
                        default :
                            this.generateItem(parent, i, arr[i]);
                            break;
                    }
                } else {
                    this.generateItem(parent, i, arr[i]);
                }
            }
        },
        /**
         * generateItem
         * @param parent
         * @param i
         * @param id
         * @param tv
         * @param big
         * @memberOf freesat.controllers.showcase.ItemCreation
         */
        generateItem: function(parent, i, id, tv, big){
            var item;
            if(tv){
                item = this.tvItem(Math.floor(i/3), i%3, big);
            }else{
                item = this.odItem(Math.floor(i/3), i%3);
            }
            item.onKey = freesat.behind.itemSelection.handle;
            parent.attach(item);
            item.setProgrammeData(id);
        },
        /**
         * tvItem
         * creates empty showcase tv item
         * @param row_id
         * @param col_id
         * @memberOf freesat.controllers.showcase.ItemCreation
         * @returns {freesat.widget.ShowcaseItem}
         */
        tvItem: function(row_id, col_id, big) {
            var obj = {};
            obj = this.returnNextInObj(obj, row_id, col_id, 'tv');
            if (big!==null && row_id < 3 && !freesat.behind.dataLayer.usingDsmcc){
                obj = this.recalibrateTV(obj, row_id, col_id);
            }

            return this.tvItemStrict(row_id, col_id, obj.nextUp, obj.nextDown, obj.nextLeft, obj.nextRight, big);
        },
        recalibrateTV: function(obj, row_id, col_id){
            switch (row_id){
                case 0:
                    switch (col_id){
                        case 0:
                            obj.nextRight = 'sc-tv-0-2';
                            obj.nextDown = 'sc-tv-2-0';
                            break;
                        case 2:
                            obj.nextLeft = 'sc-tv-0-0';
                            break;
                    }
                    return obj;
                case 1:
                    switch (col_id){
                        case 0:
                            obj.nextRight = 'sc-tv-0-2';
                            obj.nextDown = 'sc-tv-2-0';
                            break;
                        case 2:
                            obj.nextLeft = 'sc-tv-0-0';
                            break;
                    }
                    return obj;
                case 2:
                    switch (col_id){
                        case 0:
                            obj.nextUp = 'sc-tv-0-0';
                            break;
                        case 1:
                            obj.nextUp = 'sc-tv-0-0';
                            break;
                    }
                    return obj;
            }
        },
       /**
         * odItem
         * creates empty showcase tv item
         * @param row_id
         * @param col_id
         * @memberOf freesat.controllers.showcase.ItemCreation
         * @returns {freesat.widget.ShowcaseItem}
         */
        odItem: function(row_id, col_id) {
           var obj = {};
           obj = this.returnNextInObj(obj, row_id, col_id, 'od');
           return this.odItemStrict(row_id, col_id, obj.nextUp, obj.nextDown, obj.nextLeft, obj.nextRight);
        },
        /**
         * returnNextInObj
         * @param obj
         * @param row_id
         * @param col_id
         * @memberOf freesat.controllers.showcase.ItemCreation
         */
        returnNextInObj: function(obj, row_id, col_id, area){
            if (row_id > 0) { obj.nextUp = 'sc-'+ area + '-' +  (row_id-1) + '-' + col_id; }
            if (col_id > 0) { obj.nextLeft = 'sc-'+ area + '-' +  row_id + '-' + (col_id-1); }
            if (col_id != 2) { obj.nextRight = 'sc-'+ area + '-' +  row_id + '-' + (col_id+1); }
            obj.nextDown = 'sc-'+ area + '-' +  (row_id+1) + '-' + col_id;
            return obj;
        },
        /**
         * tvItemStrict
         * creates empty showcase tv item
         * @param row_id
         * @param col_id
         * @param nextUp
         * @param nextDown
         * @param nextLeft
         * @param nextRight
         * @memberOf freesat.controllers.showcase.ItemCreation
         * @returns {freesat.widget.ShowcaseItem}
         */
        tvItemStrict: function(row_id, col_id, nextUp, nextDown, nextLeft, nextRight, big) {
            return new freesat.widget.ShowcaseItem(this.returnItemObject(row_id, col_id, nextUp, nextDown, nextLeft, nextRight, 'false', big));
        },
        /**
         * odItemStrict
         * creates empty showcase tv item
         * @param row_id
         * @param col_id
         * @param nextUp
         * @param nextDown
         * @param nextLeft
         * @param nextRight
         * @memberOf freesat.controllers.showcase.ItemCreation
         * @returns {freesat.widget.ShowcaseItem}
         */
        odItemStrict: function(row_id, col_id, nextUp, nextDown, nextLeft, nextRight) {
            return new freesat.widget.ShowcaseItem(this.returnItemObject(row_id, col_id, nextUp, nextDown, nextLeft, nextRight, 'true'));
        },
        /**
         * returnItemObject
         * @param row_id
         * @param col_id
         * @param nextUp
         * @param nextDown
         * @param nextLeft
         * @param nextRight
         * @param od
         * @memberOf freesat.controllers.showcase.ItemCreation
         * @returns {{id: string, overlaysrc: string, overlayfocusedsrc: string, od: *, css: string}}
         */
        returnItemObject: function(row_id, col_id, nextUp, nextDown, nextLeft, nextRight, od, big) {
            var area;
            if (od == 'true') area = 'od'; else area = 'tv';
            var obj = { id: '#sc-' + area + '-' + row_id + '-' + col_id,
                        overlaysrc: 'images/placeholders/sc-off-item.png',
                        overlayfocusedsrc: 'images/placeholders/sc-on-item.png',
                        od: od,
                        css: 'sc-'+area+'-item'
            };
            if (big===true){
                obj.css = obj.css + '-big';
                obj.size = [530,340];
                obj.overlaysrc = 'images/placeholders/sc-off-item-big.png';
                obj.overlayfocusedsrc = 'images/placeholders/sc-on-item-big.png';
            }
            if (nextUp){ obj.nextUp = nextUp; }
            if (nextLeft){ obj.nextLeft = nextLeft; }
            if (nextRight){ obj.nextRight = nextRight; }
            if (nextDown){ obj.nextDown = nextDown; }
            return obj;
        }
    }
);
/**
 * Creates a new KeyHandling instance.
 * @name KeyHandling
 * @namespace
 * @memberof freesat.controllers.showcase
 * @class A KeyHandling class, bla functionality.
 * @author <a href="mailto:dean.clancy@accedo.tv">Dean Clancy</a>
 */
accedo.Class.create('freesat.controllers.showcase.KeyHandling', [], {},
    {
        onKey: function(vKey){
            switch (vKey){
                case accedo.VKey.KEY_UP:
                    return this.onUpKey();
                case accedo.VKey.KEY_DOWN:
                    return this.onDownKey();
                case accedo.VKey.KEY_RIGHT:
                    return this.onRightKey();
                case accedo.VKey.KEY_LEFT:
                    return this.onLeftKey();
                case accedo.VKey.KEY_OK:
                    return this.onOKKey();
                case accedo.VKey.KEY_PAGE_UP:
                case accedo.VKey.KEY_KEYBOARD_PAGE_UP:
                    return this.onPageUpKey();
                case accedo.VKey.KEY_PAGE_DOWN:
                case accedo.VKey.KEY_KEYBOARD_PAGE_DOWN:
                    return this.onPageDownKey();
            }
        },
        onOKKey: function(){
            if(freesat.behind.area == 'filter'){
                var btnPressed = freesat.behind.filtersArr[freesat.behind.currentFilter];
                return true;
            }
            return false;
        },
        onUpKey: function(){
            if(freesat.behind.area == 'filter'){
                freesat.behind.clearFilterInterval();
                --freesat.behind.currentFilter;
                if (freesat.behind.currentFilter < 0) freesat.behind.currentFilter = freesat.behind.filtersArr.length -1;
                freesat.behind.makeButtons();
                freesat.behind.setFilterInterval();
                return true;
            }else if(freesat.behind.row > 0){
                freesat.behind.row -=1;
                if(freesat.behind.area == 'ontv' && freesat.behind.row<2 && freesat.behind.column<2){
                    freesat.behind.row -=freesat.behind.buttonVGrid[freesat.behind.row][freesat.behind.row];
                    this.checkBig();
                }
                if (freesat.behind.state == 'ontv' && freesat.behind.area == 'ontv'){
                    freesat.behind.tvTop+=175;
                    if(freesat.behind.animationClass.aniUp('on-tv', freesat.behind.tvTop))freesat.behind.tvTop-=175;
                }else if (freesat.behind.state == 'ondemand' && freesat.behind.area == 'ondemand'){
                    freesat.behind.odTop+=175;
                    if(freesat.behind.animationClass.aniUp('on-demand', freesat.behind.odTop))freesat.behind.odTop-=175;
                }
                return false;
            }
            return true;
        },
        onDownKey: function(){
            if (freesat.behind.area == 'filter') {
                freesat.behind.clearFilterInterval();
                ++freesat.behind.currentFilter;
                if (freesat.behind.currentFilter >= freesat.behind.filtersArr.length) freesat.behind.currentFilter = 0;
                freesat.behind.makeButtons();
                freesat.behind.setFilterInterval();
                return true;
            } else {
                var dataSet = (freesat.behind.state == 'ontv')? freesat.behind.rightProgrammes : freesat.behind.leftProgrammes;
                var dataLength = dataSet.length;

                if (freesat.behind.state === 'ontv' && !freesat.behind.dataLayer.usingDsmcc) {
                    dataLength += 3;
                }

                if (freesat.behind.row < Math.floor((dataLength - 1) / 3)) {
                    if(!(freesat.behind.state == 'split' && freesat.behind.row > 1)){
                        freesat.behind.row +=1;
                        if(freesat.behind.area == 'ontv' && freesat.behind.row<2 && freesat.behind.column<2){
                            freesat.behind.row +=freesat.behind.buttonVGrid[freesat.behind.row][freesat.behind.row];
                            this.checkBig();
                        }

                        if (freesat.behind.state == 'ontv' && freesat.behind.area == 'ontv') {
                            freesat.behind.tvTop -= 175;

                            if(freesat.behind.animationClass.aniDown('on-tv', freesat.behind.tvTop))freesat.behind.tvTop+=175;

                            if (freesat.behind.row * 3 + freesat.behind.column >= dataLength) {

                                if (freesat.behind.get("sc-tv-" + freesat.behind.row + "-" + (freesat.behind.column - 1))) {
                                    freesat.behind.get("sc-tv-" + freesat.behind.row + "-" + (freesat.behind.column - 1)).setFocus();
                                    --freesat.behind.column;
                                } else {
                                    freesat.behind.get("sc-tv-" + freesat.behind.row + "-0").setFocus();
                                    freesat.behind.column = 0;
                                }
                            }
                        } else if (freesat.behind.state == 'ondemand' && freesat.behind.area == 'ondemand') {
                            freesat.behind.odTop -= 175;

                            if (freesat.behind.animationClass.aniDown('on-demand', freesat.behind.odTop)) {
                                freesat.behind.odTop+=175;
                            }

                            if ((freesat.behind.row * 3) + freesat.behind.column >= dataLength) {

                                if (freesat.behind.get("sc-od-" + freesat.behind.row + "-" + (freesat.behind.column - 1))) {
                                    freesat.behind.get("sc-od-" + freesat.behind.row + "-" + (freesat.behind.column - 1)).setFocus();
                                    --freesat.behind.column;
                                } else {
                                    freesat.behind.get("sc-od-" + freesat.behind.row + "-0").setFocus();
                                    freesat.behind.column = 0;
                                }
                            }
                        }
                    } else {
                        return true;
                    }
                    return false;
                }
                return true;
            }
        },
        onRightKey: function(){
            if(freesat.behind.column < 3){
                freesat.behind.column +=1;
                if((freesat.behind.state == 'split' || freesat.behind.area == 'ontv') && freesat.behind.row<3 && freesat.behind.column<3){
                    freesat.behind.column +=freesat.behind.buttonHGrid[freesat.behind.row][freesat.behind.column];
                    this.checkBig();
                }
            }
            switch (freesat.behind.state){
                case 'split':
                    if(freesat.behind.area == 'ontv' && freesat.behind.column == 2){
                        //animate ontv to center
                        freesat.isAnimating = true;
                        accedo.Env.blockKeys();
                        freesat.behind.makeFilterMenu('right');
                        freesat.behind.prevrow = freesat.behind.row;
                        freesat.behind.animationClass.aniTVtoCenterFromStart();
                    }else if(freesat.behind.area == 'ondemand' && freesat.behind.column > 2){
                        freesat.behind.area = 'ontv';
                        freesat.behind.column = 0;
                        freesat.behind.setTVFocus((freesat.behind.row), freesat.behind.column);
                        freesat.behind.prevrow = freesat.behind.row;
                        this.switchSectionHighlightTo('tv');
                        freesat.behind.setStraplineText(false);
                        return true;
                    }
                    break;
                case 'ontv':
                    if(freesat.behind.area == 'filter'){
                        this.removeFocusFromFilter();
                        return true;
                    }else{
                        if (!freesat.behind.get("sc-tv-" + freesat.behind.row + "-" + freesat.behind.column)) {
                            --freesat.behind.column;
                            return true;
                        }
                    }
                    return false;
                case 'ondemand':
                    if(freesat.behind.area == 'filter'){
                        this.removeFocusFromFilter();
                        return true;
                    }else{
                        if (!freesat.behind.get("sc-od-" + freesat.behind.row + "-" + freesat.behind.column)) {
                            //animate ontv to center
                            freesat.behind.column = 0;
                            freesat.isAnimating = true;
                            accedo.Env.blockKeys();
                            this.switchSectionHighlightTo('tv');
                            var dataLayer = freesat.behind.dataLayer;
                            if(!(dataLayer.expiryDT && dataLayer.notTimeToRefresh(dataLayer))) {
                                freesat.behind.updateItems('tv', freesat.behind, true);
                            }
                            freesat.behind.animationClass.aniTVtoCenterFromOD();
                            freesat.behind.setStraplineText(false);
                            return true;
                        }
                    }
                    break;
            }
        },
        onLeftKey: function(){
            if(freesat.behind.column > -1){
                freesat.behind.column -=1;
                if(freesat.behind.area == 'ontv' && freesat.behind.row<3 && freesat.behind.column > -1){
                    freesat.behind.column -=freesat.behind.buttonHGrid[freesat.behind.row][freesat.behind.column];
                    this.checkBig();
                }
            }
            switch (freesat.behind.state){
                case 'split':
                    if(freesat.behind.area == 'ontv' && freesat.behind.column == -1){
                        freesat.behind.area = 'ondemand';
                        freesat.behind.column = 2;
                        freesat.behind.get('sc-od-' + String(freesat.behind.row) + '-' + freesat.behind.column).setFocus();
                        this.switchSectionHighlightTo('od');
                        freesat.behind.prevrow = freesat.behind.row;
                        freesat.behind.setStraplineText(true);
                        return true;
                    }else if(freesat.behind.area == 'ondemand' && freesat.behind.column === 1){
                        // animate ondemand to center
                        freesat.isAnimating = true;
                        accedo.Env.blockKeys();
                        freesat.behind.makeFilterMenu('left');
                        this.switchSectionHighlightTo('od');
                        freesat.behind.prevrow = freesat.behind.row;
                        freesat.behind.animationClass.aniOnDemandtoCenterFromStart();
                        freesat.behind.column = 1;
                    }
                    break;
                case 'ontv':
                    if (freesat.behind.area === 'filter') {
                        freesat.isAnimating = true;
                        accedo.Env.blockKeys();
                        this.switchSectionHighlightTo('od');
                        var dataLayer = freesat.behind.dataLayer;
                        if(!(dataLayer.expiryDT && dataLayer.notTimeToRefresh(dataLayer))) {
                            freesat.behind.updateItems('od', freesat.behind, true);
                        }
                        freesat.behind.animationClass.aniODtoCenterFromTV();
                        freesat.behind.column = 2;
                        freesat.behind.get('filter-bg').removeClass('highlight');
                        freesat.behind.setStraplineText(true);
                        return true;
                    }else{
                        if(freesat.behind.column < 0){ //filter
                            freesat.behind.column = 0;
                            this.setFocusToFilter();
                        }
                        freesat.behind.checkTVtop();
                    }
                    break;
                case 'ondemand':
                    if(freesat.behind.area !== 'filter'){
                        if(freesat.behind.column < 0) {
                            freesat.behind.column = 0;
                            this.setFocusToFilter();
                        }
                    }
                    break;
            }
        },

        onPageUpKey: function() {
            var rows, distance;

            if (freesat.behind.state !== 'split' && freesat.behind.area !== 'filter') {

                if (freesat.behind.topRow === 0) {
                    return false;
                }

                if ((freesat.behind.row - 3) < 0) {
                     rows = 3 + (freesat.behind.row - 3);
                } else {
                    rows = 3;
                }
                freesat.behind.row -= rows;

                if (freesat.behind.area === 'ontv' && freesat.behind.row < 2 && freesat.behind.column < 2) {
                    freesat.behind.row -= freesat.behind.buttonVGrid[freesat.behind.row][freesat.behind.row];
                    this.checkBig();
                }

                distance = rows * 175;

                if (freesat.behind.state === 'ontv' && freesat.behind.area === 'ontv') {
                    freesat.behind.tvTop += distance;

                    if (freesat.behind.tvTop > 0) {
                        freesat.behind.tvTop = 0;
                    }

                    if (freesat.behind.animationClass.aniUp('on-tv', freesat.behind.tvTop, rows)) {
                        freesat.behind.tvTop -= distance;
                    } else {

                        if (freesat.behind.get("sc-tv-" + freesat.behind.row + "-" + (freesat.behind.column))) {
                            freesat.behind.get("sc-tv-" + freesat.behind.row + "-" + (freesat.behind.column)).setFocus();
                        }
                    }
                } else if (freesat.behind.state === 'ondemand' && freesat.behind.area === 'ondemand'){
                    freesat.behind.odTop += distance;

                    if (freesat.behind.odTop > 0) {
                        freesat.behind.odTop = 0;
                    }

                    if(freesat.behind.animationClass.aniUp('on-demand', freesat.behind.odTop, rows)) {
                        freesat.behind.odTop -= distance;
                    } else {

                        if (freesat.behind.get("sc-od-" + freesat.behind.row + "-" + (freesat.behind.column))) {
                            freesat.behind.get("sc-od-" + freesat.behind.row + "-" + (freesat.behind.column)).setFocus();
                        }
                    }
                }
                return false;
            }
            return true;


        },

        onPageDownKey: function() {
            var total_rows, data, data_length, rows, distance;

            if (freesat.behind.state !== 'split' && freesat.behind.area !== 'filter') {
                data = (freesat.behind.state === 'ontv')? freesat.behind.rightProgrammes : freesat.behind.leftProgrammes;
                data_length = freesat.behind.state === 'ontv' ? data.length + 3 : data.length;
                total_rows = Math.floor((data_length - 1) / 3);

                if (freesat.behind.row + 3 < total_rows  || freesat.behind.topRow + 3 <= total_rows) {

                    if (freesat.behind.row + 3 > total_rows) {
                        rows = total_rows - (freesat.behind.topRow + 3);
                    } else {
                        rows = 3;
                    }
                    freesat.behind.row += rows;
                    distance = rows * 175;

                    if (freesat.behind.state === 'ontv' && freesat.behind.area === 'ontv') {
                        freesat.behind.tvTop -= distance;
                        freesat.behind.tvTotalRows = total_rows;

                        if (freesat.behind.animationClass.aniDown('on-tv', freesat.behind.tvTop, rows)) {
                            freesat.behind.tvTop += distance;
                        }

                        if (freesat.behind.row * 3 + freesat.behind.column <= data_length) {

                            if (freesat.behind.get("sc-tv-" + freesat.behind.row + "-" + freesat.behind.column)) {
                                freesat.behind.get("sc-tv-" + freesat.behind.row + "-" + freesat.behind.column).setFocus();
                            } else {
                                freesat.behind.get("sc-tv-" + freesat.behind.row + "-0").setFocus();
                                freesat.behind.column = 0;
                            }
                        }
                    } else if (freesat.behind.state === 'ondemand' && freesat.behind.area === 'ondemand') {
                        freesat.behind.odTop -= distance;
                        freesat.behind.odTotalRows = total_rows;

                        if (freesat.behind.animationClass.aniDown('on-demand', freesat.behind.odTop, rows)) {
                            freesat.behind.odTop += distance;
                        }
                        if (freesat.behind.row * 3 + freesat.behind.column <= data_length) {

                            if (freesat.behind.get("sc-od-" + freesat.behind.row + "-" + freesat.behind.column)) {
                                freesat.behind.get("sc-od-" + freesat.behind.row + "-" + freesat.behind.column).setFocus();
                            } else {
                                freesat.behind.get("sc-od-" + freesat.behind.row + "-0").setFocus();
                                freesat.behind.column = 0;
                            }
                        }
                    }
                }
                return true;
            }
            return false;
        },
        /**
         * setFocusToFilter
         * @memberOf freesat.controllers.showcase.KeyHandling
         */
        setFocusToFilter: function(){
            freesat.behind.get('filter-button-item'+freesat.behind.currentFilter).setFocus();
            freesat.behind.get('filter-bg').addClass('highlight');
            freesat.behind.area = 'filter';
        },
        /**
         * removeFocusFromFilter
         * @memberOf freesat.controllers.showcase.KeyHandling
         */
        removeFocusFromFilter: function(){
            var itemStr = (freesat.behind.state=='ontv')? 'sc-tv-' : 'sc-od-';
            freesat.behind.column = 0;
            freesat.behind.get(itemStr+freesat.behind.row+'-'+freesat.behind.column).setFocus();
            freesat.behind.get('filter-bg').removeClass('highlight');
            freesat.behind.area = freesat.behind.state;
        },
        /**
         * Change the low light
         * @param section
         * @memberOf freesat.controllers.showcase.KeyHandling
         */
        switchSectionHighlightTo : function(section){
            if(section == 'tv'){
                freesat.behind.get('on-tv-title-container').removeClass('lowlight');
                freesat.behind.get('on-demand-title-container').addClass('lowlight');
            }else{
                freesat.behind.get('on-tv-title-container').addClass('lowlight');
                freesat.behind.get('on-demand-title-container').removeClass('lowlight');
            }
        },
        checkBig: function(){
            if (freesat.behind.dataLayer.usingDsmcc) {
                return;
            }
            if(freesat.behind.row < 2 && freesat.behind.column < 2){
                freesat.behind.row = 0;
                freesat.behind.column = 0;
            }
        }
    }
);
/**
 * Created with JetBrains WebStorm.
 * User: sbarnes2
 * Date: 15/10/2013
 * Time: 13:52
 * To change this template use File | Settings | File Templates.
 */
accedo.Class.create('freesat.controllers.showcase.ZoomKeyHandling', [], {},
    {
        onKey: function(vKey){
            switch (vKey){
                case accedo.VKey.KEY_UP:
                    return this.onUpKey();
                case accedo.VKey.KEY_DOWN:
                    return this.onDownKey();
                case accedo.VKey.KEY_RIGHT:
                    return this.onRightKey();
                case accedo.VKey.KEY_LEFT:
                    return this.onLeftKey();
                case accedo.VKey.KEY_OK:
                case accedo.VKey.KEY_ENTER:
                    return this.onEnterKey();
                case accedo.VKey.KEY_BACK:
                    return this.onBackKey();
                case accedo.VKey.KEY_INFO:
                    return this.onInfoKey();
                case accedo.VKey.KEY_REC:
                    return this.onRecKey();
                case accedo.VKey.KEY_STOP:
                    return this.onStopKey();
            }
        },
        onUpKey: function(){
           freesat.overlay.navigateMenu_Down();
        },
        onDownKey: function(){
            freesat.overlay.navigateMenu_Up();
        },
        onRightKey: function(){
            freesat.overlay.get('zoomrightArrow').active();

            setTimeout(function() {
                freesat.overlay.increment_pick_index();
            }, 50);
        },
        onLeftKey: function(){
            freesat.overlay.get('zoomleftArrow').active();

            setTimeout(function() {
                freesat.overlay.decrement_pick_index();
            }, 50);
        },
        onEnterKey: function (){
            freesat.overlay.process_menu_option();
        },
        onBackKey: function () {
            freesat.masterController.returnFromShowCaseZoom();
            return true;
        },
        onInfoKey: function () {
            freesat.masterController.instanciateShowcaseAbout();
            return true;
        },
        onRecKey: function () {
            if (!freesat.masterController.recordingsHandler.hasPVR()) {
                freesat.masterController.recordingsHandler.showNoHddWarning();
                return;
            }

            freesat.overlay.doRecord();
            return true;
        },
        onStopKey: function() {
            if (!freesat.masterController.recordingsHandler.hasPVR()) {
                return;
            }
            freesat.overlay.doCancelRecord();
            return true;
        }
        
    }
);
accedo.Class.create('freesat.controllers.showcase.ZoomAnimation', [], {},{

});

/**
 * Created with JetBrains WebStorm.
 * User: sbarnes2
 * Date: 14/10/2013
 * Time: 12:15
 * CONTROLLER
 * To change this template use File | Settings | File Templates.
 */
accedo.Class.create("freesat.controllers.showcase.Zoom", 'accedo.ui.Controller', ['freesat.view.showcase.Zoom','freesat.controllers.showcase.ZoomAnimation', 'freesat.controllers.showcase.ZoomKeyHandling'], {},{
    SELECTED_MENU_ITEM : 1,
    menuLabels : [],
    animationClass : null,
    mode : 'offline',
    data : null,
    lang : null,
    pick_index : 1,
    programmeOrigin : 'on demand',
    imgFactory: null,
    initialize: function($super) {
        $super();
        freesat.console.log('[ShowCase Zoom Controller] initialize');
        this.setView(freesat.view.showcase.Zoom);
    },
    setup : function (){
        var AM_urlParam;

        freesat.overlay = this ;
        freesat.behind.zoom_enabled = true;
        this.get("programmeDetailContainer").hide();
        this.get('zoomProgrammeImage').hide();
        this.animationClass = new freesat.controllers.showcase.ZoomAnimation();
        this.imgFactory = new freesat.models.Imagefactory();
        this.lang = new freesat.language.ShowCaseEn();
        this.imagefactory = new freesat.models.Imagefactory();

        this.getData();
        freesat.behind.get('container').addClass('is-in-background');

        this.AM_ScreenView();
    },
    postSetup: function () {
        freesat.overlay.get("zoomrightArrow").setFocus();
    },

    setUpMenu: function () {
        if ((freesat.behind.area === 'ontv') && !freesat.actionData.programObject.oipfProgramme) {
            // populate OIPF programme object from EPG so we can check for recordings/reminders
            freesat.overlay.get("programmeDetailContainer").hide();
            freesat.overlay.get('zoomProgrammeImage').hide();
            freesat.masterController.showLoading();
            
            var programme = freesat.actionData.programObject;
            freesat.dataStore.getInterface().searchProgrammes(
                programme.svc_id,
                programme.startTime,
                null,
                1,
                function(results) {
                    freesat.masterController.hideLoading();
                    var result = null;
                    if (!results || results.length === 0) {
                        freesat.console.log('WARNING - EPG search failed: won\'t be able to show recording/reminder options');
                    } else {
                        freesat.actionData.programObject.oipfProgramme = results[0];
                    }
                    freesat.overlay.showMenu();
                    freesat.overlay.get('programmeDetailContainer').show();
                    freesat.overlay.get('zoomProgrammeImage').show();
                });
        } else {
            freesat.overlay.showMenu();
        }
    },
    
    showMenu : function() {
        var zoommenuitemcontainer = this.get('menuItemsContainer'),
            programObject,
            now, end, on_now, unfinished;

        if (freesat.behind.area === 'ontv') {
            now = Math.round(new Date().getTime() / 1000);
            programObject = freesat.actionData.programObject;
            end = programObject.startTime + programObject.duration;

            on_now = (now >= programObject.startTime && now < end);
            unfinished = end > now;
        }

        if (freesat.actionData.programObject.deepLink || on_now) { // freesat.behind.area === 'ondemand'
            this.menuLabels = [
                this.lang.MENU_CLOSE,
                this.lang.MENU_WATCH
            ];
        } else {
            this.menuLabels = [
                this.lang.MENU_CLOSE
            ];
        }

        if (freesat.behind.dataLayer.isIpAvailable()) {
            this.menuLabels.push(this.lang.MENU_ABOUT);
        }

        var oipfProgramme = freesat.actionData.programObject.oipfProgramme;
        if ((freesat.behind.area === 'ontv') && oipfProgramme) {
            var hasReminder = freesat.masterController.remindersHandler.hasReminder(oipfProgramme);
            var setToRecord = freesat.masterController.recordingsHandler.hasRecording(oipfProgramme);

            if (hasReminder) {
                freesat.overlay.get('reminder').show();
            } else {
                freesat.overlay.get('reminder').hide();
            }

            if (setToRecord) {
                freesat.overlay.get('recording').show();
            } else {
                freesat.overlay.get('recording').hide();
            }

            if (freesat.masterController.recordingsHandler.hasPVR()) {
                this.menuLabels.push(setToRecord ? this.lang.MENU_CANCEL_RECORD : this.lang.MENU_RECORD);
            } else {
                if (!on_now && freesat.masterController.remindersHandler.isEnabledForReminders()) {
                    this.menuLabels.push(hasReminder ? this.lang.MENU_CANCEL_REMINDER : this.lang.MENU_SET_REMINDER);
                }
            }
        }

        if (zoommenuitemcontainer!==null && zoommenuitemcontainer!==undefined) {
            if (this.menuLabels.length == 1) {
                freesat.overlay.get('zoommenu').addClass('zoomMenuWithOnlyOneItem');
                freesat.overlay.SELECTED_MENU_ITEM = 0;
            } else {
                freesat.overlay.get('zoommenu').removeClass('zoomMenuWithOnlyOneItem');
                freesat.overlay.SELECTED_MENU_ITEM = 1;
            }

            for(var _i=0;_i<this.menuLabels.length;_i++) {
                var _menuItem = new accedo.ui.Container({id:'#menuItem'+_i,css:'zoomMenuItem' + (_i !== freesat.overlay.SELECTED_MENU_ITEM ? '' : ' menu_highlight'),enterAsClick: false});
                // _menuItem.attach(new accedo.ui.widget.Image({id:'#zoomUpDownMenuIcon',css:'zoomUpDownMenuIcon' + (_i === 1 ? '' : ' hidden'),src:'images/1280x720/arrow/arrows_menu.png'}),false);
                _menuItem.attach(new accedo.ui.widget.Label({id:'#menuItemLabel'+_i,css:'zoomMenuLabel',text:this.menuLabels[_i]}));
                zoommenuitemcontainer.attach(_menuItem);
            }

        }
        // freesat.overlay.highlight_menuItem();
    },
    updateMenu: function() {
        if (freesat.behind.area === 'ontv') {
            freesat.overlay.get('menuItemsContainer').removeAll();
            freesat.overlay.setUpMenu();
        }
    },
    updateTVGridItem: function() {
        if (freesat.behind.area != 'ontv') {
            return;
        }

        var scProgrammeData = freesat.overlay.data[freesat.overlay.dataIndexForPickIndex(freesat.overlay.pick_index)];
        var dataSet = freesat.behind.rightProgrammes;
        var dataLength = dataSet.length + 3;
        var col = 0;
        var row = 0;

        while (true) {
            var index = col + (row * 3);
            if (index >= dataLength) {
                console.log('WARNING - failed to find TV grid item to update');
                break;
            }

            var tvGridElement = freesat.behind.get("sc-tv-" + row + "-" + col);
            if (tvGridElement) {
                if (tvGridElement.getProgrammeData().sc_id === scProgrammeData.sc_id) {
                    tvGridElement.updateProgrammeData();
                    break;
                }
            }

            col++;
            if (col === 3) {
                col = 0;
                row++;
            }
        }
    },
    selectMenuItem: function(label) {
        freesat.overlay.SELECTED_MENU_ITEM = 1;
        for (var i = 0; i < freesat.overlay.menuLabels.length; i++) {
            if (freesat.overlay.menuLabels[i] == label) {
                freesat.overlay.SELECTED_MENU_ITEM = i;
                break;
            }
        }
        freesat.overlay.updateMenuItems();
    },
    swapMenuLabel: function(index, newLabel) {
        var option = freesat.overlay.menuLabels[index];
        document.getElementById('menuItemLabel' + index).innerHTML = newLabel;
        freesat.overlay.menuLabels[index] = newLabel;
    },
    getData : function (){
        freesat.overlay.programmeOrigin = freesat.behind.area === "ondemand" ? "on demand" : "on tv";
        freesat.behind.getZoomData(freesat.overlay.onDataComplete);
    },
    onDataComplete : function (result){
        freesat.overlay.data = result;
        freesat.overlay.determinePickIndex();
        freesat.overlay.processData();
        freesat.overlay.setUpMenu();
        freesat.behind.getCurrentFilterName(function (name) {
            freesat.overlay.get('zoomContainerTitleLabel').setText(freesat.overlay.programmeOrigin + ": " + name);
        });
    },
    dataIndexForPickIndex: function(pickIndex) {
        // take into account special ordering on first page of ondemand
        if ((freesat.behind.area !== 'ondemand') || (pickIndex > 8)) {
            return pickIndex;
        }

        var row = Math.floor(pickIndex / 3);
        var column = pickIndex % 3;

        return freesat.behind.uiPlacementMap.ondemand[row][column] - 1;
    },
    determinePickIndex: function () {
        for (var i = 0; i < freesat.overlay.data.length; i++) {
            if (freesat.actionData.programObject.sc_id === freesat.overlay.data[i].sc_id) {
                if (freesat.behind.area === 'ontv') {
                    freesat.overlay.pick_index = i;
                } else {
                    freesat.overlay.pick_index = (freesat.behind.row * 3) + freesat.behind.column;
                }
                break;
            }
        }
    },
    reset : function (){
        freesat.behind.zoom_enabled = false;
        freesat.behind.get('container').removeClass('is-in-background');
    },
    doRecord : function() {
        var showcaseProgram = freesat.actionData.programObject;
        var programObject = showcaseProgram.oipfProgramme;
        if (!programObject) {
            // TODO: error notification
            console.log('RECORDING ERROR - couldn\'t find event in EPG to be recorded');
            return;
        }

        var recHandler = freesat.masterController.recordingsHandler;
        if (programObject.hasRecording) {
            if (recHandler.removeRecording(programObject) === recHandler.RECORDING_CHANGE_OK) {
                freesat.overlay.updateMenu();
                freesat.overlay.updateTVGridItem();
                console.log('recording cancelled');
            } else {
                console.log('FAILED TO CANCEL RECORDING')
            }
        } else {
            switch (freesat.masterController.recordingsHandler.setRecording(programObject)) {
            case freesat.masterController.recordingsHandler.RECORDING_CLASH:
                // ignore as recording will have been set correctly and warning dialog will be shown: fall through
            case freesat.masterController.recordingsHandler.RECORDING_CHANGE_OK:
                console.log("set recording ok");
                freesat.overlay.updateMenu();
                freesat.overlay.updateTVGridItem();
                break;
            default:
                console.log("RECORDING FAILURE!!!!");
                // TODO: pop-up
                break;
            }
        }
    },
    doCancelRecord : function() {
        var showcaseProgram = freesat.actionData.programObject;
        var programObject = showcaseProgram.oipfProgramme;
        if (!programObject) {
            // TODO: error notification
            console.log('RECORDING ERROR - couldn\'t find event in EPG to cancel recording for');
            return;
        }
        freesat.masterController.recordingsHandler.removeRecording(programObject);
        freesat.overlay.updateMenu();
        freesat.overlay.updateTVGridItem();
    },
    processData : function (){
        // var programme = freesat.overlay.data[freesat.overlay.pick_index];
        var programme = freesat.overlay.data[freesat.overlay.dataIndexForPickIndex(freesat.overlay.pick_index)],
            subtitle, now, end;

        if (programme) {
            try {
                var channelImage =  freesat.overlay.get('zoomChannelLogo');
                var programmeName = freesat.overlay.get('zoomProgrammeName');
                var programmeLength = freesat.overlay.get('zoomProgrammeLength');
                var programmeAvailability = freesat.overlay.get('zoomProgrammeAvailability');
                var programmeSeasonEpisode = freesat.overlay.get('zoomProgrammeSeasonAndEpisode');
                var programmeIcons = freesat.overlay.get('zoomProgrammeIcons');
                var programmeLongdescription = freesat.overlay.get('zoomProgrammeLongdescription');
                var programmenofnn = freesat.overlay.get('zoomProgrammesNofNN');
                var programmeImage = freesat.overlay.get('zoomProgrammeImage');
                channelImage.setSrc(this.imgFactory.getImageURL(programme.channel_logo));

                if (programme.icons.pay) {freesat.overlay.get('pay').show();} else {freesat.overlay.get('pay').hide();}
                if (programme.icons.guidance) {freesat.overlay.get('guidance').show();} else {freesat.overlay.get('guidance').hide();}
                if (programme.icons.ssound) {freesat.overlay.get('ssound').show();} else {freesat.overlay.get('ssound').hide();}
                if (programme.icons.dolby) {freesat.overlay.get('dolby').show();} else {freesat.overlay.get('dolby').hide();}
                if (programme.icons.hd) {freesat.overlay.get('hd').show();} else {freesat.overlay.get('hd').hide();}
                if (programme.icons.threed) {freesat.overlay.get('threed').show();} else {freesat.overlay.get('threed').hide();}
                if (programme.icons.subtitle) {freesat.overlay.get('subtitle').show();} else {freesat.overlay.get('subtitle').hide();}
                if (programme.icons.ad) {freesat.overlay.get('ad').show();} else {freesat.overlay.get('ad').hide();}
                if (programme.icons.series) {freesat.overlay.get('series').show();} else {freesat.overlay.get('series').hide();}
                if (programme.icons.sc) {freesat.overlay.get('sc').show();} else {freesat.overlay.get('sc').hide();}
                if (programme.icons.ondemand) {freesat.overlay.get('ondemand').show();} else {freesat.overlay.get('ondemand').hide();}
                if (programme.icons.signed) {freesat.overlay.get('signed').show();} else {freesat.overlay.get('signed').hide();}
                if (programme.genre === 'film' || programme.genre.indexOf('film') !== -1) {freesat.overlay.get('filmIcon').show();} else {freesat.overlay.get('filmIcon').hide();}

                // show these if/when we get back an OIPF object for this programme
                freesat.overlay.get('recording').hide();
                freesat.overlay.get('reminder').hide();

                programmeName.setText(programme.sc_title);
                subtitle = programme.sc_title2;

                if (subtitle && freesat.behind.area === 'ontv') {
                    now = Math.round(new Date().getTime() / 1000);
                    end = programme.startTime + programme.duration;
                    subtitle = (end < now) ? 'Programme ended' : subtitle;
                    programmeLength.setText(subtitle);
                    programmeAvailability.hide();
                } else {
                    programmeLength.setText(freesat.overlay.formatTime(programme.duration));

                    if (programme.availability_text) {
                        programmeAvailability.setText(programme.availability_text);
                        programmeAvailability.show();
                    } else {
                        programmeAvailability.hide();
                    }
                }

                if (programme.sc_title3) {
                    programmeSeasonEpisode.setText(programme.sc_title3);
                    programmeSeasonEpisode.show();
                } else {
                    programmeSeasonEpisode.hide();
                }
                programmeIcons = null;

                if (programme.sc_image) {
                    console.log(typeof freesat.overlay.imagefactory + ", " + freesat.overlay.imagefactory.getImageURL(programme.sc_image));
                    programmeImage.setSrc(freesat.overlay.imagefactory.getImageURL(programme.sc_image, 638, 405, true));
                } else {
                    programmeImage.setSrc('images/placeholders/sc-not-found.png');
                }

                if (programme.sc_description.length > 220) {
                    programmeLongdescription.setText(programme.sc_description.substring(0, 220) + "...");
                } else {
                    programmeLongdescription.setText(programme.sc_description);
                }
                programmenofnn.setText(freesat.overlay.lang.ZOOM_NofNN.replace('{n}', freesat.overlay.pick_index+1).replace('{nn}',freesat.overlay.data.length));

                if (freesat.overlay.pick_index === 0) { // Hide left arrow
                    freesat.overlay.get('zoomleftArrow').addClass('hidden');
                } else {
                    freesat.overlay.get('zoomleftArrow').removeClass('hidden');
                }

                if ((freesat.overlay.pick_index+1) === freesat.overlay.data.length) { // Hide right arrow
                    freesat.overlay.get('zoomrightArrow').addClass('hidden');
                } else {
                    freesat.overlay.get('zoomrightArrow').removeClass('hidden');
                }
            } catch(e) {
                freesat.console.log('zoom processData '+e);
            }
            freesat.actionData.programObject = programme;
            freesat.overlay.updateDisplayMode();
            freesat.overlay.get("programmeDetailContainer").show();
            freesat.overlay.get('zoomProgrammeImage').show();
        }

    },
    updateDisplayMode: function (){
        var programmeDetailContainer = freesat.overlay.get('programmeDetailContainer');
        var programmeImage = freesat.overlay.get('zoomProgrammeImage');
        var zoomChannelLogo = freesat.overlay.get('zoomChannelLogo');

        programmeDetailContainer.removeClass('programmeDetailContainer-connected');
        programmeDetailContainer.removeClass('programmeDetailContainer-offline');
        programmeImage.removeClass('zoomProgrammeImage-connected');
        programmeImage.removeClass('zoomProgrammeImage-offline');
        zoomChannelLogo.removeClass('zoomChannelLogo-connected');
        zoomChannelLogo.removeClass('zoomChannelLogo-offline');

        programmeDetailContainer.addClass('programmeDetailContainer-'+freesat.overlay.mode);
        programmeImage.addClass('zoomProgrammeImage-'+freesat.overlay.mode);
        zoomChannelLogo.addClass('zoomChannelLogo-'+freesat.overlay.mode);
    },
    decrement_pick_index : function (){
        freesat.overlay.pick_index = Math.max(0, freesat.overlay.pick_index - 1);
        freesat.overlay.processData();
        freesat.overlay.updateMenu();

        this.AM_ScreenView();
    },
    increment_pick_index : function (){
        freesat.overlay.pick_index = Math.min(freesat.overlay.data.length - 1, freesat.overlay.pick_index + 1);
        freesat.overlay.processData();
        freesat.overlay.updateMenu();

        this.AM_ScreenView();
    },

    getColAndRowForZoomedPick: function() {
        var i = freesat.overlay.pick_index;
        console.log('ROW: ' + Math.floor(i/3));
        console.log('COL: ' + Math.floor(i%3));
        if(freesat.behind.area === 'ontv') {
            item = this.tvItem(Math.floor(i/3), i%3, big);
        }else{
            item = this.odItem(Math.floor(i/3), i%3);
        }

    },

    navigateMenu_Up : function (){
        freesat.overlay.SELECTED_MENU_ITEM = ((freesat.overlay.SELECTED_MENU_ITEM + 1) + freesat.overlay.menuLabels.length) % freesat.overlay.menuLabels.length;
        freesat.overlay.updateMenuItems();
    },
    navigateMenu_Down: function (){
        freesat.overlay.SELECTED_MENU_ITEM = ((freesat.overlay.SELECTED_MENU_ITEM - 1) + freesat.overlay.menuLabels.length) % freesat.overlay.menuLabels.length;
        freesat.overlay.updateMenuItems();
    },
    updateMenuItems: function () {
        var placeholderIndex = 1; // position 1 is always the selected item
        var labelTextIndex = this.SELECTED_MENU_ITEM;
        for (var i = 0; i < this.menuLabels.length; i++) {
            var labelText = freesat.overlay.menuLabels[labelTextIndex];
            freesat.overlay.get('menuItem' + placeholderIndex).getChildren()[0].setText(labelText);
            placeholderIndex = (placeholderIndex + 1) % this.menuLabels.length;
            labelTextIndex = (labelTextIndex + 1) % this.menuLabels.length;
        }
    },
    formatTime: function(seconds) {
        var tArr, _date, hh, mm, hour, mins, hStr, mStr, radix = 10;
        try {
            _date = new Date(seconds * 1000);
            var dateStr = _date.toISOString().substr(0, _date.toISOString().length - 5);
            tArr = dateStr.split('T')[1].split(':');
        } catch (Error) {
            _date = new Date(seconds);
            if (_date && seconds) {
                tArr = seconds.split('T')[1].split(':');
            }
        }
        hh = tArr[0];
        mm = tArr[1];
        hour = parseInt(hh, radix);
        mins = parseInt(mm, radix);
        hh = String(hour);
        mm = String(mins);
        hStr = '';
        mStr = '';
        if (hour > 1) {
            hStr = hh + ' hrs ';
        } else if (hour > 0) {
            hStr = hh + ' hr ';
        }
        if (mins > 1) {
            mStr = mm + ' mins ';
        } else if (mins > 0) {
            mStr = mm + ' min ';
        }
        return hStr + mStr;
    },
    onKey: function (VKey){
        var keyHandling = new freesat.controllers.showcase.ZoomKeyHandling();
        keyHandling.onKey(VKey);
    },
    process_menu_option : function (){
        var option = freesat.overlay.menuLabels[freesat.overlay.SELECTED_MENU_ITEM],
            programObject,
            ccid,
            contentObj,
            channelObj,
            channelID,
            AM_urlParam = freesat.overlay.getAM_urlParam();

        switch(option) {
            case freesat.overlay.lang.MENU_CLOSE:   // close
                AM_urlParam = '';
                freesat.masterController.returnFromShowCaseZoom();
                break;
            case freesat.overlay.lang.MENU_WATCH:
                programObject = freesat.actionData.programObject;

                if (programObject.deepLink) {
                    if (!freesat.behind.dataLayer.isIpAvailable()) {
                        freesat.masterController.returnFromShowCaseZoom();
                        freesat.behind.showConnectToWatchMessage();
                        return;
                    }
                    freesat.setBackCookieValue('startType', freesat.debugVar);
                    freesat.setBackCookieValue('section', 'sc');
                    var curFilterId = freesat.behind.dataLayer.left_page.filters[freesat.behind.leftFilterIndex].id;
                    freesat.setBackCookieValue('filter', curFilterId);
                    freesat.setBackCookieValue('sc_id', programObject.sc_id);
                    freesat.setBackCookieValue('top_row', freesat.behind.topRow);
                    freesat.console.log('Showcase redirect to : '+ programObject.deepLink);
                    freesat.console.log("sc_id = " + programObject.sc_id);
                    freesat.console.log("filter id = " + curFilterId);
                    setTimeout(function () {
                        window.location = programObject.deepLink;
                    }, 200);
                } else {
                    ccid = freesat.channelData.getChannelObjectByServiceID(programObject.svc_id).ccid;
                    freesat.watchNow = true;

                    if (ccid) {
                        freesat.setCurrentChannel(parseInt(ccid.split(':')[1], null));
                    }
                }
                break;
            case freesat.overlay.lang.MENU_ABOUT:
                freesat.masterController.instanciateShowcaseAbout();
                break;
            case freesat.overlay.lang.MENU_RECORD:
                freesat.overlay.doRecord();
                freesat.overlay.selectMenuItem(freesat.overlay.lang.MENU_CANCEL_RECORD);
                break;
            case freesat.overlay.lang.MENU_CANCEL_RECORD:
                freesat.overlay.doCancelRecord();
                freesat.overlay.selectMenuItem(freesat.overlay.lang.MENU_RECORD);
                break;
            case freesat.overlay.lang.MENU_SET_REMINDER:
                switch (freesat.masterController.remindersHandler.setReminder(
                    freesat.actionData.programObject.oipfProgramme)) {
                case freesat.masterController.remindersHandler.REMINDER_CLASH:
                    // ignore as recording will have been set correctly and warning dialog will be shown: fall through
                case freesat.masterController.remindersHandler.REMINDER_CHANGE_OK:
                    console.log("set reminder ok");
                    freesat.overlay.updateMenu();
                    freesat.overlay.updateTVGridItem();
                    freesat.overlay.selectMenuItem(freesat.overlay.lang.MENU_CANCEL_REMINDER);
                    break;
                default:
                    console.log("REMINDER FAILURE!!!!");
                    break;
                }
                break;
            case freesat.overlay.lang.MENU_CANCEL_REMINDER:
                freesat.masterController.remindersHandler.removeReminder(
                    freesat.actionData.programObject.oipfProgramme);
                freesat.overlay.updateMenu();
                freesat.overlay.updateTVGridItem();
                freesat.overlay.selectMenuItem(freesat.overlay.lang.MENU_SET_REMINDER);
                break;
        }

        /* Application Monitoring trigger */
        if (AM_urlParam){
            try {
                channelID = freesat.channelData.getChannelObjectByServiceID(freesat.actionData.programObject.svc_id).ccid;
        
                contentObj = freesat.masterController.AM_GetShowcaseObject(freesat.actionData.programObject);
                channelObj = freesat.masterController.AM_GetChannelObject(channelID);

                freesat.am.screenEvent(AM_urlParam, {
                            category: 'actionMenu',
                            action: option.toAMStandardised(),
                            channel: channelObj,
                            content: contentObj
                        });                                  

                if (option === freesat.overlay.lang.MENU_WATCH) {
                    freesat.am.amEvent(AM_urlParam, {
                                channel: channelObj,
                                content: contentObj,
                                ondemand: {
                                    type: 'ondemand',
                                    apptype: freesat.actionData.programObject.deepLinkType,
                                    sID: freesat.actionData.programObject.deepLinkServiceId,
                                    URI: freesat.actionData.programObject.deepLink.split('[%]')[1]
                                }
                            });                                  
                }
            } catch (e) {
                freesat.console.log('ERROR - could not generate AM notification: ' + e);
            }
        }
    },

    AM_ScreenView: function(){
        var urlParam = this.getAM_urlParam();
        freesat.am.screenView(urlParam);
    },

    getAM_urlParam: function() {
        var uri = '',
            uri2 = '',
            filter,
            uiPlacement = '';
        

        switch(freesat.behind.state) {
            case 'ontv':
                uri = '/showcase/onTv/';
                uri2 = "/zoom/" +  this.uiPlacementForCurrentZoom();
                freesat.behind.getCurrentFilterName(function(filterName) {
                    uri = uri + filterName.toAMStandardised() + uri2;
                });
                break;

            case 'ondemand':
                uri = '/showcase/onDemand/';
                uri2 = "/zoom/" + this.uiPlacementForCurrentZoom();
                freesat.behind.getCurrentFilterName(function(filterName) {
                    uri = uri + filterName.toAMStandardised() + uri2;
                });
                break;

            case 'split':
                if (freesat.behind.area === 'ondemand') {
                    uri = '/showcase/split/onDemand/zoom/' + this.uiPlacementForCurrentZoom();
                } else {
                    uri = '/showcase/split/onTv/zoom/' + this.uiPlacementForCurrentZoom();
                }
                break;

            default:
                uri = '/showcase/unknown';
        }

        

        return uri;
    },

    uiPlacementForCurrentZoom: function() {
        if (freesat.behind.area == 'ontv') {
            return freesat.overlay.pick_index + 1;
        }
        var row = Math.floor(freesat.overlay.pick_index / 3);
        var col = freesat.overlay.pick_index % 3;
        var map = freesat.behind.uiPlacementMap['ondemand'];
        if (row < map.length) {
            return map[row][col];
        } else {
            return ((row * 3) + col) + 1;
        }
    }

});
/**
 * @name ShowCase
 * @namespace
 * @memberOf freesat.controllers
 * @class
 */
accedo.Class.create('freesat.controllers.ShowCase', 'accedo.ui.Controller', ['freesat.view.ShowCase', 'freesat.controllers.showcase.KeyHandling', 'freesat.controllers.showcase.ItemCreation'],{},
    {
        state: null,  // split / ondemand / ontv / zoom / filter /
        area: 'ontv',
        column: 0,
        topRow: 0,
        row: 0,
        prevrow: 0,
        buttonHGrid:null,
        buttonVGrid:null,
        animationClass:null,
        itemSelection:null,
        clock: null,
        startInterval: null,
        tvitems : false,
        oditems : false,
        tvTop: 0,
        odTop: 0,
        filtersArr: null,
        currentFilter: 2,
        allData:{},

        dataLayer:null,
        leftProgrammes:null,
        rightProgrammes:null,
        leftFilterList:null,
        rightFilterList:null,
        leftFilterIndex: null,
        rightFilterIndex: null,
        renderReady: false,
        left_titles: null,
        right_titles: null,
        filterInterval: null,
        create: null,
        lang: null,
        showError: false,
        usingDsmcc: false,

        uiPlacementMapPreferred:{
            ondemand: [
                [4,5,1],
                [6,7,2],
                [8,9,3]
            ],
            ontv: [
                [1,1,4],
                [1,1,5],
                [2,3,6],
                [7,8,9]
            ]
        },
        uiPlacementMapFallback:{
            ondemand: [
                [1,2,3],
                [4,5,6],
                [7,8,9]
            ],
            ontv: [
                [1,1,2],
                [1,1,3],
                [4,5,6],
                [7,8,9]
            ]
        },
        uiPlacementMap: {},

        initialize: function($super) {
            $super();
            this.uiPlacementMap = {
                ondemand: this.uiPlacementMapPreferred.ondemand,
                ontv: this.uiPlacementMapPreferred.ontv
            };
            freesat.oipfElement.setKeysetWithNumbers();
            freesat.console.log('[ShowCase Controller] initialize');
            this.clock = new freesat.models.Clock();
            this.setView(freesat.view.ShowCase);
            this.dataLayer = new freesat.data.datafunc.Showcase();
            freesat.console.log('get sc data : ');

            var scope = this;
            this.dataLayer.setDsmccFetchCallback(function(state) {
                switch (state) {
                case scope.dataLayer.DSMCC_FETCHING:
                    console.log('showing DSMCC fetch message');
                    scope.dsmccState = state;
                    break;
                case scope.dataLayer.DSMCC_COMPLETE:
                    console.log('complete - hiding DSMCC fetch message');
                    scope.dsmccState = state;
                    scope.hideDsmccFetchMessage.call(scope);
                    break;
                case scope.dataLayer.DSMCC_ERROR:
                    console.log('error - hiding DSMCC fetch message');
                    scope.dsmccState = state;
                    scope.showTryAgain();
                    break;
                }
            });

            if (scope.dataLayer.isIpAvailable() && !freesat.localConfig.auth.showcase) { // No config var
                console.log('LOCAL CONFIG: ' + freesat.localConfig.auth.regional);
                this.showError = true;
                this.errorDescription = 'Missing showcase entry in auth file';
            } else {

                if (freesat.backJourney) {
                    this.cookieFilterId = parseInt(freesat.getBackCookieValue('filter'), 10);
                    this.cookieProgrammeId = parseInt(freesat.getBackCookieValue('sc_id'), 10);
                    this.cookieTopRow = parseInt(freesat.getBackCookieValue('top_row'), 10);
                    freesat.clearBackCookie('section');
                    freesat.clearBackCookie('filter');
                    freesat.clearBackCookie('sc_id');
                    freesat.clearBackCookie('top_row');
                    console.log(this.cookieFilterId + "; " + this.cookieProgrammeId);
                    this.dataLayer.getDefaultFilterIndex(true, this.leftIndexCallback(this), this.cookieFilterId);
                } else {
                    this.dataLayer.getDefaultFilterIndex(true, this.leftIndexCallback(this));
                }
            }
        },
        handleBackJourney: function () {
            console.log("handling back journey to " + freesat.behind.cookieFilterId + ", " + freesat.behind.cookieProgrammeId);
            freesat.backJourney = false;
            // 1. NAVIGATE LEFT
            freesat.behind.area = "ondemand";
            freesat.isAnimating = true;
            freesat.behind.makeFilterMenu('left');
            (new freesat.controllers.showcase.KeyHandling()).switchSectionHighlightTo('od');
            freesat.behind.prevrow = freesat.behind.row;
            freesat.behind.animationClass.aniOnDemandtoCenterFromStart();
            freesat.behind.column = 1;
            // 2. FIND CORRECT ITEM IN GRID
            var element = null,
                position = 0;
            for (var i = 0; i < freesat.behind.leftProgrammes.length; i++) {
                if (freesat.behind.cookieProgrammeId === freesat.behind.leftProgrammes[i].sc_id) {

                    if (freesat.behind.dataLayer.isStartFilter(true, freesat.behind.leftFilterIndex)) {
                        position = freesat.behind.create.getODGridPositionFromIndex(i);
                    } else {
                        position = i;
                    }
                    freesat.behind.row = ~~(position / 3);
                    freesat.behind.column = position % 3;
//                    if (freesat.behind.row > 2) {
//                        freesat.behind.create.populateODGrid(freesat.behind.leftProgrammes, false, freesat.behind.row + 2);
//                    }
                    element = freesat.behind.get('sc-od-' + freesat.behind.row + "-" + freesat.behind.column);
                    break;
                }
            }
            if (element) {
                freesat.behind.topRow = freesat.behind.cookieTopRow || 0;
//                freesat.behind.topRow = Math.min(freesat.behind.topRow, freesat.behind.row);
//                freesat.behind.topRow = Math.max(freesat.behind.topRow, freesat.behind.row - 2);
                element.setFocus();
                freesat.behind.odTop = -175 * freesat.behind.topRow;
                freesat.behind.animationClass.moveUpDown(freesat.behind.odTop, "on-demand-item-container");
                // 3. OPEN ZOOM VIEW
                var timeZoneVar = freesat.getZone();
                freesat.actionData = new freesat.models.vo.MenuObject();
                freesat.actionData.timeZone = timeZoneVar;
                freesat.behind.backItem = element;
                freesat.actionData.backFocus = element;
                freesat.actionData.programObject = element._data;
                freesat.actionData.hasMask = true;
                freesat.masterController.instanciateShowCaseZoom();
                freesat.behind.zoom_enabled = true;
            } else {
                // DEFAULT TO TOP LEFT ITEM IF THE BACK JOURNEY ITEM ISN'T FOUND
                freesat.behind.get('sc-od-0-0').setFocus();
                freesat.behind.row = freesat.behind.column = 0;
            }

            freesat.behind.get('filter-buttons').removeClass('hidden');
            freesat.behind.get('filter-bg').removeClass('hidden');
        },
        leftIndexCallback: function(scope){
            return function(index){
                freesat.console.log('[ShowCase Controller] leftIndexCallback : '+ index);
                if (typeof index === "number") {
                    scope.leftFilterIndex = index;
                    scope.dataLayer.getFilterNames(true, scope.leftFilterListCallback(scope));
                } else if (scope.dataLayer.isIpAvailable()) {
                    scope.errorDescription = 'Failed to fetch left index';
                    scope.showError = true;
                } else {
                    // ignore - 'get connected' will be shown in setup
                }
            };
        },
        leftFilterListCallback: function(scope){
            return function(list){
                if(list){
                    freesat.console.log('[ShowCase Controller] leftFilterListCallback : '+list.length);
                    scope.leftFilterList = list;
                    var func = scope.leftProgrammesCallback(scope);
                    scope.dataLayer.getFilter(true, list[scope.leftFilterIndex], func);
                }else{
                    scope.errorDescription = 'Failed to fetch left filter list';
                    scope.showNotAvailable();
                }
            };
        },
        leftProgrammesCallback: function(scope){
            return function(data){
                if(data){
                    freesat.console.log('[ShowCase Controller] leftProgrammesCallback' + data.length);
                    scope.leftProgrammes = data;
                    scope.dataLayer.getDefaultFilterIndex(false, scope.rightIndexCallback(scope));
                }else{
                    scope.errorDescription = 'Failed to fetch left programmes';
                    scope.showNotAvailable();
                }
            };
        },
        rightIndexCallback: function(scope){
            return function(index){
                if(typeof index === "number"){
                    freesat.console.log('[ShowCase Controller] rightIndexCallback ');
                    scope.rightFilterIndex = index;
                    scope.dataLayer.getFilterNames(false, scope.rightFilterListCallback(scope));
                }else{
                    scope.errorDescription = 'Failed to fetch right index';
                    scope.showNotAvailable();
                }
            };
        },
        rightFilterListCallback: function(scope){
            return function(list){
                if(list){
                    freesat.console.log('[ShowCase Controller] rightFilterListCallback');
                    scope.rightFilterList = list;
                    scope.dataLayer.getFilter(false, list[scope.rightFilterIndex], scope.rightProgrammesCallback(scope));
                }else{
                    scope.errorDescription = 'Failed to fetch right filter list';
                    scope.showNotAvailable();
                }
            };
        },
        rightProgrammesCallback: function(scope){
            return function(data){
                if(data){
                    freesat.console.log('[ShowCase Controller] rightProgrammesCallback ' + data.length);
                    scope.rightProgrammes = data;
                    scope.renderToScreen(scope);
                }else{
                    scope.errorDescription = 'Failed to fetch right programmes';
                    scope.showNotAvailable();
                }
            };
        },

        getZoomData: function (callback) {
            var isLeft = freesat.behind.area === 'ondemand';
            freesat.behind.dataLayer.getFilterNames(isLeft, function (list) {
                freesat.behind.dataLayer.getFilterZoom(
                    isLeft,
                    list[isLeft ? freesat.behind.leftFilterIndex : freesat.behind.rightFilterIndex],
                    callback
                );
            });
        },

        getCurrentFilterName: function (callback) {
            var isLeft = freesat.behind.state === 'ondemand';
            freesat.behind.dataLayer.getFilterNames(isLeft, function (list) {
                callback(list[isLeft ? freesat.behind.leftFilterIndex : freesat.behind.rightFilterIndex]);
            });
        },

        renderToScreen: function(scope){

            if(scope.renderReady){
                freesat.console.log('controller showcase : renderToScreen');
                scope.startInterval = setInterval(function () {
                    freesat.behind.showSplit(true);
                }, 600);
                
            }else{
                scope.renderReady = true;
            }
        },
        makeFilterMenu: function(move){
            if(move=='right'){
                this.filtersArr = this.rightFilterList;
                this.currentFilter = this.rightFilterIndex;
            }else{
                this.filtersArr = this.leftFilterList;
                this.currentFilter = this.leftFilterIndex;
            }
            this.makeButtons();
        },

        clearFilterInterval: function(){
            if(this.filterInterval)clearInterval(this.filterInterval);
        },
        setFilterInterval: function(){
            this.clearFilterInterval();
            this.filterInterval = setInterval(this.changeFilter(this), 600);
        },
        changeFilter: function(scope){
            return function(){
                scope.clearFilterInterval();
                scope.updateItems(freesat.behind.state, scope, true); // passing true because we want to reset to position 0, 0
            };
        },
        updateItems: function(state, scope, reset){
            if(scope.create == null) scope.create = new freesat.controllers.showcase.ItemCreation();
            var startFilter;
            if(state === 'tv' || state === 'ontv') {
                scope.rightFilterIndex = scope.currentFilter;
                startFilter = freesat.behind.dataLayer.isStartFilter(false, scope.rightFilterIndex);
                scope.dataLayer.getFilter(false, scope.rightFilterList[scope.rightFilterIndex], scope.create.repopulateTVGrid(scope.create, reset, startFilter));
            }else{
                scope.leftFilterIndex = scope.currentFilter;
                startFilter = freesat.behind.dataLayer.isStartFilter(true, scope.leftFilterIndex);
                scope.dataLayer.getFilter(true, scope.leftFilterList[scope.leftFilterIndex], scope.create.repopulateODGrid(scope.create, reset, startFilter));
            }
            scope.showScrollbar();
        },
        setup: function(){
            freesat.behind = this;
            this.initComplete = true;
            this.lang = new freesat.language.ShowCaseEn();
            if (this.showError) {
                this.showTryAgain();
                this.showError = false;
            } else {
                this.get('showcase_bg_gradient').hide();
                this.get('showcase-title').setText(this.lang.SHOWCASE);
                this.get('showcase-strap').setText(this.lang.PLACEHOLDER_STRAPLINE);
                this.animationClass = new freesat.controllers.showcase.Animations();
                this.itemSelection = new freesat.controllers.showcase.ItemSelection();
                this.clock.updateClock(this.get('pageClock'));
                if (this.dataLayer.isIpAvailable() || (this.dsmccState == this.dataLayer.DSMCC_COMPLETE)) {
                    this.get('on-demand-title-label').setText(this.lang.ON_DEMAND);
                    this.get('on-tv-title-label').setText(this.lang.ON_TV);
                    this.get('showcase-connection-message').addClass('hidden');
                    this.get('showcase-connection-on-demand-blank').addClass('hidden');
                    this.renderToScreen(this);
                } else if (this.dsmccState == this.dataLayer.DSMCC_FETCHING) {
                    this.showDsmccFetchMessage();
                    freesat.behind.showSplit(false);
                    setTimeout(freesat.loadRemainingSections, 200);
                } else {
                    freesat.behind.showSplit(false);
                    this.showNotConnected();
                    trace("Browser load to Focus on screen");
                    setTimeout(freesat.loadRemainingSections, 200);
                }
            }

        },
        showTryAgain: function() {
            console.log('showTryAgain');
            this.get('showcase-connectionLabel').setText('trouble loading service');
            this.get('showcase-connectionmessageLabel').setText('Sorry, there was a problem loading the service. Please exit and try again.');
            this.displayErrorMessage();
        },
        showNotConnected: function(){
            this.get('on-demand-title-label').setText('');
            this.get('on-tv-title-label').setText(''); // Clear on tv header
            this.get('showcase-connectionLabel').setText('get connected');
            this.get('showcase-connectionmessageLabel').setText('To use this section, please make sure your TV is connected to the internet');
            this.displayErrorMessage();
        },
        showNotAvailable: function(){
            this.get('on-demand-title-label').setText('');
            this.get('on-tv-title-label').setText(''); // Clear on tv header
            this.get('showcase-connectionLabel').setText('coming soon'); // not available
            this.get('showcase-connectionmessageLabel').setText("Find programmes you'll love with Showcase, our picks of the best new TV. Stay tuned"); // This service is not available. Please try again later.
            this.displayErrorMessage();
        },
        showDsmccFetchMessage: function() {
            this.get('on-demand-title-label').setText('');
            this.get('on-tv-title-label').setText(''); // Clear on tv header
            this.get('showcase-connectionLabel').setText('downloading showcase');
            this.get('showcase-connectionmessageLabel').setText('Please bear with us for a few minutes while we get the latest Showcase picks...');
            this.displayErrorMessage();
        },
        hideDsmccFetchMessage: function() {
            if (!this.get('showcase-connection-message')) {
                // ui hasn't been set-up yet: ignore because dialog won't be showing anyway
                return;
            }

            var scope = this;
            freesat.behind.animationClass.dialogOutAni(function() {
                scope.get('on-demand-title-label').setText(scope.lang.ON_DEMAND);
                scope.get('on-tv-title-label').setText(scope.lang.ON_TV);
                scope.get('showcase-connection-message').addClass('hidden');
                scope.get('showcase-connection-on-demand-blank').addClass('hidden');
                scope.get('arrowContainer').removeClass('hidden');

                scope.renderReady = true;
                scope.renderToScreen(scope);
            });
        },
        showConnectToWatchMessage: function() {
            var scope = this;

            freesat.behind.animationClass.clearUpArrowAni();
            this.get('filter-buttons').addClass('hidden');
            this.get('filter-bg').addClass('hidden');
            this.hideScrollbar();

            freesat.behind.animationClass.dialogOutAni(function() {
                scope.get('on-demand-title-label').setText('');
                scope.get('on-tv-title-label').setText('');
                scope.get('showcase-connectionLabel').setText('get connected');
                scope.get('showcase-connectionmessageLabel').setText('To watch this, please make sure your TV is connected to the internet');

                scope.get('showcase-connection-message').removeClass('hidden');
                scope.get('showcase-connection-on-demand-blank').removeClass('hidden');
                scope.get('showcase-connectionBackButton').setFocus();
                scope.get('arrowContainer').addClass('hidden');
                scope.get('item-grey-out-container').removeClass('hidden');

                scope.get('showcase-connectionBackButton').onKey = function (vKey) {
                    if (vKey === accedo.VKey.KEY_OK) {
                        scope.hideConnectToWatchMessage.call(scope);
                        return true;
                    }
                };

                freesat.behind.animationClass.dialogInAni();
            });
        },
        hideConnectToWatchMessage: function() {
            var scope = this;
            freesat.behind.animationClass.dialogOutAni(function() {
                scope.get('on-demand-title-label').setText(scope.lang.ON_DEMAND);
                scope.get('on-tv-title-label').setText(scope.lang.ON_TV);
                scope.get('showcase-connection-message').addClass('hidden');
                scope.get('showcase-connection-on-demand-blank').addClass('hidden');
                scope.get('arrowContainer').removeClass('hidden');

                freesat.backJourney = true;
                scope.cookieFilterId = scope.dataLayer.left_page.filters[scope.leftFilterIndex].id;
                scope.cookieProgrammeId = freesat.actionData.programObject.sc_id;
                scope.cookieTopRow = freesat.behind.topRow;

                freesat.behind.animationClass.startupAni();
            });
        },
        displayErrorMessage: function(){
            this.get('on-tv-container').removeClass('hidden');
            this.get('showcase-connection-message').removeClass('hidden');
            this.get('showcase-connection-on-demand-blank').removeClass('hidden');
            this.get('showcase-connectionBackButton').setFocus();
            this.get('arrowContainer').addClass('hidden');
            this.get('item-grey-out-container').addClass('hidden');
            this.get('showcase-connectionBackButton').onKey = function (vKey) {
                if (vKey === accedo.VKey.KEY_OK || vKey === accedo.VKey.KEY_BACK) {
                    freesat.dsmcc.tuneToOriginalChannel();
                    if (freesat.behind.animationClass) {
                        freesat.behind.animationClass.dialogOutAni(freesat.masterController.handleBackPress);
                    } else {
                        freesat.masterController.handleBackPress();
                    }
                    return true;
                }
            };

            if (this.dataLayer.isIpAvailable()) {
                freesat.am.techEvent('/showcase', {
                    category: 'exception',
                    action: 'showcaseFailed',
                    description: this.errorDescription
                });
            }
        },
        /**
         * makeButtons
         * makes filter buttons
         * @memberOf freesat.controllers.ShowCase
         */
        makeButtons: function(){
            this.clearMenu();
            var i, index, top = 0;
            var container = this.get('filter-buttons');
            var inAdj = Math.ceil(this.filtersArr.length / 2);
            var topAdj = -((Math.ceil(this.filtersArr.length / 2) * 46)-(3*46));

            container.root.setStyle({'top': String(topAdj)+'px'});
            for(i=0;i<this.filtersArr.length;i++){
                index = (this.currentFilter + i -(inAdj-1));
                if(index > this.filtersArr.length-1){
                    index -= (this.filtersArr.length);
                } else if(index < 0){
                    index += this.filtersArr.length;
                }
                var highlight = (index == this.currentFilter);
                top += index * 46;
                if(i==this.currentFilter) top+=4;
                this.createButtonElement(top, index, highlight, i);
            }
        },
        /**
         * createButtonElement
         * creates a button with icon element
         * @param {?} top
         * @param {number} index
         * @param {boolean} highlight
         * @memberOf freesat.controllers.ShowCase
         * @returns {freesat.widget.ButtonWithIcon}
         * @todo - remove top param?
         */
        createButtonElement: function(top, index, highlight) {
            var height = (highlight) ? 44 : 36;
            var hcss = (highlight) ? ' highlight' : '';
            var id = 'filter-button-item' + String(index);
            var css = 'sc-filter-button' + hcss;
            var obj = {
                id: '#' + id,
                css: css,
                text: this.filtersArr[index],
                'nextUp': 'filter-button-item' + String(index-1),
                'nextDown': 'filter-button-item' + String(index+1),
                enterAsClick: false
            };
            var ele = new freesat.widget.ButtonWithIcon(obj);
            ele.root.setStyle({'height': String(height)+'px'});
            this.get('filter-buttons').attach(ele);
            return ele;
        },
        /**
         * clearMenu
         * removes all filter buttons
         * @memberOf freesat.controllers.ShowCase
         */
        clearMenu: function(){
            var i, child = this.get('filter-buttons').getChildren();
            for(i = 0; i < child.length; i++){
                child[i].detach();
                child[i].doDetach();
                child[i] = null;
            }

        },
        reset: function () {
            //XDK[warn]
        },
        /**
         * showSplit
         * creates items and start the first animation
         * @memberOf freesat.controllers.ShowCase
         */
        showSplit: function (connected) {
            freesat.console.log('controller showcase : showSplit');
            clearInterval(freesat.behind.startInterval);
            freesat.behind.left_titles = freesat.behind.dataLayer.getPageTitleAndStrap(true);
            freesat.behind.right_titles = freesat.behind.dataLayer.getPageTitleAndStrap(false);
            freesat.behind.setStraplineText(false);
            if (this.create == null) this.create = new freesat.controllers.showcase.ItemCreation();
            freesat.behind.highlightOntv();
            freesat.behind.state = 'split';

            if (connected) {
                freesat.behind.ontvGrid();
                freesat.behind.get('on-demand-title-label').setText(freesat.behind.left_titles[0]);
                freesat.behind.get('on-tv-title-label').setText(freesat.behind.right_titles[0]);
                this.create.populateTVGrid(freesat.behind.rightProgrammes, true);
                this.create.populateODGrid(freesat.behind.leftProgrammes, this.dataLayer.isStartFilter(true, this.leftFilterIndex));

                freesat.behind.get('sc-tv-0-0').setFocus();
                
                trace("Browser load to Focus on screen");
                setTimeout(function() {
                    freesat.marketingOptIn.showDialogIfRequired();
                    freesat.loadRemainingSections();
                }, 200);
                freesat.behind.animationClass.startupAni();
            } else {
                freesat.behind.animationClass.dialogInAni();
            }

            freesat.behind.AM_ScreenView();
        },
        setStraplineText: function(left){
            var title = (left) ? freesat.behind.left_titles[1] : freesat.behind.right_titles[1];

            if (!title) {
                title = this.lang.PLACEHOLDER_STRAPLINE;
            }
            freesat.behind.get('showcase-strap').setText(title);
        },
        /**
         * ontvGrid
         * populates multi dimensional arrays representing horizontal and vertical additional movements
         * @memberOf freesat.controllers.ShowCase
         */
        ontvGrid: function(){
            if (freesat.behind.dataLayer.usingDsmcc) {
                // no big
                freesat.behind.buttonHGrid = [[0,0,0],[0,0,0],[0,0,0]];
                freesat.behind.buttonVGrid = [[0,0,0],[0,0,0],[0,0,0]];
            } else {
                // 1 hot pick or no hot pic with one big
                freesat.behind.buttonHGrid = [[0,1,0],[0,1,0],[0,0,0]];
                freesat.behind.buttonVGrid = [[0,0,0],[1,1,0],[0,0,0]];
            }
        },
        /**
         * onKey
         * @param vKey
         * @memberOf freesat.controllers.ShowCase
         * @returns boolean
         */
        onKey: function(vKey){
            if(!freesat.isAnimating){
                var keyHandling = new freesat.controllers.showcase.KeyHandling();
                return keyHandling.onKey(vKey);
            }
            return false;
        },
        /**
         * highlightOntv
         * highlights on tv banner
         * @memberOf freesat.controllers.ShowCase
         */
        highlightOntv: function(){
            var lang = new freesat.language.ShowCaseEn();
            this.get('showcase-strap').setText(lang.PLACEHOLDER_STRAPLINE);
            this.get('on-demand-title-container').addClass('lowlight');
            this.get('on-tv-title-container').removeClass('lowlight');
        },
        /**
         * highlightOndemand
         * highlights on demand banner
         * @memberOf freesat.controllers.ShowCase
         */
        highlightOndemand: function(){
            var lang = new freesat.language.ShowCaseEn();
            this.get('showcase-strap').setText(lang.PLACEHOLDER_STRAPLINE);
            this.get('on-demand-title-container').removeClass('lowlight');
            this.get('on-tv-title-container').addClass('lowlight');
        },
        /**
         * setTVFocus
         * set focus for on tv when big item present
         * @param {number} row
         * @param {number} col
         * @param {boolean} up
         * @memberOf freesat.controllers.ShowCase
         */
        setTVFocus : function(row, col, up){
            switch (row){
                case 0:
                    if(col == 1)col=2;
                    break;
                case 1:
                    switch (col){
                        case 0:
                            if(up){
                                row=0;
                            }else{
                                row=2;
                            }
                            break;
                        case 1:
                            if(up){
                                row=0;
                            }else if(up===false){
                                row=2;
                            }else{
                                col=0;
                            }
                            break;
                    }
            }
            freesat.behind.row = row;
            freesat.behind.column = col;
            freesat.behind.get('sc-tv-' + row + '-' + col).setFocus();
        },
        /**
         * checkTVtop
         * checks if on tv is at an time at the top and if the container need animating it starts the animation
         * @memberOf freesat.controllers.ShowCase
         */
        checkTVtop: function(){
            if(freesat.behind.row === 0 && freesat.behind.column === 0 && freesat.behind.topRow > 0){
                freesat.behind.tvTop+=175;
                if(freesat.behind.animationClass.aniUp('on-tv', freesat.behind.tvTop))freesat.behind.tvTop-=175;
            }
        },
        /**
         * showScrollbar
         */
        showScrollbar: function() {
            var scrollbar = freesat.behind.get('scroll-bar-container'),
                data, data_length, limit = 3, rows;

            if (freesat.behind.state === 'ontv') {
                scrollbar.removeClass('od');
                data = freesat.behind.rightProgrammes;
                data_length = data.length + 3;
                limit = 2;
            } else {
                scrollbar.addClass('od');
                data = freesat.behind.leftProgrammes;
                data_length = data.length;
            }
            rows = Math.floor((data_length - 1) / 3);

            if (rows > limit) {
                this.updateScrollbar();
                setTimeout(function() {
                    scrollbar.addClass('show');
                }, 350);
            } else {
                scrollbar.removeClass('show');
            }
        },
        /**
         * hideScrollbar
         */
        hideScrollbar: function() {
            freesat.behind.get('scroll-bar-container').removeClass('show');
        },

        /**
         * updateScrollbar
         */
        updateScrollbar: function(dir) {
            var handle = freesat.behind.get('scroll-bar-handle'),
                data, data_length, rows, height, offscreen, unit, diff,
                pos = 0,
                limit = 3,
                direction = dir || 'down';

            if (freesat.behind.area === 'ontv') {
                data = freesat.behind.rightProgrammes;
                data_length = data.length + 3;
            } else {
                data = freesat.behind.leftProgrammes;
                data_length = data.length;
            }
            rows = Math.ceil(data_length / 3);
            height = (limit / rows) * 100;
            offscreen = rows - 3;
            diff = 100 - height;
            unit = diff / offscreen;

            if ((freesat.behind.row > 2 && direction === 'down') || (freesat.behind.topRow > 0 && direction === 'up')) { // Position scrollbar handle
                pos = Math.round(unit * freesat.behind.topRow);
            }
            handle.root.setStyle({'height': height + '%', 'top': pos + '%'});
        },

        getUIPlacement: function(type){
            return this.getUIPlacementForColAndRow(type, this.column, this.row);
        },

        getUIPlacementForColAndRow: function(type, column, row){
            if (freesat.behind.dataLayer.usingDsmcc && (type == "ontv")) {
                return row*3 + column+1;
            }

            if (this.uiPlacementMap[type][row]){
                return this.uiPlacementMap[type][row][column];
            }else{
                // Must be beyond mapped positions so need to work out
                if (type == "ontv"){
                    return (row-1)*3 + column+1; 
                } else {
                    return row*3 + column+1; 
                }
            }

        },

        AM_ScreenView: function(){
            var urlParam = this.getAM_urlParam();
            freesat.am.screenView(urlParam);
        },

        getAM_urlParam: function() {
            var uri = '',
                uri2 = '',
                filter,
                uiPlacement = '';
            switch(freesat.behind.state) {
                case 'ontv':
                    uri = '/showcase/onTv/';
                    uri2 = freesat.behind.topRow + 1;
                    freesat.behind.getCurrentFilterName(function(filterName) {
                        uri = uri + filterName.toAMStandardised() + '/r' +uri2;
                    });
                    break;

                case 'ondemand':
                    uri = '/showcase/onDemand/';
                    uri2 = freesat.behind.topRow + 1;
                    freesat.behind.getCurrentFilterName(function(filterName) {
                        uri = uri + filterName.toAMStandardised() + '/r' +uri2;
                    });
                    break;

                case 'split':
                    uri = '/showcase/split/all/r1';
                    break;

                default:
                    uri = '/showcase/unknown';
            }

            

            return uri;
        }
    }
);
/**
 * @name ShowCasePlaceholder
 * @namespace
 * @memberOf freesat.controllers
 * @class
 */
accedo.Class.create('freesat.controllers.ShowCasePlaceholder', 'accedo.ui.Controller', ['freesat.view.ShowCasePlaceholder', 'freesat.controllers.showcase.KeyHandling', 'freesat.controllers.showcase.ItemCreation'],{},
    {

        initialize: function($super) {
            $super();
            freesat.oipfElement.setKeysetWithNumbers();
            freesat.console.log('[ShowCasePlaceholder Controller] initialize');
            this.clock = new freesat.models.Clock();
            this.setView(freesat.view.ShowCasePlaceholder);
        },
        setup: function () {
            freesat.behind = this;
            var lang = new freesat.language.ShowCaseEn();
            this.get('showcase-title').setText(lang.SHOWCASE);
            this.get('showcase-strap').setText(lang.PLACEHOLDER_STRAPLINE);
            this.itemSelection = new freesat.controllers.showcase.ItemSelection();
            this.clock.updateClock(this.get('pageClock'));
            this.get('showcase-connectionBackButton').setFocus();
            this.get('showcase-connectionBackButton').onKey = function (vKey) {
                if (vKey === accedo.VKey.KEY_OK) {
                    freesat.masterController.handleBackPress();
                    return true;
                }
            };
            trace("Browser load to Focus on screen");
            setTimeout(freesat.loadRemainingSections, 200);
        },

        reset: function () {
            //XDK[warn]
        },

    }
);
/**
 * User: Dean Clancy
 * Date: 26/02/14
 * Time: 09:46
 */
/*global accedo: false */
/**
 * Creates a new ShowcaseItem instance.
 * @name ShowcaseItem
 * @memberof freesat.ShowcaseItem
 * @class A ShowcaseItem class, bla functionality.
 * @author <a href="mailto:dean.clancy@accedo.tv">Dean Clancy</a>
 */
accedo.Class.create("freesat.models.vo.ShowcaseProgramme", [], {},
    {
        sc_id:null,
        programmeObject:null,
        lock:null,
        available:null,
        svc_id:null,
        fsvc_id:null,
        event_id:null,
        sc_title:null,
        sc_description:null,
        sc_long_description: null,
        sc_image:null,
        channel_logo:null,
        sc_title2:null,
        pick_flag:null,
        duration:null,
        genre:null,
        sc_title3:null,
        availability_text:null,
        icons: {
            pay : false,
            ssound : false,
            hd : false,
            dolby : false,
            guidance: false,
            subtitle: false,
            signed: false,
            ad: false,
            threed: false,
            hdlinkage: false,
            series: false,
            sc: false,
            ondemand: false
        },
        links: [],
        deepLink: null,
        CRIDS: []
    }
);
/**
 * User: Dean Clancy
 * Date: 26/02/14
 * Time: 09:12
 */
/*global accedo: false */
/**
 * Creates a new ShowcasePage instance.
 * @name ShowcasePage
 * @memberof freesat.ShowcasePage
 * @class A ShowcasePage class, bla functionality.
 * @author <a href="mailto:dean.clancy@accedo.tv">Dean Clancy</a>
 */
accedo.Class.create("freesat.models.vo.ShowcasePage", [], {},
    {
        id:null,
        title:null,
        sub_title:null,
        startfilter:null,
        filters:null
    }
);
/**
 * User: Dean Clancy
 * Date: 26/02/14
 * Time: 09:19
 */
/*global accedo: false */
/**
 * Creates a new ShowcaseFilter instance.
 * @name ShowcaseFilter
 * @memberof freesat.ShowcaseFilter
 * @class A ShowcaseFilter class, bla functionality.
 * @author <a href="mailto:dean.clancy@accedo.tv">Dean Clancy</a>
 */
accedo.Class.create("freesat.models.vo.ShowcaseFilter", [], {},
    {
        id: null,
        name: null,
        section_items: null,
        zoom_items: null
    }
);
/**
 * User: Dean Clancy
 * Date: 22/01/14
 * Time: 09:52
 */
/*global accedo: false */
/**
 * Creates a new Showcase instance.
 * @name Showcase
 * @memberof freesat.Showcase
 * @class A Showcase class, bla functionality.
 * @author <a href="mailto:dean.clancy@accedo.tv">Dean Clancy</a>
 */
accedo.Class.create("freesat.data.datafunc.Showcase", ["freesat.models.GetLocalFile"], {},
    {
        DSMCC_FETCHING: 0,
        DSMCC_COMPLETE: 1,
        DSMCC_ERROR: 2,
        /*
        Public functions

        getFilter(left, filterName, callback)
         left : boolean
         filterName : String
         callback : function

        getFilterNames(left, callback)
         left : boolean
         callback : function

        getDefaultFilterIndex(left, callback)
         left : boolean
         callback : function

         */
        UpdateDT : null,
        RefreshDT : null,
        expiryDT : null,
        logTime : 0,
        programmesByShowcaseId : {},
        left_page : [],
        right_page : [],
        client: null,
        usingDsmcc: false,

        isIpAvailable: function() {
            if (freesat.ipavailable && (window.localStorage.getItem('FORCE_DSMCC') === 'true')) {
                freesat.console.log('WARNING - forcing fetch using DSM-CC');
                return false;
            }

            return freesat.ipavailable;
        },
        getPageTitleAndStrap: function(left){
            if(left){
                return [this.left_page.title, this.left_page.sub_title];
            }else{
                return [this.right_page.title, this.right_page.sub_title];
            }
        },
        notTimeToRefresh: function(scope){
            var nowTime = new Date().getTime() / 1000;
            
            // TODO: do we really never want to refresh for DSM-CC?
            if (scope.usingDsmcc) {
                return true;
            }

            if(scope.logTime<nowTime){
                if(this.RefreshDT < nowTime){
                    freesat.console.log('dataLayer showcase : notTimeToRefresh : '+false);
                    return false;
                }
            }
            return true;
        },
        getFilter: function(left, filterName, callback){
            freesat.console.log('dataLayer showcase : getFilter ');
            if(this.expiryDT && this.notTimeToRefresh(this)){
                var func = this.returnFilter(this, left, filterName, callback);
                func();
            }else{
                this.getShowcase(this.returnFilter(this, left, filterName, callback));
            }
        },
        isStartFilter: function (left, filterIndex) {
            var page = left ? this.left_page : this.right_page;
            return page.filters[filterIndex].id === page.startfilter;
        },
        returnFilter: function(scope, left, filterName, callback){
            return function(){
                freesat.console.log('dataLayer showcase : returnFilter');
                var nowTime = new Date().getTime() / 1000;
                if(scope.expiryDT < nowTime){
                    callback(false);
                }else{
                    var filters = (left)?scope.left_page.filters:scope.right_page.filters;
                    var len = filters.length;
                    var data = [];
                    var filter, i;
                    for(i = 0;i<len;i++){
                        if(filters[i].name==filterName){
                            filter = filters[i];
                            break;
                        }
                    }
                    if(filter){
                        len = filter.section_items.length;
                        for(i = 0;i<len;i++){
                            var programme = scope.returnProgramme(scope, filter.section_items[i].sc_id);
                            if (programme) {
                                data.push(programme);
                            }
                        }
                        callback(data);
                    }else{
                        callback(false);
                    }
                }
            };
        },
        getFilterZoom: function(left, filterName, callback){
            freesat.console.log('dataLayer showcase : getFilterZoom ');
            if(this.expiryDT && this.notTimeToRefresh(this)){
                var func = this.returnFilterZoom(this, left, filterName, callback);
                func();
            }else{
                this.getShowcase(this.returnFilterZoom(this, left, filterName, callback));
            }
        },
        returnFilterZoom: function(scope, left, filterName, callback){
            return function(){
                freesat.console.log('dataLayer showcase : returnFilterZoom');
                var nowTime = new Date().getTime() / 1000;
//                if(scope.expiryDT < nowTime){
//                    callback(false);
//                }else{
                    var filters = (left)?scope.left_page.filters:scope.right_page.filters;
                    var len = filters.length;
                    var data = [];
                    var filter, i, has_zoom;
                    for(i = 0;i<len;i++){
                        if(filters[i].name==filterName){
                            filter = filters[i];
                            break;
                        }
                    }
                    if(filter){
                        has_zoom = (typeof filter.zoom_items !== "undefined") ? filter.zoom_items.length > 0 : false;

                        if (has_zoom) {
                            len = filter.zoom_items.length;
                            for(i = 0;i<len;i++){
                                var programme = scope.returnProgramme(scope, filter.zoom_items[i].sc_id);
                                if (programme) {
                                    data.push(programme);
                                }
                            }
                        } else {
                            len = filter.section_items.length;
                            for(i = 0;i<len;i++){
                                var programme = scope.returnProgramme(scope, filter.section_items[i].sc_id);
                                if (programme) {
                                    data.push(programme);
                                }
                            }
                        }
                        callback(data);
                    }else{
                        callback(false);
                    }
//                }
            };
        },
        returnProgramme: function(scope, sc_id){
            return scope.programmesByShowcaseId[sc_id];
        },
        getFilterNames: function(left, callback){
            freesat.console.log('dataLayer showcase : getFilterNames ');
            if(this.expiryDT && this.notTimeToRefresh(this)){
                this.returnFilterNames(this, left, callback)();
            }else{
                this.getShowcase(this.returnFilterNames(this, left, callback));
            }
        },
        returnFilterNames: function(scope, left, callback){
            return function(){
                    var filters = (left)?scope.left_page.filters:scope.right_page.filters,
                        len = filters.length,
                        data = [],
                        i;

                    for (i = 0; i < len; i++) {
                        data.push(filters[i].name);
                    }
                    callback(data);
            };
        },
        getDefaultFilterIndex: function(left, callback, cookieFilterId){
            freesat.console.log('dataLayer showcase : getDefaultFilterIndex ');
            if(this.expiryDT && this.notTimeToRefresh(this)){
                this.returnDefaultFilterIndex(this, left, callback, cookieFilterId)();
            }else{
                this.getShowcase(this.returnDefaultFilterIndex(this, left, callback, cookieFilterId));
            }
        },
        returnDefaultFilterIndex: function(scope, left, callback, cookieFilterId){
            return function(){
                var getFilterIndexFromFilterId = function (filterId) {
                    var filters = left ? scope.left_page.filters : scope.right_page.filters;
                    var len = filters.length;
                    for (var i = 0; i < len; i++) {
                        if (filters[i].id === filterId) {
                            return i;
                        }
                    }
                };
                var nowTime = new Date().getTime() / 1000;
                if(scope.expiryDT < nowTime){
                    callback(false);
                }else{
                    if (typeof cookieFilterId === "number") {
                        callback(getFilterIndexFromFilterId(cookieFilterId) || 0);
                        return;
                    }
                    var data = (left)?scope.left_page.startfilter:scope.right_page.startfilter;
                    callback(getFilterIndexFromFilterId(data) || 0);
                }
            };
        },
        getShowcase: function(dataCallback) {
            if (this.isIpAvailable()) {
                this.getShowcaseUsingHTTP(dataCallback);
            } else if (freesat.datamode === 'dsat') {
                this.getShowcaseUsingDSMCC(dataCallback);
            } else {
                dataCallback();
            }
        },
        getShowcaseUsingDSMCC: function (dataCallback) {
            var scope = this;

            freesat.console.log('[DSMCC] Fetching Showcase data');
            this.usingDsmcc = true;

            // first see if there's an up-to-date SC file available immediately
            freesat.dsmcc.getRegionalisedFile('sc.json', function(result) {
                var data = scope.parseShowcaseResult(scope, result);
                if (data) {
                    freesat.console.log('Got fresh Showcase data from DSM-CC carousel - no need to tune to home transponder');
                    scope.dsmccFetchCallback(scope.DSMCC_COMPLETE);
                    dataCallback(data);
                    return;
                }

                // try downloading from carousel
                scope.dsmccFetchCallback(scope.DSMCC_FETCHING);
                freesat.video.hide();

                freesat.console.log('No fresh Showcase data available from DSM-CC - tuning to home transponder in order to attempt to acquire it...');

                freesat.dsmcc.waitForCarouselUpdateOfFile(
                    'sc.json',
                    function(result) {
                        var data = scope.parseShowcaseResult(scope, result);
                        freesat.video.show();
                        if (data) {
                            freesat.console.log('Successfully got Showcase data from DSM-CC carousel');
                            scope.dsmccFetchCallback(scope.DSMCC_COMPLETE);
                            dataCallback(scope.data);
                        } else {
                            freesat.console.log('Failed to get Showcase data from DSM-CC carousel');
                            scope.dsmccFetchCallback(scope.DSMCC_ERROR);
                        }
                    });
            });
        },
        parseShowcaseResult: function(scope, result) {
            if (!result) {
                return null;
            }

            try {
                var data = JSON.parse(result),
                    nowTime = new Date().getTime() / 1000,
                    scData = data.showcase,
                    programmes = scData.showcase_events,
                    pages = scData.pages,
                    version = scData.version,
                    expiryDT = version.expiryDT;
                if (expiryDT < nowTime) {
                    freesat.console.log('Showcase data expired');
                    return null;
                }

                scope.data = data;
                scope.UpdateDT = version.updateDT;
                scope.RefreshDT = version.refreshDT;
                scope.expiryDT = expiryDT;

                scope.parseProgrammes(programmes, scope);
                scope.parsePage(pages[0], scope);
                scope.parsePage(pages[1], scope);

                return data;
            } catch (e) {
                console.log('Failed to parse Showcase result: ' + e);
            }

            return null;
        },
        setDsmccFetchCallback: function(callback) {
            this.dsmccFetchCallback = callback;
        },
        getShowcaseUsingHTTP: function (dataCallback) {
            try{
                var url = freesat.localConfig.auth.showcase + '/regional/sc/json',
                    regArr = freesat.localConfig.config.regions,
                    i, len = regArr.length,
                    prId, sr_name;

                for(i = 0; i < len; i++){
                    prId = regArr[i].pr_id;

                    if (prId) {
                        url += '/' + prId + '/' + regArr[i].sr_id;
                    } else {
                        sr_name = regArr[i].sr_name || 'null';
                        url += '/' + regArr[i].pr_name + '/' + sr_name;
                    }
                }

                var callback = {
                    success: this.httpSuccess(this),
                    failure: this.httpFailure,
                    returnCallback: dataCallback
                };

                this.httpRequest(url, callback, this);
            }catch(e){
                freesat.am.techEvent('/showcase', {
                    category: 'exception',
                    action: 'applicationException',
                    description: 'Got exception retrieving data from ' + url + ': ' + e
                });

                dataCallback();
            }
        },
        httpRequest: function(url, callback, scope) {
            scope.logTime = new Date().getTime() + 60000;
            freesat.console.log('request : ' + url);
            freesat.masterController.showLoading();
            scope.client = new XMLHttpRequest();
            scope.client.onreadystatechange = function() {
                if (scope.client.readyState == XMLHttpRequest.DONE) {
                    if (scope.client.status === 200) {
                        scope.data = callback.success(callback.returnCallback);
                    } else {
                        scope.data = callback.failure(scope.client.status);

                        freesat.am.techEvent('/showcase', {
                            category: 'exception',
                            action: 'applicationException',
                            description: 'Got status code ' + scope.client.status + ' for request ' + url
                        });
                    }
                }
            };

            try {
                scope.client.open('get', url, true, scope.username, scope.password);
                scope.client.send();
            } catch (e) {
                freesat.masterController.hideLoading();
                freesat.console.log('request error : ' + e);
                freesat.am.techEvent('/showcase', {
                    category: 'exception',
                    action: 'applicationException',
                    description: 'Got exception for request ' + url + ': ' + e
                });
            }
        },
        httpFailure: function() {
            freesat.masterController.hideLoading();
            freesat.console.log('Failed to retrieve file');
            freesat.behind.showNotAvailable();
        },
        httpSuccess: function(scope){
            return function(dataCallback){
                var data = JSON.parse(scope.client.responseText),
                    scData = data.showcase,
                    version = scData.version,
                    programmes = scData.showcase_events,
                    pages = scData.pages,
                    i;
                freesat.masterController.hideLoading();
                scope.UpdateDT = version.updateDT;
                scope.RefreshDT = version.refreshDT;
                scope.expiryDT = version.expiryDT;
                var nowTime = new Date().getTime() / 1000;
                if(scope.expiryDT < nowTime){
                    freesat.console.log('Showcase data expired');
                    dataCallback(false);
                   freesat.am.techEvent('/showcase', {
                        category: 'exception',
                        action: 'applicationException',
                        description: 'Showcase data expired'
                    });
                    return false;
                }else{
                    scope.parseProgrammes(programmes, scope);
                    scope.parsePage(pages[0], scope);
                    scope.parsePage(pages[1], scope);
                    dataCallback(data);
                }
            };
        },
        parsePage: function(page, scope){
            var resObject = {},
                i, filters, len;
            try {
                resObject = new freesat.models.vo.ShowcasePage();
                resObject.id = page.id;
                resObject.title = page.title;
                resObject.sub_title = page.sub_title;
                resObject.startfilter = page.startfilter;
                resObject.filters = [];
                filters = page.filters;
                len = filters.length;
                for (i = 0; i < len; i++) {
                    resObject.filters.push(scope.parseFilter(filters[i]));
                }
            } catch (e) {
                freesat.console.log('parsePageError : '+ e);
                freesat.am.techEvent('/showcase', {
                    category: 'exception',
                    action: 'applicationException',
                    description: 'Failed to parse showcase data: ' + e
                });

            }
            if (resObject.id === 'left') {
                scope.left_page = resObject;
            } else {
                scope.right_page = resObject;
            }
        },
        parseFilter: function(filter){
            var resObject = new freesat.models.vo.ShowcaseFilter();
            resObject.id = filter.id;
            resObject.name = filter.name;
            resObject.section_items = filter.section_items;
            resObject.zoom_items = filter.zoom_items;

            return resObject;
        },
        parseProgrammes: function(programmes, scope){
            var len = programmes.length, i;
            for(i=0;i<len;i++){
                var dat = scope.parseProgramme(programmes[i]);
                if (dat) {
                    scope.programmesByShowcaseId[dat.sc_id] = dat;
                }
            }
        },
        parseProgramme: function(programme){
            // certain fields copied to other names to make it compatible with other programObjects
            var i, n, m, len, links, regionalVariants = [];
            var pItem = new freesat.models.vo.ShowcaseProgramme();
            pItem.sc_id = programme.sc_id;
            pItem.programmeObject = programme.programmeObject;
            pItem.lock = programme.lock;
            pItem.available = programme.available;
            pItem.svc_id = programme.svc_id;
            pItem.fsvc_id = programme.fsvc_id;
            pItem.event_id = programme.event_id;
            pItem.sc_title = pItem.name = programme.sc_title;
            pItem.sc_description = pItem.description = programme.sc_description;
            pItem.sc_long_description = pItem.longDescription = programme.sc_long_description;
            pItem.sc_image = programme.sc_image;
            pItem.channel_logo = programme.channel_logo;
            pItem.sc_title2 = programme.sc_title2;
            pItem.pick_flag = programme.pick_flag;
            pItem.startTime = programme.starttime;
            pItem.duration = programme.duration;
            pItem.genre = [programme.genre]; // Assigning as an array to match OIPF programme object
            pItem.sc_title3 = programme.sc_title3;
            pItem.availability_text = programme.availability_text;
            if (programme.icons) {
                pItem.icons.pay = programme.icons.pay;
                pItem.icons.ssound = programme.icons.ssound;
                pItem.icons.hd = programme.icons.hd;
                pItem.icons.dolby = programme.icons.dolby;
                pItem.icons.guidance = programme.icons.guidance;
                pItem.icons.subtitle = programme.icons.subtitle;
                pItem.icons.signed = programme.icons.signed;
                pItem.icons.ad = programme.icons.ad;
                pItem.icons.threed = programme.icons.threed;
                pItem.icons.hdlinkage = programme.icons.hdlinkage;
                pItem.icons.series = programme.icons.series;
                pItem.icons.sc = programme.icons.sc;
                pItem.icons.ondemand = programme.icons.ondemand;
            }
            links = programme.links;
            if (links && links.length) {
                pItem.links = links;
                len = links.length;
                for (n = 0; n < len; n++){
                    if (links[n].ondemand_link) {
                        if (links[n].ondemand_link.type &&
                            (links[n].ondemand_link.type.toUpperCase() === "CTV" ||
                            links[n].ondemand_link.type.toUpperCase() === "HTML" ||
                            links[n].ondemand_link.type.toUpperCase() === "MHEG" ||
                            links[n].ondemand_link.type.toUpperCase() === "HBBTV")) {
                            pItem.linkType = links[n].ondemand_link.type;
                            pItem.linkText = links[n].ondemand_link.text;
                            pItem.linkServiceId = links[n].ondemand_link.serviceid;
                            break;
                        }
                    }
                    if (links[n].events_link) {
                        for (m = links[n].events_link.length - 1; m >= 0; m--) {
                            var link = links[n].events_link[m];

                            switch (link.type) {
                                case "EVENTID":
                                    if (!link.text || (link.text.indexOf('dvb://') != 0) || (link.text.indexOf(';') == -1)) {
                                        freesat.console.log('Unexpected EVENTID link format: "' + link.text + '"');
                                        break;
                                    }
                                    var linkParts = link.text.substr('dvb://'.length).split(';');
                                    var serviceTriplet = linkParts[0];
                                    regionalVariants.push({
                                        serviceId: parseInt(serviceTriplet.substr(serviceTriplet.lastIndexOf('.') + 1), 16),
                                        eventId: parseInt(linkParts[1], 16)
                                    });
                                    break;
                                case "PCRIDID": pItem.CRIDS.push('0x31' + link.text);break;
                                case "SCRIDID": pItem.CRIDS.push('0x32' + link.text);break;
                                case "RCRIDID": pItem.CRIDS.push('0x33' + link.text);break;
                            }
                        }
                    }
                }
            }
            if (pItem.linkType && pItem.linkText) {
                pItem.deepLink = "native://freetime/" + pItem.linkType.toLowerCase() + "/[%]" + freesat.localConfig.auth.ipchannelsmgr + pItem.linkText + "[%]";
                pItem.deepLinkType = pItem.linkType;
                pItem.deepLinkServiceId = pItem.linkServiceId;
            } else {
                var bestRegionalVariant = null;
                for (var i = 0; i < regionalVariants.length; i++) {
                    var regionalVariant = regionalVariants[i];
                    var channel = freesat.channelData.getChannelObjectByServiceID(regionalVariant.serviceId);
                    if (!channel) {
                        console.log('Failed to find service id ' + regionalVariant.serviceId);
                        continue;
                    }

                    regionalVariant.lcn = parseInt(channel.ccid.substr('ccid:'.length));
                    regionalVariant.fsid = channel.freesatServiceID.toString();

                    // pick channel with lowest LCN
                    if (!bestRegionalVariant || regionalVariant.channel.lcn < bestRegionalVariant.channel.lcn) {
                        bestRegionalVariant = regionalVariant;
                    }
                }
                if (bestRegionalVariant) {
                    pItem.svc_id = bestRegionalVariant.serviceId;
                    pItem.fsvc_id = bestRegionalVariant.fsid;
                    pItem.event_id = bestRegionalVariant.eventId;
                } else {
                    freesat.console.log('Ignoring On TV item not showing on available channels');
                    return null;
                }
            }
            
            return pItem;
        }
    }
);