accedo.ui.View.create('freesat.view.Search', {
    type: accedo.ui.layout.Normal,
    defaultFocus: 'searchKeyboard',
    id: '#search',
    children: [
        {
            type: accedo.ui.widget.Image,
            id: '#backgrounnd',
            src: 'images/1280x720/background/back_search.png'
        },
        {
            id: '#header-controller',
            controller: 'freesat.controllers.subcontrollers.Header'
        },
        {
            type: accedo.ui.Container,
            id: '#container',
            css: 'container',
            children: [
                    {
                        type: accedo.ui.Container,
                        id: '#straplineBG',
                        css: 'straplineBG'
                    },
                    {
                        type: accedo.ui.Container,
                        id: '#searchEntry',
                        css: 'searchEntry',
                        children:
                            [
                                {
                                    type: freesat.widget.InputField,
                                    id: '#searchInput',
                                    css: 'inputField',
                                    maxLength: 10
                                },
                                {
                                    type: freesat.widget.Keyboard,
                                    id: '#searchKeyboard',
                                    css: 'freesat-keyboard keyboard',
                                    focusable: true,
                                    firstSelectedIndex:[0,4]
                                }
                            ]
                    },
                    {
                        type: accedo.ui.Container,
                        id: '#searchLandingPage',
                        children:
                            [
                                {
                                    type: accedo.ui.Container,
                                    id: '#strapline',
                                    css: 'straplineSearch',
                                    children:
                                        [
                                            {
                                                type: accedo.ui.widget.Label,
                                                id: '#straplineTitle',
                                                css: 'straplineTitle'
                                            }
                                        ]
                                },
                                {
                                    type: accedo.ui.Container,
                                    id: '#searchInstructionsContainer',
                                    css: 'searchInstructionsContainer',
                                    children:
                                        [
                                            {
                                                type: accedo.ui.widget.Label,
                                                id: '#searchInstructionsHeadline',
                                                css: 'searchInstructionsHeadline'
                                            },
                                            {
                                                type: accedo.ui.widget.Label,
                                                id: '#searchInstructions',
                                                css: 'searchInstructions'
                                            }
                                        ]
                                }
                            ]
                    },
                    {
                        type: accedo.ui.Container,
                        id: '#searchResultsPage',
                        css: 'hidden',
                        children:
                            [
                                {
                                    type: accedo.ui.Container,
                                    id: '#straplineResults',
                                    css: 'straplineSearch',
                                    children:
                                        [
                                            {
                                                type: accedo.ui.widget.Label,
                                                id: '#straplineResultsTitle',
                                                css: 'straplineTitle'
                                            }
                                        ]
                                },
                                {
                                    type: accedo.ui.Container,
                                    id: '#searchResults',
                                    css: 'searchResults',
                                    children: [
                                        {
                                            type: accedo.ui.Container,
                                            id: '#searchPeekGradient',
                                            css: 'peek-gradient'
                                        },
                                        {
                                            type: accedo.ui.widget.Label,
                                            id: '#searchResultsCount',
                                            css: 'search-results-count'
                                        }
                                    ]
                                },
                                {
                                    type: accedo.ui.Container,
                                    id: '#groupResults',
                                    css: 'group-results hidden',
                                    children: [

                                        {
                                            type: accedo.ui.Container,
                                            id: '#straplineBG',
                                            css: 'straplineBG'
                                        },
                                        {
                                            type: accedo.ui.Container,
                                            id: '#search-filter-container',
                                            css: '',
                                            children: [
                                                {
                                                    type: accedo.ui.Container,
                                                    id: '#search-filter-bg'
                                                },
                                                {
                                                    type: accedo.ui.Container,
                                                    id: '#search-filter-buttons',
                                                    children: [
                                                        {
                                                            type: accedo.ui.widget.Button,
                                                            id: '#filter-ontv',
                                                            css: 'search-filter-button',
                                                            text: 'On TV'
                                                        },
                                                        {
                                                            type: accedo.ui.widget.Button,
                                                            id: '#filter-ondemand',
                                                            css: 'search-filter-button',
                                                            text: 'On Demand'
                                                        }
                                                    ]
                                                }
                                            ]
                                        },
                                        {
                                            type: freesat.widget.VTextImageButton,
                                            id: '#leftArrow',
                                            src: 'images/1280x720/arrow/arrow_left_srch.png',
                                            focusedsrc: 'images/1280x720/arrow/arrow_left_search.png',
                                            text: 'back',
                                            align: 'left'
                                        },
                                        {
                                            type: accedo.ui.Container,
                                            id: '#groupPage',
                                            css: 'group-page',
                                            children: [
                                                {
                                                    type: accedo.ui.widget.Label,
                                                    id: '#groupTitle',
                                                    css: 'group-title',
                                                    text: ''
                                                },
                                                {
                                                    type: accedo.ui.Container,
                                                    id: '#groupListMask',
                                                    css: 'group-list-mask'
                                                },
                                                {
                                                    type: accedo.ui.widget.Label,
                                                    id: '#groupNoResults',
                                                    css: 'group-no-results hidden'
                                                },
                                                {
                                                    type: accedo.ui.Container,
                                                    id: '#groupPeekGradient',
                                                    css: 'peek-gradient'
                                                },
                                                {
                                                    type: accedo.ui.widget.Label,
                                                    id: '#groupResultsCount',
                                                    css: 'search-results-count'
                                                }
                                            ]
                                        }
                                    ]
                                }

                            ]
                    },
                {
                    type : accedo.ui.Container,
                    id: '#search-disconnected',
                    css : 'search-disconnected',
                    children :
                        [
                            {
                                type : accedo.ui.Container,
                                id:'#search-connection-image-holder',
                                css:'search-connection-image-holder',
                                children :
                                [
                                    {
                                        type : accedo.ui.widget.Image,
                                        id : '#search-connection-image',
                                        css : 'search-connection-image',
                                        src : ''
                                    }
                                ]
                            },
                            {
                                type : accedo.ui.Container,
                                id : '#search-connection-message',
                                css : 'search-connection-message',
                                children :
                                    [
                                        {
                                            type : accedo.ui.widget.Label,
                                            id: '#search-connectionLabel',
                                            css:'search-connectionLabel',
                                            text : 'not connected'
                                        },
                                        {
                                            type : accedo.ui.widget.Label,
                                            id: '#search-connectionmessageLabel',
                                            css:'search-connectionmessageLabel',
                                            text : 'it appears that you\'re not connected to the internet and thats why we can\'t bring you search'
                                        },
                                        {
                                            type : accedo.ui.widget.Button,
                                            id: '#search-connectionretrybutton',
                                            css:'search-connectionretrybutton',
                                            text : 'Retry the connection',
                                            nextDown : 'search-connectionBackButton'
                                        },
                                        {
                                            type : accedo.ui.widget.Button,
                                            id: '#search-connectionBackButton',
                                            css:'search-connectionBackButton',
                                            text : 'Back',
                                            nextUp:'search-connectionretrybutton'
                                        }

                                    ]
                            }

                        ]
                }
                ]
        },
        {
            id: '#footer-controller',
            controller: 'freesat.controllers.subcontrollers.Footer'
        },
        {
            type: accedo.ui.Container,
            id: '#filterOverlay',
            css: 'filter-overlay'
        },
        {
            type: accedo.ui.Container,
            id: '#filterMenu',
            css: 'filter-menu',
            children: [
                {
                    type: accedo.ui.Container,
                    id: '#filterSelection',
                    css: 'filter-selection',
                    children: [
                        {
                            type: accedo.ui.widget.Label,
                            id: '#filterSelectionTypes',
                            css: 'filter-selection-types'
                        }
                    ]
                }
            ]
        }
    ]
});
/**
 * @namespace freesat.controllers.search
 * @memberOf freesat.controllers
 */

/**
 * @name Create
 * @namespace
 * @memberof freesat.controllers.search
 * @class
 * @author <a href="mailto:rhys.jeffreys@accedo.tv">Rhys Jeffreys</a>
 */
accedo.Class.create("freesat.controllers.search.Create", ["freesat.widget.ButtonWith2FieldsAndImage"], {},
    {
        ICON_RECORDING: 'images/1280x720/icon/icon_rec.png',
        ICON_REMINDER: 'images/1280x720/icon/icon_reminder.png',

        /**
         *
         * @param page - current page
         * @param last - last item number of current page
         * @param total - number of results
         * @memberOf freesat.controllers.search
         * @returns - populates search results count
         */
        resultsLabel: function(page, last, total) {
            var first = (page * freesat.behind.MAX_DISPLAY_ITEMS) + 1,
                msg = '';

            // if (page > 0) {
                last = (page * freesat.behind.MAX_DISPLAY_ITEMS) + freesat.behind.MAX_DISPLAY_ITEMS;
                if (last > total) {
                    last = total;
                }
            // }

            if (total > 50) {
                total = 'over 50';
            }

            if (total <= 1) {
                msg += total + ' result';

                if (total === 0) {
                    msg += 's';
                }
            } else {
                msg += first + '-' + last + ' of ' + total + ' results';
            }

            return msg;
        },
        /**
         *
         * @param number - index - pass the position of the result item
         * @param src - image channel icon
         * @param focusedsrc
         * @param leftLabel - programme name
         * @param rightLabel - startTime
         * @memberOf freesat.controllers.search
         * @returns {freesat.widget.ButtonWith2FieldsAndImage}
         */
        searchResultItem: function(opts) {
            opts.index = opts.index || 0;
            opts.resultIndex = opts.resultIndex || 0;
            opts.src = opts.src || null;
            opts.focusedsrc = opts.focusedsrc || null;
            opts.leftLabel = opts.leftLabel || '';
            opts.middleLabel = opts.middleLabel || '';
            opts.middleIcon = opts.middleIcon || '';
            opts.rightLabel = opts.rightLabel || '';
            opts.name = opts.name || '';
            opts.channel = opts.channel || '';
            opts.date = opts.date || '';
            opts.duration = opts.duration || '';
            opts.programObject = opts.programObject || null;
            opts.events = opts.events || [];
            opts.episodes = opts.episodes || 0;

            var obj = {
                id: '#result' + opts.resultIndex,
                src: opts.src,
                focusedsrc: opts.focusedsrc,
                lefttext: opts.leftLabel,
                middletext: opts.middleLabel,
                middleicon: opts.middleIcon,
                righttext: opts.rightLabel,
                imageBackground: true,
                index: opts.resultIndex,
                name: opts.name,
                channel: opts.channel,
                date: opts.date,
                duration: opts.duration,
                programObject: opts.programObject,
                events: opts.events,
                ontv: opts.ontv,
                ondemand: opts.ondemand,
                episodes: opts.episodes
            };

            // if (opts.resultIndex % 6 !== 0) {
            //     obj.nextUp = 'result' + (opts.resultIndex - 1);
            // }

            // if ((opts.resultIndex + 1) % 6 !== 0) {
            //     obj.nextDown = 'result' + (opts.resultIndex + 1);
            // }
            obj.css = 'search-item full-width';

            if (opts.ondemand.length > 0) {
                obj.css += ' ondemand';
            }
            
            var btn = new freesat.widget.ButtonWith3FieldsAndImage(obj);
            // freesat.behind.resultsHolder.attach(btn);
            btn.getLeftLabel().addClass('programme-label');
            btn.getRightLabel().addClass('starttime-label');
            btn.notifyFocused = freesat.behind.setHeader;
            btn.onKey = freesat.behind.handleItemSelection;

            btn.setReminder = function(hasReminder) {
                btn.setMiddleText('');
                btn.setMiddleIcon(hasReminder ? 'images/1280x720/icon/icon_reminder.png' : '');
            };
            
            btn.setRecording = function(hasRecording) {
                btn.setMiddleText('');
                btn.setMiddleIcon(hasRecording ? 'images/1280x720/icon/icon_rec.png' : '');
            };
            
            return btn;
        },
        /**
         *
         * @param opts {object}
         * @memberOf freesat.controllers.search
         * @returns {freesat.widget.ButtonWith2FieldsAndImage}
         */
        groupItem: function(opts) {
            opts.index = opts.index || 0;
            opts.resultIndex = opts.resultIndex || 0;
            opts.src = opts.src || null;
            opts.focusedsrc = opts.focusedsrc || null;
            opts.leftLabel = opts.leftLabel || '';
            opts.middleLabel = opts.middleLabel || '';
            opts.middleIcon = opts.middleIcon || '';
            opts.rightLabel = opts.rightLabel || '';
            opts.name = opts.name || '';
            opts.channel = opts.channel || '';
            opts.date = opts.date || '';
            opts.duration = opts.duration || '';
            opts.programObject = opts.programObject || null;
            opts.ondemand = opts.ondemand || null;

            var obj = {
                id: '#group' + opts.index,
                src: opts.src,
                focusedsrc: opts.focusedsrc,
                lefttext: opts.leftLabel,
                middletext: opts.middleLabel,
                middleicon: opts.middleIcon,
                righttext: opts.rightLabel,
                imageBackground: false,
                index: opts.resultIndex,
                name: opts.name,
                channel: opts.channel,
                date: opts.date,
                duration: opts.duration,
                programObject: opts.programObject
            };

            // if (opts.index !== 0) {
            //     obj.nextUp = 'group' + (opts.index - 1);
            // }

            // if (opts.index !== 6) {
            //     obj.nextDown = 'group' + (opts.index + 1);
            // }
            obj.css = 'search-item full-width';

/*
            var btn = new freesat.widget.ButtonWith2FieldsAndImage(obj);
            freesat.behind.groupHolder.attach(btn);
            btn.getLeftLabel().addClass('programme-label');
            btn.getRightLabel().addClass('starttime-label');
            btn.notifyFocused = freesat.behind.setHeader;
            btn.onKey = freesat.behind.handleItemSelection;
            return btn;
*/            
            
            var btn = new freesat.widget.ButtonWith3FieldsAndImage(obj);
            freesat.behind.groupHolder.attach(btn);
            btn.getLeftLabel().addClass('programme-label');
            btn.getRightLabel().addClass('starttime-label');
            btn.notifyFocused = freesat.behind.setHeader;
            btn.onKey = freesat.behind.handleItemSelection;

            btn.setReminder = function(hasReminder) {
                btn.setMiddleText('');
                btn.setMiddleIcon(hasReminder ? 'images/1280x720/icon/icon_reminder.png' : '');
            };
            
            btn.setRecording = function(hasRecording) {
                btn.setMiddleText('');
                btn.setMiddleIcon(hasRecording ? 'images/1280x720/icon/icon_rec.png' : '');
            };
            return btn;
        },
        /**
         * Create the search results listing
         * Reset all search page, top index and row vars to 0
         * @memberOf freesat.controllers.search
         */
        searchResults: function() {
            freesat.behind.page = freesat.behind.topPositionIndex = freesat.behind.currentRows = freesat.behind.row = 0;
            freesat.behind.populateSearchResults(true, true);

            if (!freesat.behind.hasResults) {
                freesat.behind.hasResults = true;
            }

            freesat.behind.landingPage.addClass("hidden");
            freesat.behind.resultsPage.removeClass("hidden");
        },

        noGroupResultsMessage: function() {
            var label = freesat.behind.get('groupNoResults'),
                message = 'There are currently no results for "{{programme}}" {{section}}',
                section = (freesat.behind.groupType === 'ontv') ? 'On TV.' : 'On Demand.';

            if (!freesat.behind.isIpAvailable() && (freesat.behind.groupType !== 'ontv')) {
                message = 'Please connect your TV to the Internet to search for On Demand availability of "{{programme}}"'
            }

            message = message.replace('{{programme}}', freesat.behind.groupMenu.name).replace('{{section}}', section);
            freesat.behind.get('groupContainer').addClass('hidden');
            label.setText(message);
            label.removeClass('hidden');
        },

        /**
         *
         * @param group {array} - of programObjects for selected multiple search result
         * @memberOf freesat.controllers.search
         */
        groupResults: function(group, ontv) {
            var selector = 'filter-';

            if (ontv) {
                freesat.behind.get('search-filter-container').addClass('ontv');
                freesat.behind.groupType = 'ontv';
            } else {
                freesat.behind.get('search-filter-container').removeClass('ontv');
                freesat.behind.groupType = 'ondemand';
            }

            if (group.length > 0) {
                freesat.behind.groupPage = 0;
                freesat.behind.groupTopPositionIndex = 0;
                freesat.behind.groupCurrentRows = 0;
                freesat.behind.groupRow = 0;

                freesat.behind.group = group;
                freesat.behind.populateGroupResults(true, false, true);
                freesat.behind.get('groupNoResults').addClass('hidden');
            } else {
                // Show no results
                this.noGroupResultsMessage();
            }
            selector += (ontv) ? 'ontv': 'ondemand';

            freesat.behind.get(selector).setFocus();

            if (!freesat.behind.hasGroupResults) {
                freesat.behind.hasGroupResults = true;
            }
            freesat.behind.get('groupTitle').setText(freesat.behind.groupMenu.name.toLowerCase());
            freesat.behind.get('groupResults').removeClass('hidden');
            freesat.behind.currentFocus = 'group_menu';
//            freesat.behind.currentFocus = 'group_results';
        },

        /**
         * Display no results page
         * @memberOf freesat.controllers.search
         */
        noResults: function() {
            var NO_RESULTS_HEADER = "No results",
                NO_RESULTS_DESCRIPTION = "Please change your search term",
                header = new accedo.ui.widget.Label({
                    id: '#NoResultsLabel',
                    css: 'header',
                    text: NO_RESULTS_HEADER
                }),
                description = new accedo.ui.widget.Label({
                    id: '#NoResultsDescription',
                    css: 'description',
                    text: NO_RESULTS_DESCRIPTION
                });

            // Remove existing search results
            if (freesat.behind.hasResults) {
                freesat.behind.deleteSearchResults();
                freesat.behind.hasResults = false;
            }

            // Create results holder
            freesat.behind.resultsHolder = new accedo.ui.Container({
                id: '#resultsHolder',
                css: 'results-list no-results'
            });

            freesat.behind.resultsHolder.attach(header);
            freesat.behind.resultsHolder.attach(description);
            freesat.behind.searchResults.attach(freesat.behind.resultsHolder);

            freesat.behind.searchResultsCount.setText('');
            freesat.behind.landingPage.addClass("hidden");
            freesat.behind.resultsPage.addClass('show-no-results').removeClass("hidden");
        },
        /**
         * Create a new filter menu from the available types
         * populated in the filter_menu array
         * @memberOf freesat.controllers.search
         */
        filterMenu: function() {
            var arr = freesat.behind.filter_menu,
                len = arr.length,
                height,
                i, y = 0;

            if (freesat.behind.hasFilterMenu) {
                freesat.behind.filterSelectionMenu.detach();
            }
            freesat.behind.hasFilterMenu = true;

            freesat.behind.filterSelectionMenu = new accedo.ui.Container({
                id: '#filterSelectionMenu',
                css: 'filter-selection-menu'
            });

            freesat.behind.filter_order = [];


            for (i = 0; i < len; i++) {
                if (i === 0) {
                    height = 0;
                } else if (i === 1) {
                    height = 50;
                } else {
                    height = 40;
                }
                y = y + height;
                freesat.behind.filter_order.push(i);
                freesat.behind.filterSelectionMenu.attach(this.filterButton(arr[i], y, i));
            }

            freesat.behind.get('filterMenu').attach(freesat.behind.filterSelectionMenu);
        },
        /**
         *
         * @param {string} text - for button label
         * @param yPos - for button css top positioning
         * @param index - button index
         * @memberOf freesat.controllers.search
         * @returns {accedo.ui.widget.Button}
         */
        filterButton: function(text, yPos, index) {
            var item = new accedo.ui.widget.Button({
                id: '#filter' + index,
                css: 'filter-menu-item',
                text: text
            });

            item.root.setStyle({
                top: yPos + 'px'
            });

            item.onKey = freesat.behind.filterResults;
            return item;
        }
    }
);
/**
 * Creates a new KeyHandler instance.
 * @name KeyHandler
 * @namespace
 * @memberof freesat.controllers.search
 * @class A KeyHandler class
 * @author <a href="mailto:rhys.jeffreys@accedo.tv">Rhys Jeffreys</a>
 */
accedo.Class.create("freesat.controllers.search.KeyHandler", [], {},
    {
        onKey: function(vKey) {

            var lookupOipfProgram = function(searchProgram, cb) {
                if (searchProgram.oipfProgram) {
                    cb(searchProgram.oipfProgram);
                    return;
                }

                freesat.masterController.showLoading();
                freesat.dataStore.getInterface().searchProgrammes(
                    searchProgram.channelID,
                    searchProgram.startTime,
                    null,
                    1,
                    function(results) {
                        freesat.masterController.hideLoading();
                        var result = null;
                        if (!results || results.length === 0) {
                            cb(null);
                        } else {
                            searchProgram.oipfProgram = results[0];
                            cb(searchProgram.oipfProgram);
                        }
                    });
            };

            if (freesat.behind.currentFocus !== 'keypad') {
                switch (vKey) {
                    case accedo.VKey.KEY_LEFT:
                        return this.onLeftKey();
                    case accedo.VKey.KEY_RIGHT:
                        return this.onRightKey();
                    case accedo.VKey.KEY_UP:
                        return this.onUpKey();
                    case accedo.VKey.KEY_DOWN:
                        return this.onDownKey();
                    case accedo.VKey.KEY_PAGE_UP:
                    case accedo.VKey.KEY_KEYBOARD_PAGE_UP:
                        if (freesat.behind.currentFocus === 'search_results') {
                            freesat.behind.tapPageUp = false;
                            return this.onPageUp();
                        } else if (freesat.behind.currentFocus === 'group_results') {
                            freesat.behind.tapGroupPageUp = false;
                            return this.onGroupPageUp();
                        }
                        break;

                    case accedo.VKey.KEY_PAGE_DOWN:
                    case accedo.VKey.KEY_KEYBOARD_PAGE_DOWN:
                        if (freesat.behind.currentFocus === 'search_results') {
                            freesat.behind.tapPageDown = false;
                            return this.onPageDown();
                        } else if (freesat.behind.currentFocus === 'group_results') {
                            freesat.behind.tapGroupPageDown = false;
                            return this.onGroupPageDown();
                        }
                        break;

                    case accedo.VKey.KEY_GREEN:
                        return this.onGreenKey();

                    case accedo.VKey.KEY_RED:
                        if (freesat.behind.filterMenuIsVisible) {
                            return true;
                        }
                        return false;

                    case accedo.VKey.KEY_BACK:
                        if (freesat.behind.currentFocus === 'filter_menu') {
                            freesat.behind.toggleFilterMenu();
                            return true;
                        } else if (freesat.behind.currentFocus === 'group_results' || freesat.behind.currentFocus === 'group_menu') {
                            freesat.behind.hideGroupResults();
                            return true;
                        }
                        return false;
                    case accedo.VKey.KEY_0:
                    case accedo.VKey.KEY_1:
                    case accedo.VKey.KEY_2:
                    case accedo.VKey.KEY_3:
                    case accedo.VKey.KEY_4:
                    case accedo.VKey.KEY_5:
                    case accedo.VKey.KEY_6:
                    case accedo.VKey.KEY_7:
                    case accedo.VKey.KEY_8:
                    case accedo.VKey.KEY_9:
                        return true; // Don't allow channel change from search page.
                    case accedo.VKey.KEY_REC:
                        if (!freesat.masterController.recordingsHandler.hasPVR()) {
                            freesat.masterController.recordingsHandler.showNoHddWarning();
                            return;
                        }

                        var item = null;
                        if (freesat.behind.currentFocus === 'group_results') {
                            item = freesat.behind.groupHolders[freesat.behind.groupPage].getChildren()[freesat.behind.groupRow];
                        } else if (freesat.behind.currentFocus === 'search_results') {
                            item = freesat.behind.resultsHolders[freesat.behind.page].getChildren()[freesat.behind.row];
                        }

                        if (!item || !item.opts || !item.opts.programObject) {
                            freesat.console.log('Couldn\'t find source item - can\'t record');
                            return;
                        } else if (item.opts.episodes > 1) {
                            freesat.console.log('Can\'t record a group of results');
                            return;
                        }

                        lookupOipfProgram(item.opts.programObject, function(oipfProgram) {
                            if (!oipfProgram) {
                                // TODO: error notification
                                console.log('RECORDING ERROR - couldn\'t find event in EPG to be recorded/cancelled');
                                return;
                            }
                            var recHandler = freesat.masterController.recordingsHandler;
                            if (oipfProgram.hasRecording) {
                                if (recHandler.removeRecording(oipfProgram) == recHandler.RECORDING_CHANGE_OK) {
                                    item.setRecording(false);
                                    freesat.header.metaIcons.setIcon('recording', freesat.header.programmeMetadataIconsContainer, false);
                                    console.log('cancelled recording ok');
                                } else {
                                    console.log('FAILED TO CANCEL RECORDING!!!!');
                                }
                            } else {
                                switch (freesat.masterController.recordingsHandler.setRecording(oipfProgram)) {
                                case freesat.masterController.recordingsHandler.RECORDING_CLASH:
                                    // ignore as recording will have been set correctly and warning dialog will be shown: fall through
                                case freesat.masterController.recordingsHandler.RECORDING_CHANGE_OK:
                                    console.log("set recording ok");
                                    item.setRecording(true);
                                    freesat.header.metaIcons.setIcon('recording', freesat.header.programmeMetadataIconsContainer, true)
                                    break;
                                default:
                                    console.log("RECORDING FAILURE!!!!");
                                    // TODO: pop-up
                                    break;
                                }
                            }
                        });
                        return true;

                    case accedo.VKey.KEY_STOP:
                        if (!freesat.masterController.recordingsHandler.hasPVR()) {
                            return;
                        }

                        var item = null;
                        if (freesat.behind.currentFocus === 'group_results') {
                            item = freesat.behind.groupHolders[freesat.behind.groupPage].getChildren()[freesat.behind.groupRow];
                        } else if (freesat.behind.currentFocus === 'search_results') {
                            item = freesat.behind.resultsHolders[freesat.behind.page].getChildren()[freesat.behind.row];
                        }

                        if (!item || !item.opts || !item.opts.programObject) {
                            freesat.console.log('Couldn\'t find source item - can\'t record');
                            return;
                        } else if (item.opts.episodes > 1) {
                            freesat.console.log('Can\'t cancel the recording of a group of results');
                            return;
                        }

                        lookupOipfProgram(item.opts.programObject, function(oipfProgram) {
                            if (!oipfProgram) {
                                // TODO: error notification
                                console.log('RECORDING ERROR - couldn\'t find event in EPG to be cancelled');
                                return;
                            }

                            var recHandler = freesat.masterController.recordingsHandler;
                            if (recHandler.removeRecording(oipfProgram) == recHandler.RECORDING_CHANGE_OK) {
                                item.setRecording(false);
                                freesat.header.metaIcons.setIcon('recording', freesat.header.programmeMetadataIconsContainer, false);
                            }
                        });
                        return true;
                }
            } else {
                switch (vKey) {
                    case accedo.VKey.KEY_0:
                    case accedo.VKey.KEY_1:
                    case accedo.VKey.KEY_2:
                    case accedo.VKey.KEY_3:
                    case accedo.VKey.KEY_4:
                    case accedo.VKey.KEY_5:
                    case accedo.VKey.KEY_6:
                    case accedo.VKey.KEY_7:
                    case accedo.VKey.KEY_8:
                    case accedo.VKey.KEY_9:
                        freesat.behind.textField.numberInput(vKey);
                        return true;
                    case accedo.VKey.KEY_UP:
                    case accedo.VKey.KEY_DOWN:
                    case accedo.VKey.KEY_LEFT:
                    case accedo.VKey.KEY_RIGHT:
                        // print pending T9 char on arrow key.
                        freesat.behind.textField.setCurrentT9Number(-1);
                        return false;
                    case accedo.VKey.KEY_BACK:
                        return freesat.behind.textField.backPress();
                }
            }
        },
        onLeftKey: function() {

            if (freesat.behind.currentFocus === 'search_results') {
                freesat.behind.row = 0;
                freesat.behind.unsetHeader();
                freesat.behind.get('searchKeyboard_0_4').setFocus();
                freesat.behind.currentFocus = 'keypad';
                freesat.footer.hide('green');
                return true;
            } else if (freesat.behind.currentFocus === 'group_menu') {
                freesat.behind.hideGroupResults();
            } else if (freesat.behind.currentFocus === 'group_results') {
                var groupMenu = freesat.behind.groupMenu,
                    programmeName = groupMenu.name,
                    channelName = groupMenu.channel,
                    programmeDate = groupMenu.date,
                    programmeDuration = groupMenu.duration,
                    programObject = groupMenu.programObject,
                    ontv = groupMenu.ontv.length,
                    ondemand = groupMenu.ondemand.length;

                freesat.behind.currentFocus = 'group_menu';
                freesat.behind.get('filter-' + freesat.behind.groupType).setFocus();

                if (freesat.behind.isIpAvailable()) {
                    freesat.header.setSearch(programmeName, channelName, programmeDate, programmeDuration, programObject, ontv, ondemand);
                } else {
                    freesat.header.setSearch(programmeName, channelName, programmeDate, '', programObject, ontv, null);
                }
            }
        },

        onRightKey: function() {
            var item;

            if (freesat.behind.currentFocus === 'group_menu' && freesat.behind.groupMenu[freesat.behind.groupType].length > 0) {
                item = (freesat.behind.groupPage * 6) + freesat.behind.groupRow;
                freesat.behind.get('group' + item).setFocus();
                freesat.behind.currentFocus = 'group_results';
            }
        },

        onUpKey: function() {
            if (freesat.behind.isAnimating) {
                return;
            }
            if (freesat.behind.currentFocus === 'group_results') {
                if (freesat.behind.groupRow === 0) {
                    if (freesat.behind.groupTopPositionIndex > 0) {
                        freesat.behind.groupRow = 5;
                        freesat.behind.tapGroupPageUp = true;
                        this.onGroupPageUp();
                    }
                } else {
                    freesat.behind.groupRow -= 1;
                    freesat.behind.groupHolders[freesat.behind.groupPage].getChildren()[freesat.behind.groupRow].setFocus();
                }
            } else if (freesat.behind.currentFocus === 'search_results') {
                if (freesat.behind.row === 0) {

                    if (freesat.behind.topPositionIndex > 0) {
                        freesat.behind.row = 5;
                        freesat.behind.tapPageUp = true;
                        this.onPageUp();
                        return;
                    } else {
                        freesat.behind.row = 0;
                    }
                } else {
                    freesat.behind.row -= 1;
                }
                freesat.behind.resultsHolders[freesat.behind.page].getChildren()[freesat.behind.row].setFocus();
            } else if (freesat.behind.currentFocus === 'filter_menu') {
                this.onFilterNavigate('up');
            } else if (freesat.behind.currentFocus === 'group_menu') {
                this.onGroupMenuNavigate();
            }
        },

        onDownKey: function() {
            if (freesat.behind.isAnimating) {
                return;
            }
            if (freesat.behind.currentFocus === 'group_results') {
                if (freesat.behind.groupRow === 5) {
                    freesat.behind.tapGroupPageDown = true;
                    this.onGroupPageDown();
                    return;
                } else if (freesat.behind.groupCurrentRows < 6) {
                    if (freesat.behind.groupRow < freesat.behind.groupCurrentRows - 1) {
                        freesat.behind.groupRow += 1;
                    }
                } else {
                    freesat.behind.groupRow += 1;
                }
                freesat.behind.groupHolders[freesat.behind.groupPage].getChildren()[freesat.behind.groupRow].setFocus();
            } else if (freesat.behind.currentFocus === 'search_results') {
                if (freesat.behind.row === 5) {
                    freesat.behind.tapPageDown = true;
                    this.onPageDown();
                    return;
                } else if (freesat.behind.currentRows < 6) {
                    if (freesat.behind.row < freesat.behind.currentRows - 1) {
                        freesat.behind.row += 1;
                    }
                } else {
                    freesat.behind.row += 1;
                }
                freesat.behind.resultsHolders[freesat.behind.page].getChildren()[freesat.behind.row].setFocus();
            } else if (freesat.behind.currentFocus === 'filter_menu') {
                this.onFilterNavigate('down');
            } else if (freesat.behind.currentFocus === 'group_menu') {
                this.onGroupMenuNavigate();
            }
        },

        onPageUp: function() {

            if (!freesat.behind.isAnimating && freesat.behind.canPageUp) {
                freesat.behind.page -= 1;
                freesat.behind.isAnimating = true;
                var newIndex = freesat.behind.topPositionIndex - 6;

                if (newIndex < 0) {
                    freesat.behind.topPositionIndex = 0;
                } else {
                    freesat.behind.topPositionIndex = newIndex;
                }
                freesat.behind.get('resultsContainer').addClass('off-top');
                freesat.behind.populateSearchResults(false, true);
                setTimeout(function() {
                    document.getElementById('resultsContainer').addEventListener('webkitTransitionEnd', freesat.behind.onTransitionEnd);
                    freesat.behind.get('resultsContainer').addClass('transition-vertical');
                    freesat.behind.get('resultsContainer').removeClass('off-top');
                },25);
                freesat.behind.resultsHolders[freesat.behind.page].getChildren()[freesat.behind.row].setFocus();
            }

        },

        onPageDown: function() {

            if (!freesat.behind.isAnimating && freesat.behind.canPageDown) {
                freesat.behind.isPageDown = true;
                freesat.behind.page += 1;
                freesat.behind.isAnimating = true;
                var newIndex = freesat.behind.topPositionIndex + 6,
                    rowIndex;

                if (!freesat.behind.tapPageDown) {

                    if ((freesat.behind.row+7) > freesat.behind.numOfRows) {
                        rowIndex = freesat.behind.numOfRows;
                        freesat.behind.row = rowIndex-6;
                    } else {
                        rowIndex = (freesat.behind.row+6);
                    }
                    // freesat.behind.get('result' + (freesat.behind.page * 6 + rowIndex)).setFocus();
                } else {
                    freesat.behind.row = 0;
                }

                if (freesat.behind.resultsHolders[freesat.behind.page].getChildren().length <= freesat.behind.row) {
                    freesat.behind.row = freesat.behind.resultsHolders[freesat.behind.page].getChildren().length - 1;
                }
                freesat.behind.resultsHolders[freesat.behind.page].getChildren()[freesat.behind.row].setFocus();

                if (newIndex < freesat.behind.results.length) {
                    freesat.behind.topPositionIndex = newIndex;
                } else {
                    freesat.behind.topPositionIndex = newIndex - freesat.behind.results.length;
                }

                freesat.behind.updateResultsLabel();

                document.getElementById('resultsContainer').addEventListener('webkitTransitionEnd', freesat.behind.onTransitionEnd);
                freesat.behind.get('resultsContainer').addClass('off-top transition-vertical');
            }
        },

        onGroupPageUp: function() {

            if (!freesat.behind.isAnimating && freesat.behind.canGroupPageUp) {
                freesat.behind.groupPage -= 1;
                freesat.behind.isAnimating = true;
                var newIndex = freesat.behind.groupTopPositionIndex - 6;

                if (newIndex < 0) {
                    freesat.behind.groupTopPositionIndex = 0;
                } else {
                    freesat.behind.groupTopPositionIndex = newIndex;
                }
                freesat.behind.get('groupContainer').addClass('off-top');
                freesat.behind.populateGroupResults(false, true);
                setTimeout(function() {
                    document.getElementById('groupContainer').addEventListener('webkitTransitionEnd', freesat.behind.onGroupTransitionEnd);
                    freesat.behind.get('groupContainer').addClass('transition-vertical');
                    freesat.behind.get('groupContainer').removeClass('off-top');
                },25);
                freesat.behind.groupHolders[freesat.behind.groupPage].getChildren()[freesat.behind.groupRow].setFocus();
            }
        },

        onGroupPageDown: function() {
            if (!freesat.behind.isAnimating && freesat.behind.canGroupPageDown) {
                freesat.behind.isGroupPageDown = true;
                freesat.behind.groupPage += 1;
                freesat.behind.isAnimating = true;
                var newIndex = freesat.behind.groupTopPositionIndex + 6,
                    rowIndex;

                if (!freesat.behind.tapGroupPageDown) {

                    if ((freesat.behind.groupRow + 7) > freesat.behind.groupNumOfRows) {
                        rowIndex = freesat.behind.groupNumOfRows;
                        freesat.behind.groupRow = rowIndex-6;
                    } else {
                        rowIndex = (freesat.behind.groupRow+6);
                    }
                } else {
                    freesat.behind.groupRow = 0;
                }
                if (freesat.behind.groupHolders[freesat.behind.groupPage].getChildren().length <= freesat.behind.groupRow) {
                    freesat.behind.groupRow = freesat.behind.groupHolders[freesat.behind.groupPage].getChildren().length - 1;
                }
                freesat.behind.groupHolders[freesat.behind.groupPage].getChildren()[freesat.behind.groupRow].setFocus();

                if (newIndex < freesat.behind.group.length) {
                    freesat.behind.groupTopPositionIndex = newIndex;
                } else {
                    freesat.behind.groupTopPositionIndex = newIndex - freesat.behind.group.length;
                }

                freesat.behind.updateResultsLabel();
                document.getElementById('groupContainer').addEventListener('webkitTransitionEnd', freesat.behind.onGroupTransitionEnd);
                freesat.behind.get('groupContainer').addClass('off-top transition-vertical');
            }
        },

        onGreenKey: function() {

            if (freesat.behind.currentFocus === 'search_results' || freesat.behind.currentFocus === 'filter_menu') {
                freesat.behind.toggleFilterMenu();
            }
        },

        onFilterNavigate: function(dir) {

            if (dir === 'up') {
                freesat.behind.filter_order.unshift(freesat.behind.filter_order.pop());
            } else {
                freesat.behind.filter_order.push(freesat.behind.filter_order.shift());
            }
            freesat.behind.orderFilterMenu();
        },

        onGroupMenuNavigate: function() {
            var current = freesat.behind.groupType,
                prefix = 'filter-',
                next;

            if (current === 'ontv') {
                next = 'ondemand';
                freesat.behind.get('search-filter-container').removeClass('ontv');

            } else {
                next = 'ontv';
                freesat.behind.get('search-filter-container').addClass('ontv');
            }
            freesat.behind.groupType = next;
            freesat.behind.create.groupResults(freesat.behind.groupMenu[next], (next === 'ontv'));
            freesat.behind.get(prefix + next).setFocus();
        }
    }
);
/**
 * @name Search
 * @namespace
 * @memberOf freesat.controllers
 * @class
 */
accedo.Class.create("freesat.controllers.Search", "accedo.ui.Controller", ["freesat.view.Search", "freesat.controllers.search.KeyHandler", "freesat.controllers.search.Create"], {}, {

    // Search term
    searchTerm: null,
    activeSearch: false,

    // Has existing results flag
    hasResults: false,
    hasGroupResults: false,
    useFilterResults: false,
    hasFilterMenu: false,
    filterMenuIsVisible: false,

    // Show selected flag
    /**
     * @ignore
     * @property {string} currentFocus available options:
     * 'keypad'
     * 'search_results'
     * 'group_results'
     * 'filter_menu'
     */
    currentFocus: null,

    tapPageUp: false,
    tapPageDown: false,
    canPageDown: false,
    canPageUp: false,
    tapGroupPageUp: false,
    tapGroupPageDown: false,
    canGroupPageDown: false,
    canGroupPageUp: false,
    isAnimating: false,
    isPageDown: false,
    isGroupPageDown: false,

    create: null,

    // Results array
    results: [],

    // Group array
    group: [],

    // Filter array - temp array filtered from results array
    filter: [],

    selected_type: 0,
    // Filter menu array
    filter_menu: [],
    // Filter types array
    filter_types: [],
    // Array of filter type indexes to order menu
    filter_order: [],

    MAX_DISPLAY_ITEMS: 6,
    MAX_PAGE_ITEMS: 13,

    handledSearchTerm: '',

    lang: {},

    initialize: function($super) {
        $super();
        freesat.oipfElement.setKeysetWithNumbers();
        freesat.console.log('[Search Controller] initialize');
        this.setView(freesat.view.Search);
    },
    setup: function() {
        freesat.behind = this;
        var lang = new freesat.language.SearchEn();
        this.get('search-disconnected').addClass('hidden');
        this.get('straplineTitle').setText(lang.STRAPLINE_TITLE);
        this.get('searchInstructionsHeadline').setText(lang.INSTRUCTIONS_HEADER);
        this.get('searchInstructions').setText(lang.INSTRUCTIONS);
        this.get('straplineResultsTitle').setText(lang.SEARCH_RESULTS);

        freesat.clearBackCookie('section');

        this.lang = lang;

        this.get('filterSelectionTypes').setText(lang.SELECT_RESULT_TYPES);

        lang = new freesat.language.FiltersEn();

        // Add default All results
        this.filter_menu = [lang.ALL_RESULTS];

        this.dataInterface = freesat.dataStore.getInterface();

        this.create = new freesat.controllers.search.Create();

        this.textField = this.get("searchInput");
        this.keyboard = this.get("searchKeyboard");
        this.keyboard.setTextField(this.textField);
        this.keyboard.opts.nextRight = function () {
            if (freesat.behind.hasResults) {
                freesat.behind.row = 0;
                freesat.behind.resultsHolders[freesat.behind.page].getChildren()[0].setFocus();
            }
        };
        this.landingPage = this.get("searchLandingPage");
        this.resultsPage = this.get("searchResultsPage");
        this.searchPage = this.get("search");
        this.searchResultsCount = this.get('searchResultsCount');
        this.groupResultsCount = this.get('groupResultsCount');
        this.searchResults = this.get("searchResults");
        this.resultsHolder = null;

        this.textField.addEventListener(accedo.ui.Evt.TEXT_CHANGED, function() {
            this.handleSearchEntry();
        }, this);

        this.textField.startInput();

        this.searchResults.addEventListener(accedo.ui.Evt.CHILD_FOCUS, function() {
            this.handleResultsFocus();
        }, this);

        this.get('search-filter-buttons').addEventListener(accedo.ui.Evt.CHILD_FOCUS, function() {
            this.handleMenuFocus();
        }, this);

        //TODO if this unconnected state never exists remove commented code
//        if(freesat.ipavailable){
        this.get('search-disconnected').addClass('hidden');
//        }else{
//            this.get('footer').addClass('hidden');
//            this.get('search-connectionretrybutton').setFocus();
//        }

        // Highlight first letter on the keyboard
        this.currentFocus = 'keypad';
        this.get("searchKeyboard_0_0").setFocus();

        trace("Browser load to Focus on screen");

        freesat.am.screenView('/search');

        setTimeout(function () {
            freesat.marketingOptIn.showDialogIfRequired();
            freesat.loadRemainingSections();
        }, 200);
    },
    isIpAvailable: function() {
        if (freesat.ipavailable && (window.localStorage.getItem('FORCE_DSMCC') === 'true')) {
            freesat.console.log('WARNING - setting IP to unavailable because FORCE_DSMCC is true');
            return false;
        }

        if (freesat.behind.ipFailed) {
            return false;
        }

        return freesat.ipavailable;
    },
    setHeader: function(button) {
        if (freesat.behind.headerTimeout) clearTimeout(freesat.behind.headerTimeout);
        freesat.behind.headerTimeout = setTimeout(function () {
            if (button.opts.episodes > 1) {
                if (freesat.behind.isIpAvailable()) {
                    freesat.header.setSearch(button.opts.name, button.opts.channel, button.opts.date, '', button.opts.programObject, button.opts.ontv.length, button.opts.ondemand.length);
                } else {
                    freesat.header.setSearch(button.opts.name, button.opts.channel, button.opts.date, '', button.opts.programObject, button.opts.episodes, null);
                }
            } else {
                freesat.header.setSearchEpisode(button.opts.name, button.opts.channel, button.opts.programObject.description, button.opts.date, button.opts.duration, button.opts.programObject);
            }
        }, 150);
    },
    unsetHeader: function() {
        freesat.header.unsetSearch();
    },
    handleResultsFocus: function() {
        if (freesat.behind.currentFocus !== 'search_results') {
            freesat.behind.currentFocus = 'search_results';

            if(freesat.behind.filter_menu.length>1){
                freesat.footer.show('green');
            }
        }
    },
    handleItemSelection: function(vKey) {

        if (vKey === accedo.VKey.KEY_OK) {

            if (this.opts.episodes > 1) {
                var group, ontv;

                freesat.behind.groupMenu = {
                    name: this.opts.name,
                    channel: this.opts.channel,
                    date: this.opts.date,
                    duration: this.opts.duration,
                    ontv: this.opts.ontv,
                    ondemand: this.opts.ondemand,
                    programObject: this.opts.programObject
                };

                if (this.opts.ontv.length > 0) {
                    group = this.opts.ontv;
                    ontv = true;
                } else {
                    group = this.opts.ondemand;
                    ontv = false;
                }
                freesat.behind.create.groupResults(group, ontv);
            } else { // show action menu

                freesat.setBackFocus(accedo.ui.FocusManager.singleton().getCurrentFocus());
                var timeZoneVar = 'search',
                    left, top;
                this.addClass('disable');
                freesat.actionData = new freesat.models.vo.MenuObject();
                freesat.actionData.timeZone = timeZoneVar;
                freesat.actionData.backFocus = this;

                // This is specifying the top/left/height/width of your button relative to the top left of the screen
                // Adding the negative margined image offsetLeft value

                if (freesat.behind.currentFocus === 'group_results') { // Group result items
                    // groupListMask + groupPage + logo image offsetLeft
                    left = this.parent.parent.parent.root._dom.offsetLeft + this.parent.parent.parent.parent.root._dom.offsetLeft + Math.abs(this._children[0].root._dom.offsetLeft);
                    // this + groupListMask + groupResults
                    top = this.root._dom.offsetTop + this.parent.parent.parent.root._dom.offsetTop + this.parent.parent.parent.parent.parent.root._dom.offsetTop;
                } else if (freesat.behind.currentFocus === 'search_results') { // Search result items
                    // searchResults + logo image offsetLeft
                    left = this.parent.parent.parent.root._dom.offsetLeft + Math.abs(this._children[0].root._dom.offsetLeft);
                    // this + searchResults
                    top = this.root._dom.offsetTop + this.parent.parent.parent.root._dom.offsetTop;
                }
                freesat.actionData.left = left;
                freesat.actionData.top = top;
                freesat.actionData.width = this.root._dom.offsetWidth;
                freesat.actionData.height = this.root._dom.offsetHeight - 4; // Minus the 4 px margin
                freesat.actionData.hasMask = true;
                freesat.actionData.location = 'freesat.controllers.Search';
                freesat.actionData.search = true;
                freesat.actionData.programObject = this.opts.programObject;

                freesat.masterController.showLoading();
                freesat.dataStore.getInterface().searchProgrammes(
                    freesat.actionData.programObject.channelID,
                    freesat.actionData.programObject.startTime,
                    null,
                    1,
                    function(results) {
                        freesat.masterController.hideLoading();
                        var result = null;
                        if (!results || results.length === 0) {
                            freesat.console.log('WARNING - EPG search failed: won\'t be able to show recording/reminder options');
                        } else {
                            freesat.actionData.programObject.oipfProgramme = results[0];
                        }
                        freesat.masterController.instanciateSelectionMenu();
                    });
            }
        } else if (vKey === accedo.VKey.KEY_INFO || vKey === accedo.VKey.KEY_I || vKey === accedo.VKey.KEY_I_LOWER) {
            if (!this.opts.episodes || this.opts.episodes === 1) {
                freesat.actionData = new freesat.models.vo.MenuObject();
                freesat.actionData.timeZone = 'search';
                freesat.actionData.backFocus = this;
                freesat.setBackFocus(accedo.ui.FocusManager.singleton().getCurrentFocus());
                freesat.actionData.location = 'Search';
                freesat.actionData.search = true;
                freesat.actionData.programObject = this.opts.programObject;
                freesat.masterController.instanciateAbout();
            }
        }
    },
    /**
     * Get date and time info
     * @param {number} seconds
     * @memberOf freesat.controllers.Search
     * @returns {object} Date represented as a date ('string') and time ('time')
     */
    getDateAndTime: function(seconds, duration) {
        var _date = new Date(seconds * 1000),
            _endDate = new Date((seconds + duration) * 1000),
            dateArr = _date.toString().split(' '),
            day = dateArr[0],
            month = dateArr[1],
            dd = dateArr[2],
            time = dateArr[4].substr(0, 5),
            dateObj = {},
            nowDate = new Date()
            ;

        if (_date.getYear() === nowDate.getYear() &&
            _date.getMonth() === nowDate.getMonth() &&
            _date.getDay() === nowDate.getDay()){

            if ((_date.getTime() < nowDate.getTime()) && (nowDate.getTime() < _endDate.getTime())) {
                dateObj.string = this.lang.ON_NOW;
            } else {
                dateObj.string = this.lang.TODAY + " " + ' <span class="time">' + time + '</span>';
            }

        } else {
            dateObj.string = day + ' ' + dd + ' ' + month + ' ' + time;
        }

        dateObj.time = time;
        return dateObj;
    },
    formatDuration: function(seconds) {
        var minutes = seconds / 60,
            hours = 0,
            text = '';

        if (minutes > 60) {
            hours = Math.floor(minutes / 60);
            text += hours + ' hr ';
            minutes = (minutes - (hours * 60));
        }

        if (minutes !== 0) {
            text += minutes + ' min';
        }

        return text;
    },
    stripPunctuation: function(txt) {
        return txt.replace(/[\.,-\/#!$%\^&\*;:{}=\-_`~()]/g,"").replace(/\s{2,}/g," ");
    },

    stripWhitespace: function(txt) {
        return txt.replace(/[\.,-\/#!$%\^&\*;:{}=\-_`~()]/g,"").replace(/\s/g,"");
    },
    /**
     * @param {string} txt - text
     * @param {string} term - search term for string replace function using regular expression
     * @memberOf freesat.controllers.Search
     * @returns A string with <em> tags surrounding the highlighted search term
     */
    highlight: function(txt, term) {
        return txt.replace(new RegExp("(" + term + ")", "gi"), "<em>$1</em>");
    },
    /**
     * Removes preceding 'The ' or 'A ' from the start of a text string
     * @param {string} txt - text
     * @param {string} term - search term for string search function using regular expression
     * @memberOf freesat.controllers.Search
     * @todo - don't perform the name replace if the search term doesn't start with 'The' or 'A '
     * @returns {Number} to determine the first occurrence in a string of a particular search term
     */
    searchTermPos: function(txt, term) {
        var name = txt.replace(new RegExp("^(The |A )", "gi"), "");
        return name.search(new RegExp("(" + term + ")", "gi"));
    },

    remove: function(el) {
        el.detach();
    },

    deleteSearchResults: function() {
        freesat.behind.resultsHolder.detach();
    },

    searchResultsCallback: function() {

        freesat.behind.populateSearchResults(false, true);
        freesat.masterController.hideLoading();
    },

    getAvailabilityText: function(data){
        var text = data.availabilityText,
            dateObj,
            ontvLen = data.ontv.length,
            nextProgTime,
            nextProgDuration;

        if (data.ondemand && data.ondemand.length > 0){
            text = data.ondemand[0].availabilityText;
        }

        for (var i = 0; i < ontvLen; i++){
            if (!nextProgTime || data.ontv[i].startTime < nextProgTime){
                nextProgTime = data.ontv[i].startTime;
                nextProgDuration = data.ontv[i].duration;
            }
        }

        if (nextProgTime){
            dateObj = this.getDateAndTime(nextProgTime, nextProgDuration);
            text = dateObj.string;
        }

        return text;
    },

    populateSearchResults: function(overwrite, noLoader) {
        var indexAdjust = freesat.behind.topPositionIndex,
            results,
            results_css = 'results-list',
            lastBlock = 0,
            _maxLines, i, showing, label, len;

        if (freesat.behind.useFilterResults) {
            results = freesat.behind.filter;
        } else {
            results = freesat.behind.results;
        }

        freesat.behind.hasResults = results.length > 0;
        freesat.behind.resultsLength = results.length;

        if (overwrite && freesat.behind.resultsHolder) {
            freesat.behind.remove(freesat.behind.resultsHolder);
            delete freesat.behind.resultsHolder;

            if (freesat.behind.resultsHolders) {
                delete freesat.behind.resultsHolders;
            }
        }
        if (!freesat.behind.resultsHolder) {
            freesat.behind.resultsHolder = new accedo.ui.Container({
                id: '#resultsContainer',
                css: results_css
            });
            freesat.behind.searchResults.attach(freesat.behind.resultsHolder);
        }

        if (!freesat.behind.resultsHolders) {
            freesat.behind.resultsHolders = [];
        }
        if (freesat.behind.resultsHolders.length > 0) {
            lastBlock = freesat.behind.resultsHolders[freesat.behind.resultsHolders.length - 1].opts.topIndex;
        } else {
            freesat.behind.resultsHolders.push(new accedo.ui.Container({
                css: results_css,
                topIndex: 0,
                empty: true
            }));
        }
        while (results.length - 1 >= lastBlock + 6 &&
        (freesat.behind.topPositionIndex + 6 > lastBlock || lastBlock <= 6)) { // if the last visible item is > last block's first item
            lastBlock += 6;
            freesat.behind.resultsHolders.push(new accedo.ui.Container({
                css: results_css,
                topIndex: lastBlock,
                empty: true
            }));
            if (!freesat.masterController.loadingIcon.isShowing() && !noLoader) {
                freesat.masterController.showLoading();
                setTimeout(freesat.behind.searchResultsCallback, 100);
                return;
            }
        }
        len = freesat.behind.resultsHolders.length;

        var ipAvailable = this.isIpAvailable();
        for (i = 0; i < len; i++) {
            if (freesat.behind.resultsHolders[i].opts.empty) {
                _maxLines = Math.min(results.length, freesat.behind.resultsHolders[i].opts.topIndex + 6);
                for (var j = freesat.behind.resultsHolders[i].opts.topIndex; j < _maxLines; j++) {
                    var index = i + indexAdjust,
                        result = results[j],
                        programme = result.highlighted,
                        count = '',
                        dateAndTime = ipAvailable ? this.getAvailabilityText(result) : result.date.string,
                        channel = freesat.channelData.channelList.getChannel(result.programObject.channelID),
                        label = (channel) ? channel.name : '',
                        icon = '',
                        hasRecording = freesat.masterController.recordingsHandler.isRecordingScheduled(
                                                result.programObject.channelID,
                                                result.programObject.startTime),
                        hasReminder = freesat.masterController.remindersHandler.isReminderScheduled(
                                                result.programObject.channelID,
                                                result.programObject.startTime);
                    if (result.count > 1) {
                        count += result.count + ' Results';
                    }

                    if (hasRecording) {
                        icon = 'images/1280x720/icon/icon_rec.png'; 
                    } else if (hasReminder) {
                        icon = 'images/1280x720/icon/icon_reminder.png';
                    }

                    freesat.behind.resultsHolders[i].attach(freesat.behind.create.searchResultItem({
                        index: j - freesat.behind.resultsHolders[i].opts.topIndex,
                        resultIndex: j,
                        src: result.logo || {label: label},
                        focusedsrc: result.logo_highlight || freesat.channelData.getChannelLogo(result.channel.freesatServiceID, true),
                        leftLabel: programme,
                        middleLabel: count,
                        middleIcon: icon,
                        rightLabel: dateAndTime,
                        name: result.name,
                        channel: result.channel,
                        date: result.date.string,
                        duration: freesat.behind.formatDuration(result.duration),
                        episodes: ipAvailable ? result.count : result.events.length,
                        programObject: result.programObject,
                        events: result.events,
                        ontv: ipAvailable ? result.ontv : result.events,
                        ondemand: ipAvailable ? result.ondemand : []
                    }));
                }
            }
        }

        if (results.length > freesat.behind.topPositionIndex + freesat.behind.MAX_DISPLAY_ITEMS) {
            showing = freesat.behind.MAX_DISPLAY_ITEMS;
            freesat.behind.canPageDown = true;
        } else {
            _maxLines = results.length - freesat.behind.topPositionIndex;
            showing = _maxLines;
            freesat.behind.canPageDown = false;
        }

        if (freesat.behind.topPositionIndex > 0) {
            freesat.behind.canPageUp = true;
        } else {
            freesat.behind.canPageUp = false;
        }

        freesat.behind.currentRows = Math.min(freesat.behind.MAX_DISPLAY_ITEMS, results.length - freesat.behind.topPositionIndex);

        label = freesat.behind.create.resultsLabel(freesat.behind.page, showing, results.length);
        freesat.behind.searchResultsCount.setText(label);
        var second = false;
        len = freesat.behind.resultsHolders.length;
        for (i = 0; i < len; i++) {
            if (freesat.behind.resultsHolders[i].opts.empty) {
                freesat.behind.resultsHolders[i].opts.empty = false;
                freesat.behind.resultsHolder.attach(freesat.behind.resultsHolders[i]);
            }
            if (freesat.behind.resultsHolders[i].opts.topIndex >= freesat.behind.topPositionIndex &&
                freesat.behind.resultsHolders[i].opts.topIndex <= freesat.behind.topPositionIndex + 6) {
                if (second) {
                    freesat.behind.resultsHolders[i].addClass("second-page");
                } else {
                    freesat.behind.resultsHolders[i].removeClass("second-page");
                }
                second = true;
                freesat.behind.resultsHolders[i].show();
            } else {
                freesat.behind.resultsHolders[i].hide();
            }
        }

        if (freesat.behind.canPageDown || freesat.behind.canPageUp) {
            freesat.footer.show('paging');
        } else {
            freesat.footer.hide('paging');
        }
    },

    hideGroupResults: function() {
        freesat.behind.get('groupResults').addClass('hidden');
        freesat.behind.group = [];
        freesat.behind.tapGroupPageUp = freesat.behind.tapGroupPageDown = freesat.behind.canGroupPageDown = freesat.behind.canGroupPageUp = false;

        // Show hide footer buttons
        if (freesat.behind.canPageUp || freesat.behind.canPageDown) {
            freesat.footer.show('paging');
        } else {
            freesat.footer.hide('paging');
        }
        freesat.footer.show('green');

        freesat.behind.resultsHolders[freesat.behind.page].getChildren()[freesat.behind.row].setFocus();
        freesat.behind.currentFocus = 'search_results';
        freesat.behind.populateSearchResults(false, true);
    },

    groupResultsCallback: function(onload) {
        freesat.behind.populateGroupResults(false, true, onload);
        freesat.masterController.hideLoading();
    },

    populateGroupResults: function(overwrite, noLoader, onload) {
        var indexAdjust = freesat.behind.groupTopPositionIndex,
            episodes = freesat.behind.group,
            results_css = 'group-list',
            lastBlock = 0,
            _maxLines, i, showing, label;

        if (overwrite && freesat.behind.groupHolder && freesat.behind.groupHolders) {
            freesat.behind.remove(freesat.behind.groupHolder);
            delete freesat.behind.groupHolder;
            delete freesat.behind.groupHolders;
        }

        if (freesat.behind.groupType === 'ondemand') {
            results_css += ' ondemand-items';
        }

        if (!freesat.behind.groupHolder) {
            freesat.behind.groupHolder = new accedo.ui.Container({
                id: '#groupContainer',
                css: results_css
            });
            freesat.behind.searchResults.attach(freesat.behind.resultsHolder);
        }

        if (!freesat.behind.groupHolders) {
            freesat.behind.groupHolders = [];
        }
        if (freesat.behind.groupHolders.length > 0) {
            lastBlock = freesat.behind.groupHolders[freesat.behind.groupHolders.length - 1].opts.topIndex;
        } else {
            freesat.behind.groupHolders.push(new accedo.ui.Container({
                css: results_css,
                topIndex: 0,
                empty: true
            }));
        }
        while (episodes.length - 1 >= lastBlock + 6 && (freesat.behind.groupTopPositionIndex + 6 > lastBlock || lastBlock <= 6)) { // if the last visible item is > last block's first item
            lastBlock += 6;
            freesat.behind.groupHolders.push(new accedo.ui.Container({
                css: results_css,
                topIndex: lastBlock,
                empty: true
            }));
            if (!freesat.masterController.loadingIcon.isShowing() && !noLoader) {
                freesat.masterController.showLoading();
                setTimeout(function() {
                    freesat.behind.groupResultsCallback(onload)
                }, 100);
                return;
            }
        }


        for (i = 0; i < freesat.behind.groupHolders.length; i++) {
            if (freesat.behind.groupHolders[i].opts.empty) {
                _maxLines = Math.min(episodes.length, freesat.behind.groupHolders[i].opts.topIndex + 6);
                for (var j = freesat.behind.groupHolders[i].opts.topIndex; j < _maxLines; j++) {


                    var index = i + indexAdjust,
                        episode = episodes[j],
                        dateAndTime = freesat.behind.getDateAndTime(episode.startTime, episode.duration),
                        dateAndTimeLabel,
                        channel = freesat.channelData.channelList.getChannel(episode.channelID),
                        channel_name = '',
                        channel_logo = '',
                        focused_logo = '',
                        icon = '',
                        hasRecording = freesat.masterController.recordingsHandler.isRecordingScheduled(
                                            episode.channelID,
                                            episode.startTime),
                        hasReminder = freesat.masterController.remindersHandler.isReminderScheduled(
                                            episode.channelID,
                                            episode.startTime);

                    dateAndTimeLabel = dateAndTime.string;

                    if (channel) {
                        channel_logo = freesat.channelData.getChannelLogo(channel.freesatServiceID, false) || {label: channel.name};
                        focused_logo = freesat.channelData.getChannelLogo(channel.freesatServiceID, true);
                        channel_name = channel.name;
                    }

                    if (hasRecording) {
                        icon = 'images/1280x720/icon/icon_rec.png'; 
                    } else if (hasReminder) {
                        icon = 'images/1280x720/icon/icon_reminder.png';
                    }

                    freesat.behind.groupHolders[i].attach(freesat.behind.create.groupItem({
                        index: j,
                        resultIndex: index,
                        src: channel_logo,
                        focusedsrc: focused_logo,
                        leftLabel: episode.name,
                        middleIcon: icon,
                        rightLabel: dateAndTimeLabel,
                        name: episode.name,
                        channel: channel_name,
                        date: dateAndTime.string,
                        duration: freesat.behind.formatDuration(episode.duration),
                        programObject: episode,
                        ondemand: episode.ondemand
                    }));
                }
            }
        }

        if (episodes.length > freesat.behind.groupTopPositionIndex + freesat.behind.MAX_DISPLAY_ITEMS) {
            showing = freesat.behind.MAX_DISPLAY_ITEMS;
            freesat.behind.canGroupPageDown = true;
        } else {
            _maxLines = episodes.length - freesat.behind.groupTopPositionIndex;
            showing = _maxLines;
            freesat.behind.canGroupPageDown = false;
        }

        if (freesat.behind.groupTopPositionIndex > 0) {
            freesat.behind.canGroupPageUp = true;
        } else {
            freesat.behind.canGroupPageUp = false;
        }

        freesat.behind.groupCurrentRows = Math.min(freesat.behind.MAX_DISPLAY_ITEMS, episodes.length - freesat.behind.groupTopPositionIndex);

        label = freesat.behind.create.resultsLabel(freesat.behind.groupPage, showing, episodes.length);
        freesat.behind.searchResultsCount.setText(label);
        var second = false;
        for (i = 0; i < freesat.behind.groupHolders.length; i++) {
            if (freesat.behind.groupHolders[i].opts.empty) {
                freesat.behind.groupHolders[i].opts.empty = false;
                freesat.behind.groupHolder.attach(freesat.behind.groupHolders[i]);
            }
            if (freesat.behind.groupHolders[i].opts.topIndex >= freesat.behind.groupTopPositionIndex &&
                freesat.behind.groupHolders[i].opts.topIndex <= freesat.behind.groupTopPositionIndex + 6) {

                if (second) {
                    freesat.behind.groupHolders[i].addClass("second-page");
                } else {
                    freesat.behind.groupHolders[i].removeClass("second-page");
                }
                second = true;
                freesat.behind.groupHolders[i].show();
            } else {
                freesat.behind.groupHolders[i].hide();
            }
        }

        label = freesat.behind.create.resultsLabel(freesat.behind.groupPage, showing, episodes.length);
        freesat.behind.groupResultsCount.setText(label);
        freesat.behind.get('groupListMask').attach(freesat.behind.groupHolder);

        if (freesat.behind.canGroupPageDown || freesat.behind.canGroupPageUp) {
            freesat.footer.show('paging');
        } else {
            freesat.footer.hide('paging');
        }
        freesat.footer.hide('green');

        if (!onload) {
            freesat.behind.groupHolders[freesat.behind.groupPage].getChildren()[freesat.behind.groupRow].setFocus();
        }
    },

    updateResultsLabel: function () {
        var len,
            label;
        if (freesat.behind.currentFocus === 'group_results') {
            len = freesat.behind.group.length;
            label = freesat.behind.create.resultsLabel(
                freesat.behind.groupPage,
                Math.min(len - freesat.behind.groupTopPositionIndex, freesat.behind.MAX_DISPLAY_ITEMS),
                len
            );
            freesat.behind.groupResultsCount.setText(label);
        } else {
            if (freesat.behind.useFilterResults) {
                len = freesat.behind.filter.length;
            } else {
                len = freesat.behind.results.length;
            }
            label = freesat.behind.create.resultsLabel(
                freesat.behind.page,
                Math.min(len - freesat.behind.topPositionIndex, freesat.behind.MAX_DISPLAY_ITEMS),
                len
            );
            freesat.behind.searchResultsCount.setText(label);
        }
    },

    toggleFilterMenu: function() {
        if (freesat.behind.currentFocus === 'filter_menu') { // hide
            freesat.behind.searchPage.removeClass('show-filter');
            freesat.behind.currentFocus = 'search_results';
            freesat.behind.get('result' + freesat.behind.row).setFocus();
            freesat.behind.filterMenuIsVisible = false;
        } else { // show
            freesat.behind.searchPage.addClass('show-filter');
            freesat.behind.currentFocus = 'filter_menu';
            freesat.behind.get('filter' + freesat.behind.selected_type).setFocus();
            freesat.behind.filterMenuIsVisible = true;
        }
    },

    populateFilterType: function(searchObject) {
        var type = searchObject.type,
            len = type.length,
            index,
            i;

        // Check genre against existing types
        if (len > 0) {

            for (i = 0; i < len; i++) {
                index = freesat.behind.filter_types.indexOf(type[i]);

                if (index === -1) {
                    freesat.behind.filter_types.push(type[i]);
                }
            }
        }
    },

    filterResults: function(vKey) {

        if (vKey === accedo.VKey.KEY_OK) {
            var selected = freesat.behind.filter_menu[freesat.behind.selected_type],
                len = freesat.behind.results.length,
                searchObject,
                i;

            if (freesat.behind.selected_type !== 0) { // Filter results if hasn't selected All results
                // Empty filter array
                freesat.behind.filter = [];

                for (i = 0; i < len; i++) {
                    searchObject = freesat.behind.results[i];

                    if (searchObject.type.indexOf(selected) !== -1) {
                        freesat.behind.filter.push(searchObject);
                    }
                }
                freesat.behind.useFilterResults = true;
            } else {
                freesat.behind.useFilterResults = false;
            }


            freesat.behind.page = freesat.behind.topPositionIndex = freesat.behind.currentRows = freesat.behind.row = 0;

            freesat.behind.populateSearchResults(true, true);
            freesat.behind.toggleFilterMenu();
            freesat.behind.currentFocus = 'search_results';
            freesat.behind.get('result0').setFocus();

        }
    },

    orderFilterMenu: function() {
        var arr = freesat.behind.filter_order,
            len = arr.length,
            height,
            i, y = 0;

        for (i = 0; i < len; i++) {
            var filterItem = freesat.behind.get('filter' + freesat.behind.filter_order[i]);

            if (i === 0) {
                height = 0;
            } else if (i === 1) {
                height = 50;
            } else {
                height = 40;
            }
            y = y + height;
            filterItem.root.setStyle({
                top: y + 'px'
            });
        }
        freesat.behind.selected_type = freesat.behind.filter_order[0];
        freesat.behind.get('filter' + freesat.behind.selected_type).setFocus();
    },

    setSearchObject: function(programme, pos) {
        var searchObject,
            name,
            channel,
            lcn,
            startTime,
            genre,
            genreLength,
            i;

        try {
            searchObject = new freesat.models.vo.Search();
            name = programme.name;
            channel = freesat.channelData.channelList.getChannel(programme.channelID);
            lcn = programme.channelID;
            startTime = programme.startTime;
            genre = programme.genre;
            genreLength = genre.length;

            searchObject.name = name;
            searchObject.highlighted = freesat.behind.highlight(name, freesat.behind.searchTerm);
            searchObject.startTime = startTime;
            searchObject.date = freesat.behind.getDateAndTime(startTime, programme.duration);
            searchObject.count = 1;
            searchObject.svcId = lcn;
            //        searchObject.evtId = programme.evtId;
            //        searchObject.seriesNo = programme.seriesNo;
            searchObject.episodeNo = programme.episodes;
            searchObject.duration = programme.duration;
            searchObject.searchPos = pos;
            if(channel){
                searchObject.logo = freesat.channelData.getChannelLogo(channel.freesatServiceID, false);
                searchObject.logo_highlight = freesat.channelData.getChannelLogo(channel.freesatServiceID, true);
                searchObject.channel = channel.name;
            }else{
                searchObject.channel = 'no data';
                searchObject.logo = '';
            }
            searchObject.type = [];

            if (genreLength > 0) {

                for (i = 0; i < genreLength; i++) {
                    searchObject.type.push(genre[i]);
                }
            }
        }catch(e){
            return null;
        }
        return searchObject;
    },
//    setProgramObject: function(event) {
//        var programObject = new freesat.models.vo.ProgramObject();
//
//        programObject.Name = event.name;
//        programObject.LongSynopsis = event.description;
//        programObject.genre[0] = event.genre;
//        programObject.DurationInSeconds = event.duration;
//        programObject.id = event.evtId;
//        programObject.ChannelId = event.svcId;
//        programObject.AvailabilityStart = event.startTime;
//        programObject.image = event.image || '';
//        programObject.HasTstv = event.hasTstv;
//        programObject.ChannelName = freesat.channelData.getChannelNameAndLogo(event.svcId).name;
//        programObject.ChannelLogo = freesat.channelData.getChannelNameAndLogo(event.svcId).logo;
//
//
//        return programObject;
//
//    },
    /**
     * Loops through the array of returned objects
     * Compares names to determine individual titles
     * Adds name to the titles array for use as comparison and index
     * Unmatched names are added as new object to results array
     * Matched names are added to their corresponding object in results array
     * The results array is sorted by the first occurrence of the search term and passed to:
     * this.createSearchResults()
     *
     * @param obj - JSON object returned from API
     * @memberOf freesat.controllers.Search
     */
    setSearchResults: function(programmes) {
        var titles = [],
            results = [],
            len = programmes.length,
            i;
        freesat.behind.activeSearch = false;

        if (len > 0) {
            // Reset filter menus
            freesat.behind.selected_type = 0;
            freesat.behind.filter_types = [];
            freesat.behind.filter_menu = [freesat.behind.filter_menu.shift()]; // Reset filter menu to just 'All results'

            if (freesat.behind.useFilterResults) { // Reset if filter is currently applied
                freesat.behind.useFilterResults = false;
            }

            for (i = 0; i < len; i++) {
                var programme = programmes[i],
                    name = programme.name,
                    searchTermPos = freesat.behind.searchTermPos(name, freesat.behind.searchTerm),
                    index = titles.indexOf(name),
                    programObject;
                if (index === -1 && searchTermPos !== -1) {
                    var searchObject = freesat.behind.setSearchObject(programme, searchTermPos);
                    if(searchObject){
                        programObject = programme;
                        titles.push(name);
                        searchObject.programObject = programObject;
                        searchObject.events = [programObject];
                        results.push(searchObject);
                        freesat.behind.populateFilterType(searchObject);
                    }
                } else if (searchTermPos !== -1) {
                    var resultObj = results[index];

                    programObject = programme;
                    resultObj.events.push(programObject);
                    resultObj.count++;

                    try{
                        if (programme.startTime < resultObj.startTime) {
                            resultObj = programObject;
                        }
                    }catch(e){

                    }
                }
            }

            results.sort(function(obj1, obj2) {
                return obj1.searchPos - obj2.searchPos;
            });

            freesat.behind.results = results;

            freesat.behind.create.searchResults();
            freesat.behind.filter_types.sort();
            freesat.behind.filter_menu = freesat.behind.filter_menu.concat(freesat.behind.filter_types);
            freesat.behind.create.filterMenu();
        } else {

            if (freesat.behind.resultsHolder) {
                freesat.behind.deleteSearchResults();
            }
            freesat.behind.create.noResults();
        }
    },

    parseIPSubItem: function(item){

//        obj = {
//            name: programme.title,
//            description: programme.description,
//            longDescription: programme.long_description,
//            startTime: programme.startTime,
//            duration: programme.duration,
//            channelID: freesat.channelData.getChannelByFreesatServiceID(String(programme.fsvc_id)),
//            programmeID: this.getProgrammeIDFromIP(links),
//            genre: [programme.genre], // OIPF programme object genre is a string collection
//            episode: programme.episode_name,
//            pay: meta.pay,
//            hasSsound: meta.ssound,
//            isHD: meta.hd,
//            hasDolby: meta.dolby,
//            hasGuidance: meta.guidance,
//            subtitles: meta.subtitle,
//            hasSignLanguage: meta.signed,
//            hasAudioDescription: meta.ad,
//            is3D: meta.threed,
//            showcase: meta.sc,
//            ondemand: ondemand,
//            hasHDSimulcast: meta.hdlinkage,
//            locked: programme.lock,
//            onlineAvailability: programme.available,
//            image: programme.image,
//            availabilityText: programme.availability_text,
//            guidanceText: programme.guidance_text
//        };

        var obj = {
            name: item.name,
            description: item.description,
            startTime: item.startTime,
            duration: item.duration,
            channelID: item.channelID,
//            episode: 0,//Integer
//            totalEpisodes: 0,//Integer
            event_id: item.event_id,
//            programmeID: '',//readonly
//            programmeIDType: 0,//Integer
//            showType: 0,//Integer
//            subtitles: false,//Boolean
//            isHD: false,//Boolean
//            audioType: 0,//Integer
//            isMultilingual: false,//Boolean
            genre: item.genre,
//            hasRecording: false,//Boolean
//            audioLanguages: null,
//            subtitleLanguages: null,
//            locked: false,//Boolean
//            recording: null,
//            hasSignLanguage: false,//Boolean
//            hasAudioDescription: false,//Boolean
//            is3D: false,//Boolean
//            onlineAvailability: false,//Boolean
//            hasGuidance: false,//Boolean
//            HDSimulcast: '',//readonly
//            onlineMediaLocation: '',//readonly
//            imageMediaLocation: '',//readonly
//            promotionalContentMediaLocation: '',//readonly
//            programmeCRID: '',//readonly
//            seriesCRID: '',//readonly
//            recommendationCRID: '',//readonly
//            CRIDS: [],
            availabilityText: item.availability_text
        };

        return obj;
    },

    parseIPProgramme: function(prog){
        var obj = this.parseIPSubItem(prog),
            programObject = new freesat.models.vo.IpProgramObject(),
            key;

        for (key in obj) {

            if (obj.hasOwnProperty(key)) {
                programObject[key] = obj[key];
            }
        }

        return programObject;
    },

    parseIPSearchObject: function(programme, pos) {
        var searchObject,
            programObject,
            name,
            items,
            item,
            svc_id,
            channelID,
            channel,
            genre,
            genre_value,
            genreLength,
            len,
            i;
        try {
            searchObject = new freesat.models.vo.Search();
            name = programme.name;
//            channel = freesat.channelData.channelList.getChannel(programme.channelID);
//            genre = programme.genre;

            searchObject.name = name;
            searchObject.highlighted = freesat.behind.highlight(name, freesat.behind.searchTerm);
            searchObject.count = programme.count;
//            searchObject.svcId = lcn;
            // searchObject.evtId = programme.evtId;
            // searchObject.seriesNo = programme.seriesNo;
            searchObject.searchPos = pos;

            if (programme.subitems) {
                items = programme.subitems;
            } else {
                items = [programme];
            }
            if (items && Array.isArray(items)) {
                len = items.length;
                searchObject.type = [];

                for (i = 0; i < len; i++) {
                    item = items[i];
                    // Get channel info
                    svc_id = item.svc_id;
                    channel = freesat.channelData.getChannelObjectByServiceID(svc_id);
                    if (!channel) {
                        freesat.console.log('Ignoring result for unknown channel with DVB service id 0x' + svc_id.toString(16) + ' (fsatServiceId=' + item.fsvc_id + ')');
                        continue;
                    }

                    channelID = channel.ccid;
                    genre = item.genre;
                    item.channelID = (channelID) ? channelID : '';

                    programObject = this.parseIPProgramme(item);

                    var now = (new Date().getTime()) / 1000;
                    var endTime = programObject.startTime + programObject.duration;
                    if (!item.icons.ondemand && endTime < now) {
                        freesat.console.log('Filtering out On TV event ' + programObject.name + ' with end time before now: ' + (new Date(endTime * 1000)));
                        searchObject.count--;
                        continue;
                    }

                    searchObject.events.push(programObject); // Populate all events
                    if (item.icons.ondemand) {
                        programObject.available = true;
                        programObject.event_id = item.event_id;
                        programObject.fsvc_id = item.fsvc_id;
                        var foundLink = false;
                        if (item.links) {
                            for (var linkIndex = 0; linkIndex < item.links.length; linkIndex++) {
                                var linkSet = item.links[linkIndex];
                                var odLink = linkSet['ondemand_link'];
                                if (odLink) {
                                    var linkParams = odLink.text;
                                    if (odLink.text.indexOf('?') !== -1) {
                                        linkParams = odLink.text.substr(odLink.text.indexOf('?') + 1);
                                    }
                                    foundLink = true;
                                    programObject.deepLink = "native://freetime/" + odLink.type.toLowerCase() + "/[%]" + freesat.localConfig.auth.ipchannelsmgr + linkParams + "[%]";
                                    programObject.deepLinkType = odLink.type;
                                    programObject.deepLinkServiceId = odLink.serviceid;
                                }
                            }
                        }

                        if (!foundLink) {
                            freesat.console.log('WARNING - failed to find ondemand_link for event ' + event_id + ' in following links:');
                            freesat.console.log(JSON.stringify(currentProg.links, null, 4));
                        }

                        searchObject.ondemand.push(programObject);
                    } else {
                        searchObject.ontv.push(programObject);
                    }

                    if (genre && searchObject.type.indexOf(genre) === -1) {

                        if (Array.isArray(genre)) { // Check to see if genre is an array of types, as in broadcast programmeObject
                            genreLength = genre.length;

                            for (i = 0; i < genreLength; i++) {
                                genre_value = genre[i];

                                if (searchObject.type.indexOf(genre_value) === -1) {
                                    searchObject.type.push(genre_value);
                                }
                            }
                        } else {
                            searchObject.type.push(genre);
                        }
                    }
                    if (i === 0) { // Get channel for 1st item
                        channel = freesat.channelData.channelList.getChannel(channelID);
                        if(channel){
                            searchObject.logo = freesat.channelData.getChannelLogo(channel.freesatServiceID, false);
                            searchObject.logo_highlight = freesat.channelData.getChannelLogo(channel.freesatServiceID, true);
                            searchObject.channel = channel.name;
                        }else{
                            searchObject.channel = 'no data';
                            searchObject.logo = '';
                        }

                        searchObject.svcId = channelID;
                        searchObject.evtId = item.event_id;
                        searchObject.programObject = programObject;
                        searchObject.availabilityText = programObject.availability_text;
                    }
                }
            }

        }catch(e){
            console.log('parseIPSearchObject ERROR: ' + e);
            return null;
        }
        return searchObject;
    },

    setIPSearchResults: function(data) {
        if (data == null) {
            freesat.console.log('IP search failed - retrying using OIPF');
            freesat.behind.ipFailed = true;
            freesat.behind.handledSearchTerm = null;
            freesat.behind.handleSearchEntry();
            return;
        }


        var programmes = data.results,
            count = programmes.results_count,
            items = programmes.items,
            results = [],
            i;

        if (count > 0) {
            // Reset filter menus
            freesat.behind.selected_type = 0;
            freesat.behind.filter_types = [];
            freesat.behind.filter_menu = [freesat.behind.filter_menu.shift()]; // Reset filter menu to just 'All results'

            if (freesat.behind.useFilterResults) { // Reset if filter is currently applied
                freesat.behind.useFilterResults = false;
            }

            for (i = 0; i < count; i++) {
                var programme = items[i],
                    name = programme.name;
                    var searchTermPos = freesat.behind.searchTermPos(name, freesat.behind.searchTerm);
                    var searchObject = freesat.behind.parseIPSearchObject(programme, i); // use server's ordering

                if (searchObject && searchObject.programObject) {
                    results.push(searchObject);
                    freesat.behind.populateFilterType(searchObject);
                }
            }

            results.sort(function(obj1, obj2) {
                if (obj1.searchPos < obj2.searchPos) {
                    return -1;
                } else if (obj1.searchPos > obj2.searchPos) {
                    return 1;
                }
                return 0;
            });

            freesat.behind.results = results;
            freesat.behind.create.searchResults();
            freesat.behind.filter_types.sort();
            freesat.behind.filter_menu = freesat.behind.filter_menu.concat(freesat.behind.filter_types);
            freesat.behind.create.filterMenu();
        } else {
            freesat.behind.create.noResults();
        }

    },

    handleSearchEntry: function() {
        var searchTerm = freesat.behind.textField.getText(),
            chars = freesat.behind.stripWhitespace(searchTerm),
            formatted = freesat.behind.stripPunctuation(searchTerm),
            callback = freesat.behind.isIpAvailable() ? freesat.behind.setIPSearchResults : freesat.behind.setSearchResults;

        if(freesat.behind.handledSearchTerm !== formatted){
            freesat.behind.handledSearchTerm = formatted;

            if (chars.length > 2) {
                freesat.behind.searchTerm = formatted;
                freesat.behind.activeSearch = true;
                freesat.behind.dataInterface.abortiveSearch = false;
                if (this.isIpAvailable()) {
                    freesat.behind.dataInterface.ipsearch(formatted, 'forward', callback);
                }else{
                    freesat.behind.dataInterface.oipfsearch([formatted, 'forward', callback]);
                }
                
            } else {

                if (freesat.behind.hasResults || freesat.behind.activeSearch) {
                    freesat.behind.dataInterface.voidAllSearchs();
                    freesat.behind.page = freesat.behind.topPositionIndex = freesat.behind.row = 0;
                    freesat.behind.deleteSearchResults();
                    freesat.footer.hide('green');
                    freesat.footer.hide('paging');
                    freesat.behind.hasResults = false;
                }
                freesat.behind.landingPage.removeClass("hidden");
                freesat.behind.resultsPage.addClass("hidden").removeClass('show-no-results');
            }
        }
    },

    handleMenuFocus: function() {
        var current = accedo.ui.FocusManager.singleton().getCurrentFocus(),
            previous;

        current.addClass('selected');
        previous = (freesat.behind.groupType === 'ontv') ? 'filter-ondemand' : 'filter-ontv';
        freesat.behind.get(previous).removeClass('selected');
    },

    onTransitionEnd: function() {
        document.getElementById('resultsContainer').removeEventListener('webkitTransitionEnd', freesat.behind.onTransitionEnd);
        freesat.behind.get('resultsContainer').removeClass('off-top').removeClass('transition-vertical');

        // if (freesat.behind.isPageDown) {
        // freesat.behind.get('result' + freesat.behind.row).setFocus();
        freesat.behind.populateSearchResults(false, true);
        freesat.behind.isPageDown = false;
        // }
        freesat.behind.isAnimating = false;
    },

    onGroupTransitionEnd: function() {
        document.getElementById('groupContainer').removeEventListener('webkitTransitionEnd', freesat.behind.onGroupTransitionEnd);
        freesat.behind.get('groupContainer').removeClass('off-top').removeClass('transition-vertical');

        // if (freesat.behind.isGroupPageDown) {
        // freesat.behind.get('group' + freesat.behind.groupRow).setFocus();
        freesat.behind.populateGroupResults(false, true, false);
        freesat.behind.isGroupPageDown = false;
        // }
        freesat.behind.isAnimating = false;
    },

    onKey: function(vKey){

        if(!freesat.isAnimating){
            keyHandler = new freesat.controllers.search.KeyHandler();
            return keyHandler.onKey(vKey);
        }
        return false;
    },

    getAM_urlParam: function(){
        return '/search';
    }

});
