accedo.ui.View.create("freesat.view.Ondemand", {
    type : accedo.ui.layout.Normal,
    defaultFocus: '',
    id: "#ondemand",
    focusable: true,
    children : [
        {
            type: accedo.ui.widget.Image,
            id: '#background',
            src: 'images/1280x720/background/back_onDemand3.png'
        },
        {
            id : '#header-controller',
            controller: 'freesat.controllers.subcontrollers.Header'
        },

        {
            type: accedo.ui.Container,
            id: '#container',
            css:'container',
            children:
                [

                    {
                        type: accedo.ui.Container,
                        id: '#od-overlay-container',
                        css:'od-overlay-container'
                    },
                    {
                        type:accedo.ui.Container,
                        id:'#header-container',
                        children:
                            [
                                {
                                    type: accedo.ui.widget.Label,
                                    id: '#pageClock',
                                    css: 'showcase-time'
                                },
                                {
                                    type: accedo.ui.Container,
                                    css: 'logoContainer',
                                    children:[
                                        {
                                            type: accedo.ui.widget.Image,
                                            id: 'freesatLogo',
                                            css: 'freesatLogo',
                                            src: 'images/1280x720/logo/freetime-125x24.png'
                                        }]
                                },
                                {
                                    type: accedo.ui.widget.Label,
                                    id: '#showcase-title',
                                    text:'on demand'

                                },
                                {
                                    type: accedo.ui.widget.Label,
                                    id: '#showcase-strap',
                                    text:'movies, apps & catchup tv all in one place'
                                }
                            ]
                    },

                    {
                        type: accedo.ui.widget.Button,
                        id: '#hidden-button'
                    },
                    {
                        type: accedo.ui.Container,
                        id:'#straplineBG',
                        css:'straplineBG hidden'
                    },
                    {
                        type:accedo.ui.widget.Label,
                        id:'#ondemandStrapline',
                        css:'straplineTitle hidden',
                        text:'players and apps, ready when you are'
                    },
                    {
                        type: accedo.ui.Container,
                        id: '#scrollContainer',
                        css: 'scrollContainer',
                        children:
                            [
                                {
                                    type: accedo.ui.Container,
                                    id: "#scrollContainerInner",
                                    css: "scrollContainerInner",
                                    children: [
                                        {
                                            type: accedo.ui.Container,
                                            id: '#ondemandShowcasePromoContainer',
                                            css: 'showcasePromoContainer hide',
                                            children:
                                                [
                                                    {
                                                        type: accedo.ui.Container,
                                                        id: '#ondemandShowcasePromo',
                                                        css: 'showcasePromo',
                                                        children: [
                                                            {
                                                                type: accedo.ui.Container,
                                                                id: '#ondemandShowcaseImageContainer',
                                                                css: 'ondemandShowcaseImageContainer',
                                                                children: [{
                                                                    type:accedo.ui.widget.Image,
                                                                    id:'#ondemandShowcaseImage',
                                                                    css:'showcasePromoImage',
                                                                    src: 'images/1280x720/showcase/placeholder.jpg'
                                                                }]
                                                            },
                                                            {
                                                                type: accedo.ui.Container,
                                                                id: '#ondemandShowcaseGradient',
                                                                css: 'showcasePromoGradient'
                                                            },
                                                            {
                                                                type:accedo.ui.widget.Image,
                                                                id:'#ondemandShowcaseImageChannel',
                                                                css: 'ondemandShowcaseImageChannel'
                                                            },
                                                            {
                                                                type:accedo.ui.widget.Label,
                                                                id:'#ondemandShowcaseImageText',
                                                                css: 'ondemandShowcaseImageText'
                                                            },
                                                            {
                                                                type:accedo.ui.widget.Label,
                                                                id:'#ondemandShowcaseHeader',
                                                                css:'showcasePromoHeader'
                                                            },
                                                            {
                                                                type:accedo.ui.widget.Label,
                                                                id:'#ondemandShowcaseText',
                                                                css: 'showcasePromoText'
                                                            },
                                                            {
                                                                type: accedo.ui.Container,
                                                                id: '#ondemandShowcaseHighlight',
                                                                css: 'showcasePromoHighlight'
                                                            }

                                                        ]
                                                    },
                                                    {
                                                        type: accedo.ui.Container,
                                                        id: '#ondemandShowcasePromo2',
                                                        css: 'showcasePromo',
                                                        children: [
                                                            {
                                                                type: accedo.ui.Container,
                                                                id: '#ondemandShowcaseImageContainer2',
                                                                css: 'ondemandShowcaseImageContainer',
                                                                children: [{
                                                                    type:accedo.ui.widget.Image,
                                                                    id:'#ondemandShowcaseImage2',
                                                                    css:'showcasePromoImage',
                                                                    src: 'images/1280x720/showcase/placeholder.jpg'
                                                                }]
                                                            },
                                                            {
                                                                type: accedo.ui.Container,
                                                                id: '#ondemandShowcaseGradient',
                                                                css: 'showcasePromoGradient'
                                                            },
                                                            {
                                                                type:accedo.ui.widget.Image,
                                                                id:'#ondemandShowcaseImageChannel2',
                                                                css: 'ondemandShowcaseImageChannel'
                                                            },
                                                            {
                                                                type:accedo.ui.widget.Label,
                                                                id:'#ondemandShowcaseImageText2',
                                                                css: 'ondemandShowcaseImageText'
                                                            },
                                                            {
                                                                type:accedo.ui.widget.Label,
                                                                id:'#ondemandShowcaseHeader2',
                                                                css:'showcasePromoHeader'
                                                            },
                                                            {
                                                                type:accedo.ui.widget.Label,
                                                                id:'#ondemandShowcaseText2',
                                                                css: 'showcasePromoText'
                                                            },
                                                            {
                                                                type: accedo.ui.Container,
                                                                id: '#ondemandShowcaseHighlight',
                                                                css: 'showcasePromoHighlight'
                                                            }

                                                        ]
                                                    },
                                                    {
                                                        type: accedo.ui.Container,
                                                        id: '#ondemandShowcasePromo3',
                                                        css: 'showcasePromo',
                                                        children: [
                                                            {
                                                                type: accedo.ui.Container,
                                                                id: '#ondemandShowcaseImageContainer3',
                                                                css: 'ondemandShowcaseImageContainer',
                                                                children: [{
                                                                    type:accedo.ui.widget.Image,
                                                                    id:'#ondemandShowcaseImage3',
                                                                    css:'showcasePromoImage',
                                                                    src: 'images/1280x720/showcase/placeholder.jpg'
                                                                }]
                                                            },
                                                            {
                                                                type: accedo.ui.Container,
                                                                id: '#ondemandShowcaseGradient',
                                                                css: 'showcasePromoGradient'
                                                            },
                                                            {
                                                                type:accedo.ui.widget.Image,
                                                                id:'#ondemandShowcaseImageChannel3',
                                                                css: 'ondemandShowcaseImageChannel'
                                                            },
                                                            {
                                                                type:accedo.ui.widget.Label,
                                                                id:'#ondemandShowcaseImageText3',
                                                                css: 'ondemandShowcaseImageText'
                                                            },
                                                            {
                                                                type:accedo.ui.widget.Label,
                                                                id:'#ondemandShowcaseHeader3',
                                                                css:'showcasePromoHeader'
                                                            },
                                                            {
                                                                type:accedo.ui.widget.Label,
                                                                id:'#ondemandShowcaseText3',
                                                                css: 'showcasePromoText'
                                                            },
                                                            {
                                                                type: accedo.ui.Container,
                                                                id: '#ondemandShowcaseHighlight3',
                                                                css: 'showcasePromoHighlight'
                                                            }

                                                        ]
                                                    }
                                                ]
                                        },
                                        {
                                            type: accedo.ui.Container,
                                            id: '#ondemandGridMask',
                                            css: 'ondemandGridMask',
                                            children: [

                                                {
                                                    type: accedo.ui.Container,
                                                    id: '#ondemandGridContainer',
                                                    css: 'ondemandGridContainer'
                                                }
                                            ]
                                        }
                                    ]
                                },
                                {
                                    type:   accedo.ui.Container,
                                    id: '#ondemandScrollbar',
                                    css: 'od-scrollbar',
                                    children: [
                                        {
                                            type: accedo.ui.Container,
                                            id: '#ondemandScrollbarHandle',
                                            css: 'scrollbar-handle od-scrollbar-handle'
                                        }
                                    ]
                                }
                            ]
                    },
                    {
                        type : accedo.ui.Container,
                        id: '#ondemand-connection-message',
                        css : 'ondemand-connection-message',
                        children :
                            [
                                {
                                    type: accedo.ui.widget.Image,
                                    src: 'images/1280x720/not_connected/ondemand.png',
                                    css: 'ondemand-not-connected-earlier-image'
                                },
                                {
                                    type: accedo.ui.Container,
                                    css: 'ondemand-not-connected-container',
                                    children: [
                                        {
                                            type : accedo.ui.widget.Label,
                                            id: '#ondemand-connectionLabel',
                                            css:'ondemand-connectionLabel',
                                            text : 'get connected'
                                        },
                                        {
                                            type : accedo.ui.widget.Label,
                                            id: '#ondemand-connectionmessageLabel',
                                            css:'ondemand-connectionmessageLabel',
                                            text : 'To use this section, please make sure your TV is connected to the internet'
                                        },
                                        {
                                            type : accedo.ui.widget.Button,
                                            id: '#ondemand-connectionBackButton',
                                            css:'ondemand-connectionBackButton',
                                            text : 'Back',
                                            nextUp:''
                                        }
                                    ]
                                }
                            ]
                    }
                ]
        }
    ]
});
/**
 * @name Ondemand
 * @namespace
 * @memberOf freesat.controllers
 * @class
 */
accedo.Class.create("freesat.controllers.Ondemand", "accedo.ui.Controller", ["freesat.view.Ondemand"], {}, {
    /**
     * @memberOf freesat.controllers.Ondemand
     */
    data: null,
    initialFocus: 1,
    row: 0,
    col: 0,
    page: 0,
    pageTotal: 0,
    rowTotal:0,
    itemsTotal:0,
    playersTotal: 0,
    dataInterface: null,
    jsonObject: null,
    setupDone:false,
    showcase: false,
    scrollpage: 0,
    overlayOn: false,
    promoList: [],

    initialize: function($super) {
        $super();
        freesat.behind = this;
        freesat.oipfElement.setKeysetWithNumbers();
        freesat.console.log('[Ondemand Controller] initialize');
        this.dataInterface = freesat.dataStore.getInterface();

        this.setView(freesat.view.Ondemand);

    },

    onKey: function(vKey) {
        var keyHandling = new freesat.controllers.ondemand.KeyHandler();
        return keyHandling.onKey(vKey);
    },
    pinResults: function(url){
        return function(result){
            freesat.console.log('ondemand.pinResult : '+ result);
            if(result == 1){
                freesat.behind.goToPlayer(url);
            }
        };
    },
    goToPlayer: function(url){
        freesat.console.log('ondemand.goToPlayer : '+ url);
        freesat.setBackCookieValue('startType',freesat.debugVar);
        freesat.setBackCookieValue('section','od');
        freesat.setBackCookieValue('row',freesat.behind.row);
        freesat.setBackCookieValue('col',freesat.behind.col);
        freesat.setBackCookieValue('page',freesat.behind.page);
        setTimeout(function () {
            window.location = url;
        }, 200);
    },

    launchPlayer: function(){
        var player, page, scrollPage, url, available, locked;

        playerNum = ((this.row - 1) * 4) + this.col;
        page = this.page;
        scrollpage = this.scrollpage+1;
        player = this.data.pages[page].players[(playerNum - 1)];
        url = player.url;
        name = player.name;
        available = player.available;
        locked = player.locked;

        freesat.console.log('ondemandPlayer' + (playerNum - 1) + ' +++Player+++ ' + url);

        if (available) {
            if (url) {
                if (this.dataInterface.ondemand.isIpAvailable()) {
                    try {
                        if (locked && opal_isPINSet(4)) {
                            opal_onPromptForPinResult = freesat.behind.pinResults(url);
                            opal_promptForPin(1, '');
                        } else {
                            freesat.am.screenEvent('/onDemand/page' + scrollpage, {
                                category: 'select',
                                action: 'launchPlayer',
                                name: name
                            });
                            freesat.am.amEvent('/onDemand/page' + scrollpage, {
                                channel: {
                                    sID: player.linkServiceId,
                                    name: player.name
                                },
                                playback: {
                                    playSpeed: 1,
                                    position: 0
                                }
                            });
                            this.goToPlayer(url);
                        }
                    } catch (e) {
                        freesat.console.log('ondemand.keyHandler.onKey OK : ' + e);
                    }
                } else {
                    if (this.noip_onload) {
                        this.setConnectionError(false);
                    } else {
                        this.get('ondemand-connectionLabel').setText('lost connection');
                        this.get('ondemand-connectionmessageLabel').setText('You are no longer connected to the internet. Please check your connection and try again');
                        this.showError();
                    }
                }
            }
        }
    },

    scrollToFocus: function(){
        if (freesat.behind.data.rowCount > 3){
            // Need to scroll content

            if (freesat.behind.row < 3){
                document.getElementById('scrollContainerInner').style.top= '0px';
                freesat.behind.scrollpage = 0;
                freesat.behind.get('showcase-strap').setText(freesat.behind.jsonObject.odPages.pages.page[0].heading_title);
            } else {
                if (freesat.behind.row < 5) {
                    document.getElementById('scrollContainerInner').style.top= '-330px';
                    freesat.behind.scrollpage = 1;
                    freesat.behind.get('showcase-strap').setText(freesat.behind.jsonObject.odPages.pages.page[1].heading_title);
                } else {
                    document.getElementById('scrollContainerInner').style.top= '-656px';
                    freesat.behind.scrollpage = 2;
                    freesat.behind.get('showcase-strap').setText(freesat.behind.jsonObject.odPages.pages.page[2].heading_title);
                }
            }

            this .updateScrollbar();
        } else {
            //Single page so no scrolling needed
            document.getElementById('scrollContainerInner').style.top= '0px';
        }
    },


    renderFocus: function(){
        /*
         Jira PDC-145 defines 3 template modes depending on number of items:
         1-12: No scroll and single promo 3x row height
         13-20: Scrolling, 1st promo 2x row height, 2nd promo 3x row height
         21-28: Scrolling, 1st & 2nd promo 2x row height, 3rd promo 3x row height
         */
        if (freesat.behind.col === 0) {
           freesat.behind.selectShowcase();
           return;
        }

        var playerNum = ((freesat.behind.row-1) * 4) + freesat.behind.col,
            page = freesat.behind.page,
            player = freesat.behind.get('ondemandPlayer'+playerNum + '-' + page),
            playerHighlight = freesat.behind.get('ondemandPlayerHighlight-'+playerNum + '-' + page);

        player.addClass('focused');
        playerHighlight.removeClass('hidden');
      //  freesat.header.setOndemand(freesat.behind.data.pages[page].players[(playerNum-1)].name, freesat.behind.data.pages[page].players[(playerNum-1)].description);

        this.scrollToFocus();

    },
    removeHighlight: function(){
        var playerNum = ((freesat.behind.row-1) * 4) + freesat.behind.col,
            page = freesat.behind.page,
            player = freesat.behind.get('ondemandPlayer'+playerNum + '-' + page),
            playerHighlight = freesat.behind.get('ondemandPlayerHighlight-'+playerNum + '-' + page);

        player.removeClass('focused');
        playerHighlight.addClass('hidden');
    },
    setup : function() {
        if (!this.setupDone) {
            this.setupDone = true;

            this.lang = new freesat.language.OnDemandEn();
            setTimeout(freesat.loadRemainingSections, 200);

            if (this.dataInterface.ondemand.isIpAvailable()) {
                if (!freesat.localConfig.auth.onDemand) {
                    this.setError();
                    return;
                }

                this.get('ondemand-connection-message').addClass('hidden');
                this.dataInterface.ondemand.getOnDemand(this.gotData(this));
            } else if (freesat.datamode === 'dsat') {
                this.noip_onload = true;
                this.get('ondemand-connection-message').addClass('hidden');

                var scope = this;
                setTimeout(function() {
                    scope.dataInterface.ondemand.getOnDemandUsingDSMCC(scope.gotData(scope));
                }, 1);
                //this.dataInterface.ondemand.getOnDemandUsingDSMCC(this.gotData(this));
            } else {
                this.setConnectionError(true);
            }
        }
    },
    //EXAMPLE data see src/fakedata/od.json
    gotData: function(scope){
        return function(jsonObj){
            var pages, pages_len, page_len, obj, imgFactory, i, j, k, item, img, scrollbarPages;
            if(jsonObj){
                scope.jsonObject = jsonObj;
                var data = {
                    pages: [],
                    players: []
                };
                scope.initialFocus = jsonObj.odPages.pages.page[0].itemlist.initalItem;
                imgFactory = new freesat.models.Imagefactory();
                pages = jsonObj.odPages.pages.page;
                pages_len = pages.length;

                var allItems =[];
                for (var i = 0; i < pages_len; i++) {
                    allItems = allItems.concat(pages[i].itemlist.item);
                }


                scope.get('showcase-strap').setText(scope.jsonObject.odPages.pages.page[0].heading_title);

// Uncomment to add more items to grid for testing larger number of OD players
//               allItems = allItems.concat(allItems, allItems);

                items_len = allItems.length;
                   
  //              for (i = 0; i < pages_len; i++) {
                    i = 0; // For single page

                    scope.createPage(i + 1);

                    data.pages.push({page: 1, players: [], rowTotal: 0, initialFocus: scope.initialFocus});
                    data.rowCount = 0;
                    data.gridPopulation = []; // Setup 2D array to represent row & cols of grid
                    data.gridPopulation.push([]); // Add empty first row. Rows & cols indices start at 1 so 1st array row not needed

                    for(var j= 0; j<items_len; j++){
                        item = allItems[j];
                        obj = {};

                        img = imgFactory.getImageURL(item.thumbnail_image);

                        var link = scope.getLink(item.links, 'ondemand_link');
                        obj.name = item.title;
                        obj.url = link.url;
                        obj.linkServiceId = link.serviceId;
                        obj.linkType = link.type;
                        obj.image = img;
                        obj.description = item.short_synopsis;
                        obj.available = item.available;
                        obj.locked = item.locked;
                        obj.heading_title = pages[i].heading_title;
                        data.players.push(obj); // .pages[i]
                        data.pages[i].players.push(obj); //
                    }
                    scope.data = data;
                    try {
                        scope.itemsTotal = scope.data.pages[i].players.length;
                        scope.playersTotal += scope.itemsTotal;
                    } catch (e) {
                        freesat.console.log('[ondemand]setup '+e);
                    } // .pages[i]

                    if(scope.itemsTotal>0){
                        for(k=0;k<scope.itemsTotal;k++){

                            if(k%4===0){
                                scope.data.rowCount++;
                                // New row array in grid population array
                                scope.data.gridPopulation.push(Array([]));
                                scope.createRow(i, scope.rowTotal+1);
                            }

                            scope.createPlayerButton(k+1, scope.data.pages[i].players[k], i); // .pages[i]
                            // Record whether grid position is populated

                            scope.data.gridPopulation[scope.data.gridPopulation.length - 1].push(true);

                        }

                        // Pad out rest of row with placeholders
                        while (k%4 !== 0){
                            scope.createPlayerPlaceholder();
                            k++;
                        }

                        if (scope.data.rowCount < 3) {
                            // Need to add a 3rd row of placeholders
                            scope.createEmptyRows(3 - scope.data.rowCount);

                        } else if (scope.data.rowCount < 5){

                            scope.createEmptyRows(5 - scope.data.rowCount);

                        } else {

                            scope.createEmptyRows(7 - scope.data.rowCount);
                        }

                    }




                    // Add class so promos can be resized according to how many players there are
                    var hasAtLeast1Promo = (pages.length >= 1) && pages[0].promo && pages[0].promo.promoitem;
                    var hasAtLeast2Promos = (pages.length >= 2) && pages[1].promo && pages[1].promo.promoitem;
                    var hasAtLeast3Promos = (pages.length >= 3) && pages[2].promo && pages[2].promo.promoitem;

                    var promo1 = (pages.length > 0) ? pages[0].promo.promoitem : null;
                    var promo2 = (pages.length > 1) ? pages[1].promo.promoitem : null;
                    var promo3 = (pages.length > 2) ? pages[2].promo.promoitem : null;

                    if (scope.data.rowCount <= 3) {
                        scope.updateShowcase('', promo1, true);
                        scope.get('ondemandShowcasePromoContainer').addClass('promoCount-1');
                        scrollbarPages = 1;
                    } else if (scope.data.rowCount < 6) {
                            scope.updateShowcase('', promo1, false);
                            scope.updateShowcase('2', promo2, true);
                            scope.get('ondemandShowcasePromoContainer').addClass('promoCount-2');
                            scrollbarPages = 2;
                    } else {
                        scope.get('ondemandShowcasePromoContainer').addClass('promoCount-3');
                        scope.updateShowcase('', promo1, false);
                        scope.updateShowcase('2', promo2, false);
                        scope.updateShowcase('3', promo3, true);
                        scrollbarPages = 3;
                    }

                    if (items_len > 12) {
                        scope.get('ondemandScrollbar').addClass('show');
                        freesat.behind.scrollbar = 100 / scrollbarPages;
                        scope.get('ondemandScrollbarHandle').root.setStyle({
                            height: freesat.behind.scrollbar + '%'
                        });
                    }
                   

  //              }
                if (freesat.backJourney) {
                    var cookierow = freesat.getBackCookieValue('row');
                    var cookiecol = freesat.getBackCookieValue('col');
                    var cookiepage = freesat.getBackCookieValue('page');

                    scope.row = (cookierow)?parseInt(cookierow,null):1;
                    scope.col = (cookiecol)?parseInt(cookiecol,null):1;
                    scope.page = (cookiecol)?parseInt(cookiepage,null):0;
                    freesat.backJourney = false;
                    freesat.clearBackCookie('section');
                    freesat.clearBackCookie('row');
                    freesat.clearBackCookie('col');
                    freesat.clearBackCookie('page');
                    var fNum = ((scope.row-1) * 4) + scope.col;
                    if (fNum > scope.itemsTotal) {
                        scope.row = 1;
                        scope.col = 1;
                    }
                } else {
                    scope.row = 1;
                    scope.col = 1;
                    scope.page = 0;
                }
                scope.self = scope;
                scope.renderFocus();

                // Promos hidden until we know what size each should be. Show now as we know how many player rows there are
                scope.get('ondemandShowcasePromoContainer').removeClass('hide');

                scope.setFocus();

                freesat.am.screenView('/onDemand');
                freesat.marketingOptIn.showDialogIfRequired();
            }
        };
    },
    getLink: function(linkSets, linkType) {
        if ((typeof linkSets === 'undefined') || (linkSets === null)) {
            return null;
        }

        for (var linkSetIndex = 0; linkSetIndex < linkSets.length; linkSetIndex++) {
            var linkSet = linkSets[linkSetIndex];
            var link = linkSet[linkType];
            if (link && link.type) {
                return {
                    type: link.type,
                    url: 'native://freetime/'+ link.type.toLowerCase() +'/[%]' + freesat.localConfig.auth.ipchannelsmgr + link.text + '[%]',
                    serviceId: link.serviceid
                };
            }
        }
        return {};
    },
    updateShowcase: function(promoNum, promo, isBig){
        if (!promo) {
            return;
        }

        var imgFactory = new freesat.models.Imagefactory(),
            promoNumIndex = (promoNum)? promoNum : 1,
            img = imgFactory.getImageURL(promo.image, 312, 478, true) || '';

        freesat.console.log(promo.image);

        this.promoList[promoNumIndex] = promo;

        this.get('ondemandShowcaseHeader' + promoNum).setText(promo.title);
        this.get('ondemandShowcaseImageChannel' + promoNum).setSrc(imgFactory.getImageURL(promo.channel_logo));
        this.get('ondemandShowcaseImageText' + promoNum).setText(promo.imageText);
        this.get('ondemandShowcaseImage' + promoNum).setSrc(img);
        this.get('ondemandShowcaseText' + promoNum).setText(promo.ctaText);
    },

    selectShowcase: function() {
        var selectedPromoIndex = 1;
        var selectedPromo = 'ondemandShowcasePromo';

        if (this.data.rowCount < 4){
            // Only single, large promo shown.
            selectedPromoIndex = 1;
            selectedPromo = 'ondemandShowcasePromo';
        } else if (this.data.rowCount < 6) {
            // One small, one large promo shown
            if (this.row < 3) {
                selectedPromoIndex = 1;
                selectedPromo = 'ondemandShowcasePromo';
            } else {
                selectedPromoIndex = 2;
                selectedPromo = 'ondemandShowcasePromo2';
            }
        } else {
            // Two small, one large promo shown
            if (this.row < 3) {
                selectedPromoIndex = 1;
                selectedPromo = 'ondemandShowcasePromo';
            } else if (this.row < 5) {
                selectedPromoIndex = 2;
                selectedPromo = 'ondemandShowcasePromo2';
            } else {
                selectedPromoIndex = 3;
                selectedPromo = 'ondemandShowcasePromo3';
            }
        }
        freesat.behind.selectedPromo = freesat.behind.promoList[selectedPromoIndex];
        this.get(selectedPromo).addClass('focused');
        
        freesat.behind.showcase = true;
        freesat.behind.col = 0;

        this.scrollToFocus();
    },

    deselectShowcase: function() {

        this.get('ondemandShowcasePromo').removeClass('focused');
        this.get('ondemandShowcasePromo2').removeClass('focused');
        this.get('ondemandShowcasePromo3').removeClass('focused');

        freesat.behind.showcase = false;
    },

    updateScrollbar: function() {
        var pos = freesat.behind.scrollbar * freesat.behind.scrollpage;
        freesat.behind.get('ondemandScrollbarHandle').root.setStyle({
            top: pos + '%'
        });
    },

    showInfoOverlay: function(playerNum){

        this.createInfoPanel(playerNum);
       
        this.get('od-overlay-container').addClass('show');
        this.overlayOn = true;
    },

    hideInfoOverlay: function(){
        this.get('od-overlay-container').removeClass('show');
        this.get('od-overlay-container').removeAll();
        this.overlayOn = false;
        this.setFocus();
    },

    nextInfoOverlayButton: function(){
        this.infoMenuButtons[this.infoMenuButtonFocus].setFocus(true);
        this.infoMenuButtonFocus++;
        if (this.infoMenuButtonFocus == this.infoMenuButtons.length){
            this.infoMenuButtonFocus = 0;
        }
        this.infoMenuButtons[this.infoMenuButtonFocus].setFocus();
    },

    previousInfoOverlayButton: function(){
        this.infoMenuButtons[this.infoMenuButtonFocus].setFocus(true);
        this.infoMenuButtonFocus--;
        if (this.infoMenuButtonFocus < 0){
            this.infoMenuButtonFocus = this.infoMenuButtons.length - 1;
        }
        this.infoMenuButtons[this.infoMenuButtonFocus].setFocus();
    },

    setFetchingDsmcc: function() {
        this.get('ondemand-connectionLabel').setText('updating on demand');
        this.get('ondemand-connectionmessageLabel').setText('Please bear with us for a few minutes while we update On Demand...');
        this.noip_onload = true;
        this.showError();
    },

    setConnectionError: function(isFatal) {
        this.get('ondemand-connectionLabel').setText('get connected');
        this.get('ondemand-connectionmessageLabel').setText('To use this section, please make sure your TV is connected to the internet');
        this.noip_onload = true;
        this.isNonFatalConnectionError = !isFatal;
        this.showError();
    },

    setError: function() {
        this.get('ondemand-connectionLabel').setText('trouble loading service');
        this.get('ondemand-connectionmessageLabel').setText('Sorry, there was a problem loading the service. Please exit and try again.');
        this.noip_onload = true;
        this.showError();
    },

    showError: function(){
        var self = this;

        this.get('straplineBG').addClass('hidden');
        this.get('ondemandStrapline').addClass('hidden');
        this.get('ondemandGridMask').addClass('hidden');
        this.get('ondemandShowcasePromo').addClass('hidden');
        this.get('programmeInformation').hide();
        this.get('ondemand-connection-message').removeClass ('hidden');
        this.get('ondemand-connectionBackButton').onKey = function (vKey) {
            if (vKey === accedo.VKey.KEY_OK || vKey === accedo.VKey.KEY_BACK) {
                if (self.errorShowing || self.noip_onload) {
                    self.get('straplineBG').removeClass('hidden');
                    if (self.isNonFatalConnectionError) {
                        freesat.dsmcc.tuneToOriginalChannel();
                        self.handleBack();
                    } else {
                        freesat.masterController.showLoading();
                        freesat.dsmcc.tuneToOriginalChannel();

                        // allow time for channel change before going back (to avoid confusing Guide with channel change)
                        setTimeout(freesat.masterController.handleBackPress, 2000);
                    }
                } else {
                    self.handleBack();
                }
                return true;
            }
        };
        this.get('ondemand-connectionBackButton').setFocus();
        this.errorShowing = true;
    },

    hideError: function() {
        this.get('ondemandGridMask').removeClass('hidden');
        this.get('ondemandShowcasePromo').removeClass('hidden');
        this.get('programmeInformation').show();
        this.get('ondemand-connection-message').addClass('hidden');
        this.errorShowing = false;
        this.get('hidden-button').onKey = function(vKey) {
            return false;
        };
        this.get('hidden-button').setFocus();
    },

    handleBack: function() {
        this.get('ondemandGridMask').removeClass('hidden');
        this.get('ondemandShowcasePromo').removeClass('hidden');
        this.get('programmeInformation').show();
        this.get('ondemand-connection-message').addClass ('hidden');
        this.get('hidden-button').onKey = function(vKey) {
            return false;
        };
        this.get('hidden-button').setFocus();
        this.errorShowing = false;
    },
    createPage: function(pageNum) {
        var pageCont, opts;

        opts = {
            id: 'ondemandPage'+pageNum,
            css: 'od-page'
        };
        pageCont = new accedo.ui.Container(opts);
        this.get('ondemandGridContainer').attach(pageCont);
        ++this.pageTotal;
    },
    createRow: function(pageNum, rowNum){
        var opts = {
            id: '#ondemandPlayerRow' + rowNum,
            css: 'od-row'
        };
        var rowCont = new accedo.ui.Container(opts);
        this.get('ondemandPage' + this.pageTotal).attach(rowCont);
//        this.get('ondemandGridContainer').attach(rowCont);

        ++this.data.pages[pageNum].rowTotal;
        ++this.rowTotal;
    },

    createEmptyRows: function(num){

        while (num > 0) {
            this.createRow(0, this.rowTotal + 1);

            for (var k=0; k<4; k++){
                this.createPlayerPlaceholder();
            }
            num--;
        }
    },

    createPlayerPlaceholder: function(){
        var opts = {
            css: 'od-player-placeholder'
        };

        var playerButton = new accedo.ui.Container(opts);
        this.get('ondemandPlayerRow'+this.rowTotal).attach(playerButton);
    },

    createInfoPanel: function(playerNum){

        var data = this.data.pages[this.page].players[(playerNum - 1)];

        var opts = {
            id: 'od-overlay-player',
            playerId: 'overlay-player',
            css: 'od-player'
        };

        var imgopts = {
            id: '#od-overlay-image',
            css: 'od-player-logo',
            src: data.image
        };

        var titleOpts = {
            id: '#od-overlay-title',
            css: 'od-overlay-title',
            text: data.name
        }

        var descOpts = {
            id: '#od-overlay-description',
            css: 'od-overlay-description',
            text: data.description
        }

        var panel = new accedo.ui.Container();
        var textContainer = new accedo.ui.Container({
            id: '#od-overlay-text-container',
            css: 'od-overlay-text-container'
        });

        var playerButton = new accedo.ui.Container(opts);

        var playerImage = new accedo.ui.widget.Image(imgopts);
        var titleEl = new accedo.ui.widget.Label(titleOpts);
        var descEl = new accedo.ui.widget.Label(descOpts);

        playerButton.attach(playerImage);

        panel.attach(playerButton);

        textContainer.attach(titleEl);
        textContainer.attach(descEl);


        var menuList = new accedo.ui.Container({
            id: '#od-overlay-menu-container',
            css: 'od-overlay-menu-container'
        });

        var buttonLaunch = new accedo.ui.widget.Button({
            text: this.lang.LAUNCH_BUTTON
        });

        var scope = this;
        buttonLaunch.addEventListener(accedo.ui.widget.Button.EVT_CLICK,function(){
            scope.hideInfoOverlay();
            scope.launchPlayer();
        },this);

        var buttonClose = new accedo.ui.widget.Button({
            css: 'last',
            text: this.lang.CLOSE_BUTTON
        });

        buttonClose.addEventListener(accedo.ui.widget.Button.EVT_CLICK,function(){
            scope.hideInfoOverlay();
        },this);


        menuList.attach(buttonLaunch);
        menuList.attach(buttonClose);

        textContainer.attach(menuList);

        panel.attach(textContainer);

        this.infoMenuButtonFocus = 0;
        this.infoMenuButtons = [
            buttonLaunch,
            buttonClose
        ];

        this.get('od-overlay-container').removeAll();
        this.get('od-overlay-container').attach(panel);

        this.infoMenuButtons[this.infoMenuButtonFocus].setFocus();
    },

    createPlayerButton: function(playerNum, data, page){
        var opts = {
            id: 'ondemandPlayer'+playerNum + '-' + page,
            playerId: 'iplayer',
            css: 'od-player'
        };
        var imgopts = {
            id: '#odImage-'+playerNum + '-' + page,
            css: 'od-player-logo',
            src: data.image
        };
        var hiopts = {
            id: '#ondemandPlayerHighlight-'+playerNum + '-' + page,
            css: 'od-player-highlight hidden'
        };
        var playerButton = new accedo.ui.Container(opts);
        var playerImage = new accedo.ui.widget.Image(imgopts);
        var playerHighlight = new accedo.ui.Container(hiopts);
        playerButton.attach(playerImage);
        playerButton.attach(playerHighlight);
        playerButton.url = data.url;
        playerButton.name = data.name;
        playerButton.description = data.description;
        this.get('ondemandPlayerRow'+this.rowTotal).attach(playerButton);
    }
});
