accedo.ui.View.create('freesat.view.Help', {
    type: accedo.ui.layout.Normal,
    defaultFocus: '',
    id: '#help',
    children : [
        {
            type: accedo.ui.widget.Image,
            id: '#backgrounnd',
            src: 'images/1280x720/background/back_help.png'
        },
        {
            id : '#header-controller',
            controller: 'freesat.controllers.subcontrollers.Header'
        },
        {
            type:accedo.ui.Container,
            id:'#header-container',
            children:
                [
                    {
                        type: accedo.ui.widget.Label,
                        id: '#pageClock',
                        css: 'help-time'
                    },
                    {
                        type: accedo.ui.Container,
                        css: 'logoContainer',
                        children:[
                            {
                                type: accedo.ui.widget.Image,
                                id: 'freesatLogo',
                                css: 'freesatLogo',
                                src: 'images/1280x720/logo/freetime-125x24.png'
                            }
                        ]
                    },
                    {
                        type: accedo.ui.widget.Label,
                        id: '#pageTitle'
                    },
                    {
                        type: accedo.ui.widget.Label,
                        id: '#help-title'
                    },
                    {
                        type: accedo.ui.widget.Label,
                        id: '#help-strap'
                    }
                ]
        },
        {
            type: accedo.ui.Container,
            id: '#container',
            css:'container',
            children:
                [
                    {
                        type: accedo.ui.Container,
                        id:'#straplineBG',
                        css:'straplineBG'
                    },
                    {
                        type:accedo.ui.widget.Label,
                        id:'#helpStrapline',
                        css:'straplineTitle',
                        text:'players and apps, ready when you are'
                    },
                    {
                        type: accedo.ui.Container,
                        id: '#helpGridMask',
                        css: 'helpGridMask',
                        focusable: true,
                        forwardFocus: true,
                        children: [
                            {
                                type: accedo.ui.Container,
                                id: '#helpGridContainer',
                                css: 'helpGridContainer'

                            },
                            {
                                type: accedo.ui.Container,
                                id: '#helpTopicContainer',
                                css: 'helpTopicContainer',
                                children: [
                                    {
                                        type: accedo.ui.Container,
                                        id: '#helpTopicControllerContainer',
                                        css: 'helpTopicControllerContainer',
                                        children: [
                                            {
                                                controller: ''
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                type: accedo.ui.Container,
                                id: '#questionsContainer'
                            },
                            {
                                type: accedo.ui.widget.Label,
                                id: '#pageUp',
                                css: 'hidden',
                                text: 'Page Up'
                            },
                            {
                                type: accedo.ui.widget.Label,
                                id: '#pageDown',
                                css: 'hidden',
                                text: 'Page Down'
                            }
                        ]
                    },
                    {
                        type:   freesat.widget.VTextImageButton,
                        focusable: true,
                        id: '#arrowRightContainer',
                        src: 'images/1280x720/arrow/arrow_right_dark_L_D.png',
                        focusedsrc: 'images/1280x720/arrow/bg_help_arrow.png',
                        text: 'more'
                    },
                    {
                        type:   freesat.widget.VTextImageButton,
                        focusable: true,
                        id: '#arrowLeftContainer',
                        src: 'images/1280x720/arrow/arrow_left_dark_L_D.png',
                        focusedsrc: 'images/1280x720/arrow/bg_help_arrow_left.png',
                        text: 'help'
                    }
                ]
        }
    ]
});
/**
 * @name Fullscreen
 * @namespace
 * @memberOf freesat.controllers
 * @class
 */
accedo.Class.create("freesat.controllers.Help", "accedo.ui.Controller", ["freesat.view.Help","freesat.language.HelpEn"], {}, {
    
    area: 'help',
    clock: null,
    startInterval: null,
    pageView: 'grid',
    gridWidth: 894,
    data: null,
    topicIndex: 0,
    subtopicIndex: null,

    initialize: function($super) {
        accedo.console.log('[Help Controller] ');
        $super();
        freesat.oipfElement.setKeysetWithNumbers();
        freesat.behind = this;
        freesat.behind.setView(freesat.view.Help);
        this.clock = new freesat.models.Clock();
        accedo.console.log('[Help Controller] init done');
        
    },
    
    setup: function() {
        var self = this;
        
        this.lang = new freesat.language.HelpEn();

        freesat.isAnimating = false;
        this.getElements();
        this.clock.updateClock(this.get('pageClock'));

        this.arrowLeft.addClass('hidden');

        this.get('pageTitle').setText(this.lang.HELP);
        this.helpStrapline.setText(this.lang.STRAPLINE);

        this.buildGrid();

        this.arrowRight.addEventListener(accedo.ui.Evt.KEY, function(key){
            if(!freesat.isAnimating){
                switch(key){
                    case accedo.VKey.KEY_OK:
                    case accedo.VKey.KEY_ENTER:
                    case accedo.VKey.KEY_RIGHT:
                        this.clickOnArrowRight();
                        break;
                    case accedo.VKey.KEY_LEFT:
                        if(!this.arrowLeft.getRoot().hasClass('hidden')){
                            this.clickOnArrowLeft();
                            this.arrowLeft.setFocus();
                            this.arrowRight.activateFocus();
                        }
                        break;
                    case accedo.VKey.KEY_KEYBOARD_PAGE_UP:
                    case accedo.VKey.KEY_UP:
                        this.scrollUp();
                        return true;
                    case accedo.VKey.KEY_KEYBOARD_PAGE_DOWN:
                    case accedo.VKey.KEY_DOWN:
                        this.scrollDown();
                        return true;
                    
                }
            }
        }, this);

        this.arrowLeft.addEventListener(accedo.ui.Evt.KEY, function(key){
            if(!freesat.isAnimating){
                switch(key){
                    case accedo.VKey.KEY_OK:
                    case accedo.VKey.KEY_ENTER:
                    case accedo.VKey.KEY_LEFT:
                        this.clickOnArrowLeft();
                        break;
                        
                    case accedo.VKey.KEY_RIGHT:
                        if(!this.arrowRight.getRoot().hasClass('hidden')){
                            this.clickOnArrowRight();
                            this.arrowRight.setFocus();
                        }
                        break;
                    case accedo.VKey.KEY_KEYBOARD_PAGE_UP:
                    case accedo.VKey.KEY_UP:
                        this.scrollUp();
                        return true;
                    case accedo.VKey.KEY_KEYBOARD_PAGE_DOWN:
                    case accedo.VKey.KEY_DOWN:
                        this.scrollDown();
                        return true;
                    
                }
            }
        }, this);
    },
    
    reset: function() {
        
    },

    buildGrid: function () {
        var self = this,
            gridNo = 0,
            pagesGridJson = [],
            gridJson = [],
            helpGrid = null,
            arrowRight = this.arrowRight,
            arrowLeft = this.arrowLeft;
//        [2/10/2014 10:25:42 AM] Raj Patel: For help
//            [2/10/2014 10:25:51 AM] Raj Patel: recdata path + /help/help.json
        var getter = new freesat.models.GetLocalFile();
        // Use local URL for developing HELP
//window.useLocalHelp = true;
        var fetchURL = (freesat.ipavailable && !window.useLocalHelp) ? freesat.localConfig.config.recdata_loc + '/help/help-v1-5/help.json' : 'js/freesat/data/help.json';

        getter.retrieveJSON(fetchURL,function(data) {
            if(data){
                if(data.responseJSON){
                    self.data = data.responseJSON.topics;
                }else{
                    self.data = data.topics;
                }

                var foundUsageData = false;
                accedo.Array.each(self.data, function(topic, index) {
                    if (topic.controller == 'freesat.controllers.AppMonitor') {
                        foundUsageData = true;
                    }
                });

                if (!foundUsageData) {
                    freesat.console.log('WARNING - inserting missing help for app usage');
                    self.data.push({
                        "template": "controller",
                        "title": "Your usage data",
                        "subtitle": "Opt in or out of collection",
                        "description": "To help us continue to improve the service your TV will let us know a few things about how you are using it.",
                        "gridImage": "./images/1280x720/help/png_black/icon_0005_help.png",
                        "controller": "freesat.controllers.AppMonitor"
                    });
                } else {
                    freesat.console.log('WARNING - not inserting help for app usage');
                }

                accedo.Array.each(self.data, function(topic, index){
                    if (index % 6 === 0) {
                        helpGrid = new accedo.ui.Container({
                            css: 'helpGrid',
                            focusable: true,
                            forwardFocus: true
                        });
                    }
                    freesat.console.log('topic.gridImage = '+topic.gridImage);
                    var thumb = new accedo.ui.Container({
                        css  : 'help-thumb',
                        id: '#thumb-'+index,
                        template: topic.template,
                        focusable: true,
                        children: [{
                            type: accedo.ui.widget.Image,
                            src: topic.gridImage
                        },
                            {
                                type: accedo.ui.widget.Label,
                                css: 'thumb-title',
                                text: topic.title
                            },
                            {
                                type: accedo.ui.widget.Label,
                                css: 'thumb-strapline',
                                text: topic.subtitle,
                                description: topic.description
                            }
                        ]
                    });

                    helpGrid.attach(thumb);

                    thumb.addEventListener(accedo.ui.Evt.FOCUS, function(){
                        self.get('help-title').setText(this.getChildren()[1].opts.text);
                        self.get('help-strap').setText(this.getChildren()[2].opts.description);
                        self.topicIndex = index;
                    }, thumb);

                    thumb.addEventListener(accedo.ui.Evt.KEY, function(key){
                        var selected_index;
                        if(!freesat.isAnimating){
                            if (self.pageView === 'controller'){
                                if (self.subController && self.subController.onKey(key)){
                                        return true;
                                }

                                switch(key){
                                    case accedo.VKey.KEY_LEFT:
                                        self.backToGrid();
                                        return true;
                                        break;
                                }
                            }

                            switch(key){
                                case accedo.VKey.KEY_OK:
                                case accedo.VKey.KEY_ENTER:
                                    self.switchToTopic();
                                    self.helpTopicContainer.removeClass('right').addClass('left');
                                    freesat.isAnimating = true;
                                    setTimeout(function(){
                                        freesat.isAnimating = false;
                                    },1);
                                    return true;

                                case accedo.VKey.KEY_LEFT:

                                    if (index%6 !== 0) {
                                        self.get('thumb-'+(index-1)).setFocus();
                                    } else if (index > 5) {
                                        arrowLeft.setFocus();
                                    }
                                    return true;

                                case accedo.VKey.KEY_RIGHT:

                                    selected_index = index+1;

                                    if (selected_index < self.data.length) {
                                        self.get('thumb-'+selected_index).setFocus();
                                    } else if (self.data.length > 6) {
                                        arrowRight.setFocus();
                                    }
                                    return true;

                                case accedo.VKey.KEY_KEYBOARD_PAGE_UP:
                                case accedo.VKey.KEY_UP:

                                    if ((index % 6) > 2) {
                                        self.get('thumb-'+(index-3)).setFocus();
                                    }
                                    return true;

                                case accedo.VKey.KEY_KEYBOARD_PAGE_DOWN:
                                case accedo.VKey.KEY_DOWN:

                                    if ((index % 6) < 3) {
                                        selected_index = index + 3;

                                        if (selected_index >= self.data.length) {
                                            selected_index = self.data.length - 1;
                                        }
                                        self.get('thumb-'+selected_index).setFocus();
                                    }
                                    return true;
                            }
                        }
                    }, thumb);

                    if((index+1)%6 === 0 || index == self.data.length-1){
                        self.helpGridContainer.attach(helpGrid);
                        gridNo++;
                    }
                });

                if (self.data.length <= 6) {
                    self.arrowRight.addClass('hidden');
                }

                self.helpGridContainer.getRoot()._dom.style.width = parseInt(gridNo*this.gridWidth, null)+'px';
                self.get('thumb-0').setFocus();
            }
        }, true);

    },
    createSubtopic: function(){
        var subtopic = new accedo.ui.Container({
                id: '#subtopicContainer-'+this.subtopicIndex,
                css: 'topicContainer',
                children: [
                {
                    type: accedo.ui.widget.Label,
                    css: 'paragraph',
                    text: this.data[this.topicIndex].subtopics[this.subtopicIndex].content
                }]
            });
        this.helpStrapline.setText(this.data[this.topicIndex].subtopics[this.subtopicIndex].title);
        this.helpTopicContainer.attach(subtopic);
        
        if(this.get('subtopicContainer-'+(this.subtopicIndex-1))){
            this.get('subtopicContainer-'+(this.subtopicIndex-1)).removeClass('left').addClass('leftTwice');
            freesat.isAnimating = true;
            setTimeout(function(){
                freesat.isAnimating = false;
            }, 1000);
        }
        setTimeout(function(){
            subtopic.addClass('left');
        }, 1);
     
        this.setNextPrevious();

        var container = this.get('subtopicContainer-'+this.subtopicIndex),
            frameHeight = container.getRoot()._dom.offsetHeight,
            contentHeight = container.getRoot()._dom.scrollHeight;

        if(contentHeight > frameHeight){
            this.get('pageDown').removeClass('hidden');
        }
    },

    switchToTopic: function(){
        var self = this,
            topicContainer,
            topic = this.data[this.topicIndex];

        this.pageView = 'topic';

        switch(topic.template){
            case 'text':
                if (topic.subtopics && topic.subtopics.length <= 1) {
                    this.pageView = 'subtopic';
                    this.subtopicIndex = 0;
                    this.createSubtopic();

                } else if (topic.subtopics && topic.subtopics.length > 1) {
                    this.pageView = 'faq';
                    this.createTopicsList();

                } else {
                    topicContainer = new accedo.ui.Container({
                        id: '#topicContainer-'+this.topicIndex,
                        css: 'topicContainer',
                        children: [{
                            type: accedo.ui.widget.Label,
                            text: this.data[this.topicIndex].content
                        }]
                    });

                    topicContainer.addClass('left');
                    freesat.isAnimating = true;
                    setTimeout(function(){
                        freesat.isAnimating = false;
                        self.setNextPrevious();
                    }, 1000);

                    this.helpStrapline.setText(topic.title);
                    this.helpTopicContainer.attach(topicContainer);
                }
                break;

            case 'image':
                this.helpStrapline.setText(topic.title);

                topicContainer = new accedo.ui.Container({
                    id: '#topicContainer-'+this.topicIndex,
                    css: 'topicContainer imageTopic',
                    children: [
                    {
                        type: accedo.ui.widget.Image,
                        src: topic.image
                    }]
                });

                topicContainer.addClass('left');
                freesat.isAnimating = true;
                setTimeout(function(){
                    freesat.isAnimating = false;
                    self.setNextPrevious();
                }, 1000);

                this.helpStrapline.setText(topic.title);
                this.helpTopicContainer.attach(topicContainer);
                break;

            case 'faq': // 'faq'
                this.pageView = 'faq';
                this.createTopicsList();
                break;

            case "controller":
                // Load controller in page
                this.pageView = 'controller';

                topicContainer = new accedo.ui.Container({
                    id: '#topicContainer-'+this.topicIndex,
                    css: 'topicContainer left',
                    children: [
                        {
                            controller: topic.controller
                        }]
                });


                freesat.isAnimating = true;
                setTimeout(function(){
                    freesat.isAnimating = false;
                    // Have to call each method separately
                    self.arrowLeft.setText('help');
                    self.arrowLeft.removeClass('hidden');
                    self.arrowLeft.activateFocus();
                }, 1000);

                this.helpStrapline.setText(topic.title);
                this.helpTopicContainer.attach(topicContainer);

                this.changeController(topic.controller, topicContainer);



                break;
        }
    },

    createTopicsList: function() {
        var self = this,
            topicContainer,
            topic = this.data[this.topicIndex];

        this.subtopicIndex = 0;
        topicContainer = new accedo.ui.Container({
            id: '#topicContainer-'+this.topicIndex,
            css: 'topicContainer question-list'
        });

        accedo.Array.each(this.data[this.topicIndex].subtopics, function(q, i){
            var question = new accedo.ui.Container({
                id: 'question-'+i,
                css: 'question',
                focusable: true,
//                nextDown: (i<self.data[self.topicIndex].subtopics.length-1) ? 'question-'+(i+1) : null,
//                nextUp: (i>0) ? 'question-'+(i-1) : null,

                children:[{
                    type: accedo.ui.widget.Label,
                    css: 'qtitle',
                    text: q.title
                }]
            });

            question.addEventListener(accedo.ui.Evt.KEY, function(key){
                switch(key){
                    case accedo.VKey.KEY_OK:
                    case accedo.VKey.KEY_ENTER:
                        self.subtopicIndex = i;
                        self.questionsContainer.removeClass('right').addClass('left');
                        self.createQuestionView(false);
                        break;

                    case accedo.VKey.KEY_LEFT:
                        self.backToGrid();
                        break;

                    case accedo.VKey.KEY_KEYBOARD_PAGE_UP:
                    case accedo.VKey.KEY_UP:
                        if (i > 0) {
                            self.get('question-'+(i-1)).setFocus();
                        }
                        break;

                    case accedo.VKey.KEY_KEYBOARD_PAGE_DOWN:
                    case accedo.VKey.KEY_DOWN:
                        if (i < self.data[self.topicIndex].subtopics.length-1) {
                            self.get('question-'+(i+1)).setFocus();
                        }
                        break;
                }
            }, question);
            topicContainer.attach(question);
        });

        topicContainer.addClass('left');
        freesat.isAnimating = true;
        setTimeout(function(){
            freesat.isAnimating = false;
            // Have to call each method separately
            self.arrowLeft.setText('help');
            self.arrowLeft.removeClass('hidden');
            self.arrowLeft.activateFocus();
        }, 1000);

        this.helpStrapline.setText(topic.title);
        this.helpTopicContainer.attach(topicContainer);

        topicContainer.getChildren()[0].setFocus();


    },

    createQuestionView: function(previous){
        var self = this,
            question = this.data[this.topicIndex].subtopics[this.subtopicIndex];

        var questionContainer = new accedo.ui.Container({
            id: '#questionContainer-'+this.subtopicIndex,
            css: 'questionContainer'+((previous)? ' leftTwice':''),
            children: [{
                type: accedo.ui.widget.Label,
                text: question.content
            }]
        });

        this.questionsContainer.attach(questionContainer);
        if (this.subtopicIndex > 0) {
            if (this.get('questionContainer-'+(this.subtopicIndex-1))) {
                this.get('questionContainer-'+(this.subtopicIndex-1)).removeClass('left').addClass('leftTwice');
            
                freesat.isAnimating = true;
                setTimeout(function(){
                    freesat.isAnimating = false;
                }, 1000);
            }
            setTimeout(function(){
                if (previous) {
                    questionContainer.removeClass('leftTwice').addClass('left');
                } else {
                    questionContainer.addClass('left').removeClass('leftTwice');
                }
                freesat.isAnimating = true;
                setTimeout(function(){
                    freesat.isAnimating = false;
                }, 1000);
            }, 1);
        } else {
            questionContainer.removeClass('leftTwice').addClass('left');
        }
        
        this.setNextPrevious();
        this.helpStrapline.setText(question.title);
    },

    changeController: function(id, container) {

        accedo.ui.ControllerManager.singleton().openController(id, container, this,
            {   noHistory: true }
        );

        this.subController =  accedo.ui.ControllerManager.singleton().getController(id);

    },

    getElements: function(){
        this.helpStrapline = this.get('helpStrapline');
        this.helpGridMask = this.get('helpGridMask');
        this.helpGridContainer = this.get('helpGridContainer');
        this.helpTopicContainer = this.get('helpTopicContainer');
        this.questionsContainer = this.get('questionsContainer');
        this.arrowRight = this.get('arrowRightContainer');
        this.arrowLeft = this.get('arrowLeftContainer');
    },

    setNextPrevious: function(){
        switch(this.pageView){
            case 'grid':
                this.arrowRight.setText('more');
                this.arrowLeft.addClass('hidden');

                if(this.data.length <= 6) {
                    this.arrowRight.addClass('hidden');
                } else {
                    if(this.topicIndex >= 6){
                        this.arrowRight.addClass('hidden');
                        this.arrowLeft.removeClass('hidden');
                    }
                    else{
                        this.arrowLeft.addClass('hidden');
                        this.arrowRight.removeClass('hidden');
                    }
                }
                break;

            case 'topic':
            case 'controller':
                this.arrowLeft.removeClass('prev').removeClass('hidden').setText('help');
                this.arrowLeft.setFocus();
                this.arrowRight.addClass('hidden');
                break;

            case 'subtopic':
                this.arrowLeft.removeClass('hidden').setText('help');
                if (this.subtopicIndex < this.data[this.topicIndex].subtopics.length - 1) {
                    this.arrowRight.removeClass('hidden').setText('next');
                    this.arrowRight.setFocus();
                } else {
                    this.arrowRight.addClass('hidden');
                    this.arrowLeft.setFocus();
                }
                if (this.subtopicIndex > 0) {
                    this.arrowLeft.removeClass('hidden').addClass('prev').setText('previous');
                } else {
                    this.arrowLeft.removeClass('prev').setText('help');
                }
                break;

            case 'faq':

                if(this.subtopicIndex >= 0){

                    if(this.subtopicIndex < this.data[this.topicIndex].subtopics.length-1){
                        this.arrowRight.removeClass('hidden').setText('next');
                        this.arrowRight.setFocus();
                        this.arrowLeft.activateFocus();
                    } else {
                        this.arrowRight.addClass('hidden').setText('more');
                        this.arrowLeft.setFocus();
                        this.arrowRight.activateFocus();

                    }

                    if(this.subtopicIndex > 0){
                        this.arrowLeft.addClass('prev').setText('previous');
                    } else {
                        this.arrowLeft.removeClass('prev').setText('FAQs');
                    }
                } else {
                    this.arrowRight.addClass('hidden').setText('more');
                    this.arrowLeft.removeClass('prev').setText('help');
                }
                break;
        }
    },

    clickOnArrowLeft: function(){
        var self = this;

        switch(this.pageView){
            case 'grid':
                this.helpGridContainer.removeClass('left').addClass('toFront');
                freesat.isAnimating = true;

                setTimeout(function(){
                    freesat.isAnimating = false;
                    self.get('thumb-'+self.topicIndex).setFocus();
                    self.helpGridContainer.getRoot()._dom.className = "helpGridContainer" ;
                },1000);

                this.topicIndex = 0;
                this.setNextPrevious();
                break;

            case 'topic':
            case "controller":
                this.backToGrid();

                break;

            case 'subtopic':
                if(this.arrowLeft._labelText == 'previous'){
                    if(this.subtopicIndex > 0){
                        this.get('subtopicContainer-'+this.subtopicIndex).removeClass('left').addClass('right');
                        this.get('subtopicContainer-'+(this.subtopicIndex-1)).removeClass('leftTwice').addClass('left');
                        freesat.isAnimating = true;
                        self.subtopicIndex--;
                        this.setNextPrevious();
                        setTimeout(function(){
                            freesat.isAnimating = false;
                            self.get('subtopicContainer-'+(self.subtopicIndex+1)).detach();
                            self.helpStrapline.setText(self.data[self.topicIndex].subtopics[self.subtopicIndex].title);
                        }, 1000);
                    }
                } else {
                    this.backToGrid();
                }
                break;

            case 'faq':

                if(this.arrowLeft._labelText === 'help'){
                    this.backToGrid();
                } else if (this.arrowLeft._labelText == 'previous') {
                    this.get('questionContainer-'+this.subtopicIndex).addClass('right');
                    
                    this.subtopicIndex--;
                    if(this.get('questionContainer-'+this.subtopicIndex)) {
                        this.get('questionContainer-'+this.subtopicIndex).removeClass('leftTwice').addClass('left');
                    } else {
                        this.createQuestionView(true);
                    }
                    freesat.isAnimating = true;
                    setTimeout(function(){
                        freesat.isAnimating = false;
                        self.get('questionContainer-'+(self.subtopicIndex+1)).detach();
                    }, 1000);
                    this.helpStrapline.setText(this.data[this.topicIndex].subtopics[this.subtopicIndex].title);
                    this.setNextPrevious();

                    if(this.subtopicIndex === 0){
                        this.arrowLeft.removeClass('prev').setText('FAQs');
//                        this.arrowRight.activateFocus();
                    }
                } else if (this.arrowLeft._labelText == 'FAQs') {
                    this.get('questionsContainer').removeClass('left').addClass('right');
                    freesat.isAnimating = true;
                    setTimeout(function(){
                        freesat.isAnimating = false;
                        self.arrowLeft.setText('help');
                        self.arrowRight.addClass('hidden');
                        self.helpStrapline.setText(self.data[self.topicIndex].title);
                        self.get('topicContainer-'+self.topicIndex).getChildren()[self.subtopicIndex].setFocus();
                        self.subtopicIndex = null;
                        self.questionsContainer.removeAll();
                        self.arrowLeft.activateFocus();
                    }, 1000);
                }
                break;
        }
    },

    clickOnArrowRight: function(){
        var self = this;

        switch(this.pageView){
            case 'grid':
                this.helpGridContainer.addClass('left');
                freesat.isAnimating = true;
                this.topicIndex = 6;
                this.setNextPrevious();

                setTimeout(function(){
                    freesat.isAnimating = false;
                    self.get('thumb-'+self.topicIndex).setFocus();
                },1000);
                break;

            case 'subtopic':
                if(this.subtopicIndex+1 < this.data[this.topicIndex].subtopics.length){
                    this.subtopicIndex++;
                    this.createSubtopic();
                } else {
                    this.arrowLeft.setFocus();
                    this.arrowRight.addClass('hidden');
                }

                if(this.subtopicIndex > 0){
                    this.arrowLeft.removeClass('hidden');
                }
                break;

            case 'faq':
                if(this.subtopicIndex >= 0 && this.subtopicIndex < this.data[this.topicIndex].subtopics.length - 1){
                    this.subtopicIndex++;
                    self.createQuestionView(false);
                }
                break;
        }
    },

    backToGrid: function(){
        var self = this;

        this.helpTopicContainer.removeClass('left').addClass('right');
        freesat.isAnimating = true;
        this.pageView = 'grid';
        this.helpStrapline.setText(this.lang.STRAPLINE);
        this.setNextPrevious();

        setTimeout(function(){
            freesat.isAnimating = false;
            self.helpTopicContainer.removeAll();
            self.get('thumb-'+self.topicIndex).setFocus();
            self.subtopicIndex = null;
        }, 1000);
    },

    scrollUp: function(){
        switch(this.pageView){
            case 'subtopic':
                var container = this.get('subtopicContainer-'+this.subtopicIndex),
                    frameHeight = container.getRoot()._dom.offsetHeight,
                    contentHeight = container.getRoot()._dom.scrollHeight;

                if (contentHeight > frameHeight && container.getRoot()._dom.offsetTop < 0) {
                    this.moveUpDown(0, container.getId());
                    this.get('pageUp').addClass('hidden');
                    this.get('pageDown').removeClass('hidden');
                }
                break;
        }

    },

    scrollDown: function(){
        switch(this.pageView){
            case 'subtopic':
                var container = this.get('subtopicContainer-'+this.subtopicIndex),
                    frameHeight = container.getRoot()._dom.offsetHeight,
                    contentHeight = container.getRoot()._dom.scrollHeight;

                if (contentHeight > frameHeight) {
                    this.moveUpDown(-(frameHeight - 47), container.getId());
                    this.get('pageDown').addClass('hidden');
                    this.get('pageUp').removeClass('hidden');
                }
                break;
        }

    },

    moveUpDown : function(top, container){
        this.get(container).root.setStyle({
            'top': String(top) + 'px'
        });
    },

    onKey: function(vKey) {
        var self = this;
        freesat.console.log('[help Controller] onKey ' + vKey);

        /**
         * Pass the key to the focused child for handling first.
         * Sometime the current focus is on the main controller(parent), then the child controller will not handle the key.
         * However in most of the cases it is intended to be handled by child controller.
         */
        //            if( freesat.masterController.childContainer.getChildren()[freesat.masterController.currentFocus].onKey(vKey) ){
        //                return true;
        //            }


        if(!freesat.isAnimating){
            switch (vKey) {
                case accedo.VKey.KEY_BACK:
                    switch(this.pageView){
                        case 'grid':
                            return false;
                        case 'topic':
                        case 'subtopic':
                        case 'controller':
                            this.backToGrid();
                            break;
                        case 'faq':
                            if (self.arrowLeft._labelText != 'help') {
                                this.get('questionsContainer').removeClass('left').addClass('right');
                                freesat.isAnimating = true;
                                setTimeout(function(){
                                    freesat.isAnimating = false;
                                    self.arrowLeft.removeClass('prev').setText('help');
                                    self.helpStrapline.setText(self.data[self.topicIndex].title);
                                    self.get('topicContainer-'+self.topicIndex).getChildren()[self.subtopicIndex].setFocus();
                                    self.arrowLeft.activateFocus();
                                    self.arrowRight.addClass('hidden');
                                    self.subtopicIndex = null;
                                    self.questionsContainer.removeAll();
                                }, 1000);
                            } else {
                                this.backToGrid();
                            }
                            break;
                    }
                    return true;
                case accedo.VKey.KEY_INFO:
                    if (freesat.masterController.currentFocus === 1) {
                        freesat.masterController.showInfo = true;
                        freesat.masterController.instanciateZapper();
                        return true;
                    }
                    return false;
                case accedo.VKey.KEY_RED:

                    if (freesat.masterController.currentFocus === 0) {
                        freesat.masterController.instanciateHomeMenu();
                    }
                    return true;

                case accedo.VKey.KEY_KEYBOARD_PAGE_UP:
                case accedo.VKey.KEY_UP:
                    this.scrollUp();
                    return true;
                case accedo.VKey.KEY_KEYBOARD_PAGE_DOWN:
                case accedo.VKey.KEY_DOWN:
                    this.scrollDown();
                    return true;
            }
        } else {
            return false;
        }
    }
});
