/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/. */

/* Copyright (c) 2014 - 2015 Panasonic Corporation */

/* This Source Code Form is "Incompatible With Secondary Licenses",
 * as defined by the Mozilla Public License, v. 2.0. */

"use strict";

const Cc = Components.classes;
const Ci = Components.interfaces;
const Cu = Components.utils;
const Cr = Components.results;

Cu.import("resource://gre/modules/XPCOMUtils.jsm");
Cu.import("resource://gre/modules/Services.jsm");

function PushServiceLauncher() {
};

PushServiceLauncher.prototype = {
  classID: Components.ID("{4b8caa3b-3c58-4f3c-a7f5-7bd9cb24c11d}"),

  contractID: "@mozilla.org/push/ServiceLauncher;1",

  QueryInterface: XPCOMUtils.generateQI([Ci.nsIObserver,
                                         Ci.nsISupportsWeakReference]),

  observe: function observe(subject, topic, data) {
    switch (topic) {
      case "app-startup":
        Services.obs.addObserver(this, "final-ui-startup", true);
        break;
      case "final-ui-startup":
        Services.obs.removeObserver(this, "final-ui-startup");
        if (!Services.prefs.getBoolPref("services.push.enabled")) {
          return;
        }
//@line 42 "/home/builder/auto-build/GBL16MT5595/work.04111431_v3232/newarch/usr/src/b2g/b2g/gecko/dom/push/PushServiceLauncher.js"
      Cu.import("resource://gre/modules/PanaPushService.jsm");
//@line 46 "/home/builder/auto-build/GBL16MT5595/work.04111431_v3232/newarch/usr/src/b2g/b2g/gecko/dom/push/PushServiceLauncher.js"
        PushService.init();
        break;
    }
  }
};

this.NSGetFactory = XPCOMUtils.generateNSGetFactory([PushServiceLauncher]);
