/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/. */

"use strict";

const DEBUG = false;
function debug(s) {
  if (DEBUG) dump("-*- PanaSystem: " + s + "\n");
}

const Cc = Components.classes;
const Ci = Components.interfaces;
const Cu = Components.utils;

Cu.import("resource://gre/modules/XPCOMUtils.jsm");

function PanaSystemManager() {
  this.wrappedJSObject = this;
}

PanaSystemManager.prototype = {
  _wrap: function _wrap(obj) {
    return Cu.cloneInto(obj, this._window);
  },

  init: function(aWindow) {
    debug('init ()');
    this._window = aWindow;
  },

  get modeldata() {
    if (!this._modeldata) {
      let modeldata = Cc["@mozilla.org/modelData;1"]
                        .createInstance(Ci.nsISupports);
      modeldata.wrappedJSObject.init(this._window);
      this._modeldata = this._window.DOMModelData._create(this._window, modeldata.wrappedJSObject);
    }
    return this._modeldata;
  },

  get serverUrl() {
    if (!this._serverUrl) {
      let serverUrl = Cc["@mozilla.org/pana-server-url;1"]
                        .createInstance(Ci.nsISupports);
      serverUrl.wrappedJSObject.init(this._window);
      this._serverUrl = this._window.DOMServerUrl._create(this._window, serverUrl.wrappedJSObject);
    }
    return this._serverUrl;
  },

  get tvstore() {
    if (!this._tvstore) {
      let tvstore = Cc["@mozilla.org/tvstoremanager2;1"]
                      .createInstance(Ci.nsISupports);
      tvstore.wrappedJSObject.init(this._window);
      this._tvstore = this._window.DOMTVStore._create(this._window, tvstore.wrappedJSObject);
    }
    return this._tvstore;
  },

  classID: Components.ID("{229b7b87-e70c-4194-9c8d-54c4c691fb90}"),
  contractID: "@mozilla.org/panaSystem;1",
  QueryInterface: XPCOMUtils.generateQI([
    Ci.nsISupports,
    Ci.nsIDOMGlobalPropertyInitializer
  ])
};

this.NSGetFactory = XPCOMUtils.generateNSGetFactory([PanaSystemManager])
