/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/. */

"use strict";

const Cc = Components.classes;
const Ci = Components.interfaces;
const Cu = Components.utils;

Cu.import("resource://gre/modules/Services.jsm");
Cu.import("resource://gre/modules/XPCOMUtils.jsm");

XPCOMUtils.defineLazyModuleGetter(this, "PanaServerUrlInternal",
  "resource://gre/modules/PanaServerUrl.jsm");

function PanaServerUrl() {
  this._serverURL = null;
  this._latestURL = null;
  this._mhcXpanaHttps = null;
  this._mhcSecHttp = null;
  this._mhcSecHttps = null;
  this.wrappedJSObject = this;
}

PanaServerUrl.prototype = {
  __exposedProps__: {
    serverURL: 'r',
  },

  _hasPrivileges: null,

  _wrap: function _wrap(obj) {
    return Cu.cloneInto(obj, this._window);
  },

  init: function(aWindow) {
    this._window = aWindow;

    let util = aWindow.QueryInterface(
      Ci.nsIInterfaceRequestor
    ).getInterface(Ci.nsIDOMWindowUtils);

    // initialize of serverURL
    this._serverURL = PanaServerUrlInternal.serverURL;
    this._latestURL = PanaServerUrlInternal.latestURL;
    this._mhcXpanaHttps = PanaServerUrlInternal.mhcXpanaHttps;
    this._mhcSecHttp = PanaServerUrlInternal.mhcSecHttp;
    this._mhcSecHttps = PanaServerUrlInternal.mhcSecHttps;
  },

  get serverURL() {
    return this._wrap(this._serverURL);
  },

  get latestURL() {
    return this._wrap(this._latestURL);
  },

  get mhcXpanaHttps() {
    return this._wrap(this._mhcXpanaHttps);
  },

  get mhcSecHttp() {
    return this._wrap(this._mhcSecHttp);
  },

  get mhcSecHttps() {
    return this._wrap(this._mhcSecHttps);
  },

  classID: Components.ID("{a8cf408a-1783-11e4-bc5f-00224d7a7d73}"),
  contractID: "@mozilla.org/pana-server-url;1",
  QueryInterface: XPCOMUtils.generateQI([
    Ci.nsISupports,
    Ci.nsIDOMGlobalPropertyInitializer
  ])
};

this.NSGetFactory = XPCOMUtils.generateNSGetFactory([PanaServerUrl]);
