/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/. */

"use strict";

const DEBUG = false;
function debug(s) {
  if (DEBUG) dump("-*- ModelData: " + s + "\n");
}

const Cc = Components.classes;
const Ci = Components.interfaces;
const Cu = Components.utils;

const MODELDATA_FILE_PATH = "/tmp/modeldata.json";

Cu.import("resource://gre/modules/XPCOMUtils.jsm");
XPCOMUtils.defineLazyModuleGetter(this, "ModelDataInternal",
  "resource://gre/modules/ModelData.jsm");

function ModelData() {
  this.wrappedJSObject = this;
  this._modeldata = null;
}

ModelData.prototype = {
  _wrap: function _wrap(obj) {
    return Cu.cloneInto(obj, this._window);
  },

  init: function(aWindow) {
    debug('init ()');
    this._window = aWindow;
  },

  get data() {
    debug('get data');
    return this._wrap(ModelDataInternal.data);
  },

  get: function get(aName) {
    debug("get - name:" + aName);
    return ModelDataInternal.get(aName);
  },

  classID: Components.ID("{0d5f637b-a411-4264-9098-af93956c08eb}"),
  QueryInterface: XPCOMUtils.generateQI([Ci.nsIModelData])
};

this.NSGetFactory = XPCOMUtils.generateNSGetFactory([ModelData])
